
#line 1 "hb-ot-shape-complex-indic-machine.rl"
/*
 * Copyright © 2011,2012  Google, Inc.
 *
 *  This is part of HarfBuzz, a text shaping library.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE COPYRIGHT HOLDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * THE COPYRIGHT HOLDER SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE COPYRIGHT HOLDER HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * Google Author(s): Behdad Esfahbod
 */

#ifndef HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH
#define HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH

#include "hb-private.hh"


#line 36 "hb-ot-shape-complex-indic-machine.hh"
static const unsigned char _indic_syllable_machine_trans_keys[] = {
	8u, 8u, 1u, 16u, 8u, 13u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 
	7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 4u, 8u, 
	6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 
	4u, 8u, 6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 8u, 8u, 1u, 16u, 8u, 13u, 
	5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 
	7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 
	6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 8u, 8u, 1u, 16u, 8u, 13u, 5u, 8u, 5u, 7u, 7u, 7u, 
	5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 
	7u, 7u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 
	6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 8u, 8u, 1u, 16u, 
	8u, 13u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 
	5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 4u, 8u, 6u, 6u, 16u, 16u, 
	4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 
	16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 5u, 8u, 4u, 14u, 4u, 14u, 5u, 8u, 
	5u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 
	5u, 7u, 7u, 7u, 8u, 8u, 1u, 16u, 8u, 13u, 4u, 8u, 6u, 6u, 16u, 16u, 
	4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 
	16u, 16u, 8u, 8u, 1u, 31u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 
	3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 
	3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 4u, 31u, 5u, 14u, 5u, 14u, 
	5u, 10u, 9u, 10u, 9u, 9u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 13u, 
	3u, 10u, 5u, 10u, 3u, 10u, 3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 
	3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 
	5u, 14u, 3u, 14u, 1u, 16u, 4u, 31u, 4u, 14u, 3u, 31u, 3u, 31u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 3u, 31u, 3u, 31u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 
	3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 
	3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 4u, 31u, 5u, 14u, 5u, 14u, 
	5u, 10u, 9u, 10u, 9u, 9u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 13u, 
	3u, 10u, 5u, 10u, 3u, 10u, 3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 
	3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 
	5u, 14u, 3u, 14u, 1u, 16u, 4u, 31u, 4u, 14u, 3u, 31u, 3u, 31u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	4u, 14u, 1u, 16u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 
	4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 
	4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 4u, 31u, 5u, 14u, 5u, 14u, 5u, 10u, 
	9u, 10u, 9u, 9u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 13u, 3u, 10u, 
	5u, 10u, 3u, 10u, 3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 
	4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 
	3u, 14u, 1u, 16u, 4u, 31u, 4u, 14u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	4u, 14u, 3u, 31u, 4u, 14u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 
	3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 
	3u, 31u, 4u, 31u, 1u, 16u, 3u, 31u, 3u, 31u, 4u, 31u, 5u, 14u, 5u, 14u, 
	5u, 10u, 9u, 10u, 9u, 9u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 13u, 
	3u, 10u, 5u, 10u, 3u, 10u, 3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 
	3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 
	5u, 14u, 3u, 14u, 1u, 16u, 4u, 31u, 4u, 14u, 3u, 31u, 3u, 31u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 31u, 3u, 31u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 3u, 31u, 1u, 31u, 3u, 31u, 1u, 31u, 4u, 14u, 5u, 10u, 9u, 10u, 
	9u, 9u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 1u, 16u, 3u, 31u, 3u, 31u, 
	4u, 31u, 3u, 31u, 3u, 31u, 1u, 16u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 
	4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 
	3u, 13u, 3u, 10u, 5u, 10u, 3u, 10u, 3u, 13u, 1u, 16u, 3u, 10u, 5u, 10u, 
	5u, 10u, 9u, 10u, 9u, 9u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 0
};

static const char _indic_syllable_machine_key_spans[] = {
	1, 16, 6, 4, 3, 1, 4, 3, 
	1, 4, 3, 1, 4, 3, 1, 5, 
	1, 1, 5, 1, 1, 5, 1, 1, 
	5, 1, 1, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 1, 16, 6, 
	4, 3, 1, 4, 3, 1, 4, 3, 
	1, 4, 3, 1, 5, 1, 1, 5, 
	1, 1, 5, 1, 1, 5, 1, 1, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 1, 16, 6, 4, 3, 1, 
	4, 3, 1, 4, 3, 1, 4, 3, 
	1, 5, 1, 1, 5, 1, 1, 5, 
	1, 1, 5, 1, 1, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 1, 16, 
	6, 4, 3, 1, 4, 3, 1, 4, 
	3, 1, 4, 3, 1, 5, 1, 1, 
	5, 1, 1, 5, 1, 1, 5, 1, 
	1, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 4, 11, 11, 4, 
	3, 4, 3, 1, 4, 3, 1, 4, 
	3, 1, 1, 16, 6, 5, 1, 1, 
	5, 1, 1, 5, 1, 1, 5, 1, 
	1, 1, 31, 29, 29, 28, 16, 29, 
	29, 28, 16, 29, 29, 28, 16, 29, 
	29, 28, 16, 29, 29, 28, 10, 10, 
	6, 2, 1, 2, 2, 1, 6, 11, 
	8, 6, 8, 11, 12, 12, 11, 10, 
	12, 11, 10, 12, 11, 10, 12, 11, 
	10, 12, 16, 28, 11, 29, 29, 16, 
	16, 16, 16, 16, 29, 29, 16, 16, 
	16, 16, 16, 29, 29, 16, 16, 16, 
	16, 16, 29, 29, 16, 16, 16, 16, 
	16, 29, 29, 29, 29, 28, 16, 29, 
	29, 28, 16, 29, 29, 28, 16, 29, 
	29, 28, 16, 29, 29, 28, 10, 10, 
	6, 2, 1, 2, 2, 1, 6, 11, 
	8, 6, 8, 11, 12, 12, 11, 10, 
	12, 11, 10, 12, 11, 10, 12, 11, 
	10, 12, 16, 28, 11, 29, 29, 16, 
	16, 16, 16, 16, 29, 29, 16, 16, 
	16, 16, 16, 29, 29, 16, 16, 16, 
	16, 16, 29, 29, 16, 16, 16, 16, 
	11, 16, 29, 29, 28, 16, 29, 29, 
	28, 16, 29, 29, 28, 16, 29, 29, 
	28, 16, 29, 29, 28, 10, 10, 6, 
	2, 1, 2, 2, 1, 6, 11, 8, 
	6, 8, 11, 12, 12, 11, 10, 12, 
	11, 10, 12, 11, 10, 12, 11, 10, 
	12, 16, 28, 11, 29, 29, 16, 16, 
	16, 16, 16, 29, 29, 16, 16, 16, 
	16, 16, 29, 29, 16, 16, 16, 16, 
	16, 29, 29, 16, 16, 16, 16, 16, 
	11, 29, 11, 29, 29, 28, 16, 29, 
	29, 28, 16, 29, 29, 28, 16, 29, 
	29, 28, 16, 29, 29, 28, 10, 10, 
	6, 2, 1, 2, 2, 1, 6, 11, 
	8, 6, 8, 11, 12, 12, 11, 10, 
	12, 11, 10, 12, 11, 10, 12, 11, 
	10, 12, 16, 28, 11, 29, 29, 16, 
	16, 16, 16, 16, 29, 29, 16, 16, 
	16, 16, 16, 29, 29, 16, 16, 16, 
	16, 16, 29, 29, 16, 16, 16, 16, 
	16, 29, 31, 29, 31, 11, 6, 2, 
	1, 2, 2, 1, 6, 16, 29, 29, 
	28, 29, 29, 16, 12, 11, 10, 12, 
	11, 10, 12, 11, 10, 12, 11, 10, 
	11, 8, 6, 8, 11, 16, 8, 6, 
	6, 2, 1, 2, 2, 1, 6
};

static const short _indic_syllable_machine_index_offsets[] = {
	0, 2, 19, 26, 31, 35, 37, 42, 
	46, 48, 53, 57, 59, 64, 68, 70, 
	76, 78, 80, 86, 88, 90, 96, 98, 
	100, 106, 108, 110, 122, 134, 146, 158, 
	170, 182, 194, 206, 218, 230, 232, 249, 
	256, 261, 265, 267, 272, 276, 278, 283, 
	287, 289, 294, 298, 300, 306, 308, 310, 
	316, 318, 320, 326, 328, 330, 336, 338, 
	340, 352, 364, 376, 388, 400, 412, 424, 
	436, 448, 460, 462, 479, 486, 491, 495, 
	497, 502, 506, 508, 513, 517, 519, 524, 
	528, 530, 536, 538, 540, 546, 548, 550, 
	556, 558, 560, 566, 568, 570, 582, 594, 
	606, 618, 630, 642, 654, 666, 678, 680, 
	697, 704, 709, 713, 715, 720, 724, 726, 
	731, 735, 737, 742, 746, 748, 754, 756, 
	758, 764, 766, 768, 774, 776, 778, 784, 
	786, 788, 800, 812, 824, 836, 848, 860, 
	872, 884, 896, 908, 920, 925, 937, 949, 
	954, 958, 963, 967, 969, 974, 978, 980, 
	985, 989, 991, 993, 1010, 1017, 1023, 1025, 
	1027, 1033, 1035, 1037, 1043, 1045, 1047, 1053, 
	1055, 1057, 1059, 1091, 1121, 1151, 1180, 1197, 
	1227, 1257, 1286, 1303, 1333, 1363, 1392, 1409, 
	1439, 1469, 1498, 1515, 1545, 1575, 1604, 1615, 
	1626, 1633, 1636, 1638, 1641, 1644, 1646, 1653, 
	1665, 1674, 1681, 1690, 1702, 1715, 1728, 1740, 
	1751, 1764, 1776, 1787, 1800, 1812, 1823, 1836, 
	1848, 1859, 1872, 1889, 1918, 1930, 1960, 1990, 
	2007, 2024, 2041, 2058, 2075, 2105, 2135, 2152, 
	2169, 2186, 2203, 2220, 2250, 2280, 2297, 2314, 
	2331, 2348, 2365, 2395, 2425, 2442, 2459, 2476, 
	2493, 2510, 2540, 2570, 2600, 2630, 2659, 2676, 
	2706, 2736, 2765, 2782, 2812, 2842, 2871, 2888, 
	2918, 2948, 2977, 2994, 3024, 3054, 3083, 3094, 
	3105, 3112, 3115, 3117, 3120, 3123, 3125, 3132, 
	3144, 3153, 3160, 3169, 3181, 3194, 3207, 3219, 
	3230, 3243, 3255, 3266, 3279, 3291, 3302, 3315, 
	3327, 3338, 3351, 3368, 3397, 3409, 3439, 3469, 
	3486, 3503, 3520, 3537, 3554, 3584, 3614, 3631, 
	3648, 3665, 3682, 3699, 3729, 3759, 3776, 3793, 
	3810, 3827, 3844, 3874, 3904, 3921, 3938, 3955, 
	3972, 3984, 4001, 4031, 4061, 4090, 4107, 4137, 
	4167, 4196, 4213, 4243, 4273, 4302, 4319, 4349, 
	4379, 4408, 4425, 4455, 4485, 4514, 4525, 4536, 
	4543, 4546, 4548, 4551, 4554, 4556, 4563, 4575, 
	4584, 4591, 4600, 4612, 4625, 4638, 4650, 4661, 
	4674, 4686, 4697, 4710, 4722, 4733, 4746, 4758, 
	4769, 4782, 4799, 4828, 4840, 4870, 4900, 4917, 
	4934, 4951, 4968, 4985, 5015, 5045, 5062, 5079, 
	5096, 5113, 5130, 5160, 5190, 5207, 5224, 5241, 
	5258, 5275, 5305, 5335, 5352, 5369, 5386, 5403, 
	5420, 5432, 5462, 5474, 5504, 5534, 5563, 5580, 
	5610, 5640, 5669, 5686, 5716, 5746, 5775, 5792, 
	5822, 5852, 5881, 5898, 5928, 5958, 5987, 5998, 
	6009, 6016, 6019, 6021, 6024, 6027, 6029, 6036, 
	6048, 6057, 6064, 6073, 6085, 6098, 6111, 6123, 
	6134, 6147, 6159, 6170, 6183, 6195, 6206, 6219, 
	6231, 6242, 6255, 6272, 6301, 6313, 6343, 6373, 
	6390, 6407, 6424, 6441, 6458, 6488, 6518, 6535, 
	6552, 6569, 6586, 6603, 6633, 6663, 6680, 6697, 
	6714, 6731, 6748, 6778, 6808, 6825, 6842, 6859, 
	6876, 6893, 6923, 6955, 6985, 7017, 7029, 7036, 
	7039, 7041, 7044, 7047, 7049, 7056, 7073, 7103, 
	7133, 7162, 7192, 7222, 7239, 7252, 7264, 7275, 
	7288, 7300, 7311, 7324, 7336, 7347, 7360, 7372, 
	7383, 7395, 7404, 7411, 7420, 7432, 7449, 7458, 
	7465, 7472, 7475, 7477, 7480, 7483, 7485
};

static const short _indic_syllable_machine_indicies[] = {
	1, 0, 2, 3, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 2, 0, 1, 0, 0, 0, 0, 
	4, 0, 5, 5, 6, 1, 0, 7, 
	7, 6, 0, 6, 0, 8, 8, 9, 
	1, 0, 10, 10, 9, 0, 9, 0, 
	11, 11, 12, 1, 0, 13, 13, 12, 
	0, 12, 0, 14, 14, 15, 1, 0, 
	16, 16, 15, 0, 15, 0, 17, 0, 
	0, 0, 1, 0, 18, 0, 19, 0, 
	20, 14, 14, 15, 1, 0, 21, 0, 
	22, 0, 23, 11, 11, 12, 1, 0, 
	24, 0, 25, 0, 26, 8, 8, 9, 
	1, 0, 27, 0, 28, 0, 29, 5, 
	5, 6, 1, 0, 0, 0, 0, 0, 
	29, 0, 29, 5, 5, 6, 1, 0, 
	0, 0, 0, 30, 29, 0, 31, 5, 
	5, 6, 1, 0, 0, 0, 0, 0, 
	31, 0, 31, 5, 5, 6, 1, 0, 
	0, 0, 0, 32, 31, 0, 33, 5, 
	5, 6, 1, 0, 0, 0, 0, 0, 
	33, 0, 33, 5, 5, 6, 1, 0, 
	0, 0, 0, 34, 33, 0, 35, 5, 
	5, 6, 1, 0, 0, 0, 0, 0, 
	35, 0, 35, 5, 5, 6, 1, 0, 
	0, 0, 0, 36, 35, 0, 37, 5, 
	5, 6, 1, 0, 0, 0, 0, 0, 
	37, 0, 37, 5, 5, 6, 1, 0, 
	0, 0, 0, 38, 37, 0, 40, 39, 
	41, 42, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 41, 
	39, 40, 39, 39, 39, 39, 43, 39, 
	44, 44, 45, 40, 39, 46, 46, 45, 
	39, 45, 39, 47, 47, 48, 40, 39, 
	49, 49, 48, 39, 48, 39, 50, 50, 
	51, 40, 39, 52, 52, 51, 39, 51, 
	39, 53, 53, 54, 40, 39, 55, 55, 
	54, 39, 54, 39, 56, 39, 39, 39, 
	40, 39, 57, 39, 58, 39, 59, 53, 
	53, 54, 40, 39, 60, 39, 61, 39, 
	62, 50, 50, 51, 40, 39, 63, 39, 
	64, 39, 65, 47, 47, 48, 40, 39, 
	66, 39, 67, 39, 68, 44, 44, 45, 
	40, 39, 39, 39, 39, 39, 68, 39, 
	68, 44, 44, 45, 40, 39, 39, 39, 
	39, 69, 68, 39, 70, 44, 44, 45, 
	40, 39, 39, 39, 39, 39, 70, 39, 
	70, 44, 44, 45, 40, 39, 39, 39, 
	39, 71, 70, 39, 72, 44, 44, 45, 
	40, 39, 39, 39, 39, 39, 72, 39, 
	72, 44, 44, 45, 40, 39, 39, 39, 
	39, 73, 72, 39, 74, 44, 44, 45, 
	40, 39, 39, 39, 39, 39, 74, 39, 
	74, 44, 44, 45, 40, 39, 39, 39, 
	39, 75, 74, 39, 76, 44, 44, 45, 
	40, 39, 39, 39, 39, 39, 76, 39, 
	76, 44, 44, 45, 40, 39, 39, 39, 
	39, 77, 76, 39, 79, 78, 80, 81, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 80, 78, 79, 
	78, 78, 78, 78, 82, 78, 83, 83, 
	84, 79, 78, 86, 86, 84, 85, 84, 
	85, 87, 87, 88, 79, 78, 89, 89, 
	88, 78, 88, 78, 90, 90, 91, 79, 
	78, 92, 92, 91, 78, 91, 78, 93, 
	93, 94, 79, 78, 95, 95, 94, 78, 
	94, 78, 96, 78, 78, 78, 79, 78, 
	97, 78, 98, 78, 99, 93, 93, 94, 
	79, 78, 100, 78, 101, 78, 102, 90, 
	90, 91, 79, 78, 103, 78, 104, 78, 
	105, 87, 87, 88, 79, 78, 106, 78, 
	107, 78, 108, 83, 83, 84, 79, 78, 
	78, 78, 78, 78, 108, 78, 108, 83, 
	83, 84, 79, 78, 78, 78, 78, 109, 
	108, 78, 110, 83, 83, 84, 79, 78, 
	78, 78, 78, 78, 110, 78, 110, 83, 
	83, 84, 79, 78, 78, 78, 78, 111, 
	110, 78, 112, 83, 83, 84, 79, 78, 
	78, 78, 78, 78, 112, 78, 112, 83, 
	83, 84, 79, 78, 78, 78, 78, 113, 
	112, 78, 114, 83, 83, 84, 79, 78, 
	78, 78, 78, 78, 114, 78, 114, 83, 
	83, 84, 79, 78, 78, 78, 78, 115, 
	114, 78, 116, 83, 83, 84, 79, 78, 
	78, 78, 78, 78, 116, 78, 118, 117, 
	119, 120, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 119, 
	117, 118, 117, 117, 117, 117, 121, 117, 
	122, 122, 123, 118, 117, 124, 124, 123, 
	117, 123, 117, 125, 125, 126, 118, 117, 
	127, 127, 126, 117, 126, 117, 128, 128, 
	129, 118, 117, 130, 130, 129, 117, 129, 
	117, 131, 131, 132, 118, 117, 133, 133, 
	132, 117, 132, 117, 134, 117, 117, 117, 
	118, 117, 135, 117, 136, 117, 137, 131, 
	131, 132, 118, 117, 138, 117, 139, 117, 
	140, 128, 128, 129, 118, 117, 141, 117, 
	142, 117, 143, 125, 125, 126, 118, 117, 
	144, 117, 145, 117, 146, 122, 122, 123, 
	118, 117, 117, 117, 117, 117, 146, 117, 
	146, 122, 122, 123, 118, 117, 117, 117, 
	117, 147, 146, 117, 148, 122, 122, 123, 
	118, 117, 117, 117, 117, 117, 148, 117, 
	148, 122, 122, 123, 118, 117, 117, 117, 
	117, 149, 148, 117, 150, 122, 122, 123, 
	118, 117, 117, 117, 117, 117, 150, 117, 
	150, 122, 122, 123, 118, 117, 117, 117, 
	117, 151, 150, 117, 152, 122, 122, 123, 
	118, 117, 117, 117, 117, 117, 152, 117, 
	152, 122, 122, 123, 118, 117, 117, 117, 
	117, 153, 152, 117, 154, 122, 122, 123, 
	118, 117, 117, 117, 117, 117, 154, 117, 
	154, 122, 122, 123, 118, 117, 117, 117, 
	117, 155, 154, 117, 116, 83, 83, 84, 
	79, 78, 78, 78, 78, 156, 116, 78, 
	86, 86, 84, 1, 0, 114, 83, 83, 
	84, 157, 0, 0, 0, 0, 0, 114, 
	0, 114, 83, 83, 84, 157, 0, 0, 
	0, 0, 158, 114, 0, 159, 159, 160, 
	1, 0, 7, 7, 160, 0, 161, 161, 
	162, 157, 0, 163, 163, 162, 0, 162, 
	0, 164, 164, 165, 157, 0, 166, 166, 
	165, 0, 165, 0, 167, 167, 168, 157, 
	0, 169, 169, 168, 0, 168, 0, 157, 
	0, 170, 171, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	170, 0, 157, 0, 0, 0, 0, 172, 
	0, 173, 0, 0, 0, 157, 0, 174, 
	0, 175, 0, 176, 167, 167, 168, 157, 
	0, 177, 0, 178, 0, 179, 164, 164, 
	165, 157, 0, 180, 0, 181, 0, 182, 
	161, 161, 162, 157, 0, 183, 0, 184, 
	0, 186, 185, 188, 189, 190, 191, 192, 
	193, 84, 79, 194, 195, 196, 196, 156, 
	197, 198, 199, 200, 201, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 187, 
	187, 202, 187, 204, 205, 206, 207, 6, 
	1, 208, 209, 203, 203, 38, 210, 203, 
	203, 211, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 212, 
	203, 213, 205, 214, 214, 6, 1, 208, 
	209, 203, 203, 203, 210, 203, 203, 211, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 212, 203, 205, 
	214, 214, 6, 1, 208, 209, 203, 203, 
	203, 210, 203, 203, 211, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 212, 203, 215, 203, 203, 203, 
	19, 216, 203, 1, 208, 209, 203, 203, 
	203, 217, 203, 215, 203, 218, 219, 220, 
	221, 6, 1, 208, 209, 203, 203, 36, 
	222, 203, 203, 211, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 212, 203, 223, 219, 224, 224, 6, 
	1, 208, 209, 203, 203, 203, 222, 203, 
	203, 211, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 212, 
	203, 219, 224, 224, 6, 1, 208, 209, 
	203, 203, 203, 222, 203, 203, 211, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 212, 203, 225, 203, 
	203, 203, 19, 226, 203, 1, 208, 209, 
	203, 203, 203, 217, 203, 225, 203, 227, 
	228, 229, 230, 6, 1, 208, 209, 203, 
	203, 34, 231, 203, 203, 211, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 212, 203, 232, 228, 233, 
	233, 6, 1, 208, 209, 203, 203, 203, 
	231, 203, 203, 211, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 212, 203, 228, 233, 233, 6, 1, 
	208, 209, 203, 203, 203, 231, 203, 203, 
	211, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 212, 203, 
	234, 203, 203, 203, 19, 235, 203, 1, 
	208, 209, 203, 203, 203, 217, 203, 234, 
	203, 236, 237, 238, 239, 6, 1, 208, 
	209, 203, 203, 32, 240, 203, 203, 211, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 212, 203, 241, 
	237, 242, 242, 6, 1, 208, 209, 203, 
	203, 203, 240, 203, 203, 211, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 212, 203, 237, 242, 242, 
	6, 1, 208, 209, 203, 203, 203, 240, 
	203, 203, 211, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	212, 203, 243, 203, 203, 203, 19, 244, 
	203, 1, 208, 209, 203, 203, 203, 217, 
	203, 243, 203, 245, 246, 247, 248, 6, 
	1, 208, 209, 203, 203, 30, 249, 203, 
	203, 211, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 212, 
	203, 250, 246, 251, 251, 6, 1, 208, 
	209, 203, 203, 203, 249, 203, 203, 211, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 212, 203, 246, 
	251, 251, 6, 1, 208, 209, 203, 203, 
	203, 249, 203, 203, 211, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 212, 203, 19, 252, 203, 1, 
	208, 209, 203, 203, 203, 217, 203, 253, 
	253, 203, 1, 208, 209, 203, 203, 203, 
	217, 203, 254, 203, 203, 255, 208, 209, 
	203, 208, 209, 203, 256, 203, 208, 257, 
	203, 208, 258, 203, 208, 203, 254, 203, 
	203, 203, 208, 209, 203, 259, 203, 260, 
	261, 203, 1, 208, 209, 203, 203, 4, 
	203, 3, 203, 253, 253, 203, 1, 208, 
	209, 203, 253, 253, 203, 1, 208, 209, 
	203, 259, 203, 253, 253, 203, 1, 208, 
	209, 203, 259, 203, 260, 253, 203, 1, 
	208, 209, 203, 203, 4, 203, 19, 203, 
	262, 262, 6, 1, 208, 209, 203, 203, 
	203, 217, 203, 263, 28, 264, 265, 9, 
	1, 208, 209, 203, 203, 203, 217, 203, 
	28, 264, 265, 9, 1, 208, 209, 203, 
	203, 203, 217, 203, 264, 264, 9, 1, 
	208, 209, 203, 203, 203, 217, 203, 266, 
	25, 267, 268, 12, 1, 208, 209, 203, 
	203, 203, 217, 203, 25, 267, 268, 12, 
	1, 208, 209, 203, 203, 203, 217, 203, 
	267, 267, 12, 1, 208, 209, 203, 203, 
	203, 217, 203, 269, 22, 270, 271, 15, 
	1, 208, 209, 203, 203, 203, 217, 203, 
	22, 270, 271, 15, 1, 208, 209, 203, 
	203, 203, 217, 203, 270, 270, 15, 1, 
	208, 209, 203, 203, 203, 217, 203, 272, 
	19, 253, 273, 203, 1, 208, 209, 203, 
	203, 203, 217, 203, 19, 253, 273, 203, 
	1, 208, 209, 203, 203, 203, 217, 203, 
	253, 274, 203, 1, 208, 209, 203, 203, 
	203, 217, 203, 19, 203, 253, 253, 203, 
	1, 208, 209, 203, 203, 203, 217, 203, 
	2, 3, 203, 203, 19, 252, 203, 1, 
	208, 209, 203, 203, 203, 217, 203, 2, 
	203, 246, 251, 251, 6, 1, 208, 209, 
	203, 203, 203, 249, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 212, 203, 246, 251, 
	251, 6, 1, 208, 209, 203, 203, 203, 
	249, 203, 245, 246, 251, 251, 6, 1, 
	208, 209, 203, 203, 203, 249, 203, 203, 
	211, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 212, 203, 
	245, 246, 247, 251, 6, 1, 208, 209, 
	203, 203, 30, 249, 203, 203, 211, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 212, 203, 243, 203, 
	275, 203, 262, 262, 6, 1, 208, 209, 
	203, 203, 203, 217, 203, 243, 203, 243, 
	203, 203, 203, 253, 253, 203, 1, 208, 
	209, 203, 203, 203, 217, 203, 243, 203, 
	243, 203, 203, 203, 253, 276, 203, 1, 
	208, 209, 203, 203, 203, 217, 203, 243, 
	203, 243, 203, 275, 203, 253, 253, 203, 
	1, 208, 209, 203, 203, 203, 217, 203, 
	243, 203, 243, 3, 203, 203, 19, 244, 
	203, 1, 208, 209, 203, 203, 203, 217, 
	203, 243, 203, 236, 237, 242, 242, 6, 
	1, 208, 209, 203, 203, 203, 240, 203, 
	203, 211, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 212, 
	203, 236, 237, 238, 242, 6, 1, 208, 
	209, 203, 203, 32, 240, 203, 203, 211, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 212, 203, 234, 
	203, 277, 203, 262, 262, 6, 1, 208, 
	209, 203, 203, 203, 217, 203, 234, 203, 
	234, 203, 203, 203, 253, 253, 203, 1, 
	208, 209, 203, 203, 203, 217, 203, 234, 
	203, 234, 203, 203, 203, 253, 278, 203, 
	1, 208, 209, 203, 203, 203, 217, 203, 
	234, 203, 234, 203, 277, 203, 253, 253, 
	203, 1, 208, 209, 203, 203, 203, 217, 
	203, 234, 203, 234, 3, 203, 203, 19, 
	235, 203, 1, 208, 209, 203, 203, 203, 
	217, 203, 234, 203, 227, 228, 233, 233, 
	6, 1, 208, 209, 203, 203, 203, 231, 
	203, 203, 211, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	212, 203, 227, 228, 229, 233, 6, 1, 
	208, 209, 203, 203, 34, 231, 203, 203, 
	211, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 212, 203, 
	225, 203, 279, 203, 262, 262, 6, 1, 
	208, 209, 203, 203, 203, 217, 203, 225, 
	203, 225, 203, 203, 203, 253, 253, 203, 
	1, 208, 209, 203, 203, 203, 217, 203, 
	225, 203, 225, 203, 203, 203, 253, 280, 
	203, 1, 208, 209, 203, 203, 203, 217, 
	203, 225, 203, 225, 203, 279, 203, 253, 
	253, 203, 1, 208, 209, 203, 203, 203, 
	217, 203, 225, 203, 225, 3, 203, 203, 
	19, 226, 203, 1, 208, 209, 203, 203, 
	203, 217, 203, 225, 203, 218, 219, 224, 
	224, 6, 1, 208, 209, 203, 203, 203, 
	222, 203, 203, 211, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 212, 203, 218, 219, 220, 224, 6, 
	1, 208, 209, 203, 203, 36, 222, 203, 
	203, 211, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 212, 
	203, 215, 203, 281, 203, 262, 262, 6, 
	1, 208, 209, 203, 203, 203, 217, 203, 
	215, 203, 215, 203, 203, 203, 253, 253, 
	203, 1, 208, 209, 203, 203, 203, 217, 
	203, 215, 203, 215, 203, 203, 203, 253, 
	282, 203, 1, 208, 209, 203, 203, 203, 
	217, 203, 215, 203, 215, 203, 281, 203, 
	253, 253, 203, 1, 208, 209, 203, 203, 
	203, 217, 203, 215, 203, 215, 3, 203, 
	203, 19, 216, 203, 1, 208, 209, 203, 
	203, 203, 217, 203, 215, 203, 204, 205, 
	214, 214, 6, 1, 208, 209, 203, 203, 
	203, 210, 203, 203, 211, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 212, 203, 204, 205, 206, 214, 
	6, 1, 208, 209, 203, 203, 38, 210, 
	203, 203, 211, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	212, 203, 284, 285, 286, 287, 45, 40, 
	288, 289, 283, 283, 77, 290, 283, 283, 
	291, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 292, 283, 
	293, 285, 294, 287, 45, 40, 288, 289, 
	283, 283, 283, 290, 283, 283, 291, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 292, 283, 285, 294, 
	287, 45, 40, 288, 289, 283, 283, 283, 
	290, 283, 283, 291, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 292, 283, 295, 283, 283, 283, 58, 
	296, 283, 40, 288, 289, 283, 283, 283, 
	297, 283, 295, 283, 298, 299, 300, 301, 
	45, 40, 288, 289, 283, 283, 75, 302, 
	283, 283, 291, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	292, 283, 303, 299, 304, 304, 45, 40, 
	288, 289, 283, 283, 283, 302, 283, 283, 
	291, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 292, 283, 
	299, 304, 304, 45, 40, 288, 289, 283, 
	283, 283, 302, 283, 283, 291, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 292, 283, 305, 283, 283, 
	283, 58, 306, 283, 40, 288, 289, 283, 
	283, 283, 297, 283, 305, 283, 307, 308, 
	309, 310, 45, 40, 288, 289, 283, 283, 
	73, 311, 283, 283, 291, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 292, 283, 312, 308, 313, 313, 
	45, 40, 288, 289, 283, 283, 283, 311, 
	283, 283, 291, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	292, 283, 308, 313, 313, 45, 40, 288, 
	289, 283, 283, 283, 311, 283, 283, 291, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 292, 283, 314, 
	283, 283, 283, 58, 315, 283, 40, 288, 
	289, 283, 283, 283, 297, 283, 314, 283, 
	316, 317, 318, 319, 45, 40, 288, 289, 
	283, 283, 71, 320, 283, 283, 291, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 292, 283, 321, 317, 
	322, 322, 45, 40, 288, 289, 283, 283, 
	283, 320, 283, 283, 291, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 292, 283, 317, 322, 322, 45, 
	40, 288, 289, 283, 283, 283, 320, 283, 
	283, 291, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 292, 
	283, 323, 283, 283, 283, 58, 324, 283, 
	40, 288, 289, 283, 283, 283, 297, 283, 
	323, 283, 325, 326, 327, 328, 45, 40, 
	288, 289, 283, 283, 69, 329, 283, 283, 
	291, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 292, 283, 
	330, 326, 331, 331, 45, 40, 288, 289, 
	283, 283, 283, 329, 283, 283, 291, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 292, 283, 326, 331, 
	331, 45, 40, 288, 289, 283, 283, 283, 
	329, 283, 283, 291, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 292, 283, 58, 332, 283, 40, 288, 
	289, 283, 283, 283, 297, 283, 333, 333, 
	283, 40, 288, 289, 283, 283, 283, 297, 
	283, 334, 283, 283, 335, 288, 289, 283, 
	288, 289, 283, 336, 283, 288, 337, 283, 
	288, 338, 283, 288, 283, 334, 283, 283, 
	283, 288, 289, 283, 339, 283, 340, 341, 
	283, 40, 288, 289, 283, 283, 43, 283, 
	42, 283, 333, 333, 283, 40, 288, 289, 
	283, 333, 333, 283, 40, 288, 289, 283, 
	339, 283, 333, 333, 283, 40, 288, 289, 
	283, 339, 283, 340, 333, 283, 40, 288, 
	289, 283, 283, 43, 283, 58, 283, 342, 
	342, 45, 40, 288, 289, 283, 283, 283, 
	297, 283, 343, 67, 344, 345, 48, 40, 
	288, 289, 283, 283, 283, 297, 283, 67, 
	344, 345, 48, 40, 288, 289, 283, 283, 
	283, 297, 283, 344, 344, 48, 40, 288, 
	289, 283, 283, 283, 297, 283, 346, 64, 
	347, 348, 51, 40, 288, 289, 283, 283, 
	283, 297, 283, 64, 347, 348, 51, 40, 
	288, 289, 283, 283, 283, 297, 283, 347, 
	347, 51, 40, 288, 289, 283, 283, 283, 
	297, 283, 349, 61, 350, 351, 54, 40, 
	288, 289, 283, 283, 283, 297, 283, 61, 
	350, 351, 54, 40, 288, 289, 283, 283, 
	283, 297, 283, 350, 350, 54, 40, 288, 
	289, 283, 283, 283, 297, 283, 352, 58, 
	333, 353, 283, 40, 288, 289, 283, 283, 
	283, 297, 283, 58, 333, 353, 283, 40, 
	288, 289, 283, 283, 283, 297, 283, 333, 
	354, 283, 40, 288, 289, 283, 283, 283, 
	297, 283, 58, 283, 333, 333, 283, 40, 
	288, 289, 283, 283, 283, 297, 283, 41, 
	42, 283, 283, 58, 332, 283, 40, 288, 
	289, 283, 283, 283, 297, 283, 41, 283, 
	326, 331, 331, 45, 40, 288, 289, 283, 
	283, 283, 329, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 292, 283, 326, 331, 331, 
	45, 40, 288, 289, 283, 283, 283, 329, 
	283, 325, 326, 331, 331, 45, 40, 288, 
	289, 283, 283, 283, 329, 283, 283, 291, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 292, 283, 325, 
	326, 327, 331, 45, 40, 288, 289, 283, 
	283, 69, 329, 283, 283, 291, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 292, 283, 323, 283, 355, 
	283, 342, 342, 45, 40, 288, 289, 283, 
	283, 283, 297, 283, 323, 283, 323, 283, 
	283, 283, 333, 333, 283, 40, 288, 289, 
	283, 283, 283, 297, 283, 323, 283, 323, 
	283, 283, 283, 333, 356, 283, 40, 288, 
	289, 283, 283, 283, 297, 283, 323, 283, 
	323, 283, 355, 283, 333, 333, 283, 40, 
	288, 289, 283, 283, 283, 297, 283, 323, 
	283, 323, 42, 283, 283, 58, 324, 283, 
	40, 288, 289, 283, 283, 283, 297, 283, 
	323, 283, 316, 317, 322, 322, 45, 40, 
	288, 289, 283, 283, 283, 320, 283, 283, 
	291, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 292, 283, 
	316, 317, 318, 322, 45, 40, 288, 289, 
	283, 283, 71, 320, 283, 283, 291, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 292, 283, 314, 283, 
	357, 283, 342, 342, 45, 40, 288, 289, 
	283, 283, 283, 297, 283, 314, 283, 314, 
	283, 283, 283, 333, 333, 283, 40, 288, 
	289, 283, 283, 283, 297, 283, 314, 283, 
	314, 283, 283, 283, 333, 358, 283, 40, 
	288, 289, 283, 283, 283, 297, 283, 314, 
	283, 314, 283, 357, 283, 333, 333, 283, 
	40, 288, 289, 283, 283, 283, 297, 283, 
	314, 283, 314, 42, 283, 283, 58, 315, 
	283, 40, 288, 289, 283, 283, 283, 297, 
	283, 314, 283, 307, 308, 313, 313, 45, 
	40, 288, 289, 283, 283, 283, 311, 283, 
	283, 291, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 292, 
	283, 307, 308, 309, 313, 45, 40, 288, 
	289, 283, 283, 73, 311, 283, 283, 291, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 292, 283, 305, 
	283, 359, 283, 342, 342, 45, 40, 288, 
	289, 283, 283, 283, 297, 283, 305, 283, 
	305, 283, 283, 283, 333, 333, 283, 40, 
	288, 289, 283, 283, 283, 297, 283, 305, 
	283, 305, 283, 283, 283, 333, 360, 283, 
	40, 288, 289, 283, 283, 283, 297, 283, 
	305, 283, 305, 283, 359, 283, 333, 333, 
	283, 40, 288, 289, 283, 283, 283, 297, 
	283, 305, 283, 305, 42, 283, 283, 58, 
	306, 283, 40, 288, 289, 283, 283, 283, 
	297, 283, 305, 283, 298, 299, 304, 304, 
	45, 40, 288, 289, 283, 283, 283, 302, 
	283, 283, 291, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	292, 283, 298, 299, 300, 304, 45, 40, 
	288, 289, 283, 283, 75, 302, 283, 283, 
	291, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 292, 283, 
	295, 283, 361, 283, 342, 342, 45, 40, 
	288, 289, 283, 283, 283, 297, 283, 295, 
	283, 295, 283, 283, 283, 333, 333, 283, 
	40, 288, 289, 283, 283, 283, 297, 283, 
	295, 283, 295, 283, 283, 283, 333, 362, 
	283, 40, 288, 289, 283, 283, 283, 297, 
	283, 295, 283, 295, 283, 361, 283, 333, 
	333, 283, 40, 288, 289, 283, 283, 283, 
	297, 283, 295, 283, 76, 44, 44, 45, 
	40, 283, 283, 283, 283, 283, 76, 283, 
	295, 42, 283, 283, 58, 296, 283, 40, 
	288, 289, 283, 283, 283, 297, 283, 295, 
	283, 284, 285, 294, 287, 45, 40, 288, 
	289, 283, 283, 283, 290, 283, 283, 291, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 292, 283, 364, 
	191, 365, 365, 84, 79, 194, 195, 363, 
	363, 363, 197, 363, 363, 200, 363, 363, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	363, 363, 363, 202, 363, 191, 365, 365, 
	84, 79, 194, 195, 363, 363, 363, 197, 
	363, 363, 200, 363, 363, 363, 363, 363, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	202, 363, 366, 363, 363, 363, 98, 367, 
	363, 79, 194, 195, 363, 363, 363, 368, 
	363, 366, 363, 369, 370, 371, 372, 84, 
	79, 194, 195, 363, 363, 115, 373, 363, 
	363, 200, 363, 363, 363, 363, 363, 363, 
	363, 363, 363, 363, 363, 363, 363, 202, 
	363, 374, 370, 375, 375, 84, 79, 194, 
	195, 363, 363, 363, 373, 363, 363, 200, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	363, 363, 363, 363, 363, 202, 363, 370, 
	375, 375, 84, 79, 194, 195, 363, 363, 
	363, 373, 363, 363, 200, 363, 363, 363, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	363, 363, 202, 363, 376, 363, 363, 363, 
	98, 377, 363, 79, 194, 195, 363, 363, 
	363, 368, 363, 376, 363, 378, 379, 380, 
	381, 84, 79, 194, 195, 363, 363, 113, 
	382, 363, 363, 200, 363, 363, 363, 363, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	363, 202, 363, 383, 379, 384, 384, 84, 
	79, 194, 195, 363, 363, 363, 382, 363, 
	363, 200, 363, 363, 363, 363, 363, 363, 
	363, 363, 363, 363, 363, 363, 363, 202, 
	363, 379, 384, 384, 84, 79, 194, 195, 
	363, 363, 363, 382, 363, 363, 200, 363, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	363, 363, 363, 363, 202, 363, 385, 363, 
	363, 363, 98, 386, 363, 79, 194, 195, 
	363, 363, 363, 368, 363, 385, 363, 387, 
	388, 389, 390, 84, 79, 194, 195, 363, 
	363, 111, 391, 363, 363, 200, 363, 363, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	363, 363, 363, 202, 363, 392, 388, 393, 
	393, 84, 79, 194, 195, 363, 363, 363, 
	391, 363, 363, 200, 363, 363, 363, 363, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	363, 202, 363, 388, 393, 393, 84, 79, 
	194, 195, 363, 363, 363, 391, 363, 363, 
	200, 363, 363, 363, 363, 363, 363, 363, 
	363, 363, 363, 363, 363, 363, 202, 363, 
	394, 363, 363, 363, 98, 395, 363, 79, 
	194, 195, 363, 363, 363, 368, 363, 394, 
	363, 396, 397, 398, 399, 84, 79, 194, 
	195, 363, 363, 109, 400, 363, 363, 200, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	363, 363, 363, 363, 363, 202, 363, 401, 
	397, 402, 402, 84, 79, 194, 195, 363, 
	363, 363, 400, 363, 363, 200, 363, 363, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	363, 363, 363, 202, 363, 397, 402, 402, 
	84, 79, 194, 195, 363, 363, 363, 400, 
	363, 363, 200, 363, 363, 363, 363, 363, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	202, 363, 98, 403, 363, 79, 194, 195, 
	363, 363, 363, 368, 363, 404, 404, 363, 
	79, 194, 195, 363, 363, 363, 368, 363, 
	405, 363, 363, 406, 194, 195, 363, 194, 
	195, 363, 407, 363, 194, 408, 363, 194, 
	409, 363, 194, 363, 405, 363, 363, 363, 
	194, 195, 363, 410, 363, 411, 412, 363, 
	79, 194, 195, 363, 363, 82, 363, 81, 
	363, 404, 404, 363, 79, 194, 195, 363, 
	404, 404, 363, 79, 194, 195, 363, 410, 
	363, 404, 404, 363, 79, 194, 195, 363, 
	410, 363, 411, 404, 363, 79, 194, 195, 
	363, 363, 82, 363, 98, 363, 413, 413, 
	84, 79, 194, 195, 363, 363, 363, 368, 
	363, 414, 107, 415, 416, 88, 79, 194, 
	195, 363, 363, 363, 368, 363, 107, 415, 
	416, 88, 79, 194, 195, 363, 363, 363, 
	368, 363, 415, 415, 88, 79, 194, 195, 
	363, 363, 363, 368, 363, 417, 104, 418, 
	419, 91, 79, 194, 195, 363, 363, 363, 
	368, 363, 104, 418, 419, 91, 79, 194, 
	195, 363, 363, 363, 368, 363, 418, 418, 
	91, 79, 194, 195, 363, 363, 363, 368, 
	363, 420, 101, 421, 422, 94, 79, 194, 
	195, 363, 363, 363, 368, 363, 101, 421, 
	422, 94, 79, 194, 195, 363, 363, 363, 
	368, 363, 421, 421, 94, 79, 194, 195, 
	363, 363, 363, 368, 363, 423, 98, 404, 
	424, 363, 79, 194, 195, 363, 363, 363, 
	368, 363, 98, 404, 424, 363, 79, 194, 
	195, 363, 363, 363, 368, 363, 404, 425, 
	363, 79, 194, 195, 363, 363, 363, 368, 
	363, 98, 363, 404, 404, 363, 79, 194, 
	195, 363, 363, 363, 368, 363, 80, 81, 
	363, 363, 98, 403, 363, 79, 194, 195, 
	363, 363, 363, 368, 363, 80, 363, 397, 
	402, 402, 84, 79, 194, 195, 363, 363, 
	363, 400, 363, 363, 363, 363, 363, 363, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	363, 363, 202, 363, 397, 402, 402, 84, 
	79, 194, 195, 363, 363, 363, 400, 363, 
	396, 397, 402, 402, 84, 79, 194, 195, 
	363, 363, 363, 400, 363, 363, 200, 363, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	363, 363, 363, 363, 202, 363, 396, 397, 
	398, 402, 84, 79, 194, 195, 363, 363, 
	109, 400, 363, 363, 200, 363, 363, 363, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	363, 363, 202, 363, 394, 363, 426, 363, 
	413, 413, 84, 79, 194, 195, 363, 363, 
	363, 368, 363, 394, 363, 394, 363, 363, 
	363, 404, 404, 363, 79, 194, 195, 363, 
	363, 363, 368, 363, 394, 363, 394, 363, 
	363, 363, 404, 427, 363, 79, 194, 195, 
	363, 363, 363, 368, 363, 394, 363, 394, 
	363, 426, 363, 404, 404, 363, 79, 194, 
	195, 363, 363, 363, 368, 363, 394, 363, 
	394, 81, 363, 363, 98, 395, 363, 79, 
	194, 195, 363, 363, 363, 368, 363, 394, 
	363, 387, 388, 393, 393, 84, 79, 194, 
	195, 363, 363, 363, 391, 363, 363, 200, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	363, 363, 363, 363, 363, 202, 363, 387, 
	388, 389, 393, 84, 79, 194, 195, 363, 
	363, 111, 391, 363, 363, 200, 363, 363, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	363, 363, 363, 202, 363, 385, 363, 428, 
	363, 413, 413, 84, 79, 194, 195, 363, 
	363, 363, 368, 363, 385, 363, 385, 363, 
	363, 363, 404, 404, 363, 79, 194, 195, 
	363, 363, 363, 368, 363, 385, 363, 385, 
	363, 363, 363, 404, 429, 363, 79, 194, 
	195, 363, 363, 363, 368, 363, 385, 363, 
	385, 363, 428, 363, 404, 404, 363, 79, 
	194, 195, 363, 363, 363, 368, 363, 385, 
	363, 385, 81, 363, 363, 98, 386, 363, 
	79, 194, 195, 363, 363, 363, 368, 363, 
	385, 363, 378, 379, 384, 384, 84, 79, 
	194, 195, 363, 363, 363, 382, 363, 363, 
	200, 363, 363, 363, 363, 363, 363, 363, 
	363, 363, 363, 363, 363, 363, 202, 363, 
	378, 379, 380, 384, 84, 79, 194, 195, 
	363, 363, 113, 382, 363, 363, 200, 363, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	363, 363, 363, 363, 202, 363, 376, 363, 
	430, 363, 413, 413, 84, 79, 194, 195, 
	363, 363, 363, 368, 363, 376, 363, 376, 
	363, 363, 363, 404, 404, 363, 79, 194, 
	195, 363, 363, 363, 368, 363, 376, 363, 
	376, 363, 363, 363, 404, 431, 363, 79, 
	194, 195, 363, 363, 363, 368, 363, 376, 
	363, 376, 363, 430, 363, 404, 404, 363, 
	79, 194, 195, 363, 363, 363, 368, 363, 
	376, 363, 376, 81, 363, 363, 98, 377, 
	363, 79, 194, 195, 363, 363, 363, 368, 
	363, 376, 363, 369, 370, 375, 375, 84, 
	79, 194, 195, 363, 363, 363, 373, 363, 
	363, 200, 363, 363, 363, 363, 363, 363, 
	363, 363, 363, 363, 363, 363, 363, 202, 
	363, 369, 370, 371, 375, 84, 79, 194, 
	195, 363, 363, 115, 373, 363, 363, 200, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	363, 363, 363, 363, 363, 202, 363, 366, 
	363, 432, 363, 413, 413, 84, 79, 194, 
	195, 363, 363, 363, 368, 363, 366, 363, 
	366, 363, 363, 363, 404, 404, 363, 79, 
	194, 195, 363, 363, 363, 368, 363, 366, 
	363, 366, 363, 363, 363, 404, 433, 363, 
	79, 194, 195, 363, 363, 363, 368, 363, 
	366, 363, 366, 363, 432, 363, 404, 404, 
	363, 79, 194, 195, 363, 363, 363, 368, 
	363, 366, 363, 366, 81, 363, 363, 98, 
	367, 363, 79, 194, 195, 363, 363, 363, 
	368, 363, 366, 363, 116, 83, 83, 84, 
	79, 434, 434, 434, 434, 156, 116, 434, 
	190, 191, 365, 365, 84, 79, 194, 195, 
	363, 363, 363, 197, 363, 363, 200, 363, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	363, 363, 363, 363, 202, 363, 116, 83, 
	83, 84, 79, 434, 434, 434, 434, 434, 
	116, 434, 436, 437, 438, 439, 123, 118, 
	440, 441, 435, 435, 155, 442, 435, 435, 
	443, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 444, 435, 
	445, 437, 439, 439, 123, 118, 440, 441, 
	435, 435, 435, 442, 435, 435, 443, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 444, 435, 437, 439, 
	439, 123, 118, 440, 441, 435, 435, 435, 
	442, 435, 435, 443, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 444, 435, 446, 435, 435, 435, 136, 
	447, 435, 118, 440, 441, 435, 435, 435, 
	448, 435, 446, 435, 449, 450, 451, 452, 
	123, 118, 440, 441, 435, 435, 153, 453, 
	435, 435, 443, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	444, 435, 454, 450, 455, 455, 123, 118, 
	440, 441, 435, 435, 435, 453, 435, 435, 
	443, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 444, 435, 
	450, 455, 455, 123, 118, 440, 441, 435, 
	435, 435, 453, 435, 435, 443, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 444, 435, 456, 435, 435, 
	435, 136, 457, 435, 118, 440, 441, 435, 
	435, 435, 448, 435, 456, 435, 458, 459, 
	460, 461, 123, 118, 440, 441, 435, 435, 
	151, 462, 435, 435, 443, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 444, 435, 463, 459, 464, 464, 
	123, 118, 440, 441, 435, 435, 435, 462, 
	435, 435, 443, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	444, 435, 459, 464, 464, 123, 118, 440, 
	441, 435, 435, 435, 462, 435, 435, 443, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 444, 435, 465, 
	435, 435, 435, 136, 466, 435, 118, 440, 
	441, 435, 435, 435, 448, 435, 465, 435, 
	467, 468, 469, 470, 123, 118, 440, 441, 
	435, 435, 149, 471, 435, 435, 443, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 444, 435, 472, 468, 
	473, 473, 123, 118, 440, 441, 435, 435, 
	435, 471, 435, 435, 443, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 444, 435, 468, 473, 473, 123, 
	118, 440, 441, 435, 435, 435, 471, 435, 
	435, 443, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 444, 
	435, 474, 435, 435, 435, 136, 475, 435, 
	118, 440, 441, 435, 435, 435, 448, 435, 
	474, 435, 476, 477, 478, 479, 123, 118, 
	440, 441, 435, 435, 147, 480, 435, 435, 
	443, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 444, 435, 
	481, 477, 482, 482, 123, 118, 440, 441, 
	435, 435, 435, 480, 435, 435, 443, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 444, 435, 477, 482, 
	482, 123, 118, 440, 441, 435, 435, 435, 
	480, 435, 435, 443, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 444, 435, 136, 483, 435, 118, 440, 
	441, 435, 435, 435, 448, 435, 484, 484, 
	435, 118, 440, 441, 435, 435, 435, 448, 
	435, 485, 435, 435, 486, 440, 441, 435, 
	440, 441, 435, 487, 435, 440, 488, 435, 
	440, 489, 435, 440, 435, 485, 435, 435, 
	435, 440, 441, 435, 490, 435, 491, 492, 
	435, 118, 440, 441, 435, 435, 121, 435, 
	120, 435, 484, 484, 435, 118, 440, 441, 
	435, 484, 484, 435, 118, 440, 441, 435, 
	490, 435, 484, 484, 435, 118, 440, 441, 
	435, 490, 435, 491, 484, 435, 118, 440, 
	441, 435, 435, 121, 435, 136, 435, 493, 
	493, 123, 118, 440, 441, 435, 435, 435, 
	448, 435, 494, 145, 495, 496, 126, 118, 
	440, 441, 435, 435, 435, 448, 435, 145, 
	495, 496, 126, 118, 440, 441, 435, 435, 
	435, 448, 435, 495, 495, 126, 118, 440, 
	441, 435, 435, 435, 448, 435, 497, 142, 
	498, 499, 129, 118, 440, 441, 435, 435, 
	435, 448, 435, 142, 498, 499, 129, 118, 
	440, 441, 435, 435, 435, 448, 435, 498, 
	498, 129, 118, 440, 441, 435, 435, 435, 
	448, 435, 500, 139, 501, 502, 132, 118, 
	440, 441, 435, 435, 435, 448, 435, 139, 
	501, 502, 132, 118, 440, 441, 435, 435, 
	435, 448, 435, 501, 501, 132, 118, 440, 
	441, 435, 435, 435, 448, 435, 503, 136, 
	484, 504, 435, 118, 440, 441, 435, 435, 
	435, 448, 435, 136, 484, 504, 435, 118, 
	440, 441, 435, 435, 435, 448, 435, 484, 
	505, 435, 118, 440, 441, 435, 435, 435, 
	448, 435, 136, 435, 484, 484, 435, 118, 
	440, 441, 435, 435, 435, 448, 435, 119, 
	120, 435, 435, 136, 483, 435, 118, 440, 
	441, 435, 435, 435, 448, 435, 119, 435, 
	477, 482, 482, 123, 118, 440, 441, 435, 
	435, 435, 480, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 444, 435, 477, 482, 482, 
	123, 118, 440, 441, 435, 435, 435, 480, 
	435, 476, 477, 482, 482, 123, 118, 440, 
	441, 435, 435, 435, 480, 435, 435, 443, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 444, 435, 476, 
	477, 478, 482, 123, 118, 440, 441, 435, 
	435, 147, 480, 435, 435, 443, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 444, 435, 474, 435, 506, 
	435, 493, 493, 123, 118, 440, 441, 435, 
	435, 435, 448, 435, 474, 435, 474, 435, 
	435, 435, 484, 484, 435, 118, 440, 441, 
	435, 435, 435, 448, 435, 474, 435, 474, 
	435, 435, 435, 484, 507, 435, 118, 440, 
	441, 435, 435, 435, 448, 435, 474, 435, 
	474, 435, 506, 435, 484, 484, 435, 118, 
	440, 441, 435, 435, 435, 448, 435, 474, 
	435, 474, 120, 435, 435, 136, 475, 435, 
	118, 440, 441, 435, 435, 435, 448, 435, 
	474, 435, 467, 468, 473, 473, 123, 118, 
	440, 441, 435, 435, 435, 471, 435, 435, 
	443, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 444, 435, 
	467, 468, 469, 473, 123, 118, 440, 441, 
	435, 435, 149, 471, 435, 435, 443, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 444, 435, 465, 435, 
	508, 435, 493, 493, 123, 118, 440, 441, 
	435, 435, 435, 448, 435, 465, 435, 465, 
	435, 435, 435, 484, 484, 435, 118, 440, 
	441, 435, 435, 435, 448, 435, 465, 435, 
	465, 435, 435, 435, 484, 509, 435, 118, 
	440, 441, 435, 435, 435, 448, 435, 465, 
	435, 465, 435, 508, 435, 484, 484, 435, 
	118, 440, 441, 435, 435, 435, 448, 435, 
	465, 435, 465, 120, 435, 435, 136, 466, 
	435, 118, 440, 441, 435, 435, 435, 448, 
	435, 465, 435, 458, 459, 464, 464, 123, 
	118, 440, 441, 435, 435, 435, 462, 435, 
	435, 443, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 444, 
	435, 458, 459, 460, 464, 123, 118, 440, 
	441, 435, 435, 151, 462, 435, 435, 443, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 444, 435, 456, 
	435, 510, 435, 493, 493, 123, 118, 440, 
	441, 435, 435, 435, 448, 435, 456, 435, 
	456, 435, 435, 435, 484, 484, 435, 118, 
	440, 441, 435, 435, 435, 448, 435, 456, 
	435, 456, 435, 435, 435, 484, 511, 435, 
	118, 440, 441, 435, 435, 435, 448, 435, 
	456, 435, 456, 435, 510, 435, 484, 484, 
	435, 118, 440, 441, 435, 435, 435, 448, 
	435, 456, 435, 456, 120, 435, 435, 136, 
	457, 435, 118, 440, 441, 435, 435, 435, 
	448, 435, 456, 435, 449, 450, 455, 455, 
	123, 118, 440, 441, 435, 435, 435, 453, 
	435, 435, 443, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	444, 435, 449, 450, 451, 455, 123, 118, 
	440, 441, 435, 435, 153, 453, 435, 435, 
	443, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 444, 435, 
	446, 435, 512, 435, 493, 493, 123, 118, 
	440, 441, 435, 435, 435, 448, 435, 446, 
	435, 446, 435, 435, 435, 484, 484, 435, 
	118, 440, 441, 435, 435, 435, 448, 435, 
	446, 435, 446, 435, 435, 435, 484, 513, 
	435, 118, 440, 441, 435, 435, 435, 448, 
	435, 446, 435, 446, 435, 512, 435, 484, 
	484, 435, 118, 440, 441, 435, 435, 435, 
	448, 435, 446, 435, 446, 120, 435, 435, 
	136, 447, 435, 118, 440, 441, 435, 435, 
	435, 448, 435, 446, 435, 436, 437, 439, 
	439, 123, 118, 440, 441, 435, 435, 435, 
	442, 435, 435, 443, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 444, 435, 188, 189, 190, 191, 514, 
	365, 84, 79, 194, 195, 196, 196, 156, 
	197, 363, 188, 200, 363, 363, 363, 363, 
	363, 363, 363, 363, 363, 363, 363, 363, 
	363, 202, 363, 204, 515, 206, 207, 6, 
	1, 208, 209, 203, 203, 38, 210, 203, 
	203, 211, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 212, 
	203, 215, 189, 190, 191, 516, 517, 84, 
	157, 518, 519, 203, 196, 156, 520, 203, 
	215, 200, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 202, 
	203, 116, 521, 521, 84, 157, 208, 209, 
	203, 203, 156, 522, 203, 523, 203, 203, 
	524, 518, 519, 203, 518, 519, 203, 256, 
	203, 518, 525, 203, 518, 526, 203, 518, 
	203, 523, 203, 203, 203, 518, 519, 203, 
	527, 3, 363, 363, 404, 433, 363, 79, 
	194, 195, 363, 363, 363, 368, 363, 527, 
	363, 528, 370, 529, 530, 84, 157, 518, 
	519, 203, 203, 158, 373, 203, 203, 200, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 202, 203, 531, 
	370, 532, 532, 84, 157, 518, 519, 203, 
	203, 203, 373, 203, 203, 200, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 202, 203, 370, 532, 532, 
	84, 157, 518, 519, 203, 203, 203, 373, 
	203, 203, 200, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	202, 203, 528, 370, 532, 532, 84, 157, 
	518, 519, 203, 203, 203, 373, 203, 203, 
	200, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 202, 203, 
	528, 370, 529, 532, 84, 157, 518, 519, 
	203, 203, 158, 373, 203, 203, 200, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 202, 203, 215, 203, 
	281, 116, 533, 533, 160, 157, 208, 209, 
	203, 203, 203, 522, 203, 215, 203, 534, 
	184, 535, 536, 162, 157, 518, 519, 203, 
	203, 203, 537, 203, 184, 535, 536, 162, 
	157, 518, 519, 203, 203, 203, 537, 203, 
	535, 535, 162, 157, 518, 519, 203, 203, 
	203, 537, 203, 538, 181, 539, 540, 165, 
	157, 518, 519, 203, 203, 203, 537, 203, 
	181, 539, 540, 165, 157, 518, 519, 203, 
	203, 203, 537, 203, 539, 539, 165, 157, 
	518, 519, 203, 203, 203, 537, 203, 541, 
	178, 542, 543, 168, 157, 518, 519, 203, 
	203, 203, 537, 203, 178, 542, 543, 168, 
	157, 518, 519, 203, 203, 203, 537, 203, 
	542, 542, 168, 157, 518, 519, 203, 203, 
	203, 537, 203, 544, 175, 545, 546, 203, 
	157, 518, 519, 203, 203, 203, 537, 203, 
	175, 545, 546, 203, 157, 518, 519, 203, 
	203, 203, 537, 203, 545, 545, 203, 157, 
	518, 519, 203, 203, 203, 537, 203, 547, 
	203, 548, 549, 203, 157, 518, 519, 203, 
	203, 172, 203, 171, 203, 545, 545, 203, 
	157, 518, 519, 203, 545, 545, 203, 157, 
	518, 519, 203, 547, 203, 545, 545, 203, 
	157, 518, 519, 203, 547, 203, 548, 545, 
	203, 157, 518, 519, 203, 203, 172, 203, 
	527, 171, 363, 363, 98, 367, 363, 79, 
	194, 195, 363, 363, 363, 368, 363, 527, 
	363, 551, 550, 552, 552, 550, 186, 553, 
	554, 550, 552, 552, 550, 186, 553, 554, 
	550, 555, 550, 550, 556, 553, 554, 550, 
	553, 554, 550, 557, 550, 553, 558, 550, 
	553, 559, 550, 553, 550, 555, 550, 550, 
	550, 553, 554, 550, 0
};

static const short _indic_syllable_machine_trans_targs[] = {
	178, 200, 207, 209, 210, 4, 213, 5, 
	7, 216, 8, 10, 219, 11, 13, 222, 
	14, 16, 17, 199, 19, 20, 221, 22, 
	23, 218, 25, 26, 215, 224, 229, 233, 
	236, 240, 243, 247, 250, 254, 257, 178, 
	280, 287, 289, 290, 41, 293, 42, 44, 
	296, 45, 47, 299, 48, 50, 302, 51, 
	53, 54, 279, 56, 57, 301, 59, 60, 
	298, 62, 63, 295, 304, 309, 313, 316, 
	320, 323, 327, 330, 334, 338, 178, 359, 
	366, 368, 369, 78, 372, 178, 79, 81, 
	375, 82, 84, 378, 85, 87, 381, 88, 
	90, 91, 358, 93, 94, 380, 96, 97, 
	377, 99, 100, 374, 383, 388, 392, 395, 
	399, 402, 406, 409, 413, 178, 440, 447, 
	449, 450, 114, 453, 115, 117, 456, 118, 
	120, 459, 121, 123, 462, 124, 126, 127, 
	439, 129, 130, 461, 132, 133, 458, 135, 
	136, 455, 464, 469, 473, 476, 480, 483, 
	487, 490, 494, 497, 417, 502, 513, 152, 
	516, 154, 519, 155, 157, 522, 158, 160, 
	525, 161, 528, 530, 531, 166, 167, 527, 
	169, 170, 524, 172, 173, 521, 175, 176, 
	518, 178, 536, 178, 179, 259, 339, 341, 
	416, 418, 361, 362, 419, 415, 498, 499, 
	386, 534, 387, 178, 180, 182, 36, 258, 
	202, 203, 256, 227, 228, 181, 35, 183, 
	252, 1, 184, 186, 34, 251, 249, 185, 
	33, 187, 245, 188, 190, 32, 244, 242, 
	189, 31, 191, 238, 192, 194, 30, 237, 
	235, 193, 29, 195, 231, 196, 198, 28, 
	230, 226, 197, 27, 212, 0, 201, 206, 
	178, 204, 205, 208, 2, 211, 3, 214, 
	6, 24, 217, 9, 21, 220, 12, 18, 
	223, 15, 225, 232, 234, 239, 241, 246, 
	248, 253, 255, 178, 260, 262, 73, 336, 
	282, 283, 337, 307, 308, 261, 72, 263, 
	332, 38, 264, 266, 71, 331, 329, 265, 
	70, 267, 325, 268, 270, 69, 324, 322, 
	269, 68, 271, 318, 272, 274, 67, 317, 
	315, 273, 66, 275, 311, 276, 278, 65, 
	310, 306, 277, 64, 292, 37, 281, 286, 
	178, 284, 285, 288, 39, 291, 40, 294, 
	43, 61, 297, 46, 58, 300, 49, 55, 
	303, 52, 305, 312, 314, 319, 321, 326, 
	328, 333, 335, 178, 340, 109, 342, 411, 
	75, 343, 345, 108, 410, 408, 344, 107, 
	346, 404, 347, 349, 106, 403, 401, 348, 
	105, 350, 397, 351, 353, 104, 396, 394, 
	352, 103, 354, 390, 355, 357, 102, 389, 
	385, 356, 101, 371, 74, 360, 365, 178, 
	363, 364, 367, 76, 370, 77, 373, 80, 
	98, 376, 83, 95, 379, 86, 92, 382, 
	89, 384, 391, 393, 398, 400, 405, 407, 
	412, 414, 178, 178, 420, 422, 146, 145, 
	442, 443, 496, 467, 468, 421, 423, 492, 
	111, 424, 426, 144, 491, 489, 425, 143, 
	427, 485, 428, 430, 142, 484, 482, 429, 
	141, 431, 478, 432, 434, 140, 477, 475, 
	433, 139, 435, 471, 436, 438, 138, 470, 
	466, 437, 137, 452, 110, 441, 446, 178, 
	444, 445, 448, 112, 451, 113, 454, 116, 
	134, 457, 119, 131, 460, 122, 128, 463, 
	125, 465, 472, 474, 479, 481, 486, 488, 
	493, 495, 147, 500, 501, 515, 504, 505, 
	533, 148, 509, 503, 508, 506, 507, 510, 
	511, 150, 514, 512, 149, 151, 517, 153, 
	174, 163, 520, 156, 171, 523, 159, 168, 
	526, 162, 165, 529, 164, 532, 178, 535, 
	177, 538, 539, 537, 542, 178, 540, 541
};

static const char _indic_syllable_machine_trans_actions[] = {
	1, 0, 2, 2, 2, 0, 2, 0, 
	0, 2, 0, 0, 2, 0, 0, 2, 
	0, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 0, 0, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	0, 2, 2, 2, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 4, 0, 
	2, 2, 2, 0, 2, 5, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 2, 6, 2, 6, 
	2, 6, 2, 6, 2, 7, 0, 2, 
	2, 2, 0, 2, 0, 0, 2, 0, 
	0, 2, 0, 0, 2, 0, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 6, 0, 8, 0, 
	2, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 2, 2, 2, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 9, 0, 12, 2, 2, 6, 2, 
	13, 13, 0, 0, 2, 2, 6, 2, 
	6, 2, 6, 14, 2, 2, 0, 2, 
	0, 0, 2, 2, 2, 2, 0, 2, 
	2, 0, 2, 2, 0, 2, 2, 2, 
	0, 2, 2, 2, 2, 0, 2, 2, 
	2, 0, 2, 2, 2, 2, 0, 2, 
	2, 2, 0, 2, 2, 2, 2, 0, 
	2, 2, 2, 0, 2, 0, 0, 0, 
	15, 0, 0, 2, 0, 2, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 16, 2, 2, 0, 2, 
	0, 0, 2, 2, 2, 2, 0, 2, 
	2, 0, 2, 2, 0, 2, 2, 2, 
	0, 2, 2, 2, 2, 0, 2, 2, 
	2, 0, 2, 2, 2, 2, 0, 2, 
	2, 2, 0, 2, 2, 2, 2, 0, 
	2, 2, 2, 0, 2, 0, 0, 0, 
	17, 0, 0, 2, 0, 2, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 18, 6, 0, 6, 6, 
	0, 6, 2, 0, 6, 2, 6, 0, 
	6, 6, 6, 2, 0, 6, 2, 6, 
	0, 6, 6, 6, 2, 0, 6, 2, 
	6, 0, 6, 6, 6, 2, 0, 6, 
	2, 6, 0, 6, 0, 0, 0, 19, 
	0, 0, 2, 0, 2, 0, 2, 0, 
	0, 2, 0, 0, 2, 0, 0, 2, 
	0, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 20, 21, 2, 2, 0, 0, 
	0, 0, 2, 2, 2, 2, 2, 2, 
	0, 2, 2, 0, 2, 2, 2, 0, 
	2, 2, 2, 2, 0, 2, 2, 2, 
	0, 2, 2, 2, 2, 0, 2, 2, 
	2, 0, 2, 2, 2, 2, 0, 2, 
	2, 2, 0, 2, 0, 0, 0, 22, 
	0, 0, 2, 0, 2, 0, 2, 0, 
	0, 2, 0, 0, 2, 0, 0, 2, 
	0, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 0, 0, 8, 2, 0, 0, 
	2, 0, 2, 0, 0, 0, 0, 8, 
	8, 0, 8, 8, 0, 0, 2, 0, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 2, 23, 2, 
	0, 0, 0, 0, 0, 24, 0, 0
};

static const char _indic_syllable_machine_to_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 10, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0
};

static const char _indic_syllable_machine_from_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 11, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0
};

static const short _indic_syllable_machine_eof_trans[] = {
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 79, 79, 79, 79, 86, 86, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 79, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 186, 0, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 364, 364, 364, 364, 364, 
	364, 364, 364, 364, 364, 364, 364, 364, 
	364, 364, 364, 364, 364, 364, 364, 364, 
	364, 364, 364, 364, 364, 364, 364, 364, 
	364, 364, 364, 364, 364, 364, 364, 364, 
	364, 364, 364, 364, 364, 364, 364, 364, 
	364, 364, 364, 364, 364, 364, 364, 364, 
	364, 364, 364, 364, 364, 364, 364, 364, 
	364, 364, 364, 364, 364, 364, 364, 364, 
	364, 364, 364, 364, 364, 364, 364, 364, 
	435, 364, 435, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 364, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 364, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 364, 551, 551, 
	551, 551, 551, 551, 551, 551, 551
};

static const int indic_syllable_machine_start = 178;
static const int indic_syllable_machine_first_final = 178;
static const int indic_syllable_machine_error = -1;

static const int indic_syllable_machine_en_main = 178;


#line 36 "hb-ot-shape-complex-indic-machine.rl"



#line 97 "hb-ot-shape-complex-indic-machine.rl"


#define found_syllable(syllable_type) \
  HB_STMT_START { \
    if (0) fprintf (stderr, "syllable %d..%d %s\n", last, p+1, #syllable_type); \
    for (unsigned int i = last; i < p+1; i++) \
      info[i].syllable() = (syllable_serial << 4) | syllable_type; \
    last = p+1; \
    syllable_serial++; \
    if (unlikely (syllable_serial == 16)) syllable_serial = 1; \
  } HB_STMT_END

static void
find_syllables (hb_buffer_t *buffer)
{
  unsigned int p, pe, eof, ts HB_UNUSED, te HB_UNUSED, act HB_UNUSED;
  int cs;
  hb_glyph_info_t *info = buffer->info;
  
#line 1580 "hb-ot-shape-complex-indic-machine.hh"
	{
	cs = indic_syllable_machine_start;
	ts = 0;
	te = 0;
	act = 0;
	}

#line 118 "hb-ot-shape-complex-indic-machine.rl"


  p = 0;
  pe = eof = buffer->len;

  unsigned int last = 0;
  unsigned int syllable_serial = 1;
  
#line 1597 "hb-ot-shape-complex-indic-machine.hh"
	{
	int _slen;
	int _trans;
	const unsigned char *_keys;
	const short *_inds;
	if ( p == pe )
		goto _test_eof;
_resume:
	switch ( _indic_syllable_machine_from_state_actions[cs] ) {
	case 11:
#line 1 "NONE"
	{ts = p;}
	break;
#line 1611 "hb-ot-shape-complex-indic-machine.hh"
	}

	_keys = _indic_syllable_machine_trans_keys + (cs<<1);
	_inds = _indic_syllable_machine_indicies + _indic_syllable_machine_index_offsets[cs];

	_slen = _indic_syllable_machine_key_spans[cs];
	_trans = _inds[ _slen > 0 && _keys[0] <=( info[p].indic_category()) &&
		( info[p].indic_category()) <= _keys[1] ?
		( info[p].indic_category()) - _keys[0] : _slen ];

_eof_trans:
	cs = _indic_syllable_machine_trans_targs[_trans];

	if ( _indic_syllable_machine_trans_actions[_trans] == 0 )
		goto _again;

	switch ( _indic_syllable_machine_trans_actions[_trans] ) {
	case 2:
#line 1 "NONE"
	{te = p+1;}
	break;
	case 15:
#line 88 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (consonant_syllable); }}
	break;
	case 17:
#line 89 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (vowel_syllable); }}
	break;
	case 22:
#line 90 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (standalone_cluster); }}
	break;
	case 24:
#line 91 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (symbol_cluster); }}
	break;
	case 19:
#line 92 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (broken_cluster); }}
	break;
	case 12:
#line 93 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (non_indic_cluster); }}
	break;
	case 14:
#line 88 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (consonant_syllable); }}
	break;
	case 16:
#line 89 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (vowel_syllable); }}
	break;
	case 21:
#line 90 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (standalone_cluster); }}
	break;
	case 23:
#line 91 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (symbol_cluster); }}
	break;
	case 18:
#line 92 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (broken_cluster); }}
	break;
	case 20:
#line 93 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (non_indic_cluster); }}
	break;
	case 1:
#line 88 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (consonant_syllable); }}
	break;
	case 3:
#line 89 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (vowel_syllable); }}
	break;
	case 7:
#line 90 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (standalone_cluster); }}
	break;
	case 9:
#line 91 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (symbol_cluster); }}
	break;
	case 4:
#line 92 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (broken_cluster); }}
	break;
	case 5:
#line 1 "NONE"
	{	switch( act ) {
	case 1:
	{{p = ((te))-1;} found_syllable (consonant_syllable); }
	break;
	case 5:
	{{p = ((te))-1;} found_syllable (broken_cluster); }
	break;
	case 6:
	{{p = ((te))-1;} found_syllable (non_indic_cluster); }
	break;
	}
	}
	break;
	case 8:
#line 1 "NONE"
	{te = p+1;}
#line 88 "hb-ot-shape-complex-indic-machine.rl"
	{act = 1;}
	break;
	case 6:
#line 1 "NONE"
	{te = p+1;}
#line 92 "hb-ot-shape-complex-indic-machine.rl"
	{act = 5;}
	break;
	case 13:
#line 1 "NONE"
	{te = p+1;}
#line 93 "hb-ot-shape-complex-indic-machine.rl"
	{act = 6;}
	break;
#line 1734 "hb-ot-shape-complex-indic-machine.hh"
	}

_again:
	switch ( _indic_syllable_machine_to_state_actions[cs] ) {
	case 10:
#line 1 "NONE"
	{ts = 0;}
	break;
#line 1743 "hb-ot-shape-complex-indic-machine.hh"
	}

	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	if ( _indic_syllable_machine_eof_trans[cs] > 0 ) {
		_trans = _indic_syllable_machine_eof_trans[cs] - 1;
		goto _eof_trans;
	}
	}

	}

#line 127 "hb-ot-shape-complex-indic-machine.rl"

}

#endif /* HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH */
