.TH "ZIP_SOURCE_ZIP" "3" "August 2, 2014" "NiH" "Library Functions Manual"
.SH "NAME"
\fBzip_source_zip\fP
\- create data source from zip file
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
zip.h
zip_source_t *
zip_source_zip zip_t *archive zip_t *srcarchive zip_uint64_t srcidx zip_flags_t flags zip_uint64_t start zip_int64_t len
.SH "DESCRIPTION"
The function
zip_source_zip
creates a zip source from a file in a zip archive.
The
\fIsrcarchive\fP
argument is the (open) zip archive containing the source zip file
at index
\fIsrcidx\fP.
\fIlen\fP
bytes from offset
\fIstart\fP
will be used in the zip_source.
If
\fIlen\fP
is 0 or \-1, the rest of the file, starting from
\fIstart\fP,
is used.
If
\fIstart\fP
is zero and
\fIlen\fP
is \-1, the whole file will be copied without decompressing it.
.PP
Supported flags are:
.TP XZIPXFLXRECOMPRESSXXX
\fRZIP_FL_UNCHANGED\fP
Try to get the original data without any changes that may have been
made to
\fIsrcarchive\fP
after opening it.
.TP XZIPXFLXRECOMPRESSXXX
\fRZIP_FL_RECOMPRESS\fP
When adding the data from
\fIsrcarchive\fP,
re-compress it using the current settings instead of copying the
compressed data.
.SH "RETURN VALUES"
Upon successful completion, the created source is returned.
Otherwise,
\fRNULL\fP
is returned and the error code in
\fIarchive\fP
is set to indicate the error.
.SH "ERRORS"
zip_source_zip
fails if:
.TP 17n
[\fRZIP_ER_CHANGED\fP]
Unchanged data was requested, but it is not available.
.TP 17n
[\fRZIP_ER_INVAL\fP]
\fIsrcarchive\fP,
\fIsrcidx\fP,
\fIstart\fP,
or
\fIlen\fP
are invalid.
.TP 17n
[\fRZIP_ER_MEMORY\fP]
Required memory could not be allocated.
Additionally, it can return all error codes from
zip_stat_index
and
zip_fopen_index.
.SH "SEE ALSO"
libzip(3),
zip_add(3),
zip_replace(3),
zip_source(3)
.SH "AUTHORS"
Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
