/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.BoundsOutlineHandle;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.FontSizeHandle;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.MoveHandle;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.draw.TextEditingTool;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.LinkHandle;
import org.jhotdraw.samples.svg.figures.SVGAttributedFigure;
import org.jhotdraw.samples.svg.figures.SVGFigure;

public class SVGTextFigure
extends SVGAttributedFigure
implements TextHolderFigure,
SVGFigure {
    protected Point2D.Double[] coordinates = new Point2D.Double[]{new Point2D.Double()};
    protected double[] rotates = new double[]{0.0};
    private boolean editable = true;
    private transient Shape cachedTextShape;
    private transient Rectangle2D.Double cachedBounds;
    private transient Rectangle2D.Double cachedDrawingArea;

    public SVGTextFigure() {
        this("Text");
    }

    public SVGTextFigure(String string) {
        this.setText(string);
        SVGAttributeKeys.setDefaults(this);
    }

    @Override
    protected void drawText(Graphics2D graphics2D) {
    }

    @Override
    protected void drawFill(Graphics2D graphics2D) {
        graphics2D.fill(this.getTextShape());
    }

    @Override
    protected void drawStroke(Graphics2D graphics2D) {
        graphics2D.draw(this.getTextShape());
    }

    public void setCoordinates(Point2D.Double[] doubleArray) {
        this.coordinates = doubleArray;
        this.invalidate();
    }

    public Point2D.Double[] getCoordinates() {
        Point2D.Double[] doubleArray = new Point2D.Double[this.coordinates.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = (Point2D.Double)this.coordinates[i].clone();
        }
        return doubleArray;
    }

    public void setRotates(double[] dArray) {
        this.rotates = dArray;
        this.invalidate();
    }

    public double[] getRotates() {
        return (double[])this.rotates.clone();
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.cachedBounds == null) {
            this.cachedBounds = new Rectangle2D.Double();
            this.cachedBounds.setRect(this.getTextShape().getBounds2D());
            String string = this.getText();
            if (string == null || string.length() == 0) {
                string = " ";
            }
            FontRenderContext fontRenderContext = this.getFontRenderContext();
            HashMap<TextAttribute, Serializable> hashMap = new HashMap<TextAttribute, Serializable>();
            hashMap.put(TextAttribute.FONT, this.getFont());
            if (((Boolean)this.get(SVGAttributeKeys.FONT_UNDERLINE)).booleanValue()) {
                hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            TextLayout textLayout = new TextLayout(string, hashMap, fontRenderContext);
            this.cachedBounds.setRect(this.coordinates[0].x, this.coordinates[0].y - (double)textLayout.getAscent(), textLayout.getAdvance(), textLayout.getAscent());
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(this.coordinates[0].x, this.coordinates[0].y);
            switch (this.get(SVGAttributeKeys.TEXT_ANCHOR)) {
                case END: {
                    this.cachedBounds.x -= (double)textLayout.getAdvance();
                    break;
                }
                case MIDDLE: {
                    this.cachedBounds.x -= (double)textLayout.getAdvance() / 2.0;
                    break;
                }
            }
            affineTransform.rotate(this.rotates[0]);
        }
        return (Rectangle2D.Double)this.cachedBounds.clone();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            Rectangle2D rectangle2D = this.getTextShape().getBounds2D();
            Rectangle2D.Double double_ = rectangle2D instanceof Rectangle2D.Double ? (Rectangle2D.Double)rectangle2D : new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            double d = SVGAttributeKeys.getPerpendicularHitGrowth(this) + 1.0;
            Geom.grow(double_, d, d);
            if (this.get(SVGAttributeKeys.TRANSFORM) == null) {
                this.cachedDrawingArea = double_;
            } else {
                this.cachedDrawingArea = new Rectangle2D.Double();
                this.cachedDrawingArea.setRect(((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).createTransformedShape(double_).getBounds2D());
            }
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public boolean contains(Point2D.Double double_) {
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            try {
                double_ = (Point2D.Double)((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).inverseTransform(double_, new Point2D.Double());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        }
        return this.getTextShape().getBounds2D().contains(double_);
    }

    private Shape getTextShape() {
        if (this.cachedTextShape == null) {
            String string = this.getText();
            if (string == null || string.length() == 0) {
                string = " ";
            }
            FontRenderContext fontRenderContext = this.getFontRenderContext();
            HashMap<TextAttribute, Serializable> hashMap = new HashMap<TextAttribute, Serializable>();
            hashMap.put(TextAttribute.FONT, this.getFont());
            if (((Boolean)this.get(SVGAttributeKeys.FONT_UNDERLINE)).booleanValue()) {
                hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            TextLayout textLayout = new TextLayout(string, hashMap, fontRenderContext);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(this.coordinates[0].x, this.coordinates[0].y);
            switch (this.get(SVGAttributeKeys.TEXT_ANCHOR)) {
                case END: {
                    affineTransform.translate(-textLayout.getAdvance(), 0.0);
                    break;
                }
                case MIDDLE: {
                    affineTransform.translate((double)(-textLayout.getAdvance()) / 2.0, 0.0);
                    break;
                }
            }
            affineTransform.rotate(this.rotates[0]);
            this.cachedTextShape = affineTransform.createTransformedShape(textLayout.getOutline(affineTransform));
            this.cachedTextShape = textLayout.getOutline(affineTransform);
        }
        return this.cachedTextShape;
    }

    @Override
    public void setBounds(Point2D.Double double_, Point2D.Double double_2) {
        this.coordinates = new Point2D.Double[]{new Point2D.Double(double_.x, double_.y)};
        this.rotates = new double[]{0.0};
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        if (this.get(SVGAttributeKeys.TRANSFORM) != null || affineTransform.getType() != (affineTransform.getType() & 1)) {
            if (this.get(SVGAttributeKeys.TRANSFORM) == null) {
                this.set(SVGAttributeKeys.TRANSFORM, (AffineTransform)affineTransform.clone());
            } else {
                AffineTransform affineTransform2 = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(this);
                affineTransform2.preConcatenate(affineTransform);
                this.set(SVGAttributeKeys.TRANSFORM, affineTransform2);
            }
        } else {
            for (int i = 0; i < this.coordinates.length; ++i) {
                affineTransform.transform(this.coordinates[i], this.coordinates[i]);
            }
            if (this.get(SVGAttributeKeys.FILL_GRADIENT) != null && !this.get(SVGAttributeKeys.FILL_GRADIENT).isRelativeToFigureBounds()) {
                Gradient gradient = SVGAttributeKeys.FILL_GRADIENT.getClone(this);
                gradient.transform(affineTransform);
                this.set(SVGAttributeKeys.FILL_GRADIENT, gradient);
            }
            if (this.get(SVGAttributeKeys.STROKE_GRADIENT) != null && !this.get(SVGAttributeKeys.STROKE_GRADIENT).isRelativeToFigureBounds()) {
                Gradient gradient = SVGAttributeKeys.STROKE_GRADIENT.getClone(this);
                gradient.transform(affineTransform);
                this.set(SVGAttributeKeys.STROKE_GRADIENT, gradient);
            }
        }
        this.invalidate();
    }

    @Override
    public void restoreTransformTo(Object object) {
        Object[] objectArray = (Object[])object;
        SVGAttributeKeys.TRANSFORM.setClone(this, (AffineTransform)objectArray[0]);
        Point2D.Double[] doubleArray = (Point2D.Double[])objectArray[1];
        for (int i = 0; i < this.coordinates.length; ++i) {
            this.coordinates[i] = (Point2D.Double)doubleArray[i].clone();
        }
        SVGAttributeKeys.FILL_GRADIENT.setClone(this, (Gradient)objectArray[2]);
        SVGAttributeKeys.STROKE_GRADIENT.setClone(this, (Gradient)objectArray[3]);
        this.invalidate();
    }

    @Override
    public Object getTransformRestoreData() {
        Point2D.Double[] doubleArray = (Point2D.Double[])this.coordinates.clone();
        for (int i = 0; i < this.coordinates.length; ++i) {
            doubleArray[i] = (Point2D.Double)this.coordinates[i].clone();
        }
        return new Object[]{SVGAttributeKeys.TRANSFORM.getClone(this), doubleArray, SVGAttributeKeys.FILL_GRADIENT.getClone(this), SVGAttributeKeys.STROKE_GRADIENT.getClone(this)};
    }

    @Override
    public String getText() {
        return (String)this.get(SVGAttributeKeys.TEXT);
    }

    @Override
    public <T> void set(AttributeKey<T> attributeKey, T t) {
        if (attributeKey.equals(SVGAttributeKeys.TRANSFORM) || attributeKey.equals(SVGAttributeKeys.FONT_FACE) || attributeKey.equals(SVGAttributeKeys.FONT_BOLD) || attributeKey.equals(SVGAttributeKeys.FONT_ITALIC) || attributeKey.equals(SVGAttributeKeys.FONT_SIZE)) {
            this.invalidate();
        }
        super.set(attributeKey, t);
    }

    @Override
    public void setText(String string) {
        this.set(SVGAttributeKeys.TEXT, string);
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    @Override
    public int getTextColumns() {
        return 4;
    }

    @Override
    public Font getFont() {
        return SVGAttributeKeys.getFont(this);
    }

    @Override
    public Color getTextColor() {
        return (Color)this.get(SVGAttributeKeys.FILL_COLOR);
    }

    @Override
    public Color getFillColor() {
        return this.get(SVGAttributeKeys.FILL_COLOR) == null || ((Color)this.get(SVGAttributeKeys.FILL_COLOR)).equals(Color.white) ? Color.black : Color.WHITE;
    }

    @Override
    public void setFontSize(float f) {
        Point2D.Double double_ = new Point2D.Double(0.0, f);
        AffineTransform affineTransform = (AffineTransform)this.get(SVGAttributeKeys.TRANSFORM);
        if (affineTransform != null) {
            try {
                affineTransform.inverseTransform(double_, double_);
                Point2D.Double double_2 = new Point2D.Double(0.0, 0.0);
                affineTransform.inverseTransform(double_2, double_2);
                double_.y -= double_2.y;
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        }
        this.set(SVGAttributeKeys.FONT_SIZE, Math.abs(double_.y));
    }

    @Override
    public float getFontSize() {
        Point2D.Double double_ = new Point2D.Double(0.0, (Double)this.get(SVGAttributeKeys.FONT_SIZE));
        AffineTransform affineTransform = (AffineTransform)this.get(SVGAttributeKeys.TRANSFORM);
        if (affineTransform != null) {
            affineTransform.transform(double_, double_);
            Point2D.Double double_2 = new Point2D.Double(0.0, 0.0);
            affineTransform.transform(double_2, double_2);
            double_.y -= double_2.y;
        }
        return (float)Math.abs(double_.y);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedTextShape = null;
        this.cachedBounds = null;
        this.cachedDrawingArea = null;
    }

    @Override
    public Dimension2DDouble getPreferredSize() {
        Rectangle2D.Double double_ = this.getBounds();
        return new Dimension2DDouble(double_.width, double_.height);
    }

    @Override
    public Collection<Handle> createHandles(int n) {
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        switch (n % 2) {
            case -1: {
                linkedList.add(new BoundsOutlineHandle(this, false, true));
                break;
            }
            case 0: {
                linkedList.add(new BoundsOutlineHandle(this));
                linkedList.add(new MoveHandle(this, RelativeLocator.northWest()));
                linkedList.add(new MoveHandle(this, RelativeLocator.northEast()));
                linkedList.add(new MoveHandle(this, RelativeLocator.southWest()));
                linkedList.add(new MoveHandle(this, RelativeLocator.southEast()));
                linkedList.add(new FontSizeHandle(this));
                linkedList.add(new LinkHandle(this));
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, linkedList);
            }
        }
        return linkedList;
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public Connector findConnector(Point2D.Double double_, ConnectionFigure connectionFigure) {
        return null;
    }

    @Override
    public Connector findCompatibleConnector(Connector connector, boolean bl) {
        return null;
    }

    @Override
    public Tool getTool(Point2D.Double double_) {
        if (this.isEditable() && this.contains(double_)) {
            TextEditingTool textEditingTool = new TextEditingTool(this);
            return textEditingTool;
        }
        return null;
    }

    @Override
    public double getBaseline() {
        return this.coordinates[0].y - this.getBounds().y;
    }

    @Override
    public int getTabSize() {
        return 8;
    }

    @Override
    public TextHolderFigure getLabelFor() {
        return this;
    }

    @Override
    public Insets2D.Double getInsets() {
        return new Insets2D.Double();
    }

    @Override
    public SVGTextFigure clone() {
        SVGTextFigure sVGTextFigure = (SVGTextFigure)super.clone();
        sVGTextFigure.coordinates = new Point2D.Double[this.coordinates.length];
        for (int i = 0; i < this.coordinates.length; ++i) {
            sVGTextFigure.coordinates[i] = (Point2D.Double)this.coordinates[i].clone();
        }
        sVGTextFigure.rotates = (double[])this.rotates.clone();
        sVGTextFigure.cachedBounds = null;
        sVGTextFigure.cachedDrawingArea = null;
        sVGTextFigure.cachedTextShape = null;
        return sVGTextFigure;
    }

    @Override
    public boolean isEmpty() {
        return this.getText() == null || this.getText().length() == 0;
    }

    @Override
    public boolean isTextOverflow() {
        return false;
    }
}

