/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/MgmtTypesXml/MgmtCollectInstancesXml.h"

#include "Doc/MgmtTypesDoc/CMgmtCollectInstancesCollectionDoc.h"
#include "Doc/MgmtTypesDoc/CMgmtCollectInstancesDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/MgmtTypesXml/MgmtCollectInstancesCollectionXml.h"

using namespace Caf;

void MgmtCollectInstancesCollectionXml::add(
	const SmartPtrCMgmtCollectInstancesCollectionDoc mgmtCollectInstancesCollectionDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("MgmtCollectInstancesCollectionXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(mgmtCollectInstancesCollectionDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::deque<SmartPtrCMgmtCollectInstancesDoc> collectInstancesVal =
			mgmtCollectInstancesCollectionDoc->getCollectInstancesCollection();
		CAF_CM_VALIDATE_STL(collectInstancesVal);

		if (! collectInstancesVal.empty()) {
			for (TConstIterator<std::deque<SmartPtrCMgmtCollectInstancesDoc> > collectInstancesIter(collectInstancesVal);
				collectInstancesIter; collectInstancesIter++) {
				const SmartPtrCXmlElement collectInstancesXml =
					thisXml->createAndAddElement("collectInstances");
				MgmtCollectInstancesXml::add(*collectInstancesIter, collectInstancesXml);
			}
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCMgmtCollectInstancesCollectionDoc MgmtCollectInstancesCollectionXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("MgmtCollectInstancesCollectionXml", "parse");

	SmartPtrCMgmtCollectInstancesCollectionDoc mgmtCollectInstancesCollectionDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const CXmlElement::SmartPtrCElementCollection collectInstancesChildrenXml =
			thisXml->findRequiredChildren("collectInstances");

		std::deque<SmartPtrCMgmtCollectInstancesDoc> collectInstancesVal;
		if (! collectInstancesChildrenXml.IsNull() && ! collectInstancesChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> collectInstancesXmlIter(*collectInstancesChildrenXml);
				collectInstancesXmlIter; collectInstancesXmlIter++) {
				const SmartPtrCXmlElement collectInstancesXml = collectInstancesXmlIter->second;
				const SmartPtrCMgmtCollectInstancesDoc collectInstancesDoc =
					MgmtCollectInstancesXml::parse(collectInstancesXml);
				collectInstancesVal.push_back(collectInstancesDoc);
			}
		}

		mgmtCollectInstancesCollectionDoc.CreateInstance();
		mgmtCollectInstancesCollectionDoc->initialize(
			collectInstancesVal);
	}
	CAF_CM_EXIT;

	return mgmtCollectInstancesCollectionDoc;
}

