/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means: 
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and 

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program. 

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program. 

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution. 


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations. 

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive. 

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation. 



*/

/* (C) COPYRIGHT International Business Machines Corp. 2001          */


#include "pthread.h"
#include "pkcsslotd.h"
#include <strings.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>

#define PROC_BASE "/proc"

extern BOOL GCBlockSignals (void);

#if !defined(NOGARBAGE)

#include "garbage_linux.h"

#ifdef PKCS64
BOOL                IsValidProcessEntry     ( pid_t_64 pid, time_t_64 RegTime );
#else
BOOL                IsValidProcessEntry     ( pid_t pid,   time_t RegTime );
#endif

int                 Stat2Proc               ( int pid, proc_t *p );

 pthread_t    GCThread;                /* Garbage Collection thread's handle */
static BOOL         ThreadRunning = FALSE;   /* If we're already running or not */

#if THREADED
static void        *GCMain                  ( void *Ptr );
static void         GCCancel                ( void *Ptr );
#else
void        *GCMain                  ( void *Ptr );
void         GCCancel                ( void *Ptr );
#endif





/*********************************************************************************
 * StartGCThread -
 * 
 *   Entry point that starts the garbage collection thread
 * 
 *********************************************************************************/

BOOL StartGCThread ( Slot_Mgr_Shr_t *MemPtr ) {

  int err;

#if !(THREADED)
  return TRUE;
#endif

  if ( ThreadRunning ) {
    DbgLog (DL0, "StartGCThread: Thread already running.");
    return FALSE;
  }

  if ( ( err = pthread_create( &GCThread, NULL, GCMain, ((void *)MemPtr) ) ) != 0 ) {
    DbgLog(DL0,"StartGCThread: pthread_create returned %s (%d; %#x)", SysConst(err), err, err );
    return FALSE;
  }

  ThreadRunning = TRUE;

#ifdef DEV
  // Only development builds
  LogLog ( "StartGCThread: garbage collection thread started as ID %d (%#x) by ID %d (%#x)", GCThread, GCThread, pthread_self(), pthread_self() );
#endif
  return TRUE; 

}




/*********************************************************************************
 * StopGCThread - 
 * 
 *   Entry point which causes the Garbage collection thread to terminate
 *   Waits for the thread to terminate before continuing
 * 
 *********************************************************************************/ 

BOOL StopGCThread ( void *Ptr ) {
  int err;

  void *Status;

#if !(THREADED)
  return TRUE;
#endif
  if ( ! ThreadRunning ) {
    DbgLog(DL0,"StopGCThread was called when the garbage collection thread was not running");
    return FALSE;
  }

  DbgLog(DL0, "StopGCThread: tid %d is stopping the garbage collection thread (tid %d)", pthread_self(), GCThread);

  /* Cause the GC thread to be cancelled */
  if ( ( err = pthread_cancel(GCThread)) != 0 ) {
    DbgLog(DL0,"StopGCThread: pthread_cancel returned %s (%d; %#x)", SysConst(err), err, err );
    return FALSE;
  }

  /* Synchronize with the GC thread (aka: wait for it to terminate) */
  if ( (err = pthread_join ( GCThread, &Status ) ) != 0 ) {
    DbgLog(DL0,"StopGCThread: pthread_join returned %s (%d; %#x)", SysConst(err), err, err );
    return FALSE;
  }

  if ( Status != PTHREAD_CANCELED ) {
    DbgLog(DL0,"Hmm.  Thread was cancelled, but didn't return the appropriate return status");
  }

  ThreadRunning = FALSE;
  return TRUE;

}






/*********************************************************************************
 * GCMain -
 * 
 *     The Garbage collection thread's main()
 *     Basically, run until cancelled by another thread
 * 
 *********************************************************************************/

void *GCMain ( void *Ptr) {

#if THREADED
  int                           OrigCancelState;
  int                           OrigCancelType;
  int                           LastCancelState;
#endif
  Slot_Mgr_Shr_t               *MemPtr              = (Slot_Mgr_Shr_t *) Ptr;

  

  ASSERT ( MemPtr != NULL );


  sleep(2); //  SAB  Linux likes to have us delay
// Linux threading model appears to have some issues with regards to
// signals....  Need to look at this FIXME..

  /* setup */
  /* Block the signals that go to the main thread */
  /* FIXME: We probably want to make it so that signals go only to the main thread by default */
// SBADE ....  FIXME... remove the blocking of signals see what happens..
//  GCBlockSignals();


  /* Make it so that we can only be cancelled when we reach a cancellation point */
  /* cancellation points are listed here: http://techlib.austin.ibm.com/techlib/manuals/adoclib/aixprggd/genprogc/termthre.htm#D3A4499176manu */
  /* PTHREAD_CANCEL_DEFERRED should be the default */
#if THREADED
  pthread_setcancelstate ( PTHREAD_CANCEL_ENABLE,  &OrigCancelState );
  pthread_setcanceltype  ( PTHREAD_CANCEL_DEFERRED, &OrigCancelType  );

  /* push cleanup routines */
  pthread_cleanup_push ( GCCancel, MemPtr );
#endif

    DbgLog(DL0, "Garbage collection running... PID %d\n",getpid());
  while ( 1 ) {

    DbgLog(DL0, "Garbage collection running...");

    /* Don't allow cancellations while mucking with shared memory or holding mutexes */
#if THREADED
    pthread_setcancelstate ( PTHREAD_CANCEL_DISABLE, &LastCancelState );

#endif

    CheckForGarbage(MemPtr);

#if THREADED
    /* re-enable cancellations */
    pthread_setcancelstate ( PTHREAD_CANCEL_ENABLE, &LastCancelState );

    /* Test for cancellation by the main thread */
    pthread_testcancel();
#endif

    DbgLog(DL5, "Garbage collection finished.");

    /* now we pause */
    sleep(10);

  } /* end while 1 */


#if THREADED
  /* Yeah, yeah.  Has to be here because some implementations use macros that have to be balanced */
  pthread_cleanup_pop ( 0 );
#endif

  /* return implicitly calls pthread_cancel() */
  /* but it'll never really get executed; pthread_testcancel() implicitly calls pthread_exit() if there's a cancellation pending */
  return NULL;

}






/*********************************************************************************
 * GCCancel - 
 * 
 *       Cleanup routine called when Garbage collection thread exits/is cancelled
 * 
 *********************************************************************************/

void GCCancel ( void *Ptr ) {

  /* Yeah, yeah.  Doesn't do anything, but I had plans */
  DbgLog(DL3, "GCCancel: tid: %d running cleanup routine", pthread_self());

  return;

}






/*********************************************************************************
 * CheckForGarbage -
 * 
 *       The routine that actually does cleanup
 * 
 *********************************************************************************/

BOOL CheckForGarbage ( Slot_Mgr_Shr_t *MemPtr ) {

  int               SlotIndex;
  int               ProcIndex;
  int               Err;
  BOOL              ValidPid;

  ASSERT( MemPtr != NULL_PTR );
  #ifdef DEV
    DbgLog(DL5, "Thread %d is checking for garbage", pthread_self());
  #endif /* DEV */


  #ifdef DEV
    DbgLog (DL5, "Garbage collection attempting global shared memory lock");
  #endif /* DEV */

  /* Grab the global Shared mem mutex since we might modify global_session_count */

#if 1
    Err = XProcLock(&(MemPtr->slt_mutex));
  if ( Err != TRUE ) {
    DbgLog (DL0, "Garbage collection: Locking attempt for global shmem mutex returned %s", SysConst(Err) );
    return FALSE;
  }
#else
#ifdef PKCS64
  Err = msem_lock(&(MemPtr->slt_mutex),0);
#else
  Err = pthread_mutex_lock ( &(MemPtr->slt_mutex) );
#endif

  if ( Err != 0 ) {
    DbgLog (DL0, "Garbage collection: Locking attempt for global shmem mutex returned %s", SysConst(Err) );
    return FALSE;
  }
#endif

  #ifdef DEV
  DbgLog ( DL5, "Garbage collection: Got global shared memory lock");
  #endif /* DEV */


  for ( ProcIndex = 0; ProcIndex < NUMBER_PROCESSES_ALLOWED; ProcIndex++ ) {

#ifdef PKCS64
    Slot_Mgr_Proc_t_64 *pProc = &(MemPtr->proc_table[ProcIndex]);
#else
    Slot_Mgr_Proc_t   *pProc = &(MemPtr->proc_table[ProcIndex]);
#endif

    ASSERT(pProc != NULL_PTR);

    if ( ! (pProc->inuse) ) {
      continue;
    }

    ValidPid = ( (IsValidProcessEntry ( pProc->proc_id, pProc->reg_time )) && (pProc->proc_id != 0) );


    if ( ( pProc->inuse ) && (! ValidPid ) ) {

      #ifdef DEV
        DbgLog(DL1, "Garbage collection routine found bad entry for pid %d (Index: %d); removing from table", pProc->proc_id, ProcIndex );
      #endif /* DEV */

      /*                         */
      /* Clean up session counts */
      /*                         */
      for ( SlotIndex = 0; SlotIndex < NUMBER_SLOTS_MANAGED; SlotIndex++ ) {


#ifdef PKCS64
	unsigned int *pGlobalSessions    = &(MemPtr->slot_info[SlotIndex].global_sessions);
	unsigned int *pProcSessions      = &(pProc->slot_session_count[SlotIndex]);
#else
	int *pGlobalSessions    = &(MemPtr->slot_info[SlotIndex].global_sessions);
	int *pProcSessions      = &(pProc->slot_session_count[SlotIndex]);
#endif


	if ( *pProcSessions > 0 ) {

  	  #ifdef DEV
	    DbgLog ( DL2, "GC: Invalid pid (%d) is holding %d sessions open on slot %d.  Global session count for this slot is %d", pProc->proc_id, *pProcSessions, SlotIndex, *pGlobalSessions );
          #endif /* DEV */

	  if ( *pProcSessions > *pGlobalSessions ) {
	    #ifdef DEV
	      WarnLog ( "Garbage Collection: Illegal values in table for defunct process");
	      DbgLog  ( DL0, "Garbage collection: A process ( Index: %d, pid: %d ) showed %d sessions open on slot %s, but the global count for this slot is only %d",
			ProcIndex, pProc->proc_id, *pProcSessions, SlotIndex, *pGlobalSessions );
	    #endif /* DEV */
	    *pGlobalSessions = 0;
	  } else {
	    *pGlobalSessions -= *pProcSessions;
	  }

	  *pProcSessions = 0;

	} /* end if *pProcSessions */

      } /* end for SlotIndex */


      /*                                      */
      /* NULL out everything except the mutex */
      /*                                      */

#if PER_PROCESS_MUTEXES
        /* Grab the mutex for this proc's shared memory data structure */

#ifdef PKCS64
        Err = msem_lock(&(pProc->proc_mutex),MSEM_IF_NOWAIT);
#else 
        Err = pthread_mutex_trylock( &(pProc->proc_mutex) );
#endif

	if ( ( Err != 0 ) ) {
	  /* We didn't get the lock! */
	  /* Attempting to destroy a locked mutex results in undefined behavior */
	  /* http://techlib.austin.ibm.com/techlib/manuals/adoclib/libs/basetrf1/pthreads.htm */
	  DbgLog (DL0,"Unable to get per-process mutex for pid %d (%s) - skipping", pProc->proc_id, SysConst( Err ) );

	  /* 
	     The exit routine will figure out that this is an invalid process entry
	     (by calling IsValidProcessEntry()), and won't prevent the slotd from exiting
	     because of this entry.
	     */

	  continue;
	}
#endif /* PER_PROCESS_MUTEXES */

      memset( &(pProc->inuse),              '\0', sizeof(pProc->inuse) );
      memset( &(pProc->proc_id),            '\0', sizeof(pProc->proc_id) );
      memset( &(pProc->slotmap),            '\0', sizeof(pProc->slotmap) );
      memset( &(pProc->blocking),           '\0', sizeof(pProc->blocking ));
      memset( &(pProc->error),              '\0', sizeof(pProc->error) );
      memset( &(pProc->slot_session_count), '\0', sizeof(pProc->slot_session_count) );
      memset( &(pProc->reg_time),           '\0', sizeof(pProc->reg_time) );

    } /* end if inuse && ValidPid */
    

    #if PER_PROCESS_MUTEXES

#ifdef PKCS64 
      msem_unlock(&(pProc->proc_mutex),0)
    
#else
      pthread_mutex_unlock( &(pProc->proc_mutex));
#endif

    #endif /* PER_PROCESS_MUTEXES  */
   
    
  } /* end for ProcIndex */
  
#if 1
  XProcUnLock(&(MemPtr->slt_mutex));
#else
#ifdef PKCS64
  msem_unlock(&(MemPtr->slt_mutex),0);
#else
  pthread_mutex_unlock ( &(MemPtr->slt_mutex) );
#endif
#endif

  DbgLog ( DL5, "Garbage collection: Released global shared memory lock");

  return TRUE;
  
}



/*********************************************************************************
 * Stat2Proc -
 * 
 *     Fills a proc_t structure (defined in garbage_linux.h)
 *     with a given pid's stat information found in the /proc/<pid>/stat file
 * 
 *********************************************************************************/

int Stat2Proc (int pid, proc_t *p) {

  char buf[800];  // about 40 fields, 64-bit decimal is about 20 chars
  char fbuf[800];  // about 40 fields, 64-bit decimal is about 20 chars
  char *tmp;
  int fd, num;
  //  FILE *fp;

  //  sprintf(buf, "%s/%d/stat", PROC_BASE, pid);  
  //  if( (fp = fopen(buf, "r")) == NULL )
  //    return FALSE;

  sprintf(fbuf, "%s/%d/stat", PROC_BASE, pid);  
  printf("Buff = %s \n",fbuf); fflush(stdout);
  if( (fd = open(fbuf, O_RDONLY, 0)) == -1)
    return FALSE;

  num = read(fd, buf, 800);

  close(fd);

  if(num < 80)
    return FALSE;

  // buf[num] = '\0';
  
  tmp = strrchr(buf, ')');                      // split into "PID (cmd" and "<rest>"
  *tmp = (char)NULL;                            // replacing trailing ')' with NULL
  // Tmp now points to the rest of the buffer.
  // buff points to the command...
  

  /* fill in default values for older kernels */
  p->exit_signal = SIGCHLD;
  p->processor = 0;

  /* now parse the two strings, tmp & buf, separately, skipping the leading "(" */
  memset(p->cmd, 0, sizeof(p->cmd));
  sscanf(buf, "%d (%15c", &p->pid, p->cmd);      // comm[16] in kernel
  num = sscanf(tmp + 2,                         // skip space after ')' as well
	       "%c "
	       "%d %d %d %d %d "
	       "%lu %lu %lu %lu %lu %lu %lu "
	       "%ld %ld %ld %ld %ld %ld "
	       "%lu %lu "
	       "%ld "
	       "%lu %lu %lu %lu %lu %lu "
	       "%*s %*s %*s %*s "               // discard, no RT signals & Linux 2.1 used hex (no use for RT signals)
	       "%lu %lu %lu "
	       "%d %d",
	       &p->state,
	       &p->ppid, &p->pgrp, &p->session, &p->tty, &p->tpgid,
	       &p->flags, &p->min_flt, &p->cmin_flt, &p->maj_flt, &p->cmaj_flt, &p->utime, &p->stime,
	       &p->cutime, &p->cstime, &p->priority, &p->nice, &p->timeout, &p->it_real_value,
	       &p->start_time, &p->vsize,
	       &p->rss,
	       &p->rss_rlim, &p->start_code, &p->end_code, &p->start_stack, &p->kstk_esp, &p->kstk_eip,
	       /*  p->signal, p->blocked, p->sigignore, p->sigcatch,  */ /* can't use */
	       &p->wchan, &p->nswap, &p->cnswap,
	       /* -- Linux 2.0.35 ends here -- */
	       &p->exit_signal, &p->processor  /* 2.2.1 ends with "exit_signal" */
	       /* -- Linux 2.2.8 and 2.3.47 end here -- */
	       );
  
  /* fprintf(stderr, "Stat2Proc() converted %d fields.\n", num); */
  if (p->tty == 0)
    p->tty = -1;     // the old notty val, updated elsewhere before moving to 0
  
  p->vsize /= 1024;
  
  if(num < 30)
    return FALSE;
  if(p->pid != pid)
    return FALSE;
  
  return TRUE;
  
}



/*********************************************************************************
 * IsValidProcessEntry -
 * 
 *     Checks to see if the process identifed by pid is the same process
 *     that registered with us
 * 
 *********************************************************************************/

#ifdef PKCS64
BOOL IsValidProcessEntry ( pid_t_64 pid, time_t_64 RegTime ) {
#else
BOOL IsValidProcessEntry ( pid_t pid, time_t RegTime ) {
#endif

  int                    Err;

  int valid;
  proc_t *p;
  proc_t procstore;

  /* If kill(pid, 0) returns -1 and errno/Err = ESRCH, the pid doesn't exist */
  if ( kill(pid, 0) == -1 ) {
    Err = errno;
    if ( Err == ESRCH ) {
      /* The process was not found */
      DbgLog(DL3, "IsValidProcessEntry: PID %d was not found in the process table (kill() returned %s)", pid, SysConst(Err) );
      return FALSE;
    } else {
      /* some other error occurred */
      DbgLog(DL3, "IsValidProcessEntry: kill() returned %s (%d; %#x)", SysConst(Err), Err, Err);
      return FALSE;
    }
  } /* end if kill */

  /* Okay, the process exists, now we see if it's really ours */

#ifdef ALLOCATE
  p = (proc_t *)malloc(sizeof(proc_t));
#else
  p = &procstore;
  memset(p, 0, sizeof(proc_t));
#endif

  if( !(valid = Stat2Proc( (int)pid, p )) )
    return FALSE;
    
  if ( p->pid == pid ) {
    if ( RegTime >= p->start_time ) {   // checking for matching start times
      return TRUE;
    } else {
      /* p->start_time contains the time at which the process began ??  (22nd element in /proc/<pid>/stat file) */
      DbgLog(DL1, "IsValidProcessEntry: PID %d started at %lu; registered at %ld", pid, p->start_time, RegTime);
      DbgLog(DL4, "IsValidProcessEntry: PID Returned %d flags at %#x; state at %#x", p->pid, p->flags, p->state);
    }
  }

  return FALSE;

}

#endif // NO Garbage
