/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/**
 * @test
 * @bug 7175845 7199153
 * @summary jar -uf should not change file permission
 */

import java.io.*;
import sun.tools.jar.Main;

public class UpdateJar {

    private static void cleanup(File f) throws Throwable {
        if (f.exists())
            f.delete();
    }

    private static String permission(String fname) throws Throwable {
        Process p = Runtime.getRuntime().exec("ls -l " + fname);
        InputStream is = null;
        String ret = null;
        if (p != null && (is = p.getInputStream()) != null) {
            p.waitFor();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
            try {
                ret = br.readLine();
                if (ret != null)
                    ret = ret.split(" ")[0];
            } finally {
                br.close();
            }
        }
        return ret;
    }

    public static void realMain(String[] args) throws Throwable {
        if (!System.getProperty("os.name").startsWith("Windows")) {
            String jarName = "testUpdateJar.jar";
            String e0Name = "testUpdateJar_entry0.txt";
            String e1Name = "testUpdateJar_entry1.txt";

            File jar = new File(jarName);
            File e0 = new File(e0Name);
            File e1 = new File(e1Name);
            try {
                cleanup(jar);
                cleanup(e0);
                cleanup(e1);

                FileOutputStream fos = new FileOutputStream(e0Name);
                fos.write(0);
                fos.close();

                fos = new FileOutputStream(e1Name);
                fos.write(0);
                fos.close();

                String[] jarArgs = new String[] {"cfM0", jarName, e0Name};
                if (!new Main(System.out, System.err, "jar").run(jarArgs)) {
                    fail("Could not create jar file.");
                }
                String pm = permission(jarName);
                jarArgs = new String[] {"uf", jarName, e1Name};
                if (!new Main(System.out, System.err, "jar").run(jarArgs)) {
                    fail("Could not create jar file.");
                }
                equal(pm, permission(jarName));

            } finally {
                cleanup(jar);
                cleanup(e0);
                cleanup(e1);

            }
        }
    }

    //--------------------- Infrastructure ---------------------------
    static volatile int passed = 0, failed = 0;
    static void pass() {passed++;}
    static void fail() {failed++; Thread.dumpStack();}
    static void fail(String msg) {System.out.println(msg); fail();}
    static void unexpected(Throwable t) {failed++; t.printStackTrace();}
    static void check(boolean cond) {if (cond) pass(); else fail();}
    static void equal(Object x, Object y) {
        if (x == null ? y == null : x.equals(y)) pass();
        else fail(x + " not equal to " + y);}
    public static void main(String[] args) throws Throwable {
        try {realMain(args);} catch (Throwable t) {unexpected(t);}
        System.out.println("\nPassed = " + passed + " failed = " + failed);
        if (failed > 0) throw new AssertionError("Some tests failed");}
}
