/*
 * Copyright (c) 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


/*
 * @test
 *
 * @summary converted from VM Testbase nsk/jvmti/GetLocalVariableTable/localtab005.
 * VM Testbase keywords: [quick, jpda, jvmti, onload_only_caps, noras]
 * VM Testbase readme:
 * DESCRIPTION
 *     This test checks that the JVMTI function GetLocalVariableTable()
 *     returns local variable information properly including variables with
 *     generic types.
 *     The test creates a dummy instance of tested class 'localtab005a' which
 *     must be compiled with debugging info. Then an agent part obtains the
 *     local variable table for the following methods of localtab005a:
 *         - constructor
 *         - static method statMethod()
 *         - instance method insMethod()
 *     Some local variables of these methods have generic types. The generic
 *     signature should be returned properly for these variables, and NULL for
 *     non-generic ones.
 * COMMENTS
 *
 * @library /vmTestbase
 *          /test/lib
 * @run driver jdk.test.lib.FileInstaller . .
 *
 * @comment make sure localtab005 is compiled with full debug info
 * @build nsk.jvmti.GetLocalVariableTable.localtab005
 * @clean nsk.jvmti.GetLocalVariableTable.localtab005
 * @compile -g:lines,source,vars ../localtab005.java
 *
 * @run main/othervm/native
 *      -agentlib:localtab005=-waittime=5
 *      nsk.jvmti.GetLocalVariableTable.localtab005
 */

