/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc;

import com.google.javascript.rhino.head.ast.AstNode;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.chromium.devtools.jsdoc.ScriptText;

public class ValidatorContext {
    private static final Comparator<MessageRecord> MESSAGE_RECORD_COMPARATOR = new Comparator<MessageRecord>(){

        @Override
        public int compare(MessageRecord messageRecord, MessageRecord messageRecord2) {
            return messageRecord.position - messageRecord2.position;
        }
    };
    public final ScriptText scriptText;
    public final String scriptFileName;
    private final SortedSet<MessageRecord> validationResult = new TreeSet<MessageRecord>(MESSAGE_RECORD_COMPARATOR);

    public ValidatorContext(ScriptText scriptText, String string) {
        this.scriptText = scriptText;
        this.scriptFileName = string;
    }

    public SortedSet<MessageRecord> getValidationResult() {
        return Collections.unmodifiableSortedSet(this.validationResult);
    }

    public String getNodeText(AstNode astNode) {
        if (astNode == null) {
            return null;
        }
        return this.scriptText.text.substring(astNode.getAbsolutePosition(), astNode.getAbsolutePosition() + astNode.getLength());
    }

    public SourcePosition getPosition(AstNode astNode, int n) {
        String string = this.getNodeText(astNode);
        if (n >= string.length()) {
            return null;
        }
        int n2 = astNode.getLineno();
        int n3 = this.scriptText.getColumn(astNode.getAbsolutePosition());
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                ++n2;
                n3 = 0;
                continue;
            }
            ++n3;
        }
        return new SourcePosition(n2, n3);
    }

    public void reportErrorInNode(AstNode astNode, int n, String string) {
        int n2;
        SourcePosition sourcePosition = this.getPosition(astNode, n);
        if (sourcePosition == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(sourcePosition.column + 1);
        for (n2 = sourcePosition.column; n2 > 0; --n2) {
            stringBuilder.append(' ');
        }
        stringBuilder.append('^');
        n2 = astNode.getAbsolutePosition() + n;
        String string2 = String.format("%s:%d: ERROR - %s%n%s%n%s%n", this.scriptFileName, sourcePosition.line, string, this.scriptText.getLineTextAt(n2), stringBuilder.toString());
        this.validationResult.add(new MessageRecord(n2, string2));
    }

    public static class SourcePosition {
        public final int line;
        public final int column;

        public SourcePosition(int n, int n2) {
            this.line = n;
            this.column = n2;
        }
    }

    public static class MessageRecord {
        public final int position;
        public final String text;

        public MessageRecord(int n, String string) {
            this.position = n;
            this.text = string;
        }
    }
}

