#ifndef INCLUDE_MODULE_CDROM_H
#define INCLUDE_MODULE_CDROM_H
/* ----------------------------------------------------------------------------
 * module_cdrom.h
 * prototypes and definitions for the CDROM module.
 *
 * Copyright 2002-2005 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <pbbtaglist.h>

#define DEFAULT_CDROM	"/dev/cdrom"

/* public prototypes */
int cdrom_init ();
void cdrom_exit ();

/* private prototypes */
void cdrom_keyboard (struct tagitem *taglist);
void cdrom_query (struct tagitem *taglist);
void cdrom_configure (struct tagitem *taglist);
void cdrom_handle_tags (int cfgure, struct tagitem *taglist);
char *cdrom_getmountpoint(char *device);
int cdrom_eject ();
unsigned int cdrom_gettime ();
void cdrom_testperformance ();

#endif    /* INCLUDE_MODULE_CDROM_H */
