#line 2 "scan.c"
/*-------------------------------------------------------------------------
 *
 * scan.l
 *	  lexical scanner for PostgreSQL
 *
 * NOTE NOTE NOTE:
 *
 * The rules in this file must be kept in sync with src/fe_utils/psqlscan.l
 * and src/interfaces/ecpg/preproc/pgc.l!
 *
 * The rules are designed so that the scanner never has to backtrack,
 * in the sense that there is always a rule that can match the input
 * consumed so far (the rule action may internally throw back some input
 * with yyless(), however).  As explained in the flex manual, this makes
 * for a useful speed increase --- about a third faster than a plain -CF
 * lexer, in simple testing.  The extra complexity is mostly in the rules
 * for handling float numbers and continued string literals.  If you change
 * the lexical rules, verify that you haven't broken the no-backtrack
 * property by running flex with the "-b" option and checking that the
 * resulting "lex.backup" file says that no backing up is needed.  (As of
 * Postgres 9.2, this check is made automatically by the Makefile.)
 *
 *
 * Portions Copyright (c) 1996-2019, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * IDENTIFICATION
 *	  src/backend/parser/scan.l
 *
 *-------------------------------------------------------------------------
 */
#include "postgres.h"

#include <ctype.h>
#include <unistd.h>

#include "common/string.h"
#include "parser/gramparse.h"
#include "parser/parser.h"		/* only needed for GUC variables */
#include "parser/scansup.h"
#include "mb/pg_wchar.h"

#line 45 "scan.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define core_yy_create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer core_yy_create_buffer
#endif

#ifdef yy_delete_buffer
#define core_yy_delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer core_yy_delete_buffer
#endif

#ifdef yy_scan_buffer
#define core_yy_scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer core_yy_scan_buffer
#endif

#ifdef yy_scan_string
#define core_yy_scan_string_ALREADY_DEFINED
#else
#define yy_scan_string core_yy_scan_string
#endif

#ifdef yy_scan_bytes
#define core_yy_scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes core_yy_scan_bytes
#endif

#ifdef yy_init_buffer
#define core_yy_init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer core_yy_init_buffer
#endif

#ifdef yy_flush_buffer
#define core_yy_flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer core_yy_flush_buffer
#endif

#ifdef yy_load_buffer_state
#define core_yy_load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state core_yy_load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define core_yy_switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer core_yy_switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define core_yypush_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state core_yypush_buffer_state
#endif

#ifdef yypop_buffer_state
#define core_yypop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state core_yypop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define core_yyensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack core_yyensure_buffer_stack
#endif

#ifdef yylex
#define core_yylex_ALREADY_DEFINED
#else
#define yylex core_yylex
#endif

#ifdef yyrestart
#define core_yyrestart_ALREADY_DEFINED
#else
#define yyrestart core_yyrestart
#endif

#ifdef yylex_init
#define core_yylex_init_ALREADY_DEFINED
#else
#define yylex_init core_yylex_init
#endif

#ifdef yylex_init_extra
#define core_yylex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra core_yylex_init_extra
#endif

#ifdef yylex_destroy
#define core_yylex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy core_yylex_destroy
#endif

#ifdef yyget_debug
#define core_yyget_debug_ALREADY_DEFINED
#else
#define yyget_debug core_yyget_debug
#endif

#ifdef yyset_debug
#define core_yyset_debug_ALREADY_DEFINED
#else
#define yyset_debug core_yyset_debug
#endif

#ifdef yyget_extra
#define core_yyget_extra_ALREADY_DEFINED
#else
#define yyget_extra core_yyget_extra
#endif

#ifdef yyset_extra
#define core_yyset_extra_ALREADY_DEFINED
#else
#define yyset_extra core_yyset_extra
#endif

#ifdef yyget_in
#define core_yyget_in_ALREADY_DEFINED
#else
#define yyget_in core_yyget_in
#endif

#ifdef yyset_in
#define core_yyset_in_ALREADY_DEFINED
#else
#define yyset_in core_yyset_in
#endif

#ifdef yyget_out
#define core_yyget_out_ALREADY_DEFINED
#else
#define yyget_out core_yyget_out
#endif

#ifdef yyset_out
#define core_yyset_out_ALREADY_DEFINED
#else
#define yyset_out core_yyset_out
#endif

#ifdef yyget_leng
#define core_yyget_leng_ALREADY_DEFINED
#else
#define yyget_leng core_yyget_leng
#endif

#ifdef yyget_text
#define core_yyget_text_ALREADY_DEFINED
#else
#define yyget_text core_yyget_text
#endif

#ifdef yyget_lineno
#define core_yyget_lineno_ALREADY_DEFINED
#else
#define yyget_lineno core_yyget_lineno
#endif

#ifdef yyset_lineno
#define core_yyset_lineno_ALREADY_DEFINED
#else
#define yyset_lineno core_yyset_lineno
#endif

#ifdef yyget_column
#define core_yyget_column_ALREADY_DEFINED
#else
#define yyget_column core_yyget_column
#endif

#ifdef yyset_column
#define core_yyset_column_ALREADY_DEFINED
#else
#define yyset_column core_yyset_column
#endif

#ifdef yywrap
#define core_yywrap_ALREADY_DEFINED
#else
#define yywrap core_yywrap
#endif

#ifdef yyget_lval
#define core_yyget_lval_ALREADY_DEFINED
#else
#define yyget_lval core_yyget_lval
#endif

#ifdef yyset_lval
#define core_yyset_lval_ALREADY_DEFINED
#else
#define yyset_lval core_yyset_lval
#endif

#ifdef yyget_lloc
#define core_yyget_lloc_ALREADY_DEFINED
#else
#define yyget_lloc core_yyget_lloc
#endif

#ifdef yyset_lloc
#define core_yyset_lloc_ALREADY_DEFINED
#else
#define yyset_lloc core_yyset_lloc
#endif

#ifdef yyalloc
#define core_yyalloc_ALREADY_DEFINED
#else
#define yyalloc core_yyalloc
#endif

#ifdef yyrealloc
#define core_yyrealloc_ALREADY_DEFINED
#else
#define yyrealloc core_yyrealloc
#endif

#ifdef yyfree
#define core_yyfree_ALREADY_DEFINED
#else
#define yyfree core_yyfree
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin , yyscanner )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void yyrestart ( FILE *input_file , yyscan_t yyscanner );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size , yyscan_t yyscanner );
void yy_delete_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yy_flush_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
void yypop_buffer_state ( yyscan_t yyscanner );

static void yyensure_buffer_stack ( yyscan_t yyscanner );
static void yy_load_buffer_state ( yyscan_t yyscanner );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file , yyscan_t yyscanner );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER , yyscanner)

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len , yyscan_t yyscanner );

void *yyalloc ( yy_size_t , yyscan_t yyscanner );
void *yyrealloc ( void *, yy_size_t , yyscan_t yyscanner );
void yyfree ( void * , yyscan_t yyscanner );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define core_yywrap(yyscanner) (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

typedef const struct yy_trans_info *yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state ( yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  , yyscan_t yyscanner);
static int yy_get_next_buffer ( yyscan_t yyscanner );
static void yynoreturn yy_fatal_error ( const char* msg , yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;
#define YY_NUM_RULES 79
#define YY_END_OF_BUFFER 80
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const struct yy_trans_info yy_transition[37045] =
    {
 {   0,   0 }, {   0,36789 }, {   0,   0 }, {   0,36787 }, {   1,6708 },
 {   2,6708 }, {   3,6708 }, {   4,6708 }, {   5,6708 }, {   6,6708 },
 {   7,6708 }, {   8,6708 }, {   9,6710 }, {  10,6715 }, {  11,6708 },
 {  12,6710 }, {  13,6710 }, {  14,6708 }, {  15,6708 }, {  16,6708 },
 {  17,6708 }, {  18,6708 }, {  19,6708 }, {  20,6708 }, {  21,6708 },
 {  22,6708 }, {  23,6708 }, {  24,6708 }, {  25,6708 }, {  26,6708 },
 {  27,6708 }, {  28,6708 }, {  29,6708 }, {  30,6708 }, {  31,6708 },
 {  32,6710 }, {  33,6717 }, {  34,6712 }, {  35,6757 }, {  36,6823 },
 {  37,7080 }, {  38,6757 }, {  39,6730 }, {  40,6732 }, {  41,6732 },
 {  42,7080 }, {  43,7080 }, {  44,6732 }, {  45,7091 }, {  46,7110 },

 {  47,7181 }, {  48,7183 }, {  49,7183 }, {  50,7183 }, {  51,7183 },
 {  52,7183 }, {  53,7183 }, {  54,7183 }, {  55,7183 }, {  56,7183 },
 {  57,7183 }, {  58,6735 }, {  59,6732 }, {  60,7248 }, {  61,7259 },
 {  62,7326 }, {  63,6757 }, {  64,6757 }, {  65,7358 }, {  66,7615 },
 {  67,7358 }, {  68,7358 }, {  69,7872 }, {  70,7358 }, {  71,7358 },
 {  72,7358 }, {  73,7358 }, {  74,7358 }, {  75,7358 }, {  76,7358 },
 {  77,7358 }, {  78,8129 }, {  79,7358 }, {  80,7358 }, {  81,7358 },
 {  82,7358 }, {  83,7358 }, {  84,7358 }, {  85,8386 }, {  86,7358 },
 {  87,7358 }, {  88,8643 }, {  89,7358 }, {  90,7358 }, {  91,6732 },
 {  92,6708 }, {  93,6732 }, {  94,7080 }, {  95,7358 }, {  96,6757 },

 {  97,7358 }, {  98,7615 }, {  99,7358 }, { 100,7358 }, { 101,7872 },
 { 102,7358 }, { 103,7358 }, { 104,7358 }, { 105,7358 }, { 106,7358 },
 { 107,7358 }, { 108,7358 }, { 109,7358 }, { 110,8129 }, { 111,7358 },
 { 112,7358 }, { 113,7358 }, { 114,7358 }, { 115,7358 }, { 116,7358 },
 { 117,8386 }, { 118,7358 }, { 119,7358 }, { 120,8643 }, { 121,7358 },
 { 122,7358 }, { 123,6708 }, { 124,6757 }, { 125,6708 }, { 126,6757 },
 { 127,6708 }, { 128,7358 }, { 129,7358 }, { 130,7358 }, { 131,7358 },
 { 132,7358 }, { 133,7358 }, { 134,7358 }, { 135,7358 }, { 136,7358 },
 { 137,7358 }, { 138,7358 }, { 139,7358 }, { 140,7358 }, { 141,7358 },
 { 142,7358 }, { 143,7358 }, { 144,7358 }, { 145,7358 }, { 146,7358 },

 { 147,7358 }, { 148,7358 }, { 149,7358 }, { 150,7358 }, { 151,7358 },
 { 152,7358 }, { 153,7358 }, { 154,7358 }, { 155,7358 }, { 156,7358 },
 { 157,7358 }, { 158,7358 }, { 159,7358 }, { 160,7358 }, { 161,7358 },
 { 162,7358 }, { 163,7358 }, { 164,7358 }, { 165,7358 }, { 166,7358 },
 { 167,7358 }, { 168,7358 }, { 169,7358 }, { 170,7358 }, { 171,7358 },
 { 172,7358 }, { 173,7358 }, { 174,7358 }, { 175,7358 }, { 176,7358 },
 { 177,7358 }, { 178,7358 }, { 179,7358 }, { 180,7358 }, { 181,7358 },
 { 182,7358 }, { 183,7358 }, { 184,7358 }, { 185,7358 }, { 186,7358 },
 { 187,7358 }, { 188,7358 }, { 189,7358 }, { 190,7358 }, { 191,7358 },
 { 192,7358 }, { 193,7358 }, { 194,7358 }, { 195,7358 }, { 196,7358 },

 { 197,7358 }, { 198,7358 }, { 199,7358 }, { 200,7358 }, { 201,7358 },
 { 202,7358 }, { 203,7358 }, { 204,7358 }, { 205,7358 }, { 206,7358 },
 { 207,7358 }, { 208,7358 }, { 209,7358 }, { 210,7358 }, { 211,7358 },
 { 212,7358 }, { 213,7358 }, { 214,7358 }, { 215,7358 }, { 216,7358 },
 { 217,7358 }, { 218,7358 }, { 219,7358 }, { 220,7358 }, { 221,7358 },
 { 222,7358 }, { 223,7358 }, { 224,7358 }, { 225,7358 }, { 226,7358 },
 { 227,7358 }, { 228,7358 }, { 229,7358 }, { 230,7358 }, { 231,7358 },
 { 232,7358 }, { 233,7358 }, { 234,7358 }, { 235,7358 }, { 236,7358 },
 { 237,7358 }, { 238,7358 }, { 239,7358 }, { 240,7358 }, { 241,7358 },
 { 242,7358 }, { 243,7358 }, { 244,7358 }, { 245,7358 }, { 246,7358 },

 { 247,7358 }, { 248,7358 }, { 249,7358 }, { 250,7358 }, { 251,7358 },
 { 252,7358 }, { 253,7358 }, { 254,7358 }, { 255,7358 }, { 256,6708 },
 {   0,   0 }, {   0,36529 }, {   1,6450 }, {   2,6450 }, {   3,6450 },
 {   4,6450 }, {   5,6450 }, {   6,6450 }, {   7,6450 }, {   8,6450 },
 {   9,6452 }, {  10,6457 }, {  11,6450 }, {  12,6452 }, {  13,6452 },
 {  14,6450 }, {  15,6450 }, {  16,6450 }, {  17,6450 }, {  18,6450 },
 {  19,6450 }, {  20,6450 }, {  21,6450 }, {  22,6450 }, {  23,6450 },
 {  24,6450 }, {  25,6450 }, {  26,6450 }, {  27,6450 }, {  28,6450 },
 {  29,6450 }, {  30,6450 }, {  31,6450 }, {  32,6452 }, {  33,6459 },
 {  34,6454 }, {  35,6499 }, {  36,6565 }, {  37,6822 }, {  38,6499 },

 {  39,6472 }, {  40,6474 }, {  41,6474 }, {  42,6822 }, {  43,6822 },
 {  44,6474 }, {  45,6833 }, {  46,6852 }, {  47,6923 }, {  48,6925 },
 {  49,6925 }, {  50,6925 }, {  51,6925 }, {  52,6925 }, {  53,6925 },
 {  54,6925 }, {  55,6925 }, {  56,6925 }, {  57,6925 }, {  58,6477 },
 {  59,6474 }, {  60,6990 }, {  61,7001 }, {  62,7068 }, {  63,6499 },
 {  64,6499 }, {  65,7100 }, {  66,7357 }, {  67,7100 }, {  68,7100 },
 {  69,7614 }, {  70,7100 }, {  71,7100 }, {  72,7100 }, {  73,7100 },
 {  74,7100 }, {  75,7100 }, {  76,7100 }, {  77,7100 }, {  78,7871 },
 {  79,7100 }, {  80,7100 }, {  81,7100 }, {  82,7100 }, {  83,7100 },
 {  84,7100 }, {  85,8128 }, {  86,7100 }, {  87,7100 }, {  88,8385 },

 {  89,7100 }, {  90,7100 }, {  91,6474 }, {  92,6450 }, {  93,6474 },
 {  94,6822 }, {  95,7100 }, {  96,6499 }, {  97,7100 }, {  98,7357 },
 {  99,7100 }, { 100,7100 }, { 101,7614 }, { 102,7100 }, { 103,7100 },
 { 104,7100 }, { 105,7100 }, { 106,7100 }, { 107,7100 }, { 108,7100 },
 { 109,7100 }, { 110,7871 }, { 111,7100 }, { 112,7100 }, { 113,7100 },
 { 114,7100 }, { 115,7100 }, { 116,7100 }, { 117,8128 }, { 118,7100 },
 { 119,7100 }, { 120,8385 }, { 121,7100 }, { 122,7100 }, { 123,6450 },
 { 124,6499 }, { 125,6450 }, { 126,6499 }, { 127,6450 }, { 128,7100 },
 { 129,7100 }, { 130,7100 }, { 131,7100 }, { 132,7100 }, { 133,7100 },
 { 134,7100 }, { 135,7100 }, { 136,7100 }, { 137,7100 }, { 138,7100 },

 { 139,7100 }, { 140,7100 }, { 141,7100 }, { 142,7100 }, { 143,7100 },
 { 144,7100 }, { 145,7100 }, { 146,7100 }, { 147,7100 }, { 148,7100 },
 { 149,7100 }, { 150,7100 }, { 151,7100 }, { 152,7100 }, { 153,7100 },
 { 154,7100 }, { 155,7100 }, { 156,7100 }, { 157,7100 }, { 158,7100 },
 { 159,7100 }, { 160,7100 }, { 161,7100 }, { 162,7100 }, { 163,7100 },
 { 164,7100 }, { 165,7100 }, { 166,7100 }, { 167,7100 }, { 168,7100 },
 { 169,7100 }, { 170,7100 }, { 171,7100 }, { 172,7100 }, { 173,7100 },
 { 174,7100 }, { 175,7100 }, { 176,7100 }, { 177,7100 }, { 178,7100 },
 { 179,7100 }, { 180,7100 }, { 181,7100 }, { 182,7100 }, { 183,7100 },
 { 184,7100 }, { 185,7100 }, { 186,7100 }, { 187,7100 }, { 188,7100 },

 { 189,7100 }, { 190,7100 }, { 191,7100 }, { 192,7100 }, { 193,7100 },
 { 194,7100 }, { 195,7100 }, { 196,7100 }, { 197,7100 }, { 198,7100 },
 { 199,7100 }, { 200,7100 }, { 201,7100 }, { 202,7100 }, { 203,7100 },
 { 204,7100 }, { 205,7100 }, { 206,7100 }, { 207,7100 }, { 208,7100 },
 { 209,7100 }, { 210,7100 }, { 211,7100 }, { 212,7100 }, { 213,7100 },
 { 214,7100 }, { 215,7100 }, { 216,7100 }, { 217,7100 }, { 218,7100 },
 { 219,7100 }, { 220,7100 }, { 221,7100 }, { 222,7100 }, { 223,7100 },
 { 224,7100 }, { 225,7100 }, { 226,7100 }, { 227,7100 }, { 228,7100 },
 { 229,7100 }, { 230,7100 }, { 231,7100 }, { 232,7100 }, { 233,7100 },
 { 234,7100 }, { 235,7100 }, { 236,7100 }, { 237,7100 }, { 238,7100 },

 { 239,7100 }, { 240,7100 }, { 241,7100 }, { 242,7100 }, { 243,7100 },
 { 244,7100 }, { 245,7100 }, { 246,7100 }, { 247,7100 }, { 248,7100 },
 { 249,7100 }, { 250,7100 }, { 251,7100 }, { 252,7100 }, { 253,7100 },
 { 254,7100 }, { 255,7100 }, { 256,6450 }, {   0,  12 }, {   0,36271 },
 {   1,8384 }, {   2,8384 }, {   3,8384 }, {   4,8384 }, {   5,8384 },
 {   6,8384 }, {   7,8384 }, {   8,8384 }, {   9,8384 }, {  10,8384 },
 {  11,8384 }, {  12,8384 }, {  13,8384 }, {  14,8384 }, {  15,8384 },
 {  16,8384 }, {  17,8384 }, {  18,8384 }, {  19,8384 }, {  20,8384 },
 {  21,8384 }, {  22,8384 }, {  23,8384 }, {  24,8384 }, {  25,8384 },
 {  26,8384 }, {  27,8384 }, {  28,8384 }, {  29,8384 }, {  30,8384 },

 {  31,8384 }, {  32,8384 }, {  33,8384 }, {  34,8384 }, {  35,8384 },
 {  36,8384 }, {  37,8384 }, {  38,8384 }, {  39,8642 }, {  40,8384 },
 {  41,8384 }, {  42,8384 }, {  43,8384 }, {  44,8384 }, {  45,8384 },
 {  46,8384 }, {  47,8384 }, {  48,8384 }, {  49,8384 }, {  50,8384 },
 {  51,8384 }, {  52,8384 }, {  53,8384 }, {  54,8384 }, {  55,8384 },
 {  56,8384 }, {  57,8384 }, {  58,8384 }, {  59,8384 }, {  60,8384 },
 {  61,8384 }, {  62,8384 }, {  63,8384 }, {  64,8384 }, {  65,8384 },
 {  66,8384 }, {  67,8384 }, {  68,8384 }, {  69,8384 }, {  70,8384 },
 {  71,8384 }, {  72,8384 }, {  73,8384 }, {  74,8384 }, {  75,8384 },
 {  76,8384 }, {  77,8384 }, {  78,8384 }, {  79,8384 }, {  80,8384 },

 {  81,8384 }, {  82,8384 }, {  83,8384 }, {  84,8384 }, {  85,8384 },
 {  86,8384 }, {  87,8384 }, {  88,8384 }, {  89,8384 }, {  90,8384 },
 {  91,8384 }, {  92,8384 }, {  93,8384 }, {  94,8384 }, {  95,8384 },
 {  96,8384 }, {  97,8384 }, {  98,8384 }, {  99,8384 }, { 100,8384 },
 { 101,8384 }, { 102,8384 }, { 103,8384 }, { 104,8384 }, { 105,8384 },
 { 106,8384 }, { 107,8384 }, { 108,8384 }, { 109,8384 }, { 110,8384 },
 { 111,8384 }, { 112,8384 }, { 113,8384 }, { 114,8384 }, { 115,8384 },
 { 116,8384 }, { 117,8384 }, { 118,8384 }, { 119,8384 }, { 120,8384 },
 { 121,8384 }, { 122,8384 }, { 123,8384 }, { 124,8384 }, { 125,8384 },
 { 126,8384 }, { 127,8384 }, { 128,8384 }, { 129,8384 }, { 130,8384 },

 { 131,8384 }, { 132,8384 }, { 133,8384 }, { 134,8384 }, { 135,8384 },
 { 136,8384 }, { 137,8384 }, { 138,8384 }, { 139,8384 }, { 140,8384 },
 { 141,8384 }, { 142,8384 }, { 143,8384 }, { 144,8384 }, { 145,8384 },
 { 146,8384 }, { 147,8384 }, { 148,8384 }, { 149,8384 }, { 150,8384 },
 { 151,8384 }, { 152,8384 }, { 153,8384 }, { 154,8384 }, { 155,8384 },
 { 156,8384 }, { 157,8384 }, { 158,8384 }, { 159,8384 }, { 160,8384 },
 { 161,8384 }, { 162,8384 }, { 163,8384 }, { 164,8384 }, { 165,8384 },
 { 166,8384 }, { 167,8384 }, { 168,8384 }, { 169,8384 }, { 170,8384 },
 { 171,8384 }, { 172,8384 }, { 173,8384 }, { 174,8384 }, { 175,8384 },
 { 176,8384 }, { 177,8384 }, { 178,8384 }, { 179,8384 }, { 180,8384 },

 { 181,8384 }, { 182,8384 }, { 183,8384 }, { 184,8384 }, { 185,8384 },
 { 186,8384 }, { 187,8384 }, { 188,8384 }, { 189,8384 }, { 190,8384 },
 { 191,8384 }, { 192,8384 }, { 193,8384 }, { 194,8384 }, { 195,8384 },
 { 196,8384 }, { 197,8384 }, { 198,8384 }, { 199,8384 }, { 200,8384 },
 { 201,8384 }, { 202,8384 }, { 203,8384 }, { 204,8384 }, { 205,8384 },
 { 206,8384 }, { 207,8384 }, { 208,8384 }, { 209,8384 }, { 210,8384 },
 { 211,8384 }, { 212,8384 }, { 213,8384 }, { 214,8384 }, { 215,8384 },
 { 216,8384 }, { 217,8384 }, { 218,8384 }, { 219,8384 }, { 220,8384 },
 { 221,8384 }, { 222,8384 }, { 223,8384 }, { 224,8384 }, { 225,8384 },
 { 226,8384 }, { 227,8384 }, { 228,8384 }, { 229,8384 }, { 230,8384 },

 { 231,8384 }, { 232,8384 }, { 233,8384 }, { 234,8384 }, { 235,8384 },
 { 236,8384 }, { 237,8384 }, { 238,8384 }, { 239,8384 }, { 240,8384 },
 { 241,8384 }, { 242,8384 }, { 243,8384 }, { 244,8384 }, { 245,8384 },
 { 246,8384 }, { 247,8384 }, { 248,8384 }, { 249,8384 }, { 250,8384 },
 { 251,8384 }, { 252,8384 }, { 253,8384 }, { 254,8384 }, { 255,8384 },
 { 256,8384 }, {   0,  12 }, {   0,36013 }, {   1,8126 }, {   2,8126 },
 {   3,8126 }, {   4,8126 }, {   5,8126 }, {   6,8126 }, {   7,8126 },
 {   8,8126 }, {   9,8126 }, {  10,8126 }, {  11,8126 }, {  12,8126 },
 {  13,8126 }, {  14,8126 }, {  15,8126 }, {  16,8126 }, {  17,8126 },
 {  18,8126 }, {  19,8126 }, {  20,8126 }, {  21,8126 }, {  22,8126 },

 {  23,8126 }, {  24,8126 }, {  25,8126 }, {  26,8126 }, {  27,8126 },
 {  28,8126 }, {  29,8126 }, {  30,8126 }, {  31,8126 }, {  32,8126 },
 {  33,8126 }, {  34,8126 }, {  35,8126 }, {  36,8126 }, {  37,8126 },
 {  38,8126 }, {  39,8384 }, {  40,8126 }, {  41,8126 }, {  42,8126 },
 {  43,8126 }, {  44,8126 }, {  45,8126 }, {  46,8126 }, {  47,8126 },
 {  48,8126 }, {  49,8126 }, {  50,8126 }, {  51,8126 }, {  52,8126 },
 {  53,8126 }, {  54,8126 }, {  55,8126 }, {  56,8126 }, {  57,8126 },
 {  58,8126 }, {  59,8126 }, {  60,8126 }, {  61,8126 }, {  62,8126 },
 {  63,8126 }, {  64,8126 }, {  65,8126 }, {  66,8126 }, {  67,8126 },
 {  68,8126 }, {  69,8126 }, {  70,8126 }, {  71,8126 }, {  72,8126 },

 {  73,8126 }, {  74,8126 }, {  75,8126 }, {  76,8126 }, {  77,8126 },
 {  78,8126 }, {  79,8126 }, {  80,8126 }, {  81,8126 }, {  82,8126 },
 {  83,8126 }, {  84,8126 }, {  85,8126 }, {  86,8126 }, {  87,8126 },
 {  88,8126 }, {  89,8126 }, {  90,8126 }, {  91,8126 }, {  92,8126 },
 {  93,8126 }, {  94,8126 }, {  95,8126 }, {  96,8126 }, {  97,8126 },
 {  98,8126 }, {  99,8126 }, { 100,8126 }, { 101,8126 }, { 102,8126 },
 { 103,8126 }, { 104,8126 }, { 105,8126 }, { 106,8126 }, { 107,8126 },
 { 108,8126 }, { 109,8126 }, { 110,8126 }, { 111,8126 }, { 112,8126 },
 { 113,8126 }, { 114,8126 }, { 115,8126 }, { 116,8126 }, { 117,8126 },
 { 118,8126 }, { 119,8126 }, { 120,8126 }, { 121,8126 }, { 122,8126 },

 { 123,8126 }, { 124,8126 }, { 125,8126 }, { 126,8126 }, { 127,8126 },
 { 128,8126 }, { 129,8126 }, { 130,8126 }, { 131,8126 }, { 132,8126 },
 { 133,8126 }, { 134,8126 }, { 135,8126 }, { 136,8126 }, { 137,8126 },
 { 138,8126 }, { 139,8126 }, { 140,8126 }, { 141,8126 }, { 142,8126 },
 { 143,8126 }, { 144,8126 }, { 145,8126 }, { 146,8126 }, { 147,8126 },
 { 148,8126 }, { 149,8126 }, { 150,8126 }, { 151,8126 }, { 152,8126 },
 { 153,8126 }, { 154,8126 }, { 155,8126 }, { 156,8126 }, { 157,8126 },
 { 158,8126 }, { 159,8126 }, { 160,8126 }, { 161,8126 }, { 162,8126 },
 { 163,8126 }, { 164,8126 }, { 165,8126 }, { 166,8126 }, { 167,8126 },
 { 168,8126 }, { 169,8126 }, { 170,8126 }, { 171,8126 }, { 172,8126 },

 { 173,8126 }, { 174,8126 }, { 175,8126 }, { 176,8126 }, { 177,8126 },
 { 178,8126 }, { 179,8126 }, { 180,8126 }, { 181,8126 }, { 182,8126 },
 { 183,8126 }, { 184,8126 }, { 185,8126 }, { 186,8126 }, { 187,8126 },
 { 188,8126 }, { 189,8126 }, { 190,8126 }, { 191,8126 }, { 192,8126 },
 { 193,8126 }, { 194,8126 }, { 195,8126 }, { 196,8126 }, { 197,8126 },
 { 198,8126 }, { 199,8126 }, { 200,8126 }, { 201,8126 }, { 202,8126 },
 { 203,8126 }, { 204,8126 }, { 205,8126 }, { 206,8126 }, { 207,8126 },
 { 208,8126 }, { 209,8126 }, { 210,8126 }, { 211,8126 }, { 212,8126 },
 { 213,8126 }, { 214,8126 }, { 215,8126 }, { 216,8126 }, { 217,8126 },
 { 218,8126 }, { 219,8126 }, { 220,8126 }, { 221,8126 }, { 222,8126 },

 { 223,8126 }, { 224,8126 }, { 225,8126 }, { 226,8126 }, { 227,8126 },
 { 228,8126 }, { 229,8126 }, { 230,8126 }, { 231,8126 }, { 232,8126 },
 { 233,8126 }, { 234,8126 }, { 235,8126 }, { 236,8126 }, { 237,8126 },
 { 238,8126 }, { 239,8126 }, { 240,8126 }, { 241,8126 }, { 242,8126 },
 { 243,8126 }, { 244,8126 }, { 245,8126 }, { 246,8126 }, { 247,8126 },
 { 248,8126 }, { 249,8126 }, { 250,8126 }, { 251,8126 }, { 252,8126 },
 { 253,8126 }, { 254,8126 }, { 255,8126 }, { 256,8126 }, {   0,   0 },
 {   0,35755 }, {   1,8173 }, {   2,8173 }, {   3,8173 }, {   4,8173 },
 {   5,8173 }, {   6,8173 }, {   7,8173 }, {   8,8173 }, {   9,8173 },
 {  10,8173 }, {  11,8173 }, {  12,8173 }, {  13,8173 }, {  14,8173 },

 {  15,8173 }, {  16,8173 }, {  17,8173 }, {  18,8173 }, {  19,8173 },
 {  20,8173 }, {  21,8173 }, {  22,8173 }, {  23,8173 }, {  24,8173 },
 {  25,8173 }, {  26,8173 }, {  27,8173 }, {  28,8173 }, {  29,8173 },
 {  30,8173 }, {  31,8173 }, {  32,8173 }, {  33,8431 }, {  34,8173 },
 {  35,8431 }, {  36,8173 }, {  37,8431 }, {  38,8431 }, {  39,8173 },
 {  40,8173 }, {  41,8173 }, {  42,5708 }, {  43,8431 }, {  44,8173 },
 {  45,8431 }, {  46,8173 }, {  47,5712 }, {  48,8173 }, {  49,8173 },
 {  50,8173 }, {  51,8173 }, {  52,8173 }, {  53,8173 }, {  54,8173 },
 {  55,8173 }, {  56,8173 }, {  57,8173 }, {  58,8173 }, {  59,8173 },
 {  60,8431 }, {  61,8431 }, {  62,8431 }, {  63,8431 }, {  64,8431 },

 {  65,8173 }, {  66,8173 }, {  67,8173 }, {  68,8173 }, {  69,8173 },
 {  70,8173 }, {  71,8173 }, {  72,8173 }, {  73,8173 }, {  74,8173 },
 {  75,8173 }, {  76,8173 }, {  77,8173 }, {  78,8173 }, {  79,8173 },
 {  80,8173 }, {  81,8173 }, {  82,8173 }, {  83,8173 }, {  84,8173 },
 {  85,8173 }, {  86,8173 }, {  87,8173 }, {  88,8173 }, {  89,8173 },
 {  90,8173 }, {  91,8173 }, {  92,8173 }, {  93,8173 }, {  94,8431 },
 {  95,8173 }, {  96,8431 }, {  97,8173 }, {  98,8173 }, {  99,8173 },
 { 100,8173 }, { 101,8173 }, { 102,8173 }, { 103,8173 }, { 104,8173 },
 { 105,8173 }, { 106,8173 }, { 107,8173 }, { 108,8173 }, { 109,8173 },
 { 110,8173 }, { 111,8173 }, { 112,8173 }, { 113,8173 }, { 114,8173 },

 { 115,8173 }, { 116,8173 }, { 117,8173 }, { 118,8173 }, { 119,8173 },
 { 120,8173 }, { 121,8173 }, { 122,8173 }, { 123,8173 }, { 124,8431 },
 { 125,8173 }, { 126,8431 }, { 127,8173 }, { 128,8173 }, { 129,8173 },
 { 130,8173 }, { 131,8173 }, { 132,8173 }, { 133,8173 }, { 134,8173 },
 { 135,8173 }, { 136,8173 }, { 137,8173 }, { 138,8173 }, { 139,8173 },
 { 140,8173 }, { 141,8173 }, { 142,8173 }, { 143,8173 }, { 144,8173 },
 { 145,8173 }, { 146,8173 }, { 147,8173 }, { 148,8173 }, { 149,8173 },
 { 150,8173 }, { 151,8173 }, { 152,8173 }, { 153,8173 }, { 154,8173 },
 { 155,8173 }, { 156,8173 }, { 157,8173 }, { 158,8173 }, { 159,8173 },
 { 160,8173 }, { 161,8173 }, { 162,8173 }, { 163,8173 }, { 164,8173 },

 { 165,8173 }, { 166,8173 }, { 167,8173 }, { 168,8173 }, { 169,8173 },
 { 170,8173 }, { 171,8173 }, { 172,8173 }, { 173,8173 }, { 174,8173 },
 { 175,8173 }, { 176,8173 }, { 177,8173 }, { 178,8173 }, { 179,8173 },
 { 180,8173 }, { 181,8173 }, { 182,8173 }, { 183,8173 }, { 184,8173 },
 { 185,8173 }, { 186,8173 }, { 187,8173 }, { 188,8173 }, { 189,8173 },
 { 190,8173 }, { 191,8173 }, { 192,8173 }, { 193,8173 }, { 194,8173 },
 { 195,8173 }, { 196,8173 }, { 197,8173 }, { 198,8173 }, { 199,8173 },
 { 200,8173 }, { 201,8173 }, { 202,8173 }, { 203,8173 }, { 204,8173 },
 { 205,8173 }, { 206,8173 }, { 207,8173 }, { 208,8173 }, { 209,8173 },
 { 210,8173 }, { 211,8173 }, { 212,8173 }, { 213,8173 }, { 214,8173 },

 { 215,8173 }, { 216,8173 }, { 217,8173 }, { 218,8173 }, { 219,8173 },
 { 220,8173 }, { 221,8173 }, { 222,8173 }, { 223,8173 }, { 224,8173 },
 { 225,8173 }, { 226,8173 }, { 227,8173 }, { 228,8173 }, { 229,8173 },
 { 230,8173 }, { 231,8173 }, { 232,8173 }, { 233,8173 }, { 234,8173 },
 { 235,8173 }, { 236,8173 }, { 237,8173 }, { 238,8173 }, { 239,8173 },
 { 240,8173 }, { 241,8173 }, { 242,8173 }, { 243,8173 }, { 244,8173 },
 { 245,8173 }, { 246,8173 }, { 247,8173 }, { 248,8173 }, { 249,8173 },
 { 250,8173 }, { 251,8173 }, { 252,8173 }, { 253,8173 }, { 254,8173 },
 { 255,8173 }, { 256,8173 }, {   0,   0 }, {   0,35497 }, {   1,7915 },
 {   2,7915 }, {   3,7915 }, {   4,7915 }, {   5,7915 }, {   6,7915 },

 {   7,7915 }, {   8,7915 }, {   9,7915 }, {  10,7915 }, {  11,7915 },
 {  12,7915 }, {  13,7915 }, {  14,7915 }, {  15,7915 }, {  16,7915 },
 {  17,7915 }, {  18,7915 }, {  19,7915 }, {  20,7915 }, {  21,7915 },
 {  22,7915 }, {  23,7915 }, {  24,7915 }, {  25,7915 }, {  26,7915 },
 {  27,7915 }, {  28,7915 }, {  29,7915 }, {  30,7915 }, {  31,7915 },
 {  32,7915 }, {  33,8173 }, {  34,7915 }, {  35,8173 }, {  36,7915 },
 {  37,8173 }, {  38,8173 }, {  39,7915 }, {  40,7915 }, {  41,7915 },
 {  42,5450 }, {  43,8173 }, {  44,7915 }, {  45,8173 }, {  46,7915 },
 {  47,5454 }, {  48,7915 }, {  49,7915 }, {  50,7915 }, {  51,7915 },
 {  52,7915 }, {  53,7915 }, {  54,7915 }, {  55,7915 }, {  56,7915 },

 {  57,7915 }, {  58,7915 }, {  59,7915 }, {  60,8173 }, {  61,8173 },
 {  62,8173 }, {  63,8173 }, {  64,8173 }, {  65,7915 }, {  66,7915 },
 {  67,7915 }, {  68,7915 }, {  69,7915 }, {  70,7915 }, {  71,7915 },
 {  72,7915 }, {  73,7915 }, {  74,7915 }, {  75,7915 }, {  76,7915 },
 {  77,7915 }, {  78,7915 }, {  79,7915 }, {  80,7915 }, {  81,7915 },
 {  82,7915 }, {  83,7915 }, {  84,7915 }, {  85,7915 }, {  86,7915 },
 {  87,7915 }, {  88,7915 }, {  89,7915 }, {  90,7915 }, {  91,7915 },
 {  92,7915 }, {  93,7915 }, {  94,8173 }, {  95,7915 }, {  96,8173 },
 {  97,7915 }, {  98,7915 }, {  99,7915 }, { 100,7915 }, { 101,7915 },
 { 102,7915 }, { 103,7915 }, { 104,7915 }, { 105,7915 }, { 106,7915 },

 { 107,7915 }, { 108,7915 }, { 109,7915 }, { 110,7915 }, { 111,7915 },
 { 112,7915 }, { 113,7915 }, { 114,7915 }, { 115,7915 }, { 116,7915 },
 { 117,7915 }, { 118,7915 }, { 119,7915 }, { 120,7915 }, { 121,7915 },
 { 122,7915 }, { 123,7915 }, { 124,8173 }, { 125,7915 }, { 126,8173 },
 { 127,7915 }, { 128,7915 }, { 129,7915 }, { 130,7915 }, { 131,7915 },
 { 132,7915 }, { 133,7915 }, { 134,7915 }, { 135,7915 }, { 136,7915 },
 { 137,7915 }, { 138,7915 }, { 139,7915 }, { 140,7915 }, { 141,7915 },
 { 142,7915 }, { 143,7915 }, { 144,7915 }, { 145,7915 }, { 146,7915 },
 { 147,7915 }, { 148,7915 }, { 149,7915 }, { 150,7915 }, { 151,7915 },
 { 152,7915 }, { 153,7915 }, { 154,7915 }, { 155,7915 }, { 156,7915 },

 { 157,7915 }, { 158,7915 }, { 159,7915 }, { 160,7915 }, { 161,7915 },
 { 162,7915 }, { 163,7915 }, { 164,7915 }, { 165,7915 }, { 166,7915 },
 { 167,7915 }, { 168,7915 }, { 169,7915 }, { 170,7915 }, { 171,7915 },
 { 172,7915 }, { 173,7915 }, { 174,7915 }, { 175,7915 }, { 176,7915 },
 { 177,7915 }, { 178,7915 }, { 179,7915 }, { 180,7915 }, { 181,7915 },
 { 182,7915 }, { 183,7915 }, { 184,7915 }, { 185,7915 }, { 186,7915 },
 { 187,7915 }, { 188,7915 }, { 189,7915 }, { 190,7915 }, { 191,7915 },
 { 192,7915 }, { 193,7915 }, { 194,7915 }, { 195,7915 }, { 196,7915 },
 { 197,7915 }, { 198,7915 }, { 199,7915 }, { 200,7915 }, { 201,7915 },
 { 202,7915 }, { 203,7915 }, { 204,7915 }, { 205,7915 }, { 206,7915 },

 { 207,7915 }, { 208,7915 }, { 209,7915 }, { 210,7915 }, { 211,7915 },
 { 212,7915 }, { 213,7915 }, { 214,7915 }, { 215,7915 }, { 216,7915 },
 { 217,7915 }, { 218,7915 }, { 219,7915 }, { 220,7915 }, { 221,7915 },
 { 222,7915 }, { 223,7915 }, { 224,7915 }, { 225,7915 }, { 226,7915 },
 { 227,7915 }, { 228,7915 }, { 229,7915 }, { 230,7915 }, { 231,7915 },
 { 232,7915 }, { 233,7915 }, { 234,7915 }, { 235,7915 }, { 236,7915 },
 { 237,7915 }, { 238,7915 }, { 239,7915 }, { 240,7915 }, { 241,7915 },
 { 242,7915 }, { 243,7915 }, { 244,7915 }, { 245,7915 }, { 246,7915 },
 { 247,7915 }, { 248,7915 }, { 249,7915 }, { 250,7915 }, { 251,7915 },
 { 252,7915 }, { 253,7915 }, { 254,7915 }, { 255,7915 }, { 256,7915 },

 {   0,   0 }, {   0,35239 }, {   1,8173 }, {   2,8173 }, {   3,8173 },
 {   4,8173 }, {   5,8173 }, {   6,8173 }, {   7,8173 }, {   8,8173 },
 {   9,8173 }, {  10,8173 }, {  11,8173 }, {  12,8173 }, {  13,8173 },
 {  14,8173 }, {  15,8173 }, {  16,8173 }, {  17,8173 }, {  18,8173 },
 {  19,8173 }, {  20,8173 }, {  21,8173 }, {  22,8173 }, {  23,8173 },
 {  24,8173 }, {  25,8173 }, {  26,8173 }, {  27,8173 }, {  28,8173 },
 {  29,8173 }, {  30,8173 }, {  31,8173 }, {  32,8173 }, {  33,8173 },
 {  34,5201 }, {  35,8173 }, {  36,8173 }, {  37,8173 }, {  38,8173 },
 {  39,8173 }, {  40,8173 }, {  41,8173 }, {  42,8173 }, {  43,8173 },
 {  44,8173 }, {  45,8173 }, {  46,8173 }, {  47,8173 }, {  48,8173 },

 {  49,8173 }, {  50,8173 }, {  51,8173 }, {  52,8173 }, {  53,8173 },
 {  54,8173 }, {  55,8173 }, {  56,8173 }, {  57,8173 }, {  58,8173 },
 {  59,8173 }, {  60,8173 }, {  61,8173 }, {  62,8173 }, {  63,8173 },
 {  64,8173 }, {  65,8173 }, {  66,8173 }, {  67,8173 }, {  68,8173 },
 {  69,8173 }, {  70,8173 }, {  71,8173 }, {  72,8173 }, {  73,8173 },
 {  74,8173 }, {  75,8173 }, {  76,8173 }, {  77,8173 }, {  78,8173 },
 {  79,8173 }, {  80,8173 }, {  81,8173 }, {  82,8173 }, {  83,8173 },
 {  84,8173 }, {  85,8173 }, {  86,8173 }, {  87,8173 }, {  88,8173 },
 {  89,8173 }, {  90,8173 }, {  91,8173 }, {  92,8173 }, {  93,8173 },
 {  94,8173 }, {  95,8173 }, {  96,8173 }, {  97,8173 }, {  98,8173 },

 {  99,8173 }, { 100,8173 }, { 101,8173 }, { 102,8173 }, { 103,8173 },
 { 104,8173 }, { 105,8173 }, { 106,8173 }, { 107,8173 }, { 108,8173 },
 { 109,8173 }, { 110,8173 }, { 111,8173 }, { 112,8173 }, { 113,8173 },
 { 114,8173 }, { 115,8173 }, { 116,8173 }, { 117,8173 }, { 118,8173 },
 { 119,8173 }, { 120,8173 }, { 121,8173 }, { 122,8173 }, { 123,8173 },
 { 124,8173 }, { 125,8173 }, { 126,8173 }, { 127,8173 }, { 128,8173 },
 { 129,8173 }, { 130,8173 }, { 131,8173 }, { 132,8173 }, { 133,8173 },
 { 134,8173 }, { 135,8173 }, { 136,8173 }, { 137,8173 }, { 138,8173 },
 { 139,8173 }, { 140,8173 }, { 141,8173 }, { 142,8173 }, { 143,8173 },
 { 144,8173 }, { 145,8173 }, { 146,8173 }, { 147,8173 }, { 148,8173 },

 { 149,8173 }, { 150,8173 }, { 151,8173 }, { 152,8173 }, { 153,8173 },
 { 154,8173 }, { 155,8173 }, { 156,8173 }, { 157,8173 }, { 158,8173 },
 { 159,8173 }, { 160,8173 }, { 161,8173 }, { 162,8173 }, { 163,8173 },
 { 164,8173 }, { 165,8173 }, { 166,8173 }, { 167,8173 }, { 168,8173 },
 { 169,8173 }, { 170,8173 }, { 171,8173 }, { 172,8173 }, { 173,8173 },
 { 174,8173 }, { 175,8173 }, { 176,8173 }, { 177,8173 }, { 178,8173 },
 { 179,8173 }, { 180,8173 }, { 181,8173 }, { 182,8173 }, { 183,8173 },
 { 184,8173 }, { 185,8173 }, { 186,8173 }, { 187,8173 }, { 188,8173 },
 { 189,8173 }, { 190,8173 }, { 191,8173 }, { 192,8173 }, { 193,8173 },
 { 194,8173 }, { 195,8173 }, { 196,8173 }, { 197,8173 }, { 198,8173 },

 { 199,8173 }, { 200,8173 }, { 201,8173 }, { 202,8173 }, { 203,8173 },
 { 204,8173 }, { 205,8173 }, { 206,8173 }, { 207,8173 }, { 208,8173 },
 { 209,8173 }, { 210,8173 }, { 211,8173 }, { 212,8173 }, { 213,8173 },
 { 214,8173 }, { 215,8173 }, { 216,8173 }, { 217,8173 }, { 218,8173 },
 { 219,8173 }, { 220,8173 }, { 221,8173 }, { 222,8173 }, { 223,8173 },
 { 224,8173 }, { 225,8173 }, { 226,8173 }, { 227,8173 }, { 228,8173 },
 { 229,8173 }, { 230,8173 }, { 231,8173 }, { 232,8173 }, { 233,8173 },
 { 234,8173 }, { 235,8173 }, { 236,8173 }, { 237,8173 }, { 238,8173 },
 { 239,8173 }, { 240,8173 }, { 241,8173 }, { 242,8173 }, { 243,8173 },
 { 244,8173 }, { 245,8173 }, { 246,8173 }, { 247,8173 }, { 248,8173 },

 { 249,8173 }, { 250,8173 }, { 251,8173 }, { 252,8173 }, { 253,8173 },
 { 254,8173 }, { 255,8173 }, { 256,8173 }, {   0,   0 }, {   0,34981 },
 {   1,7915 }, {   2,7915 }, {   3,7915 }, {   4,7915 }, {   5,7915 },
 {   6,7915 }, {   7,7915 }, {   8,7915 }, {   9,7915 }, {  10,7915 },
 {  11,7915 }, {  12,7915 }, {  13,7915 }, {  14,7915 }, {  15,7915 },
 {  16,7915 }, {  17,7915 }, {  18,7915 }, {  19,7915 }, {  20,7915 },
 {  21,7915 }, {  22,7915 }, {  23,7915 }, {  24,7915 }, {  25,7915 },
 {  26,7915 }, {  27,7915 }, {  28,7915 }, {  29,7915 }, {  30,7915 },
 {  31,7915 }, {  32,7915 }, {  33,7915 }, {  34,4943 }, {  35,7915 },
 {  36,7915 }, {  37,7915 }, {  38,7915 }, {  39,7915 }, {  40,7915 },

 {  41,7915 }, {  42,7915 }, {  43,7915 }, {  44,7915 }, {  45,7915 },
 {  46,7915 }, {  47,7915 }, {  48,7915 }, {  49,7915 }, {  50,7915 },
 {  51,7915 }, {  52,7915 }, {  53,7915 }, {  54,7915 }, {  55,7915 },
 {  56,7915 }, {  57,7915 }, {  58,7915 }, {  59,7915 }, {  60,7915 },
 {  61,7915 }, {  62,7915 }, {  63,7915 }, {  64,7915 }, {  65,7915 },
 {  66,7915 }, {  67,7915 }, {  68,7915 }, {  69,7915 }, {  70,7915 },
 {  71,7915 }, {  72,7915 }, {  73,7915 }, {  74,7915 }, {  75,7915 },
 {  76,7915 }, {  77,7915 }, {  78,7915 }, {  79,7915 }, {  80,7915 },
 {  81,7915 }, {  82,7915 }, {  83,7915 }, {  84,7915 }, {  85,7915 },
 {  86,7915 }, {  87,7915 }, {  88,7915 }, {  89,7915 }, {  90,7915 },

 {  91,7915 }, {  92,7915 }, {  93,7915 }, {  94,7915 }, {  95,7915 },
 {  96,7915 }, {  97,7915 }, {  98,7915 }, {  99,7915 }, { 100,7915 },
 { 101,7915 }, { 102,7915 }, { 103,7915 }, { 104,7915 }, { 105,7915 },
 { 106,7915 }, { 107,7915 }, { 108,7915 }, { 109,7915 }, { 110,7915 },
 { 111,7915 }, { 112,7915 }, { 113,7915 }, { 114,7915 }, { 115,7915 },
 { 116,7915 }, { 117,7915 }, { 118,7915 }, { 119,7915 }, { 120,7915 },
 { 121,7915 }, { 122,7915 }, { 123,7915 }, { 124,7915 }, { 125,7915 },
 { 126,7915 }, { 127,7915 }, { 128,7915 }, { 129,7915 }, { 130,7915 },
 { 131,7915 }, { 132,7915 }, { 133,7915 }, { 134,7915 }, { 135,7915 },
 { 136,7915 }, { 137,7915 }, { 138,7915 }, { 139,7915 }, { 140,7915 },

 { 141,7915 }, { 142,7915 }, { 143,7915 }, { 144,7915 }, { 145,7915 },
 { 146,7915 }, { 147,7915 }, { 148,7915 }, { 149,7915 }, { 150,7915 },
 { 151,7915 }, { 152,7915 }, { 153,7915 }, { 154,7915 }, { 155,7915 },
 { 156,7915 }, { 157,7915 }, { 158,7915 }, { 159,7915 }, { 160,7915 },
 { 161,7915 }, { 162,7915 }, { 163,7915 }, { 164,7915 }, { 165,7915 },
 { 166,7915 }, { 167,7915 }, { 168,7915 }, { 169,7915 }, { 170,7915 },
 { 171,7915 }, { 172,7915 }, { 173,7915 }, { 174,7915 }, { 175,7915 },
 { 176,7915 }, { 177,7915 }, { 178,7915 }, { 179,7915 }, { 180,7915 },
 { 181,7915 }, { 182,7915 }, { 183,7915 }, { 184,7915 }, { 185,7915 },
 { 186,7915 }, { 187,7915 }, { 188,7915 }, { 189,7915 }, { 190,7915 },

 { 191,7915 }, { 192,7915 }, { 193,7915 }, { 194,7915 }, { 195,7915 },
 { 196,7915 }, { 197,7915 }, { 198,7915 }, { 199,7915 }, { 200,7915 },
 { 201,7915 }, { 202,7915 }, { 203,7915 }, { 204,7915 }, { 205,7915 },
 { 206,7915 }, { 207,7915 }, { 208,7915 }, { 209,7915 }, { 210,7915 },
 { 211,7915 }, { 212,7915 }, { 213,7915 }, { 214,7915 }, { 215,7915 },
 { 216,7915 }, { 217,7915 }, { 218,7915 }, { 219,7915 }, { 220,7915 },
 { 221,7915 }, { 222,7915 }, { 223,7915 }, { 224,7915 }, { 225,7915 },
 { 226,7915 }, { 227,7915 }, { 228,7915 }, { 229,7915 }, { 230,7915 },
 { 231,7915 }, { 232,7915 }, { 233,7915 }, { 234,7915 }, { 235,7915 },
 { 236,7915 }, { 237,7915 }, { 238,7915 }, { 239,7915 }, { 240,7915 },

 { 241,7915 }, { 242,7915 }, { 243,7915 }, { 244,7915 }, { 245,7915 },
 { 246,7915 }, { 247,7915 }, { 248,7915 }, { 249,7915 }, { 250,7915 },
 { 251,7915 }, { 252,7915 }, { 253,7915 }, { 254,7915 }, { 255,7915 },
 { 256,7915 }, {   0,  11 }, {   0,34723 }, {   1,7915 }, {   2,7915 },
 {   3,7915 }, {   4,7915 }, {   5,7915 }, {   6,7915 }, {   7,7915 },
 {   8,7915 }, {   9,7915 }, {  10,7915 }, {  11,7915 }, {  12,7915 },
 {  13,7915 }, {  14,7915 }, {  15,7915 }, {  16,7915 }, {  17,7915 },
 {  18,7915 }, {  19,7915 }, {  20,7915 }, {  21,7915 }, {  22,7915 },
 {  23,7915 }, {  24,7915 }, {  25,7915 }, {  26,7915 }, {  27,7915 },
 {  28,7915 }, {  29,7915 }, {  30,7915 }, {  31,7915 }, {  32,7915 },

 {  33,7915 }, {  34,7915 }, {  35,7915 }, {  36,7915 }, {  37,7915 },
 {  38,7915 }, {  39,8173 }, {  40,7915 }, {  41,7915 }, {  42,7915 },
 {  43,7915 }, {  44,7915 }, {  45,7915 }, {  46,7915 }, {  47,7915 },
 {  48,7915 }, {  49,7915 }, {  50,7915 }, {  51,7915 }, {  52,7915 },
 {  53,7915 }, {  54,7915 }, {  55,7915 }, {  56,7915 }, {  57,7915 },
 {  58,7915 }, {  59,7915 }, {  60,7915 }, {  61,7915 }, {  62,7915 },
 {  63,7915 }, {  64,7915 }, {  65,7915 }, {  66,7915 }, {  67,7915 },
 {  68,7915 }, {  69,7915 }, {  70,7915 }, {  71,7915 }, {  72,7915 },
 {  73,7915 }, {  74,7915 }, {  75,7915 }, {  76,7915 }, {  77,7915 },
 {  78,7915 }, {  79,7915 }, {  80,7915 }, {  81,7915 }, {  82,7915 },

 {  83,7915 }, {  84,7915 }, {  85,7915 }, {  86,7915 }, {  87,7915 },
 {  88,7915 }, {  89,7915 }, {  90,7915 }, {  91,7915 }, {  92,7915 },
 {  93,7915 }, {  94,7915 }, {  95,7915 }, {  96,7915 }, {  97,7915 },
 {  98,7915 }, {  99,7915 }, { 100,7915 }, { 101,7915 }, { 102,7915 },
 { 103,7915 }, { 104,7915 }, { 105,7915 }, { 106,7915 }, { 107,7915 },
 { 108,7915 }, { 109,7915 }, { 110,7915 }, { 111,7915 }, { 112,7915 },
 { 113,7915 }, { 114,7915 }, { 115,7915 }, { 116,7915 }, { 117,7915 },
 { 118,7915 }, { 119,7915 }, { 120,7915 }, { 121,7915 }, { 122,7915 },
 { 123,7915 }, { 124,7915 }, { 125,7915 }, { 126,7915 }, { 127,7915 },
 { 128,7915 }, { 129,7915 }, { 130,7915 }, { 131,7915 }, { 132,7915 },

 { 133,7915 }, { 134,7915 }, { 135,7915 }, { 136,7915 }, { 137,7915 },
 { 138,7915 }, { 139,7915 }, { 140,7915 }, { 141,7915 }, { 142,7915 },
 { 143,7915 }, { 144,7915 }, { 145,7915 }, { 146,7915 }, { 147,7915 },
 { 148,7915 }, { 149,7915 }, { 150,7915 }, { 151,7915 }, { 152,7915 },
 { 153,7915 }, { 154,7915 }, { 155,7915 }, { 156,7915 }, { 157,7915 },
 { 158,7915 }, { 159,7915 }, { 160,7915 }, { 161,7915 }, { 162,7915 },
 { 163,7915 }, { 164,7915 }, { 165,7915 }, { 166,7915 }, { 167,7915 },
 { 168,7915 }, { 169,7915 }, { 170,7915 }, { 171,7915 }, { 172,7915 },
 { 173,7915 }, { 174,7915 }, { 175,7915 }, { 176,7915 }, { 177,7915 },
 { 178,7915 }, { 179,7915 }, { 180,7915 }, { 181,7915 }, { 182,7915 },

 { 183,7915 }, { 184,7915 }, { 185,7915 }, { 186,7915 }, { 187,7915 },
 { 188,7915 }, { 189,7915 }, { 190,7915 }, { 191,7915 }, { 192,7915 },
 { 193,7915 }, { 194,7915 }, { 195,7915 }, { 196,7915 }, { 197,7915 },
 { 198,7915 }, { 199,7915 }, { 200,7915 }, { 201,7915 }, { 202,7915 },
 { 203,7915 }, { 204,7915 }, { 205,7915 }, { 206,7915 }, { 207,7915 },
 { 208,7915 }, { 209,7915 }, { 210,7915 }, { 211,7915 }, { 212,7915 },
 { 213,7915 }, { 214,7915 }, { 215,7915 }, { 216,7915 }, { 217,7915 },
 { 218,7915 }, { 219,7915 }, { 220,7915 }, { 221,7915 }, { 222,7915 },
 { 223,7915 }, { 224,7915 }, { 225,7915 }, { 226,7915 }, { 227,7915 },
 { 228,7915 }, { 229,7915 }, { 230,7915 }, { 231,7915 }, { 232,7915 },

 { 233,7915 }, { 234,7915 }, { 235,7915 }, { 236,7915 }, { 237,7915 },
 { 238,7915 }, { 239,7915 }, { 240,7915 }, { 241,7915 }, { 242,7915 },
 { 243,7915 }, { 244,7915 }, { 245,7915 }, { 246,7915 }, { 247,7915 },
 { 248,7915 }, { 249,7915 }, { 250,7915 }, { 251,7915 }, { 252,7915 },
 { 253,7915 }, { 254,7915 }, { 255,7915 }, { 256,7915 }, {   0,  11 },
 {   0,34465 }, {   1,7657 }, {   2,7657 }, {   3,7657 }, {   4,7657 },
 {   5,7657 }, {   6,7657 }, {   7,7657 }, {   8,7657 }, {   9,7657 },
 {  10,7657 }, {  11,7657 }, {  12,7657 }, {  13,7657 }, {  14,7657 },
 {  15,7657 }, {  16,7657 }, {  17,7657 }, {  18,7657 }, {  19,7657 },
 {  20,7657 }, {  21,7657 }, {  22,7657 }, {  23,7657 }, {  24,7657 },

 {  25,7657 }, {  26,7657 }, {  27,7657 }, {  28,7657 }, {  29,7657 },
 {  30,7657 }, {  31,7657 }, {  32,7657 }, {  33,7657 }, {  34,7657 },
 {  35,7657 }, {  36,7657 }, {  37,7657 }, {  38,7657 }, {  39,7915 },
 {  40,7657 }, {  41,7657 }, {  42,7657 }, {  43,7657 }, {  44,7657 },
 {  45,7657 }, {  46,7657 }, {  47,7657 }, {  48,7657 }, {  49,7657 },
 {  50,7657 }, {  51,7657 }, {  52,7657 }, {  53,7657 }, {  54,7657 },
 {  55,7657 }, {  56,7657 }, {  57,7657 }, {  58,7657 }, {  59,7657 },
 {  60,7657 }, {  61,7657 }, {  62,7657 }, {  63,7657 }, {  64,7657 },
 {  65,7657 }, {  66,7657 }, {  67,7657 }, {  68,7657 }, {  69,7657 },
 {  70,7657 }, {  71,7657 }, {  72,7657 }, {  73,7657 }, {  74,7657 },

 {  75,7657 }, {  76,7657 }, {  77,7657 }, {  78,7657 }, {  79,7657 },
 {  80,7657 }, {  81,7657 }, {  82,7657 }, {  83,7657 }, {  84,7657 },
 {  85,7657 }, {  86,7657 }, {  87,7657 }, {  88,7657 }, {  89,7657 },
 {  90,7657 }, {  91,7657 }, {  92,7657 }, {  93,7657 }, {  94,7657 },
 {  95,7657 }, {  96,7657 }, {  97,7657 }, {  98,7657 }, {  99,7657 },
 { 100,7657 }, { 101,7657 }, { 102,7657 }, { 103,7657 }, { 104,7657 },
 { 105,7657 }, { 106,7657 }, { 107,7657 }, { 108,7657 }, { 109,7657 },
 { 110,7657 }, { 111,7657 }, { 112,7657 }, { 113,7657 }, { 114,7657 },
 { 115,7657 }, { 116,7657 }, { 117,7657 }, { 118,7657 }, { 119,7657 },
 { 120,7657 }, { 121,7657 }, { 122,7657 }, { 123,7657 }, { 124,7657 },

 { 125,7657 }, { 126,7657 }, { 127,7657 }, { 128,7657 }, { 129,7657 },
 { 130,7657 }, { 131,7657 }, { 132,7657 }, { 133,7657 }, { 134,7657 },
 { 135,7657 }, { 136,7657 }, { 137,7657 }, { 138,7657 }, { 139,7657 },
 { 140,7657 }, { 141,7657 }, { 142,7657 }, { 143,7657 }, { 144,7657 },
 { 145,7657 }, { 146,7657 }, { 147,7657 }, { 148,7657 }, { 149,7657 },
 { 150,7657 }, { 151,7657 }, { 152,7657 }, { 153,7657 }, { 154,7657 },
 { 155,7657 }, { 156,7657 }, { 157,7657 }, { 158,7657 }, { 159,7657 },
 { 160,7657 }, { 161,7657 }, { 162,7657 }, { 163,7657 }, { 164,7657 },
 { 165,7657 }, { 166,7657 }, { 167,7657 }, { 168,7657 }, { 169,7657 },
 { 170,7657 }, { 171,7657 }, { 172,7657 }, { 173,7657 }, { 174,7657 },

 { 175,7657 }, { 176,7657 }, { 177,7657 }, { 178,7657 }, { 179,7657 },
 { 180,7657 }, { 181,7657 }, { 182,7657 }, { 183,7657 }, { 184,7657 },
 { 185,7657 }, { 186,7657 }, { 187,7657 }, { 188,7657 }, { 189,7657 },
 { 190,7657 }, { 191,7657 }, { 192,7657 }, { 193,7657 }, { 194,7657 },
 { 195,7657 }, { 196,7657 }, { 197,7657 }, { 198,7657 }, { 199,7657 },
 { 200,7657 }, { 201,7657 }, { 202,7657 }, { 203,7657 }, { 204,7657 },
 { 205,7657 }, { 206,7657 }, { 207,7657 }, { 208,7657 }, { 209,7657 },
 { 210,7657 }, { 211,7657 }, { 212,7657 }, { 213,7657 }, { 214,7657 },
 { 215,7657 }, { 216,7657 }, { 217,7657 }, { 218,7657 }, { 219,7657 },
 { 220,7657 }, { 221,7657 }, { 222,7657 }, { 223,7657 }, { 224,7657 },

 { 225,7657 }, { 226,7657 }, { 227,7657 }, { 228,7657 }, { 229,7657 },
 { 230,7657 }, { 231,7657 }, { 232,7657 }, { 233,7657 }, { 234,7657 },
 { 235,7657 }, { 236,7657 }, { 237,7657 }, { 238,7657 }, { 239,7657 },
 { 240,7657 }, { 241,7657 }, { 242,7657 }, { 243,7657 }, { 244,7657 },
 { 245,7657 }, { 246,7657 }, { 247,7657 }, { 248,7657 }, { 249,7657 },
 { 250,7657 }, { 251,7657 }, { 252,7657 }, { 253,7657 }, { 254,7657 },
 { 255,7657 }, { 256,7657 }, {   0,   0 }, {   0,34207 }, {   1,7704 },
 {   2,7704 }, {   3,7704 }, {   4,7704 }, {   5,7704 }, {   6,7704 },
 {   7,7704 }, {   8,7704 }, {   9,7704 }, {  10,7704 }, {  11,7704 },
 {  12,7704 }, {  13,7704 }, {  14,7704 }, {  15,7704 }, {  16,7704 },

 {  17,7704 }, {  18,7704 }, {  19,7704 }, {  20,7704 }, {  21,7704 },
 {  22,7704 }, {  23,7704 }, {  24,7704 }, {  25,7704 }, {  26,7704 },
 {  27,7704 }, {  28,7704 }, {  29,7704 }, {  30,7704 }, {  31,7704 },
 {  32,7704 }, {  33,7704 }, {  34,7704 }, {  35,7704 }, {  36,7704 },
 {  37,7704 }, {  38,7704 }, {  39,7962 }, {  40,7704 }, {  41,7704 },
 {  42,7704 }, {  43,7704 }, {  44,7704 }, {  45,7704 }, {  46,7704 },
 {  47,7704 }, {  48,7704 }, {  49,7704 }, {  50,7704 }, {  51,7704 },
 {  52,7704 }, {  53,7704 }, {  54,7704 }, {  55,7704 }, {  56,7704 },
 {  57,7704 }, {  58,7704 }, {  59,7704 }, {  60,7704 }, {  61,7704 },
 {  62,7704 }, {  63,7704 }, {  64,7704 }, {  65,7704 }, {  66,7704 },

 {  67,7704 }, {  68,7704 }, {  69,7704 }, {  70,7704 }, {  71,7704 },
 {  72,7704 }, {  73,7704 }, {  74,7704 }, {  75,7704 }, {  76,7704 },
 {  77,7704 }, {  78,7704 }, {  79,7704 }, {  80,7704 }, {  81,7704 },
 {  82,7704 }, {  83,7704 }, {  84,7704 }, {  85,7704 }, {  86,7704 },
 {  87,7704 }, {  88,7704 }, {  89,7704 }, {  90,7704 }, {  91,7704 },
 {  92,7704 }, {  93,7704 }, {  94,7704 }, {  95,7704 }, {  96,7704 },
 {  97,7704 }, {  98,7704 }, {  99,7704 }, { 100,7704 }, { 101,7704 },
 { 102,7704 }, { 103,7704 }, { 104,7704 }, { 105,7704 }, { 106,7704 },
 { 107,7704 }, { 108,7704 }, { 109,7704 }, { 110,7704 }, { 111,7704 },
 { 112,7704 }, { 113,7704 }, { 114,7704 }, { 115,7704 }, { 116,7704 },

 { 117,7704 }, { 118,7704 }, { 119,7704 }, { 120,7704 }, { 121,7704 },
 { 122,7704 }, { 123,7704 }, { 124,7704 }, { 125,7704 }, { 126,7704 },
 { 127,7704 }, { 128,7704 }, { 129,7704 }, { 130,7704 }, { 131,7704 },
 { 132,7704 }, { 133,7704 }, { 134,7704 }, { 135,7704 }, { 136,7704 },
 { 137,7704 }, { 138,7704 }, { 139,7704 }, { 140,7704 }, { 141,7704 },
 { 142,7704 }, { 143,7704 }, { 144,7704 }, { 145,7704 }, { 146,7704 },
 { 147,7704 }, { 148,7704 }, { 149,7704 }, { 150,7704 }, { 151,7704 },
 { 152,7704 }, { 153,7704 }, { 154,7704 }, { 155,7704 }, { 156,7704 },
 { 157,7704 }, { 158,7704 }, { 159,7704 }, { 160,7704 }, { 161,7704 },
 { 162,7704 }, { 163,7704 }, { 164,7704 }, { 165,7704 }, { 166,7704 },

 { 167,7704 }, { 168,7704 }, { 169,7704 }, { 170,7704 }, { 171,7704 },
 { 172,7704 }, { 173,7704 }, { 174,7704 }, { 175,7704 }, { 176,7704 },
 { 177,7704 }, { 178,7704 }, { 179,7704 }, { 180,7704 }, { 181,7704 },
 { 182,7704 }, { 183,7704 }, { 184,7704 }, { 185,7704 }, { 186,7704 },
 { 187,7704 }, { 188,7704 }, { 189,7704 }, { 190,7704 }, { 191,7704 },
 { 192,7704 }, { 193,7704 }, { 194,7704 }, { 195,7704 }, { 196,7704 },
 { 197,7704 }, { 198,7704 }, { 199,7704 }, { 200,7704 }, { 201,7704 },
 { 202,7704 }, { 203,7704 }, { 204,7704 }, { 205,7704 }, { 206,7704 },
 { 207,7704 }, { 208,7704 }, { 209,7704 }, { 210,7704 }, { 211,7704 },
 { 212,7704 }, { 213,7704 }, { 214,7704 }, { 215,7704 }, { 216,7704 },

 { 217,7704 }, { 218,7704 }, { 219,7704 }, { 220,7704 }, { 221,7704 },
 { 222,7704 }, { 223,7704 }, { 224,7704 }, { 225,7704 }, { 226,7704 },
 { 227,7704 }, { 228,7704 }, { 229,7704 }, { 230,7704 }, { 231,7704 },
 { 232,7704 }, { 233,7704 }, { 234,7704 }, { 235,7704 }, { 236,7704 },
 { 237,7704 }, { 238,7704 }, { 239,7704 }, { 240,7704 }, { 241,7704 },
 { 242,7704 }, { 243,7704 }, { 244,7704 }, { 245,7704 }, { 246,7704 },
 { 247,7704 }, { 248,7704 }, { 249,7704 }, { 250,7704 }, { 251,7704 },
 { 252,7704 }, { 253,7704 }, { 254,7704 }, { 255,7704 }, { 256,7704 },
 {   0,   0 }, {   0,33949 }, {   1,7446 }, {   2,7446 }, {   3,7446 },
 {   4,7446 }, {   5,7446 }, {   6,7446 }, {   7,7446 }, {   8,7446 },

 {   9,7446 }, {  10,7446 }, {  11,7446 }, {  12,7446 }, {  13,7446 },
 {  14,7446 }, {  15,7446 }, {  16,7446 }, {  17,7446 }, {  18,7446 },
 {  19,7446 }, {  20,7446 }, {  21,7446 }, {  22,7446 }, {  23,7446 },
 {  24,7446 }, {  25,7446 }, {  26,7446 }, {  27,7446 }, {  28,7446 },
 {  29,7446 }, {  30,7446 }, {  31,7446 }, {  32,7446 }, {  33,7446 },
 {  34,7446 }, {  35,7446 }, {  36,7446 }, {  37,7446 }, {  38,7446 },
 {  39,7704 }, {  40,7446 }, {  41,7446 }, {  42,7446 }, {  43,7446 },
 {  44,7446 }, {  45,7446 }, {  46,7446 }, {  47,7446 }, {  48,7446 },
 {  49,7446 }, {  50,7446 }, {  51,7446 }, {  52,7446 }, {  53,7446 },
 {  54,7446 }, {  55,7446 }, {  56,7446 }, {  57,7446 }, {  58,7446 },

 {  59,7446 }, {  60,7446 }, {  61,7446 }, {  62,7446 }, {  63,7446 },
 {  64,7446 }, {  65,7446 }, {  66,7446 }, {  67,7446 }, {  68,7446 },
 {  69,7446 }, {  70,7446 }, {  71,7446 }, {  72,7446 }, {  73,7446 },
 {  74,7446 }, {  75,7446 }, {  76,7446 }, {  77,7446 }, {  78,7446 },
 {  79,7446 }, {  80,7446 }, {  81,7446 }, {  82,7446 }, {  83,7446 },
 {  84,7446 }, {  85,7446 }, {  86,7446 }, {  87,7446 }, {  88,7446 },
 {  89,7446 }, {  90,7446 }, {  91,7446 }, {  92,7446 }, {  93,7446 },
 {  94,7446 }, {  95,7446 }, {  96,7446 }, {  97,7446 }, {  98,7446 },
 {  99,7446 }, { 100,7446 }, { 101,7446 }, { 102,7446 }, { 103,7446 },
 { 104,7446 }, { 105,7446 }, { 106,7446 }, { 107,7446 }, { 108,7446 },

 { 109,7446 }, { 110,7446 }, { 111,7446 }, { 112,7446 }, { 113,7446 },
 { 114,7446 }, { 115,7446 }, { 116,7446 }, { 117,7446 }, { 118,7446 },
 { 119,7446 }, { 120,7446 }, { 121,7446 }, { 122,7446 }, { 123,7446 },
 { 124,7446 }, { 125,7446 }, { 126,7446 }, { 127,7446 }, { 128,7446 },
 { 129,7446 }, { 130,7446 }, { 131,7446 }, { 132,7446 }, { 133,7446 },
 { 134,7446 }, { 135,7446 }, { 136,7446 }, { 137,7446 }, { 138,7446 },
 { 139,7446 }, { 140,7446 }, { 141,7446 }, { 142,7446 }, { 143,7446 },
 { 144,7446 }, { 145,7446 }, { 146,7446 }, { 147,7446 }, { 148,7446 },
 { 149,7446 }, { 150,7446 }, { 151,7446 }, { 152,7446 }, { 153,7446 },
 { 154,7446 }, { 155,7446 }, { 156,7446 }, { 157,7446 }, { 158,7446 },

 { 159,7446 }, { 160,7446 }, { 161,7446 }, { 162,7446 }, { 163,7446 },
 { 164,7446 }, { 165,7446 }, { 166,7446 }, { 167,7446 }, { 168,7446 },
 { 169,7446 }, { 170,7446 }, { 171,7446 }, { 172,7446 }, { 173,7446 },
 { 174,7446 }, { 175,7446 }, { 176,7446 }, { 177,7446 }, { 178,7446 },
 { 179,7446 }, { 180,7446 }, { 181,7446 }, { 182,7446 }, { 183,7446 },
 { 184,7446 }, { 185,7446 }, { 186,7446 }, { 187,7446 }, { 188,7446 },
 { 189,7446 }, { 190,7446 }, { 191,7446 }, { 192,7446 }, { 193,7446 },
 { 194,7446 }, { 195,7446 }, { 196,7446 }, { 197,7446 }, { 198,7446 },
 { 199,7446 }, { 200,7446 }, { 201,7446 }, { 202,7446 }, { 203,7446 },
 { 204,7446 }, { 205,7446 }, { 206,7446 }, { 207,7446 }, { 208,7446 },

 { 209,7446 }, { 210,7446 }, { 211,7446 }, { 212,7446 }, { 213,7446 },
 { 214,7446 }, { 215,7446 }, { 216,7446 }, { 217,7446 }, { 218,7446 },
 { 219,7446 }, { 220,7446 }, { 221,7446 }, { 222,7446 }, { 223,7446 },
 { 224,7446 }, { 225,7446 }, { 226,7446 }, { 227,7446 }, { 228,7446 },
 { 229,7446 }, { 230,7446 }, { 231,7446 }, { 232,7446 }, { 233,7446 },
 { 234,7446 }, { 235,7446 }, { 236,7446 }, { 237,7446 }, { 238,7446 },
 { 239,7446 }, { 240,7446 }, { 241,7446 }, { 242,7446 }, { 243,7446 },
 { 244,7446 }, { 245,7446 }, { 246,7446 }, { 247,7446 }, { 248,7446 },
 { 249,7446 }, { 250,7446 }, { 251,7446 }, { 252,7446 }, { 253,7446 },
 { 254,7446 }, { 255,7446 }, { 256,7446 }, {   0,   0 }, {   0,33691 },

 {   1,7493 }, {   2,7493 }, {   3,7493 }, {   4,7493 }, {   5,7493 },
 {   6,7493 }, {   7,7493 }, {   8,7493 }, {   9,7493 }, {  10,7751 },
 {  11,7493 }, {  12,7493 }, {  13,7493 }, {  14,7493 }, {  15,7493 },
 {  16,7493 }, {  17,7493 }, {  18,7493 }, {  19,7493 }, {  20,7493 },
 {  21,7493 }, {  22,7493 }, {  23,7493 }, {  24,7493 }, {  25,7493 },
 {  26,7493 }, {  27,7493 }, {  28,7493 }, {  29,7493 }, {  30,7493 },
 {  31,7493 }, {  32,7493 }, {  33,7493 }, {  34,7493 }, {  35,7493 },
 {  36,7493 }, {  37,7493 }, {  38,7493 }, {  39,8009 }, {  40,7493 },
 {  41,7493 }, {  42,7493 }, {  43,7493 }, {  44,7493 }, {  45,7493 },
 {  46,7493 }, {  47,7493 }, {  48,7493 }, {  49,7493 }, {  50,7493 },

 {  51,7493 }, {  52,7493 }, {  53,7493 }, {  54,7493 }, {  55,7493 },
 {  56,7493 }, {  57,7493 }, {  58,7493 }, {  59,7493 }, {  60,7493 },
 {  61,7493 }, {  62,7493 }, {  63,7493 }, {  64,7493 }, {  65,7493 },
 {  66,7493 }, {  67,7493 }, {  68,7493 }, {  69,7493 }, {  70,7493 },
 {  71,7493 }, {  72,7493 }, {  73,7493 }, {  74,7493 }, {  75,7493 },
 {  76,7493 }, {  77,7493 }, {  78,7493 }, {  79,7493 }, {  80,7493 },
 {  81,7493 }, {  82,7493 }, {  83,7493 }, {  84,7493 }, {  85,7493 },
 {  86,7493 }, {  87,7493 }, {  88,7493 }, {  89,7493 }, {  90,7493 },
 {  91,7493 }, {  92,8056 }, {  93,7493 }, {  94,7493 }, {  95,7493 },
 {  96,7493 }, {  97,7493 }, {  98,7493 }, {  99,7493 }, { 100,7493 },

 { 101,7493 }, { 102,7493 }, { 103,7493 }, { 104,7493 }, { 105,7493 },
 { 106,7493 }, { 107,7493 }, { 108,7493 }, { 109,7493 }, { 110,7493 },
 { 111,7493 }, { 112,7493 }, { 113,7493 }, { 114,7493 }, { 115,7493 },
 { 116,7493 }, { 117,7493 }, { 118,7493 }, { 119,7493 }, { 120,7493 },
 { 121,7493 }, { 122,7493 }, { 123,7493 }, { 124,7493 }, { 125,7493 },
 { 126,7493 }, { 127,7493 }, { 128,7493 }, { 129,7493 }, { 130,7493 },
 { 131,7493 }, { 132,7493 }, { 133,7493 }, { 134,7493 }, { 135,7493 },
 { 136,7493 }, { 137,7493 }, { 138,7493 }, { 139,7493 }, { 140,7493 },
 { 141,7493 }, { 142,7493 }, { 143,7493 }, { 144,7493 }, { 145,7493 },
 { 146,7493 }, { 147,7493 }, { 148,7493 }, { 149,7493 }, { 150,7493 },

 { 151,7493 }, { 152,7493 }, { 153,7493 }, { 154,7493 }, { 155,7493 },
 { 156,7493 }, { 157,7493 }, { 158,7493 }, { 159,7493 }, { 160,7493 },
 { 161,7493 }, { 162,7493 }, { 163,7493 }, { 164,7493 }, { 165,7493 },
 { 166,7493 }, { 167,7493 }, { 168,7493 }, { 169,7493 }, { 170,7493 },
 { 171,7493 }, { 172,7493 }, { 173,7493 }, { 174,7493 }, { 175,7493 },
 { 176,7493 }, { 177,7493 }, { 178,7493 }, { 179,7493 }, { 180,7493 },
 { 181,7493 }, { 182,7493 }, { 183,7493 }, { 184,7493 }, { 185,7493 },
 { 186,7493 }, { 187,7493 }, { 188,7493 }, { 189,7493 }, { 190,7493 },
 { 191,7493 }, { 192,7493 }, { 193,7493 }, { 194,7493 }, { 195,7493 },
 { 196,7493 }, { 197,7493 }, { 198,7493 }, { 199,7493 }, { 200,7493 },

 { 201,7493 }, { 202,7493 }, { 203,7493 }, { 204,7493 }, { 205,7493 },
 { 206,7493 }, { 207,7493 }, { 208,7493 }, { 209,7493 }, { 210,7493 },
 { 211,7493 }, { 212,7493 }, { 213,7493 }, { 214,7493 }, { 215,7493 },
 { 216,7493 }, { 217,7493 }, { 218,7493 }, { 219,7493 }, { 220,7493 },
 { 221,7493 }, { 222,7493 }, { 223,7493 }, { 224,7493 }, { 225,7493 },
 { 226,7493 }, { 227,7493 }, { 228,7493 }, { 229,7493 }, { 230,7493 },
 { 231,7493 }, { 232,7493 }, { 233,7493 }, { 234,7493 }, { 235,7493 },
 { 236,7493 }, { 237,7493 }, { 238,7493 }, { 239,7493 }, { 240,7493 },
 { 241,7493 }, { 242,7493 }, { 243,7493 }, { 244,7493 }, { 245,7493 },
 { 246,7493 }, { 247,7493 }, { 248,7493 }, { 249,7493 }, { 250,7493 },

 { 251,7493 }, { 252,7493 }, { 253,7493 }, { 254,7493 }, { 255,7493 },
 { 256,7493 }, {   0,   0 }, {   0,33433 }, {   1,7235 }, {   2,7235 },
 {   3,7235 }, {   4,7235 }, {   5,7235 }, {   6,7235 }, {   7,7235 },
 {   8,7235 }, {   9,7235 }, {  10,7493 }, {  11,7235 }, {  12,7235 },
 {  13,7235 }, {  14,7235 }, {  15,7235 }, {  16,7235 }, {  17,7235 },
 {  18,7235 }, {  19,7235 }, {  20,7235 }, {  21,7235 }, {  22,7235 },
 {  23,7235 }, {  24,7235 }, {  25,7235 }, {  26,7235 }, {  27,7235 },
 {  28,7235 }, {  29,7235 }, {  30,7235 }, {  31,7235 }, {  32,7235 },
 {  33,7235 }, {  34,7235 }, {  35,7235 }, {  36,7235 }, {  37,7235 },
 {  38,7235 }, {  39,7751 }, {  40,7235 }, {  41,7235 }, {  42,7235 },

 {  43,7235 }, {  44,7235 }, {  45,7235 }, {  46,7235 }, {  47,7235 },
 {  48,7235 }, {  49,7235 }, {  50,7235 }, {  51,7235 }, {  52,7235 },
 {  53,7235 }, {  54,7235 }, {  55,7235 }, {  56,7235 }, {  57,7235 },
 {  58,7235 }, {  59,7235 }, {  60,7235 }, {  61,7235 }, {  62,7235 },
 {  63,7235 }, {  64,7235 }, {  65,7235 }, {  66,7235 }, {  67,7235 },
 {  68,7235 }, {  69,7235 }, {  70,7235 }, {  71,7235 }, {  72,7235 },
 {  73,7235 }, {  74,7235 }, {  75,7235 }, {  76,7235 }, {  77,7235 },
 {  78,7235 }, {  79,7235 }, {  80,7235 }, {  81,7235 }, {  82,7235 },
 {  83,7235 }, {  84,7235 }, {  85,7235 }, {  86,7235 }, {  87,7235 },
 {  88,7235 }, {  89,7235 }, {  90,7235 }, {  91,7235 }, {  92,7798 },

 {  93,7235 }, {  94,7235 }, {  95,7235 }, {  96,7235 }, {  97,7235 },
 {  98,7235 }, {  99,7235 }, { 100,7235 }, { 101,7235 }, { 102,7235 },
 { 103,7235 }, { 104,7235 }, { 105,7235 }, { 106,7235 }, { 107,7235 },
 { 108,7235 }, { 109,7235 }, { 110,7235 }, { 111,7235 }, { 112,7235 },
 { 113,7235 }, { 114,7235 }, { 115,7235 }, { 116,7235 }, { 117,7235 },
 { 118,7235 }, { 119,7235 }, { 120,7235 }, { 121,7235 }, { 122,7235 },
 { 123,7235 }, { 124,7235 }, { 125,7235 }, { 126,7235 }, { 127,7235 },
 { 128,7235 }, { 129,7235 }, { 130,7235 }, { 131,7235 }, { 132,7235 },
 { 133,7235 }, { 134,7235 }, { 135,7235 }, { 136,7235 }, { 137,7235 },
 { 138,7235 }, { 139,7235 }, { 140,7235 }, { 141,7235 }, { 142,7235 },

 { 143,7235 }, { 144,7235 }, { 145,7235 }, { 146,7235 }, { 147,7235 },
 { 148,7235 }, { 149,7235 }, { 150,7235 }, { 151,7235 }, { 152,7235 },
 { 153,7235 }, { 154,7235 }, { 155,7235 }, { 156,7235 }, { 157,7235 },
 { 158,7235 }, { 159,7235 }, { 160,7235 }, { 161,7235 }, { 162,7235 },
 { 163,7235 }, { 164,7235 }, { 165,7235 }, { 166,7235 }, { 167,7235 },
 { 168,7235 }, { 169,7235 }, { 170,7235 }, { 171,7235 }, { 172,7235 },
 { 173,7235 }, { 174,7235 }, { 175,7235 }, { 176,7235 }, { 177,7235 },
 { 178,7235 }, { 179,7235 }, { 180,7235 }, { 181,7235 }, { 182,7235 },
 { 183,7235 }, { 184,7235 }, { 185,7235 }, { 186,7235 }, { 187,7235 },
 { 188,7235 }, { 189,7235 }, { 190,7235 }, { 191,7235 }, { 192,7235 },

 { 193,7235 }, { 194,7235 }, { 195,7235 }, { 196,7235 }, { 197,7235 },
 { 198,7235 }, { 199,7235 }, { 200,7235 }, { 201,7235 }, { 202,7235 },
 { 203,7235 }, { 204,7235 }, { 205,7235 }, { 206,7235 }, { 207,7235 },
 { 208,7235 }, { 209,7235 }, { 210,7235 }, { 211,7235 }, { 212,7235 },
 { 213,7235 }, { 214,7235 }, { 215,7235 }, { 216,7235 }, { 217,7235 },
 { 218,7235 }, { 219,7235 }, { 220,7235 }, { 221,7235 }, { 222,7235 },
 { 223,7235 }, { 224,7235 }, { 225,7235 }, { 226,7235 }, { 227,7235 },
 { 228,7235 }, { 229,7235 }, { 230,7235 }, { 231,7235 }, { 232,7235 },
 { 233,7235 }, { 234,7235 }, { 235,7235 }, { 236,7235 }, { 237,7235 },
 { 238,7235 }, { 239,7235 }, { 240,7235 }, { 241,7235 }, { 242,7235 },

 { 243,7235 }, { 244,7235 }, { 245,7235 }, { 246,7235 }, { 247,7235 },
 { 248,7235 }, { 249,7235 }, { 250,7235 }, { 251,7235 }, { 252,7235 },
 { 253,7235 }, { 254,7235 }, { 255,7235 }, { 256,7235 }, {   0,   0 },
 {   0,33175 }, {   1,7798 }, {   2,7798 }, {   3,7798 }, {   4,7798 },
 {   5,7798 }, {   6,7798 }, {   7,7798 }, {   8,7798 }, {   9,7798 },
 {  10,8056 }, {  11,7798 }, {  12,7798 }, {  13,7798 }, {  14,7798 },
 {  15,7798 }, {  16,7798 }, {  17,7798 }, {  18,7798 }, {  19,7798 },
 {  20,7798 }, {  21,7798 }, {  22,7798 }, {  23,7798 }, {  24,7798 },
 {  25,7798 }, {  26,7798 }, {  27,7798 }, {  28,7798 }, {  29,7798 },
 {  30,7798 }, {  31,7798 }, {  32,7798 }, {  33,7798 }, {  34,7798 },

 {  35,7798 }, {  36,8314 }, {  37,7798 }, {  38,7798 }, {  39,7798 },
 {  40,7798 }, {  41,7798 }, {  42,7798 }, {  43,7798 }, {  44,7798 },
 {  45,7798 }, {  46,7798 }, {  47,7798 }, {  48,7798 }, {  49,7798 },
 {  50,7798 }, {  51,7798 }, {  52,7798 }, {  53,7798 }, {  54,7798 },
 {  55,7798 }, {  56,7798 }, {  57,7798 }, {  58,7798 }, {  59,7798 },
 {  60,7798 }, {  61,7798 }, {  62,7798 }, {  63,7798 }, {  64,7798 },
 {  65,7798 }, {  66,7798 }, {  67,7798 }, {  68,7798 }, {  69,7798 },
 {  70,7798 }, {  71,7798 }, {  72,7798 }, {  73,7798 }, {  74,7798 },
 {  75,7798 }, {  76,7798 }, {  77,7798 }, {  78,7798 }, {  79,7798 },
 {  80,7798 }, {  81,7798 }, {  82,7798 }, {  83,7798 }, {  84,7798 },

 {  85,7798 }, {  86,7798 }, {  87,7798 }, {  88,7798 }, {  89,7798 },
 {  90,7798 }, {  91,7798 }, {  92,7798 }, {  93,7798 }, {  94,7798 },
 {  95,7798 }, {  96,7798 }, {  97,7798 }, {  98,7798 }, {  99,7798 },
 { 100,7798 }, { 101,7798 }, { 102,7798 }, { 103,7798 }, { 104,7798 },
 { 105,7798 }, { 106,7798 }, { 107,7798 }, { 108,7798 }, { 109,7798 },
 { 110,7798 }, { 111,7798 }, { 112,7798 }, { 113,7798 }, { 114,7798 },
 { 115,7798 }, { 116,7798 }, { 117,7798 }, { 118,7798 }, { 119,7798 },
 { 120,7798 }, { 121,7798 }, { 122,7798 }, { 123,7798 }, { 124,7798 },
 { 125,7798 }, { 126,7798 }, { 127,7798 }, { 128,7798 }, { 129,7798 },
 { 130,7798 }, { 131,7798 }, { 132,7798 }, { 133,7798 }, { 134,7798 },

 { 135,7798 }, { 136,7798 }, { 137,7798 }, { 138,7798 }, { 139,7798 },
 { 140,7798 }, { 141,7798 }, { 142,7798 }, { 143,7798 }, { 144,7798 },
 { 145,7798 }, { 146,7798 }, { 147,7798 }, { 148,7798 }, { 149,7798 },
 { 150,7798 }, { 151,7798 }, { 152,7798 }, { 153,7798 }, { 154,7798 },
 { 155,7798 }, { 156,7798 }, { 157,7798 }, { 158,7798 }, { 159,7798 },
 { 160,7798 }, { 161,7798 }, { 162,7798 }, { 163,7798 }, { 164,7798 },
 { 165,7798 }, { 166,7798 }, { 167,7798 }, { 168,7798 }, { 169,7798 },
 { 170,7798 }, { 171,7798 }, { 172,7798 }, { 173,7798 }, { 174,7798 },
 { 175,7798 }, { 176,7798 }, { 177,7798 }, { 178,7798 }, { 179,7798 },
 { 180,7798 }, { 181,7798 }, { 182,7798 }, { 183,7798 }, { 184,7798 },

 { 185,7798 }, { 186,7798 }, { 187,7798 }, { 188,7798 }, { 189,7798 },
 { 190,7798 }, { 191,7798 }, { 192,7798 }, { 193,7798 }, { 194,7798 },
 { 195,7798 }, { 196,7798 }, { 197,7798 }, { 198,7798 }, { 199,7798 },
 { 200,7798 }, { 201,7798 }, { 202,7798 }, { 203,7798 }, { 204,7798 },
 { 205,7798 }, { 206,7798 }, { 207,7798 }, { 208,7798 }, { 209,7798 },
 { 210,7798 }, { 211,7798 }, { 212,7798 }, { 213,7798 }, { 214,7798 },
 { 215,7798 }, { 216,7798 }, { 217,7798 }, { 218,7798 }, { 219,7798 },
 { 220,7798 }, { 221,7798 }, { 222,7798 }, { 223,7798 }, { 224,7798 },
 { 225,7798 }, { 226,7798 }, { 227,7798 }, { 228,7798 }, { 229,7798 },
 { 230,7798 }, { 231,7798 }, { 232,7798 }, { 233,7798 }, { 234,7798 },

 { 235,7798 }, { 236,7798 }, { 237,7798 }, { 238,7798 }, { 239,7798 },
 { 240,7798 }, { 241,7798 }, { 242,7798 }, { 243,7798 }, { 244,7798 },
 { 245,7798 }, { 246,7798 }, { 247,7798 }, { 248,7798 }, { 249,7798 },
 { 250,7798 }, { 251,7798 }, { 252,7798 }, { 253,7798 }, { 254,7798 },
 { 255,7798 }, { 256,7798 }, {   0,   0 }, {   0,32917 }, {   1,7540 },
 {   2,7540 }, {   3,7540 }, {   4,7540 }, {   5,7540 }, {   6,7540 },
 {   7,7540 }, {   8,7540 }, {   9,7540 }, {  10,7798 }, {  11,7540 },
 {  12,7540 }, {  13,7540 }, {  14,7540 }, {  15,7540 }, {  16,7540 },
 {  17,7540 }, {  18,7540 }, {  19,7540 }, {  20,7540 }, {  21,7540 },
 {  22,7540 }, {  23,7540 }, {  24,7540 }, {  25,7540 }, {  26,7540 },

 {  27,7540 }, {  28,7540 }, {  29,7540 }, {  30,7540 }, {  31,7540 },
 {  32,7540 }, {  33,7540 }, {  34,7540 }, {  35,7540 }, {  36,8056 },
 {  37,7540 }, {  38,7540 }, {  39,7540 }, {  40,7540 }, {  41,7540 },
 {  42,7540 }, {  43,7540 }, {  44,7540 }, {  45,7540 }, {  46,7540 },
 {  47,7540 }, {  48,7540 }, {  49,7540 }, {  50,7540 }, {  51,7540 },
 {  52,7540 }, {  53,7540 }, {  54,7540 }, {  55,7540 }, {  56,7540 },
 {  57,7540 }, {  58,7540 }, {  59,7540 }, {  60,7540 }, {  61,7540 },
 {  62,7540 }, {  63,7540 }, {  64,7540 }, {  65,7540 }, {  66,7540 },
 {  67,7540 }, {  68,7540 }, {  69,7540 }, {  70,7540 }, {  71,7540 },
 {  72,7540 }, {  73,7540 }, {  74,7540 }, {  75,7540 }, {  76,7540 },

 {  77,7540 }, {  78,7540 }, {  79,7540 }, {  80,7540 }, {  81,7540 },
 {  82,7540 }, {  83,7540 }, {  84,7540 }, {  85,7540 }, {  86,7540 },
 {  87,7540 }, {  88,7540 }, {  89,7540 }, {  90,7540 }, {  91,7540 },
 {  92,7540 }, {  93,7540 }, {  94,7540 }, {  95,7540 }, {  96,7540 },
 {  97,7540 }, {  98,7540 }, {  99,7540 }, { 100,7540 }, { 101,7540 },
 { 102,7540 }, { 103,7540 }, { 104,7540 }, { 105,7540 }, { 106,7540 },
 { 107,7540 }, { 108,7540 }, { 109,7540 }, { 110,7540 }, { 111,7540 },
 { 112,7540 }, { 113,7540 }, { 114,7540 }, { 115,7540 }, { 116,7540 },
 { 117,7540 }, { 118,7540 }, { 119,7540 }, { 120,7540 }, { 121,7540 },
 { 122,7540 }, { 123,7540 }, { 124,7540 }, { 125,7540 }, { 126,7540 },

 { 127,7540 }, { 128,7540 }, { 129,7540 }, { 130,7540 }, { 131,7540 },
 { 132,7540 }, { 133,7540 }, { 134,7540 }, { 135,7540 }, { 136,7540 },
 { 137,7540 }, { 138,7540 }, { 139,7540 }, { 140,7540 }, { 141,7540 },
 { 142,7540 }, { 143,7540 }, { 144,7540 }, { 145,7540 }, { 146,7540 },
 { 147,7540 }, { 148,7540 }, { 149,7540 }, { 150,7540 }, { 151,7540 },
 { 152,7540 }, { 153,7540 }, { 154,7540 }, { 155,7540 }, { 156,7540 },
 { 157,7540 }, { 158,7540 }, { 159,7540 }, { 160,7540 }, { 161,7540 },
 { 162,7540 }, { 163,7540 }, { 164,7540 }, { 165,7540 }, { 166,7540 },
 { 167,7540 }, { 168,7540 }, { 169,7540 }, { 170,7540 }, { 171,7540 },
 { 172,7540 }, { 173,7540 }, { 174,7540 }, { 175,7540 }, { 176,7540 },

 { 177,7540 }, { 178,7540 }, { 179,7540 }, { 180,7540 }, { 181,7540 },
 { 182,7540 }, { 183,7540 }, { 184,7540 }, { 185,7540 }, { 186,7540 },
 { 187,7540 }, { 188,7540 }, { 189,7540 }, { 190,7540 }, { 191,7540 },
 { 192,7540 }, { 193,7540 }, { 194,7540 }, { 195,7540 }, { 196,7540 },
 { 197,7540 }, { 198,7540 }, { 199,7540 }, { 200,7540 }, { 201,7540 },
 { 202,7540 }, { 203,7540 }, { 204,7540 }, { 205,7540 }, { 206,7540 },
 { 207,7540 }, { 208,7540 }, { 209,7540 }, { 210,7540 }, { 211,7540 },
 { 212,7540 }, { 213,7540 }, { 214,7540 }, { 215,7540 }, { 216,7540 },
 { 217,7540 }, { 218,7540 }, { 219,7540 }, { 220,7540 }, { 221,7540 },
 { 222,7540 }, { 223,7540 }, { 224,7540 }, { 225,7540 }, { 226,7540 },

 { 227,7540 }, { 228,7540 }, { 229,7540 }, { 230,7540 }, { 231,7540 },
 { 232,7540 }, { 233,7540 }, { 234,7540 }, { 235,7540 }, { 236,7540 },
 { 237,7540 }, { 238,7540 }, { 239,7540 }, { 240,7540 }, { 241,7540 },
 { 242,7540 }, { 243,7540 }, { 244,7540 }, { 245,7540 }, { 246,7540 },
 { 247,7540 }, { 248,7540 }, { 249,7540 }, { 250,7540 }, { 251,7540 },
 { 252,7540 }, { 253,7540 }, { 254,7540 }, { 255,7540 }, { 256,7540 },
 {   0,   0 }, {   0,32659 }, {   1,5593 }, {   2,5593 }, {   3,5593 },
 {   4,5593 }, {   5,5593 }, {   6,5593 }, {   7,5593 }, {   8,5593 },
 {   9,5593 }, {  10,5593 }, {  11,5593 }, {  12,5593 }, {  13,5593 },
 {  14,5593 }, {  15,5593 }, {  16,5593 }, {  17,5593 }, {  18,5593 },

 {  19,5593 }, {  20,5593 }, {  21,5593 }, {  22,5593 }, {  23,5593 },
 {  24,5593 }, {  25,5593 }, {  26,5593 }, {  27,5593 }, {  28,5593 },
 {  29,5593 }, {  30,5593 }, {  31,5593 }, {  32,5593 }, {  33,5593 },
 {  34,2639 }, {  35,5593 }, {  36,5593 }, {  37,5593 }, {  38,5593 },
 {  39,5593 }, {  40,5593 }, {  41,5593 }, {  42,5593 }, {  43,5593 },
 {  44,5593 }, {  45,5593 }, {  46,5593 }, {  47,5593 }, {  48,5593 },
 {  49,5593 }, {  50,5593 }, {  51,5593 }, {  52,5593 }, {  53,5593 },
 {  54,5593 }, {  55,5593 }, {  56,5593 }, {  57,5593 }, {  58,5593 },
 {  59,5593 }, {  60,5593 }, {  61,5593 }, {  62,5593 }, {  63,5593 },
 {  64,5593 }, {  65,5593 }, {  66,5593 }, {  67,5593 }, {  68,5593 },

 {  69,5593 }, {  70,5593 }, {  71,5593 }, {  72,5593 }, {  73,5593 },
 {  74,5593 }, {  75,5593 }, {  76,5593 }, {  77,5593 }, {  78,5593 },
 {  79,5593 }, {  80,5593 }, {  81,5593 }, {  82,5593 }, {  83,5593 },
 {  84,5593 }, {  85,5593 }, {  86,5593 }, {  87,5593 }, {  88,5593 },
 {  89,5593 }, {  90,5593 }, {  91,5593 }, {  92,5593 }, {  93,5593 },
 {  94,5593 }, {  95,5593 }, {  96,5593 }, {  97,5593 }, {  98,5593 },
 {  99,5593 }, { 100,5593 }, { 101,5593 }, { 102,5593 }, { 103,5593 },
 { 104,5593 }, { 105,5593 }, { 106,5593 }, { 107,5593 }, { 108,5593 },
 { 109,5593 }, { 110,5593 }, { 111,5593 }, { 112,5593 }, { 113,5593 },
 { 114,5593 }, { 115,5593 }, { 116,5593 }, { 117,5593 }, { 118,5593 },

 { 119,5593 }, { 120,5593 }, { 121,5593 }, { 122,5593 }, { 123,5593 },
 { 124,5593 }, { 125,5593 }, { 126,5593 }, { 127,5593 }, { 128,5593 },
 { 129,5593 }, { 130,5593 }, { 131,5593 }, { 132,5593 }, { 133,5593 },
 { 134,5593 }, { 135,5593 }, { 136,5593 }, { 137,5593 }, { 138,5593 },
 { 139,5593 }, { 140,5593 }, { 141,5593 }, { 142,5593 }, { 143,5593 },
 { 144,5593 }, { 145,5593 }, { 146,5593 }, { 147,5593 }, { 148,5593 },
 { 149,5593 }, { 150,5593 }, { 151,5593 }, { 152,5593 }, { 153,5593 },
 { 154,5593 }, { 155,5593 }, { 156,5593 }, { 157,5593 }, { 158,5593 },
 { 159,5593 }, { 160,5593 }, { 161,5593 }, { 162,5593 }, { 163,5593 },
 { 164,5593 }, { 165,5593 }, { 166,5593 }, { 167,5593 }, { 168,5593 },

 { 169,5593 }, { 170,5593 }, { 171,5593 }, { 172,5593 }, { 173,5593 },
 { 174,5593 }, { 175,5593 }, { 176,5593 }, { 177,5593 }, { 178,5593 },
 { 179,5593 }, { 180,5593 }, { 181,5593 }, { 182,5593 }, { 183,5593 },
 { 184,5593 }, { 185,5593 }, { 186,5593 }, { 187,5593 }, { 188,5593 },
 { 189,5593 }, { 190,5593 }, { 191,5593 }, { 192,5593 }, { 193,5593 },
 { 194,5593 }, { 195,5593 }, { 196,5593 }, { 197,5593 }, { 198,5593 },
 { 199,5593 }, { 200,5593 }, { 201,5593 }, { 202,5593 }, { 203,5593 },
 { 204,5593 }, { 205,5593 }, { 206,5593 }, { 207,5593 }, { 208,5593 },
 { 209,5593 }, { 210,5593 }, { 211,5593 }, { 212,5593 }, { 213,5593 },
 { 214,5593 }, { 215,5593 }, { 216,5593 }, { 217,5593 }, { 218,5593 },

 { 219,5593 }, { 220,5593 }, { 221,5593 }, { 222,5593 }, { 223,5593 },
 { 224,5593 }, { 225,5593 }, { 226,5593 }, { 227,5593 }, { 228,5593 },
 { 229,5593 }, { 230,5593 }, { 231,5593 }, { 232,5593 }, { 233,5593 },
 { 234,5593 }, { 235,5593 }, { 236,5593 }, { 237,5593 }, { 238,5593 },
 { 239,5593 }, { 240,5593 }, { 241,5593 }, { 242,5593 }, { 243,5593 },
 { 244,5593 }, { 245,5593 }, { 246,5593 }, { 247,5593 }, { 248,5593 },
 { 249,5593 }, { 250,5593 }, { 251,5593 }, { 252,5593 }, { 253,5593 },
 { 254,5593 }, { 255,5593 }, { 256,5593 }, {   0,   0 }, {   0,32401 },
 {   1,5335 }, {   2,5335 }, {   3,5335 }, {   4,5335 }, {   5,5335 },
 {   6,5335 }, {   7,5335 }, {   8,5335 }, {   9,5335 }, {  10,5335 },

 {  11,5335 }, {  12,5335 }, {  13,5335 }, {  14,5335 }, {  15,5335 },
 {  16,5335 }, {  17,5335 }, {  18,5335 }, {  19,5335 }, {  20,5335 },
 {  21,5335 }, {  22,5335 }, {  23,5335 }, {  24,5335 }, {  25,5335 },
 {  26,5335 }, {  27,5335 }, {  28,5335 }, {  29,5335 }, {  30,5335 },
 {  31,5335 }, {  32,5335 }, {  33,5335 }, {  34,2381 }, {  35,5335 },
 {  36,5335 }, {  37,5335 }, {  38,5335 }, {  39,5335 }, {  40,5335 },
 {  41,5335 }, {  42,5335 }, {  43,5335 }, {  44,5335 }, {  45,5335 },
 {  46,5335 }, {  47,5335 }, {  48,5335 }, {  49,5335 }, {  50,5335 },
 {  51,5335 }, {  52,5335 }, {  53,5335 }, {  54,5335 }, {  55,5335 },
 {  56,5335 }, {  57,5335 }, {  58,5335 }, {  59,5335 }, {  60,5335 },

 {  61,5335 }, {  62,5335 }, {  63,5335 }, {  64,5335 }, {  65,5335 },
 {  66,5335 }, {  67,5335 }, {  68,5335 }, {  69,5335 }, {  70,5335 },
 {  71,5335 }, {  72,5335 }, {  73,5335 }, {  74,5335 }, {  75,5335 },
 {  76,5335 }, {  77,5335 }, {  78,5335 }, {  79,5335 }, {  80,5335 },
 {  81,5335 }, {  82,5335 }, {  83,5335 }, {  84,5335 }, {  85,5335 },
 {  86,5335 }, {  87,5335 }, {  88,5335 }, {  89,5335 }, {  90,5335 },
 {  91,5335 }, {  92,5335 }, {  93,5335 }, {  94,5335 }, {  95,5335 },
 {  96,5335 }, {  97,5335 }, {  98,5335 }, {  99,5335 }, { 100,5335 },
 { 101,5335 }, { 102,5335 }, { 103,5335 }, { 104,5335 }, { 105,5335 },
 { 106,5335 }, { 107,5335 }, { 108,5335 }, { 109,5335 }, { 110,5335 },

 { 111,5335 }, { 112,5335 }, { 113,5335 }, { 114,5335 }, { 115,5335 },
 { 116,5335 }, { 117,5335 }, { 118,5335 }, { 119,5335 }, { 120,5335 },
 { 121,5335 }, { 122,5335 }, { 123,5335 }, { 124,5335 }, { 125,5335 },
 { 126,5335 }, { 127,5335 }, { 128,5335 }, { 129,5335 }, { 130,5335 },
 { 131,5335 }, { 132,5335 }, { 133,5335 }, { 134,5335 }, { 135,5335 },
 { 136,5335 }, { 137,5335 }, { 138,5335 }, { 139,5335 }, { 140,5335 },
 { 141,5335 }, { 142,5335 }, { 143,5335 }, { 144,5335 }, { 145,5335 },
 { 146,5335 }, { 147,5335 }, { 148,5335 }, { 149,5335 }, { 150,5335 },
 { 151,5335 }, { 152,5335 }, { 153,5335 }, { 154,5335 }, { 155,5335 },
 { 156,5335 }, { 157,5335 }, { 158,5335 }, { 159,5335 }, { 160,5335 },

 { 161,5335 }, { 162,5335 }, { 163,5335 }, { 164,5335 }, { 165,5335 },
 { 166,5335 }, { 167,5335 }, { 168,5335 }, { 169,5335 }, { 170,5335 },
 { 171,5335 }, { 172,5335 }, { 173,5335 }, { 174,5335 }, { 175,5335 },
 { 176,5335 }, { 177,5335 }, { 178,5335 }, { 179,5335 }, { 180,5335 },
 { 181,5335 }, { 182,5335 }, { 183,5335 }, { 184,5335 }, { 185,5335 },
 { 186,5335 }, { 187,5335 }, { 188,5335 }, { 189,5335 }, { 190,5335 },
 { 191,5335 }, { 192,5335 }, { 193,5335 }, { 194,5335 }, { 195,5335 },
 { 196,5335 }, { 197,5335 }, { 198,5335 }, { 199,5335 }, { 200,5335 },
 { 201,5335 }, { 202,5335 }, { 203,5335 }, { 204,5335 }, { 205,5335 },
 { 206,5335 }, { 207,5335 }, { 208,5335 }, { 209,5335 }, { 210,5335 },

 { 211,5335 }, { 212,5335 }, { 213,5335 }, { 214,5335 }, { 215,5335 },
 { 216,5335 }, { 217,5335 }, { 218,5335 }, { 219,5335 }, { 220,5335 },
 { 221,5335 }, { 222,5335 }, { 223,5335 }, { 224,5335 }, { 225,5335 },
 { 226,5335 }, { 227,5335 }, { 228,5335 }, { 229,5335 }, { 230,5335 },
 { 231,5335 }, { 232,5335 }, { 233,5335 }, { 234,5335 }, { 235,5335 },
 { 236,5335 }, { 237,5335 }, { 238,5335 }, { 239,5335 }, { 240,5335 },
 { 241,5335 }, { 242,5335 }, { 243,5335 }, { 244,5335 }, { 245,5335 },
 { 246,5335 }, { 247,5335 }, { 248,5335 }, { 249,5335 }, { 250,5335 },
 { 251,5335 }, { 252,5335 }, { 253,5335 }, { 254,5335 }, { 255,5335 },
 { 256,5335 }, {   0,  55 }, {   0,32143 }, {   1,2125 }, {   2,2125 },

 {   3,2125 }, {   4,2125 }, {   5,2125 }, {   6,2125 }, {   7,2125 },
 {   8,2125 }, {   9,7284 }, {  10,7289 }, {  11,2125 }, {  12,7284 },
 {  13,7284 }, {  14,2125 }, {  15,2125 }, {  16,2125 }, {  17,2125 },
 {  18,2125 }, {  19,2125 }, {  20,2125 }, {  21,2125 }, {  22,2125 },
 {  23,2125 }, {  24,2125 }, {  25,2125 }, {  26,2125 }, {  27,2125 },
 {  28,2125 }, {  29,2125 }, {  30,2125 }, {  31,2125 }, {  32,7284 },
 {  33,2125 }, {  34,2125 }, {  35,2125 }, {  36,2125 }, {  37,2125 },
 {  38,2125 }, {  39,2125 }, {  40,2125 }, {  41,2125 }, {  42,2125 },
 {  43,2125 }, {  44,2125 }, {  45,2127 }, {  46,2125 }, {  47,2125 },
 {  48,2125 }, {  49,2125 }, {  50,2125 }, {  51,2125 }, {  52,2125 },

 {  53,2125 }, {  54,2125 }, {  55,2125 }, {  56,2125 }, {  57,2125 },
 {  58,2125 }, {  59,2125 }, {  60,2125 }, {  61,2125 }, {  62,2125 },
 {  63,2125 }, {  64,2125 }, {  65,2125 }, {  66,2125 }, {  67,2125 },
 {  68,2125 }, {  69,2125 }, {  70,2125 }, {  71,2125 }, {  72,2125 },
 {  73,2125 }, {  74,2125 }, {  75,2125 }, {  76,2125 }, {  77,2125 },
 {  78,2125 }, {  79,2125 }, {  80,2125 }, {  81,2125 }, {  82,2125 },
 {  83,2125 }, {  84,2125 }, {  85,2141 }, {  86,2125 }, {  87,2125 },
 {  88,2125 }, {  89,2125 }, {  90,2125 }, {  91,2125 }, {  92,2125 },
 {  93,2125 }, {  94,2125 }, {  95,2125 }, {  96,2125 }, {  97,2125 },
 {  98,2125 }, {  99,2125 }, { 100,2125 }, { 101,2125 }, { 102,2125 },

 { 103,2125 }, { 104,2125 }, { 105,2125 }, { 106,2125 }, { 107,2125 },
 { 108,2125 }, { 109,2125 }, { 110,2125 }, { 111,2125 }, { 112,2125 },
 { 113,2125 }, { 114,2125 }, { 115,2125 }, { 116,2125 }, { 117,2141 },
 { 118,2125 }, { 119,2125 }, { 120,2125 }, { 121,2125 }, { 122,2125 },
 { 123,2125 }, { 124,2125 }, { 125,2125 }, { 126,2125 }, { 127,2125 },
 { 128,2125 }, { 129,2125 }, { 130,2125 }, { 131,2125 }, { 132,2125 },
 { 133,2125 }, { 134,2125 }, { 135,2125 }, { 136,2125 }, { 137,2125 },
 { 138,2125 }, { 139,2125 }, { 140,2125 }, { 141,2125 }, { 142,2125 },
 { 143,2125 }, { 144,2125 }, { 145,2125 }, { 146,2125 }, { 147,2125 },
 { 148,2125 }, { 149,2125 }, { 150,2125 }, { 151,2125 }, { 152,2125 },

 { 153,2125 }, { 154,2125 }, { 155,2125 }, { 156,2125 }, { 157,2125 },
 { 158,2125 }, { 159,2125 }, { 160,2125 }, { 161,2125 }, { 162,2125 },
 { 163,2125 }, { 164,2125 }, { 165,2125 }, { 166,2125 }, { 167,2125 },
 { 168,2125 }, { 169,2125 }, { 170,2125 }, { 171,2125 }, { 172,2125 },
 { 173,2125 }, { 174,2125 }, { 175,2125 }, { 176,2125 }, { 177,2125 },
 { 178,2125 }, { 179,2125 }, { 180,2125 }, { 181,2125 }, { 182,2125 },
 { 183,2125 }, { 184,2125 }, { 185,2125 }, { 186,2125 }, { 187,2125 },
 { 188,2125 }, { 189,2125 }, { 190,2125 }, { 191,2125 }, { 192,2125 },
 { 193,2125 }, { 194,2125 }, { 195,2125 }, { 196,2125 }, { 197,2125 },
 { 198,2125 }, { 199,2125 }, { 200,2125 }, { 201,2125 }, { 202,2125 },

 { 203,2125 }, { 204,2125 }, { 205,2125 }, { 206,2125 }, { 207,2125 },
 { 208,2125 }, { 209,2125 }, { 210,2125 }, { 211,2125 }, { 212,2125 },
 { 213,2125 }, { 214,2125 }, { 215,2125 }, { 216,2125 }, { 217,2125 },
 { 218,2125 }, { 219,2125 }, { 220,2125 }, { 221,2125 }, { 222,2125 },
 { 223,2125 }, { 224,2125 }, { 225,2125 }, { 226,2125 }, { 227,2125 },
 { 228,2125 }, { 229,2125 }, { 230,2125 }, { 231,2125 }, { 232,2125 },
 { 233,2125 }, { 234,2125 }, { 235,2125 }, { 236,2125 }, { 237,2125 },
 { 238,2125 }, { 239,2125 }, { 240,2125 }, { 241,2125 }, { 242,2125 },
 { 243,2125 }, { 244,2125 }, { 245,2125 }, { 246,2125 }, { 247,2125 },
 { 248,2125 }, { 249,2125 }, { 250,2125 }, { 251,2125 }, { 252,2125 },

 { 253,2125 }, { 254,2125 }, { 255,2125 }, { 256,2125 }, {   0,  55 },
 {   0,31885 }, {   1,1867 }, {   2,1867 }, {   3,1867 }, {   4,1867 },
 {   5,1867 }, {   6,1867 }, {   7,1867 }, {   8,1867 }, {   9,7026 },
 {  10,7031 }, {  11,1867 }, {  12,7026 }, {  13,7026 }, {  14,1867 },
 {  15,1867 }, {  16,1867 }, {  17,1867 }, {  18,1867 }, {  19,1867 },
 {  20,1867 }, {  21,1867 }, {  22,1867 }, {  23,1867 }, {  24,1867 },
 {  25,1867 }, {  26,1867 }, {  27,1867 }, {  28,1867 }, {  29,1867 },
 {  30,1867 }, {  31,1867 }, {  32,7026 }, {  33,1867 }, {  34,1867 },
 {  35,1867 }, {  36,1867 }, {  37,1867 }, {  38,1867 }, {  39,1867 },
 {  40,1867 }, {  41,1867 }, {  42,1867 }, {  43,1867 }, {  44,1867 },

 {  45,1869 }, {  46,1867 }, {  47,1867 }, {  48,1867 }, {  49,1867 },
 {  50,1867 }, {  51,1867 }, {  52,1867 }, {  53,1867 }, {  54,1867 },
 {  55,1867 }, {  56,1867 }, {  57,1867 }, {  58,1867 }, {  59,1867 },
 {  60,1867 }, {  61,1867 }, {  62,1867 }, {  63,1867 }, {  64,1867 },
 {  65,1867 }, {  66,1867 }, {  67,1867 }, {  68,1867 }, {  69,1867 },
 {  70,1867 }, {  71,1867 }, {  72,1867 }, {  73,1867 }, {  74,1867 },
 {  75,1867 }, {  76,1867 }, {  77,1867 }, {  78,1867 }, {  79,1867 },
 {  80,1867 }, {  81,1867 }, {  82,1867 }, {  83,1867 }, {  84,1867 },
 {  85,1883 }, {  86,1867 }, {  87,1867 }, {  88,1867 }, {  89,1867 },
 {  90,1867 }, {  91,1867 }, {  92,1867 }, {  93,1867 }, {  94,1867 },

 {  95,1867 }, {  96,1867 }, {  97,1867 }, {  98,1867 }, {  99,1867 },
 { 100,1867 }, { 101,1867 }, { 102,1867 }, { 103,1867 }, { 104,1867 },
 { 105,1867 }, { 106,1867 }, { 107,1867 }, { 108,1867 }, { 109,1867 },
 { 110,1867 }, { 111,1867 }, { 112,1867 }, { 113,1867 }, { 114,1867 },
 { 115,1867 }, { 116,1867 }, { 117,1883 }, { 118,1867 }, { 119,1867 },
 { 120,1867 }, { 121,1867 }, { 122,1867 }, { 123,1867 }, { 124,1867 },
 { 125,1867 }, { 126,1867 }, { 127,1867 }, { 128,1867 }, { 129,1867 },
 { 130,1867 }, { 131,1867 }, { 132,1867 }, { 133,1867 }, { 134,1867 },
 { 135,1867 }, { 136,1867 }, { 137,1867 }, { 138,1867 }, { 139,1867 },
 { 140,1867 }, { 141,1867 }, { 142,1867 }, { 143,1867 }, { 144,1867 },

 { 145,1867 }, { 146,1867 }, { 147,1867 }, { 148,1867 }, { 149,1867 },
 { 150,1867 }, { 151,1867 }, { 152,1867 }, { 153,1867 }, { 154,1867 },
 { 155,1867 }, { 156,1867 }, { 157,1867 }, { 158,1867 }, { 159,1867 },
 { 160,1867 }, { 161,1867 }, { 162,1867 }, { 163,1867 }, { 164,1867 },
 { 165,1867 }, { 166,1867 }, { 167,1867 }, { 168,1867 }, { 169,1867 },
 { 170,1867 }, { 171,1867 }, { 172,1867 }, { 173,1867 }, { 174,1867 },
 { 175,1867 }, { 176,1867 }, { 177,1867 }, { 178,1867 }, { 179,1867 },
 { 180,1867 }, { 181,1867 }, { 182,1867 }, { 183,1867 }, { 184,1867 },
 { 185,1867 }, { 186,1867 }, { 187,1867 }, { 188,1867 }, { 189,1867 },
 { 190,1867 }, { 191,1867 }, { 192,1867 }, { 193,1867 }, { 194,1867 },

 { 195,1867 }, { 196,1867 }, { 197,1867 }, { 198,1867 }, { 199,1867 },
 { 200,1867 }, { 201,1867 }, { 202,1867 }, { 203,1867 }, { 204,1867 },
 { 205,1867 }, { 206,1867 }, { 207,1867 }, { 208,1867 }, { 209,1867 },
 { 210,1867 }, { 211,1867 }, { 212,1867 }, { 213,1867 }, { 214,1867 },
 { 215,1867 }, { 216,1867 }, { 217,1867 }, { 218,1867 }, { 219,1867 },
 { 220,1867 }, { 221,1867 }, { 222,1867 }, { 223,1867 }, { 224,1867 },
 { 225,1867 }, { 226,1867 }, { 227,1867 }, { 228,1867 }, { 229,1867 },
 { 230,1867 }, { 231,1867 }, { 232,1867 }, { 233,1867 }, { 234,1867 },
 { 235,1867 }, { 236,1867 }, { 237,1867 }, { 238,1867 }, { 239,1867 },
 { 240,1867 }, { 241,1867 }, { 242,1867 }, { 243,1867 }, { 244,1867 },

 { 245,1867 }, { 246,1867 }, { 247,1867 }, { 248,1867 }, { 249,1867 },
 { 250,1867 }, { 251,1867 }, { 252,1867 }, { 253,1867 }, { 254,1867 },
 { 255,1867 }, { 256,1867 }, {   0,   0 }, {   0,31627 }, {   1,5124 },
 {   2,5124 }, {   3,5124 }, {   4,5124 }, {   5,5124 }, {   6,5124 },
 {   7,5124 }, {   8,5124 }, {   9,5124 }, {  10,5124 }, {  11,5124 },
 {  12,5124 }, {  13,5124 }, {  14,5124 }, {  15,5124 }, {  16,5124 },
 {  17,5124 }, {  18,5124 }, {  19,5124 }, {  20,5124 }, {  21,5124 },
 {  22,5124 }, {  23,5124 }, {  24,5124 }, {  25,5124 }, {  26,5124 },
 {  27,5124 }, {  28,5124 }, {  29,5124 }, {  30,5124 }, {  31,5124 },
 {  32,5124 }, {  33,5124 }, {  34,5124 }, {  35,5124 }, {  36,5124 },

 {  37,5124 }, {  38,5124 }, {  39,7023 }, {  40,5124 }, {  41,5124 },
 {  42,5124 }, {  43,5124 }, {  44,5124 }, {  45,5124 }, {  46,5124 },
 {  47,5124 }, {  48,5124 }, {  49,5124 }, {  50,5124 }, {  51,5124 },
 {  52,5124 }, {  53,5124 }, {  54,5124 }, {  55,5124 }, {  56,5124 },
 {  57,5124 }, {  58,5124 }, {  59,5124 }, {  60,5124 }, {  61,5124 },
 {  62,5124 }, {  63,5124 }, {  64,5124 }, {  65,5124 }, {  66,5124 },
 {  67,5124 }, {  68,5124 }, {  69,5124 }, {  70,5124 }, {  71,5124 },
 {  72,5124 }, {  73,5124 }, {  74,5124 }, {  75,5124 }, {  76,5124 },
 {  77,5124 }, {  78,5124 }, {  79,5124 }, {  80,5124 }, {  81,5124 },
 {  82,5124 }, {  83,5124 }, {  84,5124 }, {  85,5124 }, {  86,5124 },

 {  87,5124 }, {  88,5124 }, {  89,5124 }, {  90,5124 }, {  91,5124 },
 {  92,5124 }, {  93,5124 }, {  94,5124 }, {  95,5124 }, {  96,5124 },
 {  97,5124 }, {  98,5124 }, {  99,5124 }, { 100,5124 }, { 101,5124 },
 { 102,5124 }, { 103,5124 }, { 104,5124 }, { 105,5124 }, { 106,5124 },
 { 107,5124 }, { 108,5124 }, { 109,5124 }, { 110,5124 }, { 111,5124 },
 { 112,5124 }, { 113,5124 }, { 114,5124 }, { 115,5124 }, { 116,5124 },
 { 117,5124 }, { 118,5124 }, { 119,5124 }, { 120,5124 }, { 121,5124 },
 { 122,5124 }, { 123,5124 }, { 124,5124 }, { 125,5124 }, { 126,5124 },
 { 127,5124 }, { 128,5124 }, { 129,5124 }, { 130,5124 }, { 131,5124 },
 { 132,5124 }, { 133,5124 }, { 134,5124 }, { 135,5124 }, { 136,5124 },

 { 137,5124 }, { 138,5124 }, { 139,5124 }, { 140,5124 }, { 141,5124 },
 { 142,5124 }, { 143,5124 }, { 144,5124 }, { 145,5124 }, { 146,5124 },
 { 147,5124 }, { 148,5124 }, { 149,5124 }, { 150,5124 }, { 151,5124 },
 { 152,5124 }, { 153,5124 }, { 154,5124 }, { 155,5124 }, { 156,5124 },
 { 157,5124 }, { 158,5124 }, { 159,5124 }, { 160,5124 }, { 161,5124 },
 { 162,5124 }, { 163,5124 }, { 164,5124 }, { 165,5124 }, { 166,5124 },
 { 167,5124 }, { 168,5124 }, { 169,5124 }, { 170,5124 }, { 171,5124 },
 { 172,5124 }, { 173,5124 }, { 174,5124 }, { 175,5124 }, { 176,5124 },
 { 177,5124 }, { 178,5124 }, { 179,5124 }, { 180,5124 }, { 181,5124 },
 { 182,5124 }, { 183,5124 }, { 184,5124 }, { 185,5124 }, { 186,5124 },

 { 187,5124 }, { 188,5124 }, { 189,5124 }, { 190,5124 }, { 191,5124 },
 { 192,5124 }, { 193,5124 }, { 194,5124 }, { 195,5124 }, { 196,5124 },
 { 197,5124 }, { 198,5124 }, { 199,5124 }, { 200,5124 }, { 201,5124 },
 { 202,5124 }, { 203,5124 }, { 204,5124 }, { 205,5124 }, { 206,5124 },
 { 207,5124 }, { 208,5124 }, { 209,5124 }, { 210,5124 }, { 211,5124 },
 { 212,5124 }, { 213,5124 }, { 214,5124 }, { 215,5124 }, { 216,5124 },
 { 217,5124 }, { 218,5124 }, { 219,5124 }, { 220,5124 }, { 221,5124 },
 { 222,5124 }, { 223,5124 }, { 224,5124 }, { 225,5124 }, { 226,5124 },
 { 227,5124 }, { 228,5124 }, { 229,5124 }, { 230,5124 }, { 231,5124 },
 { 232,5124 }, { 233,5124 }, { 234,5124 }, { 235,5124 }, { 236,5124 },

 { 237,5124 }, { 238,5124 }, { 239,5124 }, { 240,5124 }, { 241,5124 },
 { 242,5124 }, { 243,5124 }, { 244,5124 }, { 245,5124 }, { 246,5124 },
 { 247,5124 }, { 248,5124 }, { 249,5124 }, { 250,5124 }, { 251,5124 },
 { 252,5124 }, { 253,5124 }, { 254,5124 }, { 255,5124 }, { 256,5124 },
 {   0,   0 }, {   0,31369 }, {   1,4866 }, {   2,4866 }, {   3,4866 },
 {   4,4866 }, {   5,4866 }, {   6,4866 }, {   7,4866 }, {   8,4866 },
 {   9,4866 }, {  10,4866 }, {  11,4866 }, {  12,4866 }, {  13,4866 },
 {  14,4866 }, {  15,4866 }, {  16,4866 }, {  17,4866 }, {  18,4866 },
 {  19,4866 }, {  20,4866 }, {  21,4866 }, {  22,4866 }, {  23,4866 },
 {  24,4866 }, {  25,4866 }, {  26,4866 }, {  27,4866 }, {  28,4866 },

 {  29,4866 }, {  30,4866 }, {  31,4866 }, {  32,4866 }, {  33,4866 },
 {  34,4866 }, {  35,4866 }, {  36,4866 }, {  37,4866 }, {  38,4866 },
 {  39,6765 }, {  40,4866 }, {  41,4866 }, {  42,4866 }, {  43,4866 },
 {  44,4866 }, {  45,4866 }, {  46,4866 }, {  47,4866 }, {  48,4866 },
 {  49,4866 }, {  50,4866 }, {  51,4866 }, {  52,4866 }, {  53,4866 },
 {  54,4866 }, {  55,4866 }, {  56,4866 }, {  57,4866 }, {  58,4866 },
 {  59,4866 }, {  60,4866 }, {  61,4866 }, {  62,4866 }, {  63,4866 },
 {  64,4866 }, {  65,4866 }, {  66,4866 }, {  67,4866 }, {  68,4866 },
 {  69,4866 }, {  70,4866 }, {  71,4866 }, {  72,4866 }, {  73,4866 },
 {  74,4866 }, {  75,4866 }, {  76,4866 }, {  77,4866 }, {  78,4866 },

 {  79,4866 }, {  80,4866 }, {  81,4866 }, {  82,4866 }, {  83,4866 },
 {  84,4866 }, {  85,4866 }, {  86,4866 }, {  87,4866 }, {  88,4866 },
 {  89,4866 }, {  90,4866 }, {  91,4866 }, {  92,4866 }, {  93,4866 },
 {  94,4866 }, {  95,4866 }, {  96,4866 }, {  97,4866 }, {  98,4866 },
 {  99,4866 }, { 100,4866 }, { 101,4866 }, { 102,4866 }, { 103,4866 },
 { 104,4866 }, { 105,4866 }, { 106,4866 }, { 107,4866 }, { 108,4866 },
 { 109,4866 }, { 110,4866 }, { 111,4866 }, { 112,4866 }, { 113,4866 },
 { 114,4866 }, { 115,4866 }, { 116,4866 }, { 117,4866 }, { 118,4866 },
 { 119,4866 }, { 120,4866 }, { 121,4866 }, { 122,4866 }, { 123,4866 },
 { 124,4866 }, { 125,4866 }, { 126,4866 }, { 127,4866 }, { 128,4866 },

 { 129,4866 }, { 130,4866 }, { 131,4866 }, { 132,4866 }, { 133,4866 },
 { 134,4866 }, { 135,4866 }, { 136,4866 }, { 137,4866 }, { 138,4866 },
 { 139,4866 }, { 140,4866 }, { 141,4866 }, { 142,4866 }, { 143,4866 },
 { 144,4866 }, { 145,4866 }, { 146,4866 }, { 147,4866 }, { 148,4866 },
 { 149,4866 }, { 150,4866 }, { 151,4866 }, { 152,4866 }, { 153,4866 },
 { 154,4866 }, { 155,4866 }, { 156,4866 }, { 157,4866 }, { 158,4866 },
 { 159,4866 }, { 160,4866 }, { 161,4866 }, { 162,4866 }, { 163,4866 },
 { 164,4866 }, { 165,4866 }, { 166,4866 }, { 167,4866 }, { 168,4866 },
 { 169,4866 }, { 170,4866 }, { 171,4866 }, { 172,4866 }, { 173,4866 },
 { 174,4866 }, { 175,4866 }, { 176,4866 }, { 177,4866 }, { 178,4866 },

 { 179,4866 }, { 180,4866 }, { 181,4866 }, { 182,4866 }, { 183,4866 },
 { 184,4866 }, { 185,4866 }, { 186,4866 }, { 187,4866 }, { 188,4866 },
 { 189,4866 }, { 190,4866 }, { 191,4866 }, { 192,4866 }, { 193,4866 },
 { 194,4866 }, { 195,4866 }, { 196,4866 }, { 197,4866 }, { 198,4866 },
 { 199,4866 }, { 200,4866 }, { 201,4866 }, { 202,4866 }, { 203,4866 },
 { 204,4866 }, { 205,4866 }, { 206,4866 }, { 207,4866 }, { 208,4866 },
 { 209,4866 }, { 210,4866 }, { 211,4866 }, { 212,4866 }, { 213,4866 },
 { 214,4866 }, { 215,4866 }, { 216,4866 }, { 217,4866 }, { 218,4866 },
 { 219,4866 }, { 220,4866 }, { 221,4866 }, { 222,4866 }, { 223,4866 },
 { 224,4866 }, { 225,4866 }, { 226,4866 }, { 227,4866 }, { 228,4866 },

 { 229,4866 }, { 230,4866 }, { 231,4866 }, { 232,4866 }, { 233,4866 },
 { 234,4866 }, { 235,4866 }, { 236,4866 }, { 237,4866 }, { 238,4866 },
 { 239,4866 }, { 240,4866 }, { 241,4866 }, { 242,4866 }, { 243,4866 },
 { 244,4866 }, { 245,4866 }, { 246,4866 }, { 247,4866 }, { 248,4866 },
 { 249,4866 }, { 250,4866 }, { 251,4866 }, { 252,4866 }, { 253,4866 },
 { 254,4866 }, { 255,4866 }, { 256,4866 }, {   0,  28 }, {   0,31111 },
 {   1,1113 }, {   2,1113 }, {   3,1113 }, {   4,1113 }, {   5,1113 },
 {   6,1113 }, {   7,1113 }, {   8,1113 }, {   9,6512 }, {  10,6528 },
 {  11,1113 }, {  12,6512 }, {  13,6512 }, {  14,1113 }, {  15,1113 },
 {  16,1113 }, {  17,1113 }, {  18,1113 }, {  19,1113 }, {  20,1113 },

 {  21,1113 }, {  22,1113 }, {  23,1113 }, {  24,1113 }, {  25,1113 },
 {  26,1113 }, {  27,1113 }, {  28,1113 }, {  29,1113 }, {  30,1113 },
 {  31,1113 }, {  32,6512 }, {  33,1113 }, {  34,1113 }, {  35,1113 },
 {  36,1113 }, {  37,1113 }, {  38,1113 }, {  39,1113 }, {  40,1113 },
 {  41,1113 }, {  42,1113 }, {  43,1113 }, {  44,1113 }, {  45,1131 },
 {  46,1113 }, {  47,1113 }, {  48,1113 }, {  49,1113 }, {  50,1113 },
 {  51,1113 }, {  52,1113 }, {  53,1113 }, {  54,1113 }, {  55,1113 },
 {  56,1113 }, {  57,1113 }, {  58,1113 }, {  59,1113 }, {  60,1113 },
 {  61,1113 }, {  62,1113 }, {  63,1113 }, {  64,1113 }, {  65,1113 },
 {  66,1113 }, {  67,1113 }, {  68,1113 }, {  69,1113 }, {  70,1113 },

 {  71,1113 }, {  72,1113 }, {  73,1113 }, {  74,1113 }, {  75,1113 },
 {  76,1113 }, {  77,1113 }, {  78,1113 }, {  79,1113 }, {  80,1113 },
 {  81,1113 }, {  82,1113 }, {  83,1113 }, {  84,1113 }, {  85,1139 },
 {  86,1113 }, {  87,1113 }, {  88,1113 }, {  89,1113 }, {  90,1113 },
 {  91,1113 }, {  92,1113 }, {  93,1113 }, {  94,1113 }, {  95,1113 },
 {  96,1113 }, {  97,1113 }, {  98,1113 }, {  99,1113 }, { 100,1113 },
 { 101,1113 }, { 102,1113 }, { 103,1113 }, { 104,1113 }, { 105,1113 },
 { 106,1113 }, { 107,1113 }, { 108,1113 }, { 109,1113 }, { 110,1113 },
 { 111,1113 }, { 112,1113 }, { 113,1113 }, { 114,1113 }, { 115,1113 },
 { 116,1113 }, { 117,1139 }, { 118,1113 }, { 119,1113 }, { 120,1113 },

 { 121,1113 }, { 122,1113 }, { 123,1113 }, { 124,1113 }, { 125,1113 },
 { 126,1113 }, { 127,1113 }, { 128,1113 }, { 129,1113 }, { 130,1113 },
 { 131,1113 }, { 132,1113 }, { 133,1113 }, { 134,1113 }, { 135,1113 },
 { 136,1113 }, { 137,1113 }, { 138,1113 }, { 139,1113 }, { 140,1113 },
 { 141,1113 }, { 142,1113 }, { 143,1113 }, { 144,1113 }, { 145,1113 },
 { 146,1113 }, { 147,1113 }, { 148,1113 }, { 149,1113 }, { 150,1113 },
 { 151,1113 }, { 152,1113 }, { 153,1113 }, { 154,1113 }, { 155,1113 },
 { 156,1113 }, { 157,1113 }, { 158,1113 }, { 159,1113 }, { 160,1113 },
 { 161,1113 }, { 162,1113 }, { 163,1113 }, { 164,1113 }, { 165,1113 },
 { 166,1113 }, { 167,1113 }, { 168,1113 }, { 169,1113 }, { 170,1113 },

 { 171,1113 }, { 172,1113 }, { 173,1113 }, { 174,1113 }, { 175,1113 },
 { 176,1113 }, { 177,1113 }, { 178,1113 }, { 179,1113 }, { 180,1113 },
 { 181,1113 }, { 182,1113 }, { 183,1113 }, { 184,1113 }, { 185,1113 },
 { 186,1113 }, { 187,1113 }, { 188,1113 }, { 189,1113 }, { 190,1113 },
 { 191,1113 }, { 192,1113 }, { 193,1113 }, { 194,1113 }, { 195,1113 },
 { 196,1113 }, { 197,1113 }, { 198,1113 }, { 199,1113 }, { 200,1113 },
 { 201,1113 }, { 202,1113 }, { 203,1113 }, { 204,1113 }, { 205,1113 },
 { 206,1113 }, { 207,1113 }, { 208,1113 }, { 209,1113 }, { 210,1113 },
 { 211,1113 }, { 212,1113 }, { 213,1113 }, { 214,1113 }, { 215,1113 },
 { 216,1113 }, { 217,1113 }, { 218,1113 }, { 219,1113 }, { 220,1113 },

 { 221,1113 }, { 222,1113 }, { 223,1113 }, { 224,1113 }, { 225,1113 },
 { 226,1113 }, { 227,1113 }, { 228,1113 }, { 229,1113 }, { 230,1113 },
 { 231,1113 }, { 232,1113 }, { 233,1113 }, { 234,1113 }, { 235,1113 },
 { 236,1113 }, { 237,1113 }, { 238,1113 }, { 239,1113 }, { 240,1113 },
 { 241,1113 }, { 242,1113 }, { 243,1113 }, { 244,1113 }, { 245,1113 },
 { 246,1113 }, { 247,1113 }, { 248,1113 }, { 249,1113 }, { 250,1113 },
 { 251,1113 }, { 252,1113 }, { 253,1113 }, { 254,1113 }, { 255,1113 },
 { 256,1113 }, {   0,  28 }, {   0,30853 }, {   1, 855 }, {   2, 855 },
 {   3, 855 }, {   4, 855 }, {   5, 855 }, {   6, 855 }, {   7, 855 },
 {   8, 855 }, {   9,6254 }, {  10,6270 }, {  11, 855 }, {  12,6254 },

 {  13,6254 }, {  14, 855 }, {  15, 855 }, {  16, 855 }, {  17, 855 },
 {  18, 855 }, {  19, 855 }, {  20, 855 }, {  21, 855 }, {  22, 855 },
 {  23, 855 }, {  24, 855 }, {  25, 855 }, {  26, 855 }, {  27, 855 },
 {  28, 855 }, {  29, 855 }, {  30, 855 }, {  31, 855 }, {  32,6254 },
 {  33, 855 }, {  34, 855 }, {  35, 855 }, {  36, 855 }, {  37, 855 },
 {  38, 855 }, {  39, 855 }, {  40, 855 }, {  41, 855 }, {  42, 855 },
 {  43, 855 }, {  44, 855 }, {  45, 873 }, {  46, 855 }, {  47, 855 },
 {  48, 855 }, {  49, 855 }, {  50, 855 }, {  51, 855 }, {  52, 855 },
 {  53, 855 }, {  54, 855 }, {  55, 855 }, {  56, 855 }, {  57, 855 },
 {  58, 855 }, {  59, 855 }, {  60, 855 }, {  61, 855 }, {  62, 855 },

 {  63, 855 }, {  64, 855 }, {  65, 855 }, {  66, 855 }, {  67, 855 },
 {  68, 855 }, {  69, 855 }, {  70, 855 }, {  71, 855 }, {  72, 855 },
 {  73, 855 }, {  74, 855 }, {  75, 855 }, {  76, 855 }, {  77, 855 },
 {  78, 855 }, {  79, 855 }, {  80, 855 }, {  81, 855 }, {  82, 855 },
 {  83, 855 }, {  84, 855 }, {  85, 881 }, {  86, 855 }, {  87, 855 },
 {  88, 855 }, {  89, 855 }, {  90, 855 }, {  91, 855 }, {  92, 855 },
 {  93, 855 }, {  94, 855 }, {  95, 855 }, {  96, 855 }, {  97, 855 },
 {  98, 855 }, {  99, 855 }, { 100, 855 }, { 101, 855 }, { 102, 855 },
 { 103, 855 }, { 104, 855 }, { 105, 855 }, { 106, 855 }, { 107, 855 },
 { 108, 855 }, { 109, 855 }, { 110, 855 }, { 111, 855 }, { 112, 855 },

 { 113, 855 }, { 114, 855 }, { 115, 855 }, { 116, 855 }, { 117, 881 },
 { 118, 855 }, { 119, 855 }, { 120, 855 }, { 121, 855 }, { 122, 855 },
 { 123, 855 }, { 124, 855 }, { 125, 855 }, { 126, 855 }, { 127, 855 },
 { 128, 855 }, { 129, 855 }, { 130, 855 }, { 131, 855 }, { 132, 855 },
 { 133, 855 }, { 134, 855 }, { 135, 855 }, { 136, 855 }, { 137, 855 },
 { 138, 855 }, { 139, 855 }, { 140, 855 }, { 141, 855 }, { 142, 855 },
 { 143, 855 }, { 144, 855 }, { 145, 855 }, { 146, 855 }, { 147, 855 },
 { 148, 855 }, { 149, 855 }, { 150, 855 }, { 151, 855 }, { 152, 855 },
 { 153, 855 }, { 154, 855 }, { 155, 855 }, { 156, 855 }, { 157, 855 },
 { 158, 855 }, { 159, 855 }, { 160, 855 }, { 161, 855 }, { 162, 855 },

 { 163, 855 }, { 164, 855 }, { 165, 855 }, { 166, 855 }, { 167, 855 },
 { 168, 855 }, { 169, 855 }, { 170, 855 }, { 171, 855 }, { 172, 855 },
 { 173, 855 }, { 174, 855 }, { 175, 855 }, { 176, 855 }, { 177, 855 },
 { 178, 855 }, { 179, 855 }, { 180, 855 }, { 181, 855 }, { 182, 855 },
 { 183, 855 }, { 184, 855 }, { 185, 855 }, { 186, 855 }, { 187, 855 },
 { 188, 855 }, { 189, 855 }, { 190, 855 }, { 191, 855 }, { 192, 855 },
 { 193, 855 }, { 194, 855 }, { 195, 855 }, { 196, 855 }, { 197, 855 },
 { 198, 855 }, { 199, 855 }, { 200, 855 }, { 201, 855 }, { 202, 855 },
 { 203, 855 }, { 204, 855 }, { 205, 855 }, { 206, 855 }, { 207, 855 },
 { 208, 855 }, { 209, 855 }, { 210, 855 }, { 211, 855 }, { 212, 855 },

 { 213, 855 }, { 214, 855 }, { 215, 855 }, { 216, 855 }, { 217, 855 },
 { 218, 855 }, { 219, 855 }, { 220, 855 }, { 221, 855 }, { 222, 855 },
 { 223, 855 }, { 224, 855 }, { 225, 855 }, { 226, 855 }, { 227, 855 },
 { 228, 855 }, { 229, 855 }, { 230, 855 }, { 231, 855 }, { 232, 855 },
 { 233, 855 }, { 234, 855 }, { 235, 855 }, { 236, 855 }, { 237, 855 },
 { 238, 855 }, { 239, 855 }, { 240, 855 }, { 241, 855 }, { 242, 855 },
 { 243, 855 }, { 244, 855 }, { 245, 855 }, { 246, 855 }, { 247, 855 },
 { 248, 855 }, { 249, 855 }, { 250, 855 }, { 251, 855 }, { 252, 855 },
 { 253, 855 }, { 254, 855 }, { 255, 855 }, { 256, 855 }, {   0,   0 },
 {   0,30595 }, {   1, 633 }, {   2, 633 }, {   3, 633 }, {   4, 633 },

 {   5, 633 }, {   6, 633 }, {   7, 633 }, {   8, 633 }, {   9, 633 },
 {  10, 635 }, {  11, 633 }, {  12, 633 }, {  13, 633 }, {  14, 633 },
 {  15, 633 }, {  16, 633 }, {  17, 633 }, {  18, 633 }, {  19, 633 },
 {  20, 633 }, {  21, 633 }, {  22, 633 }, {  23, 633 }, {  24, 633 },
 {  25, 633 }, {  26, 633 }, {  27, 633 }, {  28, 633 }, {  29, 633 },
 {  30, 633 }, {  31, 633 }, {  32, 633 }, {  33, 633 }, {  34, 633 },
 {  35, 633 }, {  36, 633 }, {  37, 633 }, {  38, 633 }, {  39, 633 },
 {  40, 633 }, {  41, 633 }, {  42, 633 }, {  43, 633 }, {  44, 633 },
 {  45, 633 }, {  46, 633 }, {  47, 633 }, {  48, 633 }, {  49, 633 },
 {  50, 633 }, {  51, 633 }, {  52, 633 }, {  53, 633 }, {  54, 633 },

 {  55, 633 }, {  56, 633 }, {  57, 633 }, {  58, 633 }, {  59, 633 },
 {  60, 633 }, {  61, 633 }, {  62, 633 }, {  63, 633 }, {  64, 633 },
 {  65, 633 }, {  66, 633 }, {  67, 633 }, {  68, 633 }, {  69, 633 },
 {  70, 633 }, {  71, 633 }, {  72, 633 }, {  73, 633 }, {  74, 633 },
 {  75, 633 }, {  76, 633 }, {  77, 633 }, {  78, 633 }, {  79, 633 },
 {  80, 633 }, {  81, 633 }, {  82, 633 }, {  83, 633 }, {  84, 633 },
 {  85, 633 }, {  86, 633 }, {  87, 633 }, {  88, 633 }, {  89, 633 },
 {  90, 633 }, {  91, 633 }, {  92, 637 }, {  93, 633 }, {  94, 633 },
 {  95, 633 }, {  96, 633 }, {  97, 633 }, {  98, 633 }, {  99, 633 },
 { 100, 633 }, { 101, 633 }, { 102, 633 }, { 103, 633 }, { 104, 633 },

 { 105, 633 }, { 106, 633 }, { 107, 633 }, { 108, 633 }, { 109, 633 },
 { 110, 633 }, { 111, 633 }, { 112, 633 }, { 113, 633 }, { 114, 633 },
 { 115, 633 }, { 116, 633 }, { 117, 633 }, { 118, 633 }, { 119, 633 },
 { 120, 633 }, { 121, 633 }, { 122, 633 }, { 123, 633 }, { 124, 633 },
 { 125, 633 }, { 126, 633 }, { 127, 633 }, { 128, 633 }, { 129, 633 },
 { 130, 633 }, { 131, 633 }, { 132, 633 }, { 133, 633 }, { 134, 633 },
 { 135, 633 }, { 136, 633 }, { 137, 633 }, { 138, 633 }, { 139, 633 },
 { 140, 633 }, { 141, 633 }, { 142, 633 }, { 143, 633 }, { 144, 633 },
 { 145, 633 }, { 146, 633 }, { 147, 633 }, { 148, 633 }, { 149, 633 },
 { 150, 633 }, { 151, 633 }, { 152, 633 }, { 153, 633 }, { 154, 633 },

 { 155, 633 }, { 156, 633 }, { 157, 633 }, { 158, 633 }, { 159, 633 },
 { 160, 633 }, { 161, 633 }, { 162, 633 }, { 163, 633 }, { 164, 633 },
 { 165, 633 }, { 166, 633 }, { 167, 633 }, { 168, 633 }, { 169, 633 },
 { 170, 633 }, { 171, 633 }, { 172, 633 }, { 173, 633 }, { 174, 633 },
 { 175, 633 }, { 176, 633 }, { 177, 633 }, { 178, 633 }, { 179, 633 },
 { 180, 633 }, { 181, 633 }, { 182, 633 }, { 183, 633 }, { 184, 633 },
 { 185, 633 }, { 186, 633 }, { 187, 633 }, { 188, 633 }, { 189, 633 },
 { 190, 633 }, { 191, 633 }, { 192, 633 }, { 193, 633 }, { 194, 633 },
 { 195, 633 }, { 196, 633 }, { 197, 633 }, { 198, 633 }, { 199, 633 },
 { 200, 633 }, { 201, 633 }, { 202, 633 }, { 203, 633 }, { 204, 633 },

 { 205, 633 }, { 206, 633 }, { 207, 633 }, { 208, 633 }, { 209, 633 },
 { 210, 633 }, { 211, 633 }, { 212, 633 }, { 213, 633 }, { 214, 633 },
 { 215, 633 }, { 216, 633 }, { 217, 633 }, { 218, 633 }, { 219, 633 },
 { 220, 633 }, { 221, 633 }, { 222, 633 }, { 223, 633 }, { 224, 633 },
 { 225, 633 }, { 226, 633 }, { 227, 633 }, { 228, 633 }, { 229, 633 },
 { 230, 633 }, { 231, 633 }, { 232, 633 }, { 233, 633 }, { 234, 633 },
 { 235, 633 }, { 236, 633 }, { 237, 633 }, { 238, 633 }, { 239, 633 },
 { 240, 633 }, { 241, 633 }, { 242, 633 }, { 243, 633 }, { 244, 633 },
 { 245, 633 }, { 246, 633 }, { 247, 633 }, { 248, 633 }, { 249, 633 },
 { 250, 633 }, { 251, 633 }, { 252, 633 }, { 253, 633 }, { 254, 633 },

 { 255, 633 }, { 256, 633 }, {   0,   0 }, {   0,30337 }, {   1, 375 },
 {   2, 375 }, {   3, 375 }, {   4, 375 }, {   5, 375 }, {   6, 375 },
 {   7, 375 }, {   8, 375 }, {   9, 375 }, {  10, 377 }, {  11, 375 },
 {  12, 375 }, {  13, 375 }, {  14, 375 }, {  15, 375 }, {  16, 375 },
 {  17, 375 }, {  18, 375 }, {  19, 375 }, {  20, 375 }, {  21, 375 },
 {  22, 375 }, {  23, 375 }, {  24, 375 }, {  25, 375 }, {  26, 375 },
 {  27, 375 }, {  28, 375 }, {  29, 375 }, {  30, 375 }, {  31, 375 },
 {  32, 375 }, {  33, 375 }, {  34, 375 }, {  35, 375 }, {  36, 375 },
 {  37, 375 }, {  38, 375 }, {  39, 375 }, {  40, 375 }, {  41, 375 },
 {  42, 375 }, {  43, 375 }, {  44, 375 }, {  45, 375 }, {  46, 375 },

 {  47, 375 }, {  48, 375 }, {  49, 375 }, {  50, 375 }, {  51, 375 },
 {  52, 375 }, {  53, 375 }, {  54, 375 }, {  55, 375 }, {  56, 375 },
 {  57, 375 }, {  58, 375 }, {  59, 375 }, {  60, 375 }, {  61, 375 },
 {  62, 375 }, {  63, 375 }, {  64, 375 }, {  65, 375 }, {  66, 375 },
 {  67, 375 }, {  68, 375 }, {  69, 375 }, {  70, 375 }, {  71, 375 },
 {  72, 375 }, {  73, 375 }, {  74, 375 }, {  75, 375 }, {  76, 375 },
 {  77, 375 }, {  78, 375 }, {  79, 375 }, {  80, 375 }, {  81, 375 },
 {  82, 375 }, {  83, 375 }, {  84, 375 }, {  85, 375 }, {  86, 375 },
 {  87, 375 }, {  88, 375 }, {  89, 375 }, {  90, 375 }, {  91, 375 },
 {  92, 379 }, {  93, 375 }, {  94, 375 }, {  95, 375 }, {  96, 375 },

 {  97, 375 }, {  98, 375 }, {  99, 375 }, { 100, 375 }, { 101, 375 },
 { 102, 375 }, { 103, 375 }, { 104, 375 }, { 105, 375 }, { 106, 375 },
 { 107, 375 }, { 108, 375 }, { 109, 375 }, { 110, 375 }, { 111, 375 },
 { 112, 375 }, { 113, 375 }, { 114, 375 }, { 115, 375 }, { 116, 375 },
 { 117, 375 }, { 118, 375 }, { 119, 375 }, { 120, 375 }, { 121, 375 },
 { 122, 375 }, { 123, 375 }, { 124, 375 }, { 125, 375 }, { 126, 375 },
 { 127, 375 }, { 128, 375 }, { 129, 375 }, { 130, 375 }, { 131, 375 },
 { 132, 375 }, { 133, 375 }, { 134, 375 }, { 135, 375 }, { 136, 375 },
 { 137, 375 }, { 138, 375 }, { 139, 375 }, { 140, 375 }, { 141, 375 },
 { 142, 375 }, { 143, 375 }, { 144, 375 }, { 145, 375 }, { 146, 375 },

 { 147, 375 }, { 148, 375 }, { 149, 375 }, { 150, 375 }, { 151, 375 },
 { 152, 375 }, { 153, 375 }, { 154, 375 }, { 155, 375 }, { 156, 375 },
 { 157, 375 }, { 158, 375 }, { 159, 375 }, { 160, 375 }, { 161, 375 },
 { 162, 375 }, { 163, 375 }, { 164, 375 }, { 165, 375 }, { 166, 375 },
 { 167, 375 }, { 168, 375 }, { 169, 375 }, { 170, 375 }, { 171, 375 },
 { 172, 375 }, { 173, 375 }, { 174, 375 }, { 175, 375 }, { 176, 375 },
 { 177, 375 }, { 178, 375 }, { 179, 375 }, { 180, 375 }, { 181, 375 },
 { 182, 375 }, { 183, 375 }, { 184, 375 }, { 185, 375 }, { 186, 375 },
 { 187, 375 }, { 188, 375 }, { 189, 375 }, { 190, 375 }, { 191, 375 },
 { 192, 375 }, { 193, 375 }, { 194, 375 }, { 195, 375 }, { 196, 375 },

 { 197, 375 }, { 198, 375 }, { 199, 375 }, { 200, 375 }, { 201, 375 },
 { 202, 375 }, { 203, 375 }, { 204, 375 }, { 205, 375 }, { 206, 375 },
 { 207, 375 }, { 208, 375 }, { 209, 375 }, { 210, 375 }, { 211, 375 },
 { 212, 375 }, { 213, 375 }, { 214, 375 }, { 215, 375 }, { 216, 375 },
 { 217, 375 }, { 218, 375 }, { 219, 375 }, { 220, 375 }, { 221, 375 },
 { 222, 375 }, { 223, 375 }, { 224, 375 }, { 225, 375 }, { 226, 375 },
 { 227, 375 }, { 228, 375 }, { 229, 375 }, { 230, 375 }, { 231, 375 },
 { 232, 375 }, { 233, 375 }, { 234, 375 }, { 235, 375 }, { 236, 375 },
 { 237, 375 }, { 238, 375 }, { 239, 375 }, { 240, 375 }, { 241, 375 },
 { 242, 375 }, { 243, 375 }, { 244, 375 }, { 245, 375 }, { 246, 375 },

 { 247, 375 }, { 248, 375 }, { 249, 375 }, { 250, 375 }, { 251, 375 },
 { 252, 375 }, { 253, 375 }, { 254, 375 }, { 255, 375 }, { 256, 375 },
 {   0,  78 }, {   0,30079 }, {   0,   1 }, {   0,30077 }, {   0,  49 },
 {   0,30075 }, {   0,   0 }, {   0,   1 }, {   0,30072 }, {   0,  69 },
 {   0,30070 }, {   0,   0 }, {   9,5515 }, {  10,5515 }, {   0,   0 },
 {  12,5515 }, {  13,5515 }, {   9,5510 }, {  10,5510 }, {   0,   0 },
 {  12,5510 }, {  13,5510 }, {   0,  19 }, {   0,30057 }, {   0,  68 },
 {   0,30055 }, {   0,   0 }, {   0,  68 }, {   0,30052 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   6 }, {   0,30047 }, {   0,   0 },
 {  32,5515 }, {   0,   6 }, {   0,30043 }, {   0,   0 }, {   0,   0 },

 {  32,5510 }, {   0,  51 }, {   0,30038 }, {  33,5510 }, {   0,   0 },
 {  35,5510 }, {   0,   0 }, {  37,5510 }, {  38,5510 }, {   0,  69 },
 {   0,30030 }, {   0,   0 }, {  42,5510 }, {  43,5510 }, {   0,   0 },
 {  45,5510 }, {   0,   0 }, {  47,5510 }, {   0,   0 }, {   0,  52 },
 {   0,30020 }, {   0,  54 }, {   0,30018 }, {   0,  54 }, {   0,30016 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  60,5510 }, {  61,5550 }, {  62,5510 }, {  63,5510 }, {  64,5510 },
 {  42, 348 }, {  34, 346 }, {   0,  54 }, {   0,30002 }, {  42,7294 },
 {  47, 353 }, {   0,  27 }, {   0,29998 }, {  33,5470 }, {   0,   0 },
 {  35,5470 }, {  58, 100 }, {  37,5470 }, {  38,5470 }, {  61, 102 },

 {   0,   0 }, {   0,   0 }, {  42,5470 }, {  43,5470 }, {  34, 328 },
 {  45,5470 }, {   0,   0 }, {  47,5470 }, {   0,   0 }, {   0,  27 },
 {   0,29980 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,5510 },
 {   0,   0 }, {  96,5510 }, {   0,  27 }, {   0,29972 }, {  45,9219 },
 {  60,5470 }, {  61,5470 }, {  62,5470 }, {  63,5470 }, {  64,5470 },
 {   0,  78 }, {   0,29964 }, {   0,  35 }, {   0,29962 }, {   0,  36 },
 {   0,29960 }, {   0,  35 }, {   0,29958 }, {   0,  43 }, {   0,29956 },
 {   0,  61 }, {   0,29954 }, {   0,  60 }, {   0,29952 }, {   0,  62 },
 {   0,29950 }, {   0,   8 }, {   0,29948 }, {   0,   0 }, { 124,5510 },
 {   0,   0 }, { 126,5510 }, {   0,  20 }, {   0,29942 }, {   0,  18 },

 {   0,29940 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,5470 },
 {  45,9496 }, {  96,5470 }, {  69, 327 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,   8 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,5461 },
 {  49,5461 }, {  50,5461 }, {  51,5461 }, {  52,5461 }, {  53,5461 },
 {  54,5461 }, {  55,5461 }, {  56,5461 }, {  57,5461 }, { 124,5470 },
 {   0,   0 }, { 126,5470 }, {  69, 357 }, {   0,   0 }, { 101, 327 },
 {   0,   0 }, {  65,5523 }, {  66,5523 }, {  67,5523 }, {  68,5523 },
 {  69,5523 }, {  70,5523 }, {  71,5523 }, {  72,5523 }, {  73,5523 },

 {  74,5523 }, {  75,5523 }, {  76,5523 }, {  77,5523 }, {  78,5523 },
 {  79,5523 }, {  80,5523 }, {  81,5523 }, {  82,5523 }, {  83,5523 },
 {  84,5523 }, {  85,5523 }, {  86,5523 }, {  87,5523 }, {  88,5523 },
 {  89,5523 }, {  90,5523 }, {  85,9732 }, {   0,   0 }, { 101, 357 },
 {   0,   0 }, {  95,5523 }, {   0,   0 }, {  97,5523 }, {  98,5523 },
 {  99,5523 }, { 100,5523 }, { 101,5523 }, { 102,5523 }, { 103,5523 },
 { 104,5523 }, { 105,5523 }, { 106,5523 }, { 107,5523 }, { 108,5523 },
 { 109,5523 }, { 110,5523 }, { 111,5523 }, { 112,5523 }, { 113,5523 },
 { 114,5523 }, { 115,5523 }, { 116,5523 }, { 117,5523 }, { 118,5523 },
 { 119,5523 }, { 120,5523 }, { 121,5523 }, { 122,5523 }, { 117,9755 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,5523 },
 { 129,5523 }, { 130,5523 }, { 131,5523 }, { 132,5523 }, { 133,5523 },
 { 134,5523 }, { 135,5523 }, { 136,5523 }, { 137,5523 }, { 138,5523 },
 { 139,5523 }, { 140,5523 }, { 141,5523 }, { 142,5523 }, { 143,5523 },
 { 144,5523 }, { 145,5523 }, { 146,5523 }, { 147,5523 }, { 148,5523 },
 { 149,5523 }, { 150,5523 }, { 151,5523 }, { 152,5523 }, { 153,5523 },
 { 154,5523 }, { 155,5523 }, { 156,5523 }, { 157,5523 }, { 158,5523 },
 { 159,5523 }, { 160,5523 }, { 161,5523 }, { 162,5523 }, { 163,5523 },
 { 164,5523 }, { 165,5523 }, { 166,5523 }, { 167,5523 }, { 168,5523 },
 { 169,5523 }, { 170,5523 }, { 171,5523 }, { 172,5523 }, { 173,5523 },

 { 174,5523 }, { 175,5523 }, { 176,5523 }, { 177,5523 }, { 178,5523 },
 { 179,5523 }, { 180,5523 }, { 181,5523 }, { 182,5523 }, { 183,5523 },
 { 184,5523 }, { 185,5523 }, { 186,5523 }, { 187,5523 }, { 188,5523 },
 { 189,5523 }, { 190,5523 }, { 191,5523 }, { 192,5523 }, { 193,5523 },
 { 194,5523 }, { 195,5523 }, { 196,5523 }, { 197,5523 }, { 198,5523 },
 { 199,5523 }, { 200,5523 }, { 201,5523 }, { 202,5523 }, { 203,5523 },
 { 204,5523 }, { 205,5523 }, { 206,5523 }, { 207,5523 }, { 208,5523 },
 { 209,5523 }, { 210,5523 }, { 211,5523 }, { 212,5523 }, { 213,5523 },
 { 214,5523 }, { 215,5523 }, { 216,5523 }, { 217,5523 }, { 218,5523 },
 { 219,5523 }, { 220,5523 }, { 221,5523 }, { 222,5523 }, { 223,5523 },

 { 224,5523 }, { 225,5523 }, { 226,5523 }, { 227,5523 }, { 228,5523 },
 { 229,5523 }, { 230,5523 }, { 231,5523 }, { 232,5523 }, { 233,5523 },
 { 234,5523 }, { 235,5523 }, { 236,5523 }, { 237,5523 }, { 238,5523 },
 { 239,5523 }, { 240,5523 }, { 241,5523 }, { 242,5523 }, { 243,5523 },
 { 244,5523 }, { 245,5523 }, { 246,5523 }, { 247,5523 }, { 248,5523 },
 { 249,5523 }, { 250,5523 }, { 251,5523 }, { 252,5523 }, { 253,5523 },
 { 254,5523 }, { 255,5523 }, {   0,  68 }, {   0,29707 }, {   0,  59 },
 {   0,29705 }, {   0,  15 }, {   0,29703 }, {   0,  10 }, {   0,29701 },
 {   0,   7 }, {   0,29699 }, {   0,   0 }, {   0,  68 }, {   0,29696 },
 {   0,   4 }, {   0,29694 }, {   0,  57 }, {   0,29692 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,  17 }, {   0,29687 }, {   0,  30 },
 {   0,29685 }, {   0,  23 }, {   0,29683 }, {   0,  38 }, {   0,29681 },
 {   0,  45 }, {   0,29679 }, {   0,  68 }, {   0,29677 }, {   0,  55 },
 {   0,29675 }, {  33,5147 }, {   0,   0 }, {  35,5147 }, {  34, 107 },
 {  37,5147 }, {  38,5147 }, {   0,   0 }, {   0,   0 }, {  39, 109 },
 {  42,5147 }, {  43,5147 }, {  33,5136 }, {  45,5147 }, {  35,5136 },
 {  47,5147 }, {  37,5136 }, {  38,5136 }, {  42,   0 }, {  45,10475 },
 {   0,   0 }, {  42,5136 }, {  43,5136 }, {  47,   5 }, {  45,5512 },
 {   0,   0 }, {  47,5136 }, {   0,   0 }, {  60,5147 }, {  61,5147 },
 {  62,5147 }, {  63,5147 }, {  64,5147 }, {  45,10847 }, {   0,  25 },

 {   0,29640 }, {   0,   0 }, {  45,11148 }, {   0,   0 }, {  60,5136 },
 {  61,5136 }, {  62,5136 }, {  63,5136 }, {  64,5136 }, {  46,-277 },
 {   0,   0 }, {  48,5751 }, {  49,5751 }, {  50,5751 }, {  51,5751 },
 {  52,5751 }, {  53,5751 }, {  54,5751 }, {  55,5751 }, {  56,5751 },
 {  57,5751 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  28 },
 {   0,29615 }, {   0,   0 }, {  94,5147 }, {   0,   0 }, {  96,5147 },
 {   0,  73 }, {   0,29609 }, {   0,   0 }, {   0,  68 }, {   0,29606 },
 {   0,  71 }, {   0,29604 }, {   0,   0 }, {  94,5136 }, {   0,   0 },
 {  96,5136 }, {   0,  50 }, {   0,29598 }, {   0,  21 }, {   0,29596 },
 {  45,12066 }, {   0,  14 }, {   0,29593 }, {  83, 138 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  10 }, {   0,29586 },
 {   0,  13 }, {   0,29584 }, { 124,5147 }, {   0,   0 }, { 126,5147 },
 {   0,  17 }, {   0,29579 }, {   0,  41 }, {   0,29577 }, {   0,  23 },
 {   0,29575 }, {   0,   0 }, {  33,5046 }, { 124,5136 }, {  35,5046 },
 { 126,5136 }, {  37,5046 }, {  38,5046 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  42,5705 }, {  43,5046 }, {   0,   0 }, {  45,5046 },
 { 115, 138 }, {  47,5046 }, {  46,5705 }, {   0,   0 }, {  48,5769 },
 {  49,5769 }, {  50,5769 }, {  51,5769 }, {  52,5769 }, {  53,5769 },
 {  54,5769 }, {  55,5769 }, {  56,5769 }, {  57,5769 }, {  60,5046 },
 {  61,5046 }, {  62,5046 }, {  63,5046 }, {  64,5046 }, {  45,12655 },

 {   0,  68 }, {   0,29539 }, {   0,  55 }, {   0,29537 }, {   0,   0 },
 {  69,5791 }, {  45,13680 }, {   0,   0 }, {  83,  99 }, {   0,   0 },
 {  45,14708 }, {   0,  68 }, {   0,29528 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  25 }, {   0,29519 }, {   0,   0 }, {   0,  28 }, {   0,29516 },
 {   0,  39 }, {   0,29514 }, {   0,   0 }, {  94,5046 }, {   0,   0 },
 {  96,5046 }, {   0,  40 }, {   0,29508 }, {   0,   0 }, {  33,4979 },
 {   0,   0 }, {  35,4979 }, { 101,5791 }, {  37,4979 }, {  38,4979 },
 { 115,  99 }, {   0,   0 }, {   0,   0 }, {  42,4979 }, {  43,4979 },
 {  33,4968 }, {  45,4979 }, {  35,4968 }, {  47,4979 }, {  37,4968 },

 {  38,4968 }, {   0,   0 }, {   0,  55 }, {   0,29487 }, {  42,4968 },
 {  43,4968 }, {   0,   0 }, {  45,4968 }, { 124,5046 }, {  47,4968 },
 { 126,5046 }, {  60,4979 }, {  61,5766 }, {  62,5807 }, {  63,4979 },
 {  64,4979 }, {  45,15811 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  67,  50 }, {   0,   0 }, {  60,4968 }, {  61,4968 }, {  62,5863 },
 {  63,4968 }, {  64,4968 }, {   0,   0 }, {   0,  68 }, {   0,29461 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  67,  81 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94,4979 }, {   0,   0 }, {  96,4979 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  99,  50 }, {   0,   0 }, {   0,  28 },
 {   0,29435 }, {  94,4968 }, {   0,   0 }, {  96,4968 }, {   0,   0 },
 {   0,  77 }, {   0,29429 }, {  33,4901 }, {   0,   0 }, {  35,4901 },
 {   0,   0 }, {  37,4901 }, {  38,4901 }, {  65, 326 }, {   0,   0 },
 {   0,   0 }, {  42,4901 }, {  43,4901 }, {  99,  81 }, {  45,4901 },
 { 124,4979 }, {  47,4901 }, { 126,4979 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 124,4968 }, {   0,   0 }, { 126,4968 }, {  60,4901 },
 {  61,5807 }, {  62,4901 }, {  63,4901 }, {  64,4901 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,5855 }, {   0,   0 }, {   0,   0 },

 {  97, 326 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,5855 },
 {  49,5855 }, {  50,5855 }, {  51,5855 }, {  52,5855 }, {  53,5855 },
 {  54,5855 }, {  55,5855 }, {  56,5855 }, {  57,5855 }, {   0,   0 },
 {  65, 276 }, {   0,   0 }, {   0,   0 }, {  94,4901 }, {   0,   0 },
 {  96,4901 }, {  65,5855 }, {  66,5855 }, {  67,5855 }, {  68,5855 },
 {  69,5855 }, {  70,5855 }, {  71,5855 }, {  72,5855 }, {  73,5855 },
 {  74,5855 }, {  75,5855 }, {  76,5855 }, {  77,5855 }, {  78,5855 },
 {  79,5855 }, {  80,5855 }, {  81,5855 }, {  82,5855 }, {  83,5855 },
 {  84,5855 }, {  85,5855 }, {  86,5855 }, {  87,5855 }, {  88,5855 },

 {  89,5855 }, {  90,5855 }, {  97, 276 }, { 124,4901 }, {   0,   0 },
 { 126,4901 }, {  95,5855 }, {   0,   0 }, {  97,5855 }, {  98,5855 },
 {  99,5855 }, { 100,5855 }, { 101,5855 }, { 102,5855 }, { 103,5855 },
 { 104,5855 }, { 105,5855 }, { 106,5855 }, { 107,5855 }, { 108,5855 },
 { 109,5855 }, { 110,5855 }, { 111,5855 }, { 112,5855 }, { 113,5855 },
 { 114,5855 }, { 115,5855 }, { 116,5855 }, { 117,5855 }, { 118,5855 },
 { 119,5855 }, { 120,5855 }, { 121,5855 }, { 122,5855 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,5855 },
 { 129,5855 }, { 130,5855 }, { 131,5855 }, { 132,5855 }, { 133,5855 },
 { 134,5855 }, { 135,5855 }, { 136,5855 }, { 137,5855 }, { 138,5855 },

 { 139,5855 }, { 140,5855 }, { 141,5855 }, { 142,5855 }, { 143,5855 },
 { 144,5855 }, { 145,5855 }, { 146,5855 }, { 147,5855 }, { 148,5855 },
 { 149,5855 }, { 150,5855 }, { 151,5855 }, { 152,5855 }, { 153,5855 },
 { 154,5855 }, { 155,5855 }, { 156,5855 }, { 157,5855 }, { 158,5855 },
 { 159,5855 }, { 160,5855 }, { 161,5855 }, { 162,5855 }, { 163,5855 },
 { 164,5855 }, { 165,5855 }, { 166,5855 }, { 167,5855 }, { 168,5855 },
 { 169,5855 }, { 170,5855 }, { 171,5855 }, { 172,5855 }, { 173,5855 },
 { 174,5855 }, { 175,5855 }, { 176,5855 }, { 177,5855 }, { 178,5855 },
 { 179,5855 }, { 180,5855 }, { 181,5855 }, { 182,5855 }, { 183,5855 },
 { 184,5855 }, { 185,5855 }, { 186,5855 }, { 187,5855 }, { 188,5855 },

 { 189,5855 }, { 190,5855 }, { 191,5855 }, { 192,5855 }, { 193,5855 },
 { 194,5855 }, { 195,5855 }, { 196,5855 }, { 197,5855 }, { 198,5855 },
 { 199,5855 }, { 200,5855 }, { 201,5855 }, { 202,5855 }, { 203,5855 },
 { 204,5855 }, { 205,5855 }, { 206,5855 }, { 207,5855 }, { 208,5855 },
 { 209,5855 }, { 210,5855 }, { 211,5855 }, { 212,5855 }, { 213,5855 },
 { 214,5855 }, { 215,5855 }, { 216,5855 }, { 217,5855 }, { 218,5855 },
 { 219,5855 }, { 220,5855 }, { 221,5855 }, { 222,5855 }, { 223,5855 },
 { 224,5855 }, { 225,5855 }, { 226,5855 }, { 227,5855 }, { 228,5855 },
 { 229,5855 }, { 230,5855 }, { 231,5855 }, { 232,5855 }, { 233,5855 },
 { 234,5855 }, { 235,5855 }, { 236,5855 }, { 237,5855 }, { 238,5855 },

 { 239,5855 }, { 240,5855 }, { 241,5855 }, { 242,5855 }, { 243,5855 },
 { 244,5855 }, { 245,5855 }, { 246,5855 }, { 247,5855 }, { 248,5855 },
 { 249,5855 }, { 250,5855 }, { 251,5855 }, { 252,5855 }, { 253,5855 },
 { 254,5855 }, { 255,5855 }, {   0,  77 }, {   0,29172 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  55 }, {   0,29161 },
 {   0,  28 }, {   0,29159 }, {   0,  33 }, {   0,29157 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  55 }, {   0,29149 }, {   0,  28 }, {   0,29147 }, {   0,  34 },
 {   0,29145 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,5598 },
 {   0,   0 }, {   0,   0 }, {  39,-776 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,5598 }, {  49,5598 }, {  50,5598 }, {  51,5598 },
 {  52,5598 }, {  53,5598 }, {  54,5598 }, {  55,5598 }, {  56,5598 },
 {  57,5598 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,5598 }, {  66,5598 },
 {  67,5598 }, {  68,5598 }, {  69,5598 }, {  70,5598 }, {  71,5598 },
 {  72,5598 }, {  73,5598 }, {  74,5598 }, {  75,5598 }, {  76,5598 },
 {  77,5598 }, {  78,5598 }, {  79,5598 }, {  80,5598 }, {  81,5598 },

 {  82,5598 }, {  83,5598 }, {  84,5598 }, {  85,5598 }, {  86,5598 },
 {  87,5598 }, {  88,5598 }, {  89,5598 }, {  90,5598 }, {  80,  12 },
 {  69,22401 }, {  80,  12 }, {  69,22423 }, {  95,5598 }, {   0,   0 },
 {  97,5598 }, {  98,5598 }, {  99,5598 }, { 100,5598 }, { 101,5598 },
 { 102,5598 }, { 103,5598 }, { 104,5598 }, { 105,5598 }, { 106,5598 },
 { 107,5598 }, { 108,5598 }, { 109,5598 }, { 110,5598 }, { 111,5598 },
 { 112,5598 }, { 113,5598 }, { 114,5598 }, { 115,5598 }, { 116,5598 },
 { 117,5598 }, { 118,5598 }, { 119,5598 }, { 120,5598 }, { 121,5598 },
 { 122,5598 }, { 112,  12 }, { 101,22401 }, { 112,  12 }, { 101,22423 },
 {   0,   0 }, { 128,5598 }, { 129,5598 }, { 130,5598 }, { 131,5598 },

 { 132,5598 }, { 133,5598 }, { 134,5598 }, { 135,5598 }, { 136,5598 },
 { 137,5598 }, { 138,5598 }, { 139,5598 }, { 140,5598 }, { 141,5598 },
 { 142,5598 }, { 143,5598 }, { 144,5598 }, { 145,5598 }, { 146,5598 },
 { 147,5598 }, { 148,5598 }, { 149,5598 }, { 150,5598 }, { 151,5598 },
 { 152,5598 }, { 153,5598 }, { 154,5598 }, { 155,5598 }, { 156,5598 },
 { 157,5598 }, { 158,5598 }, { 159,5598 }, { 160,5598 }, { 161,5598 },
 { 162,5598 }, { 163,5598 }, { 164,5598 }, { 165,5598 }, { 166,5598 },
 { 167,5598 }, { 168,5598 }, { 169,5598 }, { 170,5598 }, { 171,5598 },
 { 172,5598 }, { 173,5598 }, { 174,5598 }, { 175,5598 }, { 176,5598 },
 { 177,5598 }, { 178,5598 }, { 179,5598 }, { 180,5598 }, { 181,5598 },

 { 182,5598 }, { 183,5598 }, { 184,5598 }, { 185,5598 }, { 186,5598 },
 { 187,5598 }, { 188,5598 }, { 189,5598 }, { 190,5598 }, { 191,5598 },
 { 192,5598 }, { 193,5598 }, { 194,5598 }, { 195,5598 }, { 196,5598 },
 { 197,5598 }, { 198,5598 }, { 199,5598 }, { 200,5598 }, { 201,5598 },
 { 202,5598 }, { 203,5598 }, { 204,5598 }, { 205,5598 }, { 206,5598 },
 { 207,5598 }, { 208,5598 }, { 209,5598 }, { 210,5598 }, { 211,5598 },
 { 212,5598 }, { 213,5598 }, { 214,5598 }, { 215,5598 }, { 216,5598 },
 { 217,5598 }, { 218,5598 }, { 219,5598 }, { 220,5598 }, { 221,5598 },
 { 222,5598 }, { 223,5598 }, { 224,5598 }, { 225,5598 }, { 226,5598 },
 { 227,5598 }, { 228,5598 }, { 229,5598 }, { 230,5598 }, { 231,5598 },

 { 232,5598 }, { 233,5598 }, { 234,5598 }, { 235,5598 }, { 236,5598 },
 { 237,5598 }, { 238,5598 }, { 239,5598 }, { 240,5598 }, { 241,5598 },
 { 242,5598 }, { 243,5598 }, { 244,5598 }, { 245,5598 }, { 246,5598 },
 { 247,5598 }, { 248,5598 }, { 249,5598 }, { 250,5598 }, { 251,5598 },
 { 252,5598 }, { 253,5598 }, { 254,5598 }, { 255,5598 }, {   0,  77 },
 {   0,28915 }, {   0,  55 }, {   0,28913 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0,28902 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  55 },
 {   0,28895 }, {   0,  28 }, {   0,28893 }, {   0,  56 }, {   0,28891 },

 {   0,  29 }, {   0,28889 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,5341 }, {   0,   0 }, {   0,   0 }, {  39,-1027 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  45,23039 }, {  48,5341 }, {  49,5341 },
 {  50,5341 }, {  51,5341 }, {  52,5341 }, {  53,5341 }, {  54,5341 },
 {  55,5341 }, {  56,5341 }, {  57,5341 }, {  45,23286 }, {  39,   4 },
 {   0,   0 }, {  39,   4 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,5341 }, {  66,5341 }, {  67,5341 }, {  68,5341 }, {  69,5341 },
 {  70,5341 }, {  71,5341 }, {  72,5341 }, {  73,5341 }, {  74,5341 },

 {  75,5341 }, {  76,5341 }, {  77,5341 }, {  78,5341 }, {  79,5341 },
 {  80,5341 }, {  81,5341 }, {  82,5341 }, {  83,5341 }, {  84,5341 },
 {  85,5341 }, {  86,5341 }, {  87,5341 }, {  88,5341 }, {  89,5341 },
 {  90,5341 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,5341 }, {   0,   0 }, {  97,5341 }, {  98,5341 }, {  99,5341 },
 { 100,5341 }, { 101,5341 }, { 102,5341 }, { 103,5341 }, { 104,5341 },
 { 105,5341 }, { 106,5341 }, { 107,5341 }, { 108,5341 }, { 109,5341 },
 { 110,5341 }, { 111,5341 }, { 112,5341 }, { 113,5341 }, { 114,5341 },
 { 115,5341 }, { 116,5341 }, { 117,5341 }, { 118,5341 }, { 119,5341 },
 { 120,5341 }, { 121,5341 }, { 122,5341 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,5341 }, { 129,5341 },
 { 130,5341 }, { 131,5341 }, { 132,5341 }, { 133,5341 }, { 134,5341 },
 { 135,5341 }, { 136,5341 }, { 137,5341 }, { 138,5341 }, { 139,5341 },
 { 140,5341 }, { 141,5341 }, { 142,5341 }, { 143,5341 }, { 144,5341 },
 { 145,5341 }, { 146,5341 }, { 147,5341 }, { 148,5341 }, { 149,5341 },
 { 150,5341 }, { 151,5341 }, { 152,5341 }, { 153,5341 }, { 154,5341 },
 { 155,5341 }, { 156,5341 }, { 157,5341 }, { 158,5341 }, { 159,5341 },
 { 160,5341 }, { 161,5341 }, { 162,5341 }, { 163,5341 }, { 164,5341 },
 { 165,5341 }, { 166,5341 }, { 167,5341 }, { 168,5341 }, { 169,5341 },
 { 170,5341 }, { 171,5341 }, { 172,5341 }, { 173,5341 }, { 174,5341 },

 { 175,5341 }, { 176,5341 }, { 177,5341 }, { 178,5341 }, { 179,5341 },
 { 180,5341 }, { 181,5341 }, { 182,5341 }, { 183,5341 }, { 184,5341 },
 { 185,5341 }, { 186,5341 }, { 187,5341 }, { 188,5341 }, { 189,5341 },
 { 190,5341 }, { 191,5341 }, { 192,5341 }, { 193,5341 }, { 194,5341 },
 { 195,5341 }, { 196,5341 }, { 197,5341 }, { 198,5341 }, { 199,5341 },
 { 200,5341 }, { 201,5341 }, { 202,5341 }, { 203,5341 }, { 204,5341 },
 { 205,5341 }, { 206,5341 }, { 207,5341 }, { 208,5341 }, { 209,5341 },
 { 210,5341 }, { 211,5341 }, { 212,5341 }, { 213,5341 }, { 214,5341 },
 { 215,5341 }, { 216,5341 }, { 217,5341 }, { 218,5341 }, { 219,5341 },
 { 220,5341 }, { 221,5341 }, { 222,5341 }, { 223,5341 }, { 224,5341 },

 { 225,5341 }, { 226,5341 }, { 227,5341 }, { 228,5341 }, { 229,5341 },
 { 230,5341 }, { 231,5341 }, { 232,5341 }, { 233,5341 }, { 234,5341 },
 { 235,5341 }, { 236,5341 }, { 237,5341 }, { 238,5341 }, { 239,5341 },
 { 240,5341 }, { 241,5341 }, { 242,5341 }, { 243,5341 }, { 244,5341 },
 { 245,5341 }, { 246,5341 }, { 247,5341 }, { 248,5341 }, { 249,5341 },
 { 250,5341 }, { 251,5341 }, { 252,5341 }, { 253,5341 }, { 254,5341 },
 { 255,5341 }, {   0,  77 }, {   0,28658 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,5084 }, {   0,   0 },
 {   0,   0 }, {  39,-1282 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,5084 }, {  49,5084 }, {  50,5084 }, {  51,5084 }, {  52,5084 },
 {  53,5084 }, {  54,5084 }, {  55,5084 }, {  56,5084 }, {  57,5084 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,5084 }, {  66,5084 }, {  67,5084 },

 {  68,5084 }, {  69,5084 }, {  70,5084 }, {  71,5084 }, {  72,5084 },
 {  73,5084 }, {  74,5084 }, {  75,5084 }, {  76,5084 }, {  77,5084 },
 {  78,5084 }, {  79,5084 }, {  80,5084 }, {  81,5084 }, {  82,5084 },
 {  83,5084 }, {  84,5084 }, {  85,5084 }, {  86,5084 }, {  87,5084 },
 {  88,5084 }, {  89,5084 }, {  90,5084 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,5084 }, {   0,   0 }, {  97,5084 },
 {  98,5084 }, {  99,5084 }, { 100,5084 }, { 101,5084 }, { 102,5084 },
 { 103,5084 }, { 104,5084 }, { 105,5084 }, { 106,5084 }, { 107,5084 },
 { 108,5084 }, { 109,5084 }, { 110,5084 }, { 111,5084 }, { 112,5084 },
 { 113,5084 }, { 114,5084 }, { 115,5084 }, { 116,5084 }, { 117,5084 },

 { 118,5084 }, { 119,5084 }, { 120,5084 }, { 121,5084 }, { 122,5084 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,5084 }, { 129,5084 }, { 130,5084 }, { 131,5084 }, { 132,5084 },
 { 133,5084 }, { 134,5084 }, { 135,5084 }, { 136,5084 }, { 137,5084 },
 { 138,5084 }, { 139,5084 }, { 140,5084 }, { 141,5084 }, { 142,5084 },
 { 143,5084 }, { 144,5084 }, { 145,5084 }, { 146,5084 }, { 147,5084 },
 { 148,5084 }, { 149,5084 }, { 150,5084 }, { 151,5084 }, { 152,5084 },
 { 153,5084 }, { 154,5084 }, { 155,5084 }, { 156,5084 }, { 157,5084 },
 { 158,5084 }, { 159,5084 }, { 160,5084 }, { 161,5084 }, { 162,5084 },
 { 163,5084 }, { 164,5084 }, { 165,5084 }, { 166,5084 }, { 167,5084 },

 { 168,5084 }, { 169,5084 }, { 170,5084 }, { 171,5084 }, { 172,5084 },
 { 173,5084 }, { 174,5084 }, { 175,5084 }, { 176,5084 }, { 177,5084 },
 { 178,5084 }, { 179,5084 }, { 180,5084 }, { 181,5084 }, { 182,5084 },
 { 183,5084 }, { 184,5084 }, { 185,5084 }, { 186,5084 }, { 187,5084 },
 { 188,5084 }, { 189,5084 }, { 190,5084 }, { 191,5084 }, { 192,5084 },
 { 193,5084 }, { 194,5084 }, { 195,5084 }, { 196,5084 }, { 197,5084 },
 { 198,5084 }, { 199,5084 }, { 200,5084 }, { 201,5084 }, { 202,5084 },
 { 203,5084 }, { 204,5084 }, { 205,5084 }, { 206,5084 }, { 207,5084 },
 { 208,5084 }, { 209,5084 }, { 210,5084 }, { 211,5084 }, { 212,5084 },
 { 213,5084 }, { 214,5084 }, { 215,5084 }, { 216,5084 }, { 217,5084 },

 { 218,5084 }, { 219,5084 }, { 220,5084 }, { 221,5084 }, { 222,5084 },
 { 223,5084 }, { 224,5084 }, { 225,5084 }, { 226,5084 }, { 227,5084 },
 { 228,5084 }, { 229,5084 }, { 230,5084 }, { 231,5084 }, { 232,5084 },
 { 233,5084 }, { 234,5084 }, { 235,5084 }, { 236,5084 }, { 237,5084 },
 { 238,5084 }, { 239,5084 }, { 240,5084 }, { 241,5084 }, { 242,5084 },
 { 243,5084 }, { 244,5084 }, { 245,5084 }, { 246,5084 }, { 247,5084 },
 { 248,5084 }, { 249,5084 }, { 250,5084 }, { 251,5084 }, { 252,5084 },
 { 253,5084 }, { 254,5084 }, { 255,5084 }, {   0,  77 }, {   0,28401 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,4827 }, {   0,   0 }, {  38,-1304 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,4827 }, {  49,4827 }, {  50,4827 },
 {  51,4827 }, {  52,4827 }, {  53,4827 }, {  54,4827 }, {  55,4827 },
 {  56,4827 }, {  57,4827 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,4827 },
 {  66,4827 }, {  67,4827 }, {  68,4827 }, {  69,4827 }, {  70,4827 },
 {  71,4827 }, {  72,4827 }, {  73,4827 }, {  74,4827 }, {  75,4827 },
 {  76,4827 }, {  77,4827 }, {  78,4827 }, {  79,4827 }, {  80,4827 },
 {  81,4827 }, {  82,4827 }, {  83,4827 }, {  84,4827 }, {  85,4827 },
 {  86,4827 }, {  87,4827 }, {  88,4827 }, {  89,4827 }, {  90,4827 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,4827 },
 {   0,   0 }, {  97,4827 }, {  98,4827 }, {  99,4827 }, { 100,4827 },
 { 101,4827 }, { 102,4827 }, { 103,4827 }, { 104,4827 }, { 105,4827 },
 { 106,4827 }, { 107,4827 }, { 108,4827 }, { 109,4827 }, { 110,4827 },

 { 111,4827 }, { 112,4827 }, { 113,4827 }, { 114,4827 }, { 115,4827 },
 { 116,4827 }, { 117,4827 }, { 118,4827 }, { 119,4827 }, { 120,4827 },
 { 121,4827 }, { 122,4827 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,4827 }, { 129,4827 }, { 130,4827 },
 { 131,4827 }, { 132,4827 }, { 133,4827 }, { 134,4827 }, { 135,4827 },
 { 136,4827 }, { 137,4827 }, { 138,4827 }, { 139,4827 }, { 140,4827 },
 { 141,4827 }, { 142,4827 }, { 143,4827 }, { 144,4827 }, { 145,4827 },
 { 146,4827 }, { 147,4827 }, { 148,4827 }, { 149,4827 }, { 150,4827 },
 { 151,4827 }, { 152,4827 }, { 153,4827 }, { 154,4827 }, { 155,4827 },
 { 156,4827 }, { 157,4827 }, { 158,4827 }, { 159,4827 }, { 160,4827 },

 { 161,4827 }, { 162,4827 }, { 163,4827 }, { 164,4827 }, { 165,4827 },
 { 166,4827 }, { 167,4827 }, { 168,4827 }, { 169,4827 }, { 170,4827 },
 { 171,4827 }, { 172,4827 }, { 173,4827 }, { 174,4827 }, { 175,4827 },
 { 176,4827 }, { 177,4827 }, { 178,4827 }, { 179,4827 }, { 180,4827 },
 { 181,4827 }, { 182,4827 }, { 183,4827 }, { 184,4827 }, { 185,4827 },
 { 186,4827 }, { 187,4827 }, { 188,4827 }, { 189,4827 }, { 190,4827 },
 { 191,4827 }, { 192,4827 }, { 193,4827 }, { 194,4827 }, { 195,4827 },
 { 196,4827 }, { 197,4827 }, { 198,4827 }, { 199,4827 }, { 200,4827 },
 { 201,4827 }, { 202,4827 }, { 203,4827 }, { 204,4827 }, { 205,4827 },
 { 206,4827 }, { 207,4827 }, { 208,4827 }, { 209,4827 }, { 210,4827 },

 { 211,4827 }, { 212,4827 }, { 213,4827 }, { 214,4827 }, { 215,4827 },
 { 216,4827 }, { 217,4827 }, { 218,4827 }, { 219,4827 }, { 220,4827 },
 { 221,4827 }, { 222,4827 }, { 223,4827 }, { 224,4827 }, { 225,4827 },
 { 226,4827 }, { 227,4827 }, { 228,4827 }, { 229,4827 }, { 230,4827 },
 { 231,4827 }, { 232,4827 }, { 233,4827 }, { 234,4827 }, { 235,4827 },
 { 236,4827 }, { 237,4827 }, { 238,4827 }, { 239,4827 }, { 240,4827 },
 { 241,4827 }, { 242,4827 }, { 243,4827 }, { 244,4827 }, { 245,4827 },
 { 246,4827 }, { 247,4827 }, { 248,4827 }, { 249,4827 }, { 250,4827 },
 { 251,4827 }, { 252,4827 }, { 253,4827 }, { 254,4827 }, { 255,4827 },
 {   0,  77 }, {   0,28144 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,4570 }, {   0,   0 }, {   0,   0 },
 {  39,-1559 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,4570 },
 {  49,4570 }, {  50,4570 }, {  51,4570 }, {  52,4570 }, {  53,4570 },

 {  54,4570 }, {  55,4570 }, {  56,4570 }, {  57,4570 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,4570 }, {  66,4570 }, {  67,4570 }, {  68,4570 },
 {  69,4570 }, {  70,4570 }, {  71,4570 }, {  72,4570 }, {  73,4570 },
 {  74,4570 }, {  75,4570 }, {  76,4570 }, {  77,4570 }, {  78,4570 },
 {  79,4570 }, {  80,4570 }, {  81,4570 }, {  82,4570 }, {  83,4570 },
 {  84,4570 }, {  85,4570 }, {  86,4570 }, {  87,4570 }, {  88,4570 },
 {  89,4570 }, {  90,4570 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,4570 }, {   0,   0 }, {  97,4570 }, {  98,4570 },
 {  99,4570 }, { 100,4570 }, { 101,4570 }, { 102,4570 }, { 103,4570 },

 { 104,4570 }, { 105,4570 }, { 106,4570 }, { 107,4570 }, { 108,4570 },
 { 109,4570 }, { 110,4570 }, { 111,4570 }, { 112,4570 }, { 113,4570 },
 { 114,4570 }, { 115,4570 }, { 116,4570 }, { 117,4570 }, { 118,4570 },
 { 119,4570 }, { 120,4570 }, { 121,4570 }, { 122,4570 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,4570 },
 { 129,4570 }, { 130,4570 }, { 131,4570 }, { 132,4570 }, { 133,4570 },
 { 134,4570 }, { 135,4570 }, { 136,4570 }, { 137,4570 }, { 138,4570 },
 { 139,4570 }, { 140,4570 }, { 141,4570 }, { 142,4570 }, { 143,4570 },
 { 144,4570 }, { 145,4570 }, { 146,4570 }, { 147,4570 }, { 148,4570 },
 { 149,4570 }, { 150,4570 }, { 151,4570 }, { 152,4570 }, { 153,4570 },

 { 154,4570 }, { 155,4570 }, { 156,4570 }, { 157,4570 }, { 158,4570 },
 { 159,4570 }, { 160,4570 }, { 161,4570 }, { 162,4570 }, { 163,4570 },
 { 164,4570 }, { 165,4570 }, { 166,4570 }, { 167,4570 }, { 168,4570 },
 { 169,4570 }, { 170,4570 }, { 171,4570 }, { 172,4570 }, { 173,4570 },
 { 174,4570 }, { 175,4570 }, { 176,4570 }, { 177,4570 }, { 178,4570 },
 { 179,4570 }, { 180,4570 }, { 181,4570 }, { 182,4570 }, { 183,4570 },
 { 184,4570 }, { 185,4570 }, { 186,4570 }, { 187,4570 }, { 188,4570 },
 { 189,4570 }, { 190,4570 }, { 191,4570 }, { 192,4570 }, { 193,4570 },
 { 194,4570 }, { 195,4570 }, { 196,4570 }, { 197,4570 }, { 198,4570 },
 { 199,4570 }, { 200,4570 }, { 201,4570 }, { 202,4570 }, { 203,4570 },

 { 204,4570 }, { 205,4570 }, { 206,4570 }, { 207,4570 }, { 208,4570 },
 { 209,4570 }, { 210,4570 }, { 211,4570 }, { 212,4570 }, { 213,4570 },
 { 214,4570 }, { 215,4570 }, { 216,4570 }, { 217,4570 }, { 218,4570 },
 { 219,4570 }, { 220,4570 }, { 221,4570 }, { 222,4570 }, { 223,4570 },
 { 224,4570 }, { 225,4570 }, { 226,4570 }, { 227,4570 }, { 228,4570 },
 { 229,4570 }, { 230,4570 }, { 231,4570 }, { 232,4570 }, { 233,4570 },
 { 234,4570 }, { 235,4570 }, { 236,4570 }, { 237,4570 }, { 238,4570 },
 { 239,4570 }, { 240,4570 }, { 241,4570 }, { 242,4570 }, { 243,4570 },
 { 244,4570 }, { 245,4570 }, { 246,4570 }, { 247,4570 }, { 248,4570 },
 { 249,4570 }, { 250,4570 }, { 251,4570 }, { 252,4570 }, { 253,4570 },

 { 254,4570 }, { 255,4570 }, {   0,  12 }, {   0,27887 }, {   1,4570 },
 {   2,4570 }, {   3,4570 }, {   4,4570 }, {   5,4570 }, {   6,4570 },
 {   7,4570 }, {   8,4570 }, {   9,4570 }, {  10,4570 }, {  11,4570 },
 {  12,4570 }, {  13,4570 }, {  14,4570 }, {  15,4570 }, {  16,4570 },
 {  17,4570 }, {  18,4570 }, {  19,4570 }, {  20,4570 }, {  21,4570 },
 {  22,4570 }, {  23,4570 }, {  24,4570 }, {  25,4570 }, {  26,4570 },
 {  27,4570 }, {  28,4570 }, {  29,4570 }, {  30,4570 }, {  31,4570 },
 {  32,4570 }, {  33,4570 }, {  34,4570 }, {  35,4570 }, {  36,4570 },
 {  37,4570 }, {  38,4570 }, {   0,   0 }, {  40,4570 }, {  41,4570 },
 {  42,4570 }, {  43,4570 }, {  44,4570 }, {  45,4570 }, {  46,4570 },

 {  47,4570 }, {  48,4570 }, {  49,4570 }, {  50,4570 }, {  51,4570 },
 {  52,4570 }, {  53,4570 }, {  54,4570 }, {  55,4570 }, {  56,4570 },
 {  57,4570 }, {  58,4570 }, {  59,4570 }, {  60,4570 }, {  61,4570 },
 {  62,4570 }, {  63,4570 }, {  64,4570 }, {  65,4570 }, {  66,4570 },
 {  67,4570 }, {  68,4570 }, {  69,4570 }, {  70,4570 }, {  71,4570 },
 {  72,4570 }, {  73,4570 }, {  74,4570 }, {  75,4570 }, {  76,4570 },
 {  77,4570 }, {  78,4570 }, {  79,4570 }, {  80,4570 }, {  81,4570 },
 {  82,4570 }, {  83,4570 }, {  84,4570 }, {  85,4570 }, {  86,4570 },
 {  87,4570 }, {  88,4570 }, {  89,4570 }, {  90,4570 }, {  91,4570 },
 {  92,4570 }, {  93,4570 }, {  94,4570 }, {  95,4570 }, {  96,4570 },

 {  97,4570 }, {  98,4570 }, {  99,4570 }, { 100,4570 }, { 101,4570 },
 { 102,4570 }, { 103,4570 }, { 104,4570 }, { 105,4570 }, { 106,4570 },
 { 107,4570 }, { 108,4570 }, { 109,4570 }, { 110,4570 }, { 111,4570 },
 { 112,4570 }, { 113,4570 }, { 114,4570 }, { 115,4570 }, { 116,4570 },
 { 117,4570 }, { 118,4570 }, { 119,4570 }, { 120,4570 }, { 121,4570 },
 { 122,4570 }, { 123,4570 }, { 124,4570 }, { 125,4570 }, { 126,4570 },
 { 127,4570 }, { 128,4570 }, { 129,4570 }, { 130,4570 }, { 131,4570 },
 { 132,4570 }, { 133,4570 }, { 134,4570 }, { 135,4570 }, { 136,4570 },
 { 137,4570 }, { 138,4570 }, { 139,4570 }, { 140,4570 }, { 141,4570 },
 { 142,4570 }, { 143,4570 }, { 144,4570 }, { 145,4570 }, { 146,4570 },

 { 147,4570 }, { 148,4570 }, { 149,4570 }, { 150,4570 }, { 151,4570 },
 { 152,4570 }, { 153,4570 }, { 154,4570 }, { 155,4570 }, { 156,4570 },
 { 157,4570 }, { 158,4570 }, { 159,4570 }, { 160,4570 }, { 161,4570 },
 { 162,4570 }, { 163,4570 }, { 164,4570 }, { 165,4570 }, { 166,4570 },
 { 167,4570 }, { 168,4570 }, { 169,4570 }, { 170,4570 }, { 171,4570 },
 { 172,4570 }, { 173,4570 }, { 174,4570 }, { 175,4570 }, { 176,4570 },
 { 177,4570 }, { 178,4570 }, { 179,4570 }, { 180,4570 }, { 181,4570 },
 { 182,4570 }, { 183,4570 }, { 184,4570 }, { 185,4570 }, { 186,4570 },
 { 187,4570 }, { 188,4570 }, { 189,4570 }, { 190,4570 }, { 191,4570 },
 { 192,4570 }, { 193,4570 }, { 194,4570 }, { 195,4570 }, { 196,4570 },

 { 197,4570 }, { 198,4570 }, { 199,4570 }, { 200,4570 }, { 201,4570 },
 { 202,4570 }, { 203,4570 }, { 204,4570 }, { 205,4570 }, { 206,4570 },
 { 207,4570 }, { 208,4570 }, { 209,4570 }, { 210,4570 }, { 211,4570 },
 { 212,4570 }, { 213,4570 }, { 214,4570 }, { 215,4570 }, { 216,4570 },
 { 217,4570 }, { 218,4570 }, { 219,4570 }, { 220,4570 }, { 221,4570 },
 { 222,4570 }, { 223,4570 }, { 224,4570 }, { 225,4570 }, { 226,4570 },
 { 227,4570 }, { 228,4570 }, { 229,4570 }, { 230,4570 }, { 231,4570 },
 { 232,4570 }, { 233,4570 }, { 234,4570 }, { 235,4570 }, { 236,4570 },
 { 237,4570 }, { 238,4570 }, { 239,4570 }, { 240,4570 }, { 241,4570 },
 { 242,4570 }, { 243,4570 }, { 244,4570 }, { 245,4570 }, { 246,4570 },

 { 247,4570 }, { 248,4570 }, { 249,4570 }, { 250,4570 }, { 251,4570 },
 { 252,4570 }, { 253,4570 }, { 254,4570 }, { 255,4570 }, { 256,4570 },
 {   0,   9 }, {   0,27629 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   9,4570 }, {  10,4575 }, {   0,   0 }, {  12,4570 }, {  13,4575 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  32,4570 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  45,-2072 }, {   0,   5 }, {   0,27582 }, {   1,4575 },
 {   2,4575 }, {   3,4575 }, {   4,4575 }, {   5,4575 }, {   6,4575 },
 {   7,4575 }, {   8,4575 }, {   9,4575 }, {  10,4575 }, {  11,4575 },
 {  12,4575 }, {  13,4575 }, {  14,4575 }, {  15,4575 }, {  16,4575 },
 {  17,4575 }, {  18,4575 }, {  19,4575 }, {  20,4575 }, {  21,4575 },
 {  22,4575 }, {  23,4575 }, {  24,4575 }, {  25,4575 }, {  26,4575 },
 {  27,4575 }, {  28,4575 }, {  29,4575 }, {  30,4575 }, {  31,4575 },
 {  32,4575 }, {  33,4575 }, {  34,4575 }, {  35,4575 }, {  36,4575 },
 {  37,4575 }, {  38,4575 }, {  39,4575 }, {  40,4575 }, {  41,4575 },

 {   0,   0 }, {  43,4575 }, {  44,4575 }, {  45,4575 }, {  46,4575 },
 {   0,   0 }, {  48,4575 }, {  49,4575 }, {  50,4575 }, {  51,4575 },
 {  52,4575 }, {  53,4575 }, {  54,4575 }, {  55,4575 }, {  56,4575 },
 {  57,4575 }, {  58,4575 }, {  59,4575 }, {  60,4575 }, {  61,4575 },
 {  62,4575 }, {  63,4575 }, {  64,4575 }, {  65,4575 }, {  66,4575 },
 {  67,4575 }, {  68,4575 }, {  69,4575 }, {  70,4575 }, {  71,4575 },
 {  72,4575 }, {  73,4575 }, {  74,4575 }, {  75,4575 }, {  76,4575 },
 {  77,4575 }, {  78,4575 }, {  79,4575 }, {  80,4575 }, {  81,4575 },
 {  82,4575 }, {  83,4575 }, {  84,4575 }, {  85,4575 }, {  86,4575 },
 {  87,4575 }, {  88,4575 }, {  89,4575 }, {  90,4575 }, {  91,4575 },

 {  92,4575 }, {  93,4575 }, {  94,4575 }, {  95,4575 }, {  96,4575 },
 {  97,4575 }, {  98,4575 }, {  99,4575 }, { 100,4575 }, { 101,4575 },
 { 102,4575 }, { 103,4575 }, { 104,4575 }, { 105,4575 }, { 106,4575 },
 { 107,4575 }, { 108,4575 }, { 109,4575 }, { 110,4575 }, { 111,4575 },
 { 112,4575 }, { 113,4575 }, { 114,4575 }, { 115,4575 }, { 116,4575 },
 { 117,4575 }, { 118,4575 }, { 119,4575 }, { 120,4575 }, { 121,4575 },
 { 122,4575 }, { 123,4575 }, { 124,4575 }, { 125,4575 }, { 126,4575 },
 { 127,4575 }, { 128,4575 }, { 129,4575 }, { 130,4575 }, { 131,4575 },
 { 132,4575 }, { 133,4575 }, { 134,4575 }, { 135,4575 }, { 136,4575 },
 { 137,4575 }, { 138,4575 }, { 139,4575 }, { 140,4575 }, { 141,4575 },

 { 142,4575 }, { 143,4575 }, { 144,4575 }, { 145,4575 }, { 146,4575 },
 { 147,4575 }, { 148,4575 }, { 149,4575 }, { 150,4575 }, { 151,4575 },
 { 152,4575 }, { 153,4575 }, { 154,4575 }, { 155,4575 }, { 156,4575 },
 { 157,4575 }, { 158,4575 }, { 159,4575 }, { 160,4575 }, { 161,4575 },
 { 162,4575 }, { 163,4575 }, { 164,4575 }, { 165,4575 }, { 166,4575 },
 { 167,4575 }, { 168,4575 }, { 169,4575 }, { 170,4575 }, { 171,4575 },
 { 172,4575 }, { 173,4575 }, { 174,4575 }, { 175,4575 }, { 176,4575 },
 { 177,4575 }, { 178,4575 }, { 179,4575 }, { 180,4575 }, { 181,4575 },
 { 182,4575 }, { 183,4575 }, { 184,4575 }, { 185,4575 }, { 186,4575 },
 { 187,4575 }, { 188,4575 }, { 189,4575 }, { 190,4575 }, { 191,4575 },

 { 192,4575 }, { 193,4575 }, { 194,4575 }, { 195,4575 }, { 196,4575 },
 { 197,4575 }, { 198,4575 }, { 199,4575 }, { 200,4575 }, { 201,4575 },
 { 202,4575 }, { 203,4575 }, { 204,4575 }, { 205,4575 }, { 206,4575 },
 { 207,4575 }, { 208,4575 }, { 209,4575 }, { 210,4575 }, { 211,4575 },
 { 212,4575 }, { 213,4575 }, { 214,4575 }, { 215,4575 }, { 216,4575 },
 { 217,4575 }, { 218,4575 }, { 219,4575 }, { 220,4575 }, { 221,4575 },
 { 222,4575 }, { 223,4575 }, { 224,4575 }, { 225,4575 }, { 226,4575 },
 { 227,4575 }, { 228,4575 }, { 229,4575 }, { 230,4575 }, { 231,4575 },
 { 232,4575 }, { 233,4575 }, { 234,4575 }, { 235,4575 }, { 236,4575 },
 { 237,4575 }, { 238,4575 }, { 239,4575 }, { 240,4575 }, { 241,4575 },

 { 242,4575 }, { 243,4575 }, { 244,4575 }, { 245,4575 }, { 246,4575 },
 { 247,4575 }, { 248,4575 }, { 249,4575 }, { 250,4575 }, { 251,4575 },
 { 252,4575 }, { 253,4575 }, { 254,4575 }, { 255,4575 }, { 256,4575 },
 {   0,   5 }, {   0,27324 }, {   1,4317 }, {   2,4317 }, {   3,4317 },
 {   4,4317 }, {   5,4317 }, {   6,4317 }, {   7,4317 }, {   8,4317 },
 {   9,4317 }, {  10,4317 }, {  11,4317 }, {  12,4317 }, {  13,4317 },
 {  14,4317 }, {  15,4317 }, {  16,4317 }, {  17,4317 }, {  18,4317 },
 {  19,4317 }, {  20,4317 }, {  21,4317 }, {  22,4317 }, {  23,4317 },
 {  24,4317 }, {  25,4317 }, {  26,4317 }, {  27,4317 }, {  28,4317 },
 {  29,4317 }, {  30,4317 }, {  31,4317 }, {  32,4317 }, {  33,4317 },

 {  34,4317 }, {  35,4317 }, {  36,4317 }, {  37,4317 }, {  38,4317 },
 {  39,4317 }, {  40,4317 }, {  41,4317 }, {   0,   0 }, {  43,4317 },
 {  44,4317 }, {  45,4317 }, {  46,4317 }, {   0,   0 }, {  48,4317 },
 {  49,4317 }, {  50,4317 }, {  51,4317 }, {  52,4317 }, {  53,4317 },
 {  54,4317 }, {  55,4317 }, {  56,4317 }, {  57,4317 }, {  58,4317 },
 {  59,4317 }, {  60,4317 }, {  61,4317 }, {  62,4317 }, {  63,4317 },
 {  64,4317 }, {  65,4317 }, {  66,4317 }, {  67,4317 }, {  68,4317 },
 {  69,4317 }, {  70,4317 }, {  71,4317 }, {  72,4317 }, {  73,4317 },
 {  74,4317 }, {  75,4317 }, {  76,4317 }, {  77,4317 }, {  78,4317 },
 {  79,4317 }, {  80,4317 }, {  81,4317 }, {  82,4317 }, {  83,4317 },

 {  84,4317 }, {  85,4317 }, {  86,4317 }, {  87,4317 }, {  88,4317 },
 {  89,4317 }, {  90,4317 }, {  91,4317 }, {  92,4317 }, {  93,4317 },
 {  94,4317 }, {  95,4317 }, {  96,4317 }, {  97,4317 }, {  98,4317 },
 {  99,4317 }, { 100,4317 }, { 101,4317 }, { 102,4317 }, { 103,4317 },
 { 104,4317 }, { 105,4317 }, { 106,4317 }, { 107,4317 }, { 108,4317 },
 { 109,4317 }, { 110,4317 }, { 111,4317 }, { 112,4317 }, { 113,4317 },
 { 114,4317 }, { 115,4317 }, { 116,4317 }, { 117,4317 }, { 118,4317 },
 { 119,4317 }, { 120,4317 }, { 121,4317 }, { 122,4317 }, { 123,4317 },
 { 124,4317 }, { 125,4317 }, { 126,4317 }, { 127,4317 }, { 128,4317 },
 { 129,4317 }, { 130,4317 }, { 131,4317 }, { 132,4317 }, { 133,4317 },

 { 134,4317 }, { 135,4317 }, { 136,4317 }, { 137,4317 }, { 138,4317 },
 { 139,4317 }, { 140,4317 }, { 141,4317 }, { 142,4317 }, { 143,4317 },
 { 144,4317 }, { 145,4317 }, { 146,4317 }, { 147,4317 }, { 148,4317 },
 { 149,4317 }, { 150,4317 }, { 151,4317 }, { 152,4317 }, { 153,4317 },
 { 154,4317 }, { 155,4317 }, { 156,4317 }, { 157,4317 }, { 158,4317 },
 { 159,4317 }, { 160,4317 }, { 161,4317 }, { 162,4317 }, { 163,4317 },
 { 164,4317 }, { 165,4317 }, { 166,4317 }, { 167,4317 }, { 168,4317 },
 { 169,4317 }, { 170,4317 }, { 171,4317 }, { 172,4317 }, { 173,4317 },
 { 174,4317 }, { 175,4317 }, { 176,4317 }, { 177,4317 }, { 178,4317 },
 { 179,4317 }, { 180,4317 }, { 181,4317 }, { 182,4317 }, { 183,4317 },

 { 184,4317 }, { 185,4317 }, { 186,4317 }, { 187,4317 }, { 188,4317 },
 { 189,4317 }, { 190,4317 }, { 191,4317 }, { 192,4317 }, { 193,4317 },
 { 194,4317 }, { 195,4317 }, { 196,4317 }, { 197,4317 }, { 198,4317 },
 { 199,4317 }, { 200,4317 }, { 201,4317 }, { 202,4317 }, { 203,4317 },
 { 204,4317 }, { 205,4317 }, { 206,4317 }, { 207,4317 }, { 208,4317 },
 { 209,4317 }, { 210,4317 }, { 211,4317 }, { 212,4317 }, { 213,4317 },
 { 214,4317 }, { 215,4317 }, { 216,4317 }, { 217,4317 }, { 218,4317 },
 { 219,4317 }, { 220,4317 }, { 221,4317 }, { 222,4317 }, { 223,4317 },
 { 224,4317 }, { 225,4317 }, { 226,4317 }, { 227,4317 }, { 228,4317 },
 { 229,4317 }, { 230,4317 }, { 231,4317 }, { 232,4317 }, { 233,4317 },

 { 234,4317 }, { 235,4317 }, { 236,4317 }, { 237,4317 }, { 238,4317 },
 { 239,4317 }, { 240,4317 }, { 241,4317 }, { 242,4317 }, { 243,4317 },
 { 244,4317 }, { 245,4317 }, { 246,4317 }, { 247,4317 }, { 248,4317 },
 { 249,4317 }, { 250,4317 }, { 251,4317 }, { 252,4317 }, { 253,4317 },
 { 254,4317 }, { 255,4317 }, { 256,4317 }, {   0,  58 }, {   0,27066 },
 {   1,4445 }, {   2,4445 }, {   3,4445 }, {   4,4445 }, {   5,4445 },
 {   6,4445 }, {   7,4445 }, {   8,4445 }, {   9,4445 }, {  10,4445 },
 {  11,4445 }, {  12,4445 }, {  13,4445 }, {  14,4445 }, {  15,4445 },
 {  16,4445 }, {  17,4445 }, {  18,4445 }, {  19,4445 }, {  20,4445 },
 {  21,4445 }, {  22,4445 }, {  23,4445 }, {  24,4445 }, {  25,4445 },

 {  26,4445 }, {  27,4445 }, {  28,4445 }, {  29,4445 }, {  30,4445 },
 {  31,4445 }, {  32,4445 }, {  33,4445 }, {   0,   0 }, {  35,4445 },
 {  36,4445 }, {  37,4445 }, {  38,4445 }, {  39,4445 }, {  40,4445 },
 {  41,4445 }, {  42,4445 }, {  43,4445 }, {  44,4445 }, {  45,4445 },
 {  46,4445 }, {  47,4445 }, {  48,4445 }, {  49,4445 }, {  50,4445 },
 {  51,4445 }, {  52,4445 }, {  53,4445 }, {  54,4445 }, {  55,4445 },
 {  56,4445 }, {  57,4445 }, {  58,4445 }, {  59,4445 }, {  60,4445 },
 {  61,4445 }, {  62,4445 }, {  63,4445 }, {  64,4445 }, {  65,4445 },
 {  66,4445 }, {  67,4445 }, {  68,4445 }, {  69,4445 }, {  70,4445 },
 {  71,4445 }, {  72,4445 }, {  73,4445 }, {  74,4445 }, {  75,4445 },

 {  76,4445 }, {  77,4445 }, {  78,4445 }, {  79,4445 }, {  80,4445 },
 {  81,4445 }, {  82,4445 }, {  83,4445 }, {  84,4445 }, {  85,4445 },
 {  86,4445 }, {  87,4445 }, {  88,4445 }, {  89,4445 }, {  90,4445 },
 {  91,4445 }, {  92,4445 }, {  93,4445 }, {  94,4445 }, {  95,4445 },
 {  96,4445 }, {  97,4445 }, {  98,4445 }, {  99,4445 }, { 100,4445 },
 { 101,4445 }, { 102,4445 }, { 103,4445 }, { 104,4445 }, { 105,4445 },
 { 106,4445 }, { 107,4445 }, { 108,4445 }, { 109,4445 }, { 110,4445 },
 { 111,4445 }, { 112,4445 }, { 113,4445 }, { 114,4445 }, { 115,4445 },
 { 116,4445 }, { 117,4445 }, { 118,4445 }, { 119,4445 }, { 120,4445 },
 { 121,4445 }, { 122,4445 }, { 123,4445 }, { 124,4445 }, { 125,4445 },

 { 126,4445 }, { 127,4445 }, { 128,4445 }, { 129,4445 }, { 130,4445 },
 { 131,4445 }, { 132,4445 }, { 133,4445 }, { 134,4445 }, { 135,4445 },
 { 136,4445 }, { 137,4445 }, { 138,4445 }, { 139,4445 }, { 140,4445 },
 { 141,4445 }, { 142,4445 }, { 143,4445 }, { 144,4445 }, { 145,4445 },
 { 146,4445 }, { 147,4445 }, { 148,4445 }, { 149,4445 }, { 150,4445 },
 { 151,4445 }, { 152,4445 }, { 153,4445 }, { 154,4445 }, { 155,4445 },
 { 156,4445 }, { 157,4445 }, { 158,4445 }, { 159,4445 }, { 160,4445 },
 { 161,4445 }, { 162,4445 }, { 163,4445 }, { 164,4445 }, { 165,4445 },
 { 166,4445 }, { 167,4445 }, { 168,4445 }, { 169,4445 }, { 170,4445 },
 { 171,4445 }, { 172,4445 }, { 173,4445 }, { 174,4445 }, { 175,4445 },

 { 176,4445 }, { 177,4445 }, { 178,4445 }, { 179,4445 }, { 180,4445 },
 { 181,4445 }, { 182,4445 }, { 183,4445 }, { 184,4445 }, { 185,4445 },
 { 186,4445 }, { 187,4445 }, { 188,4445 }, { 189,4445 }, { 190,4445 },
 { 191,4445 }, { 192,4445 }, { 193,4445 }, { 194,4445 }, { 195,4445 },
 { 196,4445 }, { 197,4445 }, { 198,4445 }, { 199,4445 }, { 200,4445 },
 { 201,4445 }, { 202,4445 }, { 203,4445 }, { 204,4445 }, { 205,4445 },
 { 206,4445 }, { 207,4445 }, { 208,4445 }, { 209,4445 }, { 210,4445 },
 { 211,4445 }, { 212,4445 }, { 213,4445 }, { 214,4445 }, { 215,4445 },
 { 216,4445 }, { 217,4445 }, { 218,4445 }, { 219,4445 }, { 220,4445 },
 { 221,4445 }, { 222,4445 }, { 223,4445 }, { 224,4445 }, { 225,4445 },

 { 226,4445 }, { 227,4445 }, { 228,4445 }, { 229,4445 }, { 230,4445 },
 { 231,4445 }, { 232,4445 }, { 233,4445 }, { 234,4445 }, { 235,4445 },
 { 236,4445 }, { 237,4445 }, { 238,4445 }, { 239,4445 }, { 240,4445 },
 { 241,4445 }, { 242,4445 }, { 243,4445 }, { 244,4445 }, { 245,4445 },
 { 246,4445 }, { 247,4445 }, { 248,4445 }, { 249,4445 }, { 250,4445 },
 { 251,4445 }, { 252,4445 }, { 253,4445 }, { 254,4445 }, { 255,4445 },
 { 256,4445 }, {   0,  11 }, {   0,26808 }, {   1,4445 }, {   2,4445 },
 {   3,4445 }, {   4,4445 }, {   5,4445 }, {   6,4445 }, {   7,4445 },
 {   8,4445 }, {   9,4445 }, {  10,4445 }, {  11,4445 }, {  12,4445 },
 {  13,4445 }, {  14,4445 }, {  15,4445 }, {  16,4445 }, {  17,4445 },

 {  18,4445 }, {  19,4445 }, {  20,4445 }, {  21,4445 }, {  22,4445 },
 {  23,4445 }, {  24,4445 }, {  25,4445 }, {  26,4445 }, {  27,4445 },
 {  28,4445 }, {  29,4445 }, {  30,4445 }, {  31,4445 }, {  32,4445 },
 {  33,4445 }, {  34,4445 }, {  35,4445 }, {  36,4445 }, {  37,4445 },
 {  38,4445 }, {   0,   0 }, {  40,4445 }, {  41,4445 }, {  42,4445 },
 {  43,4445 }, {  44,4445 }, {  45,4445 }, {  46,4445 }, {  47,4445 },
 {  48,4445 }, {  49,4445 }, {  50,4445 }, {  51,4445 }, {  52,4445 },
 {  53,4445 }, {  54,4445 }, {  55,4445 }, {  56,4445 }, {  57,4445 },
 {  58,4445 }, {  59,4445 }, {  60,4445 }, {  61,4445 }, {  62,4445 },
 {  63,4445 }, {  64,4445 }, {  65,4445 }, {  66,4445 }, {  67,4445 },

 {  68,4445 }, {  69,4445 }, {  70,4445 }, {  71,4445 }, {  72,4445 },
 {  73,4445 }, {  74,4445 }, {  75,4445 }, {  76,4445 }, {  77,4445 },
 {  78,4445 }, {  79,4445 }, {  80,4445 }, {  81,4445 }, {  82,4445 },
 {  83,4445 }, {  84,4445 }, {  85,4445 }, {  86,4445 }, {  87,4445 },
 {  88,4445 }, {  89,4445 }, {  90,4445 }, {  91,4445 }, {  92,4445 },
 {  93,4445 }, {  94,4445 }, {  95,4445 }, {  96,4445 }, {  97,4445 },
 {  98,4445 }, {  99,4445 }, { 100,4445 }, { 101,4445 }, { 102,4445 },
 { 103,4445 }, { 104,4445 }, { 105,4445 }, { 106,4445 }, { 107,4445 },
 { 108,4445 }, { 109,4445 }, { 110,4445 }, { 111,4445 }, { 112,4445 },
 { 113,4445 }, { 114,4445 }, { 115,4445 }, { 116,4445 }, { 117,4445 },

 { 118,4445 }, { 119,4445 }, { 120,4445 }, { 121,4445 }, { 122,4445 },
 { 123,4445 }, { 124,4445 }, { 125,4445 }, { 126,4445 }, { 127,4445 },
 { 128,4445 }, { 129,4445 }, { 130,4445 }, { 131,4445 }, { 132,4445 },
 { 133,4445 }, { 134,4445 }, { 135,4445 }, { 136,4445 }, { 137,4445 },
 { 138,4445 }, { 139,4445 }, { 140,4445 }, { 141,4445 }, { 142,4445 },
 { 143,4445 }, { 144,4445 }, { 145,4445 }, { 146,4445 }, { 147,4445 },
 { 148,4445 }, { 149,4445 }, { 150,4445 }, { 151,4445 }, { 152,4445 },
 { 153,4445 }, { 154,4445 }, { 155,4445 }, { 156,4445 }, { 157,4445 },
 { 158,4445 }, { 159,4445 }, { 160,4445 }, { 161,4445 }, { 162,4445 },
 { 163,4445 }, { 164,4445 }, { 165,4445 }, { 166,4445 }, { 167,4445 },

 { 168,4445 }, { 169,4445 }, { 170,4445 }, { 171,4445 }, { 172,4445 },
 { 173,4445 }, { 174,4445 }, { 175,4445 }, { 176,4445 }, { 177,4445 },
 { 178,4445 }, { 179,4445 }, { 180,4445 }, { 181,4445 }, { 182,4445 },
 { 183,4445 }, { 184,4445 }, { 185,4445 }, { 186,4445 }, { 187,4445 },
 { 188,4445 }, { 189,4445 }, { 190,4445 }, { 191,4445 }, { 192,4445 },
 { 193,4445 }, { 194,4445 }, { 195,4445 }, { 196,4445 }, { 197,4445 },
 { 198,4445 }, { 199,4445 }, { 200,4445 }, { 201,4445 }, { 202,4445 },
 { 203,4445 }, { 204,4445 }, { 205,4445 }, { 206,4445 }, { 207,4445 },
 { 208,4445 }, { 209,4445 }, { 210,4445 }, { 211,4445 }, { 212,4445 },
 { 213,4445 }, { 214,4445 }, { 215,4445 }, { 216,4445 }, { 217,4445 },

 { 218,4445 }, { 219,4445 }, { 220,4445 }, { 221,4445 }, { 222,4445 },
 { 223,4445 }, { 224,4445 }, { 225,4445 }, { 226,4445 }, { 227,4445 },
 { 228,4445 }, { 229,4445 }, { 230,4445 }, { 231,4445 }, { 232,4445 },
 { 233,4445 }, { 234,4445 }, { 235,4445 }, { 236,4445 }, { 237,4445 },
 { 238,4445 }, { 239,4445 }, { 240,4445 }, { 241,4445 }, { 242,4445 },
 { 243,4445 }, { 244,4445 }, { 245,4445 }, { 246,4445 }, { 247,4445 },
 { 248,4445 }, { 249,4445 }, { 250,4445 }, { 251,4445 }, { 252,4445 },
 { 253,4445 }, { 254,4445 }, { 255,4445 }, { 256,4445 }, {   0,  16 },
 {   0,26550 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,4445 },

 {  10,4450 }, {   0,   0 }, {  12,4445 }, {  13,4450 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  32,4445 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  45,-3137 }, {   0,  31 }, {   0,26503 }, {   1,4450 }, {   2,4450 },
 {   3,4450 }, {   4,4450 }, {   5,4450 }, {   6,4450 }, {   7,4450 },
 {   8,4450 }, {   9,4450 }, {  10,4450 }, {  11,4450 }, {  12,4450 },

 {  13,4450 }, {  14,4450 }, {  15,4450 }, {  16,4450 }, {  17,4450 },
 {  18,4450 }, {  19,4450 }, {  20,4450 }, {  21,4450 }, {  22,4450 },
 {  23,4450 }, {  24,4450 }, {  25,4450 }, {  26,4450 }, {  27,4450 },
 {  28,4450 }, {  29,4450 }, {  30,4450 }, {  31,4450 }, {  32,4450 },
 {  33,4450 }, {  34,4450 }, {  35,4450 }, {  36,4450 }, {  37,4450 },
 {  38,4450 }, {   0,   0 }, {  40,4450 }, {  41,4450 }, {  42,4450 },
 {  43,4450 }, {  44,4450 }, {  45,4450 }, {  46,4450 }, {  47,4450 },
 {  48,4450 }, {  49,4450 }, {  50,4450 }, {  51,4450 }, {  52,4450 },
 {  53,4450 }, {  54,4450 }, {  55,4450 }, {  56,4450 }, {  57,4450 },
 {  58,4450 }, {  59,4450 }, {  60,4450 }, {  61,4450 }, {  62,4450 },

 {  63,4450 }, {  64,4450 }, {  65,4450 }, {  66,4450 }, {  67,4450 },
 {  68,4450 }, {  69,4450 }, {  70,4450 }, {  71,4450 }, {  72,4450 },
 {  73,4450 }, {  74,4450 }, {  75,4450 }, {  76,4450 }, {  77,4450 },
 {  78,4450 }, {  79,4450 }, {  80,4450 }, {  81,4450 }, {  82,4450 },
 {  83,4450 }, {  84,4450 }, {  85,4450 }, {  86,4450 }, {  87,4450 },
 {  88,4450 }, {  89,4450 }, {  90,4450 }, {  91,4450 }, {  92,4450 },
 {  93,4450 }, {  94,4450 }, {  95,4450 }, {  96,4450 }, {  97,4450 },
 {  98,4450 }, {  99,4450 }, { 100,4450 }, { 101,4450 }, { 102,4450 },
 { 103,4450 }, { 104,4450 }, { 105,4450 }, { 106,4450 }, { 107,4450 },
 { 108,4450 }, { 109,4450 }, { 110,4450 }, { 111,4450 }, { 112,4450 },

 { 113,4450 }, { 114,4450 }, { 115,4450 }, { 116,4450 }, { 117,4450 },
 { 118,4450 }, { 119,4450 }, { 120,4450 }, { 121,4450 }, { 122,4450 },
 { 123,4450 }, { 124,4450 }, { 125,4450 }, { 126,4450 }, { 127,4450 },
 { 128,4450 }, { 129,4450 }, { 130,4450 }, { 131,4450 }, { 132,4450 },
 { 133,4450 }, { 134,4450 }, { 135,4450 }, { 136,4450 }, { 137,4450 },
 { 138,4450 }, { 139,4450 }, { 140,4450 }, { 141,4450 }, { 142,4450 },
 { 143,4450 }, { 144,4450 }, { 145,4450 }, { 146,4450 }, { 147,4450 },
 { 148,4450 }, { 149,4450 }, { 150,4450 }, { 151,4450 }, { 152,4450 },
 { 153,4450 }, { 154,4450 }, { 155,4450 }, { 156,4450 }, { 157,4450 },
 { 158,4450 }, { 159,4450 }, { 160,4450 }, { 161,4450 }, { 162,4450 },

 { 163,4450 }, { 164,4450 }, { 165,4450 }, { 166,4450 }, { 167,4450 },
 { 168,4450 }, { 169,4450 }, { 170,4450 }, { 171,4450 }, { 172,4450 },
 { 173,4450 }, { 174,4450 }, { 175,4450 }, { 176,4450 }, { 177,4450 },
 { 178,4450 }, { 179,4450 }, { 180,4450 }, { 181,4450 }, { 182,4450 },
 { 183,4450 }, { 184,4450 }, { 185,4450 }, { 186,4450 }, { 187,4450 },
 { 188,4450 }, { 189,4450 }, { 190,4450 }, { 191,4450 }, { 192,4450 },
 { 193,4450 }, { 194,4450 }, { 195,4450 }, { 196,4450 }, { 197,4450 },
 { 198,4450 }, { 199,4450 }, { 200,4450 }, { 201,4450 }, { 202,4450 },
 { 203,4450 }, { 204,4450 }, { 205,4450 }, { 206,4450 }, { 207,4450 },
 { 208,4450 }, { 209,4450 }, { 210,4450 }, { 211,4450 }, { 212,4450 },

 { 213,4450 }, { 214,4450 }, { 215,4450 }, { 216,4450 }, { 217,4450 },
 { 218,4450 }, { 219,4450 }, { 220,4450 }, { 221,4450 }, { 222,4450 },
 { 223,4450 }, { 224,4450 }, { 225,4450 }, { 226,4450 }, { 227,4450 },
 { 228,4450 }, { 229,4450 }, { 230,4450 }, { 231,4450 }, { 232,4450 },
 { 233,4450 }, { 234,4450 }, { 235,4450 }, { 236,4450 }, { 237,4450 },
 { 238,4450 }, { 239,4450 }, { 240,4450 }, { 241,4450 }, { 242,4450 },
 { 243,4450 }, { 244,4450 }, { 245,4450 }, { 246,4450 }, { 247,4450 },
 { 248,4450 }, { 249,4450 }, { 250,4450 }, { 251,4450 }, { 252,4450 },
 { 253,4450 }, { 254,4450 }, { 255,4450 }, { 256,4450 }, {   0,  22 },
 {   0,26245 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,4450 },
 {  10,4455 }, {   0,   0 }, {  12,4450 }, {  13,4455 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  32,4450 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-3440 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  45,-3438 }, {   0,  32 }, {   0,26198 }, {   1,4455 }, {   2,4455 },
 {   3,4455 }, {   4,4455 }, {   5,4455 }, {   6,4455 }, {   7,4455 },

 {   8,4455 }, {   9,4455 }, {  10,4455 }, {  11,4455 }, {  12,4455 },
 {  13,4455 }, {  14,4455 }, {  15,4455 }, {  16,4455 }, {  17,4455 },
 {  18,4455 }, {  19,4455 }, {  20,4455 }, {  21,4455 }, {  22,4455 },
 {  23,4455 }, {  24,4455 }, {  25,4455 }, {  26,4455 }, {  27,4455 },
 {  28,4455 }, {  29,4455 }, {  30,4455 }, {  31,4455 }, {  32,4455 },
 {  33,4455 }, {  34,4455 }, {  35,4455 }, {  36,4455 }, {  37,4455 },
 {  38,4455 }, {   0,   0 }, {  40,4455 }, {  41,4455 }, {  42,4455 },
 {  43,4455 }, {  44,4455 }, {  45,4455 }, {  46,4455 }, {  47,4455 },
 {  48,4455 }, {  49,4455 }, {  50,4455 }, {  51,4455 }, {  52,4455 },
 {  53,4455 }, {  54,4455 }, {  55,4455 }, {  56,4455 }, {  57,4455 },

 {  58,4455 }, {  59,4455 }, {  60,4455 }, {  61,4455 }, {  62,4455 },
 {  63,4455 }, {  64,4455 }, {  65,4455 }, {  66,4455 }, {  67,4455 },
 {  68,4455 }, {  69,4455 }, {  70,4455 }, {  71,4455 }, {  72,4455 },
 {  73,4455 }, {  74,4455 }, {  75,4455 }, {  76,4455 }, {  77,4455 },
 {  78,4455 }, {  79,4455 }, {  80,4455 }, {  81,4455 }, {  82,4455 },
 {  83,4455 }, {  84,4455 }, {  85,4455 }, {  86,4455 }, {  87,4455 },
 {  88,4455 }, {  89,4455 }, {  90,4455 }, {  91,4455 }, {   0,   0 },
 {  93,4455 }, {  94,4455 }, {  95,4455 }, {  96,4455 }, {  97,4455 },
 {  98,4455 }, {  99,4455 }, { 100,4455 }, { 101,4455 }, { 102,4455 },
 { 103,4455 }, { 104,4455 }, { 105,4455 }, { 106,4455 }, { 107,4455 },

 { 108,4455 }, { 109,4455 }, { 110,4455 }, { 111,4455 }, { 112,4455 },
 { 113,4455 }, { 114,4455 }, { 115,4455 }, { 116,4455 }, { 117,4455 },
 { 118,4455 }, { 119,4455 }, { 120,4455 }, { 121,4455 }, { 122,4455 },
 { 123,4455 }, { 124,4455 }, { 125,4455 }, { 126,4455 }, { 127,4455 },
 { 128,4455 }, { 129,4455 }, { 130,4455 }, { 131,4455 }, { 132,4455 },
 { 133,4455 }, { 134,4455 }, { 135,4455 }, { 136,4455 }, { 137,4455 },
 { 138,4455 }, { 139,4455 }, { 140,4455 }, { 141,4455 }, { 142,4455 },
 { 143,4455 }, { 144,4455 }, { 145,4455 }, { 146,4455 }, { 147,4455 },
 { 148,4455 }, { 149,4455 }, { 150,4455 }, { 151,4455 }, { 152,4455 },
 { 153,4455 }, { 154,4455 }, { 155,4455 }, { 156,4455 }, { 157,4455 },

 { 158,4455 }, { 159,4455 }, { 160,4455 }, { 161,4455 }, { 162,4455 },
 { 163,4455 }, { 164,4455 }, { 165,4455 }, { 166,4455 }, { 167,4455 },
 { 168,4455 }, { 169,4455 }, { 170,4455 }, { 171,4455 }, { 172,4455 },
 { 173,4455 }, { 174,4455 }, { 175,4455 }, { 176,4455 }, { 177,4455 },
 { 178,4455 }, { 179,4455 }, { 180,4455 }, { 181,4455 }, { 182,4455 },
 { 183,4455 }, { 184,4455 }, { 185,4455 }, { 186,4455 }, { 187,4455 },
 { 188,4455 }, { 189,4455 }, { 190,4455 }, { 191,4455 }, { 192,4455 },
 { 193,4455 }, { 194,4455 }, { 195,4455 }, { 196,4455 }, { 197,4455 },
 { 198,4455 }, { 199,4455 }, { 200,4455 }, { 201,4455 }, { 202,4455 },
 { 203,4455 }, { 204,4455 }, { 205,4455 }, { 206,4455 }, { 207,4455 },

 { 208,4455 }, { 209,4455 }, { 210,4455 }, { 211,4455 }, { 212,4455 },
 { 213,4455 }, { 214,4455 }, { 215,4455 }, { 216,4455 }, { 217,4455 },
 { 218,4455 }, { 219,4455 }, { 220,4455 }, { 221,4455 }, { 222,4455 },
 { 223,4455 }, { 224,4455 }, { 225,4455 }, { 226,4455 }, { 227,4455 },
 { 228,4455 }, { 229,4455 }, { 230,4455 }, { 231,4455 }, { 232,4455 },
 { 233,4455 }, { 234,4455 }, { 235,4455 }, { 236,4455 }, { 237,4455 },
 { 238,4455 }, { 239,4455 }, { 240,4455 }, { 241,4455 }, { 242,4455 },
 { 243,4455 }, { 244,4455 }, { 245,4455 }, { 246,4455 }, { 247,4455 },
 { 248,4455 }, { 249,4455 }, { 250,4455 }, { 251,4455 }, { 252,4455 },
 { 253,4455 }, { 254,4455 }, { 255,4455 }, { 256,4455 }, {   0,  32 },

 {   0,25940 }, {   1,4197 }, {   2,4197 }, {   3,4197 }, {   4,4197 },
 {   5,4197 }, {   6,4197 }, {   7,4197 }, {   8,4197 }, {   9,4197 },
 {  10,4197 }, {  11,4197 }, {  12,4197 }, {  13,4197 }, {  14,4197 },
 {  15,4197 }, {  16,4197 }, {  17,4197 }, {  18,4197 }, {  19,4197 },
 {  20,4197 }, {  21,4197 }, {  22,4197 }, {  23,4197 }, {  24,4197 },
 {  25,4197 }, {  26,4197 }, {  27,4197 }, {  28,4197 }, {  29,4197 },
 {  30,4197 }, {  31,4197 }, {  32,4197 }, {  33,4197 }, {  34,4197 },
 {  35,4197 }, {  36,4197 }, {  37,4197 }, {  38,4197 }, {   0,   0 },
 {  40,4197 }, {  41,4197 }, {  42,4197 }, {  43,4197 }, {  44,4197 },
 {  45,4197 }, {  46,4197 }, {  47,4197 }, {  48,4197 }, {  49,4197 },

 {  50,4197 }, {  51,4197 }, {  52,4197 }, {  53,4197 }, {  54,4197 },
 {  55,4197 }, {  56,4197 }, {  57,4197 }, {  58,4197 }, {  59,4197 },
 {  60,4197 }, {  61,4197 }, {  62,4197 }, {  63,4197 }, {  64,4197 },
 {  65,4197 }, {  66,4197 }, {  67,4197 }, {  68,4197 }, {  69,4197 },
 {  70,4197 }, {  71,4197 }, {  72,4197 }, {  73,4197 }, {  74,4197 },
 {  75,4197 }, {  76,4197 }, {  77,4197 }, {  78,4197 }, {  79,4197 },
 {  80,4197 }, {  81,4197 }, {  82,4197 }, {  83,4197 }, {  84,4197 },
 {  85,4197 }, {  86,4197 }, {  87,4197 }, {  88,4197 }, {  89,4197 },
 {  90,4197 }, {  91,4197 }, {   0,   0 }, {  93,4197 }, {  94,4197 },
 {  95,4197 }, {  96,4197 }, {  97,4197 }, {  98,4197 }, {  99,4197 },

 { 100,4197 }, { 101,4197 }, { 102,4197 }, { 103,4197 }, { 104,4197 },
 { 105,4197 }, { 106,4197 }, { 107,4197 }, { 108,4197 }, { 109,4197 },
 { 110,4197 }, { 111,4197 }, { 112,4197 }, { 113,4197 }, { 114,4197 },
 { 115,4197 }, { 116,4197 }, { 117,4197 }, { 118,4197 }, { 119,4197 },
 { 120,4197 }, { 121,4197 }, { 122,4197 }, { 123,4197 }, { 124,4197 },
 { 125,4197 }, { 126,4197 }, { 127,4197 }, { 128,4197 }, { 129,4197 },
 { 130,4197 }, { 131,4197 }, { 132,4197 }, { 133,4197 }, { 134,4197 },
 { 135,4197 }, { 136,4197 }, { 137,4197 }, { 138,4197 }, { 139,4197 },
 { 140,4197 }, { 141,4197 }, { 142,4197 }, { 143,4197 }, { 144,4197 },
 { 145,4197 }, { 146,4197 }, { 147,4197 }, { 148,4197 }, { 149,4197 },

 { 150,4197 }, { 151,4197 }, { 152,4197 }, { 153,4197 }, { 154,4197 },
 { 155,4197 }, { 156,4197 }, { 157,4197 }, { 158,4197 }, { 159,4197 },
 { 160,4197 }, { 161,4197 }, { 162,4197 }, { 163,4197 }, { 164,4197 },
 { 165,4197 }, { 166,4197 }, { 167,4197 }, { 168,4197 }, { 169,4197 },
 { 170,4197 }, { 171,4197 }, { 172,4197 }, { 173,4197 }, { 174,4197 },
 { 175,4197 }, { 176,4197 }, { 177,4197 }, { 178,4197 }, { 179,4197 },
 { 180,4197 }, { 181,4197 }, { 182,4197 }, { 183,4197 }, { 184,4197 },
 { 185,4197 }, { 186,4197 }, { 187,4197 }, { 188,4197 }, { 189,4197 },
 { 190,4197 }, { 191,4197 }, { 192,4197 }, { 193,4197 }, { 194,4197 },
 { 195,4197 }, { 196,4197 }, { 197,4197 }, { 198,4197 }, { 199,4197 },

 { 200,4197 }, { 201,4197 }, { 202,4197 }, { 203,4197 }, { 204,4197 },
 { 205,4197 }, { 206,4197 }, { 207,4197 }, { 208,4197 }, { 209,4197 },
 { 210,4197 }, { 211,4197 }, { 212,4197 }, { 213,4197 }, { 214,4197 },
 { 215,4197 }, { 216,4197 }, { 217,4197 }, { 218,4197 }, { 219,4197 },
 { 220,4197 }, { 221,4197 }, { 222,4197 }, { 223,4197 }, { 224,4197 },
 { 225,4197 }, { 226,4197 }, { 227,4197 }, { 228,4197 }, { 229,4197 },
 { 230,4197 }, { 231,4197 }, { 232,4197 }, { 233,4197 }, { 234,4197 },
 { 235,4197 }, { 236,4197 }, { 237,4197 }, { 238,4197 }, { 239,4197 },
 { 240,4197 }, { 241,4197 }, { 242,4197 }, { 243,4197 }, { 244,4197 },
 { 245,4197 }, { 246,4197 }, { 247,4197 }, { 248,4197 }, { 249,4197 },

 { 250,4197 }, { 251,4197 }, { 252,4197 }, { 253,4197 }, { 254,4197 },
 { 255,4197 }, { 256,4197 }, {   0,  22 }, {   0,25682 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   9,3887 }, {  10,3892 }, {   0,   0 },
 {  12,3887 }, {  13,3892 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  32,3887 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  39,-4003 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-4001 }, {   0,  42 },
 {   0,25635 }, {   1,-4046 }, {   2,-4046 }, {   3,-4046 }, {   4,-4046 },
 {   5,-4046 }, {   6,-4046 }, {   7,-4046 }, {   8,-4046 }, {   9,-4046 },
 {  10,-4046 }, {  11,-4046 }, {  12,-4046 }, {  13,-4046 }, {  14,-4046 },
 {  15,-4046 }, {  16,-4046 }, {  17,-4046 }, {  18,-4046 }, {  19,-4046 },
 {  20,-4046 }, {  21,-4046 }, {  22,-4046 }, {  23,-4046 }, {  24,-4046 },
 {  25,-4046 }, {  26,-4046 }, {  27,-4046 }, {  28,-4046 }, {  29,-4046 },
 {  30,-4046 }, {  31,-4046 }, {  32,-4046 }, {  33,-4046 }, {  34,-4046 },
 {  35,-4046 }, {  36,-4046 }, {  37,-4046 }, {  38,-4046 }, {  39,-4046 },
 {  40,-4046 }, {  41,-4046 }, {  42,-4046 }, {  43,-4046 }, {  44,-4046 },

 {  45,-4046 }, {  46,-4046 }, {  47,-4046 }, {  48,4150 }, {  49,4150 },
 {  50,4150 }, {  51,4150 }, {  52,4150 }, {  53,4150 }, {  54,4150 },
 {  55,4150 }, {  56,-4046 }, {  57,-4046 }, {  58,-4046 }, {  59,-4046 },
 {  60,-4046 }, {  61,-4046 }, {  62,-4046 }, {  63,-4046 }, {  64,-4046 },
 {  65,-4046 }, {  66,-4046 }, {  67,-4046 }, {  68,-4046 }, {  69,-4046 },
 {  70,-4046 }, {  71,-4046 }, {  72,-4046 }, {  73,-4046 }, {  74,-4046 },
 {  75,-4046 }, {  76,-4046 }, {  77,-4046 }, {  78,-4046 }, {  79,-4046 },
 {  80,-4046 }, {  81,-4046 }, {  82,-4046 }, {  83,-4046 }, {  84,-4046 },
 {  85,4158 }, {  86,-4046 }, {  87,-4046 }, {  88,-4046 }, {  89,-4046 },
 {  90,-4046 }, {  91,-4046 }, {  92,-4046 }, {  93,-4046 }, {  94,-4046 },

 {  95,-4046 }, {  96,-4046 }, {  97,-4046 }, {  98,-4046 }, {  99,-4046 },
 { 100,-4046 }, { 101,-4046 }, { 102,-4046 }, { 103,-4046 }, { 104,-4046 },
 { 105,-4046 }, { 106,-4046 }, { 107,-4046 }, { 108,-4046 }, { 109,-4046 },
 { 110,-4046 }, { 111,-4046 }, { 112,-4046 }, { 113,-4046 }, { 114,-4046 },
 { 115,-4046 }, { 116,-4046 }, { 117,4181 }, { 118,-4046 }, { 119,-4046 },
 { 120,4219 }, { 121,-4046 }, { 122,-4046 }, { 123,-4046 }, { 124,-4046 },
 { 125,-4046 }, { 126,-4046 }, { 127,-4046 }, { 128,-4046 }, { 129,-4046 },
 { 130,-4046 }, { 131,-4046 }, { 132,-4046 }, { 133,-4046 }, { 134,-4046 },
 { 135,-4046 }, { 136,-4046 }, { 137,-4046 }, { 138,-4046 }, { 139,-4046 },
 { 140,-4046 }, { 141,-4046 }, { 142,-4046 }, { 143,-4046 }, { 144,-4046 },

 { 145,-4046 }, { 146,-4046 }, { 147,-4046 }, { 148,-4046 }, { 149,-4046 },
 { 150,-4046 }, { 151,-4046 }, { 152,-4046 }, { 153,-4046 }, { 154,-4046 },
 { 155,-4046 }, { 156,-4046 }, { 157,-4046 }, { 158,-4046 }, { 159,-4046 },
 { 160,-4046 }, { 161,-4046 }, { 162,-4046 }, { 163,-4046 }, { 164,-4046 },
 { 165,-4046 }, { 166,-4046 }, { 167,-4046 }, { 168,-4046 }, { 169,-4046 },
 { 170,-4046 }, { 171,-4046 }, { 172,-4046 }, { 173,-4046 }, { 174,-4046 },
 { 175,-4046 }, { 176,-4046 }, { 177,-4046 }, { 178,-4046 }, { 179,-4046 },
 { 180,-4046 }, { 181,-4046 }, { 182,-4046 }, { 183,-4046 }, { 184,-4046 },
 { 185,-4046 }, { 186,-4046 }, { 187,-4046 }, { 188,-4046 }, { 189,-4046 },
 { 190,-4046 }, { 191,-4046 }, { 192,-4046 }, { 193,-4046 }, { 194,-4046 },

 { 195,-4046 }, { 196,-4046 }, { 197,-4046 }, { 198,-4046 }, { 199,-4046 },
 { 200,-4046 }, { 201,-4046 }, { 202,-4046 }, { 203,-4046 }, { 204,-4046 },
 { 205,-4046 }, { 206,-4046 }, { 207,-4046 }, { 208,-4046 }, { 209,-4046 },
 { 210,-4046 }, { 211,-4046 }, { 212,-4046 }, { 213,-4046 }, { 214,-4046 },
 { 215,-4046 }, { 216,-4046 }, { 217,-4046 }, { 218,-4046 }, { 219,-4046 },
 { 220,-4046 }, { 221,-4046 }, { 222,-4046 }, { 223,-4046 }, { 224,-4046 },
 { 225,-4046 }, { 226,-4046 }, { 227,-4046 }, { 228,-4046 }, { 229,-4046 },
 { 230,-4046 }, { 231,-4046 }, { 232,-4046 }, { 233,-4046 }, { 234,-4046 },
 { 235,-4046 }, { 236,-4046 }, { 237,-4046 }, { 238,-4046 }, { 239,-4046 },
 { 240,-4046 }, { 241,-4046 }, { 242,-4046 }, { 243,-4046 }, { 244,-4046 },

 { 245,-4046 }, { 246,-4046 }, { 247,-4046 }, { 248,-4046 }, { 249,-4046 },
 { 250,-4046 }, { 251,-4046 }, { 252,-4046 }, { 253,-4046 }, { 254,-4046 },
 { 255,-4046 }, { 256,-4046 }, {   0,  46 }, {   0,25377 }, {   1,4065 },
 {   2,4065 }, {   3,4065 }, {   4,4065 }, {   5,4065 }, {   6,4065 },
 {   7,4065 }, {   8,4065 }, {   9,4065 }, {  10,4065 }, {  11,4065 },
 {  12,4065 }, {  13,4065 }, {  14,4065 }, {  15,4065 }, {  16,4065 },
 {  17,4065 }, {  18,4065 }, {  19,4065 }, {  20,4065 }, {  21,4065 },
 {  22,4065 }, {  23,4065 }, {  24,4065 }, {  25,4065 }, {  26,4065 },
 {  27,4065 }, {  28,4065 }, {  29,4065 }, {  30,4065 }, {  31,4065 },
 {  32,4065 }, {  33,4065 }, {  34,4065 }, {  35,4065 }, {   0,   0 },

 {  37,4065 }, {  38,4065 }, {  39,4065 }, {  40,4065 }, {  41,4065 },
 {  42,4065 }, {  43,4065 }, {  44,4065 }, {  45,4065 }, {  46,4065 },
 {  47,4065 }, {  48,4065 }, {  49,4065 }, {  50,4065 }, {  51,4065 },
 {  52,4065 }, {  53,4065 }, {  54,4065 }, {  55,4065 }, {  56,4065 },
 {  57,4065 }, {  58,4065 }, {  59,4065 }, {  60,4065 }, {  61,4065 },
 {  62,4065 }, {  63,4065 }, {  64,4065 }, {  65,4065 }, {  66,4065 },
 {  67,4065 }, {  68,4065 }, {  69,4065 }, {  70,4065 }, {  71,4065 },
 {  72,4065 }, {  73,4065 }, {  74,4065 }, {  75,4065 }, {  76,4065 },
 {  77,4065 }, {  78,4065 }, {  79,4065 }, {  80,4065 }, {  81,4065 },
 {  82,4065 }, {  83,4065 }, {  84,4065 }, {  85,4065 }, {  86,4065 },

 {  87,4065 }, {  88,4065 }, {  89,4065 }, {  90,4065 }, {  91,4065 },
 {  92,4065 }, {  93,4065 }, {  94,4065 }, {  95,4065 }, {  96,4065 },
 {  97,4065 }, {  98,4065 }, {  99,4065 }, { 100,4065 }, { 101,4065 },
 { 102,4065 }, { 103,4065 }, { 104,4065 }, { 105,4065 }, { 106,4065 },
 { 107,4065 }, { 108,4065 }, { 109,4065 }, { 110,4065 }, { 111,4065 },
 { 112,4065 }, { 113,4065 }, { 114,4065 }, { 115,4065 }, { 116,4065 },
 { 117,4065 }, { 118,4065 }, { 119,4065 }, { 120,4065 }, { 121,4065 },
 { 122,4065 }, { 123,4065 }, { 124,4065 }, { 125,4065 }, { 126,4065 },
 { 127,4065 }, { 128,4065 }, { 129,4065 }, { 130,4065 }, { 131,4065 },
 { 132,4065 }, { 133,4065 }, { 134,4065 }, { 135,4065 }, { 136,4065 },

 { 137,4065 }, { 138,4065 }, { 139,4065 }, { 140,4065 }, { 141,4065 },
 { 142,4065 }, { 143,4065 }, { 144,4065 }, { 145,4065 }, { 146,4065 },
 { 147,4065 }, { 148,4065 }, { 149,4065 }, { 150,4065 }, { 151,4065 },
 { 152,4065 }, { 153,4065 }, { 154,4065 }, { 155,4065 }, { 156,4065 },
 { 157,4065 }, { 158,4065 }, { 159,4065 }, { 160,4065 }, { 161,4065 },
 { 162,4065 }, { 163,4065 }, { 164,4065 }, { 165,4065 }, { 166,4065 },
 { 167,4065 }, { 168,4065 }, { 169,4065 }, { 170,4065 }, { 171,4065 },
 { 172,4065 }, { 173,4065 }, { 174,4065 }, { 175,4065 }, { 176,4065 },
 { 177,4065 }, { 178,4065 }, { 179,4065 }, { 180,4065 }, { 181,4065 },
 { 182,4065 }, { 183,4065 }, { 184,4065 }, { 185,4065 }, { 186,4065 },

 { 187,4065 }, { 188,4065 }, { 189,4065 }, { 190,4065 }, { 191,4065 },
 { 192,4065 }, { 193,4065 }, { 194,4065 }, { 195,4065 }, { 196,4065 },
 { 197,4065 }, { 198,4065 }, { 199,4065 }, { 200,4065 }, { 201,4065 },
 { 202,4065 }, { 203,4065 }, { 204,4065 }, { 205,4065 }, { 206,4065 },
 { 207,4065 }, { 208,4065 }, { 209,4065 }, { 210,4065 }, { 211,4065 },
 { 212,4065 }, { 213,4065 }, { 214,4065 }, { 215,4065 }, { 216,4065 },
 { 217,4065 }, { 218,4065 }, { 219,4065 }, { 220,4065 }, { 221,4065 },
 { 222,4065 }, { 223,4065 }, { 224,4065 }, { 225,4065 }, { 226,4065 },
 { 227,4065 }, { 228,4065 }, { 229,4065 }, { 230,4065 }, { 231,4065 },
 { 232,4065 }, { 233,4065 }, { 234,4065 }, { 235,4065 }, { 236,4065 },

 { 237,4065 }, { 238,4065 }, { 239,4065 }, { 240,4065 }, { 241,4065 },
 { 242,4065 }, { 243,4065 }, { 244,4065 }, { 245,4065 }, { 246,4065 },
 { 247,4065 }, { 248,4065 }, { 249,4065 }, { 250,4065 }, { 251,4065 },
 { 252,4065 }, { 253,4065 }, { 254,4065 }, { 255,4065 }, { 256,4065 },
 {   0,  46 }, {   0,25119 }, {   1,3807 }, {   2,3807 }, {   3,3807 },
 {   4,3807 }, {   5,3807 }, {   6,3807 }, {   7,3807 }, {   8,3807 },
 {   9,3807 }, {  10,3807 }, {  11,3807 }, {  12,3807 }, {  13,3807 },
 {  14,3807 }, {  15,3807 }, {  16,3807 }, {  17,3807 }, {  18,3807 },
 {  19,3807 }, {  20,3807 }, {  21,3807 }, {  22,3807 }, {  23,3807 },
 {  24,3807 }, {  25,3807 }, {  26,3807 }, {  27,3807 }, {  28,3807 },

 {  29,3807 }, {  30,3807 }, {  31,3807 }, {  32,3807 }, {  33,3807 },
 {  34,3807 }, {  35,3807 }, {   0,   0 }, {  37,3807 }, {  38,3807 },
 {  39,3807 }, {  40,3807 }, {  41,3807 }, {  42,3807 }, {  43,3807 },
 {  44,3807 }, {  45,3807 }, {  46,3807 }, {  47,3807 }, {  48,3807 },
 {  49,3807 }, {  50,3807 }, {  51,3807 }, {  52,3807 }, {  53,3807 },
 {  54,3807 }, {  55,3807 }, {  56,3807 }, {  57,3807 }, {  58,3807 },
 {  59,3807 }, {  60,3807 }, {  61,3807 }, {  62,3807 }, {  63,3807 },
 {  64,3807 }, {  65,3807 }, {  66,3807 }, {  67,3807 }, {  68,3807 },
 {  69,3807 }, {  70,3807 }, {  71,3807 }, {  72,3807 }, {  73,3807 },
 {  74,3807 }, {  75,3807 }, {  76,3807 }, {  77,3807 }, {  78,3807 },

 {  79,3807 }, {  80,3807 }, {  81,3807 }, {  82,3807 }, {  83,3807 },
 {  84,3807 }, {  85,3807 }, {  86,3807 }, {  87,3807 }, {  88,3807 },
 {  89,3807 }, {  90,3807 }, {  91,3807 }, {  92,3807 }, {  93,3807 },
 {  94,3807 }, {  95,3807 }, {  96,3807 }, {  97,3807 }, {  98,3807 },
 {  99,3807 }, { 100,3807 }, { 101,3807 }, { 102,3807 }, { 103,3807 },
 { 104,3807 }, { 105,3807 }, { 106,3807 }, { 107,3807 }, { 108,3807 },
 { 109,3807 }, { 110,3807 }, { 111,3807 }, { 112,3807 }, { 113,3807 },
 { 114,3807 }, { 115,3807 }, { 116,3807 }, { 117,3807 }, { 118,3807 },
 { 119,3807 }, { 120,3807 }, { 121,3807 }, { 122,3807 }, { 123,3807 },
 { 124,3807 }, { 125,3807 }, { 126,3807 }, { 127,3807 }, { 128,3807 },

 { 129,3807 }, { 130,3807 }, { 131,3807 }, { 132,3807 }, { 133,3807 },
 { 134,3807 }, { 135,3807 }, { 136,3807 }, { 137,3807 }, { 138,3807 },
 { 139,3807 }, { 140,3807 }, { 141,3807 }, { 142,3807 }, { 143,3807 },
 { 144,3807 }, { 145,3807 }, { 146,3807 }, { 147,3807 }, { 148,3807 },
 { 149,3807 }, { 150,3807 }, { 151,3807 }, { 152,3807 }, { 153,3807 },
 { 154,3807 }, { 155,3807 }, { 156,3807 }, { 157,3807 }, { 158,3807 },
 { 159,3807 }, { 160,3807 }, { 161,3807 }, { 162,3807 }, { 163,3807 },
 { 164,3807 }, { 165,3807 }, { 166,3807 }, { 167,3807 }, { 168,3807 },
 { 169,3807 }, { 170,3807 }, { 171,3807 }, { 172,3807 }, { 173,3807 },
 { 174,3807 }, { 175,3807 }, { 176,3807 }, { 177,3807 }, { 178,3807 },

 { 179,3807 }, { 180,3807 }, { 181,3807 }, { 182,3807 }, { 183,3807 },
 { 184,3807 }, { 185,3807 }, { 186,3807 }, { 187,3807 }, { 188,3807 },
 { 189,3807 }, { 190,3807 }, { 191,3807 }, { 192,3807 }, { 193,3807 },
 { 194,3807 }, { 195,3807 }, { 196,3807 }, { 197,3807 }, { 198,3807 },
 { 199,3807 }, { 200,3807 }, { 201,3807 }, { 202,3807 }, { 203,3807 },
 { 204,3807 }, { 205,3807 }, { 206,3807 }, { 207,3807 }, { 208,3807 },
 { 209,3807 }, { 210,3807 }, { 211,3807 }, { 212,3807 }, { 213,3807 },
 { 214,3807 }, { 215,3807 }, { 216,3807 }, { 217,3807 }, { 218,3807 },
 { 219,3807 }, { 220,3807 }, { 221,3807 }, { 222,3807 }, { 223,3807 },
 { 224,3807 }, { 225,3807 }, { 226,3807 }, { 227,3807 }, { 228,3807 },

 { 229,3807 }, { 230,3807 }, { 231,3807 }, { 232,3807 }, { 233,3807 },
 { 234,3807 }, { 235,3807 }, { 236,3807 }, { 237,3807 }, { 238,3807 },
 { 239,3807 }, { 240,3807 }, { 241,3807 }, { 242,3807 }, { 243,3807 },
 { 244,3807 }, { 245,3807 }, { 246,3807 }, { 247,3807 }, { 248,3807 },
 { 249,3807 }, { 250,3807 }, { 251,3807 }, { 252,3807 }, { 253,3807 },
 { 254,3807 }, { 255,3807 }, { 256,3807 }, {   0,  48 }, {   0,24861 },
 {   0,  53 }, {   0,24859 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  53 }, {   0,24854 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   9,3807 }, {  10,3807 }, {   0,   0 }, {  12,3807 }, {  13,3807 },
 {   9,3802 }, {  10,3802 }, {   0,   0 }, {  12,3802 }, {  13,3802 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  32,3807 }, {   0,   0 },
 {  36,-4818 }, {   0,   0 }, {   0,   0 }, {  32,3802 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,3807 },
 {  66,3807 }, {  67,3807 }, {  68,3807 }, {  69,3807 }, {  70,3807 },

 {  71,3807 }, {  72,3807 }, {  73,3807 }, {  74,3807 }, {  75,3807 },
 {  76,3807 }, {  77,3807 }, {  78,3807 }, {  79,3807 }, {  80,3807 },
 {  81,3807 }, {  82,3807 }, {  83,3807 }, {  84,3807 }, {  85,3807 },
 {  86,3807 }, {  87,3807 }, {  88,3807 }, {  89,3807 }, {  90,3807 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,3807 },
 {   0,   0 }, {  97,3807 }, {  98,3807 }, {  99,3807 }, { 100,3807 },
 { 101,3807 }, { 102,3807 }, { 103,3807 }, { 104,3807 }, { 105,3807 },
 { 106,3807 }, { 107,3807 }, { 108,3807 }, { 109,3807 }, { 110,3807 },
 { 111,3807 }, { 112,3807 }, { 113,3807 }, { 114,3807 }, { 115,3807 },
 { 116,3807 }, { 117,3807 }, { 118,3807 }, { 119,3807 }, { 120,3807 },

 { 121,3807 }, { 122,3807 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,3807 }, { 129,3807 }, { 130,3807 },
 { 131,3807 }, { 132,3807 }, { 133,3807 }, { 134,3807 }, { 135,3807 },
 { 136,3807 }, { 137,3807 }, { 138,3807 }, { 139,3807 }, { 140,3807 },
 { 141,3807 }, { 142,3807 }, { 143,3807 }, { 144,3807 }, { 145,3807 },
 { 146,3807 }, { 147,3807 }, { 148,3807 }, { 149,3807 }, { 150,3807 },
 { 151,3807 }, { 152,3807 }, { 153,3807 }, { 154,3807 }, { 155,3807 },
 { 156,3807 }, { 157,3807 }, { 158,3807 }, { 159,3807 }, { 160,3807 },
 { 161,3807 }, { 162,3807 }, { 163,3807 }, { 164,3807 }, { 165,3807 },
 { 166,3807 }, { 167,3807 }, { 168,3807 }, { 169,3807 }, { 170,3807 },

 { 171,3807 }, { 172,3807 }, { 173,3807 }, { 174,3807 }, { 175,3807 },
 { 176,3807 }, { 177,3807 }, { 178,3807 }, { 179,3807 }, { 180,3807 },
 { 181,3807 }, { 182,3807 }, { 183,3807 }, { 184,3807 }, { 185,3807 },
 { 186,3807 }, { 187,3807 }, { 188,3807 }, { 189,3807 }, { 190,3807 },
 { 191,3807 }, { 192,3807 }, { 193,3807 }, { 194,3807 }, { 195,3807 },
 { 196,3807 }, { 197,3807 }, { 198,3807 }, { 199,3807 }, { 200,3807 },
 { 201,3807 }, { 202,3807 }, { 203,3807 }, { 204,3807 }, { 205,3807 },
 { 206,3807 }, { 207,3807 }, { 208,3807 }, { 209,3807 }, { 210,3807 },
 { 211,3807 }, { 212,3807 }, { 213,3807 }, { 214,3807 }, { 215,3807 },
 { 216,3807 }, { 217,3807 }, { 218,3807 }, { 219,3807 }, { 220,3807 },

 { 221,3807 }, { 222,3807 }, { 223,3807 }, { 224,3807 }, { 225,3807 },
 { 226,3807 }, { 227,3807 }, { 228,3807 }, { 229,3807 }, { 230,3807 },
 { 231,3807 }, { 232,3807 }, { 233,3807 }, { 234,3807 }, { 235,3807 },
 { 236,3807 }, { 237,3807 }, { 238,3807 }, { 239,3807 }, { 240,3807 },
 { 241,3807 }, { 242,3807 }, { 243,3807 }, { 244,3807 }, { 245,3807 },
 { 246,3807 }, { 247,3807 }, { 248,3807 }, { 249,3807 }, { 250,3807 },
 { 251,3807 }, { 252,3807 }, { 253,3807 }, { 254,3807 }, { 255,3807 },
 {   0,  24 }, {   0,24604 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  26 }, {   0,24599 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   9,4065 }, {  10,4070 }, {   0,   0 }, {  12,4065 }, {  13,4070 },

 {   9,4081 }, {  10,4081 }, {   0,   0 }, {  12,4081 }, {  13,4081 },
 {   0,   0 }, {   0,  26 }, {   0,24583 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   9,4065 }, {  10,4065 }, {  32,4065 }, {  12,4065 },
 {  13,4065 }, {   0,   0 }, {   0,   0 }, {  32,4081 }, {   0,   0 },
 {  39,-5081 }, {   0,   0 }, {   0,   1 }, {   0,24562 }, {   0,  69 },
 {   0,24560 }, {  45,-5036 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   9,   0 }, {  10,   0 }, {  32,4065 },
 {  12,   0 }, {  13,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  32,   0 }, {   0,   0 }, {   0,   0 }, {  33,   0 }, {   0,   0 },
 {  35,   0 }, {   0,   0 }, {  37,   0 }, {  38,   0 }, {   0,  67 },
 {   0,24520 }, {   0,   0 }, {  42,   0 }, {  43,   0 }, {   0,   0 },
 {  45,   0 }, {   0,   0 }, {  47,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  70 }, {   0,24503 }, {   0,   0 }, {   0,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33, -40 }, {   0,   0 },
 {  35, -40 }, {   0,   0 }, {  37, -40 }, {  38, -40 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42, -40 }, {  43, -40 }, {   0,   0 },
 {  45, -40 }, {   0,   0 }, {  47, -40 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,   0 },
 {   0,   0 }, {  96,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  60, -40 }, {  61, -40 }, {  62, -40 }, {  63, -40 }, {  64, -40 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  44 }, {   0,24441 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,   0 },
 {   0,   0 }, { 126,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94, -40 },
 {   0,   0 }, {  96, -40 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-5515 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124, -40 },
 {   0,   0 }, { 126, -40 }, {  48,4297 }, {  49,4297 }, {  50,4297 },

 {  51,4297 }, {  52,4297 }, {  53,4297 }, {  54,4297 }, {  55,4297 },
 {  56,4297 }, {  57,4297 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,4297 },
 {  66,4297 }, {  67,4297 }, {  68,4297 }, {  69,4297 }, {  70,4297 },
 {  71,4297 }, {  72,4297 }, {  73,4297 }, {  74,4297 }, {  75,4297 },
 {  76,4297 }, {  77,4297 }, {  78,4297 }, {  79,4297 }, {  80,4297 },
 {  81,4297 }, {  82,4297 }, {  83,4297 }, {  84,4297 }, {  85,4297 },
 {  86,4297 }, {  87,4297 }, {  88,4297 }, {  89,4297 }, {  90,4297 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,4297 },
 {   0,   0 }, {  97,4297 }, {  98,4297 }, {  99,4297 }, { 100,4297 },

 { 101,4297 }, { 102,4297 }, { 103,4297 }, { 104,4297 }, { 105,4297 },
 { 106,4297 }, { 107,4297 }, { 108,4297 }, { 109,4297 }, { 110,4297 },
 { 111,4297 }, { 112,4297 }, { 113,4297 }, { 114,4297 }, { 115,4297 },
 { 116,4297 }, { 117,4297 }, { 118,4297 }, { 119,4297 }, { 120,4297 },
 { 121,4297 }, { 122,4297 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,4297 }, { 129,4297 }, { 130,4297 },
 { 131,4297 }, { 132,4297 }, { 133,4297 }, { 134,4297 }, { 135,4297 },
 { 136,4297 }, { 137,4297 }, { 138,4297 }, { 139,4297 }, { 140,4297 },
 { 141,4297 }, { 142,4297 }, { 143,4297 }, { 144,4297 }, { 145,4297 },
 { 146,4297 }, { 147,4297 }, { 148,4297 }, { 149,4297 }, { 150,4297 },

 { 151,4297 }, { 152,4297 }, { 153,4297 }, { 154,4297 }, { 155,4297 },
 { 156,4297 }, { 157,4297 }, { 158,4297 }, { 159,4297 }, { 160,4297 },
 { 161,4297 }, { 162,4297 }, { 163,4297 }, { 164,4297 }, { 165,4297 },
 { 166,4297 }, { 167,4297 }, { 168,4297 }, { 169,4297 }, { 170,4297 },
 { 171,4297 }, { 172,4297 }, { 173,4297 }, { 174,4297 }, { 175,4297 },
 { 176,4297 }, { 177,4297 }, { 178,4297 }, { 179,4297 }, { 180,4297 },
 { 181,4297 }, { 182,4297 }, { 183,4297 }, { 184,4297 }, { 185,4297 },
 { 186,4297 }, { 187,4297 }, { 188,4297 }, { 189,4297 }, { 190,4297 },
 { 191,4297 }, { 192,4297 }, { 193,4297 }, { 194,4297 }, { 195,4297 },
 { 196,4297 }, { 197,4297 }, { 198,4297 }, { 199,4297 }, { 200,4297 },

 { 201,4297 }, { 202,4297 }, { 203,4297 }, { 204,4297 }, { 205,4297 },
 { 206,4297 }, { 207,4297 }, { 208,4297 }, { 209,4297 }, { 210,4297 },
 { 211,4297 }, { 212,4297 }, { 213,4297 }, { 214,4297 }, { 215,4297 },
 { 216,4297 }, { 217,4297 }, { 218,4297 }, { 219,4297 }, { 220,4297 },
 { 221,4297 }, { 222,4297 }, { 223,4297 }, { 224,4297 }, { 225,4297 },
 { 226,4297 }, { 227,4297 }, { 228,4297 }, { 229,4297 }, { 230,4297 },
 { 231,4297 }, { 232,4297 }, { 233,4297 }, { 234,4297 }, { 235,4297 },
 { 236,4297 }, { 237,4297 }, { 238,4297 }, { 239,4297 }, { 240,4297 },
 { 241,4297 }, { 242,4297 }, { 243,4297 }, { 244,4297 }, { 245,4297 },
 { 246,4297 }, { 247,4297 }, { 248,4297 }, { 249,4297 }, { 250,4297 },

 { 251,4297 }, { 252,4297 }, { 253,4297 }, { 254,4297 }, { 255,4297 },
 {   0,   1 }, {   0,24184 }, {   1,4297 }, {   2,4297 }, {   3,4297 },
 {   4,4297 }, {   5,4297 }, {   6,4297 }, {   7,4297 }, {   8,4297 },
 {   9,4297 }, {   0,   0 }, {  11,4297 }, {  12,4297 }, {   0,   0 },
 {  14,4297 }, {  15,4297 }, {  16,4297 }, {  17,4297 }, {  18,4297 },
 {  19,4297 }, {  20,4297 }, {  21,4297 }, {  22,4297 }, {  23,4297 },
 {  24,4297 }, {  25,4297 }, {  26,4297 }, {  27,4297 }, {  28,4297 },
 {  29,4297 }, {  30,4297 }, {  31,4297 }, {  32,4297 }, {  33,4555 },
 {  34,4297 }, {  35,4555 }, {  36,4297 }, {  37,4555 }, {  38,4555 },
 {  39,4297 }, {  40,4297 }, {  41,4297 }, {  42,4555 }, {  43,4555 },

 {  44,4297 }, {  45,4555 }, {  46,4297 }, {  47,4555 }, {  48,4297 },
 {  49,4297 }, {  50,4297 }, {  51,4297 }, {  52,4297 }, {  53,4297 },
 {  54,4297 }, {  55,4297 }, {  56,4297 }, {  57,4297 }, {  58,4297 },
 {  59,4297 }, {  60,4555 }, {  61,4555 }, {  62,4555 }, {  63,4555 },
 {  64,4555 }, {  65,4297 }, {  66,4297 }, {  67,4297 }, {  68,4297 },
 {  69,4297 }, {  70,4297 }, {  71,4297 }, {  72,4297 }, {  73,4297 },
 {  74,4297 }, {  75,4297 }, {  76,4297 }, {  77,4297 }, {  78,4297 },
 {  79,4297 }, {  80,4297 }, {  81,4297 }, {  82,4297 }, {  83,4297 },
 {  84,4297 }, {  85,4297 }, {  86,4297 }, {  87,4297 }, {  88,4297 },
 {  89,4297 }, {  90,4297 }, {  91,4297 }, {  92,4297 }, {  93,4297 },

 {  94,4555 }, {  95,4297 }, {  96,4555 }, {  97,4297 }, {  98,4297 },
 {  99,4297 }, { 100,4297 }, { 101,4297 }, { 102,4297 }, { 103,4297 },
 { 104,4297 }, { 105,4297 }, { 106,4297 }, { 107,4297 }, { 108,4297 },
 { 109,4297 }, { 110,4297 }, { 111,4297 }, { 112,4297 }, { 113,4297 },
 { 114,4297 }, { 115,4297 }, { 116,4297 }, { 117,4297 }, { 118,4297 },
 { 119,4297 }, { 120,4297 }, { 121,4297 }, { 122,4297 }, { 123,4297 },
 { 124,4555 }, { 125,4297 }, { 126,4555 }, { 127,4297 }, { 128,4297 },
 { 129,4297 }, { 130,4297 }, { 131,4297 }, { 132,4297 }, { 133,4297 },
 { 134,4297 }, { 135,4297 }, { 136,4297 }, { 137,4297 }, { 138,4297 },
 { 139,4297 }, { 140,4297 }, { 141,4297 }, { 142,4297 }, { 143,4297 },

 { 144,4297 }, { 145,4297 }, { 146,4297 }, { 147,4297 }, { 148,4297 },
 { 149,4297 }, { 150,4297 }, { 151,4297 }, { 152,4297 }, { 153,4297 },
 { 154,4297 }, { 155,4297 }, { 156,4297 }, { 157,4297 }, { 158,4297 },
 { 159,4297 }, { 160,4297 }, { 161,4297 }, { 162,4297 }, { 163,4297 },
 { 164,4297 }, { 165,4297 }, { 166,4297 }, { 167,4297 }, { 168,4297 },
 { 169,4297 }, { 170,4297 }, { 171,4297 }, { 172,4297 }, { 173,4297 },
 { 174,4297 }, { 175,4297 }, { 176,4297 }, { 177,4297 }, { 178,4297 },
 { 179,4297 }, { 180,4297 }, { 181,4297 }, { 182,4297 }, { 183,4297 },
 { 184,4297 }, { 185,4297 }, { 186,4297 }, { 187,4297 }, { 188,4297 },
 { 189,4297 }, { 190,4297 }, { 191,4297 }, { 192,4297 }, { 193,4297 },

 { 194,4297 }, { 195,4297 }, { 196,4297 }, { 197,4297 }, { 198,4297 },
 { 199,4297 }, { 200,4297 }, { 201,4297 }, { 202,4297 }, { 203,4297 },
 { 204,4297 }, { 205,4297 }, { 206,4297 }, { 207,4297 }, { 208,4297 },
 { 209,4297 }, { 210,4297 }, { 211,4297 }, { 212,4297 }, { 213,4297 },
 { 214,4297 }, { 215,4297 }, { 216,4297 }, { 217,4297 }, { 218,4297 },
 { 219,4297 }, { 220,4297 }, { 221,4297 }, { 222,4297 }, { 223,4297 },
 { 224,4297 }, { 225,4297 }, { 226,4297 }, { 227,4297 }, { 228,4297 },
 { 229,4297 }, { 230,4297 }, { 231,4297 }, { 232,4297 }, { 233,4297 },
 { 234,4297 }, { 235,4297 }, { 236,4297 }, { 237,4297 }, { 238,4297 },
 { 239,4297 }, { 240,4297 }, { 241,4297 }, { 242,4297 }, { 243,4297 },

 { 244,4297 }, { 245,4297 }, { 246,4297 }, { 247,4297 }, { 248,4297 },
 { 249,4297 }, { 250,4297 }, { 251,4297 }, { 252,4297 }, { 253,4297 },
 { 254,4297 }, { 255,4297 }, { 256,4297 }, {   0,  72 }, {   0,23926 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   2 }, {   0,23901 },
 {   0,  72 }, {   0,23899 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {  33,4530 }, {   0,   0 }, {  35,4530 },
 {   0,   0 }, {  37,4530 }, {  38,4530 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  42,4530 }, {  43,4530 }, {  69, 113 }, {  45,4530 },
 {   0,   0 }, {  47,4530 }, {  46,-5710 }, {   0,   0 }, {  48,4530 },
 {  49,4530 }, {  50,4530 }, {  51,4530 }, {  52,4530 }, {  53,4530 },
 {  54,4530 }, {  55,4530 }, {  56,4530 }, {  57,4530 }, {  60,4530 },

 {  61,4530 }, {  62,4530 }, {  63,4530 }, {  64,4530 }, {   0,  71 },
 {   0,23835 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  69,  86 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 101, 113 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  75 }, {   0,23813 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,4530 }, {   0,   0 },
 {  96,4530 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 101,  86 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  46, -64 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, { 124,4530 }, {   0,   0 },
 { 126,4530 }, {   0,  64 }, {   0,23773 }, {   0,   0 }, {   0,   0 },
 {  43,4466 }, {   0,   0 }, {  45,4466 }, {   0,   0 }, {  69,  22 },
 {  48,4508 }, {  49,4508 }, {  50,4508 }, {  51,4508 }, {  52,4508 },
 {  53,4508 }, {  54,4508 }, {  55,4508 }, {  56,4508 }, {  57,4508 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  33,-787 }, {   0,   0 }, {  35,-787 }, {   0,   0 }, {  37,-787 },
 {  38,-787 }, { 101,  22 }, {   0,  66 }, {   0,23732 }, {  42,-787 },
 {  43,-787 }, {   0,   0 }, {  45,-787 }, {   0,   0 }, {  47,-787 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  60,-787 }, {  61,-787 }, {  62,-787 },
 {  63,-787 }, {  64,-787 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  33,-828 }, {   0,   0 }, {  35,-828 }, {   0,   0 },
 {  37,-828 }, {  38,-828 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  42,-828 }, {  43,-828 }, {   0,   0 }, {  45,-828 }, {   0,   0 },
 {  47,-828 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,-787 }, {   0,   0 }, {  96,-787 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,-828 }, {  61,-828 },
 {  62,-828 }, {  63,-828 }, {  64,-828 }, {   0,   0 }, {   0,  63 },
 {   0,23665 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  65 }, {   0,23654 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 124,-787 }, {   0,   0 }, { 126,-787 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  94,-828 }, {   0,   0 }, {  96,-828 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,-895 }, {   0,   0 },
 {  35,-895 }, {   0,   0 }, {  37,-895 }, {  38,-895 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42,-895 }, {  43,-895 }, {  33,-906 },
 {  45,-895 }, {  35,-906 }, {  47,-895 }, {  37,-906 }, {  38,-906 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,-906 }, {  43,-906 },
 {   0,   0 }, {  45,-906 }, { 124,-828 }, {  47,-906 }, { 126,-828 },
 {  60,-895 }, {  61,-895 }, {  62,-895 }, {  63,-895 }, {  64,-895 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  60,-906 }, {  61,-906 }, {  62,-906 }, {  63,-906 },

 {  64,-906 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  77 }, {   0,23574 }, {   0,   0 }, {   0,   0 }, {  94,-895 },
 {   0,   0 }, {  96,-895 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94,-906 }, {   0,   0 }, {  96,-906 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,-895 },

 {   0,   0 }, { 126,-895 }, {  36,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 124,-906 }, {   0,   0 }, { 126,-906 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },
 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },
 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },

 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },
 {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },
 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },
 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },
 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },
 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,   0 },
 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },

 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },
 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },
 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },
 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },
 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },
 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },
 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },

 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },
 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },
 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },
 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },
 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },
 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },
 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },

 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },
 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },
 { 254,   0 }, { 255,   0 }, {   0,  12 }, {   0,23317 }, {   1,   0 },
 {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 },
 {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 },
 {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 },
 {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 },
 {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 },

 {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 },
 {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 },
 {  37,   0 }, {  38,   0 }, {   0,   0 }, {  40,   0 }, {  41,   0 },
 {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 },
 {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },

 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 },
 {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 },

 { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },

 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },

 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 },
 {   0,   9 }, {   0,23059 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   9 }, {   0,23054 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   9,   0 }, {  10,   5 }, {   0,   0 }, {  12,   0 }, {  13,   5 },
 {   9,3781 }, {  10,3781 }, {   0,   0 }, {  12,3781 }, {  13,3781 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  32,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  32,3781 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  39,-6539 }, {  45,-6642 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  45,-6532 }, {   0,   5 }, {   0,23007 }, {   1,   0 },
 {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 },
 {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 },
 {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 },

 {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 },
 {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 },
 {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 },
 {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 },
 {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 },
 {   0,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 },

 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 },
 {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },

 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 },
 { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },

 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },

 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 },
 {   0,   3 }, {   0,22749 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,3781 },
 {   0,   0 }, {  35,3781 }, {   0,   0 }, {  37,3781 }, {  38,3781 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,3781 }, {  43,3781 },
 {   0,   0 }, {  45,3781 }, {   0,   0 }, {  47,3781 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  60,3781 }, {  61,3781 }, {  62,3781 }, {  63,3781 },
 {  64,3781 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94,3781 }, {   0,   0 }, {  96,3781 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 124,3781 }, {   0,   0 }, { 126,3781 }, {   0,  58 }, {   0,22621 },
 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },
 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 },
 {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },
 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },
 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },

 {  31,   0 }, {  32,   0 }, {  33,   0 }, {   0,   0 }, {  35,   0 },
 {  36,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 },
 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 },
 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },
 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },

 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },
 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },
 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },
 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },

 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },
 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },

 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },
 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },

 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 { 256,   0 }, {   0,  11 }, {   0,22363 }, {   1,   0 }, {   2,   0 },
 {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 },
 {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 },
 {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 },
 {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 },

 {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 },
 {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 },
 {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 },
 {  38,   0 }, {   0,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 },
 {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 }, {  47,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },

 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 },
 {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },

 { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },

 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },

 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  16 },
 {   0,22105 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  16 },
 {   0,22100 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,   0 },
 {  10,   5 }, {   0,   0 }, {  12,   0 }, {  13,   5 }, {   9,3139 },

 {  10,3139 }, {   0,   0 }, {  12,3139 }, {  13,3139 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  32,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  32,3139 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-7484 },
 {  45,-7582 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  45,-7479 }, {   0,  31 }, {   0,22053 }, {   1,   0 }, {   2,   0 },
 {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 },
 {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 },

 {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 },
 {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 },
 {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 },
 {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 },
 {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 },
 {  38,   0 }, {   0,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 },
 {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 }, {  47,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },

 {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 },
 {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },

 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },

 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },

 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  22 },
 {   0,21795 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  22 },

 {   0,21790 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,   0 },
 {  10,   5 }, {   0,   0 }, {  12,   0 }, {  13,   5 }, {   9,3208 },
 {  10,3208 }, {   0,   0 }, {  12,3208 }, {  13,3208 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  32,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  32,3208 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-7787 },
 {  45,-7888 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  45,-7785 }, {   0,  32 }, {   0,21743 }, {   1,   0 }, {   2,   0 },

 {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 },
 {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 },
 {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 },
 {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 },
 {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 },
 {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 },
 {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 },
 {  38,   0 }, {   0,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 },
 {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 }, {  47,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },

 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 }, {   0,   0 },
 {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },

 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },

 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },

 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },

 { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  39 },
 {   0,21485 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  37 }, {   0,21477 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  37 }, {   0,21454 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,3208 }, {  49,3208 },
 {  50,3208 }, {  51,3208 }, {  52,3208 }, {  53,3208 }, {  54,3208 },
 {  55,3208 }, {  48,3208 }, {  49,3208 }, {  50,3208 }, {  51,3208 },
 {  52,3208 }, {  53,3208 }, {  54,3208 }, {  55,3208 }, {  56,3208 },
 {  57,3208 }, {   0,   0 }, {   0,   0 }, {   0,  38 }, {   0,21416 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,3208 }, {  66,3208 },
 {  67,3208 }, {  68,3208 }, {  69,3208 }, {  70,3208 }, {  48,3208 },
 {  49,3208 }, {  50,3208 }, {  51,3208 }, {  52,3208 }, {  53,3208 },
 {  54,3208 }, {  55,3208 }, {  56,3208 }, {  57,3208 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  65,3208 }, {  66,3208 }, {  67,3208 }, {  68,3208 },
 {  69,3208 }, {  70,3208 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,3208 }, {  98,3208 }, {  99,3208 }, { 100,3208 }, { 101,3208 },
 { 102,3208 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,3208 }, {  49,3208 }, {  50,3208 },
 {  51,3208 }, {  52,3208 }, {  53,3208 }, {  54,3208 }, {  55,3208 },
 {  56,3208 }, {  57,3208 }, {   0,   0 }, {  97,3208 }, {  98,3208 },
 {  99,3208 }, { 100,3208 }, { 101,3208 }, { 102,3208 }, {  65,3208 },
 {  66,3208 }, {  67,3208 }, {  68,3208 }, {  69,3208 }, {  70,3208 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,3208 }, {  98,3208 }, {  99,3208 }, { 100,3208 },
 { 101,3208 }, { 102,3208 }, {   0,  46 }, {   0,21312 }, {   1,   0 },
 {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 },
 {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 },
 {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 },
 {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 },

 {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 },
 {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 },
 {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 }, {   0,   0 },
 {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 },
 {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 },
 {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },

 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 },
 {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },

 { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 },
 { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },

 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },

 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 },
 {   0,  47 }, {   0,21054 }, {   0,  53 }, {   0,21052 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   9,   0 }, {  10,   0 }, {   0,   0 },

 {  12,   0 }, {  13,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  32,   0 }, {   0,   0 }, {  36,-8625 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,2918 },
 {  49,2918 }, {  50,2918 }, {  51,2918 }, {  52,2918 }, {  53,2918 },
 {  54,2918 }, {  55,2918 }, {  56,2918 }, {  57,2918 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  65,2918 }, {  66,2918 }, {  67,2918 }, {  68,2918 },
 {  69,2918 }, {  70,2918 }, {  71,2918 }, {  72,2918 }, {  73,2918 },
 {  74,2918 }, {  75,2918 }, {  76,2918 }, {  77,2918 }, {  78,2918 },
 {  79,2918 }, {  80,2918 }, {  81,2918 }, {  82,2918 }, {  83,2918 },
 {  84,2918 }, {  85,2918 }, {  86,2918 }, {  87,2918 }, {  88,2918 },
 {  89,2918 }, {  90,2918 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,2918 }, {   0,   0 }, {  97,2918 }, {  98,2918 },
 {  99,2918 }, { 100,2918 }, { 101,2918 }, { 102,2918 }, { 103,2918 },
 { 104,2918 }, { 105,2918 }, { 106,2918 }, { 107,2918 }, { 108,2918 },
 { 109,2918 }, { 110,2918 }, { 111,2918 }, { 112,2918 }, { 113,2918 },

 { 114,2918 }, { 115,2918 }, { 116,2918 }, { 117,2918 }, { 118,2918 },
 { 119,2918 }, { 120,2918 }, { 121,2918 }, { 122,2918 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,2918 },
 { 129,2918 }, { 130,2918 }, { 131,2918 }, { 132,2918 }, { 133,2918 },
 { 134,2918 }, { 135,2918 }, { 136,2918 }, { 137,2918 }, { 138,2918 },
 { 139,2918 }, { 140,2918 }, { 141,2918 }, { 142,2918 }, { 143,2918 },
 { 144,2918 }, { 145,2918 }, { 146,2918 }, { 147,2918 }, { 148,2918 },
 { 149,2918 }, { 150,2918 }, { 151,2918 }, { 152,2918 }, { 153,2918 },
 { 154,2918 }, { 155,2918 }, { 156,2918 }, { 157,2918 }, { 158,2918 },
 { 159,2918 }, { 160,2918 }, { 161,2918 }, { 162,2918 }, { 163,2918 },

 { 164,2918 }, { 165,2918 }, { 166,2918 }, { 167,2918 }, { 168,2918 },
 { 169,2918 }, { 170,2918 }, { 171,2918 }, { 172,2918 }, { 173,2918 },
 { 174,2918 }, { 175,2918 }, { 176,2918 }, { 177,2918 }, { 178,2918 },
 { 179,2918 }, { 180,2918 }, { 181,2918 }, { 182,2918 }, { 183,2918 },
 { 184,2918 }, { 185,2918 }, { 186,2918 }, { 187,2918 }, { 188,2918 },
 { 189,2918 }, { 190,2918 }, { 191,2918 }, { 192,2918 }, { 193,2918 },
 { 194,2918 }, { 195,2918 }, { 196,2918 }, { 197,2918 }, { 198,2918 },
 { 199,2918 }, { 200,2918 }, { 201,2918 }, { 202,2918 }, { 203,2918 },
 { 204,2918 }, { 205,2918 }, { 206,2918 }, { 207,2918 }, { 208,2918 },
 { 209,2918 }, { 210,2918 }, { 211,2918 }, { 212,2918 }, { 213,2918 },

 { 214,2918 }, { 215,2918 }, { 216,2918 }, { 217,2918 }, { 218,2918 },
 { 219,2918 }, { 220,2918 }, { 221,2918 }, { 222,2918 }, { 223,2918 },
 { 224,2918 }, { 225,2918 }, { 226,2918 }, { 227,2918 }, { 228,2918 },
 { 229,2918 }, { 230,2918 }, { 231,2918 }, { 232,2918 }, { 233,2918 },
 { 234,2918 }, { 235,2918 }, { 236,2918 }, { 237,2918 }, { 238,2918 },
 { 239,2918 }, { 240,2918 }, { 241,2918 }, { 242,2918 }, { 243,2918 },
 { 244,2918 }, { 245,2918 }, { 246,2918 }, { 247,2918 }, { 248,2918 },
 { 249,2918 }, { 250,2918 }, { 251,2918 }, { 252,2918 }, { 253,2918 },
 { 254,2918 }, { 255,2918 }, {   0,  53 }, {   0,20797 }, {   1,2918 },
 {   2,2918 }, {   3,2918 }, {   4,2918 }, {   5,2918 }, {   6,2918 },

 {   7,2918 }, {   8,2918 }, {   9,2918 }, {   0,   0 }, {  11,2918 },
 {  12,2918 }, {   0,   0 }, {  14,2918 }, {  15,2918 }, {  16,2918 },
 {  17,2918 }, {  18,2918 }, {  19,2918 }, {  20,2918 }, {  21,2918 },
 {  22,2918 }, {  23,2918 }, {  24,2918 }, {  25,2918 }, {  26,2918 },
 {  27,2918 }, {  28,2918 }, {  29,2918 }, {  30,2918 }, {  31,2918 },
 {  32,2918 }, {  33,2918 }, {  34,2918 }, {  35,2918 }, {  36,2918 },
 {  37,2918 }, {  38,2918 }, {  39,2918 }, {  40,2918 }, {  41,2918 },
 {  42,2918 }, {  43,2918 }, {  44,2918 }, {  45,2918 }, {  46,2918 },
 {  47,2918 }, {  48,2918 }, {  49,2918 }, {  50,2918 }, {  51,2918 },
 {  52,2918 }, {  53,2918 }, {  54,2918 }, {  55,2918 }, {  56,2918 },

 {  57,2918 }, {  58,2918 }, {  59,2918 }, {  60,2918 }, {  61,2918 },
 {  62,2918 }, {  63,2918 }, {  64,2918 }, {  65,2918 }, {  66,2918 },
 {  67,2918 }, {  68,2918 }, {  69,2918 }, {  70,2918 }, {  71,2918 },
 {  72,2918 }, {  73,2918 }, {  74,2918 }, {  75,2918 }, {  76,2918 },
 {  77,2918 }, {  78,2918 }, {  79,2918 }, {  80,2918 }, {  81,2918 },
 {  82,2918 }, {  83,2918 }, {  84,2918 }, {  85,2918 }, {  86,2918 },
 {  87,2918 }, {  88,2918 }, {  89,2918 }, {  90,2918 }, {  91,2918 },
 {  92,2918 }, {  93,2918 }, {  94,2918 }, {  95,2918 }, {  96,2918 },
 {  97,2918 }, {  98,2918 }, {  99,2918 }, { 100,2918 }, { 101,2918 },
 { 102,2918 }, { 103,2918 }, { 104,2918 }, { 105,2918 }, { 106,2918 },

 { 107,2918 }, { 108,2918 }, { 109,2918 }, { 110,2918 }, { 111,2918 },
 { 112,2918 }, { 113,2918 }, { 114,2918 }, { 115,2918 }, { 116,2918 },
 { 117,2918 }, { 118,2918 }, { 119,2918 }, { 120,2918 }, { 121,2918 },
 { 122,2918 }, { 123,2918 }, { 124,2918 }, { 125,2918 }, { 126,2918 },
 { 127,2918 }, { 128,2918 }, { 129,2918 }, { 130,2918 }, { 131,2918 },
 { 132,2918 }, { 133,2918 }, { 134,2918 }, { 135,2918 }, { 136,2918 },
 { 137,2918 }, { 138,2918 }, { 139,2918 }, { 140,2918 }, { 141,2918 },
 { 142,2918 }, { 143,2918 }, { 144,2918 }, { 145,2918 }, { 146,2918 },
 { 147,2918 }, { 148,2918 }, { 149,2918 }, { 150,2918 }, { 151,2918 },
 { 152,2918 }, { 153,2918 }, { 154,2918 }, { 155,2918 }, { 156,2918 },

 { 157,2918 }, { 158,2918 }, { 159,2918 }, { 160,2918 }, { 161,2918 },
 { 162,2918 }, { 163,2918 }, { 164,2918 }, { 165,2918 }, { 166,2918 },
 { 167,2918 }, { 168,2918 }, { 169,2918 }, { 170,2918 }, { 171,2918 },
 { 172,2918 }, { 173,2918 }, { 174,2918 }, { 175,2918 }, { 176,2918 },
 { 177,2918 }, { 178,2918 }, { 179,2918 }, { 180,2918 }, { 181,2918 },
 { 182,2918 }, { 183,2918 }, { 184,2918 }, { 185,2918 }, { 186,2918 },
 { 187,2918 }, { 188,2918 }, { 189,2918 }, { 190,2918 }, { 191,2918 },
 { 192,2918 }, { 193,2918 }, { 194,2918 }, { 195,2918 }, { 196,2918 },
 { 197,2918 }, { 198,2918 }, { 199,2918 }, { 200,2918 }, { 201,2918 },
 { 202,2918 }, { 203,2918 }, { 204,2918 }, { 205,2918 }, { 206,2918 },

 { 207,2918 }, { 208,2918 }, { 209,2918 }, { 210,2918 }, { 211,2918 },
 { 212,2918 }, { 213,2918 }, { 214,2918 }, { 215,2918 }, { 216,2918 },
 { 217,2918 }, { 218,2918 }, { 219,2918 }, { 220,2918 }, { 221,2918 },
 { 222,2918 }, { 223,2918 }, { 224,2918 }, { 225,2918 }, { 226,2918 },
 { 227,2918 }, { 228,2918 }, { 229,2918 }, { 230,2918 }, { 231,2918 },
 { 232,2918 }, { 233,2918 }, { 234,2918 }, { 235,2918 }, { 236,2918 },
 { 237,2918 }, { 238,2918 }, { 239,2918 }, { 240,2918 }, { 241,2918 },
 { 242,2918 }, { 243,2918 }, { 244,2918 }, { 245,2918 }, { 246,2918 },
 { 247,2918 }, { 248,2918 }, { 249,2918 }, { 250,2918 }, { 251,2918 },
 { 252,2918 }, { 253,2918 }, { 254,2918 }, { 255,2918 }, { 256,2918 },

 {   0,  24 }, {   0,20539 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  24 }, {   0,20534 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   9,   0 }, {  10,   5 }, {   0,   0 }, {  12,   0 }, {  13,   5 },
 {   9,2913 }, {  10,2913 }, {   0,   0 }, {  12,2913 }, {  13,2913 },
 {   0,   0 }, {   0,  26 }, {   0,20518 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   9,   0 }, {  10,   0 }, {  32,   0 }, {  12,   0 },
 {  13,   0 }, {   0,   0 }, {   0,   0 }, {  32,2913 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  39,-9043 }, {  45,-9101 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  45,-8985 }, {   0,   0 }, {   0,   0 }, {  32,   0 },
 {   0,  26 }, {   0,20484 }, {   1,3168 }, {   2,3168 }, {   3,3168 },
 {   4,3168 }, {   5,3168 }, {   6,3168 }, {   7,3168 }, {   8,3168 },
 {   9,3168 }, {   0,   0 }, {  11,3168 }, {  12,3168 }, {   0,   0 },
 {  14,3168 }, {  15,3168 }, {  16,3168 }, {  17,3168 }, {  18,3168 },
 {  19,3168 }, {  20,3168 }, {  21,3168 }, {  22,3168 }, {  23,3168 },
 {  24,3168 }, {  25,3168 }, {  26,3168 }, {  27,3168 }, {  28,3168 },
 {  29,3168 }, {  30,3168 }, {  31,3168 }, {  32,3168 }, {  33,3168 },
 {  34,3168 }, {  35,3168 }, {  36,3168 }, {  37,3168 }, {  38,3168 },
 {  39,3168 }, {  40,3168 }, {  41,3168 }, {  42,3168 }, {  43,3168 },

 {  44,3168 }, {  45,3168 }, {  46,3168 }, {  47,3168 }, {  48,3168 },
 {  49,3168 }, {  50,3168 }, {  51,3168 }, {  52,3168 }, {  53,3168 },
 {  54,3168 }, {  55,3168 }, {  56,3168 }, {  57,3168 }, {  58,3168 },
 {  59,3168 }, {  60,3168 }, {  61,3168 }, {  62,3168 }, {  63,3168 },
 {  64,3168 }, {  65,3168 }, {  66,3168 }, {  67,3168 }, {  68,3168 },
 {  69,3168 }, {  70,3168 }, {  71,3168 }, {  72,3168 }, {  73,3168 },
 {  74,3168 }, {  75,3168 }, {  76,3168 }, {  77,3168 }, {  78,3168 },
 {  79,3168 }, {  80,3168 }, {  81,3168 }, {  82,3168 }, {  83,3168 },
 {  84,3168 }, {  85,3168 }, {  86,3168 }, {  87,3168 }, {  88,3168 },
 {  89,3168 }, {  90,3168 }, {  91,3168 }, {  92,3168 }, {  93,3168 },

 {  94,3168 }, {  95,3168 }, {  96,3168 }, {  97,3168 }, {  98,3168 },
 {  99,3168 }, { 100,3168 }, { 101,3168 }, { 102,3168 }, { 103,3168 },
 { 104,3168 }, { 105,3168 }, { 106,3168 }, { 107,3168 }, { 108,3168 },
 { 109,3168 }, { 110,3168 }, { 111,3168 }, { 112,3168 }, { 113,3168 },
 { 114,3168 }, { 115,3168 }, { 116,3168 }, { 117,3168 }, { 118,3168 },
 { 119,3168 }, { 120,3168 }, { 121,3168 }, { 122,3168 }, { 123,3168 },
 { 124,3168 }, { 125,3168 }, { 126,3168 }, { 127,3168 }, { 128,3168 },
 { 129,3168 }, { 130,3168 }, { 131,3168 }, { 132,3168 }, { 133,3168 },
 { 134,3168 }, { 135,3168 }, { 136,3168 }, { 137,3168 }, { 138,3168 },
 { 139,3168 }, { 140,3168 }, { 141,3168 }, { 142,3168 }, { 143,3168 },

 { 144,3168 }, { 145,3168 }, { 146,3168 }, { 147,3168 }, { 148,3168 },
 { 149,3168 }, { 150,3168 }, { 151,3168 }, { 152,3168 }, { 153,3168 },
 { 154,3168 }, { 155,3168 }, { 156,3168 }, { 157,3168 }, { 158,3168 },
 { 159,3168 }, { 160,3168 }, { 161,3168 }, { 162,3168 }, { 163,3168 },
 { 164,3168 }, { 165,3168 }, { 166,3168 }, { 167,3168 }, { 168,3168 },
 { 169,3168 }, { 170,3168 }, { 171,3168 }, { 172,3168 }, { 173,3168 },
 { 174,3168 }, { 175,3168 }, { 176,3168 }, { 177,3168 }, { 178,3168 },
 { 179,3168 }, { 180,3168 }, { 181,3168 }, { 182,3168 }, { 183,3168 },
 { 184,3168 }, { 185,3168 }, { 186,3168 }, { 187,3168 }, { 188,3168 },
 { 189,3168 }, { 190,3168 }, { 191,3168 }, { 192,3168 }, { 193,3168 },

 { 194,3168 }, { 195,3168 }, { 196,3168 }, { 197,3168 }, { 198,3168 },
 { 199,3168 }, { 200,3168 }, { 201,3168 }, { 202,3168 }, { 203,3168 },
 { 204,3168 }, { 205,3168 }, { 206,3168 }, { 207,3168 }, { 208,3168 },
 { 209,3168 }, { 210,3168 }, { 211,3168 }, { 212,3168 }, { 213,3168 },
 { 214,3168 }, { 215,3168 }, { 216,3168 }, { 217,3168 }, { 218,3168 },
 { 219,3168 }, { 220,3168 }, { 221,3168 }, { 222,3168 }, { 223,3168 },
 { 224,3168 }, { 225,3168 }, { 226,3168 }, { 227,3168 }, { 228,3168 },
 { 229,3168 }, { 230,3168 }, { 231,3168 }, { 232,3168 }, { 233,3168 },
 { 234,3168 }, { 235,3168 }, { 236,3168 }, { 237,3168 }, { 238,3168 },
 { 239,3168 }, { 240,3168 }, { 241,3168 }, { 242,3168 }, { 243,3168 },

 { 244,3168 }, { 245,3168 }, { 246,3168 }, { 247,3168 }, { 248,3168 },
 { 249,3168 }, { 250,3168 }, { 251,3168 }, { 252,3168 }, { 253,3168 },
 { 254,3168 }, { 255,3168 }, { 256,3168 }, {   0,  37 }, {   0,20226 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  37 }, {   0,20203 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,3168 }, {  49,3168 }, {  50,3168 },
 {  51,3168 }, {  52,3168 }, {  53,3168 }, {  54,3168 }, {  55,3168 },
 {  56,3168 }, {  57,3168 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,3168 },
 {  66,3168 }, {  67,3168 }, {  68,3168 }, {  69,3168 }, {  70,3168 },
 {  48,3168 }, {  49,3168 }, {  50,3168 }, {  51,3168 }, {  52,3168 },
 {  53,3168 }, {  54,3168 }, {  55,3168 }, {  56,3168 }, {  57,3168 },
 {   0,  44 }, {   0,20144 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  65,3168 }, {  66,3168 }, {  67,3168 },
 {  68,3168 }, {  69,3168 }, {  70,3168 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,3168 }, {  98,3168 }, {  99,3168 }, { 100,3168 },
 { 101,3168 }, { 102,3168 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-9812 }, {   0,   0 }, {  97,3168 },
 {  98,3168 }, {  99,3168 }, { 100,3168 }, { 101,3168 }, { 102,3168 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },

 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },
 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },
 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },
 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },
 {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },

 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },
 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },
 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },
 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,   0 },
 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },
 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },
 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },

 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },
 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },
 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },
 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },
 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },
 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },
 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },

 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },
 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },
 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },
 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },
 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },
 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },
 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },

 { 254,   0 }, { 255,   0 }, {   0,   1 }, {   0,19887 }, {   1,   0 },
 {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 },
 {   7,   0 }, {   8,   0 }, {   9,   0 }, {   0,   0 }, {  11,   0 },
 {  12,   0 }, {   0,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 },
 {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 },
 {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 },
 {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 },
 {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 },
 {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 },
 {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 },

 {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 },
 {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 },

 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 },
 { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },

 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },

 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },

 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 },
 {   0,   1 }, {   0,19629 }, {   1,-258 }, {   2,-258 }, {   3,-258 },
 {   4,-258 }, {   5,-258 }, {   6,-258 }, {   7,-258 }, {   8,-258 },
 {   9,-258 }, {   0,   0 }, {  11,-258 }, {  12,-258 }, {   0,   0 },
 {  14,-258 }, {  15,-258 }, {  16,-258 }, {  17,-258 }, {  18,-258 },
 {  19,-258 }, {  20,-258 }, {  21,-258 }, {  22,-258 }, {  23,-258 },
 {  24,-258 }, {  25,-258 }, {  26,-258 }, {  27,-258 }, {  28,-258 },
 {  29,-258 }, {  30,-258 }, {  31,-258 }, {  32,-258 }, {  33,   0 },
 {  34,-258 }, {  35,   0 }, {  36,-258 }, {  37,   0 }, {  38,   0 },

 {  39,-258 }, {  40,-258 }, {  41,-258 }, {  42,   0 }, {  43,   0 },
 {  44,-258 }, {  45,   0 }, {  46,-258 }, {  47,   0 }, {  48,-258 },
 {  49,-258 }, {  50,-258 }, {  51,-258 }, {  52,-258 }, {  53,-258 },
 {  54,-258 }, {  55,-258 }, {  56,-258 }, {  57,-258 }, {  58,-258 },
 {  59,-258 }, {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 },
 {  64,   0 }, {  65,-258 }, {  66,-258 }, {  67,-258 }, {  68,-258 },
 {  69,-258 }, {  70,-258 }, {  71,-258 }, {  72,-258 }, {  73,-258 },
 {  74,-258 }, {  75,-258 }, {  76,-258 }, {  77,-258 }, {  78,-258 },
 {  79,-258 }, {  80,-258 }, {  81,-258 }, {  82,-258 }, {  83,-258 },
 {  84,-258 }, {  85,-258 }, {  86,-258 }, {  87,-258 }, {  88,-258 },

 {  89,-258 }, {  90,-258 }, {  91,-258 }, {  92,-258 }, {  93,-258 },
 {  94,   0 }, {  95,-258 }, {  96,   0 }, {  97,-258 }, {  98,-258 },
 {  99,-258 }, { 100,-258 }, { 101,-258 }, { 102,-258 }, { 103,-258 },
 { 104,-258 }, { 105,-258 }, { 106,-258 }, { 107,-258 }, { 108,-258 },
 { 109,-258 }, { 110,-258 }, { 111,-258 }, { 112,-258 }, { 113,-258 },
 { 114,-258 }, { 115,-258 }, { 116,-258 }, { 117,-258 }, { 118,-258 },
 { 119,-258 }, { 120,-258 }, { 121,-258 }, { 122,-258 }, { 123,-258 },
 { 124,   0 }, { 125,-258 }, { 126,   0 }, { 127,-258 }, { 128,-258 },
 { 129,-258 }, { 130,-258 }, { 131,-258 }, { 132,-258 }, { 133,-258 },
 { 134,-258 }, { 135,-258 }, { 136,-258 }, { 137,-258 }, { 138,-258 },

 { 139,-258 }, { 140,-258 }, { 141,-258 }, { 142,-258 }, { 143,-258 },
 { 144,-258 }, { 145,-258 }, { 146,-258 }, { 147,-258 }, { 148,-258 },
 { 149,-258 }, { 150,-258 }, { 151,-258 }, { 152,-258 }, { 153,-258 },
 { 154,-258 }, { 155,-258 }, { 156,-258 }, { 157,-258 }, { 158,-258 },
 { 159,-258 }, { 160,-258 }, { 161,-258 }, { 162,-258 }, { 163,-258 },
 { 164,-258 }, { 165,-258 }, { 166,-258 }, { 167,-258 }, { 168,-258 },
 { 169,-258 }, { 170,-258 }, { 171,-258 }, { 172,-258 }, { 173,-258 },
 { 174,-258 }, { 175,-258 }, { 176,-258 }, { 177,-258 }, { 178,-258 },
 { 179,-258 }, { 180,-258 }, { 181,-258 }, { 182,-258 }, { 183,-258 },
 { 184,-258 }, { 185,-258 }, { 186,-258 }, { 187,-258 }, { 188,-258 },

 { 189,-258 }, { 190,-258 }, { 191,-258 }, { 192,-258 }, { 193,-258 },
 { 194,-258 }, { 195,-258 }, { 196,-258 }, { 197,-258 }, { 198,-258 },
 { 199,-258 }, { 200,-258 }, { 201,-258 }, { 202,-258 }, { 203,-258 },
 { 204,-258 }, { 205,-258 }, { 206,-258 }, { 207,-258 }, { 208,-258 },
 { 209,-258 }, { 210,-258 }, { 211,-258 }, { 212,-258 }, { 213,-258 },
 { 214,-258 }, { 215,-258 }, { 216,-258 }, { 217,-258 }, { 218,-258 },
 { 219,-258 }, { 220,-258 }, { 221,-258 }, { 222,-258 }, { 223,-258 },
 { 224,-258 }, { 225,-258 }, { 226,-258 }, { 227,-258 }, { 228,-258 },
 { 229,-258 }, { 230,-258 }, { 231,-258 }, { 232,-258 }, { 233,-258 },
 { 234,-258 }, { 235,-258 }, { 236,-258 }, { 237,-258 }, { 238,-258 },

 { 239,-258 }, { 240,-258 }, { 241,-258 }, { 242,-258 }, { 243,-258 },
 { 244,-258 }, { 245,-258 }, { 246,-258 }, { 247,-258 }, { 248,-258 },
 { 249,-258 }, { 250,-258 }, { 251,-258 }, { 252,-258 }, { 253,-258 },
 { 254,-258 }, { 255,-258 }, { 256,-258 }, {   0,   2 }, {   0,19371 },
 {   0,  72 }, {   0,19369 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  76 }, {   0,19347 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  33,   0 }, {   0,   0 }, {  35,   0 },
 {   0,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  42,   0 }, {  43,   0 }, {   0,   0 }, {  45,   0 },
 {   0,   0 }, {  47,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {   0,  74 },
 {   0,19305 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  69,-4444 }, {  48,  42 }, {  49,  42 }, {  50,  42 }, {  51,  42 },
 {  52,  42 }, {  53,  42 }, {  54,  42 }, {  55,  42 }, {  56,  42 },

 {  57,  42 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,   0 }, {   0,   0 },
 {  96,   0 }, {   0,   9 }, {   0,19273 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 101,-4444 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   9,   0 }, {  10,   0 }, {   0,   0 }, {  12,   0 },
 {  13,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, { 124,   0 }, {   0,   0 },
 { 126,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  32,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  39,-10320 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  45,-10313 }, {   0,   9 }, {   0,19226 },
 {   1,2553 }, {   2,2553 }, {   3,2553 }, {   4,2553 }, {   5,2553 },
 {   6,2553 }, {   7,2553 }, {   8,2553 }, {   9,2811 }, {  10,-3828 },
 {  11,2553 }, {  12,2811 }, {  13,-3828 }, {  14,2553 }, {  15,2553 },
 {  16,2553 }, {  17,2553 }, {  18,2553 }, {  19,2553 }, {  20,2553 },
 {  21,2553 }, {  22,2553 }, {  23,2553 }, {  24,2553 }, {  25,2553 },
 {  26,2553 }, {  27,2553 }, {  28,2553 }, {  29,2553 }, {  30,2553 },
 {  31,2553 }, {  32,2811 }, {  33,2553 }, {  34,2553 }, {  35,2553 },

 {  36,2553 }, {  37,2553 }, {  38,2553 }, {  39,2553 }, {  40,2553 },
 {  41,2553 }, {  42,2553 }, {  43,2553 }, {  44,2553 }, {  45,3069 },
 {  46,2553 }, {  47,2553 }, {  48,2553 }, {  49,2553 }, {  50,2553 },
 {  51,2553 }, {  52,2553 }, {  53,2553 }, {  54,2553 }, {  55,2553 },
 {  56,2553 }, {  57,2553 }, {  58,2553 }, {  59,2553 }, {  60,2553 },
 {  61,2553 }, {  62,2553 }, {  63,2553 }, {  64,2553 }, {  65,2553 },
 {  66,2553 }, {  67,2553 }, {  68,2553 }, {  69,2553 }, {  70,2553 },
 {  71,2553 }, {  72,2553 }, {  73,2553 }, {  74,2553 }, {  75,2553 },
 {  76,2553 }, {  77,2553 }, {  78,2553 }, {  79,2553 }, {  80,2553 },
 {  81,2553 }, {  82,2553 }, {  83,2553 }, {  84,2553 }, {  85,2553 },

 {  86,2553 }, {  87,2553 }, {  88,2553 }, {  89,2553 }, {  90,2553 },
 {  91,2553 }, {  92,2553 }, {  93,2553 }, {  94,2553 }, {  95,2553 },
 {  96,2553 }, {  97,2553 }, {  98,2553 }, {  99,2553 }, { 100,2553 },
 { 101,2553 }, { 102,2553 }, { 103,2553 }, { 104,2553 }, { 105,2553 },
 { 106,2553 }, { 107,2553 }, { 108,2553 }, { 109,2553 }, { 110,2553 },
 { 111,2553 }, { 112,2553 }, { 113,2553 }, { 114,2553 }, { 115,2553 },
 { 116,2553 }, { 117,2553 }, { 118,2553 }, { 119,2553 }, { 120,2553 },
 { 121,2553 }, { 122,2553 }, { 123,2553 }, { 124,2553 }, { 125,2553 },
 { 126,2553 }, { 127,2553 }, { 128,2553 }, { 129,2553 }, { 130,2553 },
 { 131,2553 }, { 132,2553 }, { 133,2553 }, { 134,2553 }, { 135,2553 },

 { 136,2553 }, { 137,2553 }, { 138,2553 }, { 139,2553 }, { 140,2553 },
 { 141,2553 }, { 142,2553 }, { 143,2553 }, { 144,2553 }, { 145,2553 },
 { 146,2553 }, { 147,2553 }, { 148,2553 }, { 149,2553 }, { 150,2553 },
 { 151,2553 }, { 152,2553 }, { 153,2553 }, { 154,2553 }, { 155,2553 },
 { 156,2553 }, { 157,2553 }, { 158,2553 }, { 159,2553 }, { 160,2553 },
 { 161,2553 }, { 162,2553 }, { 163,2553 }, { 164,2553 }, { 165,2553 },
 { 166,2553 }, { 167,2553 }, { 168,2553 }, { 169,2553 }, { 170,2553 },
 { 171,2553 }, { 172,2553 }, { 173,2553 }, { 174,2553 }, { 175,2553 },
 { 176,2553 }, { 177,2553 }, { 178,2553 }, { 179,2553 }, { 180,2553 },
 { 181,2553 }, { 182,2553 }, { 183,2553 }, { 184,2553 }, { 185,2553 },

 { 186,2553 }, { 187,2553 }, { 188,2553 }, { 189,2553 }, { 190,2553 },
 { 191,2553 }, { 192,2553 }, { 193,2553 }, { 194,2553 }, { 195,2553 },
 { 196,2553 }, { 197,2553 }, { 198,2553 }, { 199,2553 }, { 200,2553 },
 { 201,2553 }, { 202,2553 }, { 203,2553 }, { 204,2553 }, { 205,2553 },
 { 206,2553 }, { 207,2553 }, { 208,2553 }, { 209,2553 }, { 210,2553 },
 { 211,2553 }, { 212,2553 }, { 213,2553 }, { 214,2553 }, { 215,2553 },
 { 216,2553 }, { 217,2553 }, { 218,2553 }, { 219,2553 }, { 220,2553 },
 { 221,2553 }, { 222,2553 }, { 223,2553 }, { 224,2553 }, { 225,2553 },
 { 226,2553 }, { 227,2553 }, { 228,2553 }, { 229,2553 }, { 230,2553 },
 { 231,2553 }, { 232,2553 }, { 233,2553 }, { 234,2553 }, { 235,2553 },

 { 236,2553 }, { 237,2553 }, { 238,2553 }, { 239,2553 }, { 240,2553 },
 { 241,2553 }, { 242,2553 }, { 243,2553 }, { 244,2553 }, { 245,2553 },
 { 246,2553 }, { 247,2553 }, { 248,2553 }, { 249,2553 }, { 250,2553 },
 { 251,2553 }, { 252,2553 }, { 253,2553 }, { 254,2553 }, { 255,2553 },
 { 256,2553 }, {   0,   3 }, {   0,18968 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  16 }, {   0,18961 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,   0 }, {  10,   0 },
 {   0,   0 }, {  12,   0 }, {  13,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  33,   0 }, {   0,   0 }, {  35,   0 }, {   0,   0 }, {  37,   0 },
 {  38,   0 }, {  32,   0 }, {   0,   0 }, {   0,   0 }, {  42,   0 },
 {  43,   0 }, {   0,   0 }, {  45,   0 }, {  39,-10623 }, {  47,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-10618 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,   0 }, {   0,   0 }, {  96,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 124,   0 }, {   0,   0 }, { 126,   0 }, {   0,  16 },

 {   0,18840 }, {   1,3199 }, {   2,3199 }, {   3,3199 }, {   4,3199 },
 {   5,3199 }, {   6,3199 }, {   7,3199 }, {   8,3199 }, {   9,3457 },
 {  10,-3260 }, {  11,3199 }, {  12,3457 }, {  13,-3260 }, {  14,3199 },
 {  15,3199 }, {  16,3199 }, {  17,3199 }, {  18,3199 }, {  19,3199 },
 {  20,3199 }, {  21,3199 }, {  22,3199 }, {  23,3199 }, {  24,3199 },
 {  25,3199 }, {  26,3199 }, {  27,3199 }, {  28,3199 }, {  29,3199 },
 {  30,3199 }, {  31,3199 }, {  32,3457 }, {  33,3199 }, {  34,3199 },
 {  35,3199 }, {  36,3199 }, {  37,3199 }, {  38,3199 }, {  39,3199 },
 {  40,3199 }, {  41,3199 }, {  42,3199 }, {  43,3199 }, {  44,3199 },
 {  45,3715 }, {  46,3199 }, {  47,3199 }, {  48,3199 }, {  49,3199 },

 {  50,3199 }, {  51,3199 }, {  52,3199 }, {  53,3199 }, {  54,3199 },
 {  55,3199 }, {  56,3199 }, {  57,3199 }, {  58,3199 }, {  59,3199 },
 {  60,3199 }, {  61,3199 }, {  62,3199 }, {  63,3199 }, {  64,3199 },
 {  65,3199 }, {  66,3199 }, {  67,3199 }, {  68,3199 }, {  69,3199 },
 {  70,3199 }, {  71,3199 }, {  72,3199 }, {  73,3199 }, {  74,3199 },
 {  75,3199 }, {  76,3199 }, {  77,3199 }, {  78,3199 }, {  79,3199 },
 {  80,3199 }, {  81,3199 }, {  82,3199 }, {  83,3199 }, {  84,3199 },
 {  85,3199 }, {  86,3199 }, {  87,3199 }, {  88,3199 }, {  89,3199 },
 {  90,3199 }, {  91,3199 }, {  92,3199 }, {  93,3199 }, {  94,3199 },
 {  95,3199 }, {  96,3199 }, {  97,3199 }, {  98,3199 }, {  99,3199 },

 { 100,3199 }, { 101,3199 }, { 102,3199 }, { 103,3199 }, { 104,3199 },
 { 105,3199 }, { 106,3199 }, { 107,3199 }, { 108,3199 }, { 109,3199 },
 { 110,3199 }, { 111,3199 }, { 112,3199 }, { 113,3199 }, { 114,3199 },
 { 115,3199 }, { 116,3199 }, { 117,3199 }, { 118,3199 }, { 119,3199 },
 { 120,3199 }, { 121,3199 }, { 122,3199 }, { 123,3199 }, { 124,3199 },
 { 125,3199 }, { 126,3199 }, { 127,3199 }, { 128,3199 }, { 129,3199 },
 { 130,3199 }, { 131,3199 }, { 132,3199 }, { 133,3199 }, { 134,3199 },
 { 135,3199 }, { 136,3199 }, { 137,3199 }, { 138,3199 }, { 139,3199 },
 { 140,3199 }, { 141,3199 }, { 142,3199 }, { 143,3199 }, { 144,3199 },
 { 145,3199 }, { 146,3199 }, { 147,3199 }, { 148,3199 }, { 149,3199 },

 { 150,3199 }, { 151,3199 }, { 152,3199 }, { 153,3199 }, { 154,3199 },
 { 155,3199 }, { 156,3199 }, { 157,3199 }, { 158,3199 }, { 159,3199 },
 { 160,3199 }, { 161,3199 }, { 162,3199 }, { 163,3199 }, { 164,3199 },
 { 165,3199 }, { 166,3199 }, { 167,3199 }, { 168,3199 }, { 169,3199 },
 { 170,3199 }, { 171,3199 }, { 172,3199 }, { 173,3199 }, { 174,3199 },
 { 175,3199 }, { 176,3199 }, { 177,3199 }, { 178,3199 }, { 179,3199 },
 { 180,3199 }, { 181,3199 }, { 182,3199 }, { 183,3199 }, { 184,3199 },
 { 185,3199 }, { 186,3199 }, { 187,3199 }, { 188,3199 }, { 189,3199 },
 { 190,3199 }, { 191,3199 }, { 192,3199 }, { 193,3199 }, { 194,3199 },
 { 195,3199 }, { 196,3199 }, { 197,3199 }, { 198,3199 }, { 199,3199 },

 { 200,3199 }, { 201,3199 }, { 202,3199 }, { 203,3199 }, { 204,3199 },
 { 205,3199 }, { 206,3199 }, { 207,3199 }, { 208,3199 }, { 209,3199 },
 { 210,3199 }, { 211,3199 }, { 212,3199 }, { 213,3199 }, { 214,3199 },
 { 215,3199 }, { 216,3199 }, { 217,3199 }, { 218,3199 }, { 219,3199 },
 { 220,3199 }, { 221,3199 }, { 222,3199 }, { 223,3199 }, { 224,3199 },
 { 225,3199 }, { 226,3199 }, { 227,3199 }, { 228,3199 }, { 229,3199 },
 { 230,3199 }, { 231,3199 }, { 232,3199 }, { 233,3199 }, { 234,3199 },
 { 235,3199 }, { 236,3199 }, { 237,3199 }, { 238,3199 }, { 239,3199 },
 { 240,3199 }, { 241,3199 }, { 242,3199 }, { 243,3199 }, { 244,3199 },
 { 245,3199 }, { 246,3199 }, { 247,3199 }, { 248,3199 }, { 249,3199 },

 { 250,3199 }, { 251,3199 }, { 252,3199 }, { 253,3199 }, { 254,3199 },
 { 255,3199 }, { 256,3199 }, {   0,  22 }, {   0,18582 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   9,   0 }, {  10,   0 }, {   0,   0 },
 {  12,   0 }, {  13,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  32,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  39,-10995 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-10993 }, {   0,  22 },
 {   0,18535 }, {   1,3926 }, {   2,3926 }, {   3,3926 }, {   4,3926 },
 {   5,3926 }, {   6,3926 }, {   7,3926 }, {   8,3926 }, {   9,4184 },
 {  10,-3255 }, {  11,3926 }, {  12,4184 }, {  13,-3255 }, {  14,3926 },
 {  15,3926 }, {  16,3926 }, {  17,3926 }, {  18,3926 }, {  19,3926 },
 {  20,3926 }, {  21,3926 }, {  22,3926 }, {  23,3926 }, {  24,3926 },
 {  25,3926 }, {  26,3926 }, {  27,3926 }, {  28,3926 }, {  29,3926 },
 {  30,3926 }, {  31,3926 }, {  32,4184 }, {  33,3926 }, {  34,3926 },
 {  35,3926 }, {  36,3926 }, {  37,3926 }, {  38,3926 }, {  39,3926 },
 {  40,3926 }, {  41,3926 }, {  42,3926 }, {  43,3926 }, {  44,3926 },

 {  45,4442 }, {  46,3926 }, {  47,3926 }, {  48,3926 }, {  49,3926 },
 {  50,3926 }, {  51,3926 }, {  52,3926 }, {  53,3926 }, {  54,3926 },
 {  55,3926 }, {  56,3926 }, {  57,3926 }, {  58,3926 }, {  59,3926 },
 {  60,3926 }, {  61,3926 }, {  62,3926 }, {  63,3926 }, {  64,3926 },
 {  65,3926 }, {  66,3926 }, {  67,3926 }, {  68,3926 }, {  69,3926 },
 {  70,3926 }, {  71,3926 }, {  72,3926 }, {  73,3926 }, {  74,3926 },
 {  75,3926 }, {  76,3926 }, {  77,3926 }, {  78,3926 }, {  79,3926 },
 {  80,3926 }, {  81,3926 }, {  82,3926 }, {  83,3926 }, {  84,3926 },
 {  85,3926 }, {  86,3926 }, {  87,3926 }, {  88,3926 }, {  89,3926 },
 {  90,3926 }, {  91,3926 }, {  92,3926 }, {  93,3926 }, {  94,3926 },

 {  95,3926 }, {  96,3926 }, {  97,3926 }, {  98,3926 }, {  99,3926 },
 { 100,3926 }, { 101,3926 }, { 102,3926 }, { 103,3926 }, { 104,3926 },
 { 105,3926 }, { 106,3926 }, { 107,3926 }, { 108,3926 }, { 109,3926 },
 { 110,3926 }, { 111,3926 }, { 112,3926 }, { 113,3926 }, { 114,3926 },
 { 115,3926 }, { 116,3926 }, { 117,3926 }, { 118,3926 }, { 119,3926 },
 { 120,3926 }, { 121,3926 }, { 122,3926 }, { 123,3926 }, { 124,3926 },
 { 125,3926 }, { 126,3926 }, { 127,3926 }, { 128,3926 }, { 129,3926 },
 { 130,3926 }, { 131,3926 }, { 132,3926 }, { 133,3926 }, { 134,3926 },
 { 135,3926 }, { 136,3926 }, { 137,3926 }, { 138,3926 }, { 139,3926 },
 { 140,3926 }, { 141,3926 }, { 142,3926 }, { 143,3926 }, { 144,3926 },

 { 145,3926 }, { 146,3926 }, { 147,3926 }, { 148,3926 }, { 149,3926 },
 { 150,3926 }, { 151,3926 }, { 152,3926 }, { 153,3926 }, { 154,3926 },
 { 155,3926 }, { 156,3926 }, { 157,3926 }, { 158,3926 }, { 159,3926 },
 { 160,3926 }, { 161,3926 }, { 162,3926 }, { 163,3926 }, { 164,3926 },
 { 165,3926 }, { 166,3926 }, { 167,3926 }, { 168,3926 }, { 169,3926 },
 { 170,3926 }, { 171,3926 }, { 172,3926 }, { 173,3926 }, { 174,3926 },
 { 175,3926 }, { 176,3926 }, { 177,3926 }, { 178,3926 }, { 179,3926 },
 { 180,3926 }, { 181,3926 }, { 182,3926 }, { 183,3926 }, { 184,3926 },
 { 185,3926 }, { 186,3926 }, { 187,3926 }, { 188,3926 }, { 189,3926 },
 { 190,3926 }, { 191,3926 }, { 192,3926 }, { 193,3926 }, { 194,3926 },

 { 195,3926 }, { 196,3926 }, { 197,3926 }, { 198,3926 }, { 199,3926 },
 { 200,3926 }, { 201,3926 }, { 202,3926 }, { 203,3926 }, { 204,3926 },
 { 205,3926 }, { 206,3926 }, { 207,3926 }, { 208,3926 }, { 209,3926 },
 { 210,3926 }, { 211,3926 }, { 212,3926 }, { 213,3926 }, { 214,3926 },
 { 215,3926 }, { 216,3926 }, { 217,3926 }, { 218,3926 }, { 219,3926 },
 { 220,3926 }, { 221,3926 }, { 222,3926 }, { 223,3926 }, { 224,3926 },
 { 225,3926 }, { 226,3926 }, { 227,3926 }, { 228,3926 }, { 229,3926 },
 { 230,3926 }, { 231,3926 }, { 232,3926 }, { 233,3926 }, { 234,3926 },
 { 235,3926 }, { 236,3926 }, { 237,3926 }, { 238,3926 }, { 239,3926 },
 { 240,3926 }, { 241,3926 }, { 242,3926 }, { 243,3926 }, { 244,3926 },

 { 245,3926 }, { 246,3926 }, { 247,3926 }, { 248,3926 }, { 249,3926 },
 { 250,3926 }, { 251,3926 }, { 252,3926 }, { 253,3926 }, { 254,3926 },
 { 255,3926 }, { 256,3926 }, {   0,  39 }, {   0,18277 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  37 }, {   0,18269 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  37 }, {   0,18246 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,-11237 }, {  49,-11237 }, {  50,-11237 }, {  51,-11237 },
 {  52,-11237 }, {  53,-11237 }, {  54,-11237 }, {  55,-11237 }, {  48,4434 },
 {  49,4434 }, {  50,4434 }, {  51,4434 }, {  52,4434 }, {  53,4434 },
 {  54,4434 }, {  55,4434 }, {  56,4434 }, {  57,4434 }, {   0,   0 },
 {   0,   0 }, {   0,  40 }, {   0,18208 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,4434 }, {  66,4434 }, {  67,4434 }, {  68,4434 },
 {  69,4434 }, {  70,4434 }, {  48,4434 }, {  49,4434 }, {  50,4434 },
 {  51,4434 }, {  52,4434 }, {  53,4434 }, {  54,4434 }, {  55,4434 },

 {  56,4434 }, {  57,4434 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,4434 },
 {  66,4434 }, {  67,4434 }, {  68,4434 }, {  69,4434 }, {  70,4434 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,4434 }, {  98,4434 },
 {  99,4434 }, { 100,4434 }, { 101,4434 }, { 102,4434 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,-11300 }, {  49,-11300 }, {  50,-11300 }, {  51,-11300 }, {  52,-11300 },
 {  53,-11300 }, {  54,-11300 }, {  55,-11300 }, {  56,-11300 }, {  57,-11300 },
 {   0,   0 }, {  97,4434 }, {  98,4434 }, {  99,4434 }, { 100,4434 },
 { 101,4434 }, { 102,4434 }, {  65,-11300 }, {  66,-11300 }, {  67,-11300 },

 {  68,-11300 }, {  69,-11300 }, {  70,-11300 }, {   0,  47 }, {   0,18136 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,-11300 },
 {  98,-11300 }, {  99,-11300 }, { 100,-11300 }, { 101,-11300 }, { 102,-11300 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-11543 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },
 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,   0 },

 {   0,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },
 { 121,   0 }, { 122,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },

 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },
 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },

 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },
 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },

 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 {   0,  53 }, {   0,17879 }, {   1,   0 }, {   2,   0 }, {   3,   0 },
 {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 },
 {   9,   0 }, {   0,   0 }, {  11,   0 }, {  12,   0 }, {   0,   0 },
 {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 },
 {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 },
 {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 },
 {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 },
 {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 },

 {  39,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 },
 {  44,   0 }, {  45,   0 }, {  46,   0 }, {  47,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 },
 {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 },
 {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },
 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },
 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },
 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },

 {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 },
 {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },
 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },
 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },
 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },
 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 },
 { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 },
 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },
 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },

 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },
 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },
 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },
 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },
 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },
 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },
 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },

 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },
 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },
 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },
 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },
 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },
 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },
 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },

 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },
 { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  24 }, {   0,17621 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,   0 }, {  10,   0 },
 {   0,   0 }, {  12,   0 }, {  13,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  32,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-11956 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-11898 },
 {   0,  24 }, {   0,17574 }, {   1,4124 }, {   2,4124 }, {   3,4124 },
 {   4,4124 }, {   5,4124 }, {   6,4124 }, {   7,4124 }, {   8,4124 },
 {   9,4382 }, {  10,-2960 }, {  11,4124 }, {  12,4382 }, {  13,-2960 },
 {  14,4124 }, {  15,4124 }, {  16,4124 }, {  17,4124 }, {  18,4124 },
 {  19,4124 }, {  20,4124 }, {  21,4124 }, {  22,4124 }, {  23,4124 },
 {  24,4124 }, {  25,4124 }, {  26,4124 }, {  27,4124 }, {  28,4124 },
 {  29,4124 }, {  30,4124 }, {  31,4124 }, {  32,4382 }, {  33,4124 },

 {  34,4124 }, {  35,4124 }, {  36,4124 }, {  37,4124 }, {  38,4124 },
 {  39,4124 }, {  40,4124 }, {  41,4124 }, {  42,4124 }, {  43,4124 },
 {  44,4124 }, {  45,4640 }, {  46,4124 }, {  47,4124 }, {  48,4124 },
 {  49,4124 }, {  50,4124 }, {  51,4124 }, {  52,4124 }, {  53,4124 },
 {  54,4124 }, {  55,4124 }, {  56,4124 }, {  57,4124 }, {  58,4124 },
 {  59,4124 }, {  60,4124 }, {  61,4124 }, {  62,4124 }, {  63,4124 },
 {  64,4124 }, {  65,4124 }, {  66,4124 }, {  67,4124 }, {  68,4124 },
 {  69,4124 }, {  70,4124 }, {  71,4124 }, {  72,4124 }, {  73,4124 },
 {  74,4124 }, {  75,4124 }, {  76,4124 }, {  77,4124 }, {  78,4124 },
 {  79,4124 }, {  80,4124 }, {  81,4124 }, {  82,4124 }, {  83,4124 },

 {  84,4124 }, {  85,4124 }, {  86,4124 }, {  87,4124 }, {  88,4124 },
 {  89,4124 }, {  90,4124 }, {  91,4124 }, {  92,4124 }, {  93,4124 },
 {  94,4124 }, {  95,4124 }, {  96,4124 }, {  97,4124 }, {  98,4124 },
 {  99,4124 }, { 100,4124 }, { 101,4124 }, { 102,4124 }, { 103,4124 },
 { 104,4124 }, { 105,4124 }, { 106,4124 }, { 107,4124 }, { 108,4124 },
 { 109,4124 }, { 110,4124 }, { 111,4124 }, { 112,4124 }, { 113,4124 },
 { 114,4124 }, { 115,4124 }, { 116,4124 }, { 117,4124 }, { 118,4124 },
 { 119,4124 }, { 120,4124 }, { 121,4124 }, { 122,4124 }, { 123,4124 },
 { 124,4124 }, { 125,4124 }, { 126,4124 }, { 127,4124 }, { 128,4124 },
 { 129,4124 }, { 130,4124 }, { 131,4124 }, { 132,4124 }, { 133,4124 },

 { 134,4124 }, { 135,4124 }, { 136,4124 }, { 137,4124 }, { 138,4124 },
 { 139,4124 }, { 140,4124 }, { 141,4124 }, { 142,4124 }, { 143,4124 },
 { 144,4124 }, { 145,4124 }, { 146,4124 }, { 147,4124 }, { 148,4124 },
 { 149,4124 }, { 150,4124 }, { 151,4124 }, { 152,4124 }, { 153,4124 },
 { 154,4124 }, { 155,4124 }, { 156,4124 }, { 157,4124 }, { 158,4124 },
 { 159,4124 }, { 160,4124 }, { 161,4124 }, { 162,4124 }, { 163,4124 },
 { 164,4124 }, { 165,4124 }, { 166,4124 }, { 167,4124 }, { 168,4124 },
 { 169,4124 }, { 170,4124 }, { 171,4124 }, { 172,4124 }, { 173,4124 },
 { 174,4124 }, { 175,4124 }, { 176,4124 }, { 177,4124 }, { 178,4124 },
 { 179,4124 }, { 180,4124 }, { 181,4124 }, { 182,4124 }, { 183,4124 },

 { 184,4124 }, { 185,4124 }, { 186,4124 }, { 187,4124 }, { 188,4124 },
 { 189,4124 }, { 190,4124 }, { 191,4124 }, { 192,4124 }, { 193,4124 },
 { 194,4124 }, { 195,4124 }, { 196,4124 }, { 197,4124 }, { 198,4124 },
 { 199,4124 }, { 200,4124 }, { 201,4124 }, { 202,4124 }, { 203,4124 },
 { 204,4124 }, { 205,4124 }, { 206,4124 }, { 207,4124 }, { 208,4124 },
 { 209,4124 }, { 210,4124 }, { 211,4124 }, { 212,4124 }, { 213,4124 },
 { 214,4124 }, { 215,4124 }, { 216,4124 }, { 217,4124 }, { 218,4124 },
 { 219,4124 }, { 220,4124 }, { 221,4124 }, { 222,4124 }, { 223,4124 },
 { 224,4124 }, { 225,4124 }, { 226,4124 }, { 227,4124 }, { 228,4124 },
 { 229,4124 }, { 230,4124 }, { 231,4124 }, { 232,4124 }, { 233,4124 },

 { 234,4124 }, { 235,4124 }, { 236,4124 }, { 237,4124 }, { 238,4124 },
 { 239,4124 }, { 240,4124 }, { 241,4124 }, { 242,4124 }, { 243,4124 },
 { 244,4124 }, { 245,4124 }, { 246,4124 }, { 247,4124 }, { 248,4124 },
 { 249,4124 }, { 250,4124 }, { 251,4124 }, { 252,4124 }, { 253,4124 },
 { 254,4124 }, { 255,4124 }, { 256,4124 }, {   0,  26 }, {   0,17316 },
 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },
 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 }, {   0,   0 },
 {  11,   0 }, {  12,   0 }, {   0,   0 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },
 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },

 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },
 {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 },
 {  36,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 },
 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 },
 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },
 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },

 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },
 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },
 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },

 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },
 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },

 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },
 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },

 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 { 256,   0 }, {   0,  37 }, {   0,17058 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  37 },
 {   0,17035 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,4382 }, {  49,4382 }, {  50,4382 }, {  51,4382 }, {  52,4382 },
 {  53,4382 }, {  54,4382 }, {  55,4382 }, {  56,4382 }, {  57,4382 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,4382 }, {  66,4382 }, {  67,4382 },

 {  68,4382 }, {  69,4382 }, {  70,4382 }, {  48,4382 }, {  49,4382 },
 {  50,4382 }, {  51,4382 }, {  52,4382 }, {  53,4382 }, {  54,4382 },
 {  55,4382 }, {  56,4382 }, {  57,4382 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,4382 }, {  66,4382 }, {  67,4382 }, {  68,4382 }, {  69,4382 },
 {  70,4382 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,4382 },
 {  98,4382 }, {  99,4382 }, { 100,4382 }, { 101,4382 }, { 102,4382 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  97,4382 }, {  98,4382 }, {  99,4382 },
 { 100,4382 }, { 101,4382 }, { 102,4382 }, {   0,   9 }, {   0,16931 },
 {   1,4382 }, {   2,4382 }, {   3,4382 }, {   4,4382 }, {   5,4382 },
 {   6,4382 }, {   7,4382 }, {   8,4382 }, {   9,4640 }, {  10,4898 },
 {  11,4382 }, {  12,4640 }, {  13,4898 }, {  14,4382 }, {  15,4382 },
 {  16,4382 }, {  17,4382 }, {  18,4382 }, {  19,4382 }, {  20,4382 },
 {  21,4382 }, {  22,4382 }, {  23,4382 }, {  24,4382 }, {  25,4382 },
 {  26,4382 }, {  27,4382 }, {  28,4382 }, {  29,4382 }, {  30,4382 },
 {  31,4382 }, {  32,4640 }, {  33,4382 }, {  34,4382 }, {  35,4382 },
 {  36,4382 }, {  37,4382 }, {  38,4382 }, {  39,4382 }, {  40,4382 },

 {  41,4382 }, {  42,4382 }, {  43,4382 }, {  44,4382 }, {  45,4945 },
 {  46,4382 }, {  47,4382 }, {  48,4382 }, {  49,4382 }, {  50,4382 },
 {  51,4382 }, {  52,4382 }, {  53,4382 }, {  54,4382 }, {  55,4382 },
 {  56,4382 }, {  57,4382 }, {  58,4382 }, {  59,4382 }, {  60,4382 },
 {  61,4382 }, {  62,4382 }, {  63,4382 }, {  64,4382 }, {  65,4382 },
 {  66,4382 }, {  67,4382 }, {  68,4382 }, {  69,4382 }, {  70,4382 },
 {  71,4382 }, {  72,4382 }, {  73,4382 }, {  74,4382 }, {  75,4382 },
 {  76,4382 }, {  77,4382 }, {  78,4382 }, {  79,4382 }, {  80,4382 },
 {  81,4382 }, {  82,4382 }, {  83,4382 }, {  84,4382 }, {  85,4382 },
 {  86,4382 }, {  87,4382 }, {  88,4382 }, {  89,4382 }, {  90,4382 },

 {  91,4382 }, {  92,4382 }, {  93,4382 }, {  94,4382 }, {  95,4382 },
 {  96,4382 }, {  97,4382 }, {  98,4382 }, {  99,4382 }, { 100,4382 },
 { 101,4382 }, { 102,4382 }, { 103,4382 }, { 104,4382 }, { 105,4382 },
 { 106,4382 }, { 107,4382 }, { 108,4382 }, { 109,4382 }, { 110,4382 },
 { 111,4382 }, { 112,4382 }, { 113,4382 }, { 114,4382 }, { 115,4382 },
 { 116,4382 }, { 117,4382 }, { 118,4382 }, { 119,4382 }, { 120,4382 },
 { 121,4382 }, { 122,4382 }, { 123,4382 }, { 124,4382 }, { 125,4382 },
 { 126,4382 }, { 127,4382 }, { 128,4382 }, { 129,4382 }, { 130,4382 },
 { 131,4382 }, { 132,4382 }, { 133,4382 }, { 134,4382 }, { 135,4382 },
 { 136,4382 }, { 137,4382 }, { 138,4382 }, { 139,4382 }, { 140,4382 },

 { 141,4382 }, { 142,4382 }, { 143,4382 }, { 144,4382 }, { 145,4382 },
 { 146,4382 }, { 147,4382 }, { 148,4382 }, { 149,4382 }, { 150,4382 },
 { 151,4382 }, { 152,4382 }, { 153,4382 }, { 154,4382 }, { 155,4382 },
 { 156,4382 }, { 157,4382 }, { 158,4382 }, { 159,4382 }, { 160,4382 },
 { 161,4382 }, { 162,4382 }, { 163,4382 }, { 164,4382 }, { 165,4382 },
 { 166,4382 }, { 167,4382 }, { 168,4382 }, { 169,4382 }, { 170,4382 },
 { 171,4382 }, { 172,4382 }, { 173,4382 }, { 174,4382 }, { 175,4382 },
 { 176,4382 }, { 177,4382 }, { 178,4382 }, { 179,4382 }, { 180,4382 },
 { 181,4382 }, { 182,4382 }, { 183,4382 }, { 184,4382 }, { 185,4382 },
 { 186,4382 }, { 187,4382 }, { 188,4382 }, { 189,4382 }, { 190,4382 },

 { 191,4382 }, { 192,4382 }, { 193,4382 }, { 194,4382 }, { 195,4382 },
 { 196,4382 }, { 197,4382 }, { 198,4382 }, { 199,4382 }, { 200,4382 },
 { 201,4382 }, { 202,4382 }, { 203,4382 }, { 204,4382 }, { 205,4382 },
 { 206,4382 }, { 207,4382 }, { 208,4382 }, { 209,4382 }, { 210,4382 },
 { 211,4382 }, { 212,4382 }, { 213,4382 }, { 214,4382 }, { 215,4382 },
 { 216,4382 }, { 217,4382 }, { 218,4382 }, { 219,4382 }, { 220,4382 },
 { 221,4382 }, { 222,4382 }, { 223,4382 }, { 224,4382 }, { 225,4382 },
 { 226,4382 }, { 227,4382 }, { 228,4382 }, { 229,4382 }, { 230,4382 },
 { 231,4382 }, { 232,4382 }, { 233,4382 }, { 234,4382 }, { 235,4382 },
 { 236,4382 }, { 237,4382 }, { 238,4382 }, { 239,4382 }, { 240,4382 },

 { 241,4382 }, { 242,4382 }, { 243,4382 }, { 244,4382 }, { 245,4382 },
 { 246,4382 }, { 247,4382 }, { 248,4382 }, { 249,4382 }, { 250,4382 },
 { 251,4382 }, { 252,4382 }, { 253,4382 }, { 254,4382 }, { 255,4382 },
 { 256,4382 }, {   0,   9 }, {   0,16673 }, {   1,   0 }, {   2,   0 },
 {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 },
 {   8,   0 }, {   9, 258 }, {  10,-6381 }, {  11,   0 }, {  12, 258 },
 {  13,-6381 }, {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 },
 {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 },
 {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 },
 {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32, 258 },

 {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 },
 {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 },
 {  43,   0 }, {  44,   0 }, {  45, 516 }, {  46,   0 }, {  47,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },

 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 },
 {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },

 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },

 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },

 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,   9 },
 {   0,16415 }, {   1,-258 }, {   2,-258 }, {   3,-258 }, {   4,-258 },
 {   5,-258 }, {   6,-258 }, {   7,-258 }, {   8,-258 }, {   9,   0 },
 {  10,-6639 }, {  11,-258 }, {  12,   0 }, {  13,-6639 }, {  14,-258 },
 {  15,-258 }, {  16,-258 }, {  17,-258 }, {  18,-258 }, {  19,-258 },
 {  20,-258 }, {  21,-258 }, {  22,-258 }, {  23,-258 }, {  24,-258 },

 {  25,-258 }, {  26,-258 }, {  27,-258 }, {  28,-258 }, {  29,-258 },
 {  30,-258 }, {  31,-258 }, {  32,   0 }, {  33,-258 }, {  34,-258 },
 {  35,-258 }, {  36,-258 }, {  37,-258 }, {  38,-258 }, {  39,-258 },
 {  40,-258 }, {  41,-258 }, {  42,-258 }, {  43,-258 }, {  44,-258 },
 {  45, 258 }, {  46,-258 }, {  47,-258 }, {  48,-258 }, {  49,-258 },
 {  50,-258 }, {  51,-258 }, {  52,-258 }, {  53,-258 }, {  54,-258 },
 {  55,-258 }, {  56,-258 }, {  57,-258 }, {  58,-258 }, {  59,-258 },
 {  60,-258 }, {  61,-258 }, {  62,-258 }, {  63,-258 }, {  64,-258 },
 {  65,-258 }, {  66,-258 }, {  67,-258 }, {  68,-258 }, {  69,-258 },
 {  70,-258 }, {  71,-258 }, {  72,-258 }, {  73,-258 }, {  74,-258 },

 {  75,-258 }, {  76,-258 }, {  77,-258 }, {  78,-258 }, {  79,-258 },
 {  80,-258 }, {  81,-258 }, {  82,-258 }, {  83,-258 }, {  84,-258 },
 {  85,-258 }, {  86,-258 }, {  87,-258 }, {  88,-258 }, {  89,-258 },
 {  90,-258 }, {  91,-258 }, {  92,-258 }, {  93,-258 }, {  94,-258 },
 {  95,-258 }, {  96,-258 }, {  97,-258 }, {  98,-258 }, {  99,-258 },
 { 100,-258 }, { 101,-258 }, { 102,-258 }, { 103,-258 }, { 104,-258 },
 { 105,-258 }, { 106,-258 }, { 107,-258 }, { 108,-258 }, { 109,-258 },
 { 110,-258 }, { 111,-258 }, { 112,-258 }, { 113,-258 }, { 114,-258 },
 { 115,-258 }, { 116,-258 }, { 117,-258 }, { 118,-258 }, { 119,-258 },
 { 120,-258 }, { 121,-258 }, { 122,-258 }, { 123,-258 }, { 124,-258 },

 { 125,-258 }, { 126,-258 }, { 127,-258 }, { 128,-258 }, { 129,-258 },
 { 130,-258 }, { 131,-258 }, { 132,-258 }, { 133,-258 }, { 134,-258 },
 { 135,-258 }, { 136,-258 }, { 137,-258 }, { 138,-258 }, { 139,-258 },
 { 140,-258 }, { 141,-258 }, { 142,-258 }, { 143,-258 }, { 144,-258 },
 { 145,-258 }, { 146,-258 }, { 147,-258 }, { 148,-258 }, { 149,-258 },
 { 150,-258 }, { 151,-258 }, { 152,-258 }, { 153,-258 }, { 154,-258 },
 { 155,-258 }, { 156,-258 }, { 157,-258 }, { 158,-258 }, { 159,-258 },
 { 160,-258 }, { 161,-258 }, { 162,-258 }, { 163,-258 }, { 164,-258 },
 { 165,-258 }, { 166,-258 }, { 167,-258 }, { 168,-258 }, { 169,-258 },
 { 170,-258 }, { 171,-258 }, { 172,-258 }, { 173,-258 }, { 174,-258 },

 { 175,-258 }, { 176,-258 }, { 177,-258 }, { 178,-258 }, { 179,-258 },
 { 180,-258 }, { 181,-258 }, { 182,-258 }, { 183,-258 }, { 184,-258 },
 { 185,-258 }, { 186,-258 }, { 187,-258 }, { 188,-258 }, { 189,-258 },
 { 190,-258 }, { 191,-258 }, { 192,-258 }, { 193,-258 }, { 194,-258 },
 { 195,-258 }, { 196,-258 }, { 197,-258 }, { 198,-258 }, { 199,-258 },
 { 200,-258 }, { 201,-258 }, { 202,-258 }, { 203,-258 }, { 204,-258 },
 { 205,-258 }, { 206,-258 }, { 207,-258 }, { 208,-258 }, { 209,-258 },
 { 210,-258 }, { 211,-258 }, { 212,-258 }, { 213,-258 }, { 214,-258 },
 { 215,-258 }, { 216,-258 }, { 217,-258 }, { 218,-258 }, { 219,-258 },
 { 220,-258 }, { 221,-258 }, { 222,-258 }, { 223,-258 }, { 224,-258 },

 { 225,-258 }, { 226,-258 }, { 227,-258 }, { 228,-258 }, { 229,-258 },
 { 230,-258 }, { 231,-258 }, { 232,-258 }, { 233,-258 }, { 234,-258 },
 { 235,-258 }, { 236,-258 }, { 237,-258 }, { 238,-258 }, { 239,-258 },
 { 240,-258 }, { 241,-258 }, { 242,-258 }, { 243,-258 }, { 244,-258 },
 { 245,-258 }, { 246,-258 }, { 247,-258 }, { 248,-258 }, { 249,-258 },
 { 250,-258 }, { 251,-258 }, { 252,-258 }, { 253,-258 }, { 254,-258 },
 { 255,-258 }, { 256,-258 }, {   0,   9 }, {   0,16157 }, {   1,-516 },
 {   2,-516 }, {   3,-516 }, {   4,-516 }, {   5,-516 }, {   6,-516 },
 {   7,-516 }, {   8,-516 }, {   9,-258 }, {  10,-6897 }, {  11,-516 },
 {  12,-258 }, {  13,-6897 }, {  14,-516 }, {  15,-516 }, {  16,-516 },

 {  17,-516 }, {  18,-516 }, {  19,-516 }, {  20,-516 }, {  21,-516 },
 {  22,-516 }, {  23,-516 }, {  24,-516 }, {  25,-516 }, {  26,-516 },
 {  27,-516 }, {  28,-516 }, {  29,-516 }, {  30,-516 }, {  31,-516 },
 {  32,-258 }, {  33,-516 }, {  34,-516 }, {  35,-516 }, {  36,-516 },
 {  37,-516 }, {  38,-516 }, {  39,-516 }, {  40,-516 }, {  41,-516 },
 {  42,-516 }, {  43,-516 }, {  44,-516 }, {  45,4429 }, {  46,-516 },
 {  47,-516 }, {  48,-516 }, {  49,-516 }, {  50,-516 }, {  51,-516 },
 {  52,-516 }, {  53,-516 }, {  54,-516 }, {  55,-516 }, {  56,-516 },
 {  57,-516 }, {  58,-516 }, {  59,-516 }, {  60,-516 }, {  61,-516 },
 {  62,-516 }, {  63,-516 }, {  64,-516 }, {  65,-516 }, {  66,-516 },

 {  67,-516 }, {  68,-516 }, {  69,-516 }, {  70,-516 }, {  71,-516 },
 {  72,-516 }, {  73,-516 }, {  74,-516 }, {  75,-516 }, {  76,-516 },
 {  77,-516 }, {  78,-516 }, {  79,-516 }, {  80,-516 }, {  81,-516 },
 {  82,-516 }, {  83,-516 }, {  84,-516 }, {  85,-516 }, {  86,-516 },
 {  87,-516 }, {  88,-516 }, {  89,-516 }, {  90,-516 }, {  91,-516 },
 {  92,-516 }, {  93,-516 }, {  94,-516 }, {  95,-516 }, {  96,-516 },
 {  97,-516 }, {  98,-516 }, {  99,-516 }, { 100,-516 }, { 101,-516 },
 { 102,-516 }, { 103,-516 }, { 104,-516 }, { 105,-516 }, { 106,-516 },
 { 107,-516 }, { 108,-516 }, { 109,-516 }, { 110,-516 }, { 111,-516 },
 { 112,-516 }, { 113,-516 }, { 114,-516 }, { 115,-516 }, { 116,-516 },

 { 117,-516 }, { 118,-516 }, { 119,-516 }, { 120,-516 }, { 121,-516 },
 { 122,-516 }, { 123,-516 }, { 124,-516 }, { 125,-516 }, { 126,-516 },
 { 127,-516 }, { 128,-516 }, { 129,-516 }, { 130,-516 }, { 131,-516 },
 { 132,-516 }, { 133,-516 }, { 134,-516 }, { 135,-516 }, { 136,-516 },
 { 137,-516 }, { 138,-516 }, { 139,-516 }, { 140,-516 }, { 141,-516 },
 { 142,-516 }, { 143,-516 }, { 144,-516 }, { 145,-516 }, { 146,-516 },
 { 147,-516 }, { 148,-516 }, { 149,-516 }, { 150,-516 }, { 151,-516 },
 { 152,-516 }, { 153,-516 }, { 154,-516 }, { 155,-516 }, { 156,-516 },
 { 157,-516 }, { 158,-516 }, { 159,-516 }, { 160,-516 }, { 161,-516 },
 { 162,-516 }, { 163,-516 }, { 164,-516 }, { 165,-516 }, { 166,-516 },

 { 167,-516 }, { 168,-516 }, { 169,-516 }, { 170,-516 }, { 171,-516 },
 { 172,-516 }, { 173,-516 }, { 174,-516 }, { 175,-516 }, { 176,-516 },
 { 177,-516 }, { 178,-516 }, { 179,-516 }, { 180,-516 }, { 181,-516 },
 { 182,-516 }, { 183,-516 }, { 184,-516 }, { 185,-516 }, { 186,-516 },
 { 187,-516 }, { 188,-516 }, { 189,-516 }, { 190,-516 }, { 191,-516 },
 { 192,-516 }, { 193,-516 }, { 194,-516 }, { 195,-516 }, { 196,-516 },
 { 197,-516 }, { 198,-516 }, { 199,-516 }, { 200,-516 }, { 201,-516 },
 { 202,-516 }, { 203,-516 }, { 204,-516 }, { 205,-516 }, { 206,-516 },
 { 207,-516 }, { 208,-516 }, { 209,-516 }, { 210,-516 }, { 211,-516 },
 { 212,-516 }, { 213,-516 }, { 214,-516 }, { 215,-516 }, { 216,-516 },

 { 217,-516 }, { 218,-516 }, { 219,-516 }, { 220,-516 }, { 221,-516 },
 { 222,-516 }, { 223,-516 }, { 224,-516 }, { 225,-516 }, { 226,-516 },
 { 227,-516 }, { 228,-516 }, { 229,-516 }, { 230,-516 }, { 231,-516 },
 { 232,-516 }, { 233,-516 }, { 234,-516 }, { 235,-516 }, { 236,-516 },
 { 237,-516 }, { 238,-516 }, { 239,-516 }, { 240,-516 }, { 241,-516 },
 { 242,-516 }, { 243,-516 }, { 244,-516 }, { 245,-516 }, { 246,-516 },
 { 247,-516 }, { 248,-516 }, { 249,-516 }, { 250,-516 }, { 251,-516 },
 { 252,-516 }, { 253,-516 }, { 254,-516 }, { 255,-516 }, { 256,-516 },
 {   0,  16 }, {   0,15899 }, {   1,4429 }, {   2,4429 }, {   3,4429 },
 {   4,4429 }, {   5,4429 }, {   6,4429 }, {   7,4429 }, {   8,4429 },

 {   9,4687 }, {  10,4945 }, {  11,4429 }, {  12,4687 }, {  13,4945 },
 {  14,4429 }, {  15,4429 }, {  16,4429 }, {  17,4429 }, {  18,4429 },
 {  19,4429 }, {  20,4429 }, {  21,4429 }, {  22,4429 }, {  23,4429 },
 {  24,4429 }, {  25,4429 }, {  26,4429 }, {  27,4429 }, {  28,4429 },
 {  29,4429 }, {  30,4429 }, {  31,4429 }, {  32,4687 }, {  33,4429 },
 {  34,4429 }, {  35,4429 }, {  36,4429 }, {  37,4429 }, {  38,4429 },
 {  39,4429 }, {  40,4429 }, {  41,4429 }, {  42,4429 }, {  43,4429 },
 {  44,4429 }, {  45,4992 }, {  46,4429 }, {  47,4429 }, {  48,4429 },
 {  49,4429 }, {  50,4429 }, {  51,4429 }, {  52,4429 }, {  53,4429 },
 {  54,4429 }, {  55,4429 }, {  56,4429 }, {  57,4429 }, {  58,4429 },

 {  59,4429 }, {  60,4429 }, {  61,4429 }, {  62,4429 }, {  63,4429 },
 {  64,4429 }, {  65,4429 }, {  66,4429 }, {  67,4429 }, {  68,4429 },
 {  69,4429 }, {  70,4429 }, {  71,4429 }, {  72,4429 }, {  73,4429 },
 {  74,4429 }, {  75,4429 }, {  76,4429 }, {  77,4429 }, {  78,4429 },
 {  79,4429 }, {  80,4429 }, {  81,4429 }, {  82,4429 }, {  83,4429 },
 {  84,4429 }, {  85,4429 }, {  86,4429 }, {  87,4429 }, {  88,4429 },
 {  89,4429 }, {  90,4429 }, {  91,4429 }, {  92,4429 }, {  93,4429 },
 {  94,4429 }, {  95,4429 }, {  96,4429 }, {  97,4429 }, {  98,4429 },
 {  99,4429 }, { 100,4429 }, { 101,4429 }, { 102,4429 }, { 103,4429 },
 { 104,4429 }, { 105,4429 }, { 106,4429 }, { 107,4429 }, { 108,4429 },

 { 109,4429 }, { 110,4429 }, { 111,4429 }, { 112,4429 }, { 113,4429 },
 { 114,4429 }, { 115,4429 }, { 116,4429 }, { 117,4429 }, { 118,4429 },
 { 119,4429 }, { 120,4429 }, { 121,4429 }, { 122,4429 }, { 123,4429 },
 { 124,4429 }, { 125,4429 }, { 126,4429 }, { 127,4429 }, { 128,4429 },
 { 129,4429 }, { 130,4429 }, { 131,4429 }, { 132,4429 }, { 133,4429 },
 { 134,4429 }, { 135,4429 }, { 136,4429 }, { 137,4429 }, { 138,4429 },
 { 139,4429 }, { 140,4429 }, { 141,4429 }, { 142,4429 }, { 143,4429 },
 { 144,4429 }, { 145,4429 }, { 146,4429 }, { 147,4429 }, { 148,4429 },
 { 149,4429 }, { 150,4429 }, { 151,4429 }, { 152,4429 }, { 153,4429 },
 { 154,4429 }, { 155,4429 }, { 156,4429 }, { 157,4429 }, { 158,4429 },

 { 159,4429 }, { 160,4429 }, { 161,4429 }, { 162,4429 }, { 163,4429 },
 { 164,4429 }, { 165,4429 }, { 166,4429 }, { 167,4429 }, { 168,4429 },
 { 169,4429 }, { 170,4429 }, { 171,4429 }, { 172,4429 }, { 173,4429 },
 { 174,4429 }, { 175,4429 }, { 176,4429 }, { 177,4429 }, { 178,4429 },
 { 179,4429 }, { 180,4429 }, { 181,4429 }, { 182,4429 }, { 183,4429 },
 { 184,4429 }, { 185,4429 }, { 186,4429 }, { 187,4429 }, { 188,4429 },
 { 189,4429 }, { 190,4429 }, { 191,4429 }, { 192,4429 }, { 193,4429 },
 { 194,4429 }, { 195,4429 }, { 196,4429 }, { 197,4429 }, { 198,4429 },
 { 199,4429 }, { 200,4429 }, { 201,4429 }, { 202,4429 }, { 203,4429 },
 { 204,4429 }, { 205,4429 }, { 206,4429 }, { 207,4429 }, { 208,4429 },

 { 209,4429 }, { 210,4429 }, { 211,4429 }, { 212,4429 }, { 213,4429 },
 { 214,4429 }, { 215,4429 }, { 216,4429 }, { 217,4429 }, { 218,4429 },
 { 219,4429 }, { 220,4429 }, { 221,4429 }, { 222,4429 }, { 223,4429 },
 { 224,4429 }, { 225,4429 }, { 226,4429 }, { 227,4429 }, { 228,4429 },
 { 229,4429 }, { 230,4429 }, { 231,4429 }, { 232,4429 }, { 233,4429 },
 { 234,4429 }, { 235,4429 }, { 236,4429 }, { 237,4429 }, { 238,4429 },
 { 239,4429 }, { 240,4429 }, { 241,4429 }, { 242,4429 }, { 243,4429 },
 { 244,4429 }, { 245,4429 }, { 246,4429 }, { 247,4429 }, { 248,4429 },
 { 249,4429 }, { 250,4429 }, { 251,4429 }, { 252,4429 }, { 253,4429 },
 { 254,4429 }, { 255,4429 }, { 256,4429 }, {   0,  16 }, {   0,15641 },

 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },
 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9, 258 }, {  10,-6459 },
 {  11,   0 }, {  12, 258 }, {  13,-6459 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },
 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },
 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },
 {  31,   0 }, {  32, 258 }, {  33,   0 }, {  34,   0 }, {  35,   0 },
 {  36,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 },
 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45, 516 },
 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },

 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },
 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },
 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },

 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },
 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },
 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },

 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },
 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },

 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },
 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },

 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 { 256,   0 }, {   0,  16 }, {   0,15383 }, {   1,-258 }, {   2,-258 },
 {   3,-258 }, {   4,-258 }, {   5,-258 }, {   6,-258 }, {   7,-258 },
 {   8,-258 }, {   9,   0 }, {  10,-6717 }, {  11,-258 }, {  12,   0 },
 {  13,-6717 }, {  14,-258 }, {  15,-258 }, {  16,-258 }, {  17,-258 },
 {  18,-258 }, {  19,-258 }, {  20,-258 }, {  21,-258 }, {  22,-258 },
 {  23,-258 }, {  24,-258 }, {  25,-258 }, {  26,-258 }, {  27,-258 },
 {  28,-258 }, {  29,-258 }, {  30,-258 }, {  31,-258 }, {  32,   0 },
 {  33,-258 }, {  34,-258 }, {  35,-258 }, {  36,-258 }, {  37,-258 },
 {  38,-258 }, {  39,-258 }, {  40,-258 }, {  41,-258 }, {  42,-258 },

 {  43,-258 }, {  44,-258 }, {  45, 258 }, {  46,-258 }, {  47,-258 },
 {  48,-258 }, {  49,-258 }, {  50,-258 }, {  51,-258 }, {  52,-258 },
 {  53,-258 }, {  54,-258 }, {  55,-258 }, {  56,-258 }, {  57,-258 },
 {  58,-258 }, {  59,-258 }, {  60,-258 }, {  61,-258 }, {  62,-258 },
 {  63,-258 }, {  64,-258 }, {  65,-258 }, {  66,-258 }, {  67,-258 },
 {  68,-258 }, {  69,-258 }, {  70,-258 }, {  71,-258 }, {  72,-258 },
 {  73,-258 }, {  74,-258 }, {  75,-258 }, {  76,-258 }, {  77,-258 },
 {  78,-258 }, {  79,-258 }, {  80,-258 }, {  81,-258 }, {  82,-258 },
 {  83,-258 }, {  84,-258 }, {  85,-258 }, {  86,-258 }, {  87,-258 },
 {  88,-258 }, {  89,-258 }, {  90,-258 }, {  91,-258 }, {  92,-258 },

 {  93,-258 }, {  94,-258 }, {  95,-258 }, {  96,-258 }, {  97,-258 },
 {  98,-258 }, {  99,-258 }, { 100,-258 }, { 101,-258 }, { 102,-258 },
 { 103,-258 }, { 104,-258 }, { 105,-258 }, { 106,-258 }, { 107,-258 },
 { 108,-258 }, { 109,-258 }, { 110,-258 }, { 111,-258 }, { 112,-258 },
 { 113,-258 }, { 114,-258 }, { 115,-258 }, { 116,-258 }, { 117,-258 },
 { 118,-258 }, { 119,-258 }, { 120,-258 }, { 121,-258 }, { 122,-258 },
 { 123,-258 }, { 124,-258 }, { 125,-258 }, { 126,-258 }, { 127,-258 },
 { 128,-258 }, { 129,-258 }, { 130,-258 }, { 131,-258 }, { 132,-258 },
 { 133,-258 }, { 134,-258 }, { 135,-258 }, { 136,-258 }, { 137,-258 },
 { 138,-258 }, { 139,-258 }, { 140,-258 }, { 141,-258 }, { 142,-258 },

 { 143,-258 }, { 144,-258 }, { 145,-258 }, { 146,-258 }, { 147,-258 },
 { 148,-258 }, { 149,-258 }, { 150,-258 }, { 151,-258 }, { 152,-258 },
 { 153,-258 }, { 154,-258 }, { 155,-258 }, { 156,-258 }, { 157,-258 },
 { 158,-258 }, { 159,-258 }, { 160,-258 }, { 161,-258 }, { 162,-258 },
 { 163,-258 }, { 164,-258 }, { 165,-258 }, { 166,-258 }, { 167,-258 },
 { 168,-258 }, { 169,-258 }, { 170,-258 }, { 171,-258 }, { 172,-258 },
 { 173,-258 }, { 174,-258 }, { 175,-258 }, { 176,-258 }, { 177,-258 },
 { 178,-258 }, { 179,-258 }, { 180,-258 }, { 181,-258 }, { 182,-258 },
 { 183,-258 }, { 184,-258 }, { 185,-258 }, { 186,-258 }, { 187,-258 },
 { 188,-258 }, { 189,-258 }, { 190,-258 }, { 191,-258 }, { 192,-258 },

 { 193,-258 }, { 194,-258 }, { 195,-258 }, { 196,-258 }, { 197,-258 },
 { 198,-258 }, { 199,-258 }, { 200,-258 }, { 201,-258 }, { 202,-258 },
 { 203,-258 }, { 204,-258 }, { 205,-258 }, { 206,-258 }, { 207,-258 },
 { 208,-258 }, { 209,-258 }, { 210,-258 }, { 211,-258 }, { 212,-258 },
 { 213,-258 }, { 214,-258 }, { 215,-258 }, { 216,-258 }, { 217,-258 },
 { 218,-258 }, { 219,-258 }, { 220,-258 }, { 221,-258 }, { 222,-258 },
 { 223,-258 }, { 224,-258 }, { 225,-258 }, { 226,-258 }, { 227,-258 },
 { 228,-258 }, { 229,-258 }, { 230,-258 }, { 231,-258 }, { 232,-258 },
 { 233,-258 }, { 234,-258 }, { 235,-258 }, { 236,-258 }, { 237,-258 },
 { 238,-258 }, { 239,-258 }, { 240,-258 }, { 241,-258 }, { 242,-258 },

 { 243,-258 }, { 244,-258 }, { 245,-258 }, { 246,-258 }, { 247,-258 },
 { 248,-258 }, { 249,-258 }, { 250,-258 }, { 251,-258 }, { 252,-258 },
 { 253,-258 }, { 254,-258 }, { 255,-258 }, { 256,-258 }, {   0,  16 },
 {   0,15125 }, {   1,-516 }, {   2,-516 }, {   3,-516 }, {   4,-516 },
 {   5,-516 }, {   6,-516 }, {   7,-516 }, {   8,-516 }, {   9,-258 },
 {  10,-6975 }, {  11,-516 }, {  12,-258 }, {  13,-6975 }, {  14,-516 },
 {  15,-516 }, {  16,-516 }, {  17,-516 }, {  18,-516 }, {  19,-516 },
 {  20,-516 }, {  21,-516 }, {  22,-516 }, {  23,-516 }, {  24,-516 },
 {  25,-516 }, {  26,-516 }, {  27,-516 }, {  28,-516 }, {  29,-516 },
 {  30,-516 }, {  31,-516 }, {  32,-258 }, {  33,-516 }, {  34,-516 },

 {  35,-516 }, {  36,-516 }, {  37,-516 }, {  38,-516 }, {  39,-516 },
 {  40,-516 }, {  41,-516 }, {  42,-516 }, {  43,-516 }, {  44,-516 },
 {  45,4476 }, {  46,-516 }, {  47,-516 }, {  48,-516 }, {  49,-516 },
 {  50,-516 }, {  51,-516 }, {  52,-516 }, {  53,-516 }, {  54,-516 },
 {  55,-516 }, {  56,-516 }, {  57,-516 }, {  58,-516 }, {  59,-516 },
 {  60,-516 }, {  61,-516 }, {  62,-516 }, {  63,-516 }, {  64,-516 },
 {  65,-516 }, {  66,-516 }, {  67,-516 }, {  68,-516 }, {  69,-516 },
 {  70,-516 }, {  71,-516 }, {  72,-516 }, {  73,-516 }, {  74,-516 },
 {  75,-516 }, {  76,-516 }, {  77,-516 }, {  78,-516 }, {  79,-516 },
 {  80,-516 }, {  81,-516 }, {  82,-516 }, {  83,-516 }, {  84,-516 },

 {  85,-516 }, {  86,-516 }, {  87,-516 }, {  88,-516 }, {  89,-516 },
 {  90,-516 }, {  91,-516 }, {  92,-516 }, {  93,-516 }, {  94,-516 },
 {  95,-516 }, {  96,-516 }, {  97,-516 }, {  98,-516 }, {  99,-516 },
 { 100,-516 }, { 101,-516 }, { 102,-516 }, { 103,-516 }, { 104,-516 },
 { 105,-516 }, { 106,-516 }, { 107,-516 }, { 108,-516 }, { 109,-516 },
 { 110,-516 }, { 111,-516 }, { 112,-516 }, { 113,-516 }, { 114,-516 },
 { 115,-516 }, { 116,-516 }, { 117,-516 }, { 118,-516 }, { 119,-516 },
 { 120,-516 }, { 121,-516 }, { 122,-516 }, { 123,-516 }, { 124,-516 },
 { 125,-516 }, { 126,-516 }, { 127,-516 }, { 128,-516 }, { 129,-516 },
 { 130,-516 }, { 131,-516 }, { 132,-516 }, { 133,-516 }, { 134,-516 },

 { 135,-516 }, { 136,-516 }, { 137,-516 }, { 138,-516 }, { 139,-516 },
 { 140,-516 }, { 141,-516 }, { 142,-516 }, { 143,-516 }, { 144,-516 },
 { 145,-516 }, { 146,-516 }, { 147,-516 }, { 148,-516 }, { 149,-516 },
 { 150,-516 }, { 151,-516 }, { 152,-516 }, { 153,-516 }, { 154,-516 },
 { 155,-516 }, { 156,-516 }, { 157,-516 }, { 158,-516 }, { 159,-516 },
 { 160,-516 }, { 161,-516 }, { 162,-516 }, { 163,-516 }, { 164,-516 },
 { 165,-516 }, { 166,-516 }, { 167,-516 }, { 168,-516 }, { 169,-516 },
 { 170,-516 }, { 171,-516 }, { 172,-516 }, { 173,-516 }, { 174,-516 },
 { 175,-516 }, { 176,-516 }, { 177,-516 }, { 178,-516 }, { 179,-516 },
 { 180,-516 }, { 181,-516 }, { 182,-516 }, { 183,-516 }, { 184,-516 },

 { 185,-516 }, { 186,-516 }, { 187,-516 }, { 188,-516 }, { 189,-516 },
 { 190,-516 }, { 191,-516 }, { 192,-516 }, { 193,-516 }, { 194,-516 },
 { 195,-516 }, { 196,-516 }, { 197,-516 }, { 198,-516 }, { 199,-516 },
 { 200,-516 }, { 201,-516 }, { 202,-516 }, { 203,-516 }, { 204,-516 },
 { 205,-516 }, { 206,-516 }, { 207,-516 }, { 208,-516 }, { 209,-516 },
 { 210,-516 }, { 211,-516 }, { 212,-516 }, { 213,-516 }, { 214,-516 },
 { 215,-516 }, { 216,-516 }, { 217,-516 }, { 218,-516 }, { 219,-516 },
 { 220,-516 }, { 221,-516 }, { 222,-516 }, { 223,-516 }, { 224,-516 },
 { 225,-516 }, { 226,-516 }, { 227,-516 }, { 228,-516 }, { 229,-516 },
 { 230,-516 }, { 231,-516 }, { 232,-516 }, { 233,-516 }, { 234,-516 },

 { 235,-516 }, { 236,-516 }, { 237,-516 }, { 238,-516 }, { 239,-516 },
 { 240,-516 }, { 241,-516 }, { 242,-516 }, { 243,-516 }, { 244,-516 },
 { 245,-516 }, { 246,-516 }, { 247,-516 }, { 248,-516 }, { 249,-516 },
 { 250,-516 }, { 251,-516 }, { 252,-516 }, { 253,-516 }, { 254,-516 },
 { 255,-516 }, { 256,-516 }, {   0,  22 }, {   0,14867 }, {   1,4476 },
 {   2,4476 }, {   3,4476 }, {   4,4476 }, {   5,4476 }, {   6,4476 },
 {   7,4476 }, {   8,4476 }, {   9,4734 }, {  10,4992 }, {  11,4476 },
 {  12,4734 }, {  13,4992 }, {  14,4476 }, {  15,4476 }, {  16,4476 },
 {  17,4476 }, {  18,4476 }, {  19,4476 }, {  20,4476 }, {  21,4476 },
 {  22,4476 }, {  23,4476 }, {  24,4476 }, {  25,4476 }, {  26,4476 },

 {  27,4476 }, {  28,4476 }, {  29,4476 }, {  30,4476 }, {  31,4476 },
 {  32,4734 }, {  33,4476 }, {  34,4476 }, {  35,4476 }, {  36,4476 },
 {  37,4476 }, {  38,4476 }, {  39,4476 }, {  40,4476 }, {  41,4476 },
 {  42,4476 }, {  43,4476 }, {  44,4476 }, {  45,5039 }, {  46,4476 },
 {  47,4476 }, {  48,4476 }, {  49,4476 }, {  50,4476 }, {  51,4476 },
 {  52,4476 }, {  53,4476 }, {  54,4476 }, {  55,4476 }, {  56,4476 },
 {  57,4476 }, {  58,4476 }, {  59,4476 }, {  60,4476 }, {  61,4476 },
 {  62,4476 }, {  63,4476 }, {  64,4476 }, {  65,4476 }, {  66,4476 },
 {  67,4476 }, {  68,4476 }, {  69,4476 }, {  70,4476 }, {  71,4476 },
 {  72,4476 }, {  73,4476 }, {  74,4476 }, {  75,4476 }, {  76,4476 },

 {  77,4476 }, {  78,4476 }, {  79,4476 }, {  80,4476 }, {  81,4476 },
 {  82,4476 }, {  83,4476 }, {  84,4476 }, {  85,4476 }, {  86,4476 },
 {  87,4476 }, {  88,4476 }, {  89,4476 }, {  90,4476 }, {  91,4476 },
 {  92,4476 }, {  93,4476 }, {  94,4476 }, {  95,4476 }, {  96,4476 },
 {  97,4476 }, {  98,4476 }, {  99,4476 }, { 100,4476 }, { 101,4476 },
 { 102,4476 }, { 103,4476 }, { 104,4476 }, { 105,4476 }, { 106,4476 },
 { 107,4476 }, { 108,4476 }, { 109,4476 }, { 110,4476 }, { 111,4476 },
 { 112,4476 }, { 113,4476 }, { 114,4476 }, { 115,4476 }, { 116,4476 },
 { 117,4476 }, { 118,4476 }, { 119,4476 }, { 120,4476 }, { 121,4476 },
 { 122,4476 }, { 123,4476 }, { 124,4476 }, { 125,4476 }, { 126,4476 },

 { 127,4476 }, { 128,4476 }, { 129,4476 }, { 130,4476 }, { 131,4476 },
 { 132,4476 }, { 133,4476 }, { 134,4476 }, { 135,4476 }, { 136,4476 },
 { 137,4476 }, { 138,4476 }, { 139,4476 }, { 140,4476 }, { 141,4476 },
 { 142,4476 }, { 143,4476 }, { 144,4476 }, { 145,4476 }, { 146,4476 },
 { 147,4476 }, { 148,4476 }, { 149,4476 }, { 150,4476 }, { 151,4476 },
 { 152,4476 }, { 153,4476 }, { 154,4476 }, { 155,4476 }, { 156,4476 },
 { 157,4476 }, { 158,4476 }, { 159,4476 }, { 160,4476 }, { 161,4476 },
 { 162,4476 }, { 163,4476 }, { 164,4476 }, { 165,4476 }, { 166,4476 },
 { 167,4476 }, { 168,4476 }, { 169,4476 }, { 170,4476 }, { 171,4476 },
 { 172,4476 }, { 173,4476 }, { 174,4476 }, { 175,4476 }, { 176,4476 },

 { 177,4476 }, { 178,4476 }, { 179,4476 }, { 180,4476 }, { 181,4476 },
 { 182,4476 }, { 183,4476 }, { 184,4476 }, { 185,4476 }, { 186,4476 },
 { 187,4476 }, { 188,4476 }, { 189,4476 }, { 190,4476 }, { 191,4476 },
 { 192,4476 }, { 193,4476 }, { 194,4476 }, { 195,4476 }, { 196,4476 },
 { 197,4476 }, { 198,4476 }, { 199,4476 }, { 200,4476 }, { 201,4476 },
 { 202,4476 }, { 203,4476 }, { 204,4476 }, { 205,4476 }, { 206,4476 },
 { 207,4476 }, { 208,4476 }, { 209,4476 }, { 210,4476 }, { 211,4476 },
 { 212,4476 }, { 213,4476 }, { 214,4476 }, { 215,4476 }, { 216,4476 },
 { 217,4476 }, { 218,4476 }, { 219,4476 }, { 220,4476 }, { 221,4476 },
 { 222,4476 }, { 223,4476 }, { 224,4476 }, { 225,4476 }, { 226,4476 },

 { 227,4476 }, { 228,4476 }, { 229,4476 }, { 230,4476 }, { 231,4476 },
 { 232,4476 }, { 233,4476 }, { 234,4476 }, { 235,4476 }, { 236,4476 },
 { 237,4476 }, { 238,4476 }, { 239,4476 }, { 240,4476 }, { 241,4476 },
 { 242,4476 }, { 243,4476 }, { 244,4476 }, { 245,4476 }, { 246,4476 },
 { 247,4476 }, { 248,4476 }, { 249,4476 }, { 250,4476 }, { 251,4476 },
 { 252,4476 }, { 253,4476 }, { 254,4476 }, { 255,4476 }, { 256,4476 },
 {   0,  22 }, {   0,14609 }, {   1,   0 }, {   2,   0 }, {   3,   0 },
 {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 },
 {   9, 258 }, {  10,-7181 }, {  11,   0 }, {  12, 258 }, {  13,-7181 },
 {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 },

 {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 },
 {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 },
 {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32, 258 }, {  33,   0 },
 {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 },
 {  39,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 },
 {  44,   0 }, {  45, 516 }, {  46,   0 }, {  47,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 },
 {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 },
 {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },

 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },
 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },
 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },
 {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 },
 {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },
 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },
 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },
 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },

 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 },
 { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 },
 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },
 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },
 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },
 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },
 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },
 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },

 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },
 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },
 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },
 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },
 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },
 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },
 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },

 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },
 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },
 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },
 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },
 { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  22 }, {   0,14351 },
 {   1,-258 }, {   2,-258 }, {   3,-258 }, {   4,-258 }, {   5,-258 },
 {   6,-258 }, {   7,-258 }, {   8,-258 }, {   9,   0 }, {  10,-7439 },

 {  11,-258 }, {  12,   0 }, {  13,-7439 }, {  14,-258 }, {  15,-258 },
 {  16,-258 }, {  17,-258 }, {  18,-258 }, {  19,-258 }, {  20,-258 },
 {  21,-258 }, {  22,-258 }, {  23,-258 }, {  24,-258 }, {  25,-258 },
 {  26,-258 }, {  27,-258 }, {  28,-258 }, {  29,-258 }, {  30,-258 },
 {  31,-258 }, {  32,   0 }, {  33,-258 }, {  34,-258 }, {  35,-258 },
 {  36,-258 }, {  37,-258 }, {  38,-258 }, {  39,-258 }, {  40,-258 },
 {  41,-258 }, {  42,-258 }, {  43,-258 }, {  44,-258 }, {  45, 258 },
 {  46,-258 }, {  47,-258 }, {  48,-258 }, {  49,-258 }, {  50,-258 },
 {  51,-258 }, {  52,-258 }, {  53,-258 }, {  54,-258 }, {  55,-258 },
 {  56,-258 }, {  57,-258 }, {  58,-258 }, {  59,-258 }, {  60,-258 },

 {  61,-258 }, {  62,-258 }, {  63,-258 }, {  64,-258 }, {  65,-258 },
 {  66,-258 }, {  67,-258 }, {  68,-258 }, {  69,-258 }, {  70,-258 },
 {  71,-258 }, {  72,-258 }, {  73,-258 }, {  74,-258 }, {  75,-258 },
 {  76,-258 }, {  77,-258 }, {  78,-258 }, {  79,-258 }, {  80,-258 },
 {  81,-258 }, {  82,-258 }, {  83,-258 }, {  84,-258 }, {  85,-258 },
 {  86,-258 }, {  87,-258 }, {  88,-258 }, {  89,-258 }, {  90,-258 },
 {  91,-258 }, {  92,-258 }, {  93,-258 }, {  94,-258 }, {  95,-258 },
 {  96,-258 }, {  97,-258 }, {  98,-258 }, {  99,-258 }, { 100,-258 },
 { 101,-258 }, { 102,-258 }, { 103,-258 }, { 104,-258 }, { 105,-258 },
 { 106,-258 }, { 107,-258 }, { 108,-258 }, { 109,-258 }, { 110,-258 },

 { 111,-258 }, { 112,-258 }, { 113,-258 }, { 114,-258 }, { 115,-258 },
 { 116,-258 }, { 117,-258 }, { 118,-258 }, { 119,-258 }, { 120,-258 },
 { 121,-258 }, { 122,-258 }, { 123,-258 }, { 124,-258 }, { 125,-258 },
 { 126,-258 }, { 127,-258 }, { 128,-258 }, { 129,-258 }, { 130,-258 },
 { 131,-258 }, { 132,-258 }, { 133,-258 }, { 134,-258 }, { 135,-258 },
 { 136,-258 }, { 137,-258 }, { 138,-258 }, { 139,-258 }, { 140,-258 },
 { 141,-258 }, { 142,-258 }, { 143,-258 }, { 144,-258 }, { 145,-258 },
 { 146,-258 }, { 147,-258 }, { 148,-258 }, { 149,-258 }, { 150,-258 },
 { 151,-258 }, { 152,-258 }, { 153,-258 }, { 154,-258 }, { 155,-258 },
 { 156,-258 }, { 157,-258 }, { 158,-258 }, { 159,-258 }, { 160,-258 },

 { 161,-258 }, { 162,-258 }, { 163,-258 }, { 164,-258 }, { 165,-258 },
 { 166,-258 }, { 167,-258 }, { 168,-258 }, { 169,-258 }, { 170,-258 },
 { 171,-258 }, { 172,-258 }, { 173,-258 }, { 174,-258 }, { 175,-258 },
 { 176,-258 }, { 177,-258 }, { 178,-258 }, { 179,-258 }, { 180,-258 },
 { 181,-258 }, { 182,-258 }, { 183,-258 }, { 184,-258 }, { 185,-258 },
 { 186,-258 }, { 187,-258 }, { 188,-258 }, { 189,-258 }, { 190,-258 },
 { 191,-258 }, { 192,-258 }, { 193,-258 }, { 194,-258 }, { 195,-258 },
 { 196,-258 }, { 197,-258 }, { 198,-258 }, { 199,-258 }, { 200,-258 },
 { 201,-258 }, { 202,-258 }, { 203,-258 }, { 204,-258 }, { 205,-258 },
 { 206,-258 }, { 207,-258 }, { 208,-258 }, { 209,-258 }, { 210,-258 },

 { 211,-258 }, { 212,-258 }, { 213,-258 }, { 214,-258 }, { 215,-258 },
 { 216,-258 }, { 217,-258 }, { 218,-258 }, { 219,-258 }, { 220,-258 },
 { 221,-258 }, { 222,-258 }, { 223,-258 }, { 224,-258 }, { 225,-258 },
 { 226,-258 }, { 227,-258 }, { 228,-258 }, { 229,-258 }, { 230,-258 },
 { 231,-258 }, { 232,-258 }, { 233,-258 }, { 234,-258 }, { 235,-258 },
 { 236,-258 }, { 237,-258 }, { 238,-258 }, { 239,-258 }, { 240,-258 },
 { 241,-258 }, { 242,-258 }, { 243,-258 }, { 244,-258 }, { 245,-258 },
 { 246,-258 }, { 247,-258 }, { 248,-258 }, { 249,-258 }, { 250,-258 },
 { 251,-258 }, { 252,-258 }, { 253,-258 }, { 254,-258 }, { 255,-258 },
 { 256,-258 }, {   0,  22 }, {   0,14093 }, {   1,-516 }, {   2,-516 },

 {   3,-516 }, {   4,-516 }, {   5,-516 }, {   6,-516 }, {   7,-516 },
 {   8,-516 }, {   9,-258 }, {  10,-7697 }, {  11,-516 }, {  12,-258 },
 {  13,-7697 }, {  14,-516 }, {  15,-516 }, {  16,-516 }, {  17,-516 },
 {  18,-516 }, {  19,-516 }, {  20,-516 }, {  21,-516 }, {  22,-516 },
 {  23,-516 }, {  24,-516 }, {  25,-516 }, {  26,-516 }, {  27,-516 },
 {  28,-516 }, {  29,-516 }, {  30,-516 }, {  31,-516 }, {  32,-258 },
 {  33,-516 }, {  34,-516 }, {  35,-516 }, {  36,-516 }, {  37,-516 },
 {  38,-516 }, {  39,-516 }, {  40,-516 }, {  41,-516 }, {  42,-516 },
 {  43,-516 }, {  44,-516 }, {  45,4523 }, {  46,-516 }, {  47,-516 },
 {  48,-516 }, {  49,-516 }, {  50,-516 }, {  51,-516 }, {  52,-516 },

 {  53,-516 }, {  54,-516 }, {  55,-516 }, {  56,-516 }, {  57,-516 },
 {  58,-516 }, {  59,-516 }, {  60,-516 }, {  61,-516 }, {  62,-516 },
 {  63,-516 }, {  64,-516 }, {  65,-516 }, {  66,-516 }, {  67,-516 },
 {  68,-516 }, {  69,-516 }, {  70,-516 }, {  71,-516 }, {  72,-516 },
 {  73,-516 }, {  74,-516 }, {  75,-516 }, {  76,-516 }, {  77,-516 },
 {  78,-516 }, {  79,-516 }, {  80,-516 }, {  81,-516 }, {  82,-516 },
 {  83,-516 }, {  84,-516 }, {  85,-516 }, {  86,-516 }, {  87,-516 },
 {  88,-516 }, {  89,-516 }, {  90,-516 }, {  91,-516 }, {  92,-516 },
 {  93,-516 }, {  94,-516 }, {  95,-516 }, {  96,-516 }, {  97,-516 },
 {  98,-516 }, {  99,-516 }, { 100,-516 }, { 101,-516 }, { 102,-516 },

 { 103,-516 }, { 104,-516 }, { 105,-516 }, { 106,-516 }, { 107,-516 },
 { 108,-516 }, { 109,-516 }, { 110,-516 }, { 111,-516 }, { 112,-516 },
 { 113,-516 }, { 114,-516 }, { 115,-516 }, { 116,-516 }, { 117,-516 },
 { 118,-516 }, { 119,-516 }, { 120,-516 }, { 121,-516 }, { 122,-516 },
 { 123,-516 }, { 124,-516 }, { 125,-516 }, { 126,-516 }, { 127,-516 },
 { 128,-516 }, { 129,-516 }, { 130,-516 }, { 131,-516 }, { 132,-516 },
 { 133,-516 }, { 134,-516 }, { 135,-516 }, { 136,-516 }, { 137,-516 },
 { 138,-516 }, { 139,-516 }, { 140,-516 }, { 141,-516 }, { 142,-516 },
 { 143,-516 }, { 144,-516 }, { 145,-516 }, { 146,-516 }, { 147,-516 },
 { 148,-516 }, { 149,-516 }, { 150,-516 }, { 151,-516 }, { 152,-516 },

 { 153,-516 }, { 154,-516 }, { 155,-516 }, { 156,-516 }, { 157,-516 },
 { 158,-516 }, { 159,-516 }, { 160,-516 }, { 161,-516 }, { 162,-516 },
 { 163,-516 }, { 164,-516 }, { 165,-516 }, { 166,-516 }, { 167,-516 },
 { 168,-516 }, { 169,-516 }, { 170,-516 }, { 171,-516 }, { 172,-516 },
 { 173,-516 }, { 174,-516 }, { 175,-516 }, { 176,-516 }, { 177,-516 },
 { 178,-516 }, { 179,-516 }, { 180,-516 }, { 181,-516 }, { 182,-516 },
 { 183,-516 }, { 184,-516 }, { 185,-516 }, { 186,-516 }, { 187,-516 },
 { 188,-516 }, { 189,-516 }, { 190,-516 }, { 191,-516 }, { 192,-516 },
 { 193,-516 }, { 194,-516 }, { 195,-516 }, { 196,-516 }, { 197,-516 },
 { 198,-516 }, { 199,-516 }, { 200,-516 }, { 201,-516 }, { 202,-516 },

 { 203,-516 }, { 204,-516 }, { 205,-516 }, { 206,-516 }, { 207,-516 },
 { 208,-516 }, { 209,-516 }, { 210,-516 }, { 211,-516 }, { 212,-516 },
 { 213,-516 }, { 214,-516 }, { 215,-516 }, { 216,-516 }, { 217,-516 },
 { 218,-516 }, { 219,-516 }, { 220,-516 }, { 221,-516 }, { 222,-516 },
 { 223,-516 }, { 224,-516 }, { 225,-516 }, { 226,-516 }, { 227,-516 },
 { 228,-516 }, { 229,-516 }, { 230,-516 }, { 231,-516 }, { 232,-516 },
 { 233,-516 }, { 234,-516 }, { 235,-516 }, { 236,-516 }, { 237,-516 },
 { 238,-516 }, { 239,-516 }, { 240,-516 }, { 241,-516 }, { 242,-516 },
 { 243,-516 }, { 244,-516 }, { 245,-516 }, { 246,-516 }, { 247,-516 },
 { 248,-516 }, { 249,-516 }, { 250,-516 }, { 251,-516 }, { 252,-516 },

 { 253,-516 }, { 254,-516 }, { 255,-516 }, { 256,-516 }, {   0,  37 },
 {   0,13835 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  37 }, {   0,13812 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,4523 }, {  49,4523 },
 {  50,4523 }, {  51,4523 }, {  52,4523 }, {  53,4523 }, {  54,4523 },
 {  55,4523 }, {  56,4523 }, {  57,4523 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,4523 }, {  66,4523 }, {  67,4523 }, {  68,4523 }, {  69,4523 },
 {  70,4523 }, {  48,4523 }, {  49,4523 }, {  50,4523 }, {  51,4523 },
 {  52,4523 }, {  53,4523 }, {  54,4523 }, {  55,4523 }, {  56,4523 },
 {  57,4523 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,4523 }, {  66,4523 },
 {  67,4523 }, {  68,4523 }, {  69,4523 }, {  70,4523 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  97,4523 }, {  98,4523 }, {  99,4523 },
 { 100,4523 }, { 101,4523 }, { 102,4523 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,4523 }, {  98,4523 }, {  99,4523 }, { 100,4523 }, { 101,4523 },
 { 102,4523 }, {   0,  24 }, {   0,13708 }, {   1,4523 }, {   2,4523 },
 {   3,4523 }, {   4,4523 }, {   5,4523 }, {   6,4523 }, {   7,4523 },
 {   8,4523 }, {   9,4781 }, {  10,5039 }, {  11,4523 }, {  12,4781 },
 {  13,5039 }, {  14,4523 }, {  15,4523 }, {  16,4523 }, {  17,4523 },

 {  18,4523 }, {  19,4523 }, {  20,4523 }, {  21,4523 }, {  22,4523 },
 {  23,4523 }, {  24,4523 }, {  25,4523 }, {  26,4523 }, {  27,4523 },
 {  28,4523 }, {  29,4523 }, {  30,4523 }, {  31,4523 }, {  32,4781 },
 {  33,4523 }, {  34,4523 }, {  35,4523 }, {  36,4523 }, {  37,4523 },
 {  38,4523 }, {  39,4523 }, {  40,4523 }, {  41,4523 }, {  42,4523 },
 {  43,4523 }, {  44,4523 }, {  45,5086 }, {  46,4523 }, {  47,4523 },
 {  48,4523 }, {  49,4523 }, {  50,4523 }, {  51,4523 }, {  52,4523 },
 {  53,4523 }, {  54,4523 }, {  55,4523 }, {  56,4523 }, {  57,4523 },
 {  58,4523 }, {  59,4523 }, {  60,4523 }, {  61,4523 }, {  62,4523 },
 {  63,4523 }, {  64,4523 }, {  65,4523 }, {  66,4523 }, {  67,4523 },

 {  68,4523 }, {  69,4523 }, {  70,4523 }, {  71,4523 }, {  72,4523 },
 {  73,4523 }, {  74,4523 }, {  75,4523 }, {  76,4523 }, {  77,4523 },
 {  78,4523 }, {  79,4523 }, {  80,4523 }, {  81,4523 }, {  82,4523 },
 {  83,4523 }, {  84,4523 }, {  85,4523 }, {  86,4523 }, {  87,4523 },
 {  88,4523 }, {  89,4523 }, {  90,4523 }, {  91,4523 }, {  92,4523 },
 {  93,4523 }, {  94,4523 }, {  95,4523 }, {  96,4523 }, {  97,4523 },
 {  98,4523 }, {  99,4523 }, { 100,4523 }, { 101,4523 }, { 102,4523 },
 { 103,4523 }, { 104,4523 }, { 105,4523 }, { 106,4523 }, { 107,4523 },
 { 108,4523 }, { 109,4523 }, { 110,4523 }, { 111,4523 }, { 112,4523 },
 { 113,4523 }, { 114,4523 }, { 115,4523 }, { 116,4523 }, { 117,4523 },

 { 118,4523 }, { 119,4523 }, { 120,4523 }, { 121,4523 }, { 122,4523 },
 { 123,4523 }, { 124,4523 }, { 125,4523 }, { 126,4523 }, { 127,4523 },
 { 128,4523 }, { 129,4523 }, { 130,4523 }, { 131,4523 }, { 132,4523 },
 { 133,4523 }, { 134,4523 }, { 135,4523 }, { 136,4523 }, { 137,4523 },
 { 138,4523 }, { 139,4523 }, { 140,4523 }, { 141,4523 }, { 142,4523 },
 { 143,4523 }, { 144,4523 }, { 145,4523 }, { 146,4523 }, { 147,4523 },
 { 148,4523 }, { 149,4523 }, { 150,4523 }, { 151,4523 }, { 152,4523 },
 { 153,4523 }, { 154,4523 }, { 155,4523 }, { 156,4523 }, { 157,4523 },
 { 158,4523 }, { 159,4523 }, { 160,4523 }, { 161,4523 }, { 162,4523 },
 { 163,4523 }, { 164,4523 }, { 165,4523 }, { 166,4523 }, { 167,4523 },

 { 168,4523 }, { 169,4523 }, { 170,4523 }, { 171,4523 }, { 172,4523 },
 { 173,4523 }, { 174,4523 }, { 175,4523 }, { 176,4523 }, { 177,4523 },
 { 178,4523 }, { 179,4523 }, { 180,4523 }, { 181,4523 }, { 182,4523 },
 { 183,4523 }, { 184,4523 }, { 185,4523 }, { 186,4523 }, { 187,4523 },
 { 188,4523 }, { 189,4523 }, { 190,4523 }, { 191,4523 }, { 192,4523 },
 { 193,4523 }, { 194,4523 }, { 195,4523 }, { 196,4523 }, { 197,4523 },
 { 198,4523 }, { 199,4523 }, { 200,4523 }, { 201,4523 }, { 202,4523 },
 { 203,4523 }, { 204,4523 }, { 205,4523 }, { 206,4523 }, { 207,4523 },
 { 208,4523 }, { 209,4523 }, { 210,4523 }, { 211,4523 }, { 212,4523 },
 { 213,4523 }, { 214,4523 }, { 215,4523 }, { 216,4523 }, { 217,4523 },

 { 218,4523 }, { 219,4523 }, { 220,4523 }, { 221,4523 }, { 222,4523 },
 { 223,4523 }, { 224,4523 }, { 225,4523 }, { 226,4523 }, { 227,4523 },
 { 228,4523 }, { 229,4523 }, { 230,4523 }, { 231,4523 }, { 232,4523 },
 { 233,4523 }, { 234,4523 }, { 235,4523 }, { 236,4523 }, { 237,4523 },
 { 238,4523 }, { 239,4523 }, { 240,4523 }, { 241,4523 }, { 242,4523 },
 { 243,4523 }, { 244,4523 }, { 245,4523 }, { 246,4523 }, { 247,4523 },
 { 248,4523 }, { 249,4523 }, { 250,4523 }, { 251,4523 }, { 252,4523 },
 { 253,4523 }, { 254,4523 }, { 255,4523 }, { 256,4523 }, {   0,  24 },
 {   0,13450 }, {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 },
 {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9, 258 },

 {  10,-7084 }, {  11,   0 }, {  12, 258 }, {  13,-7084 }, {  14,   0 },
 {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 },
 {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 },
 {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 },
 {  30,   0 }, {  31,   0 }, {  32, 258 }, {  33,   0 }, {  34,   0 },
 {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 },
 {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 },
 {  45, 516 }, {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 },

 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 },
 {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },

 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 },
 { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },

 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },

 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, { 256,   0 }, {   0,  24 }, {   0,13192 }, {   1,-258 },

 {   2,-258 }, {   3,-258 }, {   4,-258 }, {   5,-258 }, {   6,-258 },
 {   7,-258 }, {   8,-258 }, {   9,   0 }, {  10,-7342 }, {  11,-258 },
 {  12,   0 }, {  13,-7342 }, {  14,-258 }, {  15,-258 }, {  16,-258 },
 {  17,-258 }, {  18,-258 }, {  19,-258 }, {  20,-258 }, {  21,-258 },
 {  22,-258 }, {  23,-258 }, {  24,-258 }, {  25,-258 }, {  26,-258 },
 {  27,-258 }, {  28,-258 }, {  29,-258 }, {  30,-258 }, {  31,-258 },
 {  32,   0 }, {  33,-258 }, {  34,-258 }, {  35,-258 }, {  36,-258 },
 {  37,-258 }, {  38,-258 }, {  39,-258 }, {  40,-258 }, {  41,-258 },
 {  42,-258 }, {  43,-258 }, {  44,-258 }, {  45, 258 }, {  46,-258 },
 {  47,-258 }, {  48,-258 }, {  49,-258 }, {  50,-258 }, {  51,-258 },

 {  52,-258 }, {  53,-258 }, {  54,-258 }, {  55,-258 }, {  56,-258 },
 {  57,-258 }, {  58,-258 }, {  59,-258 }, {  60,-258 }, {  61,-258 },
 {  62,-258 }, {  63,-258 }, {  64,-258 }, {  65,-258 }, {  66,-258 },
 {  67,-258 }, {  68,-258 }, {  69,-258 }, {  70,-258 }, {  71,-258 },
 {  72,-258 }, {  73,-258 }, {  74,-258 }, {  75,-258 }, {  76,-258 },
 {  77,-258 }, {  78,-258 }, {  79,-258 }, {  80,-258 }, {  81,-258 },
 {  82,-258 }, {  83,-258 }, {  84,-258 }, {  85,-258 }, {  86,-258 },
 {  87,-258 }, {  88,-258 }, {  89,-258 }, {  90,-258 }, {  91,-258 },
 {  92,-258 }, {  93,-258 }, {  94,-258 }, {  95,-258 }, {  96,-258 },
 {  97,-258 }, {  98,-258 }, {  99,-258 }, { 100,-258 }, { 101,-258 },

 { 102,-258 }, { 103,-258 }, { 104,-258 }, { 105,-258 }, { 106,-258 },
 { 107,-258 }, { 108,-258 }, { 109,-258 }, { 110,-258 }, { 111,-258 },
 { 112,-258 }, { 113,-258 }, { 114,-258 }, { 115,-258 }, { 116,-258 },
 { 117,-258 }, { 118,-258 }, { 119,-258 }, { 120,-258 }, { 121,-258 },
 { 122,-258 }, { 123,-258 }, { 124,-258 }, { 125,-258 }, { 126,-258 },
 { 127,-258 }, { 128,-258 }, { 129,-258 }, { 130,-258 }, { 131,-258 },
 { 132,-258 }, { 133,-258 }, { 134,-258 }, { 135,-258 }, { 136,-258 },
 { 137,-258 }, { 138,-258 }, { 139,-258 }, { 140,-258 }, { 141,-258 },
 { 142,-258 }, { 143,-258 }, { 144,-258 }, { 145,-258 }, { 146,-258 },
 { 147,-258 }, { 148,-258 }, { 149,-258 }, { 150,-258 }, { 151,-258 },

 { 152,-258 }, { 153,-258 }, { 154,-258 }, { 155,-258 }, { 156,-258 },
 { 157,-258 }, { 158,-258 }, { 159,-258 }, { 160,-258 }, { 161,-258 },
 { 162,-258 }, { 163,-258 }, { 164,-258 }, { 165,-258 }, { 166,-258 },
 { 167,-258 }, { 168,-258 }, { 169,-258 }, { 170,-258 }, { 171,-258 },
 { 172,-258 }, { 173,-258 }, { 174,-258 }, { 175,-258 }, { 176,-258 },
 { 177,-258 }, { 178,-258 }, { 179,-258 }, { 180,-258 }, { 181,-258 },
 { 182,-258 }, { 183,-258 }, { 184,-258 }, { 185,-258 }, { 186,-258 },
 { 187,-258 }, { 188,-258 }, { 189,-258 }, { 190,-258 }, { 191,-258 },
 { 192,-258 }, { 193,-258 }, { 194,-258 }, { 195,-258 }, { 196,-258 },
 { 197,-258 }, { 198,-258 }, { 199,-258 }, { 200,-258 }, { 201,-258 },

 { 202,-258 }, { 203,-258 }, { 204,-258 }, { 205,-258 }, { 206,-258 },
 { 207,-258 }, { 208,-258 }, { 209,-258 }, { 210,-258 }, { 211,-258 },
 { 212,-258 }, { 213,-258 }, { 214,-258 }, { 215,-258 }, { 216,-258 },
 { 217,-258 }, { 218,-258 }, { 219,-258 }, { 220,-258 }, { 221,-258 },
 { 222,-258 }, { 223,-258 }, { 224,-258 }, { 225,-258 }, { 226,-258 },
 { 227,-258 }, { 228,-258 }, { 229,-258 }, { 230,-258 }, { 231,-258 },
 { 232,-258 }, { 233,-258 }, { 234,-258 }, { 235,-258 }, { 236,-258 },
 { 237,-258 }, { 238,-258 }, { 239,-258 }, { 240,-258 }, { 241,-258 },
 { 242,-258 }, { 243,-258 }, { 244,-258 }, { 245,-258 }, { 246,-258 },
 { 247,-258 }, { 248,-258 }, { 249,-258 }, { 250,-258 }, { 251,-258 },

 { 252,-258 }, { 253,-258 }, { 254,-258 }, { 255,-258 }, { 256,-258 },
 {   0,  24 }, {   0,12934 }, {   1,-516 }, {   2,-516 }, {   3,-516 },
 {   4,-516 }, {   5,-516 }, {   6,-516 }, {   7,-516 }, {   8,-516 },
 {   9,-258 }, {  10,-7600 }, {  11,-516 }, {  12,-258 }, {  13,-7600 },
 {  14,-516 }, {  15,-516 }, {  16,-516 }, {  17,-516 }, {  18,-516 },
 {  19,-516 }, {  20,-516 }, {  21,-516 }, {  22,-516 }, {  23,-516 },
 {  24,-516 }, {  25,-516 }, {  26,-516 }, {  27,-516 }, {  28,-516 },
 {  29,-516 }, {  30,-516 }, {  31,-516 }, {  32,-258 }, {  33,-516 },
 {  34,-516 }, {  35,-516 }, {  36,-516 }, {  37,-516 }, {  38,-516 },
 {  39,-516 }, {  40,-516 }, {  41,-516 }, {  42,-516 }, {  43,-516 },

 {  44,-516 }, {  45,4570 }, {  46,-516 }, {  47,-516 }, {  48,-516 },
 {  49,-516 }, {  50,-516 }, {  51,-516 }, {  52,-516 }, {  53,-516 },
 {  54,-516 }, {  55,-516 }, {  56,-516 }, {  57,-516 }, {  58,-516 },
 {  59,-516 }, {  60,-516 }, {  61,-516 }, {  62,-516 }, {  63,-516 },
 {  64,-516 }, {  65,-516 }, {  66,-516 }, {  67,-516 }, {  68,-516 },
 {  69,-516 }, {  70,-516 }, {  71,-516 }, {  72,-516 }, {  73,-516 },
 {  74,-516 }, {  75,-516 }, {  76,-516 }, {  77,-516 }, {  78,-516 },
 {  79,-516 }, {  80,-516 }, {  81,-516 }, {  82,-516 }, {  83,-516 },
 {  84,-516 }, {  85,-516 }, {  86,-516 }, {  87,-516 }, {  88,-516 },
 {  89,-516 }, {  90,-516 }, {  91,-516 }, {  92,-516 }, {  93,-516 },

 {  94,-516 }, {  95,-516 }, {  96,-516 }, {  97,-516 }, {  98,-516 },
 {  99,-516 }, { 100,-516 }, { 101,-516 }, { 102,-516 }, { 103,-516 },
 { 104,-516 }, { 105,-516 }, { 106,-516 }, { 107,-516 }, { 108,-516 },
 { 109,-516 }, { 110,-516 }, { 111,-516 }, { 112,-516 }, { 113,-516 },
 { 114,-516 }, { 115,-516 }, { 116,-516 }, { 117,-516 }, { 118,-516 },
 { 119,-516 }, { 120,-516 }, { 121,-516 }, { 122,-516 }, { 123,-516 },
 { 124,-516 }, { 125,-516 }, { 126,-516 }, { 127,-516 }, { 128,-516 },
 { 129,-516 }, { 130,-516 }, { 131,-516 }, { 132,-516 }, { 133,-516 },
 { 134,-516 }, { 135,-516 }, { 136,-516 }, { 137,-516 }, { 138,-516 },
 { 139,-516 }, { 140,-516 }, { 141,-516 }, { 142,-516 }, { 143,-516 },

 { 144,-516 }, { 145,-516 }, { 146,-516 }, { 147,-516 }, { 148,-516 },
 { 149,-516 }, { 150,-516 }, { 151,-516 }, { 152,-516 }, { 153,-516 },
 { 154,-516 }, { 155,-516 }, { 156,-516 }, { 157,-516 }, { 158,-516 },
 { 159,-516 }, { 160,-516 }, { 161,-516 }, { 162,-516 }, { 163,-516 },
 { 164,-516 }, { 165,-516 }, { 166,-516 }, { 167,-516 }, { 168,-516 },
 { 169,-516 }, { 170,-516 }, { 171,-516 }, { 172,-516 }, { 173,-516 },
 { 174,-516 }, { 175,-516 }, { 176,-516 }, { 177,-516 }, { 178,-516 },
 { 179,-516 }, { 180,-516 }, { 181,-516 }, { 182,-516 }, { 183,-516 },
 { 184,-516 }, { 185,-516 }, { 186,-516 }, { 187,-516 }, { 188,-516 },
 { 189,-516 }, { 190,-516 }, { 191,-516 }, { 192,-516 }, { 193,-516 },

 { 194,-516 }, { 195,-516 }, { 196,-516 }, { 197,-516 }, { 198,-516 },
 { 199,-516 }, { 200,-516 }, { 201,-516 }, { 202,-516 }, { 203,-516 },
 { 204,-516 }, { 205,-516 }, { 206,-516 }, { 207,-516 }, { 208,-516 },
 { 209,-516 }, { 210,-516 }, { 211,-516 }, { 212,-516 }, { 213,-516 },
 { 214,-516 }, { 215,-516 }, { 216,-516 }, { 217,-516 }, { 218,-516 },
 { 219,-516 }, { 220,-516 }, { 221,-516 }, { 222,-516 }, { 223,-516 },
 { 224,-516 }, { 225,-516 }, { 226,-516 }, { 227,-516 }, { 228,-516 },
 { 229,-516 }, { 230,-516 }, { 231,-516 }, { 232,-516 }, { 233,-516 },
 { 234,-516 }, { 235,-516 }, { 236,-516 }, { 237,-516 }, { 238,-516 },
 { 239,-516 }, { 240,-516 }, { 241,-516 }, { 242,-516 }, { 243,-516 },

 { 244,-516 }, { 245,-516 }, { 246,-516 }, { 247,-516 }, { 248,-516 },
 { 249,-516 }, { 250,-516 }, { 251,-516 }, { 252,-516 }, { 253,-516 },
 { 254,-516 }, { 255,-516 }, { 256,-516 }, {   0,  37 }, {   0,12676 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  37 }, {   0,12653 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,4570 }, {  49,4570 }, {  50,4570 },
 {  51,4570 }, {  52,4570 }, {  53,4570 }, {  54,4570 }, {  55,4570 },
 {  56,4570 }, {  57,4570 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,4570 },
 {  66,4570 }, {  67,4570 }, {  68,4570 }, {  69,4570 }, {  70,4570 },
 {  48,4570 }, {  49,4570 }, {  50,4570 }, {  51,4570 }, {  52,4570 },
 {  53,4570 }, {  54,4570 }, {  55,4570 }, {  56,4570 }, {  57,4570 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  65,4570 }, {  66,4570 }, {  67,4570 },
 {  68,4570 }, {  69,4570 }, {  70,4570 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,4570 }, {  98,4570 }, {  99,4570 }, { 100,4570 },
 { 101,4570 }, { 102,4570 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,4570 },
 {  98,4570 }, {  99,4570 }, { 100,4570 }, { 101,4570 }, { 102,4570 },
 {   0,   9 }, {   0,12549 }, {   1,   0 }, {   2,   0 }, {   3,   0 },
 {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 },

 {   9, 258 }, {  10, 516 }, {  11,   0 }, {  12, 258 }, {  13, 516 },
 {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 },
 {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 },
 {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 },
 {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32, 258 }, {  33,   0 },
 {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 },
 {  39,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 },
 {  44,   0 }, {  45, 563 }, {  46,   0 }, {  47,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 },

 {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 },
 {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },
 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },
 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },
 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },
 {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 },
 {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },
 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },

 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },
 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },
 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 },
 { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 },
 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },
 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },
 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },
 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },

 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },
 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },
 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },
 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },
 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },
 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },
 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },

 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },
 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },
 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },
 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },
 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },
 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },
 { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,   9 }, {   0,12291 },

 {   1,-258 }, {   2,-258 }, {   3,-258 }, {   4,-258 }, {   5,-258 },
 {   6,-258 }, {   7,-258 }, {   8,-258 }, {   9,   0 }, {  10, 258 },
 {  11,-258 }, {  12,   0 }, {  13, 258 }, {  14,-258 }, {  15,-258 },
 {  16,-258 }, {  17,-258 }, {  18,-258 }, {  19,-258 }, {  20,-258 },
 {  21,-258 }, {  22,-258 }, {  23,-258 }, {  24,-258 }, {  25,-258 },
 {  26,-258 }, {  27,-258 }, {  28,-258 }, {  29,-258 }, {  30,-258 },
 {  31,-258 }, {  32,   0 }, {  33,-258 }, {  34,-258 }, {  35,-258 },
 {  36,-258 }, {  37,-258 }, {  38,-258 }, {  39,-258 }, {  40,-258 },
 {  41,-258 }, {  42,-258 }, {  43,-258 }, {  44,-258 }, {  45, 305 },
 {  46,-258 }, {  47,-258 }, {  48,-258 }, {  49,-258 }, {  50,-258 },

 {  51,-258 }, {  52,-258 }, {  53,-258 }, {  54,-258 }, {  55,-258 },
 {  56,-258 }, {  57,-258 }, {  58,-258 }, {  59,-258 }, {  60,-258 },
 {  61,-258 }, {  62,-258 }, {  63,-258 }, {  64,-258 }, {  65,-258 },
 {  66,-258 }, {  67,-258 }, {  68,-258 }, {  69,-258 }, {  70,-258 },
 {  71,-258 }, {  72,-258 }, {  73,-258 }, {  74,-258 }, {  75,-258 },
 {  76,-258 }, {  77,-258 }, {  78,-258 }, {  79,-258 }, {  80,-258 },
 {  81,-258 }, {  82,-258 }, {  83,-258 }, {  84,-258 }, {  85,-258 },
 {  86,-258 }, {  87,-258 }, {  88,-258 }, {  89,-258 }, {  90,-258 },
 {  91,-258 }, {  92,-258 }, {  93,-258 }, {  94,-258 }, {  95,-258 },
 {  96,-258 }, {  97,-258 }, {  98,-258 }, {  99,-258 }, { 100,-258 },

 { 101,-258 }, { 102,-258 }, { 103,-258 }, { 104,-258 }, { 105,-258 },
 { 106,-258 }, { 107,-258 }, { 108,-258 }, { 109,-258 }, { 110,-258 },
 { 111,-258 }, { 112,-258 }, { 113,-258 }, { 114,-258 }, { 115,-258 },
 { 116,-258 }, { 117,-258 }, { 118,-258 }, { 119,-258 }, { 120,-258 },
 { 121,-258 }, { 122,-258 }, { 123,-258 }, { 124,-258 }, { 125,-258 },
 { 126,-258 }, { 127,-258 }, { 128,-258 }, { 129,-258 }, { 130,-258 },
 { 131,-258 }, { 132,-258 }, { 133,-258 }, { 134,-258 }, { 135,-258 },
 { 136,-258 }, { 137,-258 }, { 138,-258 }, { 139,-258 }, { 140,-258 },
 { 141,-258 }, { 142,-258 }, { 143,-258 }, { 144,-258 }, { 145,-258 },
 { 146,-258 }, { 147,-258 }, { 148,-258 }, { 149,-258 }, { 150,-258 },

 { 151,-258 }, { 152,-258 }, { 153,-258 }, { 154,-258 }, { 155,-258 },
 { 156,-258 }, { 157,-258 }, { 158,-258 }, { 159,-258 }, { 160,-258 },
 { 161,-258 }, { 162,-258 }, { 163,-258 }, { 164,-258 }, { 165,-258 },
 { 166,-258 }, { 167,-258 }, { 168,-258 }, { 169,-258 }, { 170,-258 },
 { 171,-258 }, { 172,-258 }, { 173,-258 }, { 174,-258 }, { 175,-258 },
 { 176,-258 }, { 177,-258 }, { 178,-258 }, { 179,-258 }, { 180,-258 },
 { 181,-258 }, { 182,-258 }, { 183,-258 }, { 184,-258 }, { 185,-258 },
 { 186,-258 }, { 187,-258 }, { 188,-258 }, { 189,-258 }, { 190,-258 },
 { 191,-258 }, { 192,-258 }, { 193,-258 }, { 194,-258 }, { 195,-258 },
 { 196,-258 }, { 197,-258 }, { 198,-258 }, { 199,-258 }, { 200,-258 },

 { 201,-258 }, { 202,-258 }, { 203,-258 }, { 204,-258 }, { 205,-258 },
 { 206,-258 }, { 207,-258 }, { 208,-258 }, { 209,-258 }, { 210,-258 },
 { 211,-258 }, { 212,-258 }, { 213,-258 }, { 214,-258 }, { 215,-258 },
 { 216,-258 }, { 217,-258 }, { 218,-258 }, { 219,-258 }, { 220,-258 },
 { 221,-258 }, { 222,-258 }, { 223,-258 }, { 224,-258 }, { 225,-258 },
 { 226,-258 }, { 227,-258 }, { 228,-258 }, { 229,-258 }, { 230,-258 },
 { 231,-258 }, { 232,-258 }, { 233,-258 }, { 234,-258 }, { 235,-258 },
 { 236,-258 }, { 237,-258 }, { 238,-258 }, { 239,-258 }, { 240,-258 },
 { 241,-258 }, { 242,-258 }, { 243,-258 }, { 244,-258 }, { 245,-258 },
 { 246,-258 }, { 247,-258 }, { 248,-258 }, { 249,-258 }, { 250,-258 },

 { 251,-258 }, { 252,-258 }, { 253,-258 }, { 254,-258 }, { 255,-258 },
 { 256,-258 }, {   0,   9 }, {   0,12033 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   9,-7240 }, {  10,-7240 }, {   0,   0 }, {  12,-7240 },
 {  13,-7240 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  32,-7240 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  39,-17560 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  45,-17553 }, {   0,   9 }, {   0,11986 },
 {   1,-563 }, {   2,-563 }, {   3,-563 }, {   4,-563 }, {   5,-563 },
 {   6,-563 }, {   7,-563 }, {   8,-563 }, {   9,-305 }, {  10, -47 },
 {  11,-563 }, {  12,-305 }, {  13, -47 }, {  14,-563 }, {  15,-563 },
 {  16,-563 }, {  17,-563 }, {  18,-563 }, {  19,-563 }, {  20,-563 },
 {  21,-563 }, {  22,-563 }, {  23,-563 }, {  24,-563 }, {  25,-563 },
 {  26,-563 }, {  27,-563 }, {  28,-563 }, {  29,-563 }, {  30,-563 },
 {  31,-563 }, {  32,-305 }, {  33,-563 }, {  34,-563 }, {  35,-563 },
 {  36,-563 }, {  37,-563 }, {  38,-563 }, {  39,-563 }, {  40,-563 },
 {  41,-563 }, {  42,-563 }, {  43,-563 }, {  44,-563 }, {  45,4007 },

 {  46,-563 }, {  47,-563 }, {  48,-563 }, {  49,-563 }, {  50,-563 },
 {  51,-563 }, {  52,-563 }, {  53,-563 }, {  54,-563 }, {  55,-563 },
 {  56,-563 }, {  57,-563 }, {  58,-563 }, {  59,-563 }, {  60,-563 },
 {  61,-563 }, {  62,-563 }, {  63,-563 }, {  64,-563 }, {  65,-563 },
 {  66,-563 }, {  67,-563 }, {  68,-563 }, {  69,-563 }, {  70,-563 },
 {  71,-563 }, {  72,-563 }, {  73,-563 }, {  74,-563 }, {  75,-563 },
 {  76,-563 }, {  77,-563 }, {  78,-563 }, {  79,-563 }, {  80,-563 },
 {  81,-563 }, {  82,-563 }, {  83,-563 }, {  84,-563 }, {  85,-563 },
 {  86,-563 }, {  87,-563 }, {  88,-563 }, {  89,-563 }, {  90,-563 },
 {  91,-563 }, {  92,-563 }, {  93,-563 }, {  94,-563 }, {  95,-563 },

 {  96,-563 }, {  97,-563 }, {  98,-563 }, {  99,-563 }, { 100,-563 },
 { 101,-563 }, { 102,-563 }, { 103,-563 }, { 104,-563 }, { 105,-563 },
 { 106,-563 }, { 107,-563 }, { 108,-563 }, { 109,-563 }, { 110,-563 },
 { 111,-563 }, { 112,-563 }, { 113,-563 }, { 114,-563 }, { 115,-563 },
 { 116,-563 }, { 117,-563 }, { 118,-563 }, { 119,-563 }, { 120,-563 },
 { 121,-563 }, { 122,-563 }, { 123,-563 }, { 124,-563 }, { 125,-563 },
 { 126,-563 }, { 127,-563 }, { 128,-563 }, { 129,-563 }, { 130,-563 },
 { 131,-563 }, { 132,-563 }, { 133,-563 }, { 134,-563 }, { 135,-563 },
 { 136,-563 }, { 137,-563 }, { 138,-563 }, { 139,-563 }, { 140,-563 },
 { 141,-563 }, { 142,-563 }, { 143,-563 }, { 144,-563 }, { 145,-563 },

 { 146,-563 }, { 147,-563 }, { 148,-563 }, { 149,-563 }, { 150,-563 },
 { 151,-563 }, { 152,-563 }, { 153,-563 }, { 154,-563 }, { 155,-563 },
 { 156,-563 }, { 157,-563 }, { 158,-563 }, { 159,-563 }, { 160,-563 },
 { 161,-563 }, { 162,-563 }, { 163,-563 }, { 164,-563 }, { 165,-563 },
 { 166,-563 }, { 167,-563 }, { 168,-563 }, { 169,-563 }, { 170,-563 },
 { 171,-563 }, { 172,-563 }, { 173,-563 }, { 174,-563 }, { 175,-563 },
 { 176,-563 }, { 177,-563 }, { 178,-563 }, { 179,-563 }, { 180,-563 },
 { 181,-563 }, { 182,-563 }, { 183,-563 }, { 184,-563 }, { 185,-563 },
 { 186,-563 }, { 187,-563 }, { 188,-563 }, { 189,-563 }, { 190,-563 },
 { 191,-563 }, { 192,-563 }, { 193,-563 }, { 194,-563 }, { 195,-563 },

 { 196,-563 }, { 197,-563 }, { 198,-563 }, { 199,-563 }, { 200,-563 },
 { 201,-563 }, { 202,-563 }, { 203,-563 }, { 204,-563 }, { 205,-563 },
 { 206,-563 }, { 207,-563 }, { 208,-563 }, { 209,-563 }, { 210,-563 },
 { 211,-563 }, { 212,-563 }, { 213,-563 }, { 214,-563 }, { 215,-563 },
 { 216,-563 }, { 217,-563 }, { 218,-563 }, { 219,-563 }, { 220,-563 },
 { 221,-563 }, { 222,-563 }, { 223,-563 }, { 224,-563 }, { 225,-563 },
 { 226,-563 }, { 227,-563 }, { 228,-563 }, { 229,-563 }, { 230,-563 },
 { 231,-563 }, { 232,-563 }, { 233,-563 }, { 234,-563 }, { 235,-563 },
 { 236,-563 }, { 237,-563 }, { 238,-563 }, { 239,-563 }, { 240,-563 },
 { 241,-563 }, { 242,-563 }, { 243,-563 }, { 244,-563 }, { 245,-563 },

 { 246,-563 }, { 247,-563 }, { 248,-563 }, { 249,-563 }, { 250,-563 },
 { 251,-563 }, { 252,-563 }, { 253,-563 }, { 254,-563 }, { 255,-563 },
 { 256,-563 }, {   0,   9 }, {   0,11728 }, {   1,-4945 }, {   2,-4945 },
 {   3,-4945 }, {   4,-4945 }, {   5,-4945 }, {   6,-4945 }, {   7,-4945 },
 {   8,-4945 }, {   9,-4687 }, {  10,-11326 }, {  11,-4945 }, {  12,-4687 },
 {  13,-11326 }, {  14,-4945 }, {  15,-4945 }, {  16,-4945 }, {  17,-4945 },
 {  18,-4945 }, {  19,-4945 }, {  20,-4945 }, {  21,-4945 }, {  22,-4945 },
 {  23,-4945 }, {  24,-4945 }, {  25,-4945 }, {  26,-4945 }, {  27,-4945 },
 {  28,-4945 }, {  29,-4945 }, {  30,-4945 }, {  31,-4945 }, {  32,-4687 },
 {  33,-4945 }, {  34,-4945 }, {  35,-4945 }, {  36,-4945 }, {  37,-4945 },

 {  38,-4945 }, {  39,-4945 }, {  40,-4945 }, {  41,-4945 }, {  42,-4945 },
 {  43,-4945 }, {  44,-4945 }, {  45,   0 }, {  46,-4945 }, {  47,-4945 },
 {  48,-4945 }, {  49,-4945 }, {  50,-4945 }, {  51,-4945 }, {  52,-4945 },
 {  53,-4945 }, {  54,-4945 }, {  55,-4945 }, {  56,-4945 }, {  57,-4945 },
 {  58,-4945 }, {  59,-4945 }, {  60,-4945 }, {  61,-4945 }, {  62,-4945 },
 {  63,-4945 }, {  64,-4945 }, {  65,-4945 }, {  66,-4945 }, {  67,-4945 },
 {  68,-4945 }, {  69,-4945 }, {  70,-4945 }, {  71,-4945 }, {  72,-4945 },
 {  73,-4945 }, {  74,-4945 }, {  75,-4945 }, {  76,-4945 }, {  77,-4945 },
 {  78,-4945 }, {  79,-4945 }, {  80,-4945 }, {  81,-4945 }, {  82,-4945 },
 {  83,-4945 }, {  84,-4945 }, {  85,-4945 }, {  86,-4945 }, {  87,-4945 },

 {  88,-4945 }, {  89,-4945 }, {  90,-4945 }, {  91,-4945 }, {  92,-4945 },
 {  93,-4945 }, {  94,-4945 }, {  95,-4945 }, {  96,-4945 }, {  97,-4945 },
 {  98,-4945 }, {  99,-4945 }, { 100,-4945 }, { 101,-4945 }, { 102,-4945 },
 { 103,-4945 }, { 104,-4945 }, { 105,-4945 }, { 106,-4945 }, { 107,-4945 },
 { 108,-4945 }, { 109,-4945 }, { 110,-4945 }, { 111,-4945 }, { 112,-4945 },
 { 113,-4945 }, { 114,-4945 }, { 115,-4945 }, { 116,-4945 }, { 117,-4945 },
 { 118,-4945 }, { 119,-4945 }, { 120,-4945 }, { 121,-4945 }, { 122,-4945 },
 { 123,-4945 }, { 124,-4945 }, { 125,-4945 }, { 126,-4945 }, { 127,-4945 },
 { 128,-4945 }, { 129,-4945 }, { 130,-4945 }, { 131,-4945 }, { 132,-4945 },
 { 133,-4945 }, { 134,-4945 }, { 135,-4945 }, { 136,-4945 }, { 137,-4945 },

 { 138,-4945 }, { 139,-4945 }, { 140,-4945 }, { 141,-4945 }, { 142,-4945 },
 { 143,-4945 }, { 144,-4945 }, { 145,-4945 }, { 146,-4945 }, { 147,-4945 },
 { 148,-4945 }, { 149,-4945 }, { 150,-4945 }, { 151,-4945 }, { 152,-4945 },
 { 153,-4945 }, { 154,-4945 }, { 155,-4945 }, { 156,-4945 }, { 157,-4945 },
 { 158,-4945 }, { 159,-4945 }, { 160,-4945 }, { 161,-4945 }, { 162,-4945 },
 { 163,-4945 }, { 164,-4945 }, { 165,-4945 }, { 166,-4945 }, { 167,-4945 },
 { 168,-4945 }, { 169,-4945 }, { 170,-4945 }, { 171,-4945 }, { 172,-4945 },
 { 173,-4945 }, { 174,-4945 }, { 175,-4945 }, { 176,-4945 }, { 177,-4945 },
 { 178,-4945 }, { 179,-4945 }, { 180,-4945 }, { 181,-4945 }, { 182,-4945 },
 { 183,-4945 }, { 184,-4945 }, { 185,-4945 }, { 186,-4945 }, { 187,-4945 },

 { 188,-4945 }, { 189,-4945 }, { 190,-4945 }, { 191,-4945 }, { 192,-4945 },
 { 193,-4945 }, { 194,-4945 }, { 195,-4945 }, { 196,-4945 }, { 197,-4945 },
 { 198,-4945 }, { 199,-4945 }, { 200,-4945 }, { 201,-4945 }, { 202,-4945 },
 { 203,-4945 }, { 204,-4945 }, { 205,-4945 }, { 206,-4945 }, { 207,-4945 },
 { 208,-4945 }, { 209,-4945 }, { 210,-4945 }, { 211,-4945 }, { 212,-4945 },
 { 213,-4945 }, { 214,-4945 }, { 215,-4945 }, { 216,-4945 }, { 217,-4945 },
 { 218,-4945 }, { 219,-4945 }, { 220,-4945 }, { 221,-4945 }, { 222,-4945 },
 { 223,-4945 }, { 224,-4945 }, { 225,-4945 }, { 226,-4945 }, { 227,-4945 },
 { 228,-4945 }, { 229,-4945 }, { 230,-4945 }, { 231,-4945 }, { 232,-4945 },
 { 233,-4945 }, { 234,-4945 }, { 235,-4945 }, { 236,-4945 }, { 237,-4945 },

 { 238,-4945 }, { 239,-4945 }, { 240,-4945 }, { 241,-4945 }, { 242,-4945 },
 { 243,-4945 }, { 244,-4945 }, { 245,-4945 }, { 246,-4945 }, { 247,-4945 },
 { 248,-4945 }, { 249,-4945 }, { 250,-4945 }, { 251,-4945 }, { 252,-4945 },
 { 253,-4945 }, { 254,-4945 }, { 255,-4945 }, { 256,-4945 }, {   0,  16 },
 {   0,11470 }, {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 },
 {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9, 258 },
 {  10, 516 }, {  11,   0 }, {  12, 258 }, {  13, 516 }, {  14,   0 },
 {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 },
 {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 },
 {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 },

 {  30,   0 }, {  31,   0 }, {  32, 258 }, {  33,   0 }, {  34,   0 },
 {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 },
 {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 },
 {  45, 563 }, {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },

 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 },
 {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 },
 { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 },

 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },

 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },

 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, { 256,   0 }, {   0,  16 }, {   0,11212 }, {   1,-258 },
 {   2,-258 }, {   3,-258 }, {   4,-258 }, {   5,-258 }, {   6,-258 },
 {   7,-258 }, {   8,-258 }, {   9,   0 }, {  10, 258 }, {  11,-258 },
 {  12,   0 }, {  13, 258 }, {  14,-258 }, {  15,-258 }, {  16,-258 },
 {  17,-258 }, {  18,-258 }, {  19,-258 }, {  20,-258 }, {  21,-258 },

 {  22,-258 }, {  23,-258 }, {  24,-258 }, {  25,-258 }, {  26,-258 },
 {  27,-258 }, {  28,-258 }, {  29,-258 }, {  30,-258 }, {  31,-258 },
 {  32,   0 }, {  33,-258 }, {  34,-258 }, {  35,-258 }, {  36,-258 },
 {  37,-258 }, {  38,-258 }, {  39,-258 }, {  40,-258 }, {  41,-258 },
 {  42,-258 }, {  43,-258 }, {  44,-258 }, {  45, 305 }, {  46,-258 },
 {  47,-258 }, {  48,-258 }, {  49,-258 }, {  50,-258 }, {  51,-258 },
 {  52,-258 }, {  53,-258 }, {  54,-258 }, {  55,-258 }, {  56,-258 },
 {  57,-258 }, {  58,-258 }, {  59,-258 }, {  60,-258 }, {  61,-258 },
 {  62,-258 }, {  63,-258 }, {  64,-258 }, {  65,-258 }, {  66,-258 },
 {  67,-258 }, {  68,-258 }, {  69,-258 }, {  70,-258 }, {  71,-258 },

 {  72,-258 }, {  73,-258 }, {  74,-258 }, {  75,-258 }, {  76,-258 },
 {  77,-258 }, {  78,-258 }, {  79,-258 }, {  80,-258 }, {  81,-258 },
 {  82,-258 }, {  83,-258 }, {  84,-258 }, {  85,-258 }, {  86,-258 },
 {  87,-258 }, {  88,-258 }, {  89,-258 }, {  90,-258 }, {  91,-258 },
 {  92,-258 }, {  93,-258 }, {  94,-258 }, {  95,-258 }, {  96,-258 },
 {  97,-258 }, {  98,-258 }, {  99,-258 }, { 100,-258 }, { 101,-258 },
 { 102,-258 }, { 103,-258 }, { 104,-258 }, { 105,-258 }, { 106,-258 },
 { 107,-258 }, { 108,-258 }, { 109,-258 }, { 110,-258 }, { 111,-258 },
 { 112,-258 }, { 113,-258 }, { 114,-258 }, { 115,-258 }, { 116,-258 },
 { 117,-258 }, { 118,-258 }, { 119,-258 }, { 120,-258 }, { 121,-258 },

 { 122,-258 }, { 123,-258 }, { 124,-258 }, { 125,-258 }, { 126,-258 },
 { 127,-258 }, { 128,-258 }, { 129,-258 }, { 130,-258 }, { 131,-258 },
 { 132,-258 }, { 133,-258 }, { 134,-258 }, { 135,-258 }, { 136,-258 },
 { 137,-258 }, { 138,-258 }, { 139,-258 }, { 140,-258 }, { 141,-258 },
 { 142,-258 }, { 143,-258 }, { 144,-258 }, { 145,-258 }, { 146,-258 },
 { 147,-258 }, { 148,-258 }, { 149,-258 }, { 150,-258 }, { 151,-258 },
 { 152,-258 }, { 153,-258 }, { 154,-258 }, { 155,-258 }, { 156,-258 },
 { 157,-258 }, { 158,-258 }, { 159,-258 }, { 160,-258 }, { 161,-258 },
 { 162,-258 }, { 163,-258 }, { 164,-258 }, { 165,-258 }, { 166,-258 },
 { 167,-258 }, { 168,-258 }, { 169,-258 }, { 170,-258 }, { 171,-258 },

 { 172,-258 }, { 173,-258 }, { 174,-258 }, { 175,-258 }, { 176,-258 },
 { 177,-258 }, { 178,-258 }, { 179,-258 }, { 180,-258 }, { 181,-258 },
 { 182,-258 }, { 183,-258 }, { 184,-258 }, { 185,-258 }, { 186,-258 },
 { 187,-258 }, { 188,-258 }, { 189,-258 }, { 190,-258 }, { 191,-258 },
 { 192,-258 }, { 193,-258 }, { 194,-258 }, { 195,-258 }, { 196,-258 },
 { 197,-258 }, { 198,-258 }, { 199,-258 }, { 200,-258 }, { 201,-258 },
 { 202,-258 }, { 203,-258 }, { 204,-258 }, { 205,-258 }, { 206,-258 },
 { 207,-258 }, { 208,-258 }, { 209,-258 }, { 210,-258 }, { 211,-258 },
 { 212,-258 }, { 213,-258 }, { 214,-258 }, { 215,-258 }, { 216,-258 },
 { 217,-258 }, { 218,-258 }, { 219,-258 }, { 220,-258 }, { 221,-258 },

 { 222,-258 }, { 223,-258 }, { 224,-258 }, { 225,-258 }, { 226,-258 },
 { 227,-258 }, { 228,-258 }, { 229,-258 }, { 230,-258 }, { 231,-258 },
 { 232,-258 }, { 233,-258 }, { 234,-258 }, { 235,-258 }, { 236,-258 },
 { 237,-258 }, { 238,-258 }, { 239,-258 }, { 240,-258 }, { 241,-258 },
 { 242,-258 }, { 243,-258 }, { 244,-258 }, { 245,-258 }, { 246,-258 },
 { 247,-258 }, { 248,-258 }, { 249,-258 }, { 250,-258 }, { 251,-258 },
 { 252,-258 }, { 253,-258 }, { 254,-258 }, { 255,-258 }, { 256,-258 },
 {   0,  16 }, {   0,10954 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   9,-8007 }, {  10,-8007 }, {   0,   0 }, {  12,-8007 }, {  13,-8007 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  32,-8007 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  39,-18630 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  45,-18625 }, {   0,  16 }, {   0,10907 }, {   1,-563 },
 {   2,-563 }, {   3,-563 }, {   4,-563 }, {   5,-563 }, {   6,-563 },
 {   7,-563 }, {   8,-563 }, {   9,-305 }, {  10, -47 }, {  11,-563 },
 {  12,-305 }, {  13, -47 }, {  14,-563 }, {  15,-563 }, {  16,-563 },

 {  17,-563 }, {  18,-563 }, {  19,-563 }, {  20,-563 }, {  21,-563 },
 {  22,-563 }, {  23,-563 }, {  24,-563 }, {  25,-563 }, {  26,-563 },
 {  27,-563 }, {  28,-563 }, {  29,-563 }, {  30,-563 }, {  31,-563 },
 {  32,-305 }, {  33,-563 }, {  34,-563 }, {  35,-563 }, {  36,-563 },
 {  37,-563 }, {  38,-563 }, {  39,-563 }, {  40,-563 }, {  41,-563 },
 {  42,-563 }, {  43,-563 }, {  44,-563 }, {  45,3186 }, {  46,-563 },
 {  47,-563 }, {  48,-563 }, {  49,-563 }, {  50,-563 }, {  51,-563 },
 {  52,-563 }, {  53,-563 }, {  54,-563 }, {  55,-563 }, {  56,-563 },
 {  57,-563 }, {  58,-563 }, {  59,-563 }, {  60,-563 }, {  61,-563 },
 {  62,-563 }, {  63,-563 }, {  64,-563 }, {  65,-563 }, {  66,-563 },

 {  67,-563 }, {  68,-563 }, {  69,-563 }, {  70,-563 }, {  71,-563 },
 {  72,-563 }, {  73,-563 }, {  74,-563 }, {  75,-563 }, {  76,-563 },
 {  77,-563 }, {  78,-563 }, {  79,-563 }, {  80,-563 }, {  81,-563 },
 {  82,-563 }, {  83,-563 }, {  84,-563 }, {  85,-563 }, {  86,-563 },
 {  87,-563 }, {  88,-563 }, {  89,-563 }, {  90,-563 }, {  91,-563 },
 {  92,-563 }, {  93,-563 }, {  94,-563 }, {  95,-563 }, {  96,-563 },
 {  97,-563 }, {  98,-563 }, {  99,-563 }, { 100,-563 }, { 101,-563 },
 { 102,-563 }, { 103,-563 }, { 104,-563 }, { 105,-563 }, { 106,-563 },
 { 107,-563 }, { 108,-563 }, { 109,-563 }, { 110,-563 }, { 111,-563 },
 { 112,-563 }, { 113,-563 }, { 114,-563 }, { 115,-563 }, { 116,-563 },

 { 117,-563 }, { 118,-563 }, { 119,-563 }, { 120,-563 }, { 121,-563 },
 { 122,-563 }, { 123,-563 }, { 124,-563 }, { 125,-563 }, { 126,-563 },
 { 127,-563 }, { 128,-563 }, { 129,-563 }, { 130,-563 }, { 131,-563 },
 { 132,-563 }, { 133,-563 }, { 134,-563 }, { 135,-563 }, { 136,-563 },
 { 137,-563 }, { 138,-563 }, { 139,-563 }, { 140,-563 }, { 141,-563 },
 { 142,-563 }, { 143,-563 }, { 144,-563 }, { 145,-563 }, { 146,-563 },
 { 147,-563 }, { 148,-563 }, { 149,-563 }, { 150,-563 }, { 151,-563 },
 { 152,-563 }, { 153,-563 }, { 154,-563 }, { 155,-563 }, { 156,-563 },
 { 157,-563 }, { 158,-563 }, { 159,-563 }, { 160,-563 }, { 161,-563 },
 { 162,-563 }, { 163,-563 }, { 164,-563 }, { 165,-563 }, { 166,-563 },

 { 167,-563 }, { 168,-563 }, { 169,-563 }, { 170,-563 }, { 171,-563 },
 { 172,-563 }, { 173,-563 }, { 174,-563 }, { 175,-563 }, { 176,-563 },
 { 177,-563 }, { 178,-563 }, { 179,-563 }, { 180,-563 }, { 181,-563 },
 { 182,-563 }, { 183,-563 }, { 184,-563 }, { 185,-563 }, { 186,-563 },
 { 187,-563 }, { 188,-563 }, { 189,-563 }, { 190,-563 }, { 191,-563 },
 { 192,-563 }, { 193,-563 }, { 194,-563 }, { 195,-563 }, { 196,-563 },
 { 197,-563 }, { 198,-563 }, { 199,-563 }, { 200,-563 }, { 201,-563 },
 { 202,-563 }, { 203,-563 }, { 204,-563 }, { 205,-563 }, { 206,-563 },
 { 207,-563 }, { 208,-563 }, { 209,-563 }, { 210,-563 }, { 211,-563 },
 { 212,-563 }, { 213,-563 }, { 214,-563 }, { 215,-563 }, { 216,-563 },

 { 217,-563 }, { 218,-563 }, { 219,-563 }, { 220,-563 }, { 221,-563 },
 { 222,-563 }, { 223,-563 }, { 224,-563 }, { 225,-563 }, { 226,-563 },
 { 227,-563 }, { 228,-563 }, { 229,-563 }, { 230,-563 }, { 231,-563 },
 { 232,-563 }, { 233,-563 }, { 234,-563 }, { 235,-563 }, { 236,-563 },
 { 237,-563 }, { 238,-563 }, { 239,-563 }, { 240,-563 }, { 241,-563 },
 { 242,-563 }, { 243,-563 }, { 244,-563 }, { 245,-563 }, { 246,-563 },
 { 247,-563 }, { 248,-563 }, { 249,-563 }, { 250,-563 }, { 251,-563 },
 { 252,-563 }, { 253,-563 }, { 254,-563 }, { 255,-563 }, { 256,-563 },
 {   0,  16 }, {   0,10649 }, {   1,-4992 }, {   2,-4992 }, {   3,-4992 },
 {   4,-4992 }, {   5,-4992 }, {   6,-4992 }, {   7,-4992 }, {   8,-4992 },

 {   9,-4734 }, {  10,-11451 }, {  11,-4992 }, {  12,-4734 }, {  13,-11451 },
 {  14,-4992 }, {  15,-4992 }, {  16,-4992 }, {  17,-4992 }, {  18,-4992 },
 {  19,-4992 }, {  20,-4992 }, {  21,-4992 }, {  22,-4992 }, {  23,-4992 },
 {  24,-4992 }, {  25,-4992 }, {  26,-4992 }, {  27,-4992 }, {  28,-4992 },
 {  29,-4992 }, {  30,-4992 }, {  31,-4992 }, {  32,-4734 }, {  33,-4992 },
 {  34,-4992 }, {  35,-4992 }, {  36,-4992 }, {  37,-4992 }, {  38,-4992 },
 {  39,-4992 }, {  40,-4992 }, {  41,-4992 }, {  42,-4992 }, {  43,-4992 },
 {  44,-4992 }, {  45,   0 }, {  46,-4992 }, {  47,-4992 }, {  48,-4992 },
 {  49,-4992 }, {  50,-4992 }, {  51,-4992 }, {  52,-4992 }, {  53,-4992 },
 {  54,-4992 }, {  55,-4992 }, {  56,-4992 }, {  57,-4992 }, {  58,-4992 },

 {  59,-4992 }, {  60,-4992 }, {  61,-4992 }, {  62,-4992 }, {  63,-4992 },
 {  64,-4992 }, {  65,-4992 }, {  66,-4992 }, {  67,-4992 }, {  68,-4992 },
 {  69,-4992 }, {  70,-4992 }, {  71,-4992 }, {  72,-4992 }, {  73,-4992 },
 {  74,-4992 }, {  75,-4992 }, {  76,-4992 }, {  77,-4992 }, {  78,-4992 },
 {  79,-4992 }, {  80,-4992 }, {  81,-4992 }, {  82,-4992 }, {  83,-4992 },
 {  84,-4992 }, {  85,-4992 }, {  86,-4992 }, {  87,-4992 }, {  88,-4992 },
 {  89,-4992 }, {  90,-4992 }, {  91,-4992 }, {  92,-4992 }, {  93,-4992 },
 {  94,-4992 }, {  95,-4992 }, {  96,-4992 }, {  97,-4992 }, {  98,-4992 },
 {  99,-4992 }, { 100,-4992 }, { 101,-4992 }, { 102,-4992 }, { 103,-4992 },
 { 104,-4992 }, { 105,-4992 }, { 106,-4992 }, { 107,-4992 }, { 108,-4992 },

 { 109,-4992 }, { 110,-4992 }, { 111,-4992 }, { 112,-4992 }, { 113,-4992 },
 { 114,-4992 }, { 115,-4992 }, { 116,-4992 }, { 117,-4992 }, { 118,-4992 },
 { 119,-4992 }, { 120,-4992 }, { 121,-4992 }, { 122,-4992 }, { 123,-4992 },
 { 124,-4992 }, { 125,-4992 }, { 126,-4992 }, { 127,-4992 }, { 128,-4992 },
 { 129,-4992 }, { 130,-4992 }, { 131,-4992 }, { 132,-4992 }, { 133,-4992 },
 { 134,-4992 }, { 135,-4992 }, { 136,-4992 }, { 137,-4992 }, { 138,-4992 },
 { 139,-4992 }, { 140,-4992 }, { 141,-4992 }, { 142,-4992 }, { 143,-4992 },
 { 144,-4992 }, { 145,-4992 }, { 146,-4992 }, { 147,-4992 }, { 148,-4992 },
 { 149,-4992 }, { 150,-4992 }, { 151,-4992 }, { 152,-4992 }, { 153,-4992 },
 { 154,-4992 }, { 155,-4992 }, { 156,-4992 }, { 157,-4992 }, { 158,-4992 },

 { 159,-4992 }, { 160,-4992 }, { 161,-4992 }, { 162,-4992 }, { 163,-4992 },
 { 164,-4992 }, { 165,-4992 }, { 166,-4992 }, { 167,-4992 }, { 168,-4992 },
 { 169,-4992 }, { 170,-4992 }, { 171,-4992 }, { 172,-4992 }, { 173,-4992 },
 { 174,-4992 }, { 175,-4992 }, { 176,-4992 }, { 177,-4992 }, { 178,-4992 },
 { 179,-4992 }, { 180,-4992 }, { 181,-4992 }, { 182,-4992 }, { 183,-4992 },
 { 184,-4992 }, { 185,-4992 }, { 186,-4992 }, { 187,-4992 }, { 188,-4992 },
 { 189,-4992 }, { 190,-4992 }, { 191,-4992 }, { 192,-4992 }, { 193,-4992 },
 { 194,-4992 }, { 195,-4992 }, { 196,-4992 }, { 197,-4992 }, { 198,-4992 },
 { 199,-4992 }, { 200,-4992 }, { 201,-4992 }, { 202,-4992 }, { 203,-4992 },
 { 204,-4992 }, { 205,-4992 }, { 206,-4992 }, { 207,-4992 }, { 208,-4992 },

 { 209,-4992 }, { 210,-4992 }, { 211,-4992 }, { 212,-4992 }, { 213,-4992 },
 { 214,-4992 }, { 215,-4992 }, { 216,-4992 }, { 217,-4992 }, { 218,-4992 },
 { 219,-4992 }, { 220,-4992 }, { 221,-4992 }, { 222,-4992 }, { 223,-4992 },
 { 224,-4992 }, { 225,-4992 }, { 226,-4992 }, { 227,-4992 }, { 228,-4992 },
 { 229,-4992 }, { 230,-4992 }, { 231,-4992 }, { 232,-4992 }, { 233,-4992 },
 { 234,-4992 }, { 235,-4992 }, { 236,-4992 }, { 237,-4992 }, { 238,-4992 },
 { 239,-4992 }, { 240,-4992 }, { 241,-4992 }, { 242,-4992 }, { 243,-4992 },
 { 244,-4992 }, { 245,-4992 }, { 246,-4992 }, { 247,-4992 }, { 248,-4992 },
 { 249,-4992 }, { 250,-4992 }, { 251,-4992 }, { 252,-4992 }, { 253,-4992 },
 { 254,-4992 }, { 255,-4992 }, { 256,-4992 }, {   0,  22 }, {   0,10391 },

 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },
 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9, 258 }, {  10, 516 },
 {  11,   0 }, {  12, 258 }, {  13, 516 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },
 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },
 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },
 {  31,   0 }, {  32, 258 }, {  33,   0 }, {  34,   0 }, {  35,   0 },
 {  36,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 },
 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45, 563 },
 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },

 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },
 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },
 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },

 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },
 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },
 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },

 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },
 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },

 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },
 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },

 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 { 256,   0 }, {   0,  22 }, {   0,10133 }, {   1,-258 }, {   2,-258 },
 {   3,-258 }, {   4,-258 }, {   5,-258 }, {   6,-258 }, {   7,-258 },
 {   8,-258 }, {   9,   0 }, {  10, 258 }, {  11,-258 }, {  12,   0 },
 {  13, 258 }, {  14,-258 }, {  15,-258 }, {  16,-258 }, {  17,-258 },
 {  18,-258 }, {  19,-258 }, {  20,-258 }, {  21,-258 }, {  22,-258 },
 {  23,-258 }, {  24,-258 }, {  25,-258 }, {  26,-258 }, {  27,-258 },
 {  28,-258 }, {  29,-258 }, {  30,-258 }, {  31,-258 }, {  32,   0 },
 {  33,-258 }, {  34,-258 }, {  35,-258 }, {  36,-258 }, {  37,-258 },
 {  38,-258 }, {  39,-258 }, {  40,-258 }, {  41,-258 }, {  42,-258 },

 {  43,-258 }, {  44,-258 }, {  45, 305 }, {  46,-258 }, {  47,-258 },
 {  48,-258 }, {  49,-258 }, {  50,-258 }, {  51,-258 }, {  52,-258 },
 {  53,-258 }, {  54,-258 }, {  55,-258 }, {  56,-258 }, {  57,-258 },
 {  58,-258 }, {  59,-258 }, {  60,-258 }, {  61,-258 }, {  62,-258 },
 {  63,-258 }, {  64,-258 }, {  65,-258 }, {  66,-258 }, {  67,-258 },
 {  68,-258 }, {  69,-258 }, {  70,-258 }, {  71,-258 }, {  72,-258 },
 {  73,-258 }, {  74,-258 }, {  75,-258 }, {  76,-258 }, {  77,-258 },
 {  78,-258 }, {  79,-258 }, {  80,-258 }, {  81,-258 }, {  82,-258 },
 {  83,-258 }, {  84,-258 }, {  85,-258 }, {  86,-258 }, {  87,-258 },
 {  88,-258 }, {  89,-258 }, {  90,-258 }, {  91,-258 }, {  92,-258 },

 {  93,-258 }, {  94,-258 }, {  95,-258 }, {  96,-258 }, {  97,-258 },
 {  98,-258 }, {  99,-258 }, { 100,-258 }, { 101,-258 }, { 102,-258 },
 { 103,-258 }, { 104,-258 }, { 105,-258 }, { 106,-258 }, { 107,-258 },
 { 108,-258 }, { 109,-258 }, { 110,-258 }, { 111,-258 }, { 112,-258 },
 { 113,-258 }, { 114,-258 }, { 115,-258 }, { 116,-258 }, { 117,-258 },
 { 118,-258 }, { 119,-258 }, { 120,-258 }, { 121,-258 }, { 122,-258 },
 { 123,-258 }, { 124,-258 }, { 125,-258 }, { 126,-258 }, { 127,-258 },
 { 128,-258 }, { 129,-258 }, { 130,-258 }, { 131,-258 }, { 132,-258 },
 { 133,-258 }, { 134,-258 }, { 135,-258 }, { 136,-258 }, { 137,-258 },
 { 138,-258 }, { 139,-258 }, { 140,-258 }, { 141,-258 }, { 142,-258 },

 { 143,-258 }, { 144,-258 }, { 145,-258 }, { 146,-258 }, { 147,-258 },
 { 148,-258 }, { 149,-258 }, { 150,-258 }, { 151,-258 }, { 152,-258 },
 { 153,-258 }, { 154,-258 }, { 155,-258 }, { 156,-258 }, { 157,-258 },
 { 158,-258 }, { 159,-258 }, { 160,-258 }, { 161,-258 }, { 162,-258 },
 { 163,-258 }, { 164,-258 }, { 165,-258 }, { 166,-258 }, { 167,-258 },
 { 168,-258 }, { 169,-258 }, { 170,-258 }, { 171,-258 }, { 172,-258 },
 { 173,-258 }, { 174,-258 }, { 175,-258 }, { 176,-258 }, { 177,-258 },
 { 178,-258 }, { 179,-258 }, { 180,-258 }, { 181,-258 }, { 182,-258 },
 { 183,-258 }, { 184,-258 }, { 185,-258 }, { 186,-258 }, { 187,-258 },
 { 188,-258 }, { 189,-258 }, { 190,-258 }, { 191,-258 }, { 192,-258 },

 { 193,-258 }, { 194,-258 }, { 195,-258 }, { 196,-258 }, { 197,-258 },
 { 198,-258 }, { 199,-258 }, { 200,-258 }, { 201,-258 }, { 202,-258 },
 { 203,-258 }, { 204,-258 }, { 205,-258 }, { 206,-258 }, { 207,-258 },
 { 208,-258 }, { 209,-258 }, { 210,-258 }, { 211,-258 }, { 212,-258 },
 { 213,-258 }, { 214,-258 }, { 215,-258 }, { 216,-258 }, { 217,-258 },
 { 218,-258 }, { 219,-258 }, { 220,-258 }, { 221,-258 }, { 222,-258 },
 { 223,-258 }, { 224,-258 }, { 225,-258 }, { 226,-258 }, { 227,-258 },
 { 228,-258 }, { 229,-258 }, { 230,-258 }, { 231,-258 }, { 232,-258 },
 { 233,-258 }, { 234,-258 }, { 235,-258 }, { 236,-258 }, { 237,-258 },
 { 238,-258 }, { 239,-258 }, { 240,-258 }, { 241,-258 }, { 242,-258 },

 { 243,-258 }, { 244,-258 }, { 245,-258 }, { 246,-258 }, { 247,-258 },
 { 248,-258 }, { 249,-258 }, { 250,-258 }, { 251,-258 }, { 252,-258 },
 { 253,-258 }, { 254,-258 }, { 255,-258 }, { 256,-258 }, {   0,  22 },
 {   0,9875 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,-8707 },
 {  10,-8707 }, {   0,   0 }, {  12,-8707 }, {  13,-8707 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  32,-8707 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-19702 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  45,-19700 }, {   0,  22 }, {   0,9828 }, {   1,-563 }, {   2,-563 },
 {   3,-563 }, {   4,-563 }, {   5,-563 }, {   6,-563 }, {   7,-563 },
 {   8,-563 }, {   9,-305 }, {  10, -47 }, {  11,-563 }, {  12,-305 },
 {  13, -47 }, {  14,-563 }, {  15,-563 }, {  16,-563 }, {  17,-563 },
 {  18,-563 }, {  19,-563 }, {  20,-563 }, {  21,-563 }, {  22,-563 },
 {  23,-563 }, {  24,-563 }, {  25,-563 }, {  26,-563 }, {  27,-563 },
 {  28,-563 }, {  29,-563 }, {  30,-563 }, {  31,-563 }, {  32,-305 },
 {  33,-563 }, {  34,-563 }, {  35,-563 }, {  36,-563 }, {  37,-563 },

 {  38,-563 }, {  39,-563 }, {  40,-563 }, {  41,-563 }, {  42,-563 },
 {  43,-563 }, {  44,-563 }, {  45,2365 }, {  46,-563 }, {  47,-563 },
 {  48,-563 }, {  49,-563 }, {  50,-563 }, {  51,-563 }, {  52,-563 },
 {  53,-563 }, {  54,-563 }, {  55,-563 }, {  56,-563 }, {  57,-563 },
 {  58,-563 }, {  59,-563 }, {  60,-563 }, {  61,-563 }, {  62,-563 },
 {  63,-563 }, {  64,-563 }, {  65,-563 }, {  66,-563 }, {  67,-563 },
 {  68,-563 }, {  69,-563 }, {  70,-563 }, {  71,-563 }, {  72,-563 },
 {  73,-563 }, {  74,-563 }, {  75,-563 }, {  76,-563 }, {  77,-563 },
 {  78,-563 }, {  79,-563 }, {  80,-563 }, {  81,-563 }, {  82,-563 },
 {  83,-563 }, {  84,-563 }, {  85,-563 }, {  86,-563 }, {  87,-563 },

 {  88,-563 }, {  89,-563 }, {  90,-563 }, {  91,-563 }, {  92,-563 },
 {  93,-563 }, {  94,-563 }, {  95,-563 }, {  96,-563 }, {  97,-563 },
 {  98,-563 }, {  99,-563 }, { 100,-563 }, { 101,-563 }, { 102,-563 },
 { 103,-563 }, { 104,-563 }, { 105,-563 }, { 106,-563 }, { 107,-563 },
 { 108,-563 }, { 109,-563 }, { 110,-563 }, { 111,-563 }, { 112,-563 },
 { 113,-563 }, { 114,-563 }, { 115,-563 }, { 116,-563 }, { 117,-563 },
 { 118,-563 }, { 119,-563 }, { 120,-563 }, { 121,-563 }, { 122,-563 },
 { 123,-563 }, { 124,-563 }, { 125,-563 }, { 126,-563 }, { 127,-563 },
 { 128,-563 }, { 129,-563 }, { 130,-563 }, { 131,-563 }, { 132,-563 },
 { 133,-563 }, { 134,-563 }, { 135,-563 }, { 136,-563 }, { 137,-563 },

 { 138,-563 }, { 139,-563 }, { 140,-563 }, { 141,-563 }, { 142,-563 },
 { 143,-563 }, { 144,-563 }, { 145,-563 }, { 146,-563 }, { 147,-563 },
 { 148,-563 }, { 149,-563 }, { 150,-563 }, { 151,-563 }, { 152,-563 },
 { 153,-563 }, { 154,-563 }, { 155,-563 }, { 156,-563 }, { 157,-563 },
 { 158,-563 }, { 159,-563 }, { 160,-563 }, { 161,-563 }, { 162,-563 },
 { 163,-563 }, { 164,-563 }, { 165,-563 }, { 166,-563 }, { 167,-563 },
 { 168,-563 }, { 169,-563 }, { 170,-563 }, { 171,-563 }, { 172,-563 },
 { 173,-563 }, { 174,-563 }, { 175,-563 }, { 176,-563 }, { 177,-563 },
 { 178,-563 }, { 179,-563 }, { 180,-563 }, { 181,-563 }, { 182,-563 },
 { 183,-563 }, { 184,-563 }, { 185,-563 }, { 186,-563 }, { 187,-563 },

 { 188,-563 }, { 189,-563 }, { 190,-563 }, { 191,-563 }, { 192,-563 },
 { 193,-563 }, { 194,-563 }, { 195,-563 }, { 196,-563 }, { 197,-563 },
 { 198,-563 }, { 199,-563 }, { 200,-563 }, { 201,-563 }, { 202,-563 },
 { 203,-563 }, { 204,-563 }, { 205,-563 }, { 206,-563 }, { 207,-563 },
 { 208,-563 }, { 209,-563 }, { 210,-563 }, { 211,-563 }, { 212,-563 },
 { 213,-563 }, { 214,-563 }, { 215,-563 }, { 216,-563 }, { 217,-563 },
 { 218,-563 }, { 219,-563 }, { 220,-563 }, { 221,-563 }, { 222,-563 },
 { 223,-563 }, { 224,-563 }, { 225,-563 }, { 226,-563 }, { 227,-563 },
 { 228,-563 }, { 229,-563 }, { 230,-563 }, { 231,-563 }, { 232,-563 },
 { 233,-563 }, { 234,-563 }, { 235,-563 }, { 236,-563 }, { 237,-563 },

 { 238,-563 }, { 239,-563 }, { 240,-563 }, { 241,-563 }, { 242,-563 },
 { 243,-563 }, { 244,-563 }, { 245,-563 }, { 246,-563 }, { 247,-563 },
 { 248,-563 }, { 249,-563 }, { 250,-563 }, { 251,-563 }, { 252,-563 },
 { 253,-563 }, { 254,-563 }, { 255,-563 }, { 256,-563 }, {   0,  22 },
 {   0,9570 }, {   1,-5039 }, {   2,-5039 }, {   3,-5039 }, {   4,-5039 },
 {   5,-5039 }, {   6,-5039 }, {   7,-5039 }, {   8,-5039 }, {   9,-4781 },
 {  10,-12220 }, {  11,-5039 }, {  12,-4781 }, {  13,-12220 }, {  14,-5039 },
 {  15,-5039 }, {  16,-5039 }, {  17,-5039 }, {  18,-5039 }, {  19,-5039 },
 {  20,-5039 }, {  21,-5039 }, {  22,-5039 }, {  23,-5039 }, {  24,-5039 },
 {  25,-5039 }, {  26,-5039 }, {  27,-5039 }, {  28,-5039 }, {  29,-5039 },

 {  30,-5039 }, {  31,-5039 }, {  32,-4781 }, {  33,-5039 }, {  34,-5039 },
 {  35,-5039 }, {  36,-5039 }, {  37,-5039 }, {  38,-5039 }, {  39,-5039 },
 {  40,-5039 }, {  41,-5039 }, {  42,-5039 }, {  43,-5039 }, {  44,-5039 },
 {  45,   0 }, {  46,-5039 }, {  47,-5039 }, {  48,-5039 }, {  49,-5039 },
 {  50,-5039 }, {  51,-5039 }, {  52,-5039 }, {  53,-5039 }, {  54,-5039 },
 {  55,-5039 }, {  56,-5039 }, {  57,-5039 }, {  58,-5039 }, {  59,-5039 },
 {  60,-5039 }, {  61,-5039 }, {  62,-5039 }, {  63,-5039 }, {  64,-5039 },
 {  65,-5039 }, {  66,-5039 }, {  67,-5039 }, {  68,-5039 }, {  69,-5039 },
 {  70,-5039 }, {  71,-5039 }, {  72,-5039 }, {  73,-5039 }, {  74,-5039 },
 {  75,-5039 }, {  76,-5039 }, {  77,-5039 }, {  78,-5039 }, {  79,-5039 },

 {  80,-5039 }, {  81,-5039 }, {  82,-5039 }, {  83,-5039 }, {  84,-5039 },
 {  85,-5039 }, {  86,-5039 }, {  87,-5039 }, {  88,-5039 }, {  89,-5039 },
 {  90,-5039 }, {  91,-5039 }, {  92,-5039 }, {  93,-5039 }, {  94,-5039 },
 {  95,-5039 }, {  96,-5039 }, {  97,-5039 }, {  98,-5039 }, {  99,-5039 },
 { 100,-5039 }, { 101,-5039 }, { 102,-5039 }, { 103,-5039 }, { 104,-5039 },
 { 105,-5039 }, { 106,-5039 }, { 107,-5039 }, { 108,-5039 }, { 109,-5039 },
 { 110,-5039 }, { 111,-5039 }, { 112,-5039 }, { 113,-5039 }, { 114,-5039 },
 { 115,-5039 }, { 116,-5039 }, { 117,-5039 }, { 118,-5039 }, { 119,-5039 },
 { 120,-5039 }, { 121,-5039 }, { 122,-5039 }, { 123,-5039 }, { 124,-5039 },
 { 125,-5039 }, { 126,-5039 }, { 127,-5039 }, { 128,-5039 }, { 129,-5039 },

 { 130,-5039 }, { 131,-5039 }, { 132,-5039 }, { 133,-5039 }, { 134,-5039 },
 { 135,-5039 }, { 136,-5039 }, { 137,-5039 }, { 138,-5039 }, { 139,-5039 },
 { 140,-5039 }, { 141,-5039 }, { 142,-5039 }, { 143,-5039 }, { 144,-5039 },
 { 145,-5039 }, { 146,-5039 }, { 147,-5039 }, { 148,-5039 }, { 149,-5039 },
 { 150,-5039 }, { 151,-5039 }, { 152,-5039 }, { 153,-5039 }, { 154,-5039 },
 { 155,-5039 }, { 156,-5039 }, { 157,-5039 }, { 158,-5039 }, { 159,-5039 },
 { 160,-5039 }, { 161,-5039 }, { 162,-5039 }, { 163,-5039 }, { 164,-5039 },
 { 165,-5039 }, { 166,-5039 }, { 167,-5039 }, { 168,-5039 }, { 169,-5039 },
 { 170,-5039 }, { 171,-5039 }, { 172,-5039 }, { 173,-5039 }, { 174,-5039 },
 { 175,-5039 }, { 176,-5039 }, { 177,-5039 }, { 178,-5039 }, { 179,-5039 },

 { 180,-5039 }, { 181,-5039 }, { 182,-5039 }, { 183,-5039 }, { 184,-5039 },
 { 185,-5039 }, { 186,-5039 }, { 187,-5039 }, { 188,-5039 }, { 189,-5039 },
 { 190,-5039 }, { 191,-5039 }, { 192,-5039 }, { 193,-5039 }, { 194,-5039 },
 { 195,-5039 }, { 196,-5039 }, { 197,-5039 }, { 198,-5039 }, { 199,-5039 },
 { 200,-5039 }, { 201,-5039 }, { 202,-5039 }, { 203,-5039 }, { 204,-5039 },
 { 205,-5039 }, { 206,-5039 }, { 207,-5039 }, { 208,-5039 }, { 209,-5039 },
 { 210,-5039 }, { 211,-5039 }, { 212,-5039 }, { 213,-5039 }, { 214,-5039 },
 { 215,-5039 }, { 216,-5039 }, { 217,-5039 }, { 218,-5039 }, { 219,-5039 },
 { 220,-5039 }, { 221,-5039 }, { 222,-5039 }, { 223,-5039 }, { 224,-5039 },
 { 225,-5039 }, { 226,-5039 }, { 227,-5039 }, { 228,-5039 }, { 229,-5039 },

 { 230,-5039 }, { 231,-5039 }, { 232,-5039 }, { 233,-5039 }, { 234,-5039 },
 { 235,-5039 }, { 236,-5039 }, { 237,-5039 }, { 238,-5039 }, { 239,-5039 },
 { 240,-5039 }, { 241,-5039 }, { 242,-5039 }, { 243,-5039 }, { 244,-5039 },
 { 245,-5039 }, { 246,-5039 }, { 247,-5039 }, { 248,-5039 }, { 249,-5039 },
 { 250,-5039 }, { 251,-5039 }, { 252,-5039 }, { 253,-5039 }, { 254,-5039 },
 { 255,-5039 }, { 256,-5039 }, {   0,  37 }, {   0,9312 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,  37 }, {   0,9289 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,2107 }, {  49,2107 }, {  50,2107 }, {  51,2107 },
 {  52,2107 }, {  53,2107 }, {  54,2107 }, {  55,2107 }, {  56,2107 },
 {  57,2107 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,2107 }, {  66,2107 },
 {  67,2107 }, {  68,2107 }, {  69,2107 }, {  70,2107 }, {  48,-19868 },

 {  49,-19868 }, {  50,-19868 }, {  51,-19868 }, {  52,-19868 }, {  53,-19868 },
 {  54,-19868 }, {  55,-19868 }, {  56,-19868 }, {  57,-19868 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-19868 }, {  66,-19868 }, {  67,-19868 }, {  68,-19868 },
 {  69,-19868 }, {  70,-19868 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,2107 }, {  98,2107 }, {  99,2107 }, { 100,2107 }, { 101,2107 },
 { 102,2107 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,-19868 }, {  98,-19868 },

 {  99,-19868 }, { 100,-19868 }, { 101,-19868 }, { 102,-19868 }, {   0,  24 },
 {   0,9185 }, {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 },
 {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9, 258 },
 {  10, 516 }, {  11,   0 }, {  12, 258 }, {  13, 516 }, {  14,   0 },
 {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 },
 {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 },
 {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 },
 {  30,   0 }, {  31,   0 }, {  32, 258 }, {  33,   0 }, {  34,   0 },
 {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 },
 {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 },

 {  45, 563 }, {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 },

 {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 },
 { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },

 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },

 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },

 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, { 256,   0 }, {   0,  24 }, {   0,8927 }, {   1,-258 },
 {   2,-258 }, {   3,-258 }, {   4,-258 }, {   5,-258 }, {   6,-258 },
 {   7,-258 }, {   8,-258 }, {   9,   0 }, {  10, 258 }, {  11,-258 },
 {  12,   0 }, {  13, 258 }, {  14,-258 }, {  15,-258 }, {  16,-258 },
 {  17,-258 }, {  18,-258 }, {  19,-258 }, {  20,-258 }, {  21,-258 },
 {  22,-258 }, {  23,-258 }, {  24,-258 }, {  25,-258 }, {  26,-258 },
 {  27,-258 }, {  28,-258 }, {  29,-258 }, {  30,-258 }, {  31,-258 },
 {  32,   0 }, {  33,-258 }, {  34,-258 }, {  35,-258 }, {  36,-258 },

 {  37,-258 }, {  38,-258 }, {  39,-258 }, {  40,-258 }, {  41,-258 },
 {  42,-258 }, {  43,-258 }, {  44,-258 }, {  45, 305 }, {  46,-258 },
 {  47,-258 }, {  48,-258 }, {  49,-258 }, {  50,-258 }, {  51,-258 },
 {  52,-258 }, {  53,-258 }, {  54,-258 }, {  55,-258 }, {  56,-258 },
 {  57,-258 }, {  58,-258 }, {  59,-258 }, {  60,-258 }, {  61,-258 },
 {  62,-258 }, {  63,-258 }, {  64,-258 }, {  65,-258 }, {  66,-258 },
 {  67,-258 }, {  68,-258 }, {  69,-258 }, {  70,-258 }, {  71,-258 },
 {  72,-258 }, {  73,-258 }, {  74,-258 }, {  75,-258 }, {  76,-258 },
 {  77,-258 }, {  78,-258 }, {  79,-258 }, {  80,-258 }, {  81,-258 },
 {  82,-258 }, {  83,-258 }, {  84,-258 }, {  85,-258 }, {  86,-258 },

 {  87,-258 }, {  88,-258 }, {  89,-258 }, {  90,-258 }, {  91,-258 },
 {  92,-258 }, {  93,-258 }, {  94,-258 }, {  95,-258 }, {  96,-258 },
 {  97,-258 }, {  98,-258 }, {  99,-258 }, { 100,-258 }, { 101,-258 },
 { 102,-258 }, { 103,-258 }, { 104,-258 }, { 105,-258 }, { 106,-258 },
 { 107,-258 }, { 108,-258 }, { 109,-258 }, { 110,-258 }, { 111,-258 },
 { 112,-258 }, { 113,-258 }, { 114,-258 }, { 115,-258 }, { 116,-258 },
 { 117,-258 }, { 118,-258 }, { 119,-258 }, { 120,-258 }, { 121,-258 },
 { 122,-258 }, { 123,-258 }, { 124,-258 }, { 125,-258 }, { 126,-258 },
 { 127,-258 }, { 128,-258 }, { 129,-258 }, { 130,-258 }, { 131,-258 },
 { 132,-258 }, { 133,-258 }, { 134,-258 }, { 135,-258 }, { 136,-258 },

 { 137,-258 }, { 138,-258 }, { 139,-258 }, { 140,-258 }, { 141,-258 },
 { 142,-258 }, { 143,-258 }, { 144,-258 }, { 145,-258 }, { 146,-258 },
 { 147,-258 }, { 148,-258 }, { 149,-258 }, { 150,-258 }, { 151,-258 },
 { 152,-258 }, { 153,-258 }, { 154,-258 }, { 155,-258 }, { 156,-258 },
 { 157,-258 }, { 158,-258 }, { 159,-258 }, { 160,-258 }, { 161,-258 },
 { 162,-258 }, { 163,-258 }, { 164,-258 }, { 165,-258 }, { 166,-258 },
 { 167,-258 }, { 168,-258 }, { 169,-258 }, { 170,-258 }, { 171,-258 },
 { 172,-258 }, { 173,-258 }, { 174,-258 }, { 175,-258 }, { 176,-258 },
 { 177,-258 }, { 178,-258 }, { 179,-258 }, { 180,-258 }, { 181,-258 },
 { 182,-258 }, { 183,-258 }, { 184,-258 }, { 185,-258 }, { 186,-258 },

 { 187,-258 }, { 188,-258 }, { 189,-258 }, { 190,-258 }, { 191,-258 },
 { 192,-258 }, { 193,-258 }, { 194,-258 }, { 195,-258 }, { 196,-258 },
 { 197,-258 }, { 198,-258 }, { 199,-258 }, { 200,-258 }, { 201,-258 },
 { 202,-258 }, { 203,-258 }, { 204,-258 }, { 205,-258 }, { 206,-258 },
 { 207,-258 }, { 208,-258 }, { 209,-258 }, { 210,-258 }, { 211,-258 },
 { 212,-258 }, { 213,-258 }, { 214,-258 }, { 215,-258 }, { 216,-258 },
 { 217,-258 }, { 218,-258 }, { 219,-258 }, { 220,-258 }, { 221,-258 },
 { 222,-258 }, { 223,-258 }, { 224,-258 }, { 225,-258 }, { 226,-258 },
 { 227,-258 }, { 228,-258 }, { 229,-258 }, { 230,-258 }, { 231,-258 },
 { 232,-258 }, { 233,-258 }, { 234,-258 }, { 235,-258 }, { 236,-258 },

 { 237,-258 }, { 238,-258 }, { 239,-258 }, { 240,-258 }, { 241,-258 },
 { 242,-258 }, { 243,-258 }, { 244,-258 }, { 245,-258 }, { 246,-258 },
 { 247,-258 }, { 248,-258 }, { 249,-258 }, { 250,-258 }, { 251,-258 },
 { 252,-258 }, { 253,-258 }, { 254,-258 }, { 255,-258 }, { 256,-258 },
 {   0,  24 }, {   0,8669 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   9,-8952 }, {  10,-8952 }, {   0,   0 }, {  12,-8952 }, {  13,-8952 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  32,-8952 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  39,-20908 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  45,-20850 }, {   0,  24 }, {   0,8622 }, {   1,-563 },
 {   2,-563 }, {   3,-563 }, {   4,-563 }, {   5,-563 }, {   6,-563 },
 {   7,-563 }, {   8,-563 }, {   9,-305 }, {  10, -47 }, {  11,-563 },
 {  12,-305 }, {  13, -47 }, {  14,-563 }, {  15,-563 }, {  16,-563 },
 {  17,-563 }, {  18,-563 }, {  19,-563 }, {  20,-563 }, {  21,-563 },
 {  22,-563 }, {  23,-563 }, {  24,-563 }, {  25,-563 }, {  26,-563 },
 {  27,-563 }, {  28,-563 }, {  29,-563 }, {  30,-563 }, {  31,-563 },

 {  32,-305 }, {  33,-563 }, {  34,-563 }, {  35,-563 }, {  36,-563 },
 {  37,-563 }, {  38,-563 }, {  39,-563 }, {  40,-563 }, {  41,-563 },
 {  42,-563 }, {  43,-563 }, {  44,-563 }, {  45,1521 }, {  46,-563 },
 {  47,-563 }, {  48,-563 }, {  49,-563 }, {  50,-563 }, {  51,-563 },
 {  52,-563 }, {  53,-563 }, {  54,-563 }, {  55,-563 }, {  56,-563 },
 {  57,-563 }, {  58,-563 }, {  59,-563 }, {  60,-563 }, {  61,-563 },
 {  62,-563 }, {  63,-563 }, {  64,-563 }, {  65,-563 }, {  66,-563 },
 {  67,-563 }, {  68,-563 }, {  69,-563 }, {  70,-563 }, {  71,-563 },
 {  72,-563 }, {  73,-563 }, {  74,-563 }, {  75,-563 }, {  76,-563 },
 {  77,-563 }, {  78,-563 }, {  79,-563 }, {  80,-563 }, {  81,-563 },

 {  82,-563 }, {  83,-563 }, {  84,-563 }, {  85,-563 }, {  86,-563 },
 {  87,-563 }, {  88,-563 }, {  89,-563 }, {  90,-563 }, {  91,-563 },
 {  92,-563 }, {  93,-563 }, {  94,-563 }, {  95,-563 }, {  96,-563 },
 {  97,-563 }, {  98,-563 }, {  99,-563 }, { 100,-563 }, { 101,-563 },
 { 102,-563 }, { 103,-563 }, { 104,-563 }, { 105,-563 }, { 106,-563 },
 { 107,-563 }, { 108,-563 }, { 109,-563 }, { 110,-563 }, { 111,-563 },
 { 112,-563 }, { 113,-563 }, { 114,-563 }, { 115,-563 }, { 116,-563 },
 { 117,-563 }, { 118,-563 }, { 119,-563 }, { 120,-563 }, { 121,-563 },
 { 122,-563 }, { 123,-563 }, { 124,-563 }, { 125,-563 }, { 126,-563 },
 { 127,-563 }, { 128,-563 }, { 129,-563 }, { 130,-563 }, { 131,-563 },

 { 132,-563 }, { 133,-563 }, { 134,-563 }, { 135,-563 }, { 136,-563 },
 { 137,-563 }, { 138,-563 }, { 139,-563 }, { 140,-563 }, { 141,-563 },
 { 142,-563 }, { 143,-563 }, { 144,-563 }, { 145,-563 }, { 146,-563 },
 { 147,-563 }, { 148,-563 }, { 149,-563 }, { 150,-563 }, { 151,-563 },
 { 152,-563 }, { 153,-563 }, { 154,-563 }, { 155,-563 }, { 156,-563 },
 { 157,-563 }, { 158,-563 }, { 159,-563 }, { 160,-563 }, { 161,-563 },
 { 162,-563 }, { 163,-563 }, { 164,-563 }, { 165,-563 }, { 166,-563 },
 { 167,-563 }, { 168,-563 }, { 169,-563 }, { 170,-563 }, { 171,-563 },
 { 172,-563 }, { 173,-563 }, { 174,-563 }, { 175,-563 }, { 176,-563 },
 { 177,-563 }, { 178,-563 }, { 179,-563 }, { 180,-563 }, { 181,-563 },

 { 182,-563 }, { 183,-563 }, { 184,-563 }, { 185,-563 }, { 186,-563 },
 { 187,-563 }, { 188,-563 }, { 189,-563 }, { 190,-563 }, { 191,-563 },
 { 192,-563 }, { 193,-563 }, { 194,-563 }, { 195,-563 }, { 196,-563 },
 { 197,-563 }, { 198,-563 }, { 199,-563 }, { 200,-563 }, { 201,-563 },
 { 202,-563 }, { 203,-563 }, { 204,-563 }, { 205,-563 }, { 206,-563 },
 { 207,-563 }, { 208,-563 }, { 209,-563 }, { 210,-563 }, { 211,-563 },
 { 212,-563 }, { 213,-563 }, { 214,-563 }, { 215,-563 }, { 216,-563 },
 { 217,-563 }, { 218,-563 }, { 219,-563 }, { 220,-563 }, { 221,-563 },
 { 222,-563 }, { 223,-563 }, { 224,-563 }, { 225,-563 }, { 226,-563 },
 { 227,-563 }, { 228,-563 }, { 229,-563 }, { 230,-563 }, { 231,-563 },

 { 232,-563 }, { 233,-563 }, { 234,-563 }, { 235,-563 }, { 236,-563 },
 { 237,-563 }, { 238,-563 }, { 239,-563 }, { 240,-563 }, { 241,-563 },
 { 242,-563 }, { 243,-563 }, { 244,-563 }, { 245,-563 }, { 246,-563 },
 { 247,-563 }, { 248,-563 }, { 249,-563 }, { 250,-563 }, { 251,-563 },
 { 252,-563 }, { 253,-563 }, { 254,-563 }, { 255,-563 }, { 256,-563 },
 {   0,  24 }, {   0,8364 }, {   1,-5086 }, {   2,-5086 }, {   3,-5086 },
 {   4,-5086 }, {   5,-5086 }, {   6,-5086 }, {   7,-5086 }, {   8,-5086 },
 {   9,-4828 }, {  10,-12170 }, {  11,-5086 }, {  12,-4828 }, {  13,-12170 },
 {  14,-5086 }, {  15,-5086 }, {  16,-5086 }, {  17,-5086 }, {  18,-5086 },
 {  19,-5086 }, {  20,-5086 }, {  21,-5086 }, {  22,-5086 }, {  23,-5086 },

 {  24,-5086 }, {  25,-5086 }, {  26,-5086 }, {  27,-5086 }, {  28,-5086 },
 {  29,-5086 }, {  30,-5086 }, {  31,-5086 }, {  32,-4828 }, {  33,-5086 },
 {  34,-5086 }, {  35,-5086 }, {  36,-5086 }, {  37,-5086 }, {  38,-5086 },
 {  39,-5086 }, {  40,-5086 }, {  41,-5086 }, {  42,-5086 }, {  43,-5086 },
 {  44,-5086 }, {  45,   0 }, {  46,-5086 }, {  47,-5086 }, {  48,-5086 },
 {  49,-5086 }, {  50,-5086 }, {  51,-5086 }, {  52,-5086 }, {  53,-5086 },
 {  54,-5086 }, {  55,-5086 }, {  56,-5086 }, {  57,-5086 }, {  58,-5086 },
 {  59,-5086 }, {  60,-5086 }, {  61,-5086 }, {  62,-5086 }, {  63,-5086 },
 {  64,-5086 }, {  65,-5086 }, {  66,-5086 }, {  67,-5086 }, {  68,-5086 },
 {  69,-5086 }, {  70,-5086 }, {  71,-5086 }, {  72,-5086 }, {  73,-5086 },

 {  74,-5086 }, {  75,-5086 }, {  76,-5086 }, {  77,-5086 }, {  78,-5086 },
 {  79,-5086 }, {  80,-5086 }, {  81,-5086 }, {  82,-5086 }, {  83,-5086 },
 {  84,-5086 }, {  85,-5086 }, {  86,-5086 }, {  87,-5086 }, {  88,-5086 },
 {  89,-5086 }, {  90,-5086 }, {  91,-5086 }, {  92,-5086 }, {  93,-5086 },
 {  94,-5086 }, {  95,-5086 }, {  96,-5086 }, {  97,-5086 }, {  98,-5086 },
 {  99,-5086 }, { 100,-5086 }, { 101,-5086 }, { 102,-5086 }, { 103,-5086 },
 { 104,-5086 }, { 105,-5086 }, { 106,-5086 }, { 107,-5086 }, { 108,-5086 },
 { 109,-5086 }, { 110,-5086 }, { 111,-5086 }, { 112,-5086 }, { 113,-5086 },
 { 114,-5086 }, { 115,-5086 }, { 116,-5086 }, { 117,-5086 }, { 118,-5086 },
 { 119,-5086 }, { 120,-5086 }, { 121,-5086 }, { 122,-5086 }, { 123,-5086 },

 { 124,-5086 }, { 125,-5086 }, { 126,-5086 }, { 127,-5086 }, { 128,-5086 },
 { 129,-5086 }, { 130,-5086 }, { 131,-5086 }, { 132,-5086 }, { 133,-5086 },
 { 134,-5086 }, { 135,-5086 }, { 136,-5086 }, { 137,-5086 }, { 138,-5086 },
 { 139,-5086 }, { 140,-5086 }, { 141,-5086 }, { 142,-5086 }, { 143,-5086 },
 { 144,-5086 }, { 145,-5086 }, { 146,-5086 }, { 147,-5086 }, { 148,-5086 },
 { 149,-5086 }, { 150,-5086 }, { 151,-5086 }, { 152,-5086 }, { 153,-5086 },
 { 154,-5086 }, { 155,-5086 }, { 156,-5086 }, { 157,-5086 }, { 158,-5086 },
 { 159,-5086 }, { 160,-5086 }, { 161,-5086 }, { 162,-5086 }, { 163,-5086 },
 { 164,-5086 }, { 165,-5086 }, { 166,-5086 }, { 167,-5086 }, { 168,-5086 },
 { 169,-5086 }, { 170,-5086 }, { 171,-5086 }, { 172,-5086 }, { 173,-5086 },

 { 174,-5086 }, { 175,-5086 }, { 176,-5086 }, { 177,-5086 }, { 178,-5086 },
 { 179,-5086 }, { 180,-5086 }, { 181,-5086 }, { 182,-5086 }, { 183,-5086 },
 { 184,-5086 }, { 185,-5086 }, { 186,-5086 }, { 187,-5086 }, { 188,-5086 },
 { 189,-5086 }, { 190,-5086 }, { 191,-5086 }, { 192,-5086 }, { 193,-5086 },
 { 194,-5086 }, { 195,-5086 }, { 196,-5086 }, { 197,-5086 }, { 198,-5086 },
 { 199,-5086 }, { 200,-5086 }, { 201,-5086 }, { 202,-5086 }, { 203,-5086 },
 { 204,-5086 }, { 205,-5086 }, { 206,-5086 }, { 207,-5086 }, { 208,-5086 },
 { 209,-5086 }, { 210,-5086 }, { 211,-5086 }, { 212,-5086 }, { 213,-5086 },
 { 214,-5086 }, { 215,-5086 }, { 216,-5086 }, { 217,-5086 }, { 218,-5086 },
 { 219,-5086 }, { 220,-5086 }, { 221,-5086 }, { 222,-5086 }, { 223,-5086 },

 { 224,-5086 }, { 225,-5086 }, { 226,-5086 }, { 227,-5086 }, { 228,-5086 },
 { 229,-5086 }, { 230,-5086 }, { 231,-5086 }, { 232,-5086 }, { 233,-5086 },
 { 234,-5086 }, { 235,-5086 }, { 236,-5086 }, { 237,-5086 }, { 238,-5086 },
 { 239,-5086 }, { 240,-5086 }, { 241,-5086 }, { 242,-5086 }, { 243,-5086 },
 { 244,-5086 }, { 245,-5086 }, { 246,-5086 }, { 247,-5086 }, { 248,-5086 },
 { 249,-5086 }, { 250,-5086 }, { 251,-5086 }, { 252,-5086 }, { 253,-5086 },
 { 254,-5086 }, { 255,-5086 }, { 256,-5086 }, {   0,  37 }, {   0,8106 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  37 }, {   0,8083 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,1263 }, {  49,1263 }, {  50,1263 },
 {  51,1263 }, {  52,1263 }, {  53,1263 }, {  54,1263 }, {  55,1263 },
 {  56,1263 }, {  57,1263 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,1263 },

 {  66,1263 }, {  67,1263 }, {  68,1263 }, {  69,1263 }, {  70,1263 },
 {  48,-21062 }, {  49,-21062 }, {  50,-21062 }, {  51,-21062 }, {  52,-21062 },
 {  53,-21062 }, {  54,-21062 }, {  55,-21062 }, {  56,-21062 }, {  57,-21062 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-21062 }, {  66,-21062 }, {  67,-21062 },
 {  68,-21062 }, {  69,-21062 }, {  70,-21062 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,1263 }, {  98,1263 }, {  99,1263 }, { 100,1263 },
 { 101,1263 }, { 102,1263 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,-21062 },
 {  98,-21062 }, {  99,-21062 }, { 100,-21062 }, { 101,-21062 }, { 102,-21062 },
 {   0,   9 }, {   0,7979 }, {   1,-4570 }, {   2,-4570 }, {   3,-4570 },
 {   4,-4570 }, {   5,-4570 }, {   6,-4570 }, {   7,-4570 }, {   8,-4570 },
 {   9,-4312 }, {  10,-4054 }, {  11,-4570 }, {  12,-4312 }, {  13,-4054 },
 {  14,-4570 }, {  15,-4570 }, {  16,-4570 }, {  17,-4570 }, {  18,-4570 },
 {  19,-4570 }, {  20,-4570 }, {  21,-4570 }, {  22,-4570 }, {  23,-4570 },
 {  24,-4570 }, {  25,-4570 }, {  26,-4570 }, {  27,-4570 }, {  28,-4570 },
 {  29,-4570 }, {  30,-4570 }, {  31,-4570 }, {  32,-4312 }, {  33,-4570 },
 {  34,-4570 }, {  35,-4570 }, {  36,-4570 }, {  37,-4570 }, {  38,-4570 },

 {  39,-4570 }, {  40,-4570 }, {  41,-4570 }, {  42,-4570 }, {  43,-4570 },
 {  44,-4570 }, {  45,   0 }, {  46,-4570 }, {  47,-4570 }, {  48,-4570 },
 {  49,-4570 }, {  50,-4570 }, {  51,-4570 }, {  52,-4570 }, {  53,-4570 },
 {  54,-4570 }, {  55,-4570 }, {  56,-4570 }, {  57,-4570 }, {  58,-4570 },
 {  59,-4570 }, {  60,-4570 }, {  61,-4570 }, {  62,-4570 }, {  63,-4570 },
 {  64,-4570 }, {  65,-4570 }, {  66,-4570 }, {  67,-4570 }, {  68,-4570 },
 {  69,-4570 }, {  70,-4570 }, {  71,-4570 }, {  72,-4570 }, {  73,-4570 },
 {  74,-4570 }, {  75,-4570 }, {  76,-4570 }, {  77,-4570 }, {  78,-4570 },
 {  79,-4570 }, {  80,-4570 }, {  81,-4570 }, {  82,-4570 }, {  83,-4570 },
 {  84,-4570 }, {  85,-4570 }, {  86,-4570 }, {  87,-4570 }, {  88,-4570 },

 {  89,-4570 }, {  90,-4570 }, {  91,-4570 }, {  92,-4570 }, {  93,-4570 },
 {  94,-4570 }, {  95,-4570 }, {  96,-4570 }, {  97,-4570 }, {  98,-4570 },
 {  99,-4570 }, { 100,-4570 }, { 101,-4570 }, { 102,-4570 }, { 103,-4570 },
 { 104,-4570 }, { 105,-4570 }, { 106,-4570 }, { 107,-4570 }, { 108,-4570 },
 { 109,-4570 }, { 110,-4570 }, { 111,-4570 }, { 112,-4570 }, { 113,-4570 },
 { 114,-4570 }, { 115,-4570 }, { 116,-4570 }, { 117,-4570 }, { 118,-4570 },
 { 119,-4570 }, { 120,-4570 }, { 121,-4570 }, { 122,-4570 }, { 123,-4570 },
 { 124,-4570 }, { 125,-4570 }, { 126,-4570 }, { 127,-4570 }, { 128,-4570 },
 { 129,-4570 }, { 130,-4570 }, { 131,-4570 }, { 132,-4570 }, { 133,-4570 },
 { 134,-4570 }, { 135,-4570 }, { 136,-4570 }, { 137,-4570 }, { 138,-4570 },

 { 139,-4570 }, { 140,-4570 }, { 141,-4570 }, { 142,-4570 }, { 143,-4570 },
 { 144,-4570 }, { 145,-4570 }, { 146,-4570 }, { 147,-4570 }, { 148,-4570 },
 { 149,-4570 }, { 150,-4570 }, { 151,-4570 }, { 152,-4570 }, { 153,-4570 },
 { 154,-4570 }, { 155,-4570 }, { 156,-4570 }, { 157,-4570 }, { 158,-4570 },
 { 159,-4570 }, { 160,-4570 }, { 161,-4570 }, { 162,-4570 }, { 163,-4570 },
 { 164,-4570 }, { 165,-4570 }, { 166,-4570 }, { 167,-4570 }, { 168,-4570 },
 { 169,-4570 }, { 170,-4570 }, { 171,-4570 }, { 172,-4570 }, { 173,-4570 },
 { 174,-4570 }, { 175,-4570 }, { 176,-4570 }, { 177,-4570 }, { 178,-4570 },
 { 179,-4570 }, { 180,-4570 }, { 181,-4570 }, { 182,-4570 }, { 183,-4570 },
 { 184,-4570 }, { 185,-4570 }, { 186,-4570 }, { 187,-4570 }, { 188,-4570 },

 { 189,-4570 }, { 190,-4570 }, { 191,-4570 }, { 192,-4570 }, { 193,-4570 },
 { 194,-4570 }, { 195,-4570 }, { 196,-4570 }, { 197,-4570 }, { 198,-4570 },
 { 199,-4570 }, { 200,-4570 }, { 201,-4570 }, { 202,-4570 }, { 203,-4570 },
 { 204,-4570 }, { 205,-4570 }, { 206,-4570 }, { 207,-4570 }, { 208,-4570 },
 { 209,-4570 }, { 210,-4570 }, { 211,-4570 }, { 212,-4570 }, { 213,-4570 },
 { 214,-4570 }, { 215,-4570 }, { 216,-4570 }, { 217,-4570 }, { 218,-4570 },
 { 219,-4570 }, { 220,-4570 }, { 221,-4570 }, { 222,-4570 }, { 223,-4570 },
 { 224,-4570 }, { 225,-4570 }, { 226,-4570 }, { 227,-4570 }, { 228,-4570 },
 { 229,-4570 }, { 230,-4570 }, { 231,-4570 }, { 232,-4570 }, { 233,-4570 },
 { 234,-4570 }, { 235,-4570 }, { 236,-4570 }, { 237,-4570 }, { 238,-4570 },

 { 239,-4570 }, { 240,-4570 }, { 241,-4570 }, { 242,-4570 }, { 243,-4570 },
 { 244,-4570 }, { 245,-4570 }, { 246,-4570 }, { 247,-4570 }, { 248,-4570 },
 { 249,-4570 }, { 250,-4570 }, { 251,-4570 }, { 252,-4570 }, { 253,-4570 },
 { 254,-4570 }, { 255,-4570 }, { 256,-4570 }, {   0,  16 }, {   0,7721 },
 {   1,-3749 }, {   2,-3749 }, {   3,-3749 }, {   4,-3749 }, {   5,-3749 },
 {   6,-3749 }, {   7,-3749 }, {   8,-3749 }, {   9,-3491 }, {  10,-3233 },
 {  11,-3749 }, {  12,-3491 }, {  13,-3233 }, {  14,-3749 }, {  15,-3749 },
 {  16,-3749 }, {  17,-3749 }, {  18,-3749 }, {  19,-3749 }, {  20,-3749 },
 {  21,-3749 }, {  22,-3749 }, {  23,-3749 }, {  24,-3749 }, {  25,-3749 },
 {  26,-3749 }, {  27,-3749 }, {  28,-3749 }, {  29,-3749 }, {  30,-3749 },

 {  31,-3749 }, {  32,-3491 }, {  33,-3749 }, {  34,-3749 }, {  35,-3749 },
 {  36,-3749 }, {  37,-3749 }, {  38,-3749 }, {  39,-3749 }, {  40,-3749 },
 {  41,-3749 }, {  42,-3749 }, {  43,-3749 }, {  44,-3749 }, {  45,   0 },
 {  46,-3749 }, {  47,-3749 }, {  48,-3749 }, {  49,-3749 }, {  50,-3749 },
 {  51,-3749 }, {  52,-3749 }, {  53,-3749 }, {  54,-3749 }, {  55,-3749 },
 {  56,-3749 }, {  57,-3749 }, {  58,-3749 }, {  59,-3749 }, {  60,-3749 },
 {  61,-3749 }, {  62,-3749 }, {  63,-3749 }, {  64,-3749 }, {  65,-3749 },
 {  66,-3749 }, {  67,-3749 }, {  68,-3749 }, {  69,-3749 }, {  70,-3749 },
 {  71,-3749 }, {  72,-3749 }, {  73,-3749 }, {  74,-3749 }, {  75,-3749 },
 {  76,-3749 }, {  77,-3749 }, {  78,-3749 }, {  79,-3749 }, {  80,-3749 },

 {  81,-3749 }, {  82,-3749 }, {  83,-3749 }, {  84,-3749 }, {  85,-3749 },
 {  86,-3749 }, {  87,-3749 }, {  88,-3749 }, {  89,-3749 }, {  90,-3749 },
 {  91,-3749 }, {  92,-3749 }, {  93,-3749 }, {  94,-3749 }, {  95,-3749 },
 {  96,-3749 }, {  97,-3749 }, {  98,-3749 }, {  99,-3749 }, { 100,-3749 },
 { 101,-3749 }, { 102,-3749 }, { 103,-3749 }, { 104,-3749 }, { 105,-3749 },
 { 106,-3749 }, { 107,-3749 }, { 108,-3749 }, { 109,-3749 }, { 110,-3749 },
 { 111,-3749 }, { 112,-3749 }, { 113,-3749 }, { 114,-3749 }, { 115,-3749 },
 { 116,-3749 }, { 117,-3749 }, { 118,-3749 }, { 119,-3749 }, { 120,-3749 },
 { 121,-3749 }, { 122,-3749 }, { 123,-3749 }, { 124,-3749 }, { 125,-3749 },
 { 126,-3749 }, { 127,-3749 }, { 128,-3749 }, { 129,-3749 }, { 130,-3749 },

 { 131,-3749 }, { 132,-3749 }, { 133,-3749 }, { 134,-3749 }, { 135,-3749 },
 { 136,-3749 }, { 137,-3749 }, { 138,-3749 }, { 139,-3749 }, { 140,-3749 },
 { 141,-3749 }, { 142,-3749 }, { 143,-3749 }, { 144,-3749 }, { 145,-3749 },
 { 146,-3749 }, { 147,-3749 }, { 148,-3749 }, { 149,-3749 }, { 150,-3749 },
 { 151,-3749 }, { 152,-3749 }, { 153,-3749 }, { 154,-3749 }, { 155,-3749 },
 { 156,-3749 }, { 157,-3749 }, { 158,-3749 }, { 159,-3749 }, { 160,-3749 },
 { 161,-3749 }, { 162,-3749 }, { 163,-3749 }, { 164,-3749 }, { 165,-3749 },
 { 166,-3749 }, { 167,-3749 }, { 168,-3749 }, { 169,-3749 }, { 170,-3749 },
 { 171,-3749 }, { 172,-3749 }, { 173,-3749 }, { 174,-3749 }, { 175,-3749 },
 { 176,-3749 }, { 177,-3749 }, { 178,-3749 }, { 179,-3749 }, { 180,-3749 },

 { 181,-3749 }, { 182,-3749 }, { 183,-3749 }, { 184,-3749 }, { 185,-3749 },
 { 186,-3749 }, { 187,-3749 }, { 188,-3749 }, { 189,-3749 }, { 190,-3749 },
 { 191,-3749 }, { 192,-3749 }, { 193,-3749 }, { 194,-3749 }, { 195,-3749 },
 { 196,-3749 }, { 197,-3749 }, { 198,-3749 }, { 199,-3749 }, { 200,-3749 },
 { 201,-3749 }, { 202,-3749 }, { 203,-3749 }, { 204,-3749 }, { 205,-3749 },
 { 206,-3749 }, { 207,-3749 }, { 208,-3749 }, { 209,-3749 }, { 210,-3749 },
 { 211,-3749 }, { 212,-3749 }, { 213,-3749 }, { 214,-3749 }, { 215,-3749 },
 { 216,-3749 }, { 217,-3749 }, { 218,-3749 }, { 219,-3749 }, { 220,-3749 },
 { 221,-3749 }, { 222,-3749 }, { 223,-3749 }, { 224,-3749 }, { 225,-3749 },
 { 226,-3749 }, { 227,-3749 }, { 228,-3749 }, { 229,-3749 }, { 230,-3749 },

 { 231,-3749 }, { 232,-3749 }, { 233,-3749 }, { 234,-3749 }, { 235,-3749 },
 { 236,-3749 }, { 237,-3749 }, { 238,-3749 }, { 239,-3749 }, { 240,-3749 },
 { 241,-3749 }, { 242,-3749 }, { 243,-3749 }, { 244,-3749 }, { 245,-3749 },
 { 246,-3749 }, { 247,-3749 }, { 248,-3749 }, { 249,-3749 }, { 250,-3749 },
 { 251,-3749 }, { 252,-3749 }, { 253,-3749 }, { 254,-3749 }, { 255,-3749 },
 { 256,-3749 }, {   0,  22 }, {   0,7463 }, {   1,-2928 }, {   2,-2928 },
 {   3,-2928 }, {   4,-2928 }, {   5,-2928 }, {   6,-2928 }, {   7,-2928 },
 {   8,-2928 }, {   9,-2670 }, {  10,-2412 }, {  11,-2928 }, {  12,-2670 },
 {  13,-2412 }, {  14,-2928 }, {  15,-2928 }, {  16,-2928 }, {  17,-2928 },
 {  18,-2928 }, {  19,-2928 }, {  20,-2928 }, {  21,-2928 }, {  22,-2928 },

 {  23,-2928 }, {  24,-2928 }, {  25,-2928 }, {  26,-2928 }, {  27,-2928 },
 {  28,-2928 }, {  29,-2928 }, {  30,-2928 }, {  31,-2928 }, {  32,-2670 },
 {  33,-2928 }, {  34,-2928 }, {  35,-2928 }, {  36,-2928 }, {  37,-2928 },
 {  38,-2928 }, {  39,-2928 }, {  40,-2928 }, {  41,-2928 }, {  42,-2928 },
 {  43,-2928 }, {  44,-2928 }, {  45,   0 }, {  46,-2928 }, {  47,-2928 },
 {  48,-2928 }, {  49,-2928 }, {  50,-2928 }, {  51,-2928 }, {  52,-2928 },
 {  53,-2928 }, {  54,-2928 }, {  55,-2928 }, {  56,-2928 }, {  57,-2928 },
 {  58,-2928 }, {  59,-2928 }, {  60,-2928 }, {  61,-2928 }, {  62,-2928 },
 {  63,-2928 }, {  64,-2928 }, {  65,-2928 }, {  66,-2928 }, {  67,-2928 },
 {  68,-2928 }, {  69,-2928 }, {  70,-2928 }, {  71,-2928 }, {  72,-2928 },

 {  73,-2928 }, {  74,-2928 }, {  75,-2928 }, {  76,-2928 }, {  77,-2928 },
 {  78,-2928 }, {  79,-2928 }, {  80,-2928 }, {  81,-2928 }, {  82,-2928 },
 {  83,-2928 }, {  84,-2928 }, {  85,-2928 }, {  86,-2928 }, {  87,-2928 },
 {  88,-2928 }, {  89,-2928 }, {  90,-2928 }, {  91,-2928 }, {  92,-2928 },
 {  93,-2928 }, {  94,-2928 }, {  95,-2928 }, {  96,-2928 }, {  97,-2928 },
 {  98,-2928 }, {  99,-2928 }, { 100,-2928 }, { 101,-2928 }, { 102,-2928 },
 { 103,-2928 }, { 104,-2928 }, { 105,-2928 }, { 106,-2928 }, { 107,-2928 },
 { 108,-2928 }, { 109,-2928 }, { 110,-2928 }, { 111,-2928 }, { 112,-2928 },
 { 113,-2928 }, { 114,-2928 }, { 115,-2928 }, { 116,-2928 }, { 117,-2928 },
 { 118,-2928 }, { 119,-2928 }, { 120,-2928 }, { 121,-2928 }, { 122,-2928 },

 { 123,-2928 }, { 124,-2928 }, { 125,-2928 }, { 126,-2928 }, { 127,-2928 },
 { 128,-2928 }, { 129,-2928 }, { 130,-2928 }, { 131,-2928 }, { 132,-2928 },
 { 133,-2928 }, { 134,-2928 }, { 135,-2928 }, { 136,-2928 }, { 137,-2928 },
 { 138,-2928 }, { 139,-2928 }, { 140,-2928 }, { 141,-2928 }, { 142,-2928 },
 { 143,-2928 }, { 144,-2928 }, { 145,-2928 }, { 146,-2928 }, { 147,-2928 },
 { 148,-2928 }, { 149,-2928 }, { 150,-2928 }, { 151,-2928 }, { 152,-2928 },
 { 153,-2928 }, { 154,-2928 }, { 155,-2928 }, { 156,-2928 }, { 157,-2928 },
 { 158,-2928 }, { 159,-2928 }, { 160,-2928 }, { 161,-2928 }, { 162,-2928 },
 { 163,-2928 }, { 164,-2928 }, { 165,-2928 }, { 166,-2928 }, { 167,-2928 },
 { 168,-2928 }, { 169,-2928 }, { 170,-2928 }, { 171,-2928 }, { 172,-2928 },

 { 173,-2928 }, { 174,-2928 }, { 175,-2928 }, { 176,-2928 }, { 177,-2928 },
 { 178,-2928 }, { 179,-2928 }, { 180,-2928 }, { 181,-2928 }, { 182,-2928 },
 { 183,-2928 }, { 184,-2928 }, { 185,-2928 }, { 186,-2928 }, { 187,-2928 },
 { 188,-2928 }, { 189,-2928 }, { 190,-2928 }, { 191,-2928 }, { 192,-2928 },
 { 193,-2928 }, { 194,-2928 }, { 195,-2928 }, { 196,-2928 }, { 197,-2928 },
 { 198,-2928 }, { 199,-2928 }, { 200,-2928 }, { 201,-2928 }, { 202,-2928 },
 { 203,-2928 }, { 204,-2928 }, { 205,-2928 }, { 206,-2928 }, { 207,-2928 },
 { 208,-2928 }, { 209,-2928 }, { 210,-2928 }, { 211,-2928 }, { 212,-2928 },
 { 213,-2928 }, { 214,-2928 }, { 215,-2928 }, { 216,-2928 }, { 217,-2928 },
 { 218,-2928 }, { 219,-2928 }, { 220,-2928 }, { 221,-2928 }, { 222,-2928 },

 { 223,-2928 }, { 224,-2928 }, { 225,-2928 }, { 226,-2928 }, { 227,-2928 },
 { 228,-2928 }, { 229,-2928 }, { 230,-2928 }, { 231,-2928 }, { 232,-2928 },
 { 233,-2928 }, { 234,-2928 }, { 235,-2928 }, { 236,-2928 }, { 237,-2928 },
 { 238,-2928 }, { 239,-2928 }, { 240,-2928 }, { 241,-2928 }, { 242,-2928 },
 { 243,-2928 }, { 244,-2928 }, { 245,-2928 }, { 246,-2928 }, { 247,-2928 },
 { 248,-2928 }, { 249,-2928 }, { 250,-2928 }, { 251,-2928 }, { 252,-2928 },
 { 253,-2928 }, { 254,-2928 }, { 255,-2928 }, { 256,-2928 }, {   0,  37 },
 {   0,7205 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48, 385 }, {  49, 385 },
 {  50, 385 }, {  51, 385 }, {  52, 385 }, {  53, 385 }, {  54, 385 },
 {  55, 385 }, {  56, 385 }, {  57, 385 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  65, 385 }, {  66, 385 }, {  67, 385 }, {  68, 385 }, {  69, 385 },
 {  70, 385 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97, 385 }, {  98, 385 }, {  99, 385 },
 { 100, 385 }, { 101, 385 }, { 102, 385 }, {   0,  24 }, {   0,7101 },
 {   1,-2084 }, {   2,-2084 }, {   3,-2084 }, {   4,-2084 }, {   5,-2084 },
 {   6,-2084 }, {   7,-2084 }, {   8,-2084 }, {   9,-1826 }, {  10,-1568 },

 {  11,-2084 }, {  12,-1826 }, {  13,-1568 }, {  14,-2084 }, {  15,-2084 },
 {  16,-2084 }, {  17,-2084 }, {  18,-2084 }, {  19,-2084 }, {  20,-2084 },
 {  21,-2084 }, {  22,-2084 }, {  23,-2084 }, {  24,-2084 }, {  25,-2084 },
 {  26,-2084 }, {  27,-2084 }, {  28,-2084 }, {  29,-2084 }, {  30,-2084 },
 {  31,-2084 }, {  32,-1826 }, {  33,-2084 }, {  34,-2084 }, {  35,-2084 },
 {  36,-2084 }, {  37,-2084 }, {  38,-2084 }, {  39,-2084 }, {  40,-2084 },
 {  41,-2084 }, {  42,-2084 }, {  43,-2084 }, {  44,-2084 }, {  45,   0 },
 {  46,-2084 }, {  47,-2084 }, {  48,-2084 }, {  49,-2084 }, {  50,-2084 },
 {  51,-2084 }, {  52,-2084 }, {  53,-2084 }, {  54,-2084 }, {  55,-2084 },
 {  56,-2084 }, {  57,-2084 }, {  58,-2084 }, {  59,-2084 }, {  60,-2084 },

 {  61,-2084 }, {  62,-2084 }, {  63,-2084 }, {  64,-2084 }, {  65,-2084 },
 {  66,-2084 }, {  67,-2084 }, {  68,-2084 }, {  69,-2084 }, {  70,-2084 },
 {  71,-2084 }, {  72,-2084 }, {  73,-2084 }, {  74,-2084 }, {  75,-2084 },
 {  76,-2084 }, {  77,-2084 }, {  78,-2084 }, {  79,-2084 }, {  80,-2084 },
 {  81,-2084 }, {  82,-2084 }, {  83,-2084 }, {  84,-2084 }, {  85,-2084 },
 {  86,-2084 }, {  87,-2084 }, {  88,-2084 }, {  89,-2084 }, {  90,-2084 },
 {  91,-2084 }, {  92,-2084 }, {  93,-2084 }, {  94,-2084 }, {  95,-2084 },
 {  96,-2084 }, {  97,-2084 }, {  98,-2084 }, {  99,-2084 }, { 100,-2084 },
 { 101,-2084 }, { 102,-2084 }, { 103,-2084 }, { 104,-2084 }, { 105,-2084 },
 { 106,-2084 }, { 107,-2084 }, { 108,-2084 }, { 109,-2084 }, { 110,-2084 },

 { 111,-2084 }, { 112,-2084 }, { 113,-2084 }, { 114,-2084 }, { 115,-2084 },
 { 116,-2084 }, { 117,-2084 }, { 118,-2084 }, { 119,-2084 }, { 120,-2084 },
 { 121,-2084 }, { 122,-2084 }, { 123,-2084 }, { 124,-2084 }, { 125,-2084 },
 { 126,-2084 }, { 127,-2084 }, { 128,-2084 }, { 129,-2084 }, { 130,-2084 },
 { 131,-2084 }, { 132,-2084 }, { 133,-2084 }, { 134,-2084 }, { 135,-2084 },
 { 136,-2084 }, { 137,-2084 }, { 138,-2084 }, { 139,-2084 }, { 140,-2084 },
 { 141,-2084 }, { 142,-2084 }, { 143,-2084 }, { 144,-2084 }, { 145,-2084 },
 { 146,-2084 }, { 147,-2084 }, { 148,-2084 }, { 149,-2084 }, { 150,-2084 },
 { 151,-2084 }, { 152,-2084 }, { 153,-2084 }, { 154,-2084 }, { 155,-2084 },
 { 156,-2084 }, { 157,-2084 }, { 158,-2084 }, { 159,-2084 }, { 160,-2084 },

 { 161,-2084 }, { 162,-2084 }, { 163,-2084 }, { 164,-2084 }, { 165,-2084 },
 { 166,-2084 }, { 167,-2084 }, { 168,-2084 }, { 169,-2084 }, { 170,-2084 },
 { 171,-2084 }, { 172,-2084 }, { 173,-2084 }, { 174,-2084 }, { 175,-2084 },
 { 176,-2084 }, { 177,-2084 }, { 178,-2084 }, { 179,-2084 }, { 180,-2084 },
 { 181,-2084 }, { 182,-2084 }, { 183,-2084 }, { 184,-2084 }, { 185,-2084 },
 { 186,-2084 }, { 187,-2084 }, { 188,-2084 }, { 189,-2084 }, { 190,-2084 },
 { 191,-2084 }, { 192,-2084 }, { 193,-2084 }, { 194,-2084 }, { 195,-2084 },
 { 196,-2084 }, { 197,-2084 }, { 198,-2084 }, { 199,-2084 }, { 200,-2084 },
 { 201,-2084 }, { 202,-2084 }, { 203,-2084 }, { 204,-2084 }, { 205,-2084 },
 { 206,-2084 }, { 207,-2084 }, { 208,-2084 }, { 209,-2084 }, { 210,-2084 },

 { 211,-2084 }, { 212,-2084 }, { 213,-2084 }, { 214,-2084 }, { 215,-2084 },
 { 216,-2084 }, { 217,-2084 }, { 218,-2084 }, { 219,-2084 }, { 220,-2084 },
 { 221,-2084 }, { 222,-2084 }, { 223,-2084 }, { 224,-2084 }, { 225,-2084 },
 { 226,-2084 }, { 227,-2084 }, { 228,-2084 }, { 229,-2084 }, { 230,-2084 },
 { 231,-2084 }, { 232,-2084 }, { 233,-2084 }, { 234,-2084 }, { 235,-2084 },
 { 236,-2084 }, { 237,-2084 }, { 238,-2084 }, { 239,-2084 }, { 240,-2084 },
 { 241,-2084 }, { 242,-2084 }, { 243,-2084 }, { 244,-2084 }, { 245,-2084 },
 { 246,-2084 }, { 247,-2084 }, { 248,-2084 }, { 249,-2084 }, { 250,-2084 },
 { 251,-2084 }, { 252,-2084 }, { 253,-2084 }, { 254,-2084 }, { 255,-2084 },
 { 256,-2084 }, {   0,  37 }, {   0,6843 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  37 },
 {   0,6820 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48, 136 }, {  49, 136 }, {  50, 136 }, {  51, 136 }, {  52, 136 },

 {  53, 136 }, {  54, 136 }, {  55, 136 }, {  56, 136 }, {  57, 136 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65, 136 }, {  66, 136 }, {  67, 136 },
 {  68, 136 }, {  69, 136 }, {  70, 136 }, {  48, 137 }, {  49, 137 },
 {  50, 137 }, {  51, 137 }, {  52, 137 }, {  53, 137 }, {  54, 137 },
 {  55, 137 }, {  56, 137 }, {  57, 137 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65, 137 }, {  66, 137 }, {  67, 137 }, {  68, 137 }, {  69, 137 },
 {  70, 137 }, {   0,  55 }, {   0,6748 }, {   0,   0 }, {  97, 136 },
 {  98, 136 }, {  99, 136 }, { 100, 136 }, { 101, 136 }, { 102, 136 },

 {   0,   0 }, {   9, 137 }, {  10, 137 }, {   0,   0 }, {  12, 137 },
 {  13, 137 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  28 }, {   0,6724 }, {  97, 137 }, {  98, 137 }, {  99, 137 },
 { 100, 137 }, { 101, 137 }, { 102, 137 }, {   0,   0 }, {  32, 137 },
 {   9, 418 }, {  10, 418 }, {   0,   0 }, {  12, 418 }, {  13, 418 },
 {   0,   0 }, {  39, 184 }, {   0,  37 }, {   0,6707 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  45,-22165 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  32, 418 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  39, 465 }, {   0,  37 }, {   0,6683 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  45,-22178 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48, 706 }, {  49, 706 }, {  50, 706 }, {  51, 706 },
 {  52, 706 }, {  53, 706 }, {  54, 706 }, {  55, 706 }, {  56, 706 },
 {  57, 706 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65, 706 }, {  66, 706 },

 {  67, 706 }, {  68, 706 }, {  69, 706 }, {  70, 706 }, {   0,   0 },
 {  48, 705 }, {  49, 705 }, {  50, 705 }, {  51, 705 }, {  52, 705 },
 {  53, 705 }, {  54, 705 }, {  55, 705 }, {  56, 705 }, {  57, 705 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65, 705 }, {  66, 705 }, {  67, 705 },
 {  68, 705 }, {  69, 705 }, {  70, 705 }, {   0,  55 }, {   0,6611 },
 {  97, 706 }, {  98, 706 }, {  99, 706 }, { 100, 706 }, { 101, 706 },
 { 102, 706 }, {   0,   0 }, {   0,   0 }, {   9,   0 }, {  10,   0 },
 {   0,   0 }, {  12,   0 }, {  13,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97, 705 },
 {  98, 705 }, {  99, 705 }, { 100, 705 }, { 101, 705 }, { 102, 705 },
 {   0,   0 }, {  32,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,  47 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-22302 },
 {   0,  55 }, {   0,6564 }, {   1,-22331 }, {   2,-22331 }, {   3,-22331 },
 {   4,-22331 }, {   5,-22331 }, {   6,-22331 }, {   7,-22331 }, {   8,-22331 },
 {   9,-22331 }, {  10,-22331 }, {  11,-22331 }, {  12,-22331 }, {  13,-22331 },
 {  14,-22331 }, {  15,-22331 }, {  16,-22331 }, {  17,-22331 }, {  18,-22331 },
 {  19,-22331 }, {  20,-22331 }, {  21,-22331 }, {  22,-22331 }, {  23,-22331 },

 {  24,-22331 }, {  25,-22331 }, {  26,-22331 }, {  27,-22331 }, {  28,-22331 },
 {  29,-22331 }, {  30,-22331 }, {  31,-22331 }, {  32,-22331 }, {  33,-22331 },
 {  34,-22331 }, {  35,-22331 }, {  36,-22331 }, {  37,-22331 }, {  38,-22331 },
 {   0,   0 }, {  40,-22331 }, {  41,-22331 }, {  42,-22331 }, {  43,-22331 },
 {  44,-22331 }, {  45,-22331 }, {  46,-22331 }, {  47,-22331 }, {  48,-22331 },
 {  49,-22331 }, {  50,-22331 }, {  51,-22331 }, {  52,-22331 }, {  53,-22331 },
 {  54,-22331 }, {  55,-22331 }, {  56,-22331 }, {  57,-22331 }, {  58,-22331 },
 {  59,-22331 }, {  60,-22331 }, {  61,-22331 }, {  62,-22331 }, {  63,-22331 },
 {  64,-22331 }, {  65,-22331 }, {  66,-22331 }, {  67,-22331 }, {  68,-22331 },
 {  69,-22331 }, {  70,-22331 }, {  71,-22331 }, {  72,-22331 }, {  73,-22331 },

 {  74,-22331 }, {  75,-22331 }, {  76,-22331 }, {  77,-22331 }, {  78,-22331 },
 {  79,-22331 }, {  80,-22331 }, {  81,-22331 }, {  82,-22331 }, {  83,-22331 },
 {  84,-22331 }, {  85,-22331 }, {  86,-22331 }, {  87,-22331 }, {  88,-22331 },
 {  89,-22331 }, {  90,-22331 }, {  91,-22331 }, {  92,-22331 }, {  93,-22331 },
 {  94,-22331 }, {  95,-22331 }, {  96,-22331 }, {  97,-22331 }, {  98,-22331 },
 {  99,-22331 }, { 100,-22331 }, { 101,-22331 }, { 102,-22331 }, { 103,-22331 },
 { 104,-22331 }, { 105,-22331 }, { 106,-22331 }, { 107,-22331 }, { 108,-22331 },
 { 109,-22331 }, { 110,-22331 }, { 111,-22331 }, { 112,-22331 }, { 113,-22331 },
 { 114,-22331 }, { 115,-22331 }, { 116,-22331 }, { 117,-22331 }, { 118,-22331 },
 { 119,-22331 }, { 120,-22331 }, { 121,-22331 }, { 122,-22331 }, { 123,-22331 },

 { 124,-22331 }, { 125,-22331 }, { 126,-22331 }, { 127,-22331 }, { 128,-22331 },
 { 129,-22331 }, { 130,-22331 }, { 131,-22331 }, { 132,-22331 }, { 133,-22331 },
 { 134,-22331 }, { 135,-22331 }, { 136,-22331 }, { 137,-22331 }, { 138,-22331 },
 { 139,-22331 }, { 140,-22331 }, { 141,-22331 }, { 142,-22331 }, { 143,-22331 },
 { 144,-22331 }, { 145,-22331 }, { 146,-22331 }, { 147,-22331 }, { 148,-22331 },
 { 149,-22331 }, { 150,-22331 }, { 151,-22331 }, { 152,-22331 }, { 153,-22331 },
 { 154,-22331 }, { 155,-22331 }, { 156,-22331 }, { 157,-22331 }, { 158,-22331 },
 { 159,-22331 }, { 160,-22331 }, { 161,-22331 }, { 162,-22331 }, { 163,-22331 },
 { 164,-22331 }, { 165,-22331 }, { 166,-22331 }, { 167,-22331 }, { 168,-22331 },
 { 169,-22331 }, { 170,-22331 }, { 171,-22331 }, { 172,-22331 }, { 173,-22331 },

 { 174,-22331 }, { 175,-22331 }, { 176,-22331 }, { 177,-22331 }, { 178,-22331 },
 { 179,-22331 }, { 180,-22331 }, { 181,-22331 }, { 182,-22331 }, { 183,-22331 },
 { 184,-22331 }, { 185,-22331 }, { 186,-22331 }, { 187,-22331 }, { 188,-22331 },
 { 189,-22331 }, { 190,-22331 }, { 191,-22331 }, { 192,-22331 }, { 193,-22331 },
 { 194,-22331 }, { 195,-22331 }, { 196,-22331 }, { 197,-22331 }, { 198,-22331 },
 { 199,-22331 }, { 200,-22331 }, { 201,-22331 }, { 202,-22331 }, { 203,-22331 },
 { 204,-22331 }, { 205,-22331 }, { 206,-22331 }, { 207,-22331 }, { 208,-22331 },
 { 209,-22331 }, { 210,-22331 }, { 211,-22331 }, { 212,-22331 }, { 213,-22331 },
 { 214,-22331 }, { 215,-22331 }, { 216,-22331 }, { 217,-22331 }, { 218,-22331 },
 { 219,-22331 }, { 220,-22331 }, { 221,-22331 }, { 222,-22331 }, { 223,-22331 },

 { 224,-22331 }, { 225,-22331 }, { 226,-22331 }, { 227,-22331 }, { 228,-22331 },
 { 229,-22331 }, { 230,-22331 }, { 231,-22331 }, { 232,-22331 }, { 233,-22331 },
 { 234,-22331 }, { 235,-22331 }, { 236,-22331 }, { 237,-22331 }, { 238,-22331 },
 { 239,-22331 }, { 240,-22331 }, { 241,-22331 }, { 242,-22331 }, { 243,-22331 },
 { 244,-22331 }, { 245,-22331 }, { 246,-22331 }, { 247,-22331 }, { 248,-22331 },
 { 249,-22331 }, { 250,-22331 }, { 251,-22331 }, { 252,-22331 }, { 253,-22331 },
 { 254,-22331 }, { 255,-22331 }, { 256,-22331 }, {   0,  28 }, {   0,6306 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,   0 }, {  10,   0 },
 {   0,   0 }, {  12,   0 }, {  13,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  32,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,  47 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-22596 },
 {   0,  28 }, {   0,6259 }, {   1,-22634 }, {   2,-22634 }, {   3,-22634 },
 {   4,-22634 }, {   5,-22634 }, {   6,-22634 }, {   7,-22634 }, {   8,-22634 },
 {   9,-22634 }, {  10,-22634 }, {  11,-22634 }, {  12,-22634 }, {  13,-22634 },
 {  14,-22634 }, {  15,-22634 }, {  16,-22634 }, {  17,-22634 }, {  18,-22634 },

 {  19,-22634 }, {  20,-22634 }, {  21,-22634 }, {  22,-22634 }, {  23,-22634 },
 {  24,-22634 }, {  25,-22634 }, {  26,-22634 }, {  27,-22634 }, {  28,-22634 },
 {  29,-22634 }, {  30,-22634 }, {  31,-22634 }, {  32,-22634 }, {  33,-22634 },
 {  34,-22634 }, {  35,-22634 }, {  36,-22634 }, {  37,-22634 }, {  38,-22634 },
 {   0,   0 }, {  40,-22634 }, {  41,-22634 }, {  42,-22634 }, {  43,-22634 },
 {  44,-22634 }, {  45,-22634 }, {  46,-22634 }, {  47,-22634 }, {  48,-22634 },
 {  49,-22634 }, {  50,-22634 }, {  51,-22634 }, {  52,-22634 }, {  53,-22634 },
 {  54,-22634 }, {  55,-22634 }, {  56,-22634 }, {  57,-22634 }, {  58,-22634 },
 {  59,-22634 }, {  60,-22634 }, {  61,-22634 }, {  62,-22634 }, {  63,-22634 },
 {  64,-22634 }, {  65,-22634 }, {  66,-22634 }, {  67,-22634 }, {  68,-22634 },

 {  69,-22634 }, {  70,-22634 }, {  71,-22634 }, {  72,-22634 }, {  73,-22634 },
 {  74,-22634 }, {  75,-22634 }, {  76,-22634 }, {  77,-22634 }, {  78,-22634 },
 {  79,-22634 }, {  80,-22634 }, {  81,-22634 }, {  82,-22634 }, {  83,-22634 },
 {  84,-22634 }, {  85,-22634 }, {  86,-22634 }, {  87,-22634 }, {  88,-22634 },
 {  89,-22634 }, {  90,-22634 }, {  91,-22634 }, {  92,-22634 }, {  93,-22634 },
 {  94,-22634 }, {  95,-22634 }, {  96,-22634 }, {  97,-22634 }, {  98,-22634 },
 {  99,-22634 }, { 100,-22634 }, { 101,-22634 }, { 102,-22634 }, { 103,-22634 },
 { 104,-22634 }, { 105,-22634 }, { 106,-22634 }, { 107,-22634 }, { 108,-22634 },
 { 109,-22634 }, { 110,-22634 }, { 111,-22634 }, { 112,-22634 }, { 113,-22634 },
 { 114,-22634 }, { 115,-22634 }, { 116,-22634 }, { 117,-22634 }, { 118,-22634 },

 { 119,-22634 }, { 120,-22634 }, { 121,-22634 }, { 122,-22634 }, { 123,-22634 },
 { 124,-22634 }, { 125,-22634 }, { 126,-22634 }, { 127,-22634 }, { 128,-22634 },
 { 129,-22634 }, { 130,-22634 }, { 131,-22634 }, { 132,-22634 }, { 133,-22634 },
 { 134,-22634 }, { 135,-22634 }, { 136,-22634 }, { 137,-22634 }, { 138,-22634 },
 { 139,-22634 }, { 140,-22634 }, { 141,-22634 }, { 142,-22634 }, { 143,-22634 },
 { 144,-22634 }, { 145,-22634 }, { 146,-22634 }, { 147,-22634 }, { 148,-22634 },
 { 149,-22634 }, { 150,-22634 }, { 151,-22634 }, { 152,-22634 }, { 153,-22634 },
 { 154,-22634 }, { 155,-22634 }, { 156,-22634 }, { 157,-22634 }, { 158,-22634 },
 { 159,-22634 }, { 160,-22634 }, { 161,-22634 }, { 162,-22634 }, { 163,-22634 },
 { 164,-22634 }, { 165,-22634 }, { 166,-22634 }, { 167,-22634 }, { 168,-22634 },

 { 169,-22634 }, { 170,-22634 }, { 171,-22634 }, { 172,-22634 }, { 173,-22634 },
 { 174,-22634 }, { 175,-22634 }, { 176,-22634 }, { 177,-22634 }, { 178,-22634 },
 { 179,-22634 }, { 180,-22634 }, { 181,-22634 }, { 182,-22634 }, { 183,-22634 },
 { 184,-22634 }, { 185,-22634 }, { 186,-22634 }, { 187,-22634 }, { 188,-22634 },
 { 189,-22634 }, { 190,-22634 }, { 191,-22634 }, { 192,-22634 }, { 193,-22634 },
 { 194,-22634 }, { 195,-22634 }, { 196,-22634 }, { 197,-22634 }, { 198,-22634 },
 { 199,-22634 }, { 200,-22634 }, { 201,-22634 }, { 202,-22634 }, { 203,-22634 },
 { 204,-22634 }, { 205,-22634 }, { 206,-22634 }, { 207,-22634 }, { 208,-22634 },
 { 209,-22634 }, { 210,-22634 }, { 211,-22634 }, { 212,-22634 }, { 213,-22634 },
 { 214,-22634 }, { 215,-22634 }, { 216,-22634 }, { 217,-22634 }, { 218,-22634 },

 { 219,-22634 }, { 220,-22634 }, { 221,-22634 }, { 222,-22634 }, { 223,-22634 },
 { 224,-22634 }, { 225,-22634 }, { 226,-22634 }, { 227,-22634 }, { 228,-22634 },
 { 229,-22634 }, { 230,-22634 }, { 231,-22634 }, { 232,-22634 }, { 233,-22634 },
 { 234,-22634 }, { 235,-22634 }, { 236,-22634 }, { 237,-22634 }, { 238,-22634 },
 { 239,-22634 }, { 240,-22634 }, { 241,-22634 }, { 242,-22634 }, { 243,-22634 },
 { 244,-22634 }, { 245,-22634 }, { 246,-22634 }, { 247,-22634 }, { 248,-22634 },
 { 249,-22634 }, { 250,-22634 }, { 251,-22634 }, { 252,-22634 }, { 253,-22634 },
 { 254,-22634 }, { 255,-22634 }, { 256,-22634 }, {   0,  37 }, {   0,6001 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  37 }, {   0,5978 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48, 643 }, {  49, 643 }, {  50, 643 },
 {  51, 643 }, {  52, 643 }, {  53, 643 }, {  54, 643 }, {  55, 643 },
 {  56, 643 }, {  57, 643 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65, 643 },
 {  66, 643 }, {  67, 643 }, {  68, 643 }, {  69, 643 }, {  70, 643 },
 {  48,-23179 }, {  49,-23179 }, {  50,-23179 }, {  51,-23179 }, {  52,-23179 },
 {  53,-23179 }, {  54,-23179 }, {  55,-23179 }, {  56,-23179 }, {  57,-23179 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-23179 }, {  66,-23179 }, {  67,-23179 },
 {  68,-23179 }, {  69,-23179 }, {  70,-23179 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97, 643 }, {  98, 643 }, {  99, 643 }, { 100, 643 },
 { 101, 643 }, { 102, 643 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,-23179 },
 {  98,-23179 }, {  99,-23179 }, { 100,-23179 }, { 101,-23179 }, { 102,-23179 },
 {   0,  55 }, {   0,5874 }, {   1, 620 }, {   2, 620 }, {   3, 620 },
 {   4, 620 }, {   5, 620 }, {   6, 620 }, {   7, 620 }, {   8, 620 },
 {   9, 878 }, {  10,-737 }, {  11, 620 }, {  12, 878 }, {  13,-737 },
 {  14, 620 }, {  15, 620 }, {  16, 620 }, {  17, 620 }, {  18, 620 },
 {  19, 620 }, {  20, 620 }, {  21, 620 }, {  22, 620 }, {  23, 620 },
 {  24, 620 }, {  25, 620 }, {  26, 620 }, {  27, 620 }, {  28, 620 },
 {  29, 620 }, {  30, 620 }, {  31, 620 }, {  32, 878 }, {  33, 620 },

 {  34, 620 }, {  35, 620 }, {  36, 620 }, {  37, 620 }, {  38, 620 },
 {  39,1136 }, {  40, 620 }, {  41, 620 }, {  42, 620 }, {  43, 620 },
 {  44, 620 }, {  45,1394 }, {  46, 620 }, {  47, 620 }, {  48, 620 },
 {  49, 620 }, {  50, 620 }, {  51, 620 }, {  52, 620 }, {  53, 620 },
 {  54, 620 }, {  55, 620 }, {  56, 620 }, {  57, 620 }, {  58, 620 },
 {  59, 620 }, {  60, 620 }, {  61, 620 }, {  62, 620 }, {  63, 620 },
 {  64, 620 }, {  65, 620 }, {  66, 620 }, {  67, 620 }, {  68, 620 },
 {  69, 620 }, {  70, 620 }, {  71, 620 }, {  72, 620 }, {  73, 620 },
 {  74, 620 }, {  75, 620 }, {  76, 620 }, {  77, 620 }, {  78, 620 },
 {  79, 620 }, {  80, 620 }, {  81, 620 }, {  82, 620 }, {  83, 620 },

 {  84, 620 }, {  85, 620 }, {  86, 620 }, {  87, 620 }, {  88, 620 },
 {  89, 620 }, {  90, 620 }, {  91, 620 }, {  92, 620 }, {  93, 620 },
 {  94, 620 }, {  95, 620 }, {  96, 620 }, {  97, 620 }, {  98, 620 },
 {  99, 620 }, { 100, 620 }, { 101, 620 }, { 102, 620 }, { 103, 620 },
 { 104, 620 }, { 105, 620 }, { 106, 620 }, { 107, 620 }, { 108, 620 },
 { 109, 620 }, { 110, 620 }, { 111, 620 }, { 112, 620 }, { 113, 620 },
 { 114, 620 }, { 115, 620 }, { 116, 620 }, { 117, 620 }, { 118, 620 },
 { 119, 620 }, { 120, 620 }, { 121, 620 }, { 122, 620 }, { 123, 620 },
 { 124, 620 }, { 125, 620 }, { 126, 620 }, { 127, 620 }, { 128, 620 },
 { 129, 620 }, { 130, 620 }, { 131, 620 }, { 132, 620 }, { 133, 620 },

 { 134, 620 }, { 135, 620 }, { 136, 620 }, { 137, 620 }, { 138, 620 },
 { 139, 620 }, { 140, 620 }, { 141, 620 }, { 142, 620 }, { 143, 620 },
 { 144, 620 }, { 145, 620 }, { 146, 620 }, { 147, 620 }, { 148, 620 },
 { 149, 620 }, { 150, 620 }, { 151, 620 }, { 152, 620 }, { 153, 620 },
 { 154, 620 }, { 155, 620 }, { 156, 620 }, { 157, 620 }, { 158, 620 },
 { 159, 620 }, { 160, 620 }, { 161, 620 }, { 162, 620 }, { 163, 620 },
 { 164, 620 }, { 165, 620 }, { 166, 620 }, { 167, 620 }, { 168, 620 },
 { 169, 620 }, { 170, 620 }, { 171, 620 }, { 172, 620 }, { 173, 620 },
 { 174, 620 }, { 175, 620 }, { 176, 620 }, { 177, 620 }, { 178, 620 },
 { 179, 620 }, { 180, 620 }, { 181, 620 }, { 182, 620 }, { 183, 620 },

 { 184, 620 }, { 185, 620 }, { 186, 620 }, { 187, 620 }, { 188, 620 },
 { 189, 620 }, { 190, 620 }, { 191, 620 }, { 192, 620 }, { 193, 620 },
 { 194, 620 }, { 195, 620 }, { 196, 620 }, { 197, 620 }, { 198, 620 },
 { 199, 620 }, { 200, 620 }, { 201, 620 }, { 202, 620 }, { 203, 620 },
 { 204, 620 }, { 205, 620 }, { 206, 620 }, { 207, 620 }, { 208, 620 },
 { 209, 620 }, { 210, 620 }, { 211, 620 }, { 212, 620 }, { 213, 620 },
 { 214, 620 }, { 215, 620 }, { 216, 620 }, { 217, 620 }, { 218, 620 },
 { 219, 620 }, { 220, 620 }, { 221, 620 }, { 222, 620 }, { 223, 620 },
 { 224, 620 }, { 225, 620 }, { 226, 620 }, { 227, 620 }, { 228, 620 },
 { 229, 620 }, { 230, 620 }, { 231, 620 }, { 232, 620 }, { 233, 620 },

 { 234, 620 }, { 235, 620 }, { 236, 620 }, { 237, 620 }, { 238, 620 },
 { 239, 620 }, { 240, 620 }, { 241, 620 }, { 242, 620 }, { 243, 620 },
 { 244, 620 }, { 245, 620 }, { 246, 620 }, { 247, 620 }, { 248, 620 },
 { 249, 620 }, { 250, 620 }, { 251, 620 }, { 252, 620 }, { 253, 620 },
 { 254, 620 }, { 255, 620 }, { 256, 620 }, {   0,  28 }, {   0,5616 },
 {   1,1394 }, {   2,1394 }, {   3,1394 }, {   4,1394 }, {   5,1394 },
 {   6,1394 }, {   7,1394 }, {   8,1394 }, {   9,1652 }, {  10,-690 },
 {  11,1394 }, {  12,1652 }, {  13,-690 }, {  14,1394 }, {  15,1394 },
 {  16,1394 }, {  17,1394 }, {  18,1394 }, {  19,1394 }, {  20,1394 },
 {  21,1394 }, {  22,1394 }, {  23,1394 }, {  24,1394 }, {  25,1394 },

 {  26,1394 }, {  27,1394 }, {  28,1394 }, {  29,1394 }, {  30,1394 },
 {  31,1394 }, {  32,1652 }, {  33,1394 }, {  34,1394 }, {  35,1394 },
 {  36,1394 }, {  37,1394 }, {  38,1394 }, {  39,1910 }, {  40,1394 },
 {  41,1394 }, {  42,1394 }, {  43,1394 }, {  44,1394 }, {  45,2168 },
 {  46,1394 }, {  47,1394 }, {  48,1394 }, {  49,1394 }, {  50,1394 },
 {  51,1394 }, {  52,1394 }, {  53,1394 }, {  54,1394 }, {  55,1394 },
 {  56,1394 }, {  57,1394 }, {  58,1394 }, {  59,1394 }, {  60,1394 },
 {  61,1394 }, {  62,1394 }, {  63,1394 }, {  64,1394 }, {  65,1394 },
 {  66,1394 }, {  67,1394 }, {  68,1394 }, {  69,1394 }, {  70,1394 },
 {  71,1394 }, {  72,1394 }, {  73,1394 }, {  74,1394 }, {  75,1394 },

 {  76,1394 }, {  77,1394 }, {  78,1394 }, {  79,1394 }, {  80,1394 },
 {  81,1394 }, {  82,1394 }, {  83,1394 }, {  84,1394 }, {  85,1394 },
 {  86,1394 }, {  87,1394 }, {  88,1394 }, {  89,1394 }, {  90,1394 },
 {  91,1394 }, {  92,1394 }, {  93,1394 }, {  94,1394 }, {  95,1394 },
 {  96,1394 }, {  97,1394 }, {  98,1394 }, {  99,1394 }, { 100,1394 },
 { 101,1394 }, { 102,1394 }, { 103,1394 }, { 104,1394 }, { 105,1394 },
 { 106,1394 }, { 107,1394 }, { 108,1394 }, { 109,1394 }, { 110,1394 },
 { 111,1394 }, { 112,1394 }, { 113,1394 }, { 114,1394 }, { 115,1394 },
 { 116,1394 }, { 117,1394 }, { 118,1394 }, { 119,1394 }, { 120,1394 },
 { 121,1394 }, { 122,1394 }, { 123,1394 }, { 124,1394 }, { 125,1394 },

 { 126,1394 }, { 127,1394 }, { 128,1394 }, { 129,1394 }, { 130,1394 },
 { 131,1394 }, { 132,1394 }, { 133,1394 }, { 134,1394 }, { 135,1394 },
 { 136,1394 }, { 137,1394 }, { 138,1394 }, { 139,1394 }, { 140,1394 },
 { 141,1394 }, { 142,1394 }, { 143,1394 }, { 144,1394 }, { 145,1394 },
 { 146,1394 }, { 147,1394 }, { 148,1394 }, { 149,1394 }, { 150,1394 },
 { 151,1394 }, { 152,1394 }, { 153,1394 }, { 154,1394 }, { 155,1394 },
 { 156,1394 }, { 157,1394 }, { 158,1394 }, { 159,1394 }, { 160,1394 },
 { 161,1394 }, { 162,1394 }, { 163,1394 }, { 164,1394 }, { 165,1394 },
 { 166,1394 }, { 167,1394 }, { 168,1394 }, { 169,1394 }, { 170,1394 },
 { 171,1394 }, { 172,1394 }, { 173,1394 }, { 174,1394 }, { 175,1394 },

 { 176,1394 }, { 177,1394 }, { 178,1394 }, { 179,1394 }, { 180,1394 },
 { 181,1394 }, { 182,1394 }, { 183,1394 }, { 184,1394 }, { 185,1394 },
 { 186,1394 }, { 187,1394 }, { 188,1394 }, { 189,1394 }, { 190,1394 },
 { 191,1394 }, { 192,1394 }, { 193,1394 }, { 194,1394 }, { 195,1394 },
 { 196,1394 }, { 197,1394 }, { 198,1394 }, { 199,1394 }, { 200,1394 },
 { 201,1394 }, { 202,1394 }, { 203,1394 }, { 204,1394 }, { 205,1394 },
 { 206,1394 }, { 207,1394 }, { 208,1394 }, { 209,1394 }, { 210,1394 },
 { 211,1394 }, { 212,1394 }, { 213,1394 }, { 214,1394 }, { 215,1394 },
 { 216,1394 }, { 217,1394 }, { 218,1394 }, { 219,1394 }, { 220,1394 },
 { 221,1394 }, { 222,1394 }, { 223,1394 }, { 224,1394 }, { 225,1394 },

 { 226,1394 }, { 227,1394 }, { 228,1394 }, { 229,1394 }, { 230,1394 },
 { 231,1394 }, { 232,1394 }, { 233,1394 }, { 234,1394 }, { 235,1394 },
 { 236,1394 }, { 237,1394 }, { 238,1394 }, { 239,1394 }, { 240,1394 },
 { 241,1394 }, { 242,1394 }, { 243,1394 }, { 244,1394 }, { 245,1394 },
 { 246,1394 }, { 247,1394 }, { 248,1394 }, { 249,1394 }, { 250,1394 },
 { 251,1394 }, { 252,1394 }, { 253,1394 }, { 254,1394 }, { 255,1394 },
 { 256,1394 }, {   0,  37 }, {   0,5358 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,-23787 }, {  49,-23787 }, {  50,-23787 }, {  51,-23787 }, {  52,-23787 },
 {  53,-23787 }, {  54,-23787 }, {  55,-23787 }, {  56,-23787 }, {  57,-23787 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-23787 }, {  66,-23787 }, {  67,-23787 },

 {  68,-23787 }, {  69,-23787 }, {  70,-23787 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,-23787 },
 {  98,-23787 }, {  99,-23787 }, { 100,-23787 }, { 101,-23787 }, { 102,-23787 },
 {   0,  55 }, {   0,5254 }, {   1,   0 }, {   2,   0 }, {   3,   0 },
 {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 },
 {   9, 258 }, {  10,-1357 }, {  11,   0 }, {  12, 258 }, {  13,-1357 },

 {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 },
 {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 },
 {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 },
 {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32, 258 }, {  33,   0 },
 {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 },
 {  39, 516 }, {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 },
 {  44,   0 }, {  45, 774 }, {  46,   0 }, {  47,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 },
 {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 },

 {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },
 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },
 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },
 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },
 {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 },
 {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },
 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },
 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },

 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },
 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 },
 { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 },
 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },
 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },
 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },
 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },
 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },

 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },
 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },
 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },
 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },
 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },
 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },
 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },

 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },
 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },
 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },
 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },
 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },
 { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  55 }, {   0,4996 },
 {   1,-258 }, {   2,-258 }, {   3,-258 }, {   4,-258 }, {   5,-258 },

 {   6,-258 }, {   7,-258 }, {   8,-258 }, {   9,   0 }, {  10,-1615 },
 {  11,-258 }, {  12,   0 }, {  13,-1615 }, {  14,-258 }, {  15,-258 },
 {  16,-258 }, {  17,-258 }, {  18,-258 }, {  19,-258 }, {  20,-258 },
 {  21,-258 }, {  22,-258 }, {  23,-258 }, {  24,-258 }, {  25,-258 },
 {  26,-258 }, {  27,-258 }, {  28,-258 }, {  29,-258 }, {  30,-258 },
 {  31,-258 }, {  32,   0 }, {  33,-258 }, {  34,-258 }, {  35,-258 },
 {  36,-258 }, {  37,-258 }, {  38,-258 }, {  39, 258 }, {  40,-258 },
 {  41,-258 }, {  42,-258 }, {  43,-258 }, {  44,-258 }, {  45, 516 },
 {  46,-258 }, {  47,-258 }, {  48,-258 }, {  49,-258 }, {  50,-258 },
 {  51,-258 }, {  52,-258 }, {  53,-258 }, {  54,-258 }, {  55,-258 },

 {  56,-258 }, {  57,-258 }, {  58,-258 }, {  59,-258 }, {  60,-258 },
 {  61,-258 }, {  62,-258 }, {  63,-258 }, {  64,-258 }, {  65,-258 },
 {  66,-258 }, {  67,-258 }, {  68,-258 }, {  69,-258 }, {  70,-258 },
 {  71,-258 }, {  72,-258 }, {  73,-258 }, {  74,-258 }, {  75,-258 },
 {  76,-258 }, {  77,-258 }, {  78,-258 }, {  79,-258 }, {  80,-258 },
 {  81,-258 }, {  82,-258 }, {  83,-258 }, {  84,-258 }, {  85,-258 },
 {  86,-258 }, {  87,-258 }, {  88,-258 }, {  89,-258 }, {  90,-258 },
 {  91,-258 }, {  92,-258 }, {  93,-258 }, {  94,-258 }, {  95,-258 },
 {  96,-258 }, {  97,-258 }, {  98,-258 }, {  99,-258 }, { 100,-258 },
 { 101,-258 }, { 102,-258 }, { 103,-258 }, { 104,-258 }, { 105,-258 },

 { 106,-258 }, { 107,-258 }, { 108,-258 }, { 109,-258 }, { 110,-258 },
 { 111,-258 }, { 112,-258 }, { 113,-258 }, { 114,-258 }, { 115,-258 },
 { 116,-258 }, { 117,-258 }, { 118,-258 }, { 119,-258 }, { 120,-258 },
 { 121,-258 }, { 122,-258 }, { 123,-258 }, { 124,-258 }, { 125,-258 },
 { 126,-258 }, { 127,-258 }, { 128,-258 }, { 129,-258 }, { 130,-258 },
 { 131,-258 }, { 132,-258 }, { 133,-258 }, { 134,-258 }, { 135,-258 },
 { 136,-258 }, { 137,-258 }, { 138,-258 }, { 139,-258 }, { 140,-258 },
 { 141,-258 }, { 142,-258 }, { 143,-258 }, { 144,-258 }, { 145,-258 },
 { 146,-258 }, { 147,-258 }, { 148,-258 }, { 149,-258 }, { 150,-258 },
 { 151,-258 }, { 152,-258 }, { 153,-258 }, { 154,-258 }, { 155,-258 },

 { 156,-258 }, { 157,-258 }, { 158,-258 }, { 159,-258 }, { 160,-258 },
 { 161,-258 }, { 162,-258 }, { 163,-258 }, { 164,-258 }, { 165,-258 },
 { 166,-258 }, { 167,-258 }, { 168,-258 }, { 169,-258 }, { 170,-258 },
 { 171,-258 }, { 172,-258 }, { 173,-258 }, { 174,-258 }, { 175,-258 },
 { 176,-258 }, { 177,-258 }, { 178,-258 }, { 179,-258 }, { 180,-258 },
 { 181,-258 }, { 182,-258 }, { 183,-258 }, { 184,-258 }, { 185,-258 },
 { 186,-258 }, { 187,-258 }, { 188,-258 }, { 189,-258 }, { 190,-258 },
 { 191,-258 }, { 192,-258 }, { 193,-258 }, { 194,-258 }, { 195,-258 },
 { 196,-258 }, { 197,-258 }, { 198,-258 }, { 199,-258 }, { 200,-258 },
 { 201,-258 }, { 202,-258 }, { 203,-258 }, { 204,-258 }, { 205,-258 },

 { 206,-258 }, { 207,-258 }, { 208,-258 }, { 209,-258 }, { 210,-258 },
 { 211,-258 }, { 212,-258 }, { 213,-258 }, { 214,-258 }, { 215,-258 },
 { 216,-258 }, { 217,-258 }, { 218,-258 }, { 219,-258 }, { 220,-258 },
 { 221,-258 }, { 222,-258 }, { 223,-258 }, { 224,-258 }, { 225,-258 },
 { 226,-258 }, { 227,-258 }, { 228,-258 }, { 229,-258 }, { 230,-258 },
 { 231,-258 }, { 232,-258 }, { 233,-258 }, { 234,-258 }, { 235,-258 },
 { 236,-258 }, { 237,-258 }, { 238,-258 }, { 239,-258 }, { 240,-258 },
 { 241,-258 }, { 242,-258 }, { 243,-258 }, { 244,-258 }, { 245,-258 },
 { 246,-258 }, { 247,-258 }, { 248,-258 }, { 249,-258 }, { 250,-258 },
 { 251,-258 }, { 252,-258 }, { 253,-258 }, { 254,-258 }, { 255,-258 },

 { 256,-258 }, {   0,  55 }, {   0,4738 }, {   1,1548 }, {   2,1548 },
 {   3,1548 }, {   4,1548 }, {   5,1548 }, {   6,1548 }, {   7,1548 },
 {   8,1548 }, {   9,1806 }, {  10,2064 }, {  11,1548 }, {  12,1806 },
 {  13,2064 }, {  14,1548 }, {  15,1548 }, {  16,1548 }, {  17,1548 },
 {  18,1548 }, {  19,1548 }, {  20,1548 }, {  21,1548 }, {  22,1548 },
 {  23,1548 }, {  24,1548 }, {  25,1548 }, {  26,1548 }, {  27,1548 },
 {  28,1548 }, {  29,1548 }, {  30,1548 }, {  31,1548 }, {  32,1806 },
 {  33,1548 }, {  34,1548 }, {  35,1548 }, {  36,1548 }, {  37,1548 },
 {  38,1548 }, {  39,   0 }, {  40,1548 }, {  41,1548 }, {  42,1548 },
 {  43,1548 }, {  44,1548 }, {  45,2111 }, {  46,1548 }, {  47,1548 },

 {  48,1548 }, {  49,1548 }, {  50,1548 }, {  51,1548 }, {  52,1548 },
 {  53,1548 }, {  54,1548 }, {  55,1548 }, {  56,1548 }, {  57,1548 },
 {  58,1548 }, {  59,1548 }, {  60,1548 }, {  61,1548 }, {  62,1548 },
 {  63,1548 }, {  64,1548 }, {  65,1548 }, {  66,1548 }, {  67,1548 },
 {  68,1548 }, {  69,1548 }, {  70,1548 }, {  71,1548 }, {  72,1548 },
 {  73,1548 }, {  74,1548 }, {  75,1548 }, {  76,1548 }, {  77,1548 },
 {  78,1548 }, {  79,1548 }, {  80,1548 }, {  81,1548 }, {  82,1548 },
 {  83,1548 }, {  84,1548 }, {  85,1548 }, {  86,1548 }, {  87,1548 },
 {  88,1548 }, {  89,1548 }, {  90,1548 }, {  91,1548 }, {  92,1548 },
 {  93,1548 }, {  94,1548 }, {  95,1548 }, {  96,1548 }, {  97,1548 },

 {  98,1548 }, {  99,1548 }, { 100,1548 }, { 101,1548 }, { 102,1548 },
 { 103,1548 }, { 104,1548 }, { 105,1548 }, { 106,1548 }, { 107,1548 },
 { 108,1548 }, { 109,1548 }, { 110,1548 }, { 111,1548 }, { 112,1548 },
 { 113,1548 }, { 114,1548 }, { 115,1548 }, { 116,1548 }, { 117,1548 },
 { 118,1548 }, { 119,1548 }, { 120,1548 }, { 121,1548 }, { 122,1548 },
 { 123,1548 }, { 124,1548 }, { 125,1548 }, { 126,1548 }, { 127,1548 },
 { 128,1548 }, { 129,1548 }, { 130,1548 }, { 131,1548 }, { 132,1548 },
 { 133,1548 }, { 134,1548 }, { 135,1548 }, { 136,1548 }, { 137,1548 },
 { 138,1548 }, { 139,1548 }, { 140,1548 }, { 141,1548 }, { 142,1548 },
 { 143,1548 }, { 144,1548 }, { 145,1548 }, { 146,1548 }, { 147,1548 },

 { 148,1548 }, { 149,1548 }, { 150,1548 }, { 151,1548 }, { 152,1548 },
 { 153,1548 }, { 154,1548 }, { 155,1548 }, { 156,1548 }, { 157,1548 },
 { 158,1548 }, { 159,1548 }, { 160,1548 }, { 161,1548 }, { 162,1548 },
 { 163,1548 }, { 164,1548 }, { 165,1548 }, { 166,1548 }, { 167,1548 },
 { 168,1548 }, { 169,1548 }, { 170,1548 }, { 171,1548 }, { 172,1548 },
 { 173,1548 }, { 174,1548 }, { 175,1548 }, { 176,1548 }, { 177,1548 },
 { 178,1548 }, { 179,1548 }, { 180,1548 }, { 181,1548 }, { 182,1548 },
 { 183,1548 }, { 184,1548 }, { 185,1548 }, { 186,1548 }, { 187,1548 },
 { 188,1548 }, { 189,1548 }, { 190,1548 }, { 191,1548 }, { 192,1548 },
 { 193,1548 }, { 194,1548 }, { 195,1548 }, { 196,1548 }, { 197,1548 },

 { 198,1548 }, { 199,1548 }, { 200,1548 }, { 201,1548 }, { 202,1548 },
 { 203,1548 }, { 204,1548 }, { 205,1548 }, { 206,1548 }, { 207,1548 },
 { 208,1548 }, { 209,1548 }, { 210,1548 }, { 211,1548 }, { 212,1548 },
 { 213,1548 }, { 214,1548 }, { 215,1548 }, { 216,1548 }, { 217,1548 },
 { 218,1548 }, { 219,1548 }, { 220,1548 }, { 221,1548 }, { 222,1548 },
 { 223,1548 }, { 224,1548 }, { 225,1548 }, { 226,1548 }, { 227,1548 },
 { 228,1548 }, { 229,1548 }, { 230,1548 }, { 231,1548 }, { 232,1548 },
 { 233,1548 }, { 234,1548 }, { 235,1548 }, { 236,1548 }, { 237,1548 },
 { 238,1548 }, { 239,1548 }, { 240,1548 }, { 241,1548 }, { 242,1548 },
 { 243,1548 }, { 244,1548 }, { 245,1548 }, { 246,1548 }, { 247,1548 },

 { 248,1548 }, { 249,1548 }, { 250,1548 }, { 251,1548 }, { 252,1548 },
 { 253,1548 }, { 254,1548 }, { 255,1548 }, { 256,1548 }, {   0,  55 },
 {   0,4480 }, {   1,-774 }, {   2,-774 }, {   3,-774 }, {   4,-774 },
 {   5,-774 }, {   6,-774 }, {   7,-774 }, {   8,-774 }, {   9,-516 },
 {  10,-2131 }, {  11,-774 }, {  12,-516 }, {  13,-2131 }, {  14,-774 },
 {  15,-774 }, {  16,-774 }, {  17,-774 }, {  18,-774 }, {  19,-774 },
 {  20,-774 }, {  21,-774 }, {  22,-774 }, {  23,-774 }, {  24,-774 },
 {  25,-774 }, {  26,-774 }, {  27,-774 }, {  28,-774 }, {  29,-774 },
 {  30,-774 }, {  31,-774 }, {  32,-516 }, {  33,-774 }, {  34,-774 },
 {  35,-774 }, {  36,-774 }, {  37,-774 }, {  38,-774 }, {  39,-258 },

 {  40,-774 }, {  41,-774 }, {  42,-774 }, {  43,-774 }, {  44,-774 },
 {  45,2111 }, {  46,-774 }, {  47,-774 }, {  48,-774 }, {  49,-774 },
 {  50,-774 }, {  51,-774 }, {  52,-774 }, {  53,-774 }, {  54,-774 },
 {  55,-774 }, {  56,-774 }, {  57,-774 }, {  58,-774 }, {  59,-774 },
 {  60,-774 }, {  61,-774 }, {  62,-774 }, {  63,-774 }, {  64,-774 },
 {  65,-774 }, {  66,-774 }, {  67,-774 }, {  68,-774 }, {  69,-774 },
 {  70,-774 }, {  71,-774 }, {  72,-774 }, {  73,-774 }, {  74,-774 },
 {  75,-774 }, {  76,-774 }, {  77,-774 }, {  78,-774 }, {  79,-774 },
 {  80,-774 }, {  81,-774 }, {  82,-774 }, {  83,-774 }, {  84,-774 },
 {  85,-774 }, {  86,-774 }, {  87,-774 }, {  88,-774 }, {  89,-774 },

 {  90,-774 }, {  91,-774 }, {  92,-774 }, {  93,-774 }, {  94,-774 },
 {  95,-774 }, {  96,-774 }, {  97,-774 }, {  98,-774 }, {  99,-774 },
 { 100,-774 }, { 101,-774 }, { 102,-774 }, { 103,-774 }, { 104,-774 },
 { 105,-774 }, { 106,-774 }, { 107,-774 }, { 108,-774 }, { 109,-774 },
 { 110,-774 }, { 111,-774 }, { 112,-774 }, { 113,-774 }, { 114,-774 },
 { 115,-774 }, { 116,-774 }, { 117,-774 }, { 118,-774 }, { 119,-774 },
 { 120,-774 }, { 121,-774 }, { 122,-774 }, { 123,-774 }, { 124,-774 },
 { 125,-774 }, { 126,-774 }, { 127,-774 }, { 128,-774 }, { 129,-774 },
 { 130,-774 }, { 131,-774 }, { 132,-774 }, { 133,-774 }, { 134,-774 },
 { 135,-774 }, { 136,-774 }, { 137,-774 }, { 138,-774 }, { 139,-774 },

 { 140,-774 }, { 141,-774 }, { 142,-774 }, { 143,-774 }, { 144,-774 },
 { 145,-774 }, { 146,-774 }, { 147,-774 }, { 148,-774 }, { 149,-774 },
 { 150,-774 }, { 151,-774 }, { 152,-774 }, { 153,-774 }, { 154,-774 },
 { 155,-774 }, { 156,-774 }, { 157,-774 }, { 158,-774 }, { 159,-774 },
 { 160,-774 }, { 161,-774 }, { 162,-774 }, { 163,-774 }, { 164,-774 },
 { 165,-774 }, { 166,-774 }, { 167,-774 }, { 168,-774 }, { 169,-774 },
 { 170,-774 }, { 171,-774 }, { 172,-774 }, { 173,-774 }, { 174,-774 },
 { 175,-774 }, { 176,-774 }, { 177,-774 }, { 178,-774 }, { 179,-774 },
 { 180,-774 }, { 181,-774 }, { 182,-774 }, { 183,-774 }, { 184,-774 },
 { 185,-774 }, { 186,-774 }, { 187,-774 }, { 188,-774 }, { 189,-774 },

 { 190,-774 }, { 191,-774 }, { 192,-774 }, { 193,-774 }, { 194,-774 },
 { 195,-774 }, { 196,-774 }, { 197,-774 }, { 198,-774 }, { 199,-774 },
 { 200,-774 }, { 201,-774 }, { 202,-774 }, { 203,-774 }, { 204,-774 },
 { 205,-774 }, { 206,-774 }, { 207,-774 }, { 208,-774 }, { 209,-774 },
 { 210,-774 }, { 211,-774 }, { 212,-774 }, { 213,-774 }, { 214,-774 },
 { 215,-774 }, { 216,-774 }, { 217,-774 }, { 218,-774 }, { 219,-774 },
 { 220,-774 }, { 221,-774 }, { 222,-774 }, { 223,-774 }, { 224,-774 },
 { 225,-774 }, { 226,-774 }, { 227,-774 }, { 228,-774 }, { 229,-774 },
 { 230,-774 }, { 231,-774 }, { 232,-774 }, { 233,-774 }, { 234,-774 },
 { 235,-774 }, { 236,-774 }, { 237,-774 }, { 238,-774 }, { 239,-774 },

 { 240,-774 }, { 241,-774 }, { 242,-774 }, { 243,-774 }, { 244,-774 },
 { 245,-774 }, { 246,-774 }, { 247,-774 }, { 248,-774 }, { 249,-774 },
 { 250,-774 }, { 251,-774 }, { 252,-774 }, { 253,-774 }, { 254,-774 },
 { 255,-774 }, { 256,-774 }, {   0,  28 }, {   0,4222 }, {   1,   0 },
 {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 },
 {   7,   0 }, {   8,   0 }, {   9, 258 }, {  10,-2084 }, {  11,   0 },
 {  12, 258 }, {  13,-2084 }, {  14,   0 }, {  15,   0 }, {  16,   0 },
 {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 },
 {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 },
 {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 },

 {  32, 258 }, {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 },
 {  37,   0 }, {  38,   0 }, {  39, 516 }, {  40,   0 }, {  41,   0 },
 {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45, 774 }, {  46,   0 },
 {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },

 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 },
 {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 },
 { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },

 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },

 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },

 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 },
 {   0,  28 }, {   0,3964 }, {   1,-258 }, {   2,-258 }, {   3,-258 },
 {   4,-258 }, {   5,-258 }, {   6,-258 }, {   7,-258 }, {   8,-258 },
 {   9,   0 }, {  10,-2342 }, {  11,-258 }, {  12,   0 }, {  13,-2342 },
 {  14,-258 }, {  15,-258 }, {  16,-258 }, {  17,-258 }, {  18,-258 },
 {  19,-258 }, {  20,-258 }, {  21,-258 }, {  22,-258 }, {  23,-258 },

 {  24,-258 }, {  25,-258 }, {  26,-258 }, {  27,-258 }, {  28,-258 },
 {  29,-258 }, {  30,-258 }, {  31,-258 }, {  32,   0 }, {  33,-258 },
 {  34,-258 }, {  35,-258 }, {  36,-258 }, {  37,-258 }, {  38,-258 },
 {  39, 258 }, {  40,-258 }, {  41,-258 }, {  42,-258 }, {  43,-258 },
 {  44,-258 }, {  45, 516 }, {  46,-258 }, {  47,-258 }, {  48,-258 },
 {  49,-258 }, {  50,-258 }, {  51,-258 }, {  52,-258 }, {  53,-258 },
 {  54,-258 }, {  55,-258 }, {  56,-258 }, {  57,-258 }, {  58,-258 },
 {  59,-258 }, {  60,-258 }, {  61,-258 }, {  62,-258 }, {  63,-258 },
 {  64,-258 }, {  65,-258 }, {  66,-258 }, {  67,-258 }, {  68,-258 },
 {  69,-258 }, {  70,-258 }, {  71,-258 }, {  72,-258 }, {  73,-258 },

 {  74,-258 }, {  75,-258 }, {  76,-258 }, {  77,-258 }, {  78,-258 },
 {  79,-258 }, {  80,-258 }, {  81,-258 }, {  82,-258 }, {  83,-258 },
 {  84,-258 }, {  85,-258 }, {  86,-258 }, {  87,-258 }, {  88,-258 },
 {  89,-258 }, {  90,-258 }, {  91,-258 }, {  92,-258 }, {  93,-258 },
 {  94,-258 }, {  95,-258 }, {  96,-258 }, {  97,-258 }, {  98,-258 },
 {  99,-258 }, { 100,-258 }, { 101,-258 }, { 102,-258 }, { 103,-258 },
 { 104,-258 }, { 105,-258 }, { 106,-258 }, { 107,-258 }, { 108,-258 },
 { 109,-258 }, { 110,-258 }, { 111,-258 }, { 112,-258 }, { 113,-258 },
 { 114,-258 }, { 115,-258 }, { 116,-258 }, { 117,-258 }, { 118,-258 },
 { 119,-258 }, { 120,-258 }, { 121,-258 }, { 122,-258 }, { 123,-258 },

 { 124,-258 }, { 125,-258 }, { 126,-258 }, { 127,-258 }, { 128,-258 },
 { 129,-258 }, { 130,-258 }, { 131,-258 }, { 132,-258 }, { 133,-258 },
 { 134,-258 }, { 135,-258 }, { 136,-258 }, { 137,-258 }, { 138,-258 },
 { 139,-258 }, { 140,-258 }, { 141,-258 }, { 142,-258 }, { 143,-258 },
 { 144,-258 }, { 145,-258 }, { 146,-258 }, { 147,-258 }, { 148,-258 },
 { 149,-258 }, { 150,-258 }, { 151,-258 }, { 152,-258 }, { 153,-258 },
 { 154,-258 }, { 155,-258 }, { 156,-258 }, { 157,-258 }, { 158,-258 },
 { 159,-258 }, { 160,-258 }, { 161,-258 }, { 162,-258 }, { 163,-258 },
 { 164,-258 }, { 165,-258 }, { 166,-258 }, { 167,-258 }, { 168,-258 },
 { 169,-258 }, { 170,-258 }, { 171,-258 }, { 172,-258 }, { 173,-258 },

 { 174,-258 }, { 175,-258 }, { 176,-258 }, { 177,-258 }, { 178,-258 },
 { 179,-258 }, { 180,-258 }, { 181,-258 }, { 182,-258 }, { 183,-258 },
 { 184,-258 }, { 185,-258 }, { 186,-258 }, { 187,-258 }, { 188,-258 },
 { 189,-258 }, { 190,-258 }, { 191,-258 }, { 192,-258 }, { 193,-258 },
 { 194,-258 }, { 195,-258 }, { 196,-258 }, { 197,-258 }, { 198,-258 },
 { 199,-258 }, { 200,-258 }, { 201,-258 }, { 202,-258 }, { 203,-258 },
 { 204,-258 }, { 205,-258 }, { 206,-258 }, { 207,-258 }, { 208,-258 },
 { 209,-258 }, { 210,-258 }, { 211,-258 }, { 212,-258 }, { 213,-258 },
 { 214,-258 }, { 215,-258 }, { 216,-258 }, { 217,-258 }, { 218,-258 },
 { 219,-258 }, { 220,-258 }, { 221,-258 }, { 222,-258 }, { 223,-258 },

 { 224,-258 }, { 225,-258 }, { 226,-258 }, { 227,-258 }, { 228,-258 },
 { 229,-258 }, { 230,-258 }, { 231,-258 }, { 232,-258 }, { 233,-258 },
 { 234,-258 }, { 235,-258 }, { 236,-258 }, { 237,-258 }, { 238,-258 },
 { 239,-258 }, { 240,-258 }, { 241,-258 }, { 242,-258 }, { 243,-258 },
 { 244,-258 }, { 245,-258 }, { 246,-258 }, { 247,-258 }, { 248,-258 },
 { 249,-258 }, { 250,-258 }, { 251,-258 }, { 252,-258 }, { 253,-258 },
 { 254,-258 }, { 255,-258 }, { 256,-258 }, {   0,  28 }, {   0,3706 },
 {   1,1595 }, {   2,1595 }, {   3,1595 }, {   4,1595 }, {   5,1595 },
 {   6,1595 }, {   7,1595 }, {   8,1595 }, {   9,1853 }, {  10,2111 },
 {  11,1595 }, {  12,1853 }, {  13,2111 }, {  14,1595 }, {  15,1595 },

 {  16,1595 }, {  17,1595 }, {  18,1595 }, {  19,1595 }, {  20,1595 },
 {  21,1595 }, {  22,1595 }, {  23,1595 }, {  24,1595 }, {  25,1595 },
 {  26,1595 }, {  27,1595 }, {  28,1595 }, {  29,1595 }, {  30,1595 },
 {  31,1595 }, {  32,1853 }, {  33,1595 }, {  34,1595 }, {  35,1595 },
 {  36,1595 }, {  37,1595 }, {  38,1595 }, {  39,   0 }, {  40,1595 },
 {  41,1595 }, {  42,1595 }, {  43,1595 }, {  44,1595 }, {  45,2158 },
 {  46,1595 }, {  47,1595 }, {  48,1595 }, {  49,1595 }, {  50,1595 },
 {  51,1595 }, {  52,1595 }, {  53,1595 }, {  54,1595 }, {  55,1595 },
 {  56,1595 }, {  57,1595 }, {  58,1595 }, {  59,1595 }, {  60,1595 },
 {  61,1595 }, {  62,1595 }, {  63,1595 }, {  64,1595 }, {  65,1595 },

 {  66,1595 }, {  67,1595 }, {  68,1595 }, {  69,1595 }, {  70,1595 },
 {  71,1595 }, {  72,1595 }, {  73,1595 }, {  74,1595 }, {  75,1595 },
 {  76,1595 }, {  77,1595 }, {  78,1595 }, {  79,1595 }, {  80,1595 },
 {  81,1595 }, {  82,1595 }, {  83,1595 }, {  84,1595 }, {  85,1595 },
 {  86,1595 }, {  87,1595 }, {  88,1595 }, {  89,1595 }, {  90,1595 },
 {  91,1595 }, {  92,1595 }, {  93,1595 }, {  94,1595 }, {  95,1595 },
 {  96,1595 }, {  97,1595 }, {  98,1595 }, {  99,1595 }, { 100,1595 },
 { 101,1595 }, { 102,1595 }, { 103,1595 }, { 104,1595 }, { 105,1595 },
 { 106,1595 }, { 107,1595 }, { 108,1595 }, { 109,1595 }, { 110,1595 },
 { 111,1595 }, { 112,1595 }, { 113,1595 }, { 114,1595 }, { 115,1595 },

 { 116,1595 }, { 117,1595 }, { 118,1595 }, { 119,1595 }, { 120,1595 },
 { 121,1595 }, { 122,1595 }, { 123,1595 }, { 124,1595 }, { 125,1595 },
 { 126,1595 }, { 127,1595 }, { 128,1595 }, { 129,1595 }, { 130,1595 },
 { 131,1595 }, { 132,1595 }, { 133,1595 }, { 134,1595 }, { 135,1595 },
 { 136,1595 }, { 137,1595 }, { 138,1595 }, { 139,1595 }, { 140,1595 },
 { 141,1595 }, { 142,1595 }, { 143,1595 }, { 144,1595 }, { 145,1595 },
 { 146,1595 }, { 147,1595 }, { 148,1595 }, { 149,1595 }, { 150,1595 },
 { 151,1595 }, { 152,1595 }, { 153,1595 }, { 154,1595 }, { 155,1595 },
 { 156,1595 }, { 157,1595 }, { 158,1595 }, { 159,1595 }, { 160,1595 },
 { 161,1595 }, { 162,1595 }, { 163,1595 }, { 164,1595 }, { 165,1595 },

 { 166,1595 }, { 167,1595 }, { 168,1595 }, { 169,1595 }, { 170,1595 },
 { 171,1595 }, { 172,1595 }, { 173,1595 }, { 174,1595 }, { 175,1595 },
 { 176,1595 }, { 177,1595 }, { 178,1595 }, { 179,1595 }, { 180,1595 },
 { 181,1595 }, { 182,1595 }, { 183,1595 }, { 184,1595 }, { 185,1595 },
 { 186,1595 }, { 187,1595 }, { 188,1595 }, { 189,1595 }, { 190,1595 },
 { 191,1595 }, { 192,1595 }, { 193,1595 }, { 194,1595 }, { 195,1595 },
 { 196,1595 }, { 197,1595 }, { 198,1595 }, { 199,1595 }, { 200,1595 },
 { 201,1595 }, { 202,1595 }, { 203,1595 }, { 204,1595 }, { 205,1595 },
 { 206,1595 }, { 207,1595 }, { 208,1595 }, { 209,1595 }, { 210,1595 },
 { 211,1595 }, { 212,1595 }, { 213,1595 }, { 214,1595 }, { 215,1595 },

 { 216,1595 }, { 217,1595 }, { 218,1595 }, { 219,1595 }, { 220,1595 },
 { 221,1595 }, { 222,1595 }, { 223,1595 }, { 224,1595 }, { 225,1595 },
 { 226,1595 }, { 227,1595 }, { 228,1595 }, { 229,1595 }, { 230,1595 },
 { 231,1595 }, { 232,1595 }, { 233,1595 }, { 234,1595 }, { 235,1595 },
 { 236,1595 }, { 237,1595 }, { 238,1595 }, { 239,1595 }, { 240,1595 },
 { 241,1595 }, { 242,1595 }, { 243,1595 }, { 244,1595 }, { 245,1595 },
 { 246,1595 }, { 247,1595 }, { 248,1595 }, { 249,1595 }, { 250,1595 },
 { 251,1595 }, { 252,1595 }, { 253,1595 }, { 254,1595 }, { 255,1595 },
 { 256,1595 }, {   0,  28 }, {   0,3448 }, {   1,-774 }, {   2,-774 },
 {   3,-774 }, {   4,-774 }, {   5,-774 }, {   6,-774 }, {   7,-774 },

 {   8,-774 }, {   9,-516 }, {  10,-2858 }, {  11,-774 }, {  12,-516 },
 {  13,-2858 }, {  14,-774 }, {  15,-774 }, {  16,-774 }, {  17,-774 },
 {  18,-774 }, {  19,-774 }, {  20,-774 }, {  21,-774 }, {  22,-774 },
 {  23,-774 }, {  24,-774 }, {  25,-774 }, {  26,-774 }, {  27,-774 },
 {  28,-774 }, {  29,-774 }, {  30,-774 }, {  31,-774 }, {  32,-516 },
 {  33,-774 }, {  34,-774 }, {  35,-774 }, {  36,-774 }, {  37,-774 },
 {  38,-774 }, {  39,-258 }, {  40,-774 }, {  41,-774 }, {  42,-774 },
 {  43,-774 }, {  44,-774 }, {  45,2158 }, {  46,-774 }, {  47,-774 },
 {  48,-774 }, {  49,-774 }, {  50,-774 }, {  51,-774 }, {  52,-774 },
 {  53,-774 }, {  54,-774 }, {  55,-774 }, {  56,-774 }, {  57,-774 },

 {  58,-774 }, {  59,-774 }, {  60,-774 }, {  61,-774 }, {  62,-774 },
 {  63,-774 }, {  64,-774 }, {  65,-774 }, {  66,-774 }, {  67,-774 },
 {  68,-774 }, {  69,-774 }, {  70,-774 }, {  71,-774 }, {  72,-774 },
 {  73,-774 }, {  74,-774 }, {  75,-774 }, {  76,-774 }, {  77,-774 },
 {  78,-774 }, {  79,-774 }, {  80,-774 }, {  81,-774 }, {  82,-774 },
 {  83,-774 }, {  84,-774 }, {  85,-774 }, {  86,-774 }, {  87,-774 },
 {  88,-774 }, {  89,-774 }, {  90,-774 }, {  91,-774 }, {  92,-774 },
 {  93,-774 }, {  94,-774 }, {  95,-774 }, {  96,-774 }, {  97,-774 },
 {  98,-774 }, {  99,-774 }, { 100,-774 }, { 101,-774 }, { 102,-774 },
 { 103,-774 }, { 104,-774 }, { 105,-774 }, { 106,-774 }, { 107,-774 },

 { 108,-774 }, { 109,-774 }, { 110,-774 }, { 111,-774 }, { 112,-774 },
 { 113,-774 }, { 114,-774 }, { 115,-774 }, { 116,-774 }, { 117,-774 },
 { 118,-774 }, { 119,-774 }, { 120,-774 }, { 121,-774 }, { 122,-774 },
 { 123,-774 }, { 124,-774 }, { 125,-774 }, { 126,-774 }, { 127,-774 },
 { 128,-774 }, { 129,-774 }, { 130,-774 }, { 131,-774 }, { 132,-774 },
 { 133,-774 }, { 134,-774 }, { 135,-774 }, { 136,-774 }, { 137,-774 },
 { 138,-774 }, { 139,-774 }, { 140,-774 }, { 141,-774 }, { 142,-774 },
 { 143,-774 }, { 144,-774 }, { 145,-774 }, { 146,-774 }, { 147,-774 },
 { 148,-774 }, { 149,-774 }, { 150,-774 }, { 151,-774 }, { 152,-774 },
 { 153,-774 }, { 154,-774 }, { 155,-774 }, { 156,-774 }, { 157,-774 },

 { 158,-774 }, { 159,-774 }, { 160,-774 }, { 161,-774 }, { 162,-774 },
 { 163,-774 }, { 164,-774 }, { 165,-774 }, { 166,-774 }, { 167,-774 },
 { 168,-774 }, { 169,-774 }, { 170,-774 }, { 171,-774 }, { 172,-774 },
 { 173,-774 }, { 174,-774 }, { 175,-774 }, { 176,-774 }, { 177,-774 },
 { 178,-774 }, { 179,-774 }, { 180,-774 }, { 181,-774 }, { 182,-774 },
 { 183,-774 }, { 184,-774 }, { 185,-774 }, { 186,-774 }, { 187,-774 },
 { 188,-774 }, { 189,-774 }, { 190,-774 }, { 191,-774 }, { 192,-774 },
 { 193,-774 }, { 194,-774 }, { 195,-774 }, { 196,-774 }, { 197,-774 },
 { 198,-774 }, { 199,-774 }, { 200,-774 }, { 201,-774 }, { 202,-774 },
 { 203,-774 }, { 204,-774 }, { 205,-774 }, { 206,-774 }, { 207,-774 },

 { 208,-774 }, { 209,-774 }, { 210,-774 }, { 211,-774 }, { 212,-774 },
 { 213,-774 }, { 214,-774 }, { 215,-774 }, { 216,-774 }, { 217,-774 },
 { 218,-774 }, { 219,-774 }, { 220,-774 }, { 221,-774 }, { 222,-774 },
 { 223,-774 }, { 224,-774 }, { 225,-774 }, { 226,-774 }, { 227,-774 },
 { 228,-774 }, { 229,-774 }, { 230,-774 }, { 231,-774 }, { 232,-774 },
 { 233,-774 }, { 234,-774 }, { 235,-774 }, { 236,-774 }, { 237,-774 },
 { 238,-774 }, { 239,-774 }, { 240,-774 }, { 241,-774 }, { 242,-774 },
 { 243,-774 }, { 244,-774 }, { 245,-774 }, { 246,-774 }, { 247,-774 },
 { 248,-774 }, { 249,-774 }, { 250,-774 }, { 251,-774 }, { 252,-774 },
 { 253,-774 }, { 254,-774 }, { 255,-774 }, { 256,-774 }, {   0,  55 },

 {   0,3190 }, {   1,-2064 }, {   2,-2064 }, {   3,-2064 }, {   4,-2064 },
 {   5,-2064 }, {   6,-2064 }, {   7,-2064 }, {   8,-2064 }, {   9,-1806 },
 {  10,-3421 }, {  11,-2064 }, {  12,-1806 }, {  13,-3421 }, {  14,-2064 },
 {  15,-2064 }, {  16,-2064 }, {  17,-2064 }, {  18,-2064 }, {  19,-2064 },
 {  20,-2064 }, {  21,-2064 }, {  22,-2064 }, {  23,-2064 }, {  24,-2064 },
 {  25,-2064 }, {  26,-2064 }, {  27,-2064 }, {  28,-2064 }, {  29,-2064 },
 {  30,-2064 }, {  31,-2064 }, {  32,-1806 }, {  33,-2064 }, {  34,-2064 },
 {  35,-2064 }, {  36,-2064 }, {  37,-2064 }, {  38,-2064 }, {  39,2158 },
 {  40,-2064 }, {  41,-2064 }, {  42,-2064 }, {  43,-2064 }, {  44,-2064 },
 {  45,-1290 }, {  46,-2064 }, {  47,-2064 }, {  48,-2064 }, {  49,-2064 },

 {  50,-2064 }, {  51,-2064 }, {  52,-2064 }, {  53,-2064 }, {  54,-2064 },
 {  55,-2064 }, {  56,-2064 }, {  57,-2064 }, {  58,-2064 }, {  59,-2064 },
 {  60,-2064 }, {  61,-2064 }, {  62,-2064 }, {  63,-2064 }, {  64,-2064 },
 {  65,-2064 }, {  66,-2064 }, {  67,-2064 }, {  68,-2064 }, {  69,-2064 },
 {  70,-2064 }, {  71,-2064 }, {  72,-2064 }, {  73,-2064 }, {  74,-2064 },
 {  75,-2064 }, {  76,-2064 }, {  77,-2064 }, {  78,-2064 }, {  79,-2064 },
 {  80,-2064 }, {  81,-2064 }, {  82,-2064 }, {  83,-2064 }, {  84,-2064 },
 {  85,-2064 }, {  86,-2064 }, {  87,-2064 }, {  88,-2064 }, {  89,-2064 },
 {  90,-2064 }, {  91,-2064 }, {  92,-2064 }, {  93,-2064 }, {  94,-2064 },
 {  95,-2064 }, {  96,-2064 }, {  97,-2064 }, {  98,-2064 }, {  99,-2064 },

 { 100,-2064 }, { 101,-2064 }, { 102,-2064 }, { 103,-2064 }, { 104,-2064 },
 { 105,-2064 }, { 106,-2064 }, { 107,-2064 }, { 108,-2064 }, { 109,-2064 },
 { 110,-2064 }, { 111,-2064 }, { 112,-2064 }, { 113,-2064 }, { 114,-2064 },
 { 115,-2064 }, { 116,-2064 }, { 117,-2064 }, { 118,-2064 }, { 119,-2064 },
 { 120,-2064 }, { 121,-2064 }, { 122,-2064 }, { 123,-2064 }, { 124,-2064 },
 { 125,-2064 }, { 126,-2064 }, { 127,-2064 }, { 128,-2064 }, { 129,-2064 },
 { 130,-2064 }, { 131,-2064 }, { 132,-2064 }, { 133,-2064 }, { 134,-2064 },
 { 135,-2064 }, { 136,-2064 }, { 137,-2064 }, { 138,-2064 }, { 139,-2064 },
 { 140,-2064 }, { 141,-2064 }, { 142,-2064 }, { 143,-2064 }, { 144,-2064 },
 { 145,-2064 }, { 146,-2064 }, { 147,-2064 }, { 148,-2064 }, { 149,-2064 },

 { 150,-2064 }, { 151,-2064 }, { 152,-2064 }, { 153,-2064 }, { 154,-2064 },
 { 155,-2064 }, { 156,-2064 }, { 157,-2064 }, { 158,-2064 }, { 159,-2064 },
 { 160,-2064 }, { 161,-2064 }, { 162,-2064 }, { 163,-2064 }, { 164,-2064 },
 { 165,-2064 }, { 166,-2064 }, { 167,-2064 }, { 168,-2064 }, { 169,-2064 },
 { 170,-2064 }, { 171,-2064 }, { 172,-2064 }, { 173,-2064 }, { 174,-2064 },
 { 175,-2064 }, { 176,-2064 }, { 177,-2064 }, { 178,-2064 }, { 179,-2064 },
 { 180,-2064 }, { 181,-2064 }, { 182,-2064 }, { 183,-2064 }, { 184,-2064 },
 { 185,-2064 }, { 186,-2064 }, { 187,-2064 }, { 188,-2064 }, { 189,-2064 },
 { 190,-2064 }, { 191,-2064 }, { 192,-2064 }, { 193,-2064 }, { 194,-2064 },
 { 195,-2064 }, { 196,-2064 }, { 197,-2064 }, { 198,-2064 }, { 199,-2064 },

 { 200,-2064 }, { 201,-2064 }, { 202,-2064 }, { 203,-2064 }, { 204,-2064 },
 { 205,-2064 }, { 206,-2064 }, { 207,-2064 }, { 208,-2064 }, { 209,-2064 },
 { 210,-2064 }, { 211,-2064 }, { 212,-2064 }, { 213,-2064 }, { 214,-2064 },
 { 215,-2064 }, { 216,-2064 }, { 217,-2064 }, { 218,-2064 }, { 219,-2064 },
 { 220,-2064 }, { 221,-2064 }, { 222,-2064 }, { 223,-2064 }, { 224,-2064 },
 { 225,-2064 }, { 226,-2064 }, { 227,-2064 }, { 228,-2064 }, { 229,-2064 },
 { 230,-2064 }, { 231,-2064 }, { 232,-2064 }, { 233,-2064 }, { 234,-2064 },
 { 235,-2064 }, { 236,-2064 }, { 237,-2064 }, { 238,-2064 }, { 239,-2064 },
 { 240,-2064 }, { 241,-2064 }, { 242,-2064 }, { 243,-2064 }, { 244,-2064 },
 { 245,-2064 }, { 246,-2064 }, { 247,-2064 }, { 248,-2064 }, { 249,-2064 },

 { 250,-2064 }, { 251,-2064 }, { 252,-2064 }, { 253,-2064 }, { 254,-2064 },
 { 255,-2064 }, { 256,-2064 }, {   0,  55 }, {   0,2932 }, {   1,-2322 },
 {   2,-2322 }, {   3,-2322 }, {   4,-2322 }, {   5,-2322 }, {   6,-2322 },
 {   7,-2322 }, {   8,-2322 }, {   9,-2064 }, {  10,-3679 }, {  11,-2322 },
 {  12,-2064 }, {  13,-3679 }, {  14,-2322 }, {  15,-2322 }, {  16,-2322 },
 {  17,-2322 }, {  18,-2322 }, {  19,-2322 }, {  20,-2322 }, {  21,-2322 },
 {  22,-2322 }, {  23,-2322 }, {  24,-2322 }, {  25,-2322 }, {  26,-2322 },
 {  27,-2322 }, {  28,-2322 }, {  29,-2322 }, {  30,-2322 }, {  31,-2322 },
 {  32,-2064 }, {  33,-2322 }, {  34,-2322 }, {  35,-2322 }, {  36,-2322 },
 {  37,-2322 }, {  38,-2322 }, {  39,1900 }, {  40,-2322 }, {  41,-2322 },

 {  42,-2322 }, {  43,-2322 }, {  44,-2322 }, {  45,-1548 }, {  46,-2322 },
 {  47,-2322 }, {  48,-2322 }, {  49,-2322 }, {  50,-2322 }, {  51,-2322 },
 {  52,-2322 }, {  53,-2322 }, {  54,-2322 }, {  55,-2322 }, {  56,-2322 },
 {  57,-2322 }, {  58,-2322 }, {  59,-2322 }, {  60,-2322 }, {  61,-2322 },
 {  62,-2322 }, {  63,-2322 }, {  64,-2322 }, {  65,-2322 }, {  66,-2322 },
 {  67,-2322 }, {  68,-2322 }, {  69,-2322 }, {  70,-2322 }, {  71,-2322 },
 {  72,-2322 }, {  73,-2322 }, {  74,-2322 }, {  75,-2322 }, {  76,-2322 },
 {  77,-2322 }, {  78,-2322 }, {  79,-2322 }, {  80,-2322 }, {  81,-2322 },
 {  82,-2322 }, {  83,-2322 }, {  84,-2322 }, {  85,-2322 }, {  86,-2322 },
 {  87,-2322 }, {  88,-2322 }, {  89,-2322 }, {  90,-2322 }, {  91,-2322 },

 {  92,-2322 }, {  93,-2322 }, {  94,-2322 }, {  95,-2322 }, {  96,-2322 },
 {  97,-2322 }, {  98,-2322 }, {  99,-2322 }, { 100,-2322 }, { 101,-2322 },
 { 102,-2322 }, { 103,-2322 }, { 104,-2322 }, { 105,-2322 }, { 106,-2322 },
 { 107,-2322 }, { 108,-2322 }, { 109,-2322 }, { 110,-2322 }, { 111,-2322 },
 { 112,-2322 }, { 113,-2322 }, { 114,-2322 }, { 115,-2322 }, { 116,-2322 },
 { 117,-2322 }, { 118,-2322 }, { 119,-2322 }, { 120,-2322 }, { 121,-2322 },
 { 122,-2322 }, { 123,-2322 }, { 124,-2322 }, { 125,-2322 }, { 126,-2322 },
 { 127,-2322 }, { 128,-2322 }, { 129,-2322 }, { 130,-2322 }, { 131,-2322 },
 { 132,-2322 }, { 133,-2322 }, { 134,-2322 }, { 135,-2322 }, { 136,-2322 },
 { 137,-2322 }, { 138,-2322 }, { 139,-2322 }, { 140,-2322 }, { 141,-2322 },

 { 142,-2322 }, { 143,-2322 }, { 144,-2322 }, { 145,-2322 }, { 146,-2322 },
 { 147,-2322 }, { 148,-2322 }, { 149,-2322 }, { 150,-2322 }, { 151,-2322 },
 { 152,-2322 }, { 153,-2322 }, { 154,-2322 }, { 155,-2322 }, { 156,-2322 },
 { 157,-2322 }, { 158,-2322 }, { 159,-2322 }, { 160,-2322 }, { 161,-2322 },
 { 162,-2322 }, { 163,-2322 }, { 164,-2322 }, { 165,-2322 }, { 166,-2322 },
 { 167,-2322 }, { 168,-2322 }, { 169,-2322 }, { 170,-2322 }, { 171,-2322 },
 { 172,-2322 }, { 173,-2322 }, { 174,-2322 }, { 175,-2322 }, { 176,-2322 },
 { 177,-2322 }, { 178,-2322 }, { 179,-2322 }, { 180,-2322 }, { 181,-2322 },
 { 182,-2322 }, { 183,-2322 }, { 184,-2322 }, { 185,-2322 }, { 186,-2322 },
 { 187,-2322 }, { 188,-2322 }, { 189,-2322 }, { 190,-2322 }, { 191,-2322 },

 { 192,-2322 }, { 193,-2322 }, { 194,-2322 }, { 195,-2322 }, { 196,-2322 },
 { 197,-2322 }, { 198,-2322 }, { 199,-2322 }, { 200,-2322 }, { 201,-2322 },
 { 202,-2322 }, { 203,-2322 }, { 204,-2322 }, { 205,-2322 }, { 206,-2322 },
 { 207,-2322 }, { 208,-2322 }, { 209,-2322 }, { 210,-2322 }, { 211,-2322 },
 { 212,-2322 }, { 213,-2322 }, { 214,-2322 }, { 215,-2322 }, { 216,-2322 },
 { 217,-2322 }, { 218,-2322 }, { 219,-2322 }, { 220,-2322 }, { 221,-2322 },
 { 222,-2322 }, { 223,-2322 }, { 224,-2322 }, { 225,-2322 }, { 226,-2322 },
 { 227,-2322 }, { 228,-2322 }, { 229,-2322 }, { 230,-2322 }, { 231,-2322 },
 { 232,-2322 }, { 233,-2322 }, { 234,-2322 }, { 235,-2322 }, { 236,-2322 },
 { 237,-2322 }, { 238,-2322 }, { 239,-2322 }, { 240,-2322 }, { 241,-2322 },

 { 242,-2322 }, { 243,-2322 }, { 244,-2322 }, { 245,-2322 }, { 246,-2322 },
 { 247,-2322 }, { 248,-2322 }, { 249,-2322 }, { 250,-2322 }, { 251,-2322 },
 { 252,-2322 }, { 253,-2322 }, { 254,-2322 }, { 255,-2322 }, { 256,-2322 },
 {   0,  55 }, {   0,2674 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   9,-3937 }, {  10,-3937 }, {   0,   0 }, {  12,-3937 }, {  13,-3937 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  32,-3937 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  39,1900 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  45,-26239 }, {   0,  55 }, {   0,2627 }, {   1,-2627 },
 {   2,-2627 }, {   3,-2627 }, {   4,-2627 }, {   5,-2627 }, {   6,-2627 },
 {   7,-2627 }, {   8,-2627 }, {   9,-2369 }, {  10,-3984 }, {  11,-2627 },
 {  12,-2369 }, {  13,-3984 }, {  14,-2627 }, {  15,-2627 }, {  16,-2627 },
 {  17,-2627 }, {  18,-2627 }, {  19,-2627 }, {  20,-2627 }, {  21,-2627 },
 {  22,-2627 }, {  23,-2627 }, {  24,-2627 }, {  25,-2627 }, {  26,-2627 },
 {  27,-2627 }, {  28,-2627 }, {  29,-2627 }, {  30,-2627 }, {  31,-2627 },
 {  32,-2369 }, {  33,-2627 }, {  34,-2627 }, {  35,-2627 }, {  36,-2627 },

 {  37,-2627 }, {  38,-2627 }, {  39,1595 }, {  40,-2627 }, {  41,-2627 },
 {  42,-2627 }, {  43,-2627 }, {  44,-2627 }, {  45, 258 }, {  46,-2627 },
 {  47,-2627 }, {  48,-2627 }, {  49,-2627 }, {  50,-2627 }, {  51,-2627 },
 {  52,-2627 }, {  53,-2627 }, {  54,-2627 }, {  55,-2627 }, {  56,-2627 },
 {  57,-2627 }, {  58,-2627 }, {  59,-2627 }, {  60,-2627 }, {  61,-2627 },
 {  62,-2627 }, {  63,-2627 }, {  64,-2627 }, {  65,-2627 }, {  66,-2627 },
 {  67,-2627 }, {  68,-2627 }, {  69,-2627 }, {  70,-2627 }, {  71,-2627 },
 {  72,-2627 }, {  73,-2627 }, {  74,-2627 }, {  75,-2627 }, {  76,-2627 },
 {  77,-2627 }, {  78,-2627 }, {  79,-2627 }, {  80,-2627 }, {  81,-2627 },
 {  82,-2627 }, {  83,-2627 }, {  84,-2627 }, {  85,-2627 }, {  86,-2627 },

 {  87,-2627 }, {  88,-2627 }, {  89,-2627 }, {  90,-2627 }, {  91,-2627 },
 {  92,-2627 }, {  93,-2627 }, {  94,-2627 }, {  95,-2627 }, {  96,-2627 },
 {  97,-2627 }, {  98,-2627 }, {  99,-2627 }, { 100,-2627 }, { 101,-2627 },
 { 102,-2627 }, { 103,-2627 }, { 104,-2627 }, { 105,-2627 }, { 106,-2627 },
 { 107,-2627 }, { 108,-2627 }, { 109,-2627 }, { 110,-2627 }, { 111,-2627 },
 { 112,-2627 }, { 113,-2627 }, { 114,-2627 }, { 115,-2627 }, { 116,-2627 },
 { 117,-2627 }, { 118,-2627 }, { 119,-2627 }, { 120,-2627 }, { 121,-2627 },
 { 122,-2627 }, { 123,-2627 }, { 124,-2627 }, { 125,-2627 }, { 126,-2627 },
 { 127,-2627 }, { 128,-2627 }, { 129,-2627 }, { 130,-2627 }, { 131,-2627 },
 { 132,-2627 }, { 133,-2627 }, { 134,-2627 }, { 135,-2627 }, { 136,-2627 },

 { 137,-2627 }, { 138,-2627 }, { 139,-2627 }, { 140,-2627 }, { 141,-2627 },
 { 142,-2627 }, { 143,-2627 }, { 144,-2627 }, { 145,-2627 }, { 146,-2627 },
 { 147,-2627 }, { 148,-2627 }, { 149,-2627 }, { 150,-2627 }, { 151,-2627 },
 { 152,-2627 }, { 153,-2627 }, { 154,-2627 }, { 155,-2627 }, { 156,-2627 },
 { 157,-2627 }, { 158,-2627 }, { 159,-2627 }, { 160,-2627 }, { 161,-2627 },
 { 162,-2627 }, { 163,-2627 }, { 164,-2627 }, { 165,-2627 }, { 166,-2627 },
 { 167,-2627 }, { 168,-2627 }, { 169,-2627 }, { 170,-2627 }, { 171,-2627 },
 { 172,-2627 }, { 173,-2627 }, { 174,-2627 }, { 175,-2627 }, { 176,-2627 },
 { 177,-2627 }, { 178,-2627 }, { 179,-2627 }, { 180,-2627 }, { 181,-2627 },
 { 182,-2627 }, { 183,-2627 }, { 184,-2627 }, { 185,-2627 }, { 186,-2627 },

 { 187,-2627 }, { 188,-2627 }, { 189,-2627 }, { 190,-2627 }, { 191,-2627 },
 { 192,-2627 }, { 193,-2627 }, { 194,-2627 }, { 195,-2627 }, { 196,-2627 },
 { 197,-2627 }, { 198,-2627 }, { 199,-2627 }, { 200,-2627 }, { 201,-2627 },
 { 202,-2627 }, { 203,-2627 }, { 204,-2627 }, { 205,-2627 }, { 206,-2627 },
 { 207,-2627 }, { 208,-2627 }, { 209,-2627 }, { 210,-2627 }, { 211,-2627 },
 { 212,-2627 }, { 213,-2627 }, { 214,-2627 }, { 215,-2627 }, { 216,-2627 },
 { 217,-2627 }, { 218,-2627 }, { 219,-2627 }, { 220,-2627 }, { 221,-2627 },
 { 222,-2627 }, { 223,-2627 }, { 224,-2627 }, { 225,-2627 }, { 226,-2627 },
 { 227,-2627 }, { 228,-2627 }, { 229,-2627 }, { 230,-2627 }, { 231,-2627 },
 { 232,-2627 }, { 233,-2627 }, { 234,-2627 }, { 235,-2627 }, { 236,-2627 },

 { 237,-2627 }, { 238,-2627 }, { 239,-2627 }, { 240,-2627 }, { 241,-2627 },
 { 242,-2627 }, { 243,-2627 }, { 244,-2627 }, { 245,-2627 }, { 246,-2627 },
 { 247,-2627 }, { 248,-2627 }, { 249,-2627 }, { 250,-2627 }, { 251,-2627 },
 { 252,-2627 }, { 253,-2627 }, { 254,-2627 }, { 255,-2627 }, { 256,-2627 },
 {   0,  55 }, {   0,2369 }, {   1,-2885 }, {   2,-2885 }, {   3,-2885 },
 {   4,-2885 }, {   5,-2885 }, {   6,-2885 }, {   7,-2885 }, {   8,-2885 },
 {   9,-2627 }, {  10,-4242 }, {  11,-2885 }, {  12,-2627 }, {  13,-4242 },
 {  14,-2885 }, {  15,-2885 }, {  16,-2885 }, {  17,-2885 }, {  18,-2885 },
 {  19,-2885 }, {  20,-2885 }, {  21,-2885 }, {  22,-2885 }, {  23,-2885 },
 {  24,-2885 }, {  25,-2885 }, {  26,-2885 }, {  27,-2885 }, {  28,-2885 },

 {  29,-2885 }, {  30,-2885 }, {  31,-2885 }, {  32,-2627 }, {  33,-2885 },
 {  34,-2885 }, {  35,-2885 }, {  36,-2885 }, {  37,-2885 }, {  38,-2885 },
 {  39,-2369 }, {  40,-2885 }, {  41,-2885 }, {  42,-2885 }, {  43,-2885 },
 {  44,-2885 }, {  45,   0 }, {  46,-2885 }, {  47,-2885 }, {  48,-2885 },
 {  49,-2885 }, {  50,-2885 }, {  51,-2885 }, {  52,-2885 }, {  53,-2885 },
 {  54,-2885 }, {  55,-2885 }, {  56,-2885 }, {  57,-2885 }, {  58,-2885 },
 {  59,-2885 }, {  60,-2885 }, {  61,-2885 }, {  62,-2885 }, {  63,-2885 },
 {  64,-2885 }, {  65,-2885 }, {  66,-2885 }, {  67,-2885 }, {  68,-2885 },
 {  69,-2885 }, {  70,-2885 }, {  71,-2885 }, {  72,-2885 }, {  73,-2885 },
 {  74,-2885 }, {  75,-2885 }, {  76,-2885 }, {  77,-2885 }, {  78,-2885 },

 {  79,-2885 }, {  80,-2885 }, {  81,-2885 }, {  82,-2885 }, {  83,-2885 },
 {  84,-2885 }, {  85,-2885 }, {  86,-2885 }, {  87,-2885 }, {  88,-2885 },
 {  89,-2885 }, {  90,-2885 }, {  91,-2885 }, {  92,-2885 }, {  93,-2885 },
 {  94,-2885 }, {  95,-2885 }, {  96,-2885 }, {  97,-2885 }, {  98,-2885 },
 {  99,-2885 }, { 100,-2885 }, { 101,-2885 }, { 102,-2885 }, { 103,-2885 },
 { 104,-2885 }, { 105,-2885 }, { 106,-2885 }, { 107,-2885 }, { 108,-2885 },
 { 109,-2885 }, { 110,-2885 }, { 111,-2885 }, { 112,-2885 }, { 113,-2885 },
 { 114,-2885 }, { 115,-2885 }, { 116,-2885 }, { 117,-2885 }, { 118,-2885 },
 { 119,-2885 }, { 120,-2885 }, { 121,-2885 }, { 122,-2885 }, { 123,-2885 },
 { 124,-2885 }, { 125,-2885 }, { 126,-2885 }, { 127,-2885 }, { 128,-2885 },

 { 129,-2885 }, { 130,-2885 }, { 131,-2885 }, { 132,-2885 }, { 133,-2885 },
 { 134,-2885 }, { 135,-2885 }, { 136,-2885 }, { 137,-2885 }, { 138,-2885 },
 { 139,-2885 }, { 140,-2885 }, { 141,-2885 }, { 142,-2885 }, { 143,-2885 },
 { 144,-2885 }, { 145,-2885 }, { 146,-2885 }, { 147,-2885 }, { 148,-2885 },
 { 149,-2885 }, { 150,-2885 }, { 151,-2885 }, { 152,-2885 }, { 153,-2885 },
 { 154,-2885 }, { 155,-2885 }, { 156,-2885 }, { 157,-2885 }, { 158,-2885 },
 { 159,-2885 }, { 160,-2885 }, { 161,-2885 }, { 162,-2885 }, { 163,-2885 },
 { 164,-2885 }, { 165,-2885 }, { 166,-2885 }, { 167,-2885 }, { 168,-2885 },
 { 169,-2885 }, { 170,-2885 }, { 171,-2885 }, { 172,-2885 }, { 173,-2885 },
 { 174,-2885 }, { 175,-2885 }, { 176,-2885 }, { 177,-2885 }, { 178,-2885 },

 { 179,-2885 }, { 180,-2885 }, { 181,-2885 }, { 182,-2885 }, { 183,-2885 },
 { 184,-2885 }, { 185,-2885 }, { 186,-2885 }, { 187,-2885 }, { 188,-2885 },
 { 189,-2885 }, { 190,-2885 }, { 191,-2885 }, { 192,-2885 }, { 193,-2885 },
 { 194,-2885 }, { 195,-2885 }, { 196,-2885 }, { 197,-2885 }, { 198,-2885 },
 { 199,-2885 }, { 200,-2885 }, { 201,-2885 }, { 202,-2885 }, { 203,-2885 },
 { 204,-2885 }, { 205,-2885 }, { 206,-2885 }, { 207,-2885 }, { 208,-2885 },
 { 209,-2885 }, { 210,-2885 }, { 211,-2885 }, { 212,-2885 }, { 213,-2885 },
 { 214,-2885 }, { 215,-2885 }, { 216,-2885 }, { 217,-2885 }, { 218,-2885 },
 { 219,-2885 }, { 220,-2885 }, { 221,-2885 }, { 222,-2885 }, { 223,-2885 },
 { 224,-2885 }, { 225,-2885 }, { 226,-2885 }, { 227,-2885 }, { 228,-2885 },

 { 229,-2885 }, { 230,-2885 }, { 231,-2885 }, { 232,-2885 }, { 233,-2885 },
 { 234,-2885 }, { 235,-2885 }, { 236,-2885 }, { 237,-2885 }, { 238,-2885 },
 { 239,-2885 }, { 240,-2885 }, { 241,-2885 }, { 242,-2885 }, { 243,-2885 },
 { 244,-2885 }, { 245,-2885 }, { 246,-2885 }, { 247,-2885 }, { 248,-2885 },
 { 249,-2885 }, { 250,-2885 }, { 251,-2885 }, { 252,-2885 }, { 253,-2885 },
 { 254,-2885 }, { 255,-2885 }, { 256,-2885 }, {   0,  28 }, {   0,2111 },
 {   1,-2111 }, {   2,-2111 }, {   3,-2111 }, {   4,-2111 }, {   5,-2111 },
 {   6,-2111 }, {   7,-2111 }, {   8,-2111 }, {   9,-1853 }, {  10,-4195 },
 {  11,-2111 }, {  12,-1853 }, {  13,-4195 }, {  14,-2111 }, {  15,-2111 },
 {  16,-2111 }, {  17,-2111 }, {  18,-2111 }, {  19,-2111 }, {  20,-2111 },

 {  21,-2111 }, {  22,-2111 }, {  23,-2111 }, {  24,-2111 }, {  25,-2111 },
 {  26,-2111 }, {  27,-2111 }, {  28,-2111 }, {  29,-2111 }, {  30,-2111 },
 {  31,-2111 }, {  32,-1853 }, {  33,-2111 }, {  34,-2111 }, {  35,-2111 },
 {  36,-2111 }, {  37,-2111 }, {  38,-2111 }, {  39,1595 }, {  40,-2111 },
 {  41,-2111 }, {  42,-2111 }, {  43,-2111 }, {  44,-2111 }, {  45,-1337 },
 {  46,-2111 }, {  47,-2111 }, {  48,-2111 }, {  49,-2111 }, {  50,-2111 },
 {  51,-2111 }, {  52,-2111 }, {  53,-2111 }, {  54,-2111 }, {  55,-2111 },
 {  56,-2111 }, {  57,-2111 }, {  58,-2111 }, {  59,-2111 }, {  60,-2111 },
 {  61,-2111 }, {  62,-2111 }, {  63,-2111 }, {  64,-2111 }, {  65,-2111 },
 {  66,-2111 }, {  67,-2111 }, {  68,-2111 }, {  69,-2111 }, {  70,-2111 },

 {  71,-2111 }, {  72,-2111 }, {  73,-2111 }, {  74,-2111 }, {  75,-2111 },
 {  76,-2111 }, {  77,-2111 }, {  78,-2111 }, {  79,-2111 }, {  80,-2111 },
 {  81,-2111 }, {  82,-2111 }, {  83,-2111 }, {  84,-2111 }, {  85,-2111 },
 {  86,-2111 }, {  87,-2111 }, {  88,-2111 }, {  89,-2111 }, {  90,-2111 },
 {  91,-2111 }, {  92,-2111 }, {  93,-2111 }, {  94,-2111 }, {  95,-2111 },
 {  96,-2111 }, {  97,-2111 }, {  98,-2111 }, {  99,-2111 }, { 100,-2111 },
 { 101,-2111 }, { 102,-2111 }, { 103,-2111 }, { 104,-2111 }, { 105,-2111 },
 { 106,-2111 }, { 107,-2111 }, { 108,-2111 }, { 109,-2111 }, { 110,-2111 },
 { 111,-2111 }, { 112,-2111 }, { 113,-2111 }, { 114,-2111 }, { 115,-2111 },
 { 116,-2111 }, { 117,-2111 }, { 118,-2111 }, { 119,-2111 }, { 120,-2111 },

 { 121,-2111 }, { 122,-2111 }, { 123,-2111 }, { 124,-2111 }, { 125,-2111 },
 { 126,-2111 }, { 127,-2111 }, { 128,-2111 }, { 129,-2111 }, { 130,-2111 },
 { 131,-2111 }, { 132,-2111 }, { 133,-2111 }, { 134,-2111 }, { 135,-2111 },
 { 136,-2111 }, { 137,-2111 }, { 138,-2111 }, { 139,-2111 }, { 140,-2111 },
 { 141,-2111 }, { 142,-2111 }, { 143,-2111 }, { 144,-2111 }, { 145,-2111 },
 { 146,-2111 }, { 147,-2111 }, { 148,-2111 }, { 149,-2111 }, { 150,-2111 },
 { 151,-2111 }, { 152,-2111 }, { 153,-2111 }, { 154,-2111 }, { 155,-2111 },
 { 156,-2111 }, { 157,-2111 }, { 158,-2111 }, { 159,-2111 }, { 160,-2111 },
 { 161,-2111 }, { 162,-2111 }, { 163,-2111 }, { 164,-2111 }, { 165,-2111 },
 { 166,-2111 }, { 167,-2111 }, { 168,-2111 }, { 169,-2111 }, { 170,-2111 },

 { 171,-2111 }, { 172,-2111 }, { 173,-2111 }, { 174,-2111 }, { 175,-2111 },
 { 176,-2111 }, { 177,-2111 }, { 178,-2111 }, { 179,-2111 }, { 180,-2111 },
 { 181,-2111 }, { 182,-2111 }, { 183,-2111 }, { 184,-2111 }, { 185,-2111 },
 { 186,-2111 }, { 187,-2111 }, { 188,-2111 }, { 189,-2111 }, { 190,-2111 },
 { 191,-2111 }, { 192,-2111 }, { 193,-2111 }, { 194,-2111 }, { 195,-2111 },
 { 196,-2111 }, { 197,-2111 }, { 198,-2111 }, { 199,-2111 }, { 200,-2111 },
 { 201,-2111 }, { 202,-2111 }, { 203,-2111 }, { 204,-2111 }, { 205,-2111 },
 { 206,-2111 }, { 207,-2111 }, { 208,-2111 }, { 209,-2111 }, { 210,-2111 },
 { 211,-2111 }, { 212,-2111 }, { 213,-2111 }, { 214,-2111 }, { 215,-2111 },
 { 216,-2111 }, { 217,-2111 }, { 218,-2111 }, { 219,-2111 }, { 220,-2111 },

 { 221,-2111 }, { 222,-2111 }, { 223,-2111 }, { 224,-2111 }, { 225,-2111 },
 { 226,-2111 }, { 227,-2111 }, { 228,-2111 }, { 229,-2111 }, { 230,-2111 },
 { 231,-2111 }, { 232,-2111 }, { 233,-2111 }, { 234,-2111 }, { 235,-2111 },
 { 236,-2111 }, { 237,-2111 }, { 238,-2111 }, { 239,-2111 }, { 240,-2111 },
 { 241,-2111 }, { 242,-2111 }, { 243,-2111 }, { 244,-2111 }, { 245,-2111 },
 { 246,-2111 }, { 247,-2111 }, { 248,-2111 }, { 249,-2111 }, { 250,-2111 },
 { 251,-2111 }, { 252,-2111 }, { 253,-2111 }, { 254,-2111 }, { 255,-2111 },
 { 256,-2111 }, {   0,  28 }, {   0,1853 }, {   1,-2369 }, {   2,-2369 },
 {   3,-2369 }, {   4,-2369 }, {   5,-2369 }, {   6,-2369 }, {   7,-2369 },
 {   8,-2369 }, {   9,-2111 }, {  10,-4453 }, {  11,-2369 }, {  12,-2111 },

 {  13,-4453 }, {  14,-2369 }, {  15,-2369 }, {  16,-2369 }, {  17,-2369 },
 {  18,-2369 }, {  19,-2369 }, {  20,-2369 }, {  21,-2369 }, {  22,-2369 },
 {  23,-2369 }, {  24,-2369 }, {  25,-2369 }, {  26,-2369 }, {  27,-2369 },
 {  28,-2369 }, {  29,-2369 }, {  30,-2369 }, {  31,-2369 }, {  32,-2111 },
 {  33,-2369 }, {  34,-2369 }, {  35,-2369 }, {  36,-2369 }, {  37,-2369 },
 {  38,-2369 }, {  39,1337 }, {  40,-2369 }, {  41,-2369 }, {  42,-2369 },
 {  43,-2369 }, {  44,-2369 }, {  45,-1595 }, {  46,-2369 }, {  47,-2369 },
 {  48,-2369 }, {  49,-2369 }, {  50,-2369 }, {  51,-2369 }, {  52,-2369 },
 {  53,-2369 }, {  54,-2369 }, {  55,-2369 }, {  56,-2369 }, {  57,-2369 },
 {  58,-2369 }, {  59,-2369 }, {  60,-2369 }, {  61,-2369 }, {  62,-2369 },

 {  63,-2369 }, {  64,-2369 }, {  65,-2369 }, {  66,-2369 }, {  67,-2369 },
 {  68,-2369 }, {  69,-2369 }, {  70,-2369 }, {  71,-2369 }, {  72,-2369 },
 {  73,-2369 }, {  74,-2369 }, {  75,-2369 }, {  76,-2369 }, {  77,-2369 },
 {  78,-2369 }, {  79,-2369 }, {  80,-2369 }, {  81,-2369 }, {  82,-2369 },
 {  83,-2369 }, {  84,-2369 }, {  85,-2369 }, {  86,-2369 }, {  87,-2369 },
 {  88,-2369 }, {  89,-2369 }, {  90,-2369 }, {  91,-2369 }, {  92,-2369 },
 {  93,-2369 }, {  94,-2369 }, {  95,-2369 }, {  96,-2369 }, {  97,-2369 },
 {  98,-2369 }, {  99,-2369 }, { 100,-2369 }, { 101,-2369 }, { 102,-2369 },
 { 103,-2369 }, { 104,-2369 }, { 105,-2369 }, { 106,-2369 }, { 107,-2369 },
 { 108,-2369 }, { 109,-2369 }, { 110,-2369 }, { 111,-2369 }, { 112,-2369 },

 { 113,-2369 }, { 114,-2369 }, { 115,-2369 }, { 116,-2369 }, { 117,-2369 },
 { 118,-2369 }, { 119,-2369 }, { 120,-2369 }, { 121,-2369 }, { 122,-2369 },
 { 123,-2369 }, { 124,-2369 }, { 125,-2369 }, { 126,-2369 }, { 127,-2369 },
 { 128,-2369 }, { 129,-2369 }, { 130,-2369 }, { 131,-2369 }, { 132,-2369 },
 { 133,-2369 }, { 134,-2369 }, { 135,-2369 }, { 136,-2369 }, { 137,-2369 },
 { 138,-2369 }, { 139,-2369 }, { 140,-2369 }, { 141,-2369 }, { 142,-2369 },
 { 143,-2369 }, { 144,-2369 }, { 145,-2369 }, { 146,-2369 }, { 147,-2369 },
 { 148,-2369 }, { 149,-2369 }, { 150,-2369 }, { 151,-2369 }, { 152,-2369 },
 { 153,-2369 }, { 154,-2369 }, { 155,-2369 }, { 156,-2369 }, { 157,-2369 },
 { 158,-2369 }, { 159,-2369 }, { 160,-2369 }, { 161,-2369 }, { 162,-2369 },

 { 163,-2369 }, { 164,-2369 }, { 165,-2369 }, { 166,-2369 }, { 167,-2369 },
 { 168,-2369 }, { 169,-2369 }, { 170,-2369 }, { 171,-2369 }, { 172,-2369 },
 { 173,-2369 }, { 174,-2369 }, { 175,-2369 }, { 176,-2369 }, { 177,-2369 },
 { 178,-2369 }, { 179,-2369 }, { 180,-2369 }, { 181,-2369 }, { 182,-2369 },
 { 183,-2369 }, { 184,-2369 }, { 185,-2369 }, { 186,-2369 }, { 187,-2369 },
 { 188,-2369 }, { 189,-2369 }, { 190,-2369 }, { 191,-2369 }, { 192,-2369 },
 { 193,-2369 }, { 194,-2369 }, { 195,-2369 }, { 196,-2369 }, { 197,-2369 },
 { 198,-2369 }, { 199,-2369 }, { 200,-2369 }, { 201,-2369 }, { 202,-2369 },
 { 203,-2369 }, { 204,-2369 }, { 205,-2369 }, { 206,-2369 }, { 207,-2369 },
 { 208,-2369 }, { 209,-2369 }, { 210,-2369 }, { 211,-2369 }, { 212,-2369 },

 { 213,-2369 }, { 214,-2369 }, { 215,-2369 }, { 216,-2369 }, { 217,-2369 },
 { 218,-2369 }, { 219,-2369 }, { 220,-2369 }, { 221,-2369 }, { 222,-2369 },
 { 223,-2369 }, { 224,-2369 }, { 225,-2369 }, { 226,-2369 }, { 227,-2369 },
 { 228,-2369 }, { 229,-2369 }, { 230,-2369 }, { 231,-2369 }, { 232,-2369 },
 { 233,-2369 }, { 234,-2369 }, { 235,-2369 }, { 236,-2369 }, { 237,-2369 },
 { 238,-2369 }, { 239,-2369 }, { 240,-2369 }, { 241,-2369 }, { 242,-2369 },
 { 243,-2369 }, { 244,-2369 }, { 245,-2369 }, { 246,-2369 }, { 247,-2369 },
 { 248,-2369 }, { 249,-2369 }, { 250,-2369 }, { 251,-2369 }, { 252,-2369 },
 { 253,-2369 }, { 254,-2369 }, { 255,-2369 }, { 256,-2369 }, {   0,  28 },
 {   0,1595 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,-4711 },
 {  10,-4711 }, {   0,   0 }, {  12,-4711 }, {  13,-4711 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  32,-4711 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,1337 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  45,-27307 }, {   0,  28 }, {   0,1548 }, {   1,-2674 }, {   2,-2674 },
 {   3,-2674 }, {   4,-2674 }, {   5,-2674 }, {   6,-2674 }, {   7,-2674 },

 {   8,-2674 }, {   9,-2416 }, {  10,-4758 }, {  11,-2674 }, {  12,-2416 },
 {  13,-4758 }, {  14,-2674 }, {  15,-2674 }, {  16,-2674 }, {  17,-2674 },
 {  18,-2674 }, {  19,-2674 }, {  20,-2674 }, {  21,-2674 }, {  22,-2674 },
 {  23,-2674 }, {  24,-2674 }, {  25,-2674 }, {  26,-2674 }, {  27,-2674 },
 {  28,-2674 }, {  29,-2674 }, {  30,-2674 }, {  31,-2674 }, {  32,-2416 },
 {  33,-2674 }, {  34,-2674 }, {  35,-2674 }, {  36,-2674 }, {  37,-2674 },
 {  38,-2674 }, {  39,1032 }, {  40,-2674 }, {  41,-2674 }, {  42,-2674 },
 {  43,-2674 }, {  44,-2674 }, {  45, 258 }, {  46,-2674 }, {  47,-2674 },
 {  48,-2674 }, {  49,-2674 }, {  50,-2674 }, {  51,-2674 }, {  52,-2674 },
 {  53,-2674 }, {  54,-2674 }, {  55,-2674 }, {  56,-2674 }, {  57,-2674 },

 {  58,-2674 }, {  59,-2674 }, {  60,-2674 }, {  61,-2674 }, {  62,-2674 },
 {  63,-2674 }, {  64,-2674 }, {  65,-2674 }, {  66,-2674 }, {  67,-2674 },
 {  68,-2674 }, {  69,-2674 }, {  70,-2674 }, {  71,-2674 }, {  72,-2674 },
 {  73,-2674 }, {  74,-2674 }, {  75,-2674 }, {  76,-2674 }, {  77,-2674 },
 {  78,-2674 }, {  79,-2674 }, {  80,-2674 }, {  81,-2674 }, {  82,-2674 },
 {  83,-2674 }, {  84,-2674 }, {  85,-2674 }, {  86,-2674 }, {  87,-2674 },
 {  88,-2674 }, {  89,-2674 }, {  90,-2674 }, {  91,-2674 }, {  92,-2674 },
 {  93,-2674 }, {  94,-2674 }, {  95,-2674 }, {  96,-2674 }, {  97,-2674 },
 {  98,-2674 }, {  99,-2674 }, { 100,-2674 }, { 101,-2674 }, { 102,-2674 },
 { 103,-2674 }, { 104,-2674 }, { 105,-2674 }, { 106,-2674 }, { 107,-2674 },

 { 108,-2674 }, { 109,-2674 }, { 110,-2674 }, { 111,-2674 }, { 112,-2674 },
 { 113,-2674 }, { 114,-2674 }, { 115,-2674 }, { 116,-2674 }, { 117,-2674 },
 { 118,-2674 }, { 119,-2674 }, { 120,-2674 }, { 121,-2674 }, { 122,-2674 },
 { 123,-2674 }, { 124,-2674 }, { 125,-2674 }, { 126,-2674 }, { 127,-2674 },
 { 128,-2674 }, { 129,-2674 }, { 130,-2674 }, { 131,-2674 }, { 132,-2674 },
 { 133,-2674 }, { 134,-2674 }, { 135,-2674 }, { 136,-2674 }, { 137,-2674 },
 { 138,-2674 }, { 139,-2674 }, { 140,-2674 }, { 141,-2674 }, { 142,-2674 },
 { 143,-2674 }, { 144,-2674 }, { 145,-2674 }, { 146,-2674 }, { 147,-2674 },
 { 148,-2674 }, { 149,-2674 }, { 150,-2674 }, { 151,-2674 }, { 152,-2674 },
 { 153,-2674 }, { 154,-2674 }, { 155,-2674 }, { 156,-2674 }, { 157,-2674 },

 { 158,-2674 }, { 159,-2674 }, { 160,-2674 }, { 161,-2674 }, { 162,-2674 },
 { 163,-2674 }, { 164,-2674 }, { 165,-2674 }, { 166,-2674 }, { 167,-2674 },
 { 168,-2674 }, { 169,-2674 }, { 170,-2674 }, { 171,-2674 }, { 172,-2674 },
 { 173,-2674 }, { 174,-2674 }, { 175,-2674 }, { 176,-2674 }, { 177,-2674 },
 { 178,-2674 }, { 179,-2674 }, { 180,-2674 }, { 181,-2674 }, { 182,-2674 },
 { 183,-2674 }, { 184,-2674 }, { 185,-2674 }, { 186,-2674 }, { 187,-2674 },
 { 188,-2674 }, { 189,-2674 }, { 190,-2674 }, { 191,-2674 }, { 192,-2674 },
 { 193,-2674 }, { 194,-2674 }, { 195,-2674 }, { 196,-2674 }, { 197,-2674 },
 { 198,-2674 }, { 199,-2674 }, { 200,-2674 }, { 201,-2674 }, { 202,-2674 },
 { 203,-2674 }, { 204,-2674 }, { 205,-2674 }, { 206,-2674 }, { 207,-2674 },

 { 208,-2674 }, { 209,-2674 }, { 210,-2674 }, { 211,-2674 }, { 212,-2674 },
 { 213,-2674 }, { 214,-2674 }, { 215,-2674 }, { 216,-2674 }, { 217,-2674 },
 { 218,-2674 }, { 219,-2674 }, { 220,-2674 }, { 221,-2674 }, { 222,-2674 },
 { 223,-2674 }, { 224,-2674 }, { 225,-2674 }, { 226,-2674 }, { 227,-2674 },
 { 228,-2674 }, { 229,-2674 }, { 230,-2674 }, { 231,-2674 }, { 232,-2674 },
 { 233,-2674 }, { 234,-2674 }, { 235,-2674 }, { 236,-2674 }, { 237,-2674 },
 { 238,-2674 }, { 239,-2674 }, { 240,-2674 }, { 241,-2674 }, { 242,-2674 },
 { 243,-2674 }, { 244,-2674 }, { 245,-2674 }, { 246,-2674 }, { 247,-2674 },
 { 248,-2674 }, { 249,-2674 }, { 250,-2674 }, { 251,-2674 }, { 252,-2674 },
 { 253,-2674 }, { 254,-2674 }, { 255,-2674 }, { 256,-2674 }, {   0,  28 },

 {   0,1290 }, {   1,-2932 }, {   2,-2932 }, {   3,-2932 }, {   4,-2932 },
 {   5,-2932 }, {   6,-2932 }, {   7,-2932 }, {   8,-2932 }, {   9,-2674 },
 {  10,-5016 }, {  11,-2932 }, {  12,-2674 }, {  13,-5016 }, {  14,-2932 },
 {  15,-2932 }, {  16,-2932 }, {  17,-2932 }, {  18,-2932 }, {  19,-2932 },
 {  20,-2932 }, {  21,-2932 }, {  22,-2932 }, {  23,-2932 }, {  24,-2932 },
 {  25,-2932 }, {  26,-2932 }, {  27,-2932 }, {  28,-2932 }, {  29,-2932 },
 {  30,-2932 }, {  31,-2932 }, {  32,-2674 }, {  33,-2932 }, {  34,-2932 },
 {  35,-2932 }, {  36,-2932 }, {  37,-2932 }, {  38,-2932 }, {  39,-2416 },
 {  40,-2932 }, {  41,-2932 }, {  42,-2932 }, {  43,-2932 }, {  44,-2932 },
 {  45,   0 }, {  46,-2932 }, {  47,-2932 }, {  48,-2932 }, {  49,-2932 },

 {  50,-2932 }, {  51,-2932 }, {  52,-2932 }, {  53,-2932 }, {  54,-2932 },
 {  55,-2932 }, {  56,-2932 }, {  57,-2932 }, {  58,-2932 }, {  59,-2932 },
 {  60,-2932 }, {  61,-2932 }, {  62,-2932 }, {  63,-2932 }, {  64,-2932 },
 {  65,-2932 }, {  66,-2932 }, {  67,-2932 }, {  68,-2932 }, {  69,-2932 },
 {  70,-2932 }, {  71,-2932 }, {  72,-2932 }, {  73,-2932 }, {  74,-2932 },
 {  75,-2932 }, {  76,-2932 }, {  77,-2932 }, {  78,-2932 }, {  79,-2932 },
 {  80,-2932 }, {  81,-2932 }, {  82,-2932 }, {  83,-2932 }, {  84,-2932 },
 {  85,-2932 }, {  86,-2932 }, {  87,-2932 }, {  88,-2932 }, {  89,-2932 },
 {  90,-2932 }, {  91,-2932 }, {  92,-2932 }, {  93,-2932 }, {  94,-2932 },
 {  95,-2932 }, {  96,-2932 }, {  97,-2932 }, {  98,-2932 }, {  99,-2932 },

 { 100,-2932 }, { 101,-2932 }, { 102,-2932 }, { 103,-2932 }, { 104,-2932 },
 { 105,-2932 }, { 106,-2932 }, { 107,-2932 }, { 108,-2932 }, { 109,-2932 },
 { 110,-2932 }, { 111,-2932 }, { 112,-2932 }, { 113,-2932 }, { 114,-2932 },
 { 115,-2932 }, { 116,-2932 }, { 117,-2932 }, { 118,-2932 }, { 119,-2932 },
 { 120,-2932 }, { 121,-2932 }, { 122,-2932 }, { 123,-2932 }, { 124,-2932 },
 { 125,-2932 }, { 126,-2932 }, { 127,-2932 }, { 128,-2932 }, { 129,-2932 },
 { 130,-2932 }, { 131,-2932 }, { 132,-2932 }, { 133,-2932 }, { 134,-2932 },
 { 135,-2932 }, { 136,-2932 }, { 137,-2932 }, { 138,-2932 }, { 139,-2932 },
 { 140,-2932 }, { 141,-2932 }, { 142,-2932 }, { 143,-2932 }, { 144,-2932 },
 { 145,-2932 }, { 146,-2932 }, { 147,-2932 }, { 148,-2932 }, { 149,-2932 },

 { 150,-2932 }, { 151,-2932 }, { 152,-2932 }, { 153,-2932 }, { 154,-2932 },
 { 155,-2932 }, { 156,-2932 }, { 157,-2932 }, { 158,-2932 }, { 159,-2932 },
 { 160,-2932 }, { 161,-2932 }, { 162,-2932 }, { 163,-2932 }, { 164,-2932 },
 { 165,-2932 }, { 166,-2932 }, { 167,-2932 }, { 168,-2932 }, { 169,-2932 },
 { 170,-2932 }, { 171,-2932 }, { 172,-2932 }, { 173,-2932 }, { 174,-2932 },
 { 175,-2932 }, { 176,-2932 }, { 177,-2932 }, { 178,-2932 }, { 179,-2932 },
 { 180,-2932 }, { 181,-2932 }, { 182,-2932 }, { 183,-2932 }, { 184,-2932 },
 { 185,-2932 }, { 186,-2932 }, { 187,-2932 }, { 188,-2932 }, { 189,-2932 },
 { 190,-2932 }, { 191,-2932 }, { 192,-2932 }, { 193,-2932 }, { 194,-2932 },
 { 195,-2932 }, { 196,-2932 }, { 197,-2932 }, { 198,-2932 }, { 199,-2932 },

 { 200,-2932 }, { 201,-2932 }, { 202,-2932 }, { 203,-2932 }, { 204,-2932 },
 { 205,-2932 }, { 206,-2932 }, { 207,-2932 }, { 208,-2932 }, { 209,-2932 },
 { 210,-2932 }, { 211,-2932 }, { 212,-2932 }, { 213,-2932 }, { 214,-2932 },
 { 215,-2932 }, { 216,-2932 }, { 217,-2932 }, { 218,-2932 }, { 219,-2932 },
 { 220,-2932 }, { 221,-2932 }, { 222,-2932 }, { 223,-2932 }, { 224,-2932 },
 { 225,-2932 }, { 226,-2932 }, { 227,-2932 }, { 228,-2932 }, { 229,-2932 },
 { 230,-2932 }, { 231,-2932 }, { 232,-2932 }, { 233,-2932 }, { 234,-2932 },
 { 235,-2932 }, { 236,-2932 }, { 237,-2932 }, { 238,-2932 }, { 239,-2932 },
 { 240,-2932 }, { 241,-2932 }, { 242,-2932 }, { 243,-2932 }, { 244,-2932 },
 { 245,-2932 }, { 246,-2932 }, { 247,-2932 }, { 248,-2932 }, { 249,-2932 },

 { 250,-2932 }, { 251,-2932 }, { 252,-2932 }, { 253,-2932 }, { 254,-2932 },
 { 255,-2932 }, { 256,-2932 }, {   0,  55 }, {   0,1032 }, {   1,-2158 },
 {   2,-2158 }, {   3,-2158 }, {   4,-2158 }, {   5,-2158 }, {   6,-2158 },
 {   7,-2158 }, {   8,-2158 }, {   9,-1900 }, {  10,-1642 }, {  11,-2158 },
 {  12,-1900 }, {  13,-1642 }, {  14,-2158 }, {  15,-2158 }, {  16,-2158 },
 {  17,-2158 }, {  18,-2158 }, {  19,-2158 }, {  20,-2158 }, {  21,-2158 },
 {  22,-2158 }, {  23,-2158 }, {  24,-2158 }, {  25,-2158 }, {  26,-2158 },
 {  27,-2158 }, {  28,-2158 }, {  29,-2158 }, {  30,-2158 }, {  31,-2158 },
 {  32,-1900 }, {  33,-2158 }, {  34,-2158 }, {  35,-2158 }, {  36,-2158 },
 {  37,-2158 }, {  38,-2158 }, {  39,-3706 }, {  40,-2158 }, {  41,-2158 },

 {  42,-2158 }, {  43,-2158 }, {  44,-2158 }, {  45,-1595 }, {  46,-2158 },
 {  47,-2158 }, {  48,-2158 }, {  49,-2158 }, {  50,-2158 }, {  51,-2158 },
 {  52,-2158 }, {  53,-2158 }, {  54,-2158 }, {  55,-2158 }, {  56,-2158 },
 {  57,-2158 }, {  58,-2158 }, {  59,-2158 }, {  60,-2158 }, {  61,-2158 },
 {  62,-2158 }, {  63,-2158 }, {  64,-2158 }, {  65,-2158 }, {  66,-2158 },
 {  67,-2158 }, {  68,-2158 }, {  69,-2158 }, {  70,-2158 }, {  71,-2158 },
 {  72,-2158 }, {  73,-2158 }, {  74,-2158 }, {  75,-2158 }, {  76,-2158 },
 {  77,-2158 }, {  78,-2158 }, {  79,-2158 }, {  80,-2158 }, {  81,-2158 },
 {  82,-2158 }, {  83,-2158 }, {  84,-2158 }, {  85,-2158 }, {  86,-2158 },
 {  87,-2158 }, {  88,-2158 }, {  89,-2158 }, {  90,-2158 }, {  91,-2158 },

 {  92,-2158 }, {  93,-2158 }, {  94,-2158 }, {  95,-2158 }, {  96,-2158 },
 {  97,-2158 }, {  98,-2158 }, {  99,-2158 }, { 100,-2158 }, { 101,-2158 },
 { 102,-2158 }, { 103,-2158 }, { 104,-2158 }, { 105,-2158 }, { 106,-2158 },
 { 107,-2158 }, { 108,-2158 }, { 109,-2158 }, { 110,-2158 }, { 111,-2158 },
 { 112,-2158 }, { 113,-2158 }, { 114,-2158 }, { 115,-2158 }, { 116,-2158 },
 { 117,-2158 }, { 118,-2158 }, { 119,-2158 }, { 120,-2158 }, { 121,-2158 },
 { 122,-2158 }, { 123,-2158 }, { 124,-2158 }, { 125,-2158 }, { 126,-2158 },
 { 127,-2158 }, { 128,-2158 }, { 129,-2158 }, { 130,-2158 }, { 131,-2158 },
 { 132,-2158 }, { 133,-2158 }, { 134,-2158 }, { 135,-2158 }, { 136,-2158 },
 { 137,-2158 }, { 138,-2158 }, { 139,-2158 }, { 140,-2158 }, { 141,-2158 },

 { 142,-2158 }, { 143,-2158 }, { 144,-2158 }, { 145,-2158 }, { 146,-2158 },
 { 147,-2158 }, { 148,-2158 }, { 149,-2158 }, { 150,-2158 }, { 151,-2158 },
 { 152,-2158 }, { 153,-2158 }, { 154,-2158 }, { 155,-2158 }, { 156,-2158 },
 { 157,-2158 }, { 158,-2158 }, { 159,-2158 }, { 160,-2158 }, { 161,-2158 },
 { 162,-2158 }, { 163,-2158 }, { 164,-2158 }, { 165,-2158 }, { 166,-2158 },
 { 167,-2158 }, { 168,-2158 }, { 169,-2158 }, { 170,-2158 }, { 171,-2158 },
 { 172,-2158 }, { 173,-2158 }, { 174,-2158 }, { 175,-2158 }, { 176,-2158 },
 { 177,-2158 }, { 178,-2158 }, { 179,-2158 }, { 180,-2158 }, { 181,-2158 },
 { 182,-2158 }, { 183,-2158 }, { 184,-2158 }, { 185,-2158 }, { 186,-2158 },
 { 187,-2158 }, { 188,-2158 }, { 189,-2158 }, { 190,-2158 }, { 191,-2158 },

 { 192,-2158 }, { 193,-2158 }, { 194,-2158 }, { 195,-2158 }, { 196,-2158 },
 { 197,-2158 }, { 198,-2158 }, { 199,-2158 }, { 200,-2158 }, { 201,-2158 },
 { 202,-2158 }, { 203,-2158 }, { 204,-2158 }, { 205,-2158 }, { 206,-2158 },
 { 207,-2158 }, { 208,-2158 }, { 209,-2158 }, { 210,-2158 }, { 211,-2158 },
 { 212,-2158 }, { 213,-2158 }, { 214,-2158 }, { 215,-2158 }, { 216,-2158 },
 { 217,-2158 }, { 218,-2158 }, { 219,-2158 }, { 220,-2158 }, { 221,-2158 },
 { 222,-2158 }, { 223,-2158 }, { 224,-2158 }, { 225,-2158 }, { 226,-2158 },
 { 227,-2158 }, { 228,-2158 }, { 229,-2158 }, { 230,-2158 }, { 231,-2158 },
 { 232,-2158 }, { 233,-2158 }, { 234,-2158 }, { 235,-2158 }, { 236,-2158 },
 { 237,-2158 }, { 238,-2158 }, { 239,-2158 }, { 240,-2158 }, { 241,-2158 },

 { 242,-2158 }, { 243,-2158 }, { 244,-2158 }, { 245,-2158 }, { 246,-2158 },
 { 247,-2158 }, { 248,-2158 }, { 249,-2158 }, { 250,-2158 }, { 251,-2158 },
 { 252,-2158 }, { 253,-2158 }, { 254,-2158 }, { 255,-2158 }, { 256,-2158 },
 {   0,  55 }, {   0, 774 }, {   1,-28121 }, {   2,-28121 }, {   3,-28121 },
 {   4,-28121 }, {   5,-28121 }, {   6,-28121 }, {   7,-28121 }, {   8,-28121 },
 {   9,-28121 }, {  10,-28121 }, {  11,-28121 }, {  12,-28121 }, {  13,-28121 },
 {  14,-28121 }, {  15,-28121 }, {  16,-28121 }, {  17,-28121 }, {  18,-28121 },
 {  19,-28121 }, {  20,-28121 }, {  21,-28121 }, {  22,-28121 }, {  23,-28121 },
 {  24,-28121 }, {  25,-28121 }, {  26,-28121 }, {  27,-28121 }, {  28,-28121 },
 {  29,-28121 }, {  30,-28121 }, {  31,-28121 }, {  32,-28121 }, {  33,-28121 },

 {  34,-28121 }, {  35,-28121 }, {  36,-28121 }, {  37,-28121 }, {  38,-28121 },
 {   0,   0 }, {  40,-28121 }, {  41,-28121 }, {  42,-28121 }, {  43,-28121 },
 {  44,-28121 }, {  45,-28121 }, {  46,-28121 }, {  47,-28121 }, {  48,-28121 },
 {  49,-28121 }, {  50,-28121 }, {  51,-28121 }, {  52,-28121 }, {  53,-28121 },
 {  54,-28121 }, {  55,-28121 }, {  56,-28121 }, {  57,-28121 }, {  58,-28121 },
 {  59,-28121 }, {  60,-28121 }, {  61,-28121 }, {  62,-28121 }, {  63,-28121 },
 {  64,-28121 }, {  65,-28121 }, {  66,-28121 }, {  67,-28121 }, {  68,-28121 },
 {  69,-28121 }, {  70,-28121 }, {  71,-28121 }, {  72,-28121 }, {  73,-28121 },
 {  74,-28121 }, {  75,-28121 }, {  76,-28121 }, {  77,-28121 }, {  78,-28121 },
 {  79,-28121 }, {  80,-28121 }, {  81,-28121 }, {  82,-28121 }, {  83,-28121 },

 {  84,-28121 }, {  85,-28121 }, {  86,-28121 }, {  87,-28121 }, {  88,-28121 },
 {  89,-28121 }, {  90,-28121 }, {  91,-28121 }, {  92,-28121 }, {  93,-28121 },
 {  94,-28121 }, {  95,-28121 }, {  96,-28121 }, {  97,-28121 }, {  98,-28121 },
 {  99,-28121 }, { 100,-28121 }, { 101,-28121 }, { 102,-28121 }, { 103,-28121 },
 { 104,-28121 }, { 105,-28121 }, { 106,-28121 }, { 107,-28121 }, { 108,-28121 },
 { 109,-28121 }, { 110,-28121 }, { 111,-28121 }, { 112,-28121 }, { 113,-28121 },
 { 114,-28121 }, { 115,-28121 }, { 116,-28121 }, { 117,-28121 }, { 118,-28121 },
 { 119,-28121 }, { 120,-28121 }, { 121,-28121 }, { 122,-28121 }, { 123,-28121 },
 { 124,-28121 }, { 125,-28121 }, { 126,-28121 }, { 127,-28121 }, { 128,-28121 },
 { 129,-28121 }, { 130,-28121 }, { 131,-28121 }, { 132,-28121 }, { 133,-28121 },

 { 134,-28121 }, { 135,-28121 }, { 136,-28121 }, { 137,-28121 }, { 138,-28121 },
 { 139,-28121 }, { 140,-28121 }, { 141,-28121 }, { 142,-28121 }, { 143,-28121 },
 { 144,-28121 }, { 145,-28121 }, { 146,-28121 }, { 147,-28121 }, { 148,-28121 },
 { 149,-28121 }, { 150,-28121 }, { 151,-28121 }, { 152,-28121 }, { 153,-28121 },
 { 154,-28121 }, { 155,-28121 }, { 156,-28121 }, { 157,-28121 }, { 158,-28121 },
 { 159,-28121 }, { 160,-28121 }, { 161,-28121 }, { 162,-28121 }, { 163,-28121 },
 { 164,-28121 }, { 165,-28121 }, { 166,-28121 }, { 167,-28121 }, { 168,-28121 },
 { 169,-28121 }, { 170,-28121 }, { 171,-28121 }, { 172,-28121 }, { 173,-28121 },
 { 174,-28121 }, { 175,-28121 }, { 176,-28121 }, { 177,-28121 }, { 178,-28121 },
 { 179,-28121 }, { 180,-28121 }, { 181,-28121 }, { 182,-28121 }, { 183,-28121 },

 { 184,-28121 }, { 185,-28121 }, { 186,-28121 }, { 187,-28121 }, { 188,-28121 },
 { 189,-28121 }, { 190,-28121 }, { 191,-28121 }, { 192,-28121 }, { 193,-28121 },
 { 194,-28121 }, { 195,-28121 }, { 196,-28121 }, { 197,-28121 }, { 198,-28121 },
 { 199,-28121 }, { 200,-28121 }, { 201,-28121 }, { 202,-28121 }, { 203,-28121 },
 { 204,-28121 }, { 205,-28121 }, { 206,-28121 }, { 207,-28121 }, { 208,-28121 },
 { 209,-28121 }, { 210,-28121 }, { 211,-28121 }, { 212,-28121 }, { 213,-28121 },
 { 214,-28121 }, { 215,-28121 }, { 216,-28121 }, { 217,-28121 }, { 218,-28121 },
 { 219,-28121 }, { 220,-28121 }, { 221,-28121 }, { 222,-28121 }, { 223,-28121 },
 { 224,-28121 }, { 225,-28121 }, { 226,-28121 }, { 227,-28121 }, { 228,-28121 },
 { 229,-28121 }, { 230,-28121 }, { 231,-28121 }, { 232,-28121 }, { 233,-28121 },

 { 234,-28121 }, { 235,-28121 }, { 236,-28121 }, { 237,-28121 }, { 238,-28121 },
 { 239,-28121 }, { 240,-28121 }, { 241,-28121 }, { 242,-28121 }, { 243,-28121 },
 { 244,-28121 }, { 245,-28121 }, { 246,-28121 }, { 247,-28121 }, { 248,-28121 },
 { 249,-28121 }, { 250,-28121 }, { 251,-28121 }, { 252,-28121 }, { 253,-28121 },
 { 254,-28121 }, { 255,-28121 }, { 256,-28121 }, {   0,  28 }, {   0, 516 },
 {   1,-1595 }, {   2,-1595 }, {   3,-1595 }, {   4,-1595 }, {   5,-1595 },
 {   6,-1595 }, {   7,-1595 }, {   8,-1595 }, {   9,-1337 }, {  10,-1079 },
 {  11,-1595 }, {  12,-1337 }, {  13,-1079 }, {  14,-1595 }, {  15,-1595 },
 {  16,-1595 }, {  17,-1595 }, {  18,-1595 }, {  19,-1595 }, {  20,-1595 },
 {  21,-1595 }, {  22,-1595 }, {  23,-1595 }, {  24,-1595 }, {  25,-1595 },

 {  26,-1595 }, {  27,-1595 }, {  28,-1595 }, {  29,-1595 }, {  30,-1595 },
 {  31,-1595 }, {  32,-1337 }, {  33,-1595 }, {  34,-1595 }, {  35,-1595 },
 {  36,-1595 }, {  37,-1595 }, {  38,-1595 }, {  39,-3190 }, {  40,-1595 },
 {  41,-1595 }, {  42,-1595 }, {  43,-1595 }, {  44,-1595 }, {  45,-1032 },
 {  46,-1595 }, {  47,-1595 }, {  48,-1595 }, {  49,-1595 }, {  50,-1595 },
 {  51,-1595 }, {  52,-1595 }, {  53,-1595 }, {  54,-1595 }, {  55,-1595 },
 {  56,-1595 }, {  57,-1595 }, {  58,-1595 }, {  59,-1595 }, {  60,-1595 },
 {  61,-1595 }, {  62,-1595 }, {  63,-1595 }, {  64,-1595 }, {  65,-1595 },
 {  66,-1595 }, {  67,-1595 }, {  68,-1595 }, {  69,-1595 }, {  70,-1595 },
 {  71,-1595 }, {  72,-1595 }, {  73,-1595 }, {  74,-1595 }, {  75,-1595 },

 {  76,-1595 }, {  77,-1595 }, {  78,-1595 }, {  79,-1595 }, {  80,-1595 },
 {  81,-1595 }, {  82,-1595 }, {  83,-1595 }, {  84,-1595 }, {  85,-1595 },
 {  86,-1595 }, {  87,-1595 }, {  88,-1595 }, {  89,-1595 }, {  90,-1595 },
 {  91,-1595 }, {  92,-1595 }, {  93,-1595 }, {  94,-1595 }, {  95,-1595 },
 {  96,-1595 }, {  97,-1595 }, {  98,-1595 }, {  99,-1595 }, { 100,-1595 },
 { 101,-1595 }, { 102,-1595 }, { 103,-1595 }, { 104,-1595 }, { 105,-1595 },
 { 106,-1595 }, { 107,-1595 }, { 108,-1595 }, { 109,-1595 }, { 110,-1595 },
 { 111,-1595 }, { 112,-1595 }, { 113,-1595 }, { 114,-1595 }, { 115,-1595 },
 { 116,-1595 }, { 117,-1595 }, { 118,-1595 }, { 119,-1595 }, { 120,-1595 },
 { 121,-1595 }, { 122,-1595 }, { 123,-1595 }, { 124,-1595 }, { 125,-1595 },

 { 126,-1595 }, { 127,-1595 }, { 128,-1595 }, { 129,-1595 }, { 130,-1595 },
 { 131,-1595 }, { 132,-1595 }, { 133,-1595 }, { 134,-1595 }, { 135,-1595 },
 { 136,-1595 }, { 137,-1595 }, { 138,-1595 }, { 139,-1595 }, { 140,-1595 },
 { 141,-1595 }, { 142,-1595 }, { 143,-1595 }, { 144,-1595 }, { 145,-1595 },
 { 146,-1595 }, { 147,-1595 }, { 148,-1595 }, { 149,-1595 }, { 150,-1595 },
 { 151,-1595 }, { 152,-1595 }, { 153,-1595 }, { 154,-1595 }, { 155,-1595 },
 { 156,-1595 }, { 157,-1595 }, { 158,-1595 }, { 159,-1595 }, { 160,-1595 },
 { 161,-1595 }, { 162,-1595 }, { 163,-1595 }, { 164,-1595 }, { 165,-1595 },
 { 166,-1595 }, { 167,-1595 }, { 168,-1595 }, { 169,-1595 }, { 170,-1595 },
 { 171,-1595 }, { 172,-1595 }, { 173,-1595 }, { 174,-1595 }, { 175,-1595 },

 { 176,-1595 }, { 177,-1595 }, { 178,-1595 }, { 179,-1595 }, { 180,-1595 },
 { 181,-1595 }, { 182,-1595 }, { 183,-1595 }, { 184,-1595 }, { 185,-1595 },
 { 186,-1595 }, { 187,-1595 }, { 188,-1595 }, { 189,-1595 }, { 190,-1595 },
 { 191,-1595 }, { 192,-1595 }, { 193,-1595 }, { 194,-1595 }, { 195,-1595 },
 { 196,-1595 }, { 197,-1595 }, { 198,-1595 }, { 199,-1595 }, { 200,-1595 },
 { 201,-1595 }, { 202,-1595 }, { 203,-1595 }, { 204,-1595 }, { 205,-1595 },
 { 206,-1595 }, { 207,-1595 }, { 208,-1595 }, { 209,-1595 }, { 210,-1595 },
 { 211,-1595 }, { 212,-1595 }, { 213,-1595 }, { 214,-1595 }, { 215,-1595 },
 { 216,-1595 }, { 217,-1595 }, { 218,-1595 }, { 219,-1595 }, { 220,-1595 },
 { 221,-1595 }, { 222,-1595 }, { 223,-1595 }, { 224,-1595 }, { 225,-1595 },

 { 226,-1595 }, { 227,-1595 }, { 228,-1595 }, { 229,-1595 }, { 230,-1595 },
 { 231,-1595 }, { 232,-1595 }, { 233,-1595 }, { 234,-1595 }, { 235,-1595 },
 { 236,-1595 }, { 237,-1595 }, { 238,-1595 }, { 239,-1595 }, { 240,-1595 },
 { 241,-1595 }, { 242,-1595 }, { 243,-1595 }, { 244,-1595 }, { 245,-1595 },
 { 246,-1595 }, { 247,-1595 }, { 248,-1595 }, { 249,-1595 }, { 250,-1595 },
 { 251,-1595 }, { 252,-1595 }, { 253,-1595 }, { 254,-1595 }, { 255,-1595 },
 { 256,-1595 }, {   0,  28 }, {   0, 258 }, {   1,-28635 }, {   2,-28635 },
 {   3,-28635 }, {   4,-28635 }, {   5,-28635 }, {   6,-28635 }, {   7,-28635 },
 {   8,-28635 }, {   9,-28635 }, {  10,-28635 }, {  11,-28635 }, {  12,-28635 },
 {  13,-28635 }, {  14,-28635 }, {  15,-28635 }, {  16,-28635 }, {  17,-28635 },

 {  18,-28635 }, {  19,-28635 }, {  20,-28635 }, {  21,-28635 }, {  22,-28635 },
 {  23,-28635 }, {  24,-28635 }, {  25,-28635 }, {  26,-28635 }, {  27,-28635 },
 {  28,-28635 }, {  29,-28635 }, {  30,-28635 }, {  31,-28635 }, {  32,-28635 },
 {  33,-28635 }, {  34,-28635 }, {  35,-28635 }, {  36,-28635 }, {  37,-28635 },
 {  38,-28635 }, {   0,   0 }, {  40,-28635 }, {  41,-28635 }, {  42,-28635 },
 {  43,-28635 }, {  44,-28635 }, {  45,-28635 }, {  46,-28635 }, {  47,-28635 },
 {  48,-28635 }, {  49,-28635 }, {  50,-28635 }, {  51,-28635 }, {  52,-28635 },
 {  53,-28635 }, {  54,-28635 }, {  55,-28635 }, {  56,-28635 }, {  57,-28635 },
 {  58,-28635 }, {  59,-28635 }, {  60,-28635 }, {  61,-28635 }, {  62,-28635 },
 {  63,-28635 }, {  64,-28635 }, {  65,-28635 }, {  66,-28635 }, {  67,-28635 },

 {  68,-28635 }, {  69,-28635 }, {  70,-28635 }, {  71,-28635 }, {  72,-28635 },
 {  73,-28635 }, {  74,-28635 }, {  75,-28635 }, {  76,-28635 }, {  77,-28635 },
 {  78,-28635 }, {  79,-28635 }, {  80,-28635 }, {  81,-28635 }, {  82,-28635 },
 {  83,-28635 }, {  84,-28635 }, {  85,-28635 }, {  86,-28635 }, {  87,-28635 },
 {  88,-28635 }, {  89,-28635 }, {  90,-28635 }, {  91,-28635 }, {  92,-28635 },
 {  93,-28635 }, {  94,-28635 }, {  95,-28635 }, {  96,-28635 }, {  97,-28635 },
 {  98,-28635 }, {  99,-28635 }, { 100,-28635 }, { 101,-28635 }, { 102,-28635 },
 { 103,-28635 }, { 104,-28635 }, { 105,-28635 }, { 106,-28635 }, { 107,-28635 },
 { 108,-28635 }, { 109,-28635 }, { 110,-28635 }, { 111,-28635 }, { 112,-28635 },
 { 113,-28635 }, { 114,-28635 }, { 115,-28635 }, { 116,-28635 }, { 117,-28635 },

 { 118,-28635 }, { 119,-28635 }, { 120,-28635 }, { 121,-28635 }, { 122,-28635 },
 { 123,-28635 }, { 124,-28635 }, { 125,-28635 }, { 126,-28635 }, { 127,-28635 },
 { 128,-28635 }, { 129,-28635 }, { 130,-28635 }, { 131,-28635 }, { 132,-28635 },
 { 133,-28635 }, { 134,-28635 }, { 135,-28635 }, { 136,-28635 }, { 137,-28635 },
 { 138,-28635 }, { 139,-28635 }, { 140,-28635 }, { 141,-28635 }, { 142,-28635 },
 { 143,-28635 }, { 144,-28635 }, { 145,-28635 }, { 146,-28635 }, { 147,-28635 },
 { 148,-28635 }, { 149,-28635 }, { 150,-28635 }, { 151,-28635 }, { 152,-28635 },
 { 153,-28635 }, { 154,-28635 }, { 155,-28635 }, { 156,-28635 }, { 157,-28635 },
 { 158,-28635 }, { 159,-28635 }, { 160,-28635 }, { 161,-28635 }, { 162,-28635 },
 { 163,-28635 }, { 164,-28635 }, { 165,-28635 }, { 166,-28635 }, { 167,-28635 },

 { 168,-28635 }, { 169,-28635 }, { 170,-28635 }, { 171,-28635 }, { 172,-28635 },
 { 173,-28635 }, { 174,-28635 }, { 175,-28635 }, { 176,-28635 }, { 177,-28635 },
 { 178,-28635 }, { 179,-28635 }, { 180,-28635 }, { 181,-28635 }, { 182,-28635 },
 { 183,-28635 }, { 184,-28635 }, { 185,-28635 }, { 186,-28635 }, { 187,-28635 },
 { 188,-28635 }, { 189,-28635 }, { 190,-28635 }, { 191,-28635 }, { 192,-28635 },
 { 193,-28635 }, { 194,-28635 }, { 195,-28635 }, { 196,-28635 }, { 197,-28635 },
 { 198,-28635 }, { 199,-28635 }, { 200,-28635 }, { 201,-28635 }, { 202,-28635 },
 { 203,-28635 }, { 204,-28635 }, { 205,-28635 }, { 206,-28635 }, { 207,-28635 },
 { 208,-28635 }, { 209,-28635 }, { 210,-28635 }, { 211,-28635 }, { 212,-28635 },
 { 213,-28635 }, { 214,-28635 }, { 215,-28635 }, { 216,-28635 }, { 217,-28635 },

 { 218,-28635 }, { 219,-28635 }, { 220,-28635 }, { 221,-28635 }, { 222,-28635 },
 { 223,-28635 }, { 224,-28635 }, { 225,-28635 }, { 226,-28635 }, { 227,-28635 },
 { 228,-28635 }, { 229,-28635 }, { 230,-28635 }, { 231,-28635 }, { 232,-28635 },
 { 233,-28635 }, { 234,-28635 }, { 235,-28635 }, { 236,-28635 }, { 237,-28635 },
 { 238,-28635 }, { 239,-28635 }, { 240,-28635 }, { 241,-28635 }, { 242,-28635 },
 { 243,-28635 }, { 244,-28635 }, { 245,-28635 }, { 246,-28635 }, { 247,-28635 },
 { 248,-28635 }, { 249,-28635 }, { 250,-28635 }, { 251,-28635 }, { 252,-28635 },
 { 253,-28635 }, { 254,-28635 }, { 255,-28635 }, { 256,-28635 }, { 257,  80 },
 {   1,   0 },    };

static const struct yy_trans_info *yy_start_state_list[27] =
    {
    &yy_transition[1],
    &yy_transition[3],
    &yy_transition[261],
    &yy_transition[519],
    &yy_transition[777],
    &yy_transition[1035],
    &yy_transition[1293],
    &yy_transition[1551],
    &yy_transition[1809],
    &yy_transition[2067],
    &yy_transition[2325],
    &yy_transition[2583],
    &yy_transition[2841],
    &yy_transition[3099],
    &yy_transition[3357],
    &yy_transition[3615],
    &yy_transition[3873],
    &yy_transition[4131],
    &yy_transition[4389],
    &yy_transition[4647],
    &yy_transition[4905],
    &yy_transition[5163],
    &yy_transition[5421],
    &yy_transition[5679],
    &yy_transition[5937],
    &yy_transition[6195],
    &yy_transition[6453],

    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "scan.l"

#line 46 "scan.l"

/* LCOV_EXCL_START */

/* Avoid exit() on fatal scanner errors (a bit ugly -- see yy_fatal_error) */
#undef fprintf
#define fprintf(file, fmt, msg)  fprintf_to_ereport(fmt, msg)

static void
fprintf_to_ereport(const char *fmt, const char *msg)
{
	ereport(ERROR, (errmsg_internal("%s", msg)));
}

/*
 * GUC variables.  This is a DIRECT violation of the warning given at the
 * head of gram.y, ie flex/bison code must not depend on any GUC variables;
 * as such, changing their values can induce very unintuitive behavior.
 * But we shall have to live with it until we can remove these variables.
 */
int			backslash_quote = BACKSLASH_QUOTE_SAFE_ENCODING;
bool		escape_string_warning = true;
bool		standard_conforming_strings = true;

/*
 * Constant data exported from this file.  This array maps from the
 * zero-based keyword numbers returned by ScanKeywordLookup to the
 * Bison token numbers needed by gram.y.  This is exported because
 * callers need to pass it to scanner_init, if they are using the
 * standard keyword list ScanKeywords.
 */
#define PG_KEYWORD(kwname, value, category) value,

const uint16 ScanKeywordTokens[] = {
#include "parser/kwlist.h"
};

#undef PG_KEYWORD

/*
 * Set the type of YYSTYPE.
 */
#define YYSTYPE core_YYSTYPE

/*
 * Set the type of yyextra.  All state variables used by the scanner should
 * be in yyextra, *not* statically allocated.
 */
#define YY_EXTRA_TYPE core_yy_extra_type *

/*
 * Each call to yylex must set yylloc to the location of the found token
 * (expressed as a byte offset from the start of the input text).
 * When we parse a token that requires multiple lexer rules to process,
 * this should be done in the first such rule, else yylloc will point
 * into the middle of the token.
 */
#define SET_YYLLOC()  (*(yylloc) = yytext - yyextra->scanbuf)

/*
 * Advance yylloc by the given number of bytes.
 */
#define ADVANCE_YYLLOC(delta)  ( *(yylloc) += (delta) )

#define startlit()	( yyextra->literallen = 0 )
static void addlit(char *ytext, int yleng, core_yyscan_t yyscanner);
static void addlitchar(unsigned char ychar, core_yyscan_t yyscanner);
static char *litbufdup(core_yyscan_t yyscanner);
static char *litbuf_udeescape(unsigned char escape, core_yyscan_t yyscanner);
static unsigned char unescape_single_char(unsigned char c, core_yyscan_t yyscanner);
static int	process_integer_literal(const char *token, YYSTYPE *lval);
static bool is_utf16_surrogate_first(pg_wchar c);
static bool is_utf16_surrogate_second(pg_wchar c);
static pg_wchar surrogate_pair_to_codepoint(pg_wchar first, pg_wchar second);
static void addunicode(pg_wchar c, yyscan_t yyscanner);
static bool check_uescapechar(unsigned char escape);

#define yyerror(msg)  scanner_yyerror(msg, yyscanner)

#define lexer_errposition()  scanner_errposition(*(yylloc), yyscanner)

static void check_string_escape_warning(unsigned char ychar, core_yyscan_t yyscanner);
static void check_escape_warning(core_yyscan_t yyscanner);

/*
 * Work around a bug in flex 2.5.35: it emits a couple of functions that
 * it forgets to emit declarations for.  Since we use -Wmissing-prototypes,
 * this would cause warnings.  Providing our own declarations should be
 * harmless even when the bug gets fixed.
 */
extern int	core_yyget_column(yyscan_t yyscanner);
extern void core_yyset_column(int column_no, yyscan_t yyscanner);

#line 8856 "scan.c"
#define YY_NO_INPUT 1
/*
 * OK, here is a short description of lex/flex rules behavior.
 * The longest pattern which matches an input string is always chosen.
 * For equal-length patterns, the first occurring in the rules list is chosen.
 * INITIAL is the starting state, to which all non-conditional rules apply.
 * Exclusive states change parsing rules while the state is active.  When in
 * an exclusive state, only those rules defined for that state apply.
 *
 * We use exclusive states for quoted strings, extended comments,
 * and to eliminate parsing troubles for numeric strings.
 * Exclusive states:
 *  <xb> bit string literal
 *  <xc> extended C-style comments
 *  <xd> delimited identifiers (double-quoted identifiers)
 *  <xh> hexadecimal numeric string
 *  <xq> standard quoted strings
 *  <xe> extended quoted strings (support backslash escape sequences)
 *  <xdolq> $foo$ quoted strings
 *  <xui> quoted identifier with Unicode escapes
 *  <xuiend> end of a quoted identifier with Unicode escapes, UESCAPE can follow
 *  <xus> quoted string with Unicode escapes
 *  <xusend> end of a quoted string with Unicode escapes, UESCAPE can follow
 *  <xeu> Unicode surrogate pair in extended quoted string
 *
 * Remember to add an <<EOF>> case whenever you add a new exclusive state!
 * The default one is probably not the right thing.
 */

/*
 * In order to make the world safe for Windows and Mac clients as well as
 * Unix ones, we accept either \n or \r as a newline.  A DOS-style \r\n
 * sequence will be seen as two successive newlines, but that doesn't cause
 * any problems.  Comments that start with -- and extend to the next
 * newline are treated as equivalent to a single whitespace character.
 *
 * NOTE a fine point: if there is no newline following --, we will absorb
 * everything to the end of the input as a comment.  This is correct.  Older
 * versions of Postgres failed to recognize -- as a comment if the input
 * did not end with a newline.
 *
 * XXX perhaps \f (formfeed) should be treated as a newline as well?
 *
 * XXX if you change the set of whitespace characters, fix scanner_isspace()
 * to agree.
 */
/*
 * SQL requires at least one newline in the whitespace separating
 * string literals that are to be concatenated.  Silly, but who are we
 * to argue?  Note that {whitespace_with_newline} should not have * after
 * it, whereas {whitespace} should generally have a * after it...
 */
/*
 * To ensure that {quotecontinue} can be scanned without having to back up
 * if the full pattern isn't matched, we include trailing whitespace in
 * {quotestop}.  This matches all cases where {quotecontinue} fails to match,
 * except for {quote} followed by whitespace and just one "-" (not two,
 * which would start a {comment}).  To cover that we have {quotefail}.
 * The actions for {quotestop} and {quotefail} must throw back characters
 * beyond the quote proper.
 */
/* Bit string
 * It is tempting to scan the string for only those characters
 * which are allowed. However, this leads to silently swallowed
 * characters if illegal characters are included in the string.
 * For example, if xbinside is [01] then B'ABCD' is interpreted
 * as a zero-length string, and the ABCD' is lost!
 * Better to pass the string forward and let the input routines
 * validate the contents.
 */
/* Hexadecimal number */
/* National character */
/* Quoted string that allows backslash escapes */
/* Extended quote
 * xqdouble implements embedded quote, ''''
 */
/* $foo$ style quotes ("dollar quoting")
 * The quoted string starts with $foo$ where "foo" is an optional string
 * in the form of an identifier, except that it may not contain "$",
 * and extends to the first occurrence of an identical string.
 * There is *no* processing of the quoted text.
 *
 * {dolqfailed} is an error rule to avoid scanner backup when {dolqdelim}
 * fails to match its trailing "$".
 */
/* Double quote
 * Allows embedded spaces and other special characters into identifiers.
 */
/* Unicode escapes */
/* error rule to avoid backup */
/* Quoted identifier with Unicode escapes */
/* Quoted string with Unicode escapes */
/* Optional UESCAPE after a quoted string or identifier with Unicode escapes. */
/* error rule to avoid backup */
/* C-style comments
 *
 * The "extended comment" syntax closely resembles allowable operator syntax.
 * The tricky part here is to get lex to recognize a string starting with
 * slash-star as a comment, when interpreting it as an operator would produce
 * a longer match --- remember lex will prefer a longer match!  Also, if we
 * have something like plus-slash-star, lex will think this is a 3-character
 * operator whereas we want to see it as a + operator and a comment start.
 * The solution is two-fold:
 * 1. append {op_chars}* to xcstart so that it matches as much text as
 *    {operator} would. Then the tie-breaker (first matching rule of same
 *    length) ensures xcstart wins.  We put back the extra stuff with yyless()
 *    in case it contains a star-slash that should terminate the comment.
 * 2. In the operator rule, check for slash-star within the operator, and
 *    if found throw it back with yyless().  This handles the plus-slash-star
 *    problem.
 * Dash-dash comments have similar interactions with the operator rule.
 */
/* Assorted special-case operators and operator-like tokens */
/*
 * These operator-like tokens (unlike the above ones) also match the {operator}
 * rule, which means that they might be overridden by a longer match if they
 * are followed by a comment start or a + or - character. Accordingly, if you
 * add to this list, you must also add corresponding code to the {operator}
 * block to return the correct token in such cases. (This is not needed in
 * psqlscan.l since the token value is ignored there.)
 */
/*
 * "self" is the set of chars that should be returned as single-character
 * tokens.  "op_chars" is the set of chars that can make up "Op" tokens,
 * which can be one or more characters long (but if a single-char token
 * appears in the "self" set, it is not to be returned as an Op).  Note
 * that the sets overlap, but each has some chars that are not in the other.
 *
 * If you change either set, adjust the character lists appearing in the
 * rule for "operator"!
 */
/* we no longer allow unary minus in numbers.
 * instead we pass it separately to parser. there it gets
 * coerced via doNegate() -- Leon aug 20 1999
 *
 * {decimalfail} is used because we would like "1..10" to lex as 1, dot_dot, 10.
 *
 * {realfail1} and {realfail2} are added to prevent the need for scanner
 * backup when the {real} rule fails to match completely.
 */
/*
 * Dollar quoted strings are totally opaque, and no escaping is done on them.
 * Other quoted strings must allow some special characters such as single-quote
 *  and newline.
 * Embedded single-quotes are implemented both in the SQL standard
 *  style of two adjacent single quotes "''" and in the Postgres/Java style
 *  of escaped-quote "\'".
 * Other embedded escaped characters are matched explicitly and the leading
 *  backslash is dropped from the string.
 * Note that xcstart must appear before operator, as explained above!
 *  Also whitespace (comment) must appear before operator.
 */
#line 9009 "scan.c"

#define INITIAL 0
#define xb 1
#define xc 2
#define xd 3
#define xh 4
#define xq 5
#define xe 6
#define xdolq 7
#define xui 8
#define xuiend 9
#define xus 10
#define xusend 11
#define xeu 12

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    YYLTYPE * yylloc_r;

    }; /* end struct yyguts_t */

static int yy_init_globals ( yyscan_t yyscanner );

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
    #    define yylloc yyg->yylloc_r
    
int yylex_init (yyscan_t* scanner);

int yylex_init_extra ( YY_EXTRA_TYPE user_defined, yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( yyscan_t yyscanner );

int yyget_debug ( yyscan_t yyscanner );

void yyset_debug ( int debug_flag , yyscan_t yyscanner );

YY_EXTRA_TYPE yyget_extra ( yyscan_t yyscanner );

void yyset_extra ( YY_EXTRA_TYPE user_defined , yyscan_t yyscanner );

FILE *yyget_in ( yyscan_t yyscanner );

void yyset_in  ( FILE * _in_str , yyscan_t yyscanner );

FILE *yyget_out ( yyscan_t yyscanner );

void yyset_out  ( FILE * _out_str , yyscan_t yyscanner );

			int yyget_leng ( yyscan_t yyscanner );

char *yyget_text ( yyscan_t yyscanner );

int yyget_lineno ( yyscan_t yyscanner );

void yyset_lineno ( int _line_number , yyscan_t yyscanner );

int yyget_column  ( yyscan_t yyscanner );

void yyset_column ( int _column_no , yyscan_t yyscanner );

YYSTYPE * yyget_lval ( yyscan_t yyscanner );

void yyset_lval ( YYSTYPE * yylval_param , yyscan_t yyscanner );

       YYLTYPE *yyget_lloc ( yyscan_t yyscanner );
    
        void yyset_lloc ( YYLTYPE * yylloc_param , yyscan_t yyscanner );
    
/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( yyscan_t yyscanner );
#else
extern int yywrap ( yyscan_t yyscanner );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int , yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * , yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( yyscan_t yyscanner );
#else
static int input ( yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param , yyscan_t yyscanner);

#define YY_DECL int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param , yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yylval = yylval_param;

    yylloc = yylloc_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
		}

		yy_load_buffer_state( yyscanner );
		}

	{
#line 421 "scan.l"


#line 9306 "scan.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start_state_list[yyg->yy_start];
yy_match:
		{
		const struct yy_trans_info *yy_trans_info;

		YY_CHAR yy_c;

		for ( yy_c = YY_SC_TO_UI(*yy_cp);
		      (yy_trans_info = &yy_current_state[yy_c])->
		yy_verify == yy_c;
		      yy_c = YY_SC_TO_UI(*++yy_cp) )
			yy_current_state += yy_trans_info->yy_nxt;
		}

yy_find_action:
		yy_act = yy_current_state[-1].yy_nxt;

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 423 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 427 "scan.l"
{
					/* Set location in case of syntax error in comment */
					SET_YYLLOC();
					yyextra->xcdepth = 0;
					BEGIN(xc);
					/* Put back any characters past slash-star; see above */
					yyless(2);
				}
	YY_BREAK

case 3:
YY_RULE_SETUP
#line 437 "scan.l"
{
					(yyextra->xcdepth)++;
					/* Put back any characters past slash-star; see above */
					yyless(2);
				}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 443 "scan.l"
{
					if (yyextra->xcdepth <= 0)
						BEGIN(INITIAL);
					else
						(yyextra->xcdepth)--;
				}
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 450 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 454 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 458 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case YY_STATE_EOF(xc):
#line 462 "scan.l"
{
					yyerror("unterminated /* comment");
				}
	YY_BREAK
/* <xc> */
case 8:
YY_RULE_SETUP
#line 467 "scan.l"
{
					/* Binary bit type.
					 * At some point we should simply pass the string
					 * forward to the parser and label it there.
					 * In the meantime, place a leading "b" on the string
					 * to mark it for the input routine as a binary string.
					 */
					SET_YYLLOC();
					BEGIN(xb);
					startlit();
					addlitchar('b', yyscanner);
				}
	YY_BREAK
case 9:
/* rule 9 can match eol */
#line 480 "scan.l"
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 480 "scan.l"
{
					yyless(1);
					BEGIN(INITIAL);
					yylval->str = litbufdup(yyscanner);
					return BCONST;
				}
	YY_BREAK
case 11:
/* rule 11 can match eol */
#line 487 "scan.l"
case 12:
/* rule 12 can match eol */
YY_RULE_SETUP
#line 487 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 13:
/* rule 13 can match eol */
#line 491 "scan.l"
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 491 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case YY_STATE_EOF(xb):
#line 494 "scan.l"
{ yyerror("unterminated bit string literal"); }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 496 "scan.l"
{
					/* Hexadecimal bit type.
					 * At some point we should simply pass the string
					 * forward to the parser and label it there.
					 * In the meantime, place a leading "x" on the string
					 * to mark it for the input routine as a hex string.
					 */
					SET_YYLLOC();
					BEGIN(xh);
					startlit();
					addlitchar('x', yyscanner);
				}
	YY_BREAK
case 16:
/* rule 16 can match eol */
#line 509 "scan.l"
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 509 "scan.l"
{
					yyless(1);
					BEGIN(INITIAL);
					yylval->str = litbufdup(yyscanner);
					return XCONST;
				}
	YY_BREAK
case YY_STATE_EOF(xh):
#line 515 "scan.l"
{ yyerror("unterminated hexadecimal string literal"); }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 517 "scan.l"
{
					/* National character.
					 * We will pass this along as a normal character string,
					 * but preceded with an internally-generated "NCHAR".
					 */
					int		kwnum;

					SET_YYLLOC();
					yyless(1);	/* eat only 'n' this time */

					kwnum = ScanKeywordLookup("nchar",
											  yyextra->keywordlist);
					if (kwnum >= 0)
					{
						yylval->keyword = GetScanKeyword(kwnum,
														 yyextra->keywordlist);
						return yyextra->keyword_tokens[kwnum];
					}
					else
					{
						/* If NCHAR isn't a keyword, just return "n" */
						yylval->str = pstrdup("n");
						return IDENT;
					}
				}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 543 "scan.l"
{
					yyextra->warn_on_first_escape = true;
					yyextra->saw_non_ascii = false;
					SET_YYLLOC();
					if (yyextra->standard_conforming_strings)
						BEGIN(xq);
					else
						BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 553 "scan.l"
{
					yyextra->warn_on_first_escape = false;
					yyextra->saw_non_ascii = false;
					SET_YYLLOC();
					BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 560 "scan.l"
{
					SET_YYLLOC();
					if (!yyextra->standard_conforming_strings)
						ereport(ERROR,
								(errcode(ERRCODE_FEATURE_NOT_SUPPORTED),
								 errmsg("unsafe use of string constant with Unicode escapes"),
								 errdetail("String constants with Unicode escapes cannot be used when standard_conforming_strings is off."),
								 lexer_errposition()));
					BEGIN(xus);
					startlit();
				}
	YY_BREAK
case 22:
/* rule 22 can match eol */
#line 572 "scan.l"
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 572 "scan.l"
{
					yyless(1);
					BEGIN(INITIAL);
					/*
					 * check that the data remains valid if it might have been
					 * made invalid by unescaping any chars.
					 */
					if (yyextra->saw_non_ascii)
						pg_verifymbstr(yyextra->literalbuf,
									   yyextra->literallen,
									   false);
					yylval->str = litbufdup(yyscanner);
					return SCONST;
				}
	YY_BREAK
case 24:
/* rule 24 can match eol */
#line 587 "scan.l"
case 25:
/* rule 25 can match eol */
YY_RULE_SETUP
#line 587 "scan.l"
{
					/* throw back all but the quote */
					yyless(1);
					/* xusend state looks for possible UESCAPE */
					BEGIN(xusend);
				}
	YY_BREAK
case 26:
/* rule 26 can match eol */
YY_RULE_SETUP
#line 593 "scan.l"
{
					/* stay in xusend state over whitespace */
				}
	YY_BREAK
case YY_STATE_EOF(xusend):
#line 596 "scan.l"
case 27:
/* rule 27 can match eol */
#line 598 "scan.l"
case 28:
/* rule 28 can match eol */
YY_RULE_SETUP
#line 598 "scan.l"
{
					/* no UESCAPE after the quote, throw back everything */
					yyless(0);
					BEGIN(INITIAL);
					yylval->str = litbuf_udeescape('\\', yyscanner);
					return SCONST;
				}
	YY_BREAK
case 29:
/* rule 29 can match eol */
YY_RULE_SETUP
#line 605 "scan.l"
{
					/* found UESCAPE after the end quote */
					BEGIN(INITIAL);
					if (!check_uescapechar(yytext[yyleng - 2]))
					{
						SET_YYLLOC();
						ADVANCE_YYLLOC(yyleng - 2);
						yyerror("invalid Unicode escape character");
					}
					yylval->str = litbuf_udeescape(yytext[yyleng - 2],
												   yyscanner);
					return SCONST;
				}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 618 "scan.l"
{
					addlitchar('\'', yyscanner);
				}
	YY_BREAK
case 31:
/* rule 31 can match eol */
YY_RULE_SETUP
#line 621 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 32:
/* rule 32 can match eol */
YY_RULE_SETUP
#line 624 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 627 "scan.l"
{
					pg_wchar	c = strtoul(yytext + 2, NULL, 16);

					check_escape_warning(yyscanner);

					if (is_utf16_surrogate_first(c))
					{
						yyextra->utf16_first_part = c;
						BEGIN(xeu);
					}
					else if (is_utf16_surrogate_second(c))
						yyerror("invalid Unicode surrogate pair");
					else
						addunicode(c, yyscanner);
				}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 642 "scan.l"
{
					pg_wchar	c = strtoul(yytext + 2, NULL, 16);

					if (!is_utf16_surrogate_second(c))
						yyerror("invalid Unicode surrogate pair");

					c = surrogate_pair_to_codepoint(yyextra->utf16_first_part, c);

					addunicode(c, yyscanner);

					BEGIN(xe);
				}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 654 "scan.l"
{ yyerror("invalid Unicode surrogate pair"); }
	YY_BREAK
case 36:
/* rule 36 can match eol */
YY_RULE_SETUP
#line 655 "scan.l"
{ yyerror("invalid Unicode surrogate pair"); }
	YY_BREAK
case YY_STATE_EOF(xeu):
#line 656 "scan.l"
{ yyerror("invalid Unicode surrogate pair"); }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 657 "scan.l"
{
					ereport(ERROR,
							(errcode(ERRCODE_INVALID_ESCAPE_SEQUENCE),
							 errmsg("invalid Unicode escape"),
							 errhint("Unicode escapes must be \\uXXXX or \\UXXXXXXXX."),
							 lexer_errposition()));
				}
	YY_BREAK
case 38:
/* rule 38 can match eol */
YY_RULE_SETUP
#line 664 "scan.l"
{
					if (yytext[1] == '\'')
					{
						if (yyextra->backslash_quote == BACKSLASH_QUOTE_OFF ||
							(yyextra->backslash_quote == BACKSLASH_QUOTE_SAFE_ENCODING &&
							 PG_ENCODING_IS_CLIENT_ONLY(pg_get_client_encoding())))
							ereport(ERROR,
									(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
									 errmsg("unsafe use of \\' in a string literal"),
									 errhint("Use '' to write quotes in strings. \\' is insecure in client-only encodings."),
									 lexer_errposition()));
					}
					check_string_escape_warning(yytext[1], yyscanner);
					addlitchar(unescape_single_char(yytext[1], yyscanner),
							   yyscanner);
				}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 680 "scan.l"
{
					unsigned char c = strtoul(yytext + 1, NULL, 8);

					check_escape_warning(yyscanner);
					addlitchar(c, yyscanner);
					if (c == '\0' || IS_HIGHBIT_SET(c))
						yyextra->saw_non_ascii = true;
				}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 688 "scan.l"
{
					unsigned char c = strtoul(yytext + 2, NULL, 16);

					check_escape_warning(yyscanner);
					addlitchar(c, yyscanner);
					if (c == '\0' || IS_HIGHBIT_SET(c))
						yyextra->saw_non_ascii = true;
				}
	YY_BREAK
case 41:
/* rule 41 can match eol */
YY_RULE_SETUP
#line 696 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 699 "scan.l"
{
					/* This is only needed for \ just before EOF */
					addlitchar(yytext[0], yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xq):
case YY_STATE_EOF(xe):
case YY_STATE_EOF(xus):
#line 703 "scan.l"
{ yyerror("unterminated quoted string"); }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 705 "scan.l"
{
					SET_YYLLOC();
					yyextra->dolqstart = pstrdup(yytext);
					BEGIN(xdolq);
					startlit();
				}
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 711 "scan.l"
{
					SET_YYLLOC();
					/* throw back all but the initial "$" */
					yyless(1);
					/* and treat it as {other} */
					return yytext[0];
				}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 718 "scan.l"
{
					if (strcmp(yytext, yyextra->dolqstart) == 0)
					{
						pfree(yyextra->dolqstart);
						yyextra->dolqstart = NULL;
						BEGIN(INITIAL);
						yylval->str = litbufdup(yyscanner);
						return SCONST;
					}
					else
					{
						/*
						 * When we fail to match $...$ to dolqstart, transfer
						 * the $... part to the output, but put back the final
						 * $ for rescanning.  Consider $delim$...$junk$delim$
						 */
						addlit(yytext, yyleng - 1, yyscanner);
						yyless(yyleng - 1);
					}
				}
	YY_BREAK
case 46:
/* rule 46 can match eol */
YY_RULE_SETUP
#line 738 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 741 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 744 "scan.l"
{
					/* This is only needed for $ inside the quoted text */
					addlitchar(yytext[0], yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xdolq):
#line 748 "scan.l"
{ yyerror("unterminated dollar-quoted string"); }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 750 "scan.l"
{
					SET_YYLLOC();
					BEGIN(xd);
					startlit();
				}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 755 "scan.l"
{
					SET_YYLLOC();
					BEGIN(xui);
					startlit();
				}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 760 "scan.l"
{
					char	   *ident;

					BEGIN(INITIAL);
					if (yyextra->literallen == 0)
						yyerror("zero-length delimited identifier");
					ident = litbufdup(yyscanner);
					if (yyextra->literallen >= NAMEDATALEN)
						truncate_identifier(ident, yyextra->literallen, true);
					yylval->str = ident;
					return IDENT;
				}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 772 "scan.l"
{
					yyless(1);
					/* xuiend state looks for possible UESCAPE */
					BEGIN(xuiend);
				}
	YY_BREAK
case 53:
/* rule 53 can match eol */
YY_RULE_SETUP
#line 777 "scan.l"
{
					/* stay in xuiend state over whitespace */
				}
	YY_BREAK
case YY_STATE_EOF(xuiend):
#line 780 "scan.l"
case 54:
/* rule 54 can match eol */
#line 782 "scan.l"
case 55:
/* rule 55 can match eol */
YY_RULE_SETUP
#line 782 "scan.l"
{
					/* no UESCAPE after the quote, throw back everything */
					char	   *ident;
					int			identlen;

					yyless(0);

					BEGIN(INITIAL);
					if (yyextra->literallen == 0)
						yyerror("zero-length delimited identifier");
					ident = litbuf_udeescape('\\', yyscanner);
					identlen = strlen(ident);
					if (identlen >= NAMEDATALEN)
						truncate_identifier(ident, identlen, true);
					yylval->str = ident;
					return IDENT;
				}
	YY_BREAK
case 56:
/* rule 56 can match eol */
YY_RULE_SETUP
#line 799 "scan.l"
{
					/* found UESCAPE after the end quote */
					char	   *ident;
					int			identlen;

					BEGIN(INITIAL);
					if (yyextra->literallen == 0)
						yyerror("zero-length delimited identifier");
					if (!check_uescapechar(yytext[yyleng - 2]))
					{
						SET_YYLLOC();
						ADVANCE_YYLLOC(yyleng - 2);
						yyerror("invalid Unicode escape character");
					}
					ident = litbuf_udeescape(yytext[yyleng - 2], yyscanner);
					identlen = strlen(ident);
					if (identlen >= NAMEDATALEN)
						truncate_identifier(ident, identlen, true);
					yylval->str = ident;
					return IDENT;
				}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 820 "scan.l"
{
					addlitchar('"', yyscanner);
				}
	YY_BREAK
case 58:
/* rule 58 can match eol */
YY_RULE_SETUP
#line 823 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xd):
case YY_STATE_EOF(xui):
#line 826 "scan.l"
{ yyerror("unterminated quoted identifier"); }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 828 "scan.l"
{
					char	   *ident;

					SET_YYLLOC();
					/* throw back all but the initial u/U */
					yyless(1);
					/* and treat it as {identifier} */
					ident = downcase_truncate_identifier(yytext, yyleng, true);
					yylval->str = ident;
					return IDENT;
				}
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 840 "scan.l"
{
					SET_YYLLOC();
					return TYPECAST;
				}
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 845 "scan.l"
{
					SET_YYLLOC();
					return DOT_DOT;
				}
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 850 "scan.l"
{
					SET_YYLLOC();
					return COLON_EQUALS;
				}
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 855 "scan.l"
{
					SET_YYLLOC();
					return EQUALS_GREATER;
				}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 860 "scan.l"
{
					SET_YYLLOC();
					return LESS_EQUALS;
				}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 865 "scan.l"
{
					SET_YYLLOC();
					return GREATER_EQUALS;
				}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 870 "scan.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					SET_YYLLOC();
					return NOT_EQUALS;
				}
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 876 "scan.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					SET_YYLLOC();
					return NOT_EQUALS;
				}
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 882 "scan.l"
{
					SET_YYLLOC();
					return yytext[0];
				}
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 887 "scan.l"
{
					/*
					 * Check for embedded slash-star or dash-dash; those
					 * are comment starts, so operator must stop there.
					 * Note that slash-star or dash-dash at the first
					 * character will match a prior rule, not this one.
					 */
					int			nchars = yyleng;
					char	   *slashstar = strstr(yytext, "/*");
					char	   *dashdash = strstr(yytext, "--");

					if (slashstar && dashdash)
					{
						/* if both appear, take the first one */
						if (slashstar > dashdash)
							slashstar = dashdash;
					}
					else if (!slashstar)
						slashstar = dashdash;
					if (slashstar)
						nchars = slashstar - yytext;

					/*
					 * For SQL compatibility, '+' and '-' cannot be the
					 * last char of a multi-char operator unless the operator
					 * contains chars that are not in SQL operators.
					 * The idea is to lex '=-' as two operators, but not
					 * to forbid operator names like '?-' that could not be
					 * sequences of SQL operators.
					 */
					if (nchars > 1 &&
						(yytext[nchars - 1] == '+' ||
						 yytext[nchars - 1] == '-'))
					{
						int			ic;

						for (ic = nchars - 2; ic >= 0; ic--)
						{
							char c = yytext[ic];
							if (c == '~' || c == '!' || c == '@' ||
								c == '#' || c == '^' || c == '&' ||
								c == '|' || c == '`' || c == '?' ||
								c == '%')
								break;
						}
						if (ic < 0)
						{
							/*
							 * didn't find a qualifying character, so remove
							 * all trailing [+-]
							 */
							do {
								nchars--;
							} while (nchars > 1 &&
								 (yytext[nchars - 1] == '+' ||
								  yytext[nchars - 1] == '-'));
						}
					}

					SET_YYLLOC();

					if (nchars < yyleng)
					{
						/* Strip the unwanted chars from the token */
						yyless(nchars);
						/*
						 * If what we have left is only one char, and it's
						 * one of the characters matching "self", then
						 * return it as a character token the same way
						 * that the "self" rule would have.
						 */
						if (nchars == 1 &&
							strchr(",()[].;:+-*/%^<>=", yytext[0]))
							return yytext[0];
						/*
						 * Likewise, if what we have left is two chars, and
						 * those match the tokens ">=", "<=", "=>", "<>" or
						 * "!=", then we must return the appropriate token
						 * rather than the generic Op.
						 */
						if (nchars == 2)
						{
							if (yytext[0] == '=' && yytext[1] == '>')
								return EQUALS_GREATER;
							if (yytext[0] == '>' && yytext[1] == '=')
								return GREATER_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '=')
								return LESS_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '>')
								return NOT_EQUALS;
							if (yytext[0] == '!' && yytext[1] == '=')
								return NOT_EQUALS;
						}
					}

					/*
					 * Complain if operator is too long.  Unlike the case
					 * for identifiers, we make this an error not a notice-
					 * and-truncate, because the odds are we are looking at
					 * a syntactic mistake anyway.
					 */
					if (nchars >= NAMEDATALEN)
						yyerror("operator too long");

					yylval->str = pstrdup(yytext);
					return Op;
				}
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 995 "scan.l"
{
					SET_YYLLOC();
					yylval->ival = atol(yytext + 1);
					return PARAM;
				}
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 1001 "scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval);
				}
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 1005 "scan.l"
{
					SET_YYLLOC();
					yylval->str = pstrdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 1010 "scan.l"
{
					/* throw back the .., and treat as integer */
					yyless(yyleng - 2);
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval);
				}
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 1016 "scan.l"
{
					SET_YYLLOC();
					yylval->str = pstrdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 1021 "scan.l"
{
					/*
					 * throw back the [Ee], and figure out whether what
					 * remains is an {integer} or {decimal}.
					 */
					yyless(yyleng - 1);
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval);
				}
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 1030 "scan.l"
{
					/* throw back the [Ee][+-], and proceed as above */
					yyless(yyleng - 2);
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval);
				}
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 1038 "scan.l"
{
					int			kwnum;
					char	   *ident;

					SET_YYLLOC();

					/* Is it a keyword? */
					kwnum = ScanKeywordLookup(yytext,
											  yyextra->keywordlist);
					if (kwnum >= 0)
					{
						yylval->keyword = GetScanKeyword(kwnum,
														 yyextra->keywordlist);
						return yyextra->keyword_tokens[kwnum];
					}

					/*
					 * No.  Convert the identifier to lower case, and truncate
					 * if necessary.
					 */
					ident = downcase_truncate_identifier(yytext, yyleng, true);
					yylval->str = ident;
					return IDENT;
				}
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 1063 "scan.l"
{
					SET_YYLLOC();
					return yytext[0];
				}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
#line 1068 "scan.l"
{
					SET_YYLLOC();
					yyterminate();
				}
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 1073 "scan.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 10313 "scan.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( yywrap( yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = yyg->yytext_ptr;
	int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  , yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size , yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yy_start_state_list[yyg->yy_start];

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		yy_current_state += yy_current_state[(*yy_cp ? YY_SC_TO_UI(*yy_cp) : 256)].yy_nxt;
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */

	int yy_c = 256;
	const struct yy_trans_info *yy_trans_info;

	yy_trans_info = &yy_current_state[(unsigned int) yy_c];
	yy_current_state += yy_trans_info->yy_nxt;
	yy_is_jam = (yy_trans_info->yy_verify != yy_c);

	(void)yyg;
	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr);
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin , yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( yyscanner ) )
						return 0;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file , yyscanner);
	yy_load_buffer_state( yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void yy_load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file , yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * @param yyscanner The scanner object.
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf , yyscanner );

	yyfree( (void *) b , yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_flush_buffer( b , yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack(yyscanner);

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void yypop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER , yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (yyscan_t yyscanner)
{
	yy_size_t num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyrealloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b , yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr , yyscan_t yyscanner)
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) , yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n , yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n , yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE yyget_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int yyget_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int yyget_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int yyget_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *yyget_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void yyset_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param _line_number line number
 * @param yyscanner The scanner object.
 */
void yyset_lineno (int  _line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_lineno called with no buffer" );
    
    yylineno = _line_number;
}

/** Set the current column.
 * @param _column_no column number
 * @param yyscanner The scanner object.
 */
void yyset_column (int  _column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_column called with no buffer" );
    
    yycolumn = _column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = _in_str ;
}

void yyset_out (FILE *  _out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = _out_str ;
}

int yyget_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void yyset_debug (int  _bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = _bdebug ;
}

/* Accessor methods for yylval and yylloc */

YYSTYPE * yyget_lval  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylval;
}

void yyset_lval (YYSTYPE *  yylval_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylval = yylval_param;
}

YYLTYPE *yyget_lloc  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylloc;
}
    
void yyset_lloc (YYLTYPE *  yylloc_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylloc = yylloc_param;
}
    
/* User-visible API */

/* yylex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */
int yylex_init(yyscan_t* ptr_yy_globals)
{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* yylex_init_extra has the same functionality as yylex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to yyalloc in
 * the yyextra field.
 */
int yylex_init_extra( YY_EXTRA_TYPE yy_user_defined, yyscan_t* ptr_yy_globals )
{
    struct yyguts_t dummy_yyguts;

    yyset_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), &dummy_yyguts );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    yyset_extra (yy_user_defined, *ptr_yy_globals);

    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = NULL;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = NULL;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER , yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	yyfree(yyg->yy_buffer_stack , yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        yyfree( yyg->yy_start_stack , yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    yyfree ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;

	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s , yyscan_t yyscanner)
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

#define YYTABLES_NAME "yytables"

#line 1073 "scan.l"


/* LCOV_EXCL_STOP */

/*
 * Arrange access to yyextra for subroutines of the main yylex() function.
 * We expect each subroutine to have a yyscanner parameter.  Rather than
 * use the yyget_xxx functions, which might or might not get inlined by the
 * compiler, we cheat just a bit and cast yyscanner to the right type.
 */
#undef yyextra
#define yyextra  (((struct yyguts_t *) yyscanner)->yyextra_r)

/* Likewise for a couple of other things we need. */
#undef yylloc
#define yylloc	(((struct yyguts_t *) yyscanner)->yylloc_r)
#undef yyleng
#define yyleng	(((struct yyguts_t *) yyscanner)->yyleng_r)


/*
 * scanner_errposition
 *		Report a lexer or grammar error cursor position, if possible.
 *
 * This is expected to be used within an ereport() call.  The return value
 * is a dummy (always 0, in fact).
 *
 * Note that this can only be used for messages emitted during raw parsing
 * (essentially, scan.l and gram.y), since it requires the yyscanner struct
 * to still be available.
 */
int
scanner_errposition(int location, core_yyscan_t yyscanner)
{
	int			pos;

	if (location < 0)
		return 0;				/* no-op if location is unknown */

	/* Convert byte offset to character number */
	pos = pg_mbstrlen_with_len(yyextra->scanbuf, location) + 1;
	/* And pass it to the ereport mechanism */
	return errposition(pos);
}

/*
 * scanner_yyerror
 *		Report a lexer or grammar error.
 *
 * The message's cursor position is whatever YYLLOC was last set to,
 * ie, the start of the current token if called within yylex(), or the
 * most recently lexed token if called from the grammar.
 * This is OK for syntax error messages from the Bison parser, because Bison
 * parsers report error as soon as the first unparsable token is reached.
 * Beware of using yyerror for other purposes, as the cursor position might
 * be misleading!
 */
void
scanner_yyerror(const char *message, core_yyscan_t yyscanner)
{
	const char *loc = yyextra->scanbuf + *yylloc;

	if (*loc == YY_END_OF_BUFFER_CHAR)
	{
		ereport(ERROR,
				(errcode(ERRCODE_SYNTAX_ERROR),
		/* translator: %s is typically the translation of "syntax error" */
				 errmsg("%s at end of input", _(message)),
				 lexer_errposition()));
	}
	else
	{
		ereport(ERROR,
				(errcode(ERRCODE_SYNTAX_ERROR),
		/* translator: first %s is typically the translation of "syntax error" */
				 errmsg("%s at or near \"%s\"", _(message), loc),
				 lexer_errposition()));
	}
}


/*
 * Called before any actual parsing is done
 */
core_yyscan_t
scanner_init(const char *str,
			 core_yy_extra_type *yyext,
			 const ScanKeywordList *keywordlist,
			 const uint16 *keyword_tokens)
{
	Size		slen = strlen(str);
	yyscan_t	scanner;

	if (yylex_init(&scanner) != 0)
		elog(ERROR, "yylex_init() failed: %m");

	core_yyset_extra(yyext, scanner);

	yyext->keywordlist = keywordlist;
	yyext->keyword_tokens = keyword_tokens;

	yyext->backslash_quote = backslash_quote;
	yyext->escape_string_warning = escape_string_warning;
	yyext->standard_conforming_strings = standard_conforming_strings;

	/*
	 * Make a scan buffer with special termination needed by flex.
	 */
	yyext->scanbuf = (char *) palloc(slen + 2);
	yyext->scanbuflen = slen;
	memcpy(yyext->scanbuf, str, slen);
	yyext->scanbuf[slen] = yyext->scanbuf[slen + 1] = YY_END_OF_BUFFER_CHAR;
	yy_scan_buffer(yyext->scanbuf, slen + 2, scanner);

	/* initialize literal buffer to a reasonable but expansible size */
	yyext->literalalloc = 1024;
	yyext->literalbuf = (char *) palloc(yyext->literalalloc);
	yyext->literallen = 0;

	return scanner;
}


/*
 * Called after parsing is done to clean up after scanner_init()
 */
void
scanner_finish(core_yyscan_t yyscanner)
{
	/*
	 * We don't bother to call yylex_destroy(), because all it would do is
	 * pfree a small amount of control storage.  It's cheaper to leak the
	 * storage until the parsing context is destroyed.  The amount of space
	 * involved is usually negligible compared to the output parse tree
	 * anyway.
	 *
	 * We do bother to pfree the scanbuf and literal buffer, but only if they
	 * represent a nontrivial amount of space.  The 8K cutoff is arbitrary.
	 */
	if (yyextra->scanbuflen >= 8192)
		pfree(yyextra->scanbuf);
	if (yyextra->literalalloc >= 8192)
		pfree(yyextra->literalbuf);
}


static void
addlit(char *ytext, int yleng, core_yyscan_t yyscanner)
{
	/* enlarge buffer if needed */
	if ((yyextra->literallen + yleng) >= yyextra->literalalloc)
	{
		do
		{
			yyextra->literalalloc *= 2;
		} while ((yyextra->literallen + yleng) >= yyextra->literalalloc);
		yyextra->literalbuf = (char *) repalloc(yyextra->literalbuf,
												yyextra->literalalloc);
	}
	/* append new data */
	memcpy(yyextra->literalbuf + yyextra->literallen, ytext, yleng);
	yyextra->literallen += yleng;
}


static void
addlitchar(unsigned char ychar, core_yyscan_t yyscanner)
{
	/* enlarge buffer if needed */
	if ((yyextra->literallen + 1) >= yyextra->literalalloc)
	{
		yyextra->literalalloc *= 2;
		yyextra->literalbuf = (char *) repalloc(yyextra->literalbuf,
												yyextra->literalalloc);
	}
	/* append new data */
	yyextra->literalbuf[yyextra->literallen] = ychar;
	yyextra->literallen += 1;
}


/*
 * Create a palloc'd copy of literalbuf, adding a trailing null.
 */
static char *
litbufdup(core_yyscan_t yyscanner)
{
	int			llen = yyextra->literallen;
	char	   *new;

	new = palloc(llen + 1);
	memcpy(new, yyextra->literalbuf, llen);
	new[llen] = '\0';
	return new;
}

/*
 * Process {integer}.  Note this will also do the right thing with {decimal},
 * ie digits and a decimal point.
 */
static int
process_integer_literal(const char *token, YYSTYPE *lval)
{
	int			val;
	char	   *endptr;

	errno = 0;
	val = strtoint(token, &endptr, 10);
	if (*endptr != '\0' || errno == ERANGE)
	{
		/* integer too large (or contains decimal pt), treat it as a float */
		lval->str = pstrdup(token);
		return FCONST;
	}
	lval->ival = val;
	return ICONST;
}

static unsigned int
hexval(unsigned char c)
{
	if (c >= '0' && c <= '9')
		return c - '0';
	if (c >= 'a' && c <= 'f')
		return c - 'a' + 0xA;
	if (c >= 'A' && c <= 'F')
		return c - 'A' + 0xA;
	elog(ERROR, "invalid hexadecimal digit");
	return 0;					/* not reached */
}

static void
check_unicode_value(pg_wchar c, char *loc, core_yyscan_t yyscanner)
{
	if (GetDatabaseEncoding() == PG_UTF8)
		return;

	if (c > 0x7F)
	{
		ADVANCE_YYLLOC(loc - yyextra->literalbuf + 3);	/* 3 for U&" */
		yyerror("Unicode escape values cannot be used for code point values above 007F when the server encoding is not UTF8");
	}
}

static bool
is_utf16_surrogate_first(pg_wchar c)
{
	return (c >= 0xD800 && c <= 0xDBFF);
}

static bool
is_utf16_surrogate_second(pg_wchar c)
{
	return (c >= 0xDC00 && c <= 0xDFFF);
}

static pg_wchar
surrogate_pair_to_codepoint(pg_wchar first, pg_wchar second)
{
	return ((first & 0x3FF) << 10) + 0x10000 + (second & 0x3FF);
}

static void
addunicode(pg_wchar c, core_yyscan_t yyscanner)
{
	char		buf[8];

	if (c == 0 || c > 0x10FFFF)
		yyerror("invalid Unicode escape value");
	if (c > 0x7F)
	{
		if (GetDatabaseEncoding() != PG_UTF8)
			yyerror("Unicode escape values cannot be used for code point values above 007F when the server encoding is not UTF8");
		yyextra->saw_non_ascii = true;
	}
	unicode_to_utf8(c, (unsigned char *) buf);
	addlit(buf, pg_mblen(buf), yyscanner);
}

/* is 'escape' acceptable as Unicode escape character (UESCAPE syntax) ? */
static bool
check_uescapechar(unsigned char escape)
{
	if (isxdigit(escape)
		|| escape == '+'
		|| escape == '\''
		|| escape == '"'
		|| scanner_isspace(escape))
	{
		return false;
	}
	else
		return true;
}

/* like litbufdup, but handle unicode escapes */
static char *
litbuf_udeescape(unsigned char escape, core_yyscan_t yyscanner)
{
	char	   *new;
	char	   *litbuf,
			   *in,
			   *out;
	pg_wchar	pair_first = 0;

	/* Make literalbuf null-terminated to simplify the scanning loop */
	litbuf = yyextra->literalbuf;
	litbuf[yyextra->literallen] = '\0';

	/*
	 * This relies on the subtle assumption that a UTF-8 expansion cannot be
	 * longer than its escaped representation.
	 */
	new = palloc(yyextra->literallen + 1);

	in = litbuf;
	out = new;
	while (*in)
	{
		if (in[0] == escape)
		{
			if (in[1] == escape)
			{
				if (pair_first)
				{
					ADVANCE_YYLLOC(in - litbuf + 3);	/* 3 for U&" */
					yyerror("invalid Unicode surrogate pair");
				}
				*out++ = escape;
				in += 2;
			}
			else if (isxdigit((unsigned char) in[1]) &&
					 isxdigit((unsigned char) in[2]) &&
					 isxdigit((unsigned char) in[3]) &&
					 isxdigit((unsigned char) in[4]))
			{
				pg_wchar	unicode;

				unicode = (hexval(in[1]) << 12) +
					(hexval(in[2]) << 8) +
					(hexval(in[3]) << 4) +
					hexval(in[4]);
				check_unicode_value(unicode, in, yyscanner);
				if (pair_first)
				{
					if (is_utf16_surrogate_second(unicode))
					{
						unicode = surrogate_pair_to_codepoint(pair_first, unicode);
						pair_first = 0;
					}
					else
					{
						ADVANCE_YYLLOC(in - litbuf + 3);		/* 3 for U&" */
						yyerror("invalid Unicode surrogate pair");
					}
				}
				else if (is_utf16_surrogate_second(unicode))
					yyerror("invalid Unicode surrogate pair");

				if (is_utf16_surrogate_first(unicode))
					pair_first = unicode;
				else
				{
					unicode_to_utf8(unicode, (unsigned char *) out);
					out += pg_mblen(out);
				}
				in += 5;
			}
			else if (in[1] == '+' &&
					 isxdigit((unsigned char) in[2]) &&
					 isxdigit((unsigned char) in[3]) &&
					 isxdigit((unsigned char) in[4]) &&
					 isxdigit((unsigned char) in[5]) &&
					 isxdigit((unsigned char) in[6]) &&
					 isxdigit((unsigned char) in[7]))
			{
				pg_wchar	unicode;

				unicode = (hexval(in[2]) << 20) +
					(hexval(in[3]) << 16) +
					(hexval(in[4]) << 12) +
					(hexval(in[5]) << 8) +
					(hexval(in[6]) << 4) +
					hexval(in[7]);
				check_unicode_value(unicode, in, yyscanner);
				if (pair_first)
				{
					if (is_utf16_surrogate_second(unicode))
					{
						unicode = surrogate_pair_to_codepoint(pair_first, unicode);
						pair_first = 0;
					}
					else
					{
						ADVANCE_YYLLOC(in - litbuf + 3);		/* 3 for U&" */
						yyerror("invalid Unicode surrogate pair");
					}
				}
				else if (is_utf16_surrogate_second(unicode))
					yyerror("invalid Unicode surrogate pair");

				if (is_utf16_surrogate_first(unicode))
					pair_first = unicode;
				else
				{
					unicode_to_utf8(unicode, (unsigned char *) out);
					out += pg_mblen(out);
				}
				in += 8;
			}
			else
			{
				ADVANCE_YYLLOC(in - litbuf + 3);		/* 3 for U&" */
				yyerror("invalid Unicode escape value");
			}
		}
		else
		{
			if (pair_first)
			{
				ADVANCE_YYLLOC(in - litbuf + 3);		/* 3 for U&" */
				yyerror("invalid Unicode surrogate pair");
			}
			*out++ = *in++;
		}
	}

	/* unfinished surrogate pair? */
	if (pair_first)
	{
		ADVANCE_YYLLOC(in - litbuf + 3);				/* 3 for U&" */
		yyerror("invalid Unicode surrogate pair");
	}

	*out = '\0';

	/*
	 * We could skip pg_verifymbstr if we didn't process any non-7-bit-ASCII
	 * codes; but it's probably not worth the trouble, since this isn't likely
	 * to be a performance-critical path.
	 */
	pg_verifymbstr(new, out - new, false);
	return new;
}

static unsigned char
unescape_single_char(unsigned char c, core_yyscan_t yyscanner)
{
	switch (c)
	{
		case 'b':
			return '\b';
		case 'f':
			return '\f';
		case 'n':
			return '\n';
		case 'r':
			return '\r';
		case 't':
			return '\t';
		default:
			/* check for backslash followed by non-7-bit-ASCII */
			if (c == '\0' || IS_HIGHBIT_SET(c))
				yyextra->saw_non_ascii = true;

			return c;
	}
}

static void
check_string_escape_warning(unsigned char ychar, core_yyscan_t yyscanner)
{
	if (ychar == '\'')
	{
		if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
			ereport(WARNING,
					(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
					 errmsg("nonstandard use of \\' in a string literal"),
					 errhint("Use '' to write quotes in strings, or use the escape string syntax (E'...')."),
					 lexer_errposition()));
		yyextra->warn_on_first_escape = false;	/* warn only once per string */
	}
	else if (ychar == '\\')
	{
		if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
			ereport(WARNING,
					(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
					 errmsg("nonstandard use of \\\\ in a string literal"),
					 errhint("Use the escape string syntax for backslashes, e.g., E'\\\\'."),
					 lexer_errposition()));
		yyextra->warn_on_first_escape = false;	/* warn only once per string */
	}
	else
		check_escape_warning(yyscanner);
}

static void
check_escape_warning(core_yyscan_t yyscanner)
{
	if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
		ereport(WARNING,
				(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
				 errmsg("nonstandard use of escape in a string literal"),
		errhint("Use the escape string syntax for escapes, e.g., E'\\r\\n'."),
				 lexer_errposition()));
	yyextra->warn_on_first_escape = false;		/* warn only once per string */
}

/*
 * Interface functions to make flex use palloc() instead of malloc().
 * It'd be better to make these static, but flex insists otherwise.
 */

void *
core_yyalloc(yy_size_t bytes, core_yyscan_t yyscanner)
{
	return palloc(bytes);
}

void *
core_yyrealloc(void *ptr, yy_size_t bytes, core_yyscan_t yyscanner)
{
	if (ptr)
		return repalloc(ptr, bytes);
	else
		return palloc(bytes);
}

void
core_yyfree(void *ptr, core_yyscan_t yyscanner)
{
	if (ptr)
		pfree(ptr);
}

