/* -*- mode: C; c-basic-offset: 4; indent-tabs-mode: nil -*- */
/*
    pygpgme - a Python wrapper for the gpgme library
    Copyright (C) 2006  James Henstridge

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "pygpgme.h"

struct pygpgme_constant {
  const char name[28];
  long value;
};

#define CONST(name) { #name, GPGME_##name }

static const struct pygpgme_constant constants[] = {
  /* gpgme_data_encoding_t */
  CONST(DATA_ENCODING_NONE),
  CONST(DATA_ENCODING_BINARY),
  CONST(DATA_ENCODING_BASE64),
  CONST(DATA_ENCODING_ARMOR),

  /* gpgme_pubkey_algo_t */
  CONST(PK_RSA),
  CONST(PK_RSA_E),
  CONST(PK_RSA_S),
  CONST(PK_ELG_E),
  CONST(PK_DSA),
  CONST(PK_ELG),

  /* gpgme_hash_algo_t */
  CONST(MD_NONE),
  CONST(MD_MD5),
  CONST(MD_SHA1),
  CONST(MD_RMD160),
  CONST(MD_MD2),
  CONST(MD_TIGER),
  CONST(MD_HAVAL),
  CONST(MD_SHA256),
  CONST(MD_SHA384),
  CONST(MD_SHA512),
  CONST(MD_MD4),
  CONST(MD_CRC32),
  CONST(MD_CRC32_RFC1510),
  CONST(MD_CRC24_RFC2440),

  /* gpgme_sig_mode_t */
  CONST(SIG_MODE_NORMAL),
  CONST(SIG_MODE_DETACH),
  CONST(SIG_MODE_CLEAR),

  /* gpgme_validity_t */
  CONST(VALIDITY_UNKNOWN),
  CONST(VALIDITY_UNDEFINED),
  CONST(VALIDITY_NEVER),
  CONST(VALIDITY_MARGINAL),
  CONST(VALIDITY_FULL),
  CONST(VALIDITY_ULTIMATE),

  /* gpgme_protocol_t */
  CONST(PROTOCOL_OpenPGP),
  CONST(PROTOCOL_CMS),

  /* gpgme_keylist_mode_t */
  CONST(KEYLIST_MODE_LOCAL),
  CONST(KEYLIST_MODE_EXTERN),
  CONST(KEYLIST_MODE_SIGS),
  CONST(KEYLIST_MODE_VALIDATE),

  /* gpgme_status_code_t */
  CONST(STATUS_EOF),
  CONST(STATUS_ENTER),
  CONST(STATUS_LEAVE),
  CONST(STATUS_ABORT),
  CONST(STATUS_GOODSIG),
  CONST(STATUS_BADSIG),
  CONST(STATUS_ERRSIG),
  CONST(STATUS_BADARMOR),
  CONST(STATUS_RSA_OR_IDEA),
  CONST(STATUS_KEYEXPIRED),
  CONST(STATUS_KEYREVOKED),
  CONST(STATUS_TRUST_UNDEFINED),
  CONST(STATUS_TRUST_NEVER),
  CONST(STATUS_TRUST_MARGINAL),
  CONST(STATUS_TRUST_FULLY),
  CONST(STATUS_TRUST_ULTIMATE),
  CONST(STATUS_SHM_INFO),
  CONST(STATUS_SHM_GET),
  CONST(STATUS_SHM_GET_BOOL),
  CONST(STATUS_SHM_GET_HIDDEN),
  CONST(STATUS_NEED_PASSPHRASE),
  CONST(STATUS_VALIDSIG),
  CONST(STATUS_SIG_ID),
  CONST(STATUS_ENC_TO),
  CONST(STATUS_NODATA),
  CONST(STATUS_BAD_PASSPHRASE),
  CONST(STATUS_NO_PUBKEY),
  CONST(STATUS_NO_SECKEY),
  CONST(STATUS_NEED_PASSPHRASE_SYM),
  CONST(STATUS_DECRYPTION_FAILED),
  CONST(STATUS_DECRYPTION_OKAY),
  CONST(STATUS_MISSING_PASSPHRASE),
  CONST(STATUS_GOOD_PASSPHRASE),
  CONST(STATUS_GOODMDC),
  CONST(STATUS_BADMDC),
  CONST(STATUS_ERRMDC),
  CONST(STATUS_IMPORTED),
  CONST(STATUS_IMPORT_OK),
  CONST(STATUS_IMPORT_PROBLEM),
  CONST(STATUS_IMPORT_RES),
  CONST(STATUS_FILE_START),
  CONST(STATUS_FILE_DONE),
  CONST(STATUS_FILE_ERROR),
  CONST(STATUS_BEGIN_DECRYPTION),
  CONST(STATUS_END_DECRYPTION),
  CONST(STATUS_BEGIN_ENCRYPTION),
  CONST(STATUS_END_ENCRYPTION),
  CONST(STATUS_DELETE_PROBLEM),
  CONST(STATUS_GET_BOOL),
  CONST(STATUS_GET_LINE),
  CONST(STATUS_GET_HIDDEN),
  CONST(STATUS_GOT_IT),
  CONST(STATUS_PROGRESS),
  CONST(STATUS_SIG_CREATED),
  CONST(STATUS_SESSION_KEY),
  CONST(STATUS_NOTATION_NAME),
  CONST(STATUS_NOTATION_DATA),
  CONST(STATUS_POLICY_URL),
  CONST(STATUS_BEGIN_STREAM),
  CONST(STATUS_END_STREAM),
  CONST(STATUS_KEY_CREATED),
  CONST(STATUS_USERID_HINT),
  CONST(STATUS_UNEXPECTED),
  CONST(STATUS_INV_RECP),
  CONST(STATUS_NO_RECP),
  CONST(STATUS_ALREADY_SIGNED),
  CONST(STATUS_SIGEXPIRED),
  CONST(STATUS_EXPSIG),
  CONST(STATUS_EXPKEYSIG),
  CONST(STATUS_TRUNCATED),
  CONST(STATUS_ERROR),
  CONST(STATUS_NEWSIG),
  CONST(STATUS_REVKEYSIG),

  /* gpgme_encrypt_flags_t */
  CONST(ENCRYPT_ALWAYS_TRUST),

  /* gpgme_sigsum_t */
  CONST(SIGSUM_VALID),
  CONST(SIGSUM_GREEN),
  CONST(SIGSUM_RED),
  CONST(SIGSUM_KEY_REVOKED),
  CONST(SIGSUM_KEY_EXPIRED),
  CONST(SIGSUM_SIG_EXPIRED),
  CONST(SIGSUM_KEY_MISSING),
  CONST(SIGSUM_CRL_MISSING),
  CONST(SIGSUM_CRL_TOO_OLD),
  CONST(SIGSUM_BAD_POLICY),
  CONST(SIGSUM_SYS_ERROR),

  /* import status */
  CONST(IMPORT_NEW),
  CONST(IMPORT_UID),
  CONST(IMPORT_SIG),
  CONST(IMPORT_SUBKEY),
  CONST(IMPORT_SECRET),

  /* gpg-error.h constants */
#undef CONST
#define CONST(name) { #name, GPG_##name }
  CONST(ERR_SOURCE_UNKNOWN),
  CONST(ERR_SOURCE_GCRYPT),
  CONST(ERR_SOURCE_GPG),
  CONST(ERR_SOURCE_GPGSM),
  CONST(ERR_SOURCE_GPGAGENT),
  CONST(ERR_SOURCE_PINENTRY),
  CONST(ERR_SOURCE_SCD),
  CONST(ERR_SOURCE_GPGME),
  CONST(ERR_SOURCE_KEYBOX),
  CONST(ERR_SOURCE_KSBA),
  CONST(ERR_SOURCE_DIRMNGR),
  CONST(ERR_SOURCE_GSTI),
  CONST(ERR_SOURCE_USER_1),
  CONST(ERR_SOURCE_USER_2),
  CONST(ERR_SOURCE_USER_3),
  CONST(ERR_SOURCE_USER_4),

  CONST(ERR_NO_ERROR),
  CONST(ERR_GENERAL),
  CONST(ERR_UNKNOWN_PACKET),
  CONST(ERR_UNKNOWN_VERSION),
  CONST(ERR_PUBKEY_ALGO),
  CONST(ERR_DIGEST_ALGO),
  CONST(ERR_BAD_PUBKEY),
  CONST(ERR_BAD_SECKEY),
  CONST(ERR_BAD_SIGNATURE),
  CONST(ERR_NO_PUBKEY),
  CONST(ERR_CHECKSUM),
  CONST(ERR_BAD_PASSPHRASE),
  CONST(ERR_CIPHER_ALGO),
  CONST(ERR_KEYRING_OPEN),
  CONST(ERR_INV_PACKET),
  CONST(ERR_INV_ARMOR),
  CONST(ERR_NO_USER_ID),
  CONST(ERR_NO_SECKEY),
  CONST(ERR_WRONG_SECKEY),
  CONST(ERR_BAD_KEY),
  CONST(ERR_COMPR_ALGO),
  CONST(ERR_NO_PRIME),
  CONST(ERR_NO_ENCODING_METHOD),
  CONST(ERR_NO_ENCRYPTION_SCHEME),
  CONST(ERR_NO_SIGNATURE_SCHEME),
  CONST(ERR_INV_ATTR),
  CONST(ERR_NO_VALUE),
  CONST(ERR_NOT_FOUND),
  CONST(ERR_VALUE_NOT_FOUND),
  CONST(ERR_SYNTAX),
  CONST(ERR_BAD_MPI),
  CONST(ERR_INV_PASSPHRASE),
  CONST(ERR_SIG_CLASS),
  CONST(ERR_RESOURCE_LIMIT),
  CONST(ERR_INV_KEYRING),
  CONST(ERR_TRUSTDB),
  CONST(ERR_BAD_CERT),
  CONST(ERR_INV_USER_ID),
  CONST(ERR_UNEXPECTED),
  CONST(ERR_TIME_CONFLICT),
  CONST(ERR_KEYSERVER),
  CONST(ERR_WRONG_PUBKEY_ALGO),
  CONST(ERR_TRIBUTE_TO_D_A),
  CONST(ERR_WEAK_KEY),
  CONST(ERR_INV_KEYLEN),
  CONST(ERR_INV_ARG),
  CONST(ERR_BAD_URI),
  CONST(ERR_INV_URI),
  CONST(ERR_NETWORK),
  CONST(ERR_UNKNOWN_HOST),
  CONST(ERR_SELFTEST_FAILED),
  CONST(ERR_NOT_ENCRYPTED),
  CONST(ERR_NOT_PROCESSED),
  CONST(ERR_UNUSABLE_PUBKEY),
  CONST(ERR_UNUSABLE_SECKEY),
  CONST(ERR_INV_VALUE),
  CONST(ERR_BAD_CERT_CHAIN),
  CONST(ERR_MISSING_CERT),
  CONST(ERR_NO_DATA),
  CONST(ERR_BUG),
  CONST(ERR_NOT_SUPPORTED),
  CONST(ERR_INV_OP),
  CONST(ERR_TIMEOUT),
  CONST(ERR_INTERNAL),
  CONST(ERR_EOF_GCRYPT),
  CONST(ERR_INV_OBJ),
  CONST(ERR_TOO_SHORT),
  CONST(ERR_TOO_LARGE),
  CONST(ERR_NO_OBJ),
  CONST(ERR_NOT_IMPLEMENTED),
  CONST(ERR_CONFLICT),
  CONST(ERR_INV_CIPHER_MODE),
  CONST(ERR_INV_FLAG),
  CONST(ERR_INV_HANDLE),
  CONST(ERR_TRUNCATED),
  CONST(ERR_INCOMPLETE_LINE),
  CONST(ERR_INV_RESPONSE),
  CONST(ERR_NO_AGENT),
  CONST(ERR_AGENT),
  CONST(ERR_INV_DATA),
  CONST(ERR_ASSUAN_SERVER_FAULT),
  CONST(ERR_ASSUAN),
  CONST(ERR_INV_SESSION_KEY),
  CONST(ERR_INV_SEXP),
  CONST(ERR_UNSUPPORTED_ALGORITHM),
  CONST(ERR_NO_PIN_ENTRY),
  CONST(ERR_PIN_ENTRY),
  CONST(ERR_BAD_PIN),
  CONST(ERR_INV_NAME),
  CONST(ERR_BAD_DATA),
  CONST(ERR_INV_PARAMETER),
  CONST(ERR_WRONG_CARD),
  CONST(ERR_NO_DIRMNGR),
  CONST(ERR_DIRMNGR),
  CONST(ERR_CERT_REVOKED),
  CONST(ERR_NO_CRL_KNOWN),
  CONST(ERR_CRL_TOO_OLD),
  CONST(ERR_LINE_TOO_LONG),
  CONST(ERR_NOT_TRUSTED),
  CONST(ERR_CANCELED),
  CONST(ERR_BAD_CA_CERT),
  CONST(ERR_CERT_EXPIRED),
  CONST(ERR_CERT_TOO_YOUNG),
  CONST(ERR_UNSUPPORTED_CERT),
  CONST(ERR_UNKNOWN_SEXP),
  CONST(ERR_UNSUPPORTED_PROTECTION),
  CONST(ERR_CORRUPTED_PROTECTION),
  CONST(ERR_AMBIGUOUS_NAME),
  CONST(ERR_CARD),
  CONST(ERR_CARD_RESET),
  CONST(ERR_CARD_REMOVED),
  CONST(ERR_INV_CARD),
  CONST(ERR_CARD_NOT_PRESENT),
  CONST(ERR_NO_PKCS15_APP),
  CONST(ERR_NOT_CONFIRMED),
  CONST(ERR_CONFIGURATION),
  CONST(ERR_NO_POLICY_MATCH),
  CONST(ERR_INV_INDEX),
  CONST(ERR_INV_ID),
  CONST(ERR_NO_SCDAEMON),
  CONST(ERR_SCDAEMON),
  CONST(ERR_UNSUPPORTED_PROTOCOL),
  CONST(ERR_BAD_PIN_METHOD),
  CONST(ERR_CARD_NOT_INITIALIZED),
  CONST(ERR_UNSUPPORTED_OPERATION),
  CONST(ERR_WRONG_KEY_USAGE),
  CONST(ERR_NOTHING_FOUND),
  CONST(ERR_WRONG_BLOB_TYPE),
  CONST(ERR_MISSING_VALUE),
  CONST(ERR_HARDWARE),
  CONST(ERR_PIN_BLOCKED),
  CONST(ERR_USE_CONDITIONS),
  CONST(ERR_PIN_NOT_SYNCED),
  CONST(ERR_INV_CRL),
  CONST(ERR_BAD_BER),
  CONST(ERR_INV_BER),
  CONST(ERR_ELEMENT_NOT_FOUND),
  CONST(ERR_IDENTIFIER_NOT_FOUND),
  CONST(ERR_INV_TAG),
  CONST(ERR_INV_LENGTH),
  CONST(ERR_INV_KEYINFO),
  CONST(ERR_UNEXPECTED_TAG),
  CONST(ERR_NOT_DER_ENCODED),
  CONST(ERR_NO_CMS_OBJ),
  CONST(ERR_INV_CMS_OBJ),
  CONST(ERR_UNKNOWN_CMS_OBJ),
  CONST(ERR_UNSUPPORTED_CMS_OBJ),
  CONST(ERR_UNSUPPORTED_ENCODING),
  CONST(ERR_UNSUPPORTED_CMS_VERSION),
  CONST(ERR_UNKNOWN_ALGORITHM),
  CONST(ERR_INV_ENGINE),
  CONST(ERR_PUBKEY_NOT_TRUSTED),
  CONST(ERR_DECRYPT_FAILED),
  CONST(ERR_KEY_EXPIRED),
  CONST(ERR_SIG_EXPIRED),
  CONST(ERR_ENCODING_PROBLEM),
  CONST(ERR_INV_STATE),
  CONST(ERR_DUP_VALUE),
  CONST(ERR_MISSING_ACTION),
  CONST(ERR_MODULE_NOT_FOUND),
  CONST(ERR_INV_OID_STRING),
  CONST(ERR_INV_TIME),
  CONST(ERR_INV_CRL_OBJ),
  CONST(ERR_UNSUPPORTED_CRL_VERSION),
  CONST(ERR_INV_CERT_OBJ),
  CONST(ERR_UNKNOWN_NAME),
  CONST(ERR_LOCALE_PROBLEM),
  CONST(ERR_NOT_LOCKED),
  CONST(ERR_PROTOCOL_VIOLATION),
  CONST(ERR_INV_MAC),
  CONST(ERR_INV_REQUEST),
  CONST(ERR_BUFFER_TOO_SHORT),
  CONST(ERR_SEXP_INV_LEN_SPEC),
  CONST(ERR_SEXP_STRING_TOO_LONG),
  CONST(ERR_SEXP_UNMATCHED_PAREN),
  CONST(ERR_SEXP_NOT_CANONICAL),
  CONST(ERR_SEXP_BAD_CHARACTER),
  CONST(ERR_SEXP_BAD_QUOTATION),
  CONST(ERR_SEXP_ZERO_PREFIX),
  CONST(ERR_SEXP_NESTED_DH),
  CONST(ERR_SEXP_UNMATCHED_DH),
  CONST(ERR_SEXP_UNEXPECTED_PUNC),
  CONST(ERR_SEXP_BAD_HEX_CHAR),
  CONST(ERR_SEXP_ODD_HEX_NUMBERS),
  CONST(ERR_SEXP_BAD_OCT_CHAR),
  CONST(ERR_USER_1),
  CONST(ERR_USER_2),
  CONST(ERR_USER_3),
  CONST(ERR_USER_4),
  CONST(ERR_USER_5),
  CONST(ERR_USER_6),
  CONST(ERR_USER_7),
  CONST(ERR_USER_8),
  CONST(ERR_USER_9),
  CONST(ERR_USER_10),
  CONST(ERR_USER_11),
  CONST(ERR_USER_12),
  CONST(ERR_USER_13),
  CONST(ERR_USER_14),
  CONST(ERR_USER_15),
  CONST(ERR_USER_16),
  CONST(ERR_UNKNOWN_ERRNO),
  CONST(ERR_EOF),
  CONST(ERR_E2BIG),
  CONST(ERR_EACCES),
  CONST(ERR_EADDRINUSE),
  CONST(ERR_EADDRNOTAVAIL),
  CONST(ERR_EADV),
  CONST(ERR_EAFNOSUPPORT),
  CONST(ERR_EAGAIN),
  CONST(ERR_EALREADY),
  CONST(ERR_EAUTH),
  CONST(ERR_EBACKGROUND),
  CONST(ERR_EBADE),
  CONST(ERR_EBADF),
  CONST(ERR_EBADFD),
  CONST(ERR_EBADMSG),
  CONST(ERR_EBADR),
  CONST(ERR_EBADRPC),
  CONST(ERR_EBADRQC),
  CONST(ERR_EBADSLT),
  CONST(ERR_EBFONT),
  CONST(ERR_EBUSY),
  CONST(ERR_ECANCELED),
  CONST(ERR_ECHILD),
  CONST(ERR_ECHRNG),
  CONST(ERR_ECOMM),
  CONST(ERR_ECONNABORTED),
  CONST(ERR_ECONNREFUSED),
  CONST(ERR_ECONNRESET),
  CONST(ERR_ED),
  CONST(ERR_EDEADLK),
  CONST(ERR_EDEADLOCK),
  CONST(ERR_EDESTADDRREQ),
  CONST(ERR_EDIED),
  CONST(ERR_EDOM),
  CONST(ERR_EDOTDOT),
  CONST(ERR_EDQUOT),
  CONST(ERR_EEXIST),
  CONST(ERR_EFAULT),
  CONST(ERR_EFBIG),
  CONST(ERR_EFTYPE),
  CONST(ERR_EGRATUITOUS),
  CONST(ERR_EGREGIOUS),
  CONST(ERR_EHOSTDOWN),
  CONST(ERR_EHOSTUNREACH),
  CONST(ERR_EIDRM),
  CONST(ERR_EIEIO),
  CONST(ERR_EILSEQ),
  CONST(ERR_EINPROGRESS),
  CONST(ERR_EINTR),
  CONST(ERR_EINVAL),
  CONST(ERR_EIO),
  CONST(ERR_EISCONN),
  CONST(ERR_EISDIR),
  CONST(ERR_EISNAM),
  CONST(ERR_EL2HLT),
  CONST(ERR_EL2NSYNC),
  CONST(ERR_EL3HLT),
  CONST(ERR_EL3RST),
  CONST(ERR_ELIBACC),
  CONST(ERR_ELIBBAD),
  CONST(ERR_ELIBEXEC),
  CONST(ERR_ELIBMAX),
  CONST(ERR_ELIBSCN),
  CONST(ERR_ELNRNG),
  CONST(ERR_ELOOP),
  CONST(ERR_EMEDIUMTYPE),
  CONST(ERR_EMFILE),
  CONST(ERR_EMLINK),
  CONST(ERR_EMSGSIZE),
  CONST(ERR_EMULTIHOP),
  CONST(ERR_ENAMETOOLONG),
  CONST(ERR_ENAVAIL),
  CONST(ERR_ENEEDAUTH),
  CONST(ERR_ENETDOWN),
  CONST(ERR_ENETRESET),
  CONST(ERR_ENETUNREACH),
  CONST(ERR_ENFILE),
  CONST(ERR_ENOANO),
  CONST(ERR_ENOBUFS),
  CONST(ERR_ENOCSI),
  CONST(ERR_ENODATA),
  CONST(ERR_ENODEV),
  CONST(ERR_ENOENT),
  CONST(ERR_ENOEXEC),
  CONST(ERR_ENOLCK),
  CONST(ERR_ENOLINK),
  CONST(ERR_ENOMEDIUM),
  CONST(ERR_ENOMEM),
  CONST(ERR_ENOMSG),
  CONST(ERR_ENONET),
  CONST(ERR_ENOPKG),
  CONST(ERR_ENOPROTOOPT),
  CONST(ERR_ENOSPC),
  CONST(ERR_ENOSR),
  CONST(ERR_ENOSTR),
  CONST(ERR_ENOSYS),
  CONST(ERR_ENOTBLK),
  CONST(ERR_ENOTCONN),
  CONST(ERR_ENOTDIR),
  CONST(ERR_ENOTEMPTY),
  CONST(ERR_ENOTNAM),
  CONST(ERR_ENOTSOCK),
  CONST(ERR_ENOTSUP),
  CONST(ERR_ENOTTY),
  CONST(ERR_ENOTUNIQ),
  CONST(ERR_ENXIO),
  CONST(ERR_EOPNOTSUPP),
  CONST(ERR_EOVERFLOW),
  CONST(ERR_EPERM),
  CONST(ERR_EPFNOSUPPORT),
  CONST(ERR_EPIPE),
  CONST(ERR_EPROCLIM),
  CONST(ERR_EPROCUNAVAIL),
  CONST(ERR_EPROGMISMATCH),
  CONST(ERR_EPROGUNAVAIL),
  CONST(ERR_EPROTO),
  CONST(ERR_EPROTONOSUPPORT),
  CONST(ERR_EPROTOTYPE),
  CONST(ERR_ERANGE),
  CONST(ERR_EREMCHG),
  CONST(ERR_EREMOTE),
  CONST(ERR_EREMOTEIO),
  CONST(ERR_ERESTART),
  CONST(ERR_EROFS),
  CONST(ERR_ERPCMISMATCH),
  CONST(ERR_ESHUTDOWN),
  CONST(ERR_ESOCKTNOSUPPORT),
  CONST(ERR_ESPIPE),
  CONST(ERR_ESRCH),
  CONST(ERR_ESRMNT),
  CONST(ERR_ESTALE),
  CONST(ERR_ESTRPIPE),
  CONST(ERR_ETIME),
  CONST(ERR_ETIMEDOUT),
  CONST(ERR_ETOOMANYREFS),
  CONST(ERR_ETXTBSY),
  CONST(ERR_EUCLEAN),
  CONST(ERR_EUNATCH),
  CONST(ERR_EUSERS),
  CONST(ERR_EWOULDBLOCK),
  CONST(ERR_EXDEV),
  CONST(ERR_EXFULL),
};

static const int n_constants = sizeof(constants) / sizeof(constants[0]);

PyObject *
pygpgme_make_constants(PyObject *self, PyObject *args)
{
    PyObject *dict;
    int i;

    if (!PyArg_ParseTuple(args, "O!", &PyDict_Type, &dict))
        return NULL;

    for (i = 0; i < n_constants; i++) {
        PyObject *item;

        item = PyInt_FromLong(constants[i].value);
        PyDict_SetItemString(dict, constants[i].name, item);
        Py_DECREF(item);
    }
    Py_RETURN_NONE;
}
