# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

from openstack import resource


class QoSRuleType(resource.Resource):
    resource_key = 'rule_type'
    resources_key = 'rule_types'
    base_path = '/qos/rule-types'

    _allow_unknown_attrs_in_body = True

    # capabilities
    allow_create = False
    allow_fetch = True
    allow_commit = False
    allow_delete = False
    allow_list = True

    _query_mapping = resource.QueryParameters('type', 'drivers')

    # Properties
    #: QoS rule type name.
    type = resource.Body('type', alternate_id=True)
    #: List of QoS backend drivers supporting this QoS rule type
    drivers = resource.Body('drivers')
