/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include "config.h"
#include "V8TestObj.h"

#include "BindingState.h"
#include "ContextFeatures.h"
#include "DOMStringList.h"
#include "Dictionary.h"
#include "ExceptionCode.h"
#include "FeatureObserver.h"
#include "Frame.h"
#include "HTMLNames.h"
#include "IDBBindingUtilities.h"
#include "IDBKey.h"
#include "RuntimeEnabledFeatures.h"
#include "SVGPropertyTearOff.h"
#include "SVGStaticPropertyTearOff.h"
#include "ScriptArguments.h"
#include "ScriptCallStackFactory.h"
#include "ScriptProfile.h"
#include "ScriptValue.h"
#include "SerializedScriptValue.h"
#include "V8Binding.h"
#include "V8DOMStringList.h"
#include "V8DOMWrapper.h"
#include "V8Document.h"
#include "V8Float32Array.h"
#include "V8Node.h"
#include "V8SVGDocument.h"
#include "V8SVGPoint.h"
#include "V8ScriptProfile.h"
#include "V8TestCallback.h"
#include "V8TestSubObj.h"
#include "V8a.h"
#include "V8b.h"
#include "V8bool.h"
#include "V8d.h"
#include "V8e.h"
#include <wtf/Float32Array.h>
#include <wtf/GetPtr.h>
#include <wtf/RefCounted.h>
#include <wtf/RefPtr.h>
#include <wtf/UnusedParam.h>

#if ENABLE(Condition1)
#include "V8TestObjectA.h"
#endif

#if ENABLE(Condition1) && ENABLE(Condition2)
#include "V8TestObjectB.h"
#endif

#if ENABLE(Condition1) || ENABLE(Condition2)
#include "V8TestObjectC.h"
#endif

namespace WebCore {

WrapperTypeInfo V8TestObj::info = { V8TestObj::GetTemplate, V8TestObj::derefObject, 0, 0, V8TestObj::installPerContextPrototypeProperties, 0, WrapperTypeObjectPrototype };

namespace TestObjV8Internal {

template <typename T> void V8_USE(T) { }

static v8::Handle<v8::Value> readOnlyLongAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.readOnlyLongAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->readOnlyLongAttr(), info.GetIsolate());
}

static v8::Handle<v8::Value> readOnlyStringAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.readOnlyStringAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->readOnlyStringAttr(), info.GetIsolate());
}

static v8::Handle<v8::Value> readOnlyTestObjAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.readOnlyTestObjAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    RefPtr<TestObj> result = imp->readOnlyTestObjAttr();
    v8::Handle<v8::Value> wrapper = result.get() ? v8::Handle<v8::Value>(DOMDataStore::current(info.GetIsolate())->get(result.get())) : v8Undefined();
    if (wrapper.IsEmpty()) {
        wrapper = toV8(result.get(), info.Holder(), info.GetIsolate());
        if (!wrapper.IsEmpty())
            V8DOMWrapper::setNamedHiddenReference(info.Holder(), "readOnlyTestObjAttr", wrapper);
    }
    return wrapper;
}

static v8::Handle<v8::Value> staticReadOnlyLongAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.staticReadOnlyLongAttr._get");
    return v8Integer(TestObj::staticReadOnlyLongAttr(), info.GetIsolate());
}

static v8::Handle<v8::Value> staticStringAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.staticStringAttr._get");
    return v8String(TestObj::staticStringAttr(), info.GetIsolate());
}

static void staticStringAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.staticStringAttr._set");
    V8TRYCATCH_FOR_V8STRINGRESOURCE_VOID(V8StringResource<>, v, value);
    TestObj::setStaticStringAttr(v);
    return;
}

static v8::Handle<v8::Value> shortAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.shortAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->shortAttr(), info.GetIsolate());
}

static void shortAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.shortAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setShortAttr(v);
    return;
}

static v8::Handle<v8::Value> unsignedShortAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.unsignedShortAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->unsignedShortAttr(), info.GetIsolate());
}

static void unsignedShortAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.unsignedShortAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toUInt32(value);
    imp->setUnsignedShortAttr(v);
    return;
}

static v8::Handle<v8::Value> longAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.longAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->longAttr(), info.GetIsolate());
}

static void longAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.longAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setLongAttr(v);
    return;
}

static v8::Handle<v8::Value> longLongAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.longLongAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Number::New(static_cast<double>(imp->longLongAttr()));
}

static void longLongAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.longLongAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    long long v = toInt64(value);
    imp->setLongLongAttr(WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> unsignedLongLongAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.unsignedLongLongAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Number::New(static_cast<double>(imp->unsignedLongLongAttr()));
}

static void unsignedLongLongAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.unsignedLongLongAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    unsigned long long v = toInt64(value);
    imp->setUnsignedLongLongAttr(WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> stringAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.stringAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->stringAttr(), info.GetIsolate());
}

static void stringAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.stringAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE_VOID(V8StringResource<>, v, value);
    imp->setStringAttr(v);
    return;
}

static v8::Handle<v8::Value> testObjAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.testObjAttr._get");
    FeatureObserver::observe(activeDOMWindow(BindingState::instance()), FeatureObserver::TestFeature);
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return toV8(imp->testObjAttr(), info.Holder(), info.GetIsolate());
}

static void testObjAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.testObjAttr._set");
    FeatureObserver::observe(activeDOMWindow(BindingState::instance()), FeatureObserver::TestFeature);
    TestObj* imp = V8TestObj::toNative(info.Holder());
    TestObj* v = V8TestObj::HasInstance(value) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    imp->setTestObjAttr(WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> XMLObjAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.XMLObjAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return toV8(imp->xmlObjAttr(), info.Holder(), info.GetIsolate());
}

static void XMLObjAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.XMLObjAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    TestObj* v = V8TestObj::HasInstance(value) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    imp->setXMLObjAttr(WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> createAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.create._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Boolean(imp->isCreate(), info.GetIsolate());
}

static void createAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.create._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    bool v = value->BooleanValue();
    imp->setCreate(v);
    return;
}

static v8::Handle<v8::Value> reflectedStringAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedStringAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->getAttribute(WebCore::HTMLNames::reflectedstringattrAttr), info.GetIsolate());
}

static void reflectedStringAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedStringAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE_VOID(V8StringResource<WithNullCheck>, v, value);
    imp->setAttribute(WebCore::HTMLNames::reflectedstringattrAttr, v);
    return;
}

static v8::Handle<v8::Value> reflectedIntegralAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedIntegralAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->getIntegralAttribute(WebCore::HTMLNames::reflectedintegralattrAttr), info.GetIsolate());
}

static void reflectedIntegralAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedIntegralAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setIntegralAttribute(WebCore::HTMLNames::reflectedintegralattrAttr, v);
    return;
}

static v8::Handle<v8::Value> reflectedUnsignedIntegralAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedUnsignedIntegralAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8UnsignedInteger(std::max(0, imp->getIntegralAttribute(WebCore::HTMLNames::reflectedunsignedintegralattrAttr)), info.GetIsolate());
}

static void reflectedUnsignedIntegralAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedUnsignedIntegralAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    unsigned v = toUInt32(value);
    imp->setUnsignedIntegralAttribute(WebCore::HTMLNames::reflectedunsignedintegralattrAttr, v);
    return;
}

static v8::Handle<v8::Value> reflectedBooleanAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedBooleanAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Boolean(imp->hasAttribute(WebCore::HTMLNames::reflectedbooleanattrAttr), info.GetIsolate());
}

static void reflectedBooleanAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedBooleanAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    bool v = value->BooleanValue();
    imp->setBooleanAttribute(WebCore::HTMLNames::reflectedbooleanattrAttr, v);
    return;
}

static v8::Handle<v8::Value> reflectedURLAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedURLAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->getURLAttribute(WebCore::HTMLNames::reflectedurlattrAttr), info.GetIsolate());
}

static void reflectedURLAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedURLAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE_VOID(V8StringResource<WithNullCheck>, v, value);
    imp->setAttribute(WebCore::HTMLNames::reflectedurlattrAttr, v);
    return;
}

static v8::Handle<v8::Value> reflectedStringAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedStringAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->getAttribute(WebCore::HTMLNames::customContentStringAttrAttr), info.GetIsolate());
}

static void reflectedStringAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedStringAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE_VOID(V8StringResource<WithNullCheck>, v, value);
    imp->setAttribute(WebCore::HTMLNames::customContentStringAttrAttr, v);
    return;
}

static v8::Handle<v8::Value> reflectedCustomIntegralAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedCustomIntegralAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->getIntegralAttribute(WebCore::HTMLNames::customContentIntegralAttrAttr), info.GetIsolate());
}

static void reflectedCustomIntegralAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedCustomIntegralAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setIntegralAttribute(WebCore::HTMLNames::customContentIntegralAttrAttr, v);
    return;
}

static v8::Handle<v8::Value> reflectedCustomBooleanAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedCustomBooleanAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Boolean(imp->hasAttribute(WebCore::HTMLNames::customContentBooleanAttrAttr), info.GetIsolate());
}

static void reflectedCustomBooleanAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedCustomBooleanAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    bool v = value->BooleanValue();
    imp->setBooleanAttribute(WebCore::HTMLNames::customContentBooleanAttrAttr, v);
    return;
}

static v8::Handle<v8::Value> reflectedCustomURLAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedCustomURLAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->getURLAttribute(WebCore::HTMLNames::customContentURLAttrAttr), info.GetIsolate());
}

static void reflectedCustomURLAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedCustomURLAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE_VOID(V8StringResource<WithNullCheck>, v, value);
    imp->setAttribute(WebCore::HTMLNames::customContentURLAttrAttr, v);
    return;
}

static v8::Handle<v8::Value> typedArrayAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.typedArrayAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return toV8(imp->typedArrayAttr(), info.Holder(), info.GetIsolate());
}

static void typedArrayAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.typedArrayAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    Float32Array* v = V8Float32Array::HasInstance(value) ? V8Float32Array::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    imp->setTypedArrayAttr(WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> attrWithGetterExceptionAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.attrWithGetterException._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ExceptionCode ec = 0;
    int v = imp->attrWithGetterException(ec);
    if (UNLIKELY(ec))
        return setDOMException(ec, info.GetIsolate());
    return v8Integer(v, info.GetIsolate());
}

static void attrWithGetterExceptionAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.attrWithGetterException._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setAttrWithGetterException(v);
    return;
}

static v8::Handle<v8::Value> attrWithSetterExceptionAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.attrWithSetterException._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->attrWithSetterException(), info.GetIsolate());
}

static void attrWithSetterExceptionAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.attrWithSetterException._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    ExceptionCode ec = 0;
    imp->setAttrWithSetterException(v, ec);
    if (UNLIKELY(ec))
        setDOMException(ec, info.GetIsolate());
    return;
}

static v8::Handle<v8::Value> stringAttrWithGetterExceptionAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.stringAttrWithGetterException._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ExceptionCode ec = 0;
    String v = imp->stringAttrWithGetterException(ec);
    if (UNLIKELY(ec))
        return setDOMException(ec, info.GetIsolate());
    return v8String(v, info.GetIsolate());
}

static void stringAttrWithGetterExceptionAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.stringAttrWithGetterException._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE_VOID(V8StringResource<>, v, value);
    imp->setStringAttrWithGetterException(v);
    return;
}

static v8::Handle<v8::Value> stringAttrWithSetterExceptionAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.stringAttrWithSetterException._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->stringAttrWithSetterException(), info.GetIsolate());
}

static void stringAttrWithSetterExceptionAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.stringAttrWithSetterException._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE_VOID(V8StringResource<>, v, value);
    ExceptionCode ec = 0;
    imp->setStringAttrWithSetterException(v, ec);
    if (UNLIKELY(ec))
        setDOMException(ec, info.GetIsolate());
    return;
}

static v8::Handle<v8::Value> withScriptStateAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptStateAttribute._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    return v8Integer(imp->withScriptStateAttribute(&state), info.GetIsolate());
}

static void withScriptStateAttributeAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptStateAttribute._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return;
    ScriptState& state = *currentState;
    imp->setWithScriptStateAttribute(&state, v);
    if (state.hadException())
        throwError(state.exception(), info.GetIsolate());
    return;
}

static v8::Handle<v8::Value> withScriptExecutionContextAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAttribute._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    return toV8(imp->withScriptExecutionContextAttribute(scriptContext), info.Holder(), info.GetIsolate());
}

static void withScriptExecutionContextAttributeAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAttribute._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    TestObj* v = V8TestObj::HasInstance(value) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    imp->setWithScriptExecutionContextAttribute(scriptContext, WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> withScriptStateAttributeRaisesAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptStateAttributeRaises._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ExceptionCode ec = 0;
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    RefPtr<TestObj> v = imp->withScriptStateAttributeRaises(&state, ec);
    if (UNLIKELY(ec))
        return setDOMException(ec, info.GetIsolate());
    if (state.hadException())
        return throwError(state.exception(), info.GetIsolate());
    return toV8(v.release(), info.Holder(), info.GetIsolate());
}

static void withScriptStateAttributeRaisesAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptStateAttributeRaises._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    TestObj* v = V8TestObj::HasInstance(value) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return;
    ScriptState& state = *currentState;
    imp->setWithScriptStateAttributeRaises(&state, WTF::getPtr(v));
    if (state.hadException())
        throwError(state.exception(), info.GetIsolate());
    return;
}

static v8::Handle<v8::Value> withScriptExecutionContextAttributeRaisesAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAttributeRaises._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    RefPtr<TestObj> v = imp->withScriptExecutionContextAttributeRaises(scriptContext, ec);
    if (UNLIKELY(ec))
        return setDOMException(ec, info.GetIsolate());
    return toV8(v.release(), info.Holder(), info.GetIsolate());
}

static void withScriptExecutionContextAttributeRaisesAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAttributeRaises._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    TestObj* v = V8TestObj::HasInstance(value) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    imp->setWithScriptExecutionContextAttributeRaises(scriptContext, WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAndScriptStateAttribute._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    return toV8(imp->withScriptExecutionContextAndScriptStateAttribute(&state, scriptContext), info.Holder(), info.GetIsolate());
}

static void withScriptExecutionContextAndScriptStateAttributeAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAndScriptStateAttribute._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    TestObj* v = V8TestObj::HasInstance(value) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return;
    ScriptState& state = *currentState;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    imp->setWithScriptExecutionContextAndScriptStateAttribute(&state, scriptContext, WTF::getPtr(v));
    if (state.hadException())
        throwError(state.exception(), info.GetIsolate());
    return;
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateAttributeRaisesAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAndScriptStateAttributeRaises._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ExceptionCode ec = 0;
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    RefPtr<TestObj> v = imp->withScriptExecutionContextAndScriptStateAttributeRaises(&state, scriptContext, ec);
    if (UNLIKELY(ec))
        return setDOMException(ec, info.GetIsolate());
    if (state.hadException())
        return throwError(state.exception(), info.GetIsolate());
    return toV8(v.release(), info.Holder(), info.GetIsolate());
}

static void withScriptExecutionContextAndScriptStateAttributeRaisesAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAndScriptStateAttributeRaises._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    TestObj* v = V8TestObj::HasInstance(value) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return;
    ScriptState& state = *currentState;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    imp->setWithScriptExecutionContextAndScriptStateAttributeRaises(&state, scriptContext, WTF::getPtr(v));
    if (state.hadException())
        throwError(state.exception(), info.GetIsolate());
    return;
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateWithSpacesAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAndScriptStateWithSpacesAttribute._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    return toV8(imp->withScriptExecutionContextAndScriptStateWithSpacesAttribute(&state, scriptContext), info.Holder(), info.GetIsolate());
}

static void withScriptExecutionContextAndScriptStateWithSpacesAttributeAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAndScriptStateWithSpacesAttribute._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    TestObj* v = V8TestObj::HasInstance(value) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return;
    ScriptState& state = *currentState;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    imp->setWithScriptExecutionContextAndScriptStateWithSpacesAttribute(&state, scriptContext, WTF::getPtr(v));
    if (state.hadException())
        throwError(state.exception(), info.GetIsolate());
    return;
}

static v8::Handle<v8::Value> withScriptArgumentsAndCallStackAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptArgumentsAndCallStackAttribute._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return toV8(imp->withScriptArgumentsAndCallStackAttribute(), info.Holder(), info.GetIsolate());
}

static void withScriptArgumentsAndCallStackAttributeAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptArgumentsAndCallStackAttribute._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    TestObj* v = V8TestObj::HasInstance(value) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    imp->setWithScriptArgumentsAndCallStackAttribute(WTF::getPtr(v));
    return;
}

#if ENABLE(Condition1)

static v8::Handle<v8::Value> conditionalAttr1AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.conditionalAttr1._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->conditionalAttr1(), info.GetIsolate());
}

#endif // ENABLE(Condition1)

#if ENABLE(Condition1)

static void conditionalAttr1AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.conditionalAttr1._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setConditionalAttr1(v);
    return;
}

#endif // ENABLE(Condition1)

#if ENABLE(Condition1) && ENABLE(Condition2)

static v8::Handle<v8::Value> conditionalAttr2AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.conditionalAttr2._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->conditionalAttr2(), info.GetIsolate());
}

#endif // ENABLE(Condition1) && ENABLE(Condition2)

#if ENABLE(Condition1) && ENABLE(Condition2)

static void conditionalAttr2AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.conditionalAttr2._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setConditionalAttr2(v);
    return;
}

#endif // ENABLE(Condition1) && ENABLE(Condition2)

#if ENABLE(Condition1) || ENABLE(Condition2)

static v8::Handle<v8::Value> conditionalAttr3AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.conditionalAttr3._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->conditionalAttr3(), info.GetIsolate());
}

#endif // ENABLE(Condition1) || ENABLE(Condition2)

#if ENABLE(Condition1) || ENABLE(Condition2)

static void conditionalAttr3AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.conditionalAttr3._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setConditionalAttr3(v);
    return;
}

#endif // ENABLE(Condition1) || ENABLE(Condition2)

static v8::Handle<v8::Value> cachedAttribute1AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.cachedAttribute1._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return imp->cachedAttribute1().v8Value();
}

static v8::Handle<v8::Value> cachedAttribute2AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.cachedAttribute2._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return imp->cachedAttribute2().v8Value();
}

static v8::Handle<v8::Value> anyAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.anyAttribute._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return imp->anyAttribute().v8Value();
}

static void anyAttributeAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.anyAttribute._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ScriptValue v = ScriptValue(value);
    imp->setAnyAttribute(WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> enabledAtRuntimeAttr1AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.enabledAtRuntimeAttr1._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->enabledAtRuntimeAttr1(), info.GetIsolate());
}

static void enabledAtRuntimeAttr1AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.enabledAtRuntimeAttr1._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setEnabledAtRuntimeAttr1(v);
    return;
}

static v8::Handle<v8::Value> enabledAtRuntimeAttr2AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.enabledAtRuntimeAttr2._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->enabledAtRuntimeAttr2(), info.GetIsolate());
}

static void enabledAtRuntimeAttr2AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.enabledAtRuntimeAttr2._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setEnabledAtRuntimeAttr2(v);
    return;
}

static v8::Handle<v8::Value> enabledPerContextAttr1AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.enabledPerContextAttr1._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->enabledPerContextAttr1(), info.GetIsolate());
}

static void enabledPerContextAttr1AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.enabledPerContextAttr1._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setEnabledPerContextAttr1(v);
    return;
}

static v8::Handle<v8::Value> enabledPerContextAttr2AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.enabledPerContextAttr2._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->enabledPerContextAttr2(), info.GetIsolate());
}

static void enabledPerContextAttr2AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.enabledPerContextAttr2._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setEnabledPerContextAttr2(v);
    return;
}

static v8::Handle<v8::Value> floatArrayAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.floatArray._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Array(imp->floatArray(), info.GetIsolate());
}

static void floatArrayAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.floatArray._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    Vector<float> v = toNativeArray<float>(value);
    imp->setFloatArray(v);
    return;
}

static v8::Handle<v8::Value> doubleArrayAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.doubleArray._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Array(imp->doubleArray(), info.GetIsolate());
}

static void doubleArrayAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.doubleArray._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    Vector<double> v = toNativeArray<double>(value);
    imp->setDoubleArray(v);
    return;
}

static v8::Handle<v8::Value> contentDocumentAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.contentDocument._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    if (!BindingSecurity::shouldAllowAccessToNode(BindingState::instance(), imp->contentDocument()))
        return v8::Handle<v8::Value>(v8::Null(info.GetIsolate()));

    return toV8(imp->contentDocument(), info.Holder(), info.GetIsolate());
}

static v8::Handle<v8::Value> mutablePointAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.mutablePoint._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return toV8(WTF::getPtr(SVGStaticPropertyTearOff<TestObj, FloatPoint>::create(imp, imp->mutablePoint(), &TestObj::updateMutablePoint)), info.Holder(), info.GetIsolate());
}

static void mutablePointAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.mutablePoint._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    RefPtr<SVGPropertyTearOff<FloatPoint> > v = V8SVGPoint::HasInstance(value) ? V8SVGPoint::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    imp->setMutablePoint(WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> immutablePointAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.immutablePoint._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return toV8(WTF::getPtr(SVGPropertyTearOff<FloatPoint>::create(imp->immutablePoint())), info.Holder(), info.GetIsolate());
}

static void immutablePointAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.immutablePoint._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    RefPtr<SVGPropertyTearOff<FloatPoint> > v = V8SVGPoint::HasInstance(value) ? V8SVGPoint::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    imp->setImmutablePoint(WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> strawberryAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.strawberry._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->blueberry(), info.GetIsolate());
}

static void strawberryAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.strawberry._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setBlueberry(v);
    return;
}

static v8::Handle<v8::Value> strictFloatAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.strictFloat._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Number::New(imp->strictFloat());
}

static void strictFloatAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.strictFloat._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    float v = static_cast<float>(value->NumberValue());
    imp->setStrictFloat(v);
    return;
}

static v8::Handle<v8::Value> descriptionAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.description._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->description(), info.GetIsolate());
}

static v8::Handle<v8::Value> idAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.id._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->id(), info.GetIsolate());
}

static void idAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.id._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setId(v);
    return;
}

static v8::Handle<v8::Value> hashAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.hash._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->hash(), info.GetIsolate());
}

static v8::Handle<v8::Value> replaceableAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.replaceableAttribute._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->replaceableAttribute(), info.GetIsolate());
}

static v8::Handle<v8::Value> TestObjConstructorGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.constructors._get");
    v8::Handle<v8::Value> data = info.Data();
    ASSERT(data->IsExternal());
    V8PerContextData* perContextData = V8PerContextData::from(info.Holder()->CreationContext());
    if (!perContextData)
        return v8Undefined();
    return perContextData->constructorForType(WrapperTypeInfo::unwrap(data));
}
static void TestObjReplaceableAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.replaceable._set");
    info.This()->ForceSet(name, value);
}

static v8::Handle<v8::Value> voidMethodCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.voidMethod");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    imp->voidMethod();
    return v8Undefined();
}

static v8::Handle<v8::Value> voidMethodWithArgsCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.voidMethodWithArgs");
    if (args.Length() < 3)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, strArg, MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined));
    V8TRYCATCH(TestObj*, objArg, V8TestObj::HasInstance(MAYBE_MISSING_PARAMETER(args, 2, DefaultIsUndefined)) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 2, DefaultIsUndefined))) : 0);
    imp->voidMethodWithArgs(longArg, strArg, objArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> longMethodCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.longMethod");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    return v8Integer(imp->longMethod(), args.GetIsolate());
}

static v8::Handle<v8::Value> longMethodWithArgsCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.longMethodWithArgs");
    if (args.Length() < 3)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, strArg, MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined));
    V8TRYCATCH(TestObj*, objArg, V8TestObj::HasInstance(MAYBE_MISSING_PARAMETER(args, 2, DefaultIsUndefined)) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 2, DefaultIsUndefined))) : 0);
    return v8Integer(imp->longMethodWithArgs(longArg, strArg, objArg), args.GetIsolate());
}

static v8::Handle<v8::Value> objMethodCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.objMethod");
    FeatureObserver::observe(activeDOMWindow(BindingState::instance()), FeatureObserver::TestFeature);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    return toV8(imp->objMethod(), args.Holder(), args.GetIsolate());
}

static v8::Handle<v8::Value> objMethodWithArgsCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.objMethodWithArgs");
    if (args.Length() < 3)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, strArg, MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined));
    V8TRYCATCH(TestObj*, objArg, V8TestObj::HasInstance(MAYBE_MISSING_PARAMETER(args, 2, DefaultIsUndefined)) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 2, DefaultIsUndefined))) : 0);
    return toV8(imp->objMethodWithArgs(longArg, strArg, objArg), args.Holder(), args.GetIsolate());
}

static v8::Handle<v8::Value> methodWithSequenceArgCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithSequenceArg");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(Vector<ScriptProfile>, sequenceArg, toNativeArray<ScriptProfile>(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    imp->methodWithSequenceArg(sequenceArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodReturningSequenceCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodReturningSequence");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    return v8Array(imp->methodReturningSequence(longArg), args.GetIsolate());
}

static v8::Handle<v8::Value> methodThatRequiresAllArgsAndThrowsCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodThatRequiresAllArgsAndThrows");
    if (args.Length() < 2)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, strArg, MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined));
    V8TRYCATCH(TestObj*, objArg, V8TestObj::HasInstance(MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined)) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined))) : 0);
    RefPtr<TestObj> result = imp->methodThatRequiresAllArgsAndThrows(strArg, objArg, ec);
    if (UNLIKELY(ec))
        goto fail;
    return toV8(result.release(), args.Holder(), args.GetIsolate());
    }
    fail:
    return setDOMException(ec, args.GetIsolate());
}

static v8::Handle<v8::Value> serializedValueCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.serializedValue");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    bool serializedArgDidThrow = false;
    RefPtr<SerializedScriptValue> serializedArg = SerializedScriptValue::create(args[0], 0, 0, serializedArgDidThrow, args.GetIsolate());
    if (serializedArgDidThrow)
        return v8Undefined();
    imp->serializedValue(serializedArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> idbKeyCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.idbKey");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(RefPtr<IDBKey>, key, createIDBKeyFromValue(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    imp->idbKey(key.get());
    return v8Undefined();
}

static v8::Handle<v8::Value> optionsObjectCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.optionsObject");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(Dictionary, oo, Dictionary(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined), args.GetIsolate()));
    if (!oo.isUndefinedOrNull() && !oo.isObject())
        return throwTypeError("Not an object.", args.GetIsolate());
    V8TRYCATCH(Dictionary, ooo, Dictionary(MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined), args.GetIsolate()));
    if (!ooo.isUndefinedOrNull() && !ooo.isObject())
        return throwTypeError("Not an object.", args.GetIsolate());
    imp->optionsObject(oo, ooo);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithExceptionCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithException");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    imp->methodWithException(ec);
    if (UNLIKELY(ec))
        goto fail;
    return v8Undefined();
    }
    fail:
    return setDOMException(ec, args.GetIsolate());
}

static v8::Handle<v8::Value> addEventListenerCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.addEventListener()");
    RefPtr<EventListener> listener = V8DOMWrapper::getEventListener(args[1], false, ListenerFindOrCreate);
    if (listener) {
        V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<WithNullCheck>, stringResource, args[0]);
        V8TestObj::toNative(args.Holder())->addEventListener(stringResource, listener, args[2]->BooleanValue());
        createHiddenDependency(args.Holder(), args[1], V8TestObj::eventListenerCacheIndex);
    }
    return v8Undefined();
}

static v8::Handle<v8::Value> removeEventListenerCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.removeEventListener()");
    RefPtr<EventListener> listener = V8DOMWrapper::getEventListener(args[1], false, ListenerFindOnly);
    if (listener) {
        V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<WithNullCheck>, stringResource, args[0]);
        V8TestObj::toNative(args.Holder())->removeEventListener(stringResource, listener.get(), args[2]->BooleanValue());
        removeHiddenDependency(args.Holder(), args[1], V8TestObj::eventListenerCacheIndex);
    }
    return v8Undefined();
}

static v8::Handle<v8::Value> withScriptStateVoidCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptStateVoid");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    imp->withScriptStateVoid(&state);
    if (state.hadException()) {
        v8::Local<v8::Value> exception = state.exception();
        state.clearException();
        return throwError(exception, args.GetIsolate());
    }
    return v8Undefined();
}

static v8::Handle<v8::Value> withScriptStateObjCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptStateObj");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    RefPtr<TestObj> result = imp->withScriptStateObj(&state);
    if (state.hadException()) {
        v8::Local<v8::Value> exception = state.exception();
        state.clearException();
        return throwError(exception, args.GetIsolate());
    }
    return toV8(result.release(), args.Holder(), args.GetIsolate());
}

static v8::Handle<v8::Value> withScriptStateVoidExceptionCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptStateVoidException");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    imp->withScriptStateVoidException(&state, ec);
    if (UNLIKELY(ec))
        goto fail;
    if (state.hadException()) {
        v8::Local<v8::Value> exception = state.exception();
        state.clearException();
        return throwError(exception, args.GetIsolate());
    }
    return v8Undefined();
    }
    fail:
    return setDOMException(ec, args.GetIsolate());
}

static v8::Handle<v8::Value> withScriptStateObjExceptionCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptStateObjException");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    RefPtr<TestObj> result = imp->withScriptStateObjException(&state, ec);
    if (UNLIKELY(ec))
        goto fail;
    if (state.hadException()) {
        v8::Local<v8::Value> exception = state.exception();
        state.clearException();
        return throwError(exception, args.GetIsolate());
    }
    return toV8(result.release(), args.Holder(), args.GetIsolate());
    }
    fail:
    return setDOMException(ec, args.GetIsolate());
}

static v8::Handle<v8::Value> withScriptExecutionContextCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContext");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    imp->withScriptExecutionContext(scriptContext);
    return v8Undefined();
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAndScriptState");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    imp->withScriptExecutionContextAndScriptState(&state, scriptContext);
    if (state.hadException()) {
        v8::Local<v8::Value> exception = state.exception();
        state.clearException();
        return throwError(exception, args.GetIsolate());
    }
    return v8Undefined();
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateObjExceptionCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAndScriptStateObjException");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    RefPtr<TestObj> result = imp->withScriptExecutionContextAndScriptStateObjException(&state, scriptContext, ec);
    if (UNLIKELY(ec))
        goto fail;
    if (state.hadException()) {
        v8::Local<v8::Value> exception = state.exception();
        state.clearException();
        return throwError(exception, args.GetIsolate());
    }
    return toV8(result.release(), args.Holder(), args.GetIsolate());
    }
    fail:
    return setDOMException(ec, args.GetIsolate());
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateWithSpacesCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAndScriptStateWithSpaces");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    RefPtr<TestObj> result = imp->withScriptExecutionContextAndScriptStateWithSpaces(&state, scriptContext);
    if (state.hadException()) {
        v8::Local<v8::Value> exception = state.exception();
        state.clearException();
        return throwError(exception, args.GetIsolate());
    }
    return toV8(result.release(), args.Holder(), args.GetIsolate());
}

static v8::Handle<v8::Value> withScriptArgumentsAndCallStackCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptArgumentsAndCallStack");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    RefPtr<ScriptArguments> scriptArguments(createScriptArguments(args, 0));
    imp->withScriptArgumentsAndCallStack(scriptArguments.release());
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithOptionalArgCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithOptionalArg");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    if (args.Length() <= 0) {
        imp->methodWithOptionalArg();
        return v8Undefined();
    }
    V8TRYCATCH(int, opt, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    imp->methodWithOptionalArg(opt);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithNonOptionalArgAndOptionalArgCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithNonOptionalArgAndOptionalArg");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, nonOpt, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    if (args.Length() <= 1) {
        imp->methodWithNonOptionalArgAndOptionalArg(nonOpt);
        return v8Undefined();
    }
    V8TRYCATCH(int, opt, toInt32(MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined)));
    imp->methodWithNonOptionalArgAndOptionalArg(nonOpt, opt);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithNonOptionalArgAndTwoOptionalArgsCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithNonOptionalArgAndTwoOptionalArgs");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, nonOpt, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    if (args.Length() <= 1) {
        imp->methodWithNonOptionalArgAndTwoOptionalArgs(nonOpt);
        return v8Undefined();
    }
    V8TRYCATCH(int, opt1, toInt32(MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined)));
    if (args.Length() <= 2) {
        imp->methodWithNonOptionalArgAndTwoOptionalArgs(nonOpt, opt1);
        return v8Undefined();
    }
    V8TRYCATCH(int, opt2, toInt32(MAYBE_MISSING_PARAMETER(args, 2, DefaultIsUndefined)));
    imp->methodWithNonOptionalArgAndTwoOptionalArgs(nonOpt, opt1, opt2);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithOptionalStringCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithOptionalString");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    if (args.Length() <= 0) {
        imp->methodWithOptionalString();
        return v8Undefined();
    }
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, str, MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined));
    imp->methodWithOptionalString(str);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithOptionalStringIsUndefinedCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithOptionalStringIsUndefined");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, str, MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined));
    imp->methodWithOptionalStringIsUndefined(str);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithOptionalStringIsNullStringCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithOptionalStringIsNullString");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, str, MAYBE_MISSING_PARAMETER(args, 0, DefaultIsNullString));
    imp->methodWithOptionalStringIsNullString(str);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithCallbackArgCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithCallbackArg");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    if (args.Length() <= 0 || !args[0]->IsFunction())
        return throwTypeError(0, args.GetIsolate());
    RefPtr<TestCallback> callback = V8TestCallback::create(args[0], getScriptExecutionContext());
    imp->methodWithCallbackArg(callback);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithNonCallbackArgAndCallbackArgCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithNonCallbackArgAndCallbackArg");
    if (args.Length() < 2)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, nonCallback, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    if (args.Length() <= 1 || !args[1]->IsFunction())
        return throwTypeError(0, args.GetIsolate());
    RefPtr<TestCallback> callback = V8TestCallback::create(args[1], getScriptExecutionContext());
    imp->methodWithNonCallbackArgAndCallbackArg(nonCallback, callback);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithCallbackAndOptionalArgCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithCallbackAndOptionalArg");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    RefPtr<TestCallback> callback;
    if (args.Length() > 0 && !args[0]->IsNull() && !args[0]->IsUndefined()) {
        if (!args[0]->IsFunction())
            return throwTypeError(0, args.GetIsolate());
        callback = V8TestCallback::create(args[0], getScriptExecutionContext());
    }
    imp->methodWithCallbackAndOptionalArg(callback);
    return v8Undefined();
}

#if ENABLE(Condition1)

static v8::Handle<v8::Value> conditionalMethod1Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.conditionalMethod1");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    return v8String(imp->conditionalMethod1(), args.GetIsolate());
}

#endif // ENABLE(Condition1)

#if ENABLE(Condition1) && ENABLE(Condition2)

static v8::Handle<v8::Value> conditionalMethod2Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.conditionalMethod2");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    imp->conditionalMethod2();
    return v8Undefined();
}

#endif // ENABLE(Condition1) && ENABLE(Condition2)

#if ENABLE(Condition1) || ENABLE(Condition2)

static v8::Handle<v8::Value> conditionalMethod3Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.conditionalMethod3");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    imp->conditionalMethod3();
    return v8Undefined();
}

#endif // ENABLE(Condition1) || ENABLE(Condition2)

static v8::Handle<v8::Value> overloadedMethod1Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod1");
    if (args.Length() < 2)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(TestObj*, objArg, V8TestObj::HasInstance(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined))) : 0);
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, strArg, MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined));
    imp->overloadedMethod(objArg, strArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod2Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod2");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(TestObj*, objArg, V8TestObj::HasInstance(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined))) : 0);
    if (args.Length() <= 1) {
        imp->overloadedMethod(objArg);
        return v8Undefined();
    }
    V8TRYCATCH(int, longArg, toInt32(MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined)));
    imp->overloadedMethod(objArg, longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod3Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod3");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, strArg, MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined));
    imp->overloadedMethod(strArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod4Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod4");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    imp->overloadedMethod(longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod5Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod5");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    if (args.Length() <= 0 || !args[0]->IsFunction())
        return throwTypeError(0, args.GetIsolate());
    RefPtr<TestCallback> callback = V8TestCallback::create(args[0], getScriptExecutionContext());
    imp->overloadedMethod(callback);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod6Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod6");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(RefPtr<DOMStringList>, listArg, toDOMStringList(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    imp->overloadedMethod(listArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod7Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod7");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(RefPtr<DOMStringList>, arrayArg, toDOMStringList(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    imp->overloadedMethod(arrayArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod8Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod8");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(TestObj*, objArg, V8TestObj::HasInstance(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined))) : 0);
    imp->overloadedMethod(objArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod9Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod9");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(RefPtr<DOMStringList>, arrayArg, toDOMStringList(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    imp->overloadedMethod(arrayArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod10Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod10");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(Vector<unsigned long>, arrayArg, toNativeArray<unsigned long>(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    imp->overloadedMethod(arrayArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod11Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod11");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, strArg, MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined));
    imp->overloadedMethod(strArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethodCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod");
    if ((args.Length() == 2 && (args[0]->IsNull() || V8TestObj::HasInstance(args[0])) && (args[1]->IsNull() || args[1]->IsUndefined() || args[1]->IsString() || args[1]->IsObject())))
        return overloadedMethod1Callback(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || V8TestObj::HasInstance(args[0]))) || (args.Length() == 2 && (args[0]->IsNull() || V8TestObj::HasInstance(args[0]))))
        return overloadedMethod2Callback(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || args[0]->IsUndefined() || args[0]->IsString() || args[0]->IsObject())))
        return overloadedMethod3Callback(args);
    if (args.Length() == 1)
        return overloadedMethod4Callback(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || args[0]->IsFunction())))
        return overloadedMethod5Callback(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || V8DOMStringList::HasInstance(args[0]))))
        return overloadedMethod6Callback(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || args[0]->IsArray())))
        return overloadedMethod7Callback(args);
    if ((args.Length() == 1 && (V8TestObj::HasInstance(args[0]))))
        return overloadedMethod8Callback(args);
    if ((args.Length() == 1 && (args[0]->IsArray())))
        return overloadedMethod9Callback(args);
    if ((args.Length() == 1 && (args[0]->IsArray())))
        return overloadedMethod10Callback(args);
    if (args.Length() == 1)
        return overloadedMethod11Callback(args);
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    return throwTypeError(0, args.GetIsolate());
}

static v8::Handle<v8::Value> classMethodCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.classMethod");
    TestObj::classMethod();
    return v8Undefined();
}

static v8::Handle<v8::Value> classMethodWithOptionalCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.classMethodWithOptional");
    if (args.Length() <= 0) {
        return v8Integer(TestObj::classMethodWithOptional(), args.GetIsolate());
    }
    V8TRYCATCH(int, arg, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    return v8Integer(TestObj::classMethodWithOptional(arg), args.GetIsolate());
}

#if ENABLE(Condition1)

static v8::Handle<v8::Value> overloadedMethod11Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod11");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    V8TRYCATCH(int, arg, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    TestObj::overloadedMethod1(arg);
    return v8Undefined();
}

#endif // ENABLE(Condition1)

#if ENABLE(Condition1)

static v8::Handle<v8::Value> overloadedMethod12Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod12");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, type, MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined));
    TestObj::overloadedMethod1(type);
    return v8Undefined();
}

#endif // ENABLE(Condition1)

#if ENABLE(Condition1)

static v8::Handle<v8::Value> overloadedMethod1Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod1");
    if (args.Length() == 1)
        return overloadedMethod11Callback(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || args[0]->IsUndefined() || args[0]->IsString() || args[0]->IsObject())))
        return overloadedMethod12Callback(args);
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    return throwTypeError(0, args.GetIsolate());
}

#endif // ENABLE(Condition1)

static v8::Handle<v8::Value> classMethodWithClampCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.classMethodWithClamp");
    if (args.Length() < 2)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    unsigned short objArgsShort = 0;
    V8TRYCATCH(double, objArgsShortNativeValue, args[0]->NumberValue());
    if (!isnan(objArgsShortNativeValue))
        objArgsShort = clampTo<unsigned short>(objArgsShortNativeValue);
    unsigned long objArgsLong = 0;
    V8TRYCATCH(double, objArgsLongNativeValue, args[1]->NumberValue());
    if (!isnan(objArgsLongNativeValue))
        objArgsLong = clampTo<unsigned long>(objArgsLongNativeValue);
    imp->classMethodWithClamp(objArgsShort, objArgsLong);
    return v8Undefined();
}

static v8::Handle<v8::Value> enabledAtRuntimeMethod1Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.enabledAtRuntimeMethod1");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    imp->enabledAtRuntimeMethod1(longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> enabledAtRuntimeMethod2Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.enabledAtRuntimeMethod2");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    imp->enabledAtRuntimeMethod2(longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> enabledPerContextMethod1Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.enabledPerContextMethod1");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    imp->enabledPerContextMethod1(longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> enabledPerContextMethod2Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.enabledPerContextMethod2");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    imp->enabledPerContextMethod2(longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> stringArrayFunctionCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.stringArrayFunction");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    V8TRYCATCH(RefPtr<DOMStringList>, values, toDOMStringList(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    RefPtr<DOMStringList> result = imp->stringArrayFunction(values, ec);
    if (UNLIKELY(ec))
        goto fail;
    return v8Array(result.release(), args.GetIsolate());
    }
    fail:
    return setDOMException(ec, args.GetIsolate());
}

static v8::Handle<v8::Value> getSVGDocumentCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.getSVGDocument");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    if (!BindingSecurity::shouldAllowAccessToNode(BindingState::instance(), imp->getSVGDocument(ec)))
        return v8::Handle<v8::Value>(v8::Null(args.GetIsolate()));
    RefPtr<SVGDocument> result = imp->getSVGDocument(ec);
    if (UNLIKELY(ec))
        goto fail;
    return toV8(result.release(), args.Holder(), args.GetIsolate());
    }
    fail:
    return setDOMException(ec, args.GetIsolate());
}

static v8::Handle<v8::Value> convert1Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.convert1");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(a*, value, V8a::HasInstance(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)) ? V8a::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined))) : 0);
    imp->convert1(value);
    return v8Undefined();
}

static v8::Handle<v8::Value> convert2Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.convert2");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(b*, value, V8b::HasInstance(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)) ? V8b::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined))) : 0);
    imp->convert2(value);
    return v8Undefined();
}

static v8::Handle<v8::Value> convert4Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.convert4");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(d*, value, V8d::HasInstance(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)) ? V8d::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined))) : 0);
    imp->convert4(value);
    return v8Undefined();
}

static v8::Handle<v8::Value> convert5Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.convert5");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(e*, value, V8e::HasInstance(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)) ? V8e::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined))) : 0);
    imp->convert5(value);
    return v8Undefined();
}

static v8::Handle<v8::Value> mutablePointFunctionCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.mutablePointFunction");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    return toV8(WTF::getPtr(SVGPropertyTearOff<FloatPoint>::create(imp->mutablePointFunction())), args.Holder(), args.GetIsolate());
}

static v8::Handle<v8::Value> immutablePointFunctionCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.immutablePointFunction");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    return toV8(WTF::getPtr(SVGPropertyTearOff<FloatPoint>::create(imp->immutablePointFunction())), args.Holder(), args.GetIsolate());
}

static v8::Handle<v8::Value> orangeCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.orange");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    imp->banana();
    return v8Undefined();
}

static v8::Handle<v8::Value> strictFunctionCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.strictFunction");
    if (args.Length() < 3)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, str, MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined));
    V8TRYCATCH(float, a, static_cast<float>(MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined)->NumberValue()));
    V8TRYCATCH(int, b, toInt32(MAYBE_MISSING_PARAMETER(args, 2, DefaultIsUndefined)));
    RefPtr<bool> result = imp->strictFunction(str, a, b, ec);
    if (UNLIKELY(ec))
        goto fail;
    return toV8(result.release(), args.Holder(), args.GetIsolate());
    }
    fail:
    return setDOMException(ec, args.GetIsolate());
}

static v8::Handle<v8::Value> variadicStringMethodCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.variadicStringMethod");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, head, MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined));
    V8TRYCATCH(Vector<String>, tail, toNativeArguments<String>(args, 1));
    imp->variadicStringMethod(head, tail);
    return v8Undefined();
}

static v8::Handle<v8::Value> variadicDoubleMethodCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.variadicDoubleMethod");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(double, head, static_cast<double>(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)->NumberValue()));
    V8TRYCATCH(Vector<double>, tail, toNativeArguments<double>(args, 1));
    imp->variadicDoubleMethod(head, tail);
    return v8Undefined();
}

static v8::Handle<v8::Value> variadicNodeMethodCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.variadicNodeMethod");
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(Node*, head, V8Node::HasInstance(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)) ? V8Node::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined))) : 0);
    Vector<RefPtr<Node> > tail;
    for (int i = 1; i < args.Length(); ++i) {
        if (!V8Node::HasInstance(args[i]))
            return throwTypeError(0, args.GetIsolate());
        tail.append(V8Node::toNative(v8::Handle<v8::Object>::Cast(args[i])));
    }
    imp->variadicNodeMethod(head, tail);
    return v8Undefined();
}

} // namespace TestObjV8Internal

static const V8DOMConfiguration::BatchedAttribute V8TestObjAttrs[] = {
    // Attribute 'readOnlyLongAttr' (Type: 'readonly attribute' ExtAttr: '')
    {"readOnlyLongAttr", TestObjV8Internal::readOnlyLongAttrAttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'readOnlyStringAttr' (Type: 'readonly attribute' ExtAttr: '')
    {"readOnlyStringAttr", TestObjV8Internal::readOnlyStringAttrAttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'readOnlyTestObjAttr' (Type: 'readonly attribute' ExtAttr: '')
    {"readOnlyTestObjAttr", TestObjV8Internal::readOnlyTestObjAttrAttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'staticReadOnlyLongAttr' (Type: 'readonly attribute' ExtAttr: '')
    {"staticReadOnlyLongAttr", TestObjV8Internal::staticReadOnlyLongAttrAttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'staticStringAttr' (Type: 'attribute' ExtAttr: '')
    {"staticStringAttr", TestObjV8Internal::staticStringAttrAttrGetter, TestObjV8Internal::staticStringAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'TestSubObj' (Type: 'readonly attribute' ExtAttr: '')
    {"TestSubObj", TestObjV8Internal::TestObjConstructorGetter, 0, &V8TestSubObj::info, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'shortAttr' (Type: 'attribute' ExtAttr: '')
    {"shortAttr", TestObjV8Internal::shortAttrAttrGetter, TestObjV8Internal::shortAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'unsignedShortAttr' (Type: 'attribute' ExtAttr: '')
    {"unsignedShortAttr", TestObjV8Internal::unsignedShortAttrAttrGetter, TestObjV8Internal::unsignedShortAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'longAttr' (Type: 'attribute' ExtAttr: '')
    {"longAttr", TestObjV8Internal::longAttrAttrGetter, TestObjV8Internal::longAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'longLongAttr' (Type: 'attribute' ExtAttr: '')
    {"longLongAttr", TestObjV8Internal::longLongAttrAttrGetter, TestObjV8Internal::longLongAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'unsignedLongLongAttr' (Type: 'attribute' ExtAttr: '')
    {"unsignedLongLongAttr", TestObjV8Internal::unsignedLongLongAttrAttrGetter, TestObjV8Internal::unsignedLongLongAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'stringAttr' (Type: 'attribute' ExtAttr: '')
    {"stringAttr", TestObjV8Internal::stringAttrAttrGetter, TestObjV8Internal::stringAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'testObjAttr' (Type: 'attribute' ExtAttr: 'V8MeasureAs')
    {"testObjAttr", TestObjV8Internal::testObjAttrAttrGetter, TestObjV8Internal::testObjAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'XMLObjAttr' (Type: 'attribute' ExtAttr: '')
    {"XMLObjAttr", TestObjV8Internal::XMLObjAttrAttrGetter, TestObjV8Internal::XMLObjAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'create' (Type: 'attribute' ExtAttr: '')
    {"create", TestObjV8Internal::createAttrGetter, TestObjV8Internal::createAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedStringAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedStringAttr", TestObjV8Internal::reflectedStringAttrAttrGetter, TestObjV8Internal::reflectedStringAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedIntegralAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedIntegralAttr", TestObjV8Internal::reflectedIntegralAttrAttrGetter, TestObjV8Internal::reflectedIntegralAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedUnsignedIntegralAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedUnsignedIntegralAttr", TestObjV8Internal::reflectedUnsignedIntegralAttrAttrGetter, TestObjV8Internal::reflectedUnsignedIntegralAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedBooleanAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedBooleanAttr", TestObjV8Internal::reflectedBooleanAttrAttrGetter, TestObjV8Internal::reflectedBooleanAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedURLAttr' (Type: 'attribute' ExtAttr: 'URL Reflect')
    {"reflectedURLAttr", TestObjV8Internal::reflectedURLAttrAttrGetter, TestObjV8Internal::reflectedURLAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedStringAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedStringAttr", TestObjV8Internal::reflectedStringAttrAttrGetter, TestObjV8Internal::reflectedStringAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedCustomIntegralAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedCustomIntegralAttr", TestObjV8Internal::reflectedCustomIntegralAttrAttrGetter, TestObjV8Internal::reflectedCustomIntegralAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedCustomBooleanAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedCustomBooleanAttr", TestObjV8Internal::reflectedCustomBooleanAttrAttrGetter, TestObjV8Internal::reflectedCustomBooleanAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedCustomURLAttr' (Type: 'attribute' ExtAttr: 'URL Reflect')
    {"reflectedCustomURLAttr", TestObjV8Internal::reflectedCustomURLAttrAttrGetter, TestObjV8Internal::reflectedCustomURLAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'typedArrayAttr' (Type: 'attribute' ExtAttr: '')
    {"typedArrayAttr", TestObjV8Internal::typedArrayAttrAttrGetter, TestObjV8Internal::typedArrayAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'attrWithGetterException' (Type: 'attribute' ExtAttr: '')
    {"attrWithGetterException", TestObjV8Internal::attrWithGetterExceptionAttrGetter, TestObjV8Internal::attrWithGetterExceptionAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'attrWithSetterException' (Type: 'attribute' ExtAttr: '')
    {"attrWithSetterException", TestObjV8Internal::attrWithSetterExceptionAttrGetter, TestObjV8Internal::attrWithSetterExceptionAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'stringAttrWithGetterException' (Type: 'attribute' ExtAttr: '')
    {"stringAttrWithGetterException", TestObjV8Internal::stringAttrWithGetterExceptionAttrGetter, TestObjV8Internal::stringAttrWithGetterExceptionAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'stringAttrWithSetterException' (Type: 'attribute' ExtAttr: '')
    {"stringAttrWithSetterException", TestObjV8Internal::stringAttrWithSetterExceptionAttrGetter, TestObjV8Internal::stringAttrWithSetterExceptionAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'customAttr' (Type: 'attribute' ExtAttr: 'Custom')
    {"customAttr", V8TestObj::customAttrAccessorGetter, V8TestObj::customAttrAccessorSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptStateAttribute' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptStateAttribute", TestObjV8Internal::withScriptStateAttributeAttrGetter, TestObjV8Internal::withScriptStateAttributeAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptExecutionContextAttribute' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptExecutionContextAttribute", TestObjV8Internal::withScriptExecutionContextAttributeAttrGetter, TestObjV8Internal::withScriptExecutionContextAttributeAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptStateAttributeRaises' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptStateAttributeRaises", TestObjV8Internal::withScriptStateAttributeRaisesAttrGetter, TestObjV8Internal::withScriptStateAttributeRaisesAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptExecutionContextAttributeRaises' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptExecutionContextAttributeRaises", TestObjV8Internal::withScriptExecutionContextAttributeRaisesAttrGetter, TestObjV8Internal::withScriptExecutionContextAttributeRaisesAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptExecutionContextAndScriptStateAttribute' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptExecutionContextAndScriptStateAttribute", TestObjV8Internal::withScriptExecutionContextAndScriptStateAttributeAttrGetter, TestObjV8Internal::withScriptExecutionContextAndScriptStateAttributeAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptExecutionContextAndScriptStateAttributeRaises' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptExecutionContextAndScriptStateAttributeRaises", TestObjV8Internal::withScriptExecutionContextAndScriptStateAttributeRaisesAttrGetter, TestObjV8Internal::withScriptExecutionContextAndScriptStateAttributeRaisesAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptExecutionContextAndScriptStateWithSpacesAttribute' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptExecutionContextAndScriptStateWithSpacesAttribute", TestObjV8Internal::withScriptExecutionContextAndScriptStateWithSpacesAttributeAttrGetter, TestObjV8Internal::withScriptExecutionContextAndScriptStateWithSpacesAttributeAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptArgumentsAndCallStackAttribute' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptArgumentsAndCallStackAttribute", TestObjV8Internal::withScriptArgumentsAndCallStackAttributeAttrGetter, TestObjV8Internal::withScriptArgumentsAndCallStackAttributeAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
#if ENABLE(Condition1)
    // Attribute 'conditionalAttr1' (Type: 'attribute' ExtAttr: 'Conditional')
    {"conditionalAttr1", TestObjV8Internal::conditionalAttr1AttrGetter, TestObjV8Internal::conditionalAttr1AttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
#endif // ENABLE(Condition1)
#if ENABLE(Condition1) && ENABLE(Condition2)
    // Attribute 'conditionalAttr2' (Type: 'attribute' ExtAttr: 'Conditional')
    {"conditionalAttr2", TestObjV8Internal::conditionalAttr2AttrGetter, TestObjV8Internal::conditionalAttr2AttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
#endif // ENABLE(Condition1) && ENABLE(Condition2)
#if ENABLE(Condition1) || ENABLE(Condition2)
    // Attribute 'conditionalAttr3' (Type: 'attribute' ExtAttr: 'Conditional')
    {"conditionalAttr3", TestObjV8Internal::conditionalAttr3AttrGetter, TestObjV8Internal::conditionalAttr3AttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
#endif // ENABLE(Condition1) || ENABLE(Condition2)
#if ENABLE(Condition1)
    // Attribute 'conditionalAttr4' (Type: 'attribute' ExtAttr: 'Conditional')
    {"conditionalAttr4", TestObjV8Internal::TestObjConstructorGetter, TestObjV8Internal::TestObjReplaceableAttrSetter, &V8TestObjectA::info, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
#endif // ENABLE(Condition1)
#if ENABLE(Condition1) && ENABLE(Condition2)
    // Attribute 'conditionalAttr5' (Type: 'attribute' ExtAttr: 'Conditional')
    {"conditionalAttr5", TestObjV8Internal::TestObjConstructorGetter, TestObjV8Internal::TestObjReplaceableAttrSetter, &V8TestObjectB::info, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
#endif // ENABLE(Condition1) && ENABLE(Condition2)
#if ENABLE(Condition1) || ENABLE(Condition2)
    // Attribute 'conditionalAttr6' (Type: 'attribute' ExtAttr: 'Conditional')
    {"conditionalAttr6", TestObjV8Internal::TestObjConstructorGetter, TestObjV8Internal::TestObjReplaceableAttrSetter, &V8TestObjectC::info, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
#endif // ENABLE(Condition1) || ENABLE(Condition2)
    // Attribute 'cachedAttribute1' (Type: 'readonly attribute' ExtAttr: 'CachedAttribute')
    {"cachedAttribute1", TestObjV8Internal::cachedAttribute1AttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'cachedAttribute2' (Type: 'readonly attribute' ExtAttr: 'CachedAttribute')
    {"cachedAttribute2", TestObjV8Internal::cachedAttribute2AttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'anyAttribute' (Type: 'attribute' ExtAttr: '')
    {"anyAttribute", TestObjV8Internal::anyAttributeAttrGetter, TestObjV8Internal::anyAttributeAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'floatArray' (Type: 'attribute' ExtAttr: '')
    {"floatArray", TestObjV8Internal::floatArrayAttrGetter, TestObjV8Internal::floatArrayAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'doubleArray' (Type: 'attribute' ExtAttr: '')
    {"doubleArray", TestObjV8Internal::doubleArrayAttrGetter, TestObjV8Internal::doubleArrayAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'contentDocument' (Type: 'readonly attribute' ExtAttr: 'CheckSecurityForNode')
    {"contentDocument", TestObjV8Internal::contentDocumentAttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'mutablePoint' (Type: 'attribute' ExtAttr: '')
    {"mutablePoint", TestObjV8Internal::mutablePointAttrGetter, TestObjV8Internal::mutablePointAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'immutablePoint' (Type: 'attribute' ExtAttr: 'Immutable')
    {"immutablePoint", TestObjV8Internal::immutablePointAttrGetter, TestObjV8Internal::immutablePointAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'strawberry' (Type: 'attribute' ExtAttr: 'ImplementedAs')
    {"strawberry", TestObjV8Internal::strawberryAttrGetter, TestObjV8Internal::strawberryAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'strictFloat' (Type: 'attribute' ExtAttr: 'StrictTypeChecking')
    {"strictFloat", TestObjV8Internal::strictFloatAttrGetter, TestObjV8Internal::strictFloatAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'description' (Type: 'readonly attribute' ExtAttr: '')
    {"description", TestObjV8Internal::descriptionAttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'id' (Type: 'attribute' ExtAttr: '')
    {"id", TestObjV8Internal::idAttrGetter, TestObjV8Internal::idAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'hash' (Type: 'readonly attribute' ExtAttr: '')
    {"hash", TestObjV8Internal::hashAttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'replaceableAttribute' (Type: 'readonly attribute' ExtAttr: 'Replaceable')
    {"replaceableAttribute", TestObjV8Internal::replaceableAttributeAttrGetter, TestObjV8Internal::TestObjReplaceableAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
};

static const V8DOMConfiguration::BatchedCallback V8TestObjCallbacks[] = {
    {"voidMethod", TestObjV8Internal::voidMethodCallback},
    {"longMethod", TestObjV8Internal::longMethodCallback},
    {"objMethod", TestObjV8Internal::objMethodCallback},
    {"methodReturningSequence", TestObjV8Internal::methodReturningSequenceCallback},
    {"serializedValue", TestObjV8Internal::serializedValueCallback},
    {"idbKey", TestObjV8Internal::idbKeyCallback},
    {"optionsObject", TestObjV8Internal::optionsObjectCallback},
    {"methodWithException", TestObjV8Internal::methodWithExceptionCallback},
    {"customMethod", V8TestObj::customMethodCallback},
    {"customMethodWithArgs", V8TestObj::customMethodWithArgsCallback},
    {"addEventListener", TestObjV8Internal::addEventListenerCallback},
    {"removeEventListener", TestObjV8Internal::removeEventListenerCallback},
    {"withScriptStateVoid", TestObjV8Internal::withScriptStateVoidCallback},
    {"withScriptStateObj", TestObjV8Internal::withScriptStateObjCallback},
    {"withScriptStateVoidException", TestObjV8Internal::withScriptStateVoidExceptionCallback},
    {"withScriptStateObjException", TestObjV8Internal::withScriptStateObjExceptionCallback},
    {"withScriptExecutionContext", TestObjV8Internal::withScriptExecutionContextCallback},
    {"withScriptExecutionContextAndScriptState", TestObjV8Internal::withScriptExecutionContextAndScriptStateCallback},
    {"withScriptExecutionContextAndScriptStateObjException", TestObjV8Internal::withScriptExecutionContextAndScriptStateObjExceptionCallback},
    {"withScriptExecutionContextAndScriptStateWithSpaces", TestObjV8Internal::withScriptExecutionContextAndScriptStateWithSpacesCallback},
    {"withScriptArgumentsAndCallStack", TestObjV8Internal::withScriptArgumentsAndCallStackCallback},
    {"methodWithOptionalArg", TestObjV8Internal::methodWithOptionalArgCallback},
    {"methodWithNonOptionalArgAndOptionalArg", TestObjV8Internal::methodWithNonOptionalArgAndOptionalArgCallback},
    {"methodWithNonOptionalArgAndTwoOptionalArgs", TestObjV8Internal::methodWithNonOptionalArgAndTwoOptionalArgsCallback},
    {"methodWithOptionalString", TestObjV8Internal::methodWithOptionalStringCallback},
    {"methodWithOptionalStringIsUndefined", TestObjV8Internal::methodWithOptionalStringIsUndefinedCallback},
    {"methodWithOptionalStringIsNullString", TestObjV8Internal::methodWithOptionalStringIsNullStringCallback},
    {"methodWithCallbackArg", TestObjV8Internal::methodWithCallbackArgCallback},
    {"methodWithNonCallbackArgAndCallbackArg", TestObjV8Internal::methodWithNonCallbackArgAndCallbackArgCallback},
    {"methodWithCallbackAndOptionalArg", TestObjV8Internal::methodWithCallbackAndOptionalArgCallback},
#if ENABLE(Condition1)
    {"conditionalMethod1", TestObjV8Internal::conditionalMethod1Callback},
#endif
#if ENABLE(Condition1) && ENABLE(Condition2)
    {"conditionalMethod2", TestObjV8Internal::conditionalMethod2Callback},
#endif
#if ENABLE(Condition1) || ENABLE(Condition2)
    {"conditionalMethod3", TestObjV8Internal::conditionalMethod3Callback},
#endif
    {"overloadedMethod", TestObjV8Internal::overloadedMethodCallback},
    {"classMethodWithClamp", TestObjV8Internal::classMethodWithClampCallback},
    {"stringArrayFunction", TestObjV8Internal::stringArrayFunctionCallback},
    {"getSVGDocument", TestObjV8Internal::getSVGDocumentCallback},
    {"mutablePointFunction", TestObjV8Internal::mutablePointFunctionCallback},
    {"immutablePointFunction", TestObjV8Internal::immutablePointFunctionCallback},
    {"orange", TestObjV8Internal::orangeCallback},
    {"strictFunction", TestObjV8Internal::strictFunctionCallback},
    {"variadicStringMethod", TestObjV8Internal::variadicStringMethodCallback},
    {"variadicDoubleMethod", TestObjV8Internal::variadicDoubleMethodCallback},
};

static const V8DOMConfiguration::BatchedConstant V8TestObjConsts[] = {
#if ENABLE(Condition1)
    {"CONDITIONAL_CONST", static_cast<signed int>(0)},
#endif
    {"CONST_VALUE_0", static_cast<signed int>(0)},
    {"CONST_VALUE_1", static_cast<signed int>(1)},
    {"CONST_VALUE_2", static_cast<signed int>(2)},
    {"CONST_VALUE_4", static_cast<signed int>(4)},
    {"CONST_VALUE_8", static_cast<signed int>(8)},
    {"CONST_VALUE_9", static_cast<signed int>(-1)},
    {"CONST_VALUE_10", static_cast<signed int>("my constant string")},
    {"CONST_VALUE_11", static_cast<signed int>(0xffffffff)},
    {"CONST_VALUE_12", static_cast<signed int>(0x01)},
    {"CONST_VALUE_13", static_cast<signed int>(0X20)},
    {"CONST_VALUE_14", static_cast<signed int>(0x1abc)},
    {"CONST_JAVASCRIPT", static_cast<signed int>(15)},
};


#if ENABLE(Condition1)
COMPILE_ASSERT(0 == TestObj::CONDITIONAL_CONST, TestObjEnumCONDITIONAL_CONSTIsWrongUseDoNotCheckConstants);
#endif
COMPILE_ASSERT(0 == TestObj::CONST_VALUE_0, TestObjEnumCONST_VALUE_0IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == TestObj::CONST_VALUE_1, TestObjEnumCONST_VALUE_1IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == TestObj::CONST_VALUE_2, TestObjEnumCONST_VALUE_2IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == TestObj::CONST_VALUE_4, TestObjEnumCONST_VALUE_4IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(8 == TestObj::CONST_VALUE_8, TestObjEnumCONST_VALUE_8IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(-1 == TestObj::CONST_VALUE_9, TestObjEnumCONST_VALUE_9IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT("my constant string" == TestObj::CONST_VALUE_10, TestObjEnumCONST_VALUE_10IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0xffffffff == TestObj::CONST_VALUE_11, TestObjEnumCONST_VALUE_11IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x01 == TestObj::CONST_VALUE_12, TestObjEnumCONST_VALUE_12IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0X20 == TestObj::CONST_VALUE_13, TestObjEnumCONST_VALUE_13IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x1abc == TestObj::CONST_VALUE_14, TestObjEnumCONST_VALUE_14IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(15 == TestObj::CONST_IMPL, TestObjEnumCONST_IMPLIsWrongUseDoNotCheckConstants);

v8::Handle<v8::Value> V8TestObj::constructorCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.Constructor");
    
    if (!args.IsConstructCall())
        return throwTypeError("DOM object constructor cannot be called as a function.");

    if (ConstructorMode::current() == ConstructorMode::WrapExistingObject)
        return args.Holder();
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    if (args.Length() <= 0 || !args[0]->IsFunction())
        return throwTypeError(0, args.GetIsolate());
    RefPtr<TestCallback> testCallback = V8TestCallback::create(args[0], getScriptExecutionContext());

    RefPtr<TestObj> impl = TestObj::create(testCallback);
    v8::Handle<v8::Object> wrapper = args.Holder();

    V8DOMWrapper::createDOMWrapper(impl.release(), &info, wrapper, args.GetIsolate());
    return wrapper;
}

static v8::Persistent<v8::FunctionTemplate> ConfigureV8TestObjTemplate(v8::Persistent<v8::FunctionTemplate> desc)
{
    desc->ReadOnlyPrototype();

    v8::Local<v8::Signature> defaultSignature;
    defaultSignature = V8DOMConfiguration::configureTemplate(desc, "TestObject", v8::Persistent<v8::FunctionTemplate>(), V8TestObj::internalFieldCount,
        V8TestObjAttrs, WTF_ARRAY_LENGTH(V8TestObjAttrs),
        V8TestObjCallbacks, WTF_ARRAY_LENGTH(V8TestObjCallbacks));
    UNUSED_PARAM(defaultSignature); // In some cases, it will not be used.
    desc->SetCallHandler(V8TestObj::constructorCallback);
    v8::Local<v8::ObjectTemplate> instance = desc->InstanceTemplate();
    v8::Local<v8::ObjectTemplate> proto = desc->PrototypeTemplate();
    UNUSED_PARAM(instance); // In some cases, it will not be used.
    UNUSED_PARAM(proto); // In some cases, it will not be used.
    
    if (RuntimeEnabledFeatures::enabledAtRuntimeAttr1Enabled()) {
        static const V8DOMConfiguration::BatchedAttribute attrData =\
        // Attribute 'enabledAtRuntimeAttr1' (Type: 'attribute' ExtAttr: 'V8EnabledAtRuntime')
        {"enabledAtRuntimeAttr1", TestObjV8Internal::enabledAtRuntimeAttr1AttrGetter, TestObjV8Internal::enabledAtRuntimeAttr1AttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */};
        V8DOMConfiguration::configureAttribute(instance, proto, attrData);
    }
    if (RuntimeEnabledFeatures::featureNameEnabled()) {
        static const V8DOMConfiguration::BatchedAttribute attrData =\
        // Attribute 'enabledAtRuntimeAttr2' (Type: 'attribute' ExtAttr: 'V8EnabledAtRuntime')
        {"enabledAtRuntimeAttr2", TestObjV8Internal::enabledAtRuntimeAttr2AttrGetter, TestObjV8Internal::enabledAtRuntimeAttr2AttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */};
        V8DOMConfiguration::configureAttribute(instance, proto, attrData);
    }

    // Custom Signature 'voidMethodWithArgs'
    const int voidMethodWithArgsArgc = 3;
    v8::Handle<v8::FunctionTemplate> voidMethodWithArgsArgv[voidMethodWithArgsArgc] = { v8::Handle<v8::FunctionTemplate>(), v8::Handle<v8::FunctionTemplate>(), V8TestObj::GetRawTemplate() };
    v8::Handle<v8::Signature> voidMethodWithArgsSignature = v8::Signature::New(desc, voidMethodWithArgsArgc, voidMethodWithArgsArgv);
    proto->Set(v8::String::NewSymbol("voidMethodWithArgs"), v8::FunctionTemplate::New(TestObjV8Internal::voidMethodWithArgsCallback, v8Undefined(), voidMethodWithArgsSignature));

    // Custom Signature 'longMethodWithArgs'
    const int longMethodWithArgsArgc = 3;
    v8::Handle<v8::FunctionTemplate> longMethodWithArgsArgv[longMethodWithArgsArgc] = { v8::Handle<v8::FunctionTemplate>(), v8::Handle<v8::FunctionTemplate>(), V8TestObj::GetRawTemplate() };
    v8::Handle<v8::Signature> longMethodWithArgsSignature = v8::Signature::New(desc, longMethodWithArgsArgc, longMethodWithArgsArgv);
    proto->Set(v8::String::NewSymbol("longMethodWithArgs"), v8::FunctionTemplate::New(TestObjV8Internal::longMethodWithArgsCallback, v8Undefined(), longMethodWithArgsSignature));

    // Custom Signature 'objMethodWithArgs'
    const int objMethodWithArgsArgc = 3;
    v8::Handle<v8::FunctionTemplate> objMethodWithArgsArgv[objMethodWithArgsArgc] = { v8::Handle<v8::FunctionTemplate>(), v8::Handle<v8::FunctionTemplate>(), V8TestObj::GetRawTemplate() };
    v8::Handle<v8::Signature> objMethodWithArgsSignature = v8::Signature::New(desc, objMethodWithArgsArgc, objMethodWithArgsArgv);
    proto->Set(v8::String::NewSymbol("objMethodWithArgs"), v8::FunctionTemplate::New(TestObjV8Internal::objMethodWithArgsCallback, v8Undefined(), objMethodWithArgsSignature));

    // Custom Signature 'methodWithSequenceArg'
    const int methodWithSequenceArgArgc = 1;
    v8::Handle<v8::FunctionTemplate> methodWithSequenceArgArgv[methodWithSequenceArgArgc] = { V8sequence<ScriptProfile>::GetRawTemplate() };
    v8::Handle<v8::Signature> methodWithSequenceArgSignature = v8::Signature::New(desc, methodWithSequenceArgArgc, methodWithSequenceArgArgv);
    proto->Set(v8::String::NewSymbol("methodWithSequenceArg"), v8::FunctionTemplate::New(TestObjV8Internal::methodWithSequenceArgCallback, v8Undefined(), methodWithSequenceArgSignature));

    // Custom Signature 'methodThatRequiresAllArgsAndThrows'
    const int methodThatRequiresAllArgsAndThrowsArgc = 2;
    v8::Handle<v8::FunctionTemplate> methodThatRequiresAllArgsAndThrowsArgv[methodThatRequiresAllArgsAndThrowsArgc] = { v8::Handle<v8::FunctionTemplate>(), V8TestObj::GetRawTemplate() };
    v8::Handle<v8::Signature> methodThatRequiresAllArgsAndThrowsSignature = v8::Signature::New(desc, methodThatRequiresAllArgsAndThrowsArgc, methodThatRequiresAllArgsAndThrowsArgv);
    proto->Set(v8::String::NewSymbol("methodThatRequiresAllArgsAndThrows"), v8::FunctionTemplate::New(TestObjV8Internal::methodThatRequiresAllArgsAndThrowsCallback, v8Undefined(), methodThatRequiresAllArgsAndThrowsSignature));
    desc->Set(v8::String::NewSymbol("classMethod"), v8::FunctionTemplate::New(TestObjV8Internal::classMethodCallback, v8Undefined(), v8::Local<v8::Signature>()));
    desc->Set(v8::String::NewSymbol("classMethodWithOptional"), v8::FunctionTemplate::New(TestObjV8Internal::classMethodWithOptionalCallback, v8Undefined(), v8::Local<v8::Signature>()));
    desc->Set(v8::String::NewSymbol("classMethod2"), v8::FunctionTemplate::New(V8TestObj::classMethod2Callback, v8Undefined(), v8::Local<v8::Signature>()));
#if ENABLE(Condition1)
    desc->Set(v8::String::NewSymbol("overloadedMethod1"), v8::FunctionTemplate::New(TestObjV8Internal::overloadedMethod1Callback, v8Undefined(), v8::Local<v8::Signature>()));
#endif // ENABLE(Condition1)
    if (RuntimeEnabledFeatures::enabledAtRuntimeMethod1Enabled())
        proto->Set(v8::String::NewSymbol("enabledAtRuntimeMethod1"), v8::FunctionTemplate::New(TestObjV8Internal::enabledAtRuntimeMethod1Callback, v8Undefined(), defaultSignature));
    if (RuntimeEnabledFeatures::featureNameEnabled())
        proto->Set(v8::String::NewSymbol("enabledAtRuntimeMethod2"), v8::FunctionTemplate::New(TestObjV8Internal::enabledAtRuntimeMethod2Callback, v8Undefined(), defaultSignature));

    // Custom Signature 'convert1'
    const int convert1Argc = 1;
    v8::Handle<v8::FunctionTemplate> convert1Argv[convert1Argc] = { V8a::GetRawTemplate() };
    v8::Handle<v8::Signature> convert1Signature = v8::Signature::New(desc, convert1Argc, convert1Argv);
    proto->Set(v8::String::NewSymbol("convert1"), v8::FunctionTemplate::New(TestObjV8Internal::convert1Callback, v8Undefined(), convert1Signature));

    // Custom Signature 'convert2'
    const int convert2Argc = 1;
    v8::Handle<v8::FunctionTemplate> convert2Argv[convert2Argc] = { V8b::GetRawTemplate() };
    v8::Handle<v8::Signature> convert2Signature = v8::Signature::New(desc, convert2Argc, convert2Argv);
    proto->Set(v8::String::NewSymbol("convert2"), v8::FunctionTemplate::New(TestObjV8Internal::convert2Callback, v8Undefined(), convert2Signature));

    // Custom Signature 'convert4'
    const int convert4Argc = 1;
    v8::Handle<v8::FunctionTemplate> convert4Argv[convert4Argc] = { V8d::GetRawTemplate() };
    v8::Handle<v8::Signature> convert4Signature = v8::Signature::New(desc, convert4Argc, convert4Argv);
    proto->Set(v8::String::NewSymbol("convert4"), v8::FunctionTemplate::New(TestObjV8Internal::convert4Callback, v8Undefined(), convert4Signature));

    // Custom Signature 'convert5'
    const int convert5Argc = 1;
    v8::Handle<v8::FunctionTemplate> convert5Argv[convert5Argc] = { V8e::GetRawTemplate() };
    v8::Handle<v8::Signature> convert5Signature = v8::Signature::New(desc, convert5Argc, convert5Argv);
    proto->Set(v8::String::NewSymbol("convert5"), v8::FunctionTemplate::New(TestObjV8Internal::convert5Callback, v8Undefined(), convert5Signature));

    // Custom Signature 'variadicNodeMethod'
    const int variadicNodeMethodArgc = 2;
    v8::Handle<v8::FunctionTemplate> variadicNodeMethodArgv[variadicNodeMethodArgc] = { V8Node::GetRawTemplate(), V8Node::GetRawTemplate() };
    v8::Handle<v8::Signature> variadicNodeMethodSignature = v8::Signature::New(desc, variadicNodeMethodArgc, variadicNodeMethodArgv);
    proto->Set(v8::String::NewSymbol("variadicNodeMethod"), v8::FunctionTemplate::New(TestObjV8Internal::variadicNodeMethodCallback, v8Undefined(), variadicNodeMethodSignature));
    V8DOMConfiguration::batchConfigureConstants(desc, proto, V8TestObjConsts, WTF_ARRAY_LENGTH(V8TestObjConsts));

    // Custom toString template
    desc->Set(v8::String::NewSymbol("toString"), V8PerIsolateData::current()->toStringTemplate());
    return desc;
}

v8::Persistent<v8::FunctionTemplate> V8TestObj::GetRawTemplate()
{
    V8PerIsolateData* data = V8PerIsolateData::current();
    V8PerIsolateData::TemplateMap::iterator result = data->rawTemplateMap().find(&info);
    if (result != data->rawTemplateMap().end())
        return result->value;

    v8::HandleScope handleScope;
    v8::Persistent<v8::FunctionTemplate> templ = createRawTemplate();
    data->rawTemplateMap().add(&info, templ);
    return templ;
}

v8::Persistent<v8::FunctionTemplate> V8TestObj::GetTemplate()
{
    V8PerIsolateData* data = V8PerIsolateData::current();
    V8PerIsolateData::TemplateMap::iterator result = data->templateMap().find(&info);
    if (result != data->templateMap().end())
        return result->value;

    v8::HandleScope handleScope;
    v8::Persistent<v8::FunctionTemplate> templ =
        ConfigureV8TestObjTemplate(GetRawTemplate());
    data->templateMap().add(&info, templ);
    return templ;
}

bool V8TestObj::HasInstance(v8::Handle<v8::Value> value)
{
    return GetRawTemplate()->HasInstance(value);
}

void V8TestObj::installPerContextProperties(v8::Handle<v8::Object> instance, TestObj* impl)
{
    v8::Local<v8::Object> proto = v8::Local<v8::Object>::Cast(instance->GetPrototype());
    // When building QtWebkit with V8 this variable is unused when none of the features are enabled.
    UNUSED_PARAM(proto);
    if (ContextFeatures::enabledPerContextAttr1Enabled(impl->document())) {
        static const V8DOMConfiguration::BatchedAttribute attrData =\
        // Attribute 'enabledPerContextAttr1' (Type: 'attribute' ExtAttr: 'V8EnabledPerContext')
        {"enabledPerContextAttr1", TestObjV8Internal::enabledPerContextAttr1AttrGetter, TestObjV8Internal::enabledPerContextAttr1AttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */};
        V8DOMConfiguration::configureAttribute(instance, proto, attrData);
    }
    if (ContextFeatures::featureNameEnabled(impl->document())) {
        static const V8DOMConfiguration::BatchedAttribute attrData =\
        // Attribute 'enabledPerContextAttr2' (Type: 'attribute' ExtAttr: 'V8EnabledPerContext')
        {"enabledPerContextAttr2", TestObjV8Internal::enabledPerContextAttr2AttrGetter, TestObjV8Internal::enabledPerContextAttr2AttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */};
        V8DOMConfiguration::configureAttribute(instance, proto, attrData);
    }
}
void V8TestObj::installPerContextPrototypeProperties(v8::Handle<v8::Object> proto)
{
    UNUSED_PARAM(proto);
    v8::Local<v8::Signature> defaultSignature = v8::Signature::New(GetTemplate());
    UNUSED_PARAM(defaultSignature); // In some cases, it will not be used.

    ScriptExecutionContext* context = toScriptExecutionContext(proto->CreationContext());
    if (context && context->isDocument() && ContextFeatures::enabledPerContextMethod1Enabled(static_cast<Document*>(context))) {
        proto->Set(v8::String::NewSymbol("enabledPerContextMethod1"), v8::FunctionTemplate::New(TestObjV8Internal::enabledPerContextMethod1Callback, v8Undefined(), defaultSignature)->GetFunction());
    }
    if (context && context->isDocument() && ContextFeatures::featureNameEnabled(static_cast<Document*>(context))) {
        proto->Set(v8::String::NewSymbol("enabledPerContextMethod2"), v8::FunctionTemplate::New(TestObjV8Internal::enabledPerContextMethod2Callback, v8Undefined(), defaultSignature)->GetFunction());
    }
}

v8::Handle<v8::Object> V8TestObj::createWrapper(PassRefPtr<TestObj> impl, v8::Handle<v8::Object> creationContext, v8::Isolate* isolate)
{
    ASSERT(impl.get());
    ASSERT(DOMDataStore::current(isolate)->get(impl.get()).IsEmpty());

    v8::Handle<v8::Object> wrapper = V8DOMWrapper::instantiateV8Object(creationContext, &info, impl.get());
    if (UNLIKELY(wrapper.IsEmpty()))
        return wrapper;

    installPerContextProperties(wrapper, impl.get());
    v8::Persistent<v8::Object> wrapperHandle = V8DOMWrapper::createDOMWrapper(impl, &info, wrapper, isolate);
    if (!hasDependentLifetime)
        wrapperHandle.MarkIndependent();
    return wrapper;
}

void V8TestObj::derefObject(void* object)
{
    static_cast<TestObj*>(object)->deref();
}

} // namespace WebCore
