/*
 * Copyright (C) 2010 Apple Inc. All rights reserved.
 * Copyright (C) 2010 Patrick Gansterer <paroga@paroga.com>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "PlatformStrategiesWinCE.h"

#include "IntSize.h"
#include "Page.h"
#include "PageGroup.h"
#include "PlatformCookieJar.h"
#include "PluginDatabase.h"

using namespace WebCore;

void PlatformStrategiesWinCE::initialize()
{
    DEFINE_STATIC_LOCAL(PlatformStrategiesWinCE, platformStrategies, ());
}

PlatformStrategiesWinCE::PlatformStrategiesWinCE()
{
    setPlatformStrategies(this);
}

CookiesStrategy* PlatformStrategiesWinCE::createCookiesStrategy()
{
    return this;
}

LoaderStrategy* PlatformStrategiesWinCE::createLoaderStrategy()
{
    return this;
}

PasteboardStrategy* PlatformStrategiesWinCE::createPasteboardStrategy()
{
    return 0;
}

PluginStrategy* PlatformStrategiesWinCE::createPluginStrategy()
{
    return this;
}

SharedWorkerStrategy* PlatformStrategiesWinCE::createSharedWorkerStrategy()
{
    return this;
}

VisitedLinkStrategy* PlatformStrategiesWinCE::createVisitedLinkStrategy()
{
    return this;
}

void PlatformStrategiesWinCE::notifyCookiesChanged()
{
}

String PlatformStrategiesWinCE::cookiesForDOM(NetworkingContext* context, const KURL& firstParty, const KURL& url)
{
    return WebCore::cookiesForDOM(context, firstParty, url);
}

void PlatformStrategiesWinCE::setCookiesFromDOM(NetworkingContext* context, const KURL& firstParty, const KURL& url, const String& cookieString)
{
    WebCore::setCookiesFromDOM(context, firstParty, url, cookieString);
}

bool PlatformStrategiesWinCE::cookiesEnabled(NetworkingContext* context, const KURL& firstParty, const KURL& url)
{
    return WebCore::cookiesEnabled(context, firstParty, url);
}

String PlatformStrategiesWinCE::cookieRequestHeaderFieldValue(NetworkingContext* context, const KURL& firstParty, const KURL& url)
{
    return WebCore::cookieRequestHeaderFieldValue(context, firstParty, url);
}

bool PlatformStrategiesWinCE::getRawCookies(NetworkingContext* context, const KURL& firstParty, const KURL& url, Vector<Cookie>& rawCookies)
{
    return WebCore::getRawCookies(context, firstParty, url, rawCookies);
}

void PlatformStrategiesWinCE::deleteCookie(NetworkingContext* context, const KURL& url, const String& cookieName)
{
    WebCore::deleteCookie(context, url, cookieName);
}

void PlatformStrategiesWinCE::getHostnamesWithCookies(NetworkingContext* context, HashSet<String>& hostnames)
{
    WebCore::getHostnamesWithCookies(context, hostnames);
}

void PlatformStrategiesWinCE::deleteCookiesForHostname(NetworkingContext* context, const String& hostname)
{
    WebCore::deleteCookiesForHostname(context, hostname);
}

void PlatformStrategiesWinCE::deleteAllCookies(NetworkingContext* context)
{
    WebCore::deleteAllCookies(context);
}

void PlatformStrategiesWinCE::refreshPlugins()
{
    PluginDatabase::installedPlugins()->refresh();
}

void PlatformStrategiesWinCE::getPluginInfo(const Page*, Vector<PluginInfo>& outPlugins)
{
    const Vector<PluginPackage*>& plugins = PluginDatabase::installedPlugins()->plugins();

    outPlugins.resize(plugins.size());

    for (size_t i = 0; i < plugins.size(); ++i) {
        PluginPackage* package = plugins[i];

        PluginInfo info;
        info.name = package->name();
        info.file = package->fileName();
        info.desc = package->description();

        const MIMEToDescriptionsMap& mimeToDescriptions = package->mimeToDescriptions();

        info.mimes.reserveCapacity(mimeToDescriptions.size());

        MIMEToDescriptionsMap::const_iterator end = mimeToDescriptions.end();
        for (MIMEToDescriptionsMap::const_iterator it = mimeToDescriptions.begin(); it != end; ++it) {
            MimeClassInfo mime;

            mime.type = it->key;
            mime.desc = it->value;
            mime.extensions = package->mimeToExtensions().get(mime.type);

            info.mimes.append(mime);
        }

        outPlugins[i] = info;
    }
}

bool PlatformStrategiesWinCE::isLinkVisited(Page* page, LinkHash hash, const KURL&, const AtomicString&)
{
    return page->group().isLinkVisited(hash);
}

void PlatformStrategiesWinCE::addVisitedLink(Page* page, LinkHash hash)
{
    page->group().addVisitedLinkHash(hash);
}
