# 0.0.28

**Version:** 0.0.28
**Published:** 2024-11-16T19:37:15Z

## Release Notes

### 📦 **Rust Coreutils 0.0.28 Release:**

We are thrilled to announce the release of **Rust Coreutils 0.0.28**! This release brings significant improvements in compatibility and stability, continuing our journey to provide a robust alternative to GNU Coreutils.

### Highlights:
- **Improved Compatibility**:
  - Passing GNU tests increased to **476** (+21 compared to 0.0.27).
  - Failing tests reduced to **94** (-19 compared to 0.0.27).
- **Contributions**: This release was made possible by the hard work of **37 contributors**, including 16 newcomers.
- **Enhanced Performance**: Updates and optimizations in utilities like `cksum`, `mkdir`, and `tr`.

### GNU Test Suite Compatibility:
Here’s how version 0.0.28 compares to the previous release:


| Result        | 0.0.27 | 0.0.28 | Change 0.0.27 to 0.0.28 | % Total 0.0.27 | % Total 0.0.28 | % Change 0.0.27 to 0.0.28 |
|---------------|--------|--------|-------------------------|----------------|----------------|--------------------------|
| Pass          | 455    | 476    | +21                    | 74.35%         | 77.65%         | +3.30%                   |
| Skip          | 44     | 43     | -1                     | 7.19%          | 7.01%          | -0.18%                   |
| Fail          | 113    | 94     | -19                    | 18.46%         | 15.34%         | -3.12%                   |
| Error         | 0      | 0      | 0                      | 0.00%          | 0.00%          | 0.00%                    |

![GNU testsuite evolution](https://github.com/uutils/coreutils-tracking/blob/main/gnu-results.png?raw=true)

### Call to Action:
Support our work by sponsoring us on GitHub! Your contributions help maintain our infrastructure and enable faster iterations. [Sponsor us here](https://github.com/sponsors/uutils).

For more details and to download the latest release, visit our website: [https://uutils.github.io](https://uutils.github.io).


## What's Changed

## GNU Test Suite Compatibility
### `basenc`
* Perform faster, streaming encoding by @andrewliebenow in [#6719](https://github.com/uutils/coreutils/pull/6719)

### `cat`
* Fix issue #6248 by @OshinoShinobu-Chan in [#6763](https://github.com/uutils/coreutils/pull/6763)
* Use `write_end_of_line()` to avoid duplicate code by @cakebaker in [#6764](https://github.com/uutils/coreutils/pull/6764)
* Fix issue #5186 by adding explicit flush by @gim913 in [#5256](https://github.com/uutils/coreutils/pull/5256)

### `cksum` / `hashsum`
* Add support for `--check` with base64 and other improvements by @sylvestre in [#6452](https://github.com/uutils/coreutils/pull/6452)
* Accept non-UTF-8 filenames by @BenWiederhake in [#6575](https://github.com/uutils/coreutils/pull/6575)
* Support commented lines in checksum files by @RenjiSann in [#6782](https://github.com/uutils/coreutils/pull/6782)
* Fix error handling by @Luv-Ray in [#6801](https://github.com/uutils/coreutils/pull/6801)
* Implement `-z` / `--zero` by @RenjiSann in [#6815](https://github.com/uutils/coreutils/pull/6815)
* Read the next file when the first is missing or invalid by @sylvestre in [#6524](https://github.com/uutils/coreutils/pull/6524)
* Support non-UTF-8 input in checksum files by @RenjiSann in [#6793](https://github.com/uutils/coreutils/pull/6793)

### `cp`
* Fix preserved hardlinks not being reported in `--verbose` mode by @djedi23 in [#6496](https://github.com/uutils/coreutils/pull/6496)
* Improve GNU test case compatibility for `part-symlink` by @matrixhead in [#6588](https://github.com/uutils/coreutils/pull/6588)
* Treat an empty file name as a non-existing file by @samueltardieu in [#6683](https://github.com/uutils/coreutils/pull/6683)
* Show mode if the target does not have `S_IWUSR` by @andrewliebenow in [#6700](https://github.com/uutils/coreutils/pull/6700)
* Fix possible OOM and partial writes with large files by @neyo8826 in [#6694](https://github.com/uutils/coreutils/pull/6694)
* Fix symlink-overwrite error priority by @Luv-Ray in [#6586](https://github.com/uutils/coreutils/pull/6586)
* Normalize path when checking for duplicate source by @matrixhead in [#6825](https://github.com/uutils/coreutils/pull/6825)
* Add argument count validation for `cp` by @LoricAndre in [#6690](https://github.com/uutils/coreutils/pull/6690)

### `date`
* Fix timezone error when setting UTC time by @CausingBrick in [#6503](https://github.com/uutils/coreutils/pull/6503)
* Add test for `date` by @Its-Just-Nans in [#6526](https://github.com/uutils/coreutils/pull/6526)
* Add tests for issue #6392 by @RenjiSann in [#6471](https://github.com/uutils/coreutils/pull/6471)

### `dd`
* Fix issue #5905 (different error message from GNU) by @just-an-engineer in [#6622](https://github.com/uutils/coreutils/pull/6622)

### `dircolors`
* Optimize integer and string operations required by clippy nightly by @BenWiederhake in [#6636](https://github.com/uutils/coreutils/pull/6636)

### `echo`
* Handle multibyte escape sequences by @andrewliebenow in [#6803](https://github.com/uutils/coreutils/pull/6803)
* Remove double negation by @cakebaker in [#6810](https://github.com/uutils/coreutils/pull/6810)

### `hashsum`
* When checksum file is untagged, detect the size by @sylvestre in [#6499](https://github.com/uutils/coreutils/pull/6499)
* On Windows, check in binary mode by default and allow `--binary` / `--text` by @Pistonight in [#6808](https://github.com/uutils/coreutils/pull/6808)
* Return error when only `--strict` or `--quiet` is given by @howjmay in [#6584](https://github.com/uutils/coreutils/pull/6584)

### `hostname`
* Use `dns-lookup` crate to get network address(es) of the host by @lcheylus in [#6550](https://github.com/uutils/coreutils/pull/6550)

### `join`
* Add support for multibyte separators by @jtracey in [#6736](https://github.com/uutils/coreutils/pull/6736)
* Avoid extra allocations when using `-i` by @jtracey in [#6774](https://github.com/uutils/coreutils/pull/6774)

### `ls`
* Adjust code for `--dired` after GNU v9.5 changes by @sylvestre in [#6144](https://github.com/uutils/coreutils/pull/6144)
* Fix GNU test case `color-norm` by @matrixhead in [#6481](https://github.com/uutils/coreutils/pull/6481)
* Fix error in subdirectory output by @CausingBrick in [#6521](https://github.com/uutils/coreutils/pull/6521)
* Fix `dired` option (`-D`) not outputting datetime and parent directory byte offsets by @pyoky in [#6538](https://github.com/uutils/coreutils/pull/6538)
* Use tab when `-CF` is passed (closes #5396) by @sylvestre in [#6528](https://github.com/uutils/coreutils/pull/6528)
* Fix GNU test case `color-clear-to-eol` by @matrixhead in [#6507](https://github.com/uutils/coreutils/pull/6507)
* Refactor `parse_width` function by @matrixhead in [#6510](https://github.com/uutils/coreutils/pull/6510)
* Add test for `ls` by @Its-Just-Nans in [#6527](https://github.com/uutils/coreutils/pull/6527)
* Fix GNU test case `color-ext` by @matrixhead in [#6537](https://github.com/uutils/coreutils/pull/6537)
* Fix quoting for directory names with a colon (`:`) in recursive mode and patch the `quote-align` GNU test by @RenjiSann in [#6559](https://github.com/uutils/coreutils/pull/6559)
* Change `unwrap_or` and `or` to lazy-evaluated `unwrap_or_else` and `or_else` by @AnirbanHalder654322 in [#6609](https://github.com/uutils/coreutils/pull/6609)

### `ln`
* Allow final destination directory when using `-nf` by @jansheikkinen in [#5975](https://github.com/uutils/coreutils/pull/5975)

### `mkdir`
* Add `acl` permissions inheritance for subdirectories by @AnirbanHalder654322 in [#6676](https://github.com/uutils/coreutils/pull/6676)
* Prevent mode change of existing directories by @samueltardieu in [#6682](https://github.com/uutils/coreutils/pull/6682)
* Require arguments for `mkdir` and `rmdir` by @sgvictorino in [#6790](https://github.com/uutils/coreutils/pull/6790)
* Emit error when path is empty by @andrewliebenow in [#6802](https://github.com/uutils/coreutils/pull/6802)
* Allow `--parent` to be provided more than once by @DaringCuteSeal in [#6831](https://github.com/uutils/coreutils/pull/6831)

### `mv`
* Fix GNU test case `to-symlink` by @matrixhead in [#6578](https://github.com/uutils/coreutils/pull/6578)
* Clean up inter-partition copying test code by @matrixhead in [#6583](https://github.com/uutils/coreutils/pull/6583)
* Adjust error message to pass `tests/mv/mv-exchange.sh` by @sylvestre in [#6641](https://github.com/uutils/coreutils/pull/6641)
* Fix GNU test case `mv-n` compatibility by @matrixhead in [#6599](https://github.com/uutils/coreutils/pull/6599)
* Fix GNU test case `dup-src` compatibility by @matrixhead in [#6837](https://github.com/uutils/coreutils/pull/6837)

### `od`
* Allow trailing characters in address radix by @andrewliebenow in [#6674](https://github.com/uutils/coreutils/pull/6674)
* Prevent panic on empty address radix by @andrewliebenow in [#6675](https://github.com/uutils/coreutils/pull/6675)

### `paste`
* Permit the delimiter list to be empty by @andrewliebenow in [#6714](https://github.com/uutils/coreutils/pull/6714)

### `printf`
* Check precision before writing to stdout (fix #1879) by @Kev1n8 in [#6511](https://github.com/uutils/coreutils/pull/6511)
* Remove unused argument name from help by @andrewliebenow in [#6807](https://github.com/uutils/coreutils/pull/6807)
* Fix extra padding by @Kev1n8 in [#6548](https://github.com/uutils/coreutils/pull/6548)
* Delete unused file by @BenWiederhake in [#6758](https://github.com/uutils/coreutils/pull/6758)

### `runcon`
* Adjust error message for `runcon` and `stdbuf` to pass `tests/misc/invalid-opt.pl` by @sylvestre in [#6657](https://github.com/uutils/coreutils/pull/6657)
* Improve help message for `runcon` by @cakebaker in [#6680](https://github.com/uutils/coreutils/pull/6680)

### `sort`
* Improve error management with `--batch-size` by @sylvestre in [#6535](https://github.com/uutils/coreutils/pull/6535)

### `sync`
* Replace `crash!` with `USimpleError` by @Kev1n8 in [#6547](https://github.com/uutils/coreutils/pull/6547)

### `test`
* Ensure `-o` argument triggers an error by @sylvestre in [#6642](https://github.com/uutils/coreutils/pull/6642)
* Avoid eliding named lifetimes in tests by @samueltardieu in [#6678](https://github.com/uutils/coreutils/pull/6678)
* Fix "unused imports" warning on Redox by @cakebaker in [#5930](https://github.com/uutils/coreutils/pull/5930)

### `touch`
* Change message when touching a directory by @Its-Just-Nans in [#6506](https://github.com/uutils/coreutils/pull/6506)
* Expose `touch` for Nushell by @ysthakur in [#5946](https://github.com/uutils/coreutils/pull/5946)

### `uptime`
* Add support for OpenBSD using `utmp` by @lcheylus in [#6514](https://github.com/uutils/coreutils/pull/6514)
* Relax error message due to differing `errno` values on macOS by @BenWiederhake in [#6571](https://github.com/uutils/coreutils/pull/6571)

### `users`
* Support OpenBSD using `utmp` by @jadijadi in [#6406](https://github.com/uutils/coreutils/pull/6406)
* Fix lint error `needless_borrows_for_generic_args` on OpenBSD by @lcheylus in [#6509](https://github.com/uutils/coreutils/pull/6509)
* Use `Option` instead of `Vec` for file argument by @cakebaker in [#6761](https://github.com/uutils/coreutils/pull/6761)
* Fix lint error `manual_unwrap_or_default` on OpenBSD by @lcheylus in [#6772](https://github.com/uutils/coreutils/pull/6772)

### `tr`
* Properly determine trailing backslash by @BenWiederhake in [#6731](https://github.com/uutils/coreutils/pull/6731)
* Enable ignored test on Unix by @cakebaker in [#6737](https://github.com/uutils/coreutils/pull/6737)
* Raise error if `set2` is too big on complemented class by @RenjiSann in [#6564](https://github.com/uutils/coreutils/pull/6564)
* Accept non-UTF-8 arguments for sets by @RenjiSann in [#6563](https://github.com/uutils/coreutils/pull/6563)
* Fix unescaped trailing backslash warning by @andrewliebenow in [#6713](https://github.com/uutils/coreutils/pull/6713)
* Correctly handle multibyte octal sequences by @andrewliebenow in [#6779](https://github.com/uutils/coreutils/pull/6779)
* Correctly detect matched `[:upper:]` by @cvonelm in [#6513](https://github.com/uutils/coreutils/pull/6513)
* Enable ignored tests that have already been fixed by @BenWiederhake in [#6756](https://github.com/uutils/coreutils/pull/6756)

### `tsort`
* Propose refactoring for `tsort` by @anastygnome in [#5968](https://github.com/uutils/coreutils/pull/5968)
* Adjust error message in `tsort.pl` by @sylvestre in [#6785](https://github.com/uutils/coreutils/pull/6785)


### uucore

* uucore: Split `tty` from `proc_info` by @Krysztal112233 in https://github.com/uutils/coreutils/pull/6593
* uucore: Fix return value of `ProcessInfomation::tty` by @Krysztal112233 in https://github.com/uutils/coreutils/pull/6597
* uucore: Add `getsid` for `process.rs` by @Krysztal112233 in https://github.com/uutils/coreutils/pull/6600
* fsext: remove crash! by @Kev1n8 in https://github.com/uutils/coreutils/pull/6549
* uucore+timeout: accept signals of any casing by @BenWiederhake in https://github.com/uutils/coreutils/pull/6382
* uucore: Move `pgrep/process.rs` to `uucore` by @Krysztal112233 in https://github.com/uutils/coreutils/pull/6483
* uucore/proc_info: ignore spelling of some words by @cakebaker in https://github.com/uutils/coreutils/pull/6561
* uucore: fix "unused import" warning on Redox by @cakebaker in https://github.com/uutils/coreutils/pull/6695
* uucore/checksum: simplify `determine_regex()` by @cakebaker in https://github.com/uutils/coreutils/pull/6500
* uucore: allow use of deprecated `PanicInfo` by @cakebaker in https://github.com/uutils/coreutils/pull/6792
* uucore: disable default signal-handlers added by Rust by @Ecordonnier in https://github.com/uutils/coreutils/pull/6806






### Misc
* bin/coreutils: add `--list` to help output by @cakebaker in https://github.com/uutils/coreutils/pull/6692
* prepare version 0.0.28 by @sylvestre in https://github.com/uutils/coreutils/pull/6844
* Use `workspace = true` for some dependencies by @cakebaker in https://github.com/uutils/coreutils/pull/6601
* sort: enable clippy::suspicious_open_options on OpenBSD by @lcheylus in https://github.com/uutils/coreutils/pull/6851
* Fix clippy errors by @Its-Just-Nans in https://github.com/uutils/coreutils/pull/6505
* Fix nightly clippy by @BenWiederhake in https://github.com/uutils/coreutils/pull/6581
* fuzz: run GNU Core Utilities with LC_ALL=C by @andrewliebenow in https://github.com/uutils/coreutils/pull/6795
* Disable failed tests on OpenBSD by @lcheylus in https://github.com/uutils/coreutils/pull/6545
* build.rs: skip "expensive_tests", not a crate by @cakebaker in https://github.com/uutils/coreutils/pull/6518
* build all features on docs.rs by @Its-Just-Nans in https://github.com/uutils/coreutils/pull/6502
* Cargo.toml: add "expensive_tests" feature by @cakebaker in https://github.com/uutils/coreutils/pull/6498
* clippy: fix warnings introduced by Rust 1.80 by @cakebaker in https://github.com/uutils/coreutils/pull/6592
* Cargo.toml: allow "fuzzing" as `cfg` condition name by @cakebaker in https://github.com/uutils/coreutils/pull/6497
* Change the git pre-commit actions to *actually* use stable by @BenWiederhake in https://github.com/uutils/coreutils/pull/6754
* Try to use linux high perf runners by @sylvestre in https://github.com/uutils/coreutils/pull/6556
* Revert "Try to use linux high perf runners" by @sylvestre in https://github.com/uutils/coreutils/pull/6557
* fuzzing: add `Cargo.lock` by @cakebaker in https://github.com/uutils/coreutils/pull/6652
* Fix clippy warnings. by @dcampbell24 in https://github.com/uutils/coreutils/pull/6716
* move lints from rustflags to Cargo.toml by @jtracey in https://github.com/uutils/coreutils/pull/6751
* Clippy Pedantic Acceptable Commits Try Again by @dcampbell24 in https://github.com/uutils/coreutils/pull/6748
* basename,realpath: add words to `spell-checker:ignore` by @cakebaker in https://github.com/uutils/coreutils/pull/6627
* Do not rebuild the build script unless necessary by @samueltardieu in https://github.com/uutils/coreutils/pull/6677
* Change the git pre-commit actions to work on stable. by @dcampbell24 in https://github.com/uutils/coreutils/pull/6715
* add back use_self clippy warning by @jtracey in https://github.com/uutils/coreutils/pull/6775
* Get rid of redox-specific code by @tea in https://github.com/uutils/coreutils/pull/6787


### CI
* ci: remove temporary code coverage jobs by @cakebaker in https://github.com/uutils/coreutils/pull/6856
* ci: remove unused var from "Code Coverage" job by @cakebaker in https://github.com/uutils/coreutils/pull/6605
* Fix Android CI by @jtracey in https://github.com/uutils/coreutils/pull/6580
* Add windows arm64 to the CI by @sylvestre in https://github.com/uutils/coreutils/pull/6624
* ci: disable broken code coverage on windows by @BenWiederhake in https://github.com/uutils/coreutils/pull/6687
* Android CI: enable emulator metrics by @jtracey in https://github.com/uutils/coreutils/pull/6752
* ci: use ubuntu v24 for GNU tests workflow by @cakebaker in https://github.com/uutils/coreutils/pull/6765
* GNU tests: install attr by @sylvestre in https://github.com/uutils/coreutils/pull/6784
* intermittent: timeout changed directory by @sylvestre in https://github.com/uutils/coreutils/pull/6816
* Use github for gnulib by @sylvestre in https://github.com/uutils/coreutils/pull/6762

### Documentation
* coreutils: Add a default readme for the packages by @lu-zero in https://github.com/uutils/coreutils/pull/6512
* CONTRIBUTE.md: Update broken link and formatting of link by @vikiminki in https://github.com/uutils/coreutils/pull/6776
* add docs - fix #5066 by @Its-Just-Nans in https://github.com/uutils/coreutils/pull/6523
* doc: add and change documentation of uucore by @Its-Just-Nans in https://github.com/uutils/coreutils/pull/6551
* document uucore::Args #5068 by @Its-Just-Nans in https://github.com/uutils/coreutils/pull/6515
* documents functions - #5069 by @Its-Just-Nans in https://github.com/uutils/coreutils/pull/6516
* documentation: fix crate name in README by @andrewliebenow in https://github.com/uutils/coreutils/pull/6800

### Dependencies

* chore(deps): update rust crate num-bigint to v0.4.6 by @renovate in https://github.com/uutils/coreutils/pull/6501
* chore(deps): update vmactions/freebsd-vm action to v1.0.8 by @renovate in https://github.com/uutils/coreutils/pull/6525
* chore(deps): update rust crate serde to v1.0.204 by @renovate in https://github.com/uutils/coreutils/pull/6544
* chore(deps): update rust crate thiserror to v1.0.62 by @renovate in https://github.com/uutils/coreutils/pull/6562
* chore(deps): update reactivecircus/android-emulator-runner action to v2.32.0 by @renovate in https://github.com/uutils/coreutils/pull/6553
* chore(deps): update rust crate blake3 to v1.5.2 by @renovate in https://github.com/uutils/coreutils/pull/6565
* chore(deps): update rust crate blake3 to v1.5.3 by @renovate in https://github.com/uutils/coreutils/pull/6567
* chore(deps): update rust crate redox_syscall to v0.5.3 by @renovate in https://github.com/uutils/coreutils/pull/6568
* chore(deps): update rust crate thiserror to v1.0.63 by @renovate in https://github.com/uutils/coreutils/pull/6579
* chore(deps): update rust crate bstr to v1.10.0 by @renovate in https://github.com/uutils/coreutils/pull/6594
* chore(deps): update rust crate selinux to v0.4.5 by @renovate in https://github.com/uutils/coreutils/pull/6596
* chore(deps): update vmactions/freebsd-vm action to v1.0.9 by @renovate in https://github.com/uutils/coreutils/pull/6679
* chore(deps): update vmactions/freebsd-vm action to v1.1.0 by @renovate in https://github.com/uutils/coreutils/pull/6685
* chore(deps): update davidanson/markdownlint-cli2-action action to v17 by @renovate in https://github.com/uutils/coreutils/pull/6691
* chore(deps): update vmactions/freebsd-vm action to v1.1.1 by @renovate in https://github.com/uutils/coreutils/pull/6698
* chore(deps): update rust crate memmap2 to v0.9.5 by @renovate in https://github.com/uutils/coreutils/pull/6702
* chore(deps): update rust crate fundu to v2.0.1 by @renovate in https://github.com/uutils/coreutils/pull/6701
* chore(deps): update rust crate pretty_assertions to v1.4.1 by @renovate in https://github.com/uutils/coreutils/pull/6703
* chore(deps): update rust crate redox_syscall to v0.5.4 by @renovate in https://github.com/uutils/coreutils/pull/6704
* chore(deps): update rust crate selinux to v0.4.6 by @renovate in https://github.com/uutils/coreutils/pull/6706
* chore(deps): update rust crate rlimit to v0.10.2 by @renovate in https://github.com/uutils/coreutils/pull/6705
* chore(deps): update rust crate serde to v1.0.210 by @renovate in https://github.com/uutils/coreutils/pull/6707
* chore(deps): update rust crate unicode-segmentation to v1.12.0 by @renovate in https://github.com/uutils/coreutils/pull/6709
* chore(deps): update rust crate once_cell to v1.20.0 by @renovate in https://github.com/uutils/coreutils/pull/6708
* chore(deps): update embarkstudios/cargo-deny-action action to v2 by @renovate in https://github.com/uutils/coreutils/pull/6608
* chore(deps): update rust crate regex to v1.10.6 by @renovate in https://github.com/uutils/coreutils/pull/6610
* chore(deps): update rust crate winapi-util to v0.1.9 by @renovate in https://github.com/uutils/coreutils/pull/6611
* chore(deps): update rust crate rust-ini to v0.21.1 by @renovate in https://github.com/uutils/coreutils/pull/6616
* chore(deps): update rust crate rstest to 0.22.0 by @renovate in https://github.com/uutils/coreutils/pull/6619
* chore(deps): update rust crate serde to v1.0.205 by @renovate in https://github.com/uutils/coreutils/pull/6625
* chore(deps): update rust crate serde to v1.0.206 by @renovate in https://github.com/uutils/coreutils/pull/6634
* chore(deps): update rust crate serde to v1.0.207 by @renovate in https://github.com/uutils/coreutils/pull/6643
* chore(deps): update rust crate unicode-width to v0.1.13 by @renovate in https://github.com/uutils/coreutils/pull/6451
* chore(deps): update rust crate serde to v1.0.208 by @renovate in https://github.com/uutils/coreutils/pull/6650
* chore(deps): update rust crate blake3 to v1.5.4 by @renovate in https://github.com/uutils/coreutils/pull/6656
* chore(deps): update rust crate filetime to v0.2.24 by @renovate in https://github.com/uutils/coreutils/pull/6626
* chore(deps): update rust crate serde to v1.0.209 by @renovate in https://github.com/uutils/coreutils/pull/6666
* chore(deps): update rust crate filetime to v0.2.25 by @renovate in https://github.com/uutils/coreutils/pull/6670
* chore(deps): update vmactions/freebsd-vm action to v1.1.2 by @renovate in https://github.com/uutils/coreutils/pull/6723
* chore(deps): update vmactions/freebsd-vm action to v1.1.3 by @renovate in https://github.com/uutils/coreutils/pull/6724
* chore(deps): update rust crate thiserror to v1.0.64 by @renovate in https://github.com/uutils/coreutils/pull/6726
* fix(deps): update rust crate libc to v0.2.159 by @renovate in https://github.com/uutils/coreutils/pull/6733
* chore(deps): update rust crate redox_syscall to v0.5.5 by @renovate in https://github.com/uutils/coreutils/pull/6734
* chore(deps): update rust crate terminal_size to 0.4.0 by @renovate in https://github.com/uutils/coreutils/pull/6735
* chore(deps): update rust crate redox_syscall to v0.5.6 by @renovate in https://github.com/uutils/coreutils/pull/6739
* chore(deps): update mozilla-actions/sccache-action action to v0.0.6 by @renovate in https://github.com/uutils/coreutils/pull/6743
* chore(deps): update rust crate platform-info to v2.0.4 by @renovate in https://github.com/uutils/coreutils/pull/6747
* fix(deps): update rust crate tempfile to v3.13.0 by @renovate in https://github.com/uutils/coreutils/pull/6745
* chore(deps): update rust crate rstest to 0.23.0 by @renovate in https://github.com/uutils/coreutils/pull/6749
* chore(deps): update rust crate regex to v1.11.0 by @renovate in https://github.com/uutils/coreutils/pull/6750
* chore(deps): update rust crate redox_syscall to v0.5.7 by @renovate in https://github.com/uutils/coreutils/pull/6753
* chore(deps): update rust crate lscolors to 0.20.0 by @renovate in https://github.com/uutils/coreutils/pull/6757
* chore(deps): update rust crate once_cell to v1.20.2 by @renovate in https://github.com/uutils/coreutils/pull/6768
* chore(deps): update vmactions/freebsd-vm action to v1.1.4 by @renovate in https://github.com/uutils/coreutils/pull/6769
* chore(deps): update rust crate procfs to 0.17 by @renovate in https://github.com/uutils/coreutils/pull/6770
* chore(deps): update reactivecircus/android-emulator-runner action to v2.33.0 by @renovate in https://github.com/uutils/coreutils/pull/6780
* chore(deps): update rust crate serde to v1.0.211 by @renovate in https://github.com/uutils/coreutils/pull/6809
* chore(deps): update rust crate serde to v1.0.213 by @renovate in https://github.com/uutils/coreutils/pull/6811
* fix(deps): update rust crate proc-macro2 to v1.0.89 by @renovate in https://github.com/uutils/coreutils/pull/6814
* chore(deps): update rust crate thiserror to v1.0.65 by @renovate in https://github.com/uutils/coreutils/pull/6813
* chore(deps): update rust crate regex to v1.11.1 by @renovate in https://github.com/uutils/coreutils/pull/6818
* chore(deps): update rust crate bigdecimal to v0.4.6 by @renovate in https://github.com/uutils/coreutils/pull/6829
* chore(deps): update rust crate serde to v1.0.214 by @renovate in https://github.com/uutils/coreutils/pull/6830
* chore(config): migrate renovate config by @renovate in https://github.com/uutils/coreutils/pull/6834
* chore(deps): update rust crate thiserror to v1.0.66 by @renovate in https://github.com/uutils/coreutils/pull/6835
* chore(deps): update vmactions/freebsd-vm action to v1.1.5 by @renovate in https://github.com/uutils/coreutils/pull/6838
* chore(deps): update rust crate indicatif to v0.17.9 by @renovate in https://github.com/uutils/coreutils/pull/6849
* fix(deps): update rust crate dunce to v1.0.5 by @renovate in https://github.com/uutils/coreutils/pull/6617
* Bump `nix` & `ctrlc` and adapt code to API changes in `nix` by @cakebaker in https://github.com/uutils/coreutils/pull/6648
* fix(deps): update rust crate similar to v2.6.0 by @renovate in https://github.com/uutils/coreutils/pull/6661
* fix(deps): update rust crate tempfile to v3.12.0 by @renovate in https://github.com/uutils/coreutils/pull/6647
* fix(deps): update rust crate libc to v0.2.158 by @renovate in https://github.com/uutils/coreutils/pull/6651
* fix(deps): update rust crate quote to v1.0.37 by @renovate in https://github.com/uutils/coreutils/pull/6664
* fix(deps): update rust crate proc-macro2 to v1.0.87 by @renovate in https://github.com/uutils/coreutils/pull/6773
* fix(deps): update rust crate proc-macro2 to v1.0.88 by @renovate in https://github.com/uutils/coreutils/pull/6783
* fix(deps): update rust crate libc to v0.2.160 by @renovate in https://github.com/uutils/coreutils/pull/6786
* fix(deps): update rust crate libc to v0.2.161 by @renovate in https://github.com/uutils/coreutils/pull/6789
* num-prime => '0.4.4' by @sylvestre in https://github.com/uutils/coreutils/pull/6781
* Bump `selinux-sys` and `fts-sys` by @cakebaker in https://github.com/uutils/coreutils/pull/6693
* Bump `tempfile` from `3.10.1` to `3.11.0` by @cakebaker in https://github.com/uutils/coreutils/pull/6613
* Bump windows-targets crates by @cakebaker in https://github.com/uutils/coreutils/pull/6633
* Bump `parking_lot_core` by @cakebaker in https://github.com/uutils/coreutils/pull/6663
* Bump `windows-sys` & adapt `tail` to API change by @cakebaker in https://github.com/uutils/coreutils/pull/6681

## New Contributors
* @Its-Just-Nans made their first contribution in https://github.com/uutils/coreutils/pull/6502
* @CausingBrick made their first contribution in https://github.com/uutils/coreutils/pull/6503
* @lu-zero made their first contribution in https://github.com/uutils/coreutils/pull/6512
* @Kev1n8 made their first contribution in https://github.com/uutils/coreutils/pull/6511
* @andrewliebenow made their first contribution in https://github.com/uutils/coreutils/pull/6674
* @just-an-engineer made their first contribution in https://github.com/uutils/coreutils/pull/6622
* @LoricAndre made their first contribution in https://github.com/uutils/coreutils/pull/6690
* @jansheikkinen made their first contribution in https://github.com/uutils/coreutils/pull/5975
* @dcampbell24 made their first contribution in https://github.com/uutils/coreutils/pull/6715
* @OshinoShinobu-Chan made their first contribution in https://github.com/uutils/coreutils/pull/6763
* @gim913 made their first contribution in https://github.com/uutils/coreutils/pull/5256
* @neyo8826 made their first contribution in https://github.com/uutils/coreutils/pull/6694
* @tea made their first contribution in https://github.com/uutils/coreutils/pull/6787
* @sgvictorino made their first contribution in https://github.com/uutils/coreutils/pull/6790
* @Pistonight made their first contribution in https://github.com/uutils/coreutils/pull/6808
* @DaringCuteSeal made their first contribution in https://github.com/uutils/coreutils/pull/6831

**Full Changelog**: https://github.com/uutils/coreutils/compare/0.0.27...0.0.28
