/* image.c generated by valac 0.36.6, the Vala compiler
 * generated from image.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* XPM */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BOX (box_get_type ())
typedef struct _Box Box;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Dimensions {
	gint width;
	gint height;
};

struct _Box {
	gint left;
	gint top;
	gint right;
	gint bottom;
};


extern cairo_surface_t* background_surface;
cairo_surface_t* background_surface = NULL;

gboolean is_color_parsable (const gchar* spec);
void parse_color (const gchar* spec, GdkRGBA* result);
void fetch_color (const gchar* spec, GdkRGBA* result);
void set_source_color_from_string (cairo_t* ctx, const gchar* spec);
#define MIN_SCALED_WIDTH 10
#define MIN_SCALED_HEIGHT 10
GdkPixbuf* get_placeholder_pixbuf (void);
GdkPixbuf* scale_pixbuf (GdkPixbuf* pixbuf, gint scale, GdkInterpType interp, gboolean scale_up);
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf, Dimensions* result);
void dimensions_get_scaled (Dimensions *self, gint scale, gboolean scale_up, Dimensions* result);
void dimensions_with_min (Dimensions *self, gint min_width, gint min_height, Dimensions* result);
GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf, Dimensions* resized, GdkInterpType interp);
#define DEGREE (G_PI / 180.0)
void draw_rounded_corners_filled (cairo_t* ctx, Dimensions* dim, GdkPoint* origin, gdouble radius_proportion);
void context_rounded_corners (cairo_t* cx, Dimensions* dim, GdkPoint* origin, gdouble radius_proportion);
gint dimensions_minor_axis (Dimensions *self);
guchar shift_color_byte (gint b, gint shift);
void shift_colors (GdkPixbuf* pixbuf, gint red, gint green, gint blue, gint alpha);
gboolean coord_in_rectangle (gint x, gint y, GdkRectangle* rect);
gboolean rectangles_equal (GdkRectangle* a, GdkRectangle* b);
gchar* rectangle_to_string (GdkRectangle* rect);
void clamp_rectangle (GdkRectangle* original, Dimensions* max, GdkRectangle* result);
void scale_point (GdkPoint* p, gdouble factor, GdkPoint* result);
void add_points (GdkPoint* p1, GdkPoint* p2, GdkPoint* result);
void subtract_points (GdkPoint* p1, GdkPoint* p2, GdkPoint* result);
void fix_cairo_pixbuf (GdkPixbuf* pixbuf);
void compute_arb_rotated_size (gdouble src_width, gdouble src_height, gdouble angle, gdouble* dest_width, gdouble* dest_height);
gdouble degrees_to_radians (gdouble theta);
GdkPixbuf* rotate_arb (GdkPixbuf* source_pixbuf, gdouble angle);
void rotate_point_arb (GdkPoint* source_point, gint img_w, gint img_h, gdouble angle, gboolean invert, GdkPoint* result);
void derotate_point_arb (GdkPoint* source_point, gint img_w, gint img_h, gdouble angle, GdkPoint* result);
cairo_surface_t* get_background_surface (void);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
gchar* configuration_facade_get_transparent_background_type (ConfigurationFacade* self);
gchar* configuration_facade_get_transparent_background_color (ConfigurationFacade* self);
void invalidate_transparent_background (void);
void paint_pixmap_with_background (cairo_t* ctx, GdkPixbuf* pixbuf, gint x, gint y);
GType box_get_type (void) G_GNUC_CONST;
Box* box_dup (const Box* self);
void box_free (Box* self);
void clamp_inside_rotated_image (Box* src, gint img_w, gint img_h, gdouble angle_deg, gboolean preserve_geom, Box* result);
void box_get_offset (Box *self, gint xofs, gint yofs, Box* result);
void box_init (Box *self, gint left, gint top, gint right, gint bottom);

const gchar* fallback_image_missing[103] = {"48 48 54 1 ", "  c #6A6D67", ". c #6C6E69", "X c #72746F", "o c #747672", "O c #777974", "+ c #797B77", "@ c #7C7E7A", "# c #7F817C", "$ c #81837F", "% c #848682", "& c #878984", "* c #888A86", "= c #8C8D8A", "- c #8F908C", "; c #90928E", ": c #949591", "> c #969894", ", c #999B96", "< c #9C9E9A", "1 c #9FA09C", "2 c #A1A39E", "3 c #A4A6A2", "4 c #A6A9A4", "5 c #A9ABA6", "6 c #ACADA9", "7 c #AEB1AB", "8 c #B1B2AF", "9 c #B3B4B1", "0 c #B6B9B3", "q c #B9BCB6", "w c #BDBEBA", "e c #BEC2BB", "r c #C1C4BE", "t c #C5C5C2", "y c #C6C9C3", "u c #C9CCC6", "i c #CCCDCB", "p c #CED2CA", "a c #D2D6CE", "s c #D5D5D3", "d c #D7D8D5", "f c #D9D9D6", "g c #DCDCDA", "h c #DFE0DD", "j c #E0E0DE", "k c #E4E4E2", "l c #E7E8E5", "z c #E9E9E7", "x c #EDEDEC", "c c #EFF0EE", "v c #F1F1EF", "b c #F2F2F1", "n c #FFFFFF", "m c None", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmaaaaaaaaaasaisaaaaaaaaaaaaaaaaaaapppiipuuuuumm", "mannnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnym", "manbbbbbbbbbvbbvvvvxvvvbvvvvvvvvccccccxxvxvxxnym", "manbt89898888988888888888999999999999999999txnrm", "manb6======================-;;=;;;;;;;;;;=:7znrm", "manv6&%%**%*%%%%*%%****=======;==;;;;=;=;==7znem", "manv4%%%%$%%%%%%%%%%%=****=======;==-======6znwm", "manx3%%#$$$$##%#$%%%*%**==========-=--=====6znqm", "manx1$@%#$@$###%%%%=****=*===--;;----====*=5lnqm", "manx<@@@@@@@@##%$%%%%****========-==-======5kn0m", "manz<@@@+@+@@@#$%%%%%=%=%===;=:=--------=-*4kn8m", "manz>O+O+O+@@@#$$%%%%========;;=--------=*=3kn9m", "mpnl:OOOOO+@@$##%%%%%=%=====;=;;--;-----===3kn8m", "munl;OooOOO@@@#$%%%%%======;;;;;:;;;;;---==1hn7m", "munl;oXoOO+@###$%%=%=======;::;::::;;---&#+-gn7m", "mynk*XXooOO+$$#$%%%%=%===;;:;:::::;:-$#XooX-fn5m", "mynk*XXOOO@@$$$$%%=%====;::::>::;*#OXXXXXXX*dn5m", "mrnk*oOO@@@#$$$$%=====::::>>>=%@OXOooXXXooo&dn3m", "mrnj*++@$$$$**$===-;;::>>:=@Ooo@XOOoo#o#OOO=fn3m", "menj*@#$$$$$**===;;:::=%@@@@@@O@#O#Oo#o#++@;gn2m", "menj*$$$$&**===;:;=*#@@@@@@@@@@@#######o##%>gn2m", "menh*$$%**===;=*%###########%@@@###$####$%=,gn1m", "m0nj=%***=**&$$$%$$$%$$%$$$$%$$$$$$$$$$%*;:2hn<m", "m0nj****&&&$$&&$%%%%%%%%%%%%%%%%$$*$%%%*;>13gn,m", "m0ng****&&&&&&&&&&&&*%*%*%%*%******%**-:,136kz;m", "m0nh***$&&&&&&&&&&&&%**********%*$***;:,1358r7*m", "m8ng*&&&&&&&&&*$&*&&&&$=$=$=&&&&&&**=:,<11>$65mm", "m7ng*&&&&&&&&&**&&&&&&**=$-$&&&&&&*-:,1..&1wi:mm", "m7ng&&&&&&&&=$*$&&&&&***$$$$&&&***=>,1<onxsi6*mm", "m6nf*&&&&&*&$***&&&&*$*$--$-&&&%*=;,13,:ztw9%mmm", "m5nf*%&&&&&&=$=$%*&&**%*$$&&&&**=>,225;5srw%mmmm", "m4nf3*&&**&&$-$-*******%$;&&*&*->,2365+ui7$mmmmm", "m3nsfffdddsddaffssssdassgaaaassddfgjg4wu;ommmmmm", "m3nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnvq3<$.mmmmmmm", "mm2211111,<,,,,,,>>>>:::;::;----=====@mmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm"};

gboolean is_color_parsable (const gchar* spec) {
	gboolean result = FALSE;
	GdkRGBA color = {0};
	const gchar* _tmp0_;
	gboolean _tmp1_;
#line 117 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (spec != NULL, FALSE);
#line 118 "/home/jens/Source/shotwell/src/util/image.vala"
	memset (&color, 0, sizeof (GdkRGBA));
#line 119 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = spec;
#line 119 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = gdk_rgba_parse (&color, _tmp0_);
#line 119 "/home/jens/Source/shotwell/src/util/image.vala"
	result = _tmp1_;
#line 119 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 143 "image.c"
}


void parse_color (const gchar* spec, GdkRGBA* result) {
	const gchar* _tmp0_;
	GdkRGBA _tmp1_ = {0};
#line 122 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (spec != NULL);
#line 123 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = spec;
#line 123 "/home/jens/Source/shotwell/src/util/image.vala"
	fetch_color (_tmp0_, &_tmp1_);
#line 123 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _tmp1_;
#line 123 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 160 "image.c"
}


void fetch_color (const gchar* spec, GdkRGBA* result) {
	GdkRGBA rgba = {0};
	const gchar* _tmp0_;
	gboolean _tmp1_;
#line 126 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (spec != NULL);
#line 127 "/home/jens/Source/shotwell/src/util/image.vala"
	memset (&rgba, 0, sizeof (GdkRGBA));
#line 128 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = spec;
#line 128 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = gdk_rgba_parse (&rgba, _tmp0_);
#line 128 "/home/jens/Source/shotwell/src/util/image.vala"
	if (!_tmp1_) {
#line 178 "image.c"
		const gchar* _tmp2_;
#line 129 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = spec;
#line 129 "/home/jens/Source/shotwell/src/util/image.vala"
		g_error ("image.vala:129: Can't parse color %s", _tmp2_);
#line 184 "image.c"
	}
#line 131 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = rgba;
#line 131 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 190 "image.c"
}


void set_source_color_from_string (cairo_t* ctx, const gchar* spec) {
	GdkRGBA rgba = {0};
	const gchar* _tmp0_;
	GdkRGBA _tmp1_ = {0};
	cairo_t* _tmp2_;
	GdkRGBA _tmp3_;
	gdouble _tmp4_;
	GdkRGBA _tmp5_;
	gdouble _tmp6_;
	GdkRGBA _tmp7_;
	gdouble _tmp8_;
	GdkRGBA _tmp9_;
	gdouble _tmp10_;
#line 134 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (ctx != NULL);
#line 134 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (spec != NULL);
#line 135 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = spec;
#line 135 "/home/jens/Source/shotwell/src/util/image.vala"
	fetch_color (_tmp0_, &_tmp1_);
#line 135 "/home/jens/Source/shotwell/src/util/image.vala"
	rgba = _tmp1_;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = ctx;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = rgba;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = _tmp3_.red;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = rgba;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.green;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = rgba;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = _tmp7_.blue;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = rgba;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp10_ = _tmp9_.alpha;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_set_source_rgba (_tmp2_, _tmp4_, _tmp6_, _tmp8_, _tmp10_);
#line 237 "image.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 147 "/home/jens/Source/shotwell/src/util/image.vala"
	return self ? g_object_ref (self) : NULL;
#line 244 "image.c"
}


GdkPixbuf* get_placeholder_pixbuf (void) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf = NULL;
	GError * _inner_error_ = NULL;
#line 144 "/home/jens/Source/shotwell/src/util/image.vala"
	pixbuf = NULL;
#line 254 "image.c"
	{
		GtkIconTheme* icon_theme = NULL;
		GtkIconTheme* _tmp0_;
		GtkIconTheme* _tmp1_;
		GdkPixbuf* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
#line 147 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = gtk_icon_theme_get_default ();
#line 147 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 147 "/home/jens/Source/shotwell/src/util/image.vala"
		icon_theme = _tmp1_;
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp3_ = gtk_icon_theme_load_icon (icon_theme, "image-missing", (gint) GTK_ICON_SIZE_DIALOG, 0, &_inner_error_);
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = _tmp3_;
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
			_g_object_unref0 (icon_theme);
#line 276 "image.c"
			goto __catch4_g_error;
		}
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp4_ = _tmp2_;
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = NULL;
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_object_unref0 (pixbuf);
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		pixbuf = _tmp4_;
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_object_unref0 (_tmp2_);
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_object_unref0 (icon_theme);
#line 291 "image.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		GdkPixbuf* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		_error_ = _inner_error_;
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		_inner_error_ = NULL;
#line 151 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp5_ = gdk_pixbuf_new_from_xpm_data (fallback_image_missing);
#line 151 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_object_unref0 (pixbuf);
#line 151 "/home/jens/Source/shotwell/src/util/image.vala"
		pixbuf = _tmp5_;
#line 152 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp6_ = _error_;
#line 152 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp7_ = _tmp6_->message;
#line 152 "/home/jens/Source/shotwell/src/util/image.vala"
		g_warning ("image.vala:152: Could not load icon from theme: %s", _tmp7_);
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_error_free0 (_error_);
#line 318 "image.c"
	}
	__finally4:
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_object_unref0 (pixbuf);
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		g_clear_error (&_inner_error_);
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		return NULL;
#line 331 "image.c"
	}
#line 155 "/home/jens/Source/shotwell/src/util/image.vala"
	result = pixbuf;
#line 155 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 337 "image.c"
}


GdkPixbuf* scale_pixbuf (GdkPixbuf* pixbuf, gint scale, GdkInterpType interp, gboolean scale_up) {
	GdkPixbuf* result = NULL;
	Dimensions original = {0};
	GdkPixbuf* _tmp0_;
	Dimensions _tmp1_ = {0};
	Dimensions scaled = {0};
	gint _tmp2_;
	gboolean _tmp3_;
	Dimensions _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	Dimensions _tmp6_;
	gint _tmp7_;
	Dimensions _tmp8_;
	gint _tmp9_;
	Dimensions _tmp16_ = {0};
	GdkPixbuf* _tmp17_;
	Dimensions _tmp18_;
	gint _tmp19_;
	Dimensions _tmp20_;
	gint _tmp21_;
	GdkInterpType _tmp22_;
	GdkPixbuf* _tmp23_;
#line 158 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (pixbuf), NULL);
#line 159 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = pixbuf;
#line 159 "/home/jens/Source/shotwell/src/util/image.vala"
	dimensions_for_pixbuf (_tmp0_, &_tmp1_);
#line 159 "/home/jens/Source/shotwell/src/util/image.vala"
	original = _tmp1_;
#line 160 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = scale;
#line 160 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = scale_up;
#line 160 "/home/jens/Source/shotwell/src/util/image.vala"
	dimensions_get_scaled (&original, _tmp2_, _tmp3_, &_tmp4_);
#line 160 "/home/jens/Source/shotwell/src/util/image.vala"
	scaled = _tmp4_;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = original;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = _tmp6_.width;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = scaled;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = _tmp8_.width;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp7_ == _tmp9_) {
#line 389 "image.c"
		Dimensions _tmp10_;
		gint _tmp11_;
		Dimensions _tmp12_;
		gint _tmp13_;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp10_ = original;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp11_ = _tmp10_.height;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp12_ = scaled;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp13_ = _tmp12_.height;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp5_ = _tmp11_ == _tmp13_;
#line 404 "image.c"
	} else {
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp5_ = FALSE;
#line 408 "image.c"
	}
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp5_) {
#line 412 "image.c"
		GdkPixbuf* _tmp14_;
		GdkPixbuf* _tmp15_;
#line 162 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp14_ = pixbuf;
#line 162 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp15_ = _g_object_ref0 (_tmp14_);
#line 162 "/home/jens/Source/shotwell/src/util/image.vala"
		result = _tmp15_;
#line 162 "/home/jens/Source/shotwell/src/util/image.vala"
		return result;
#line 423 "image.c"
	}
#line 165 "/home/jens/Source/shotwell/src/util/image.vala"
	dimensions_with_min (&scaled, MIN_SCALED_WIDTH, MIN_SCALED_HEIGHT, &_tmp16_);
#line 165 "/home/jens/Source/shotwell/src/util/image.vala"
	scaled = _tmp16_;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp17_ = pixbuf;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp18_ = scaled;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp19_ = _tmp18_.width;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp20_ = scaled;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp21_ = _tmp20_.height;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp22_ = interp;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp23_ = gdk_pixbuf_scale_simple (_tmp17_, _tmp19_, _tmp21_, _tmp22_);
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	result = _tmp23_;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 447 "image.c"
}


GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf, Dimensions* resized, GdkInterpType interp) {
	GdkPixbuf* result = NULL;
	Dimensions original = {0};
	GdkPixbuf* _tmp0_;
	Dimensions _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	Dimensions _tmp3_;
	gint _tmp4_;
	Dimensions _tmp5_;
	gint _tmp6_;
	Dimensions _tmp13_ = {0};
	GdkPixbuf* _tmp14_;
	Dimensions _tmp15_;
	gint _tmp16_;
	Dimensions _tmp17_;
	gint _tmp18_;
	GdkInterpType _tmp19_;
	GdkPixbuf* _tmp20_;
#line 170 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (pixbuf), NULL);
#line 170 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (resized != NULL, NULL);
#line 171 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = pixbuf;
#line 171 "/home/jens/Source/shotwell/src/util/image.vala"
	dimensions_for_pixbuf (_tmp0_, &_tmp1_);
#line 171 "/home/jens/Source/shotwell/src/util/image.vala"
	original = _tmp1_;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = original;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = _tmp3_.width;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = *resized;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.width;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp4_ == _tmp6_) {
#line 489 "image.c"
		Dimensions _tmp7_;
		gint _tmp8_;
		Dimensions _tmp9_;
		gint _tmp10_;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp7_ = original;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp8_ = _tmp7_.height;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp9_ = *resized;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp10_ = _tmp9_.height;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = _tmp8_ == _tmp10_;
#line 504 "image.c"
	} else {
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = FALSE;
#line 508 "image.c"
	}
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp2_) {
#line 512 "image.c"
		GdkPixbuf* _tmp11_;
		GdkPixbuf* _tmp12_;
#line 173 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp11_ = pixbuf;
#line 173 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp12_ = _g_object_ref0 (_tmp11_);
#line 173 "/home/jens/Source/shotwell/src/util/image.vala"
		result = _tmp12_;
#line 173 "/home/jens/Source/shotwell/src/util/image.vala"
		return result;
#line 523 "image.c"
	}
#line 176 "/home/jens/Source/shotwell/src/util/image.vala"
	dimensions_with_min (resized, MIN_SCALED_WIDTH, MIN_SCALED_HEIGHT, &_tmp13_);
#line 176 "/home/jens/Source/shotwell/src/util/image.vala"
	*resized = _tmp13_;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp14_ = pixbuf;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = *resized;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp16_ = _tmp15_.width;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp17_ = *resized;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp18_ = _tmp17_.height;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp19_ = interp;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp20_ = gdk_pixbuf_scale_simple (_tmp14_, _tmp16_, _tmp18_, _tmp19_);
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	result = _tmp20_;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 547 "image.c"
}


void draw_rounded_corners_filled (cairo_t* ctx, Dimensions* dim, GdkPoint* origin, gdouble radius_proportion) {
	cairo_t* _tmp0_;
	Dimensions _tmp1_;
	GdkPoint _tmp2_;
	gdouble _tmp3_;
	cairo_t* _tmp4_;
#line 183 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (ctx != NULL);
#line 183 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (dim != NULL);
#line 183 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (origin != NULL);
#line 185 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = ctx;
#line 185 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = *dim;
#line 185 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = *origin;
#line 185 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = radius_proportion;
#line 185 "/home/jens/Source/shotwell/src/util/image.vala"
	context_rounded_corners (_tmp0_, &_tmp1_, &_tmp2_, _tmp3_);
#line 186 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = ctx;
#line 186 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_paint (_tmp4_);
#line 577 "image.c"
}


void context_rounded_corners (cairo_t* cx, Dimensions* dim, GdkPoint* origin, gdouble radius_proportion) {
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble left = 0.0;
	GdkPoint _tmp2_;
	gint _tmp3_;
	gdouble top = 0.0;
	GdkPoint _tmp4_;
	gint _tmp5_;
	gdouble right = 0.0;
	GdkPoint _tmp6_;
	gint _tmp7_;
	Dimensions _tmp8_;
	gint _tmp9_;
	gdouble bottom = 0.0;
	GdkPoint _tmp10_;
	gint _tmp11_;
	Dimensions _tmp12_;
	gint _tmp13_;
	gdouble radius = 0.0;
	gint _tmp14_;
	gdouble _tmp15_;
	cairo_t* _tmp16_;
	cairo_t* _tmp17_;
	cairo_t* _tmp18_;
	cairo_t* _tmp19_;
	cairo_t* _tmp20_;
	cairo_t* _tmp21_;
#line 189 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (cx != NULL);
#line 189 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (dim != NULL);
#line 189 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (origin != NULL);
#line 192 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = radius_proportion;
#line 192 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = CLAMP (_tmp0_, 2.0, 100.0);
#line 192 "/home/jens/Source/shotwell/src/util/image.vala"
	radius_proportion = _tmp1_;
#line 194 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = *origin;
#line 194 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = _tmp2_.x;
#line 194 "/home/jens/Source/shotwell/src/util/image.vala"
	left = (gdouble) _tmp3_;
#line 195 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = *origin;
#line 195 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = _tmp4_.y;
#line 195 "/home/jens/Source/shotwell/src/util/image.vala"
	top = (gdouble) _tmp5_;
#line 196 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = *origin;
#line 196 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = _tmp6_.x;
#line 196 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = *dim;
#line 196 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = _tmp8_.width;
#line 196 "/home/jens/Source/shotwell/src/util/image.vala"
	right = (gdouble) (_tmp7_ + _tmp9_);
#line 197 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp10_ = *origin;
#line 197 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp11_ = _tmp10_.y;
#line 197 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp12_ = *dim;
#line 197 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_ = _tmp12_.height;
#line 197 "/home/jens/Source/shotwell/src/util/image.vala"
	bottom = (gdouble) (_tmp11_ + _tmp13_);
#line 200 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp14_ = dimensions_minor_axis (dim);
#line 200 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = radius_proportion;
#line 200 "/home/jens/Source/shotwell/src/util/image.vala"
	radius = ((gdouble) _tmp14_) / _tmp15_;
#line 204 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp16_ = cx;
#line 204 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_move_to (_tmp16_, left, top);
#line 205 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp17_ = cx;
#line 205 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_arc (_tmp17_, right - radius, top + radius, radius, -90 * DEGREE, 0 * DEGREE);
#line 206 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp18_ = cx;
#line 206 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_arc (_tmp18_, right - radius, bottom - radius, radius, 0 * DEGREE, 90 * DEGREE);
#line 207 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp19_ = cx;
#line 207 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_arc (_tmp19_, left + radius, bottom - radius, radius, 90 * DEGREE, 180 * DEGREE);
#line 208 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp20_ = cx;
#line 208 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_arc (_tmp20_, left + radius, top + radius, radius, 180 * DEGREE, 270 * DEGREE);
#line 209 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp21_ = cx;
#line 209 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_clip (_tmp21_);
#line 683 "image.c"
}


inline guchar shift_color_byte (gint b, gint shift) {
	guchar result = '\0';
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 213 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = b;
#line 213 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = shift;
#line 213 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = CLAMP (_tmp0_ + _tmp1_, 0, 255);
#line 213 "/home/jens/Source/shotwell/src/util/image.vala"
	result = (guchar) _tmp2_;
#line 213 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 702 "image.c"
}


void shift_colors (GdkPixbuf* pixbuf, gint red, gint green, gint blue, gint alpha) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_;
	gint width = 0;
	GdkPixbuf* _tmp12_;
	gint _tmp13_;
	gint height = 0;
	GdkPixbuf* _tmp14_;
	gint _tmp15_;
	gint rowstride = 0;
	GdkPixbuf* _tmp16_;
	gint _tmp17_;
	gint channels = 0;
	GdkPixbuf* _tmp18_;
	gint _tmp19_;
	guchar* pixels = NULL;
	GdkPixbuf* _tmp20_;
	guint8* _tmp21_;
	gint _tmp22_;
	GdkPixbuf* _tmp23_;
	GdkColorspace _tmp24_;
	GdkPixbuf* _tmp25_;
	gint _tmp26_;
#line 216 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 217 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = red;
#line 217 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp1_ >= -255) {
#line 741 "image.c"
		gint _tmp2_;
#line 217 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = red;
#line 217 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = _tmp2_ <= 255;
#line 747 "image.c"
	} else {
#line 217 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = FALSE;
#line 751 "image.c"
	}
#line 217 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp0_, "red >= -255 && red <= 255");
#line 218 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = green;
#line 218 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp4_ >= -255) {
#line 759 "image.c"
		gint _tmp5_;
#line 218 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp5_ = green;
#line 218 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp3_ = _tmp5_ <= 255;
#line 765 "image.c"
	} else {
#line 218 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp3_ = FALSE;
#line 769 "image.c"
	}
#line 218 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp3_, "green >= -255 && green <= 255");
#line 219 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = blue;
#line 219 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp7_ >= -255) {
#line 777 "image.c"
		gint _tmp8_;
#line 219 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp8_ = blue;
#line 219 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp6_ = _tmp8_ <= 255;
#line 783 "image.c"
	} else {
#line 219 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp6_ = FALSE;
#line 787 "image.c"
	}
#line 219 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp6_, "blue >= -255 && blue <= 255");
#line 220 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp10_ = alpha;
#line 220 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp10_ >= -255) {
#line 795 "image.c"
		gint _tmp11_;
#line 220 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp11_ = alpha;
#line 220 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp9_ = _tmp11_ <= 255;
#line 801 "image.c"
	} else {
#line 220 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp9_ = FALSE;
#line 805 "image.c"
	}
#line 220 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp9_, "alpha >= -255 && alpha <= 255");
#line 222 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp12_ = pixbuf;
#line 222 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_ = gdk_pixbuf_get_width (_tmp12_);
#line 222 "/home/jens/Source/shotwell/src/util/image.vala"
	width = _tmp13_;
#line 223 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp14_ = pixbuf;
#line 223 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = gdk_pixbuf_get_height (_tmp14_);
#line 223 "/home/jens/Source/shotwell/src/util/image.vala"
	height = _tmp15_;
#line 224 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp16_ = pixbuf;
#line 224 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp17_ = gdk_pixbuf_get_rowstride (_tmp16_);
#line 224 "/home/jens/Source/shotwell/src/util/image.vala"
	rowstride = _tmp17_;
#line 225 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp18_ = pixbuf;
#line 225 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp19_ = gdk_pixbuf_get_n_channels (_tmp18_);
#line 225 "/home/jens/Source/shotwell/src/util/image.vala"
	channels = _tmp19_;
#line 226 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp20_ = pixbuf;
#line 226 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp21_ = gdk_pixbuf_get_pixels (_tmp20_);
#line 226 "/home/jens/Source/shotwell/src/util/image.vala"
	pixels = _tmp21_;
#line 228 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp22_ = channels;
#line 228 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp22_ >= 3, "channels >= 3");
#line 229 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp23_ = pixbuf;
#line 229 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp24_ = gdk_pixbuf_get_colorspace (_tmp23_);
#line 229 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp24_ == GDK_COLORSPACE_RGB, "pixbuf.get_colorspace() == Gdk.Colorspace.RGB");
#line 230 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp25_ = pixbuf;
#line 230 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp26_ = gdk_pixbuf_get_bits_per_sample (_tmp25_);
#line 230 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp26_ == 8, "pixbuf.get_bits_per_sample() == 8");
#line 855 "image.c"
	{
		gint y = 0;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
		y = 0;
#line 860 "image.c"
		{
			gboolean _tmp27_ = FALSE;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
			_tmp27_ = TRUE;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
			while (TRUE) {
#line 867 "image.c"
				gint _tmp29_;
				gint _tmp30_;
				gint y_offset = 0;
				gint _tmp31_;
				gint _tmp32_;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
				if (!_tmp27_) {
#line 875 "image.c"
					gint _tmp28_;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp28_ = y;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
					y = _tmp28_ + 1;
#line 881 "image.c"
				}
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp27_ = FALSE;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp29_ = y;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp30_ = height;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
				if (!(_tmp29_ < _tmp30_)) {
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
					break;
#line 893 "image.c"
				}
#line 233 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp31_ = y;
#line 233 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp32_ = rowstride;
#line 233 "/home/jens/Source/shotwell/src/util/image.vala"
				y_offset = _tmp31_ * _tmp32_;
#line 901 "image.c"
				{
					gint x = 0;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
					x = 0;
#line 906 "image.c"
					{
						gboolean _tmp33_ = FALSE;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
						_tmp33_ = TRUE;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
						while (TRUE) {
#line 913 "image.c"
							gint _tmp35_;
							gint _tmp36_;
							gint offset = 0;
							gint _tmp37_;
							gint _tmp38_;
							gint _tmp39_;
							gint _tmp40_;
							gint _tmp49_;
							gint _tmp58_;
							gboolean _tmp67_ = FALSE;
							gint _tmp68_;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
							if (!_tmp33_) {
#line 927 "image.c"
								gint _tmp34_;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp34_ = x;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
								x = _tmp34_ + 1;
#line 933 "image.c"
							}
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp33_ = FALSE;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp35_ = x;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp36_ = width;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
							if (!(_tmp35_ < _tmp36_)) {
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
								break;
#line 945 "image.c"
							}
#line 236 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp37_ = y_offset;
#line 236 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp38_ = x;
#line 236 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp39_ = channels;
#line 236 "/home/jens/Source/shotwell/src/util/image.vala"
							offset = _tmp37_ + (_tmp38_ * _tmp39_);
#line 238 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp40_ = red;
#line 238 "/home/jens/Source/shotwell/src/util/image.vala"
							if (_tmp40_ != 0) {
#line 959 "image.c"
								guchar* _tmp41_;
								gint _tmp42_;
								guchar* _tmp43_;
								gint _tmp44_;
								guchar _tmp45_;
								gint _tmp46_;
								guchar _tmp47_;
								guchar _tmp48_;
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp41_ = pixels;
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp42_ = offset;
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp43_ = pixels;
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp44_ = offset;
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp45_ = _tmp43_[_tmp44_];
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp46_ = red;
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp47_ = shift_color_byte ((gint) _tmp45_, _tmp46_);
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp41_[_tmp42_] = _tmp47_;
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp48_ = _tmp41_[_tmp42_];
#line 986 "image.c"
							}
#line 241 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp49_ = green;
#line 241 "/home/jens/Source/shotwell/src/util/image.vala"
							if (_tmp49_ != 0) {
#line 992 "image.c"
								guchar* _tmp50_;
								gint _tmp51_;
								guchar* _tmp52_;
								gint _tmp53_;
								guchar _tmp54_;
								gint _tmp55_;
								guchar _tmp56_;
								guchar _tmp57_;
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp50_ = pixels;
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp51_ = offset;
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp52_ = pixels;
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp53_ = offset;
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp54_ = _tmp52_[_tmp53_ + 1];
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp55_ = green;
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp56_ = shift_color_byte ((gint) _tmp54_, _tmp55_);
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp50_[_tmp51_ + 1] = _tmp56_;
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp57_ = _tmp50_[_tmp51_ + 1];
#line 1019 "image.c"
							}
#line 244 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp58_ = blue;
#line 244 "/home/jens/Source/shotwell/src/util/image.vala"
							if (_tmp58_ != 0) {
#line 1025 "image.c"
								guchar* _tmp59_;
								gint _tmp60_;
								guchar* _tmp61_;
								gint _tmp62_;
								guchar _tmp63_;
								gint _tmp64_;
								guchar _tmp65_;
								guchar _tmp66_;
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp59_ = pixels;
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp60_ = offset;
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp61_ = pixels;
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp62_ = offset;
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp63_ = _tmp61_[_tmp62_ + 2];
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp64_ = blue;
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp65_ = shift_color_byte ((gint) _tmp63_, _tmp64_);
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp59_[_tmp60_ + 2] = _tmp65_;
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp66_ = _tmp59_[_tmp60_ + 2];
#line 1052 "image.c"
							}
#line 247 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp68_ = alpha;
#line 247 "/home/jens/Source/shotwell/src/util/image.vala"
							if (_tmp68_ != 0) {
#line 1058 "image.c"
								gint _tmp69_;
#line 247 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp69_ = channels;
#line 247 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp67_ = _tmp69_ >= 4;
#line 1064 "image.c"
							} else {
#line 247 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp67_ = FALSE;
#line 1068 "image.c"
							}
#line 247 "/home/jens/Source/shotwell/src/util/image.vala"
							if (_tmp67_) {
#line 1072 "image.c"
								guchar* _tmp70_;
								gint _tmp71_;
								guchar* _tmp72_;
								gint _tmp73_;
								guchar _tmp74_;
								gint _tmp75_;
								guchar _tmp76_;
								guchar _tmp77_;
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp70_ = pixels;
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp71_ = offset;
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp72_ = pixels;
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp73_ = offset;
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp74_ = _tmp72_[_tmp73_ + 3];
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp75_ = alpha;
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp76_ = shift_color_byte ((gint) _tmp74_, _tmp75_);
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp70_[_tmp71_ + 3] = _tmp76_;
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp77_ = _tmp70_[_tmp71_ + 3];
#line 1099 "image.c"
							}
						}
					}
				}
			}
		}
	}
}


gboolean coord_in_rectangle (gint x, gint y, GdkRectangle* rect) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	GdkRectangle _tmp4_;
	gint _tmp5_;
#line 253 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (rect != NULL, FALSE);
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = x;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = *rect;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = _tmp4_.x;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp3_ >= _tmp5_) {
#line 1128 "image.c"
		gint _tmp6_;
		GdkRectangle _tmp7_;
		gint _tmp8_;
		GdkRectangle _tmp9_;
		gint _tmp10_;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp6_ = x;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp7_ = *rect;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp8_ = _tmp7_.x;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp9_ = *rect;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp10_ = _tmp9_.width;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = _tmp6_ < (_tmp8_ + _tmp10_);
#line 1146 "image.c"
	} else {
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = FALSE;
#line 1150 "image.c"
	}
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp2_) {
#line 1154 "image.c"
		gint _tmp11_;
		GdkRectangle _tmp12_;
		gint _tmp13_;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp11_ = y;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp12_ = *rect;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp13_ = _tmp12_.y;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = _tmp11_ >= _tmp13_;
#line 1166 "image.c"
	} else {
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = FALSE;
#line 1170 "image.c"
	}
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp1_) {
#line 1174 "image.c"
		gint _tmp14_;
		GdkRectangle _tmp15_;
		gint _tmp16_;
		GdkRectangle _tmp17_;
		gint _tmp18_;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp14_ = y;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp15_ = *rect;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp16_ = _tmp15_.y;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp17_ = *rect;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp18_ = _tmp17_.height;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = _tmp14_ <= (_tmp16_ + _tmp18_);
#line 1192 "image.c"
	} else {
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = FALSE;
#line 1196 "image.c"
	}
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
	result = _tmp0_;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 1202 "image.c"
}


gboolean rectangles_equal (GdkRectangle* a, GdkRectangle* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GdkRectangle _tmp3_;
	gint _tmp4_;
	GdkRectangle _tmp5_;
	gint _tmp6_;
#line 257 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 257 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = *a;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = _tmp3_.x;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = *b;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.x;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp4_ == _tmp6_) {
#line 1229 "image.c"
		GdkRectangle _tmp7_;
		gint _tmp8_;
		GdkRectangle _tmp9_;
		gint _tmp10_;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp7_ = *a;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp8_ = _tmp7_.y;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp9_ = *b;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp10_ = _tmp9_.y;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = _tmp8_ == _tmp10_;
#line 1244 "image.c"
	} else {
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = FALSE;
#line 1248 "image.c"
	}
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp2_) {
#line 1252 "image.c"
		GdkRectangle _tmp11_;
		gint _tmp12_;
		GdkRectangle _tmp13_;
		gint _tmp14_;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp11_ = *a;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp12_ = _tmp11_.width;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp13_ = *b;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp14_ = _tmp13_.width;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = _tmp12_ == _tmp14_;
#line 1267 "image.c"
	} else {
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = FALSE;
#line 1271 "image.c"
	}
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp1_) {
#line 1275 "image.c"
		GdkRectangle _tmp15_;
		gint _tmp16_;
		GdkRectangle _tmp17_;
		gint _tmp18_;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp15_ = *a;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp16_ = _tmp15_.height;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp17_ = *b;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp18_ = _tmp17_.height;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = _tmp16_ == _tmp18_;
#line 1290 "image.c"
	} else {
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = FALSE;
#line 1294 "image.c"
	}
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	result = _tmp0_;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 1300 "image.c"
}


gchar* rectangle_to_string (GdkRectangle* rect) {
	gchar* result = NULL;
	GdkRectangle _tmp0_;
	gint _tmp1_;
	GdkRectangle _tmp2_;
	gint _tmp3_;
	GdkRectangle _tmp4_;
	gint _tmp5_;
	GdkRectangle _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
#line 261 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (rect != NULL, NULL);
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = *rect;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = _tmp0_.x;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = *rect;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = _tmp2_.y;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = *rect;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = _tmp4_.width;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = *rect;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = _tmp6_.height;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = g_strdup_printf ("%d,%d %dx%d", _tmp1_, _tmp3_, _tmp5_, _tmp7_);
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	result = _tmp8_;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 1339 "image.c"
}


void clamp_rectangle (GdkRectangle* original, Dimensions* max, GdkRectangle* result) {
	GdkRectangle rect = {0};
	GdkRectangle _tmp0_;
	gint _tmp1_;
	Dimensions _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GdkRectangle _tmp5_;
	gint _tmp6_;
	Dimensions _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GdkRectangle _tmp10_;
	gint _tmp11_;
	Dimensions _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GdkRectangle _tmp15_;
	gint _tmp16_;
	Dimensions _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
#line 265 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (original != NULL);
#line 265 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (max != NULL);
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
	memset (&rect, 0, sizeof (GdkRectangle));
#line 267 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = *original;
#line 267 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = _tmp0_.x;
#line 267 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = *max;
#line 267 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = _tmp2_.width;
#line 267 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = CLAMP (_tmp1_, 0, _tmp3_);
#line 267 "/home/jens/Source/shotwell/src/util/image.vala"
	rect.x = _tmp4_;
#line 268 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = *original;
#line 268 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.y;
#line 268 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = *max;
#line 268 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = _tmp7_.height;
#line 268 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = CLAMP (_tmp6_, 0, _tmp8_);
#line 268 "/home/jens/Source/shotwell/src/util/image.vala"
	rect.y = _tmp9_;
#line 269 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp10_ = *original;
#line 269 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp11_ = _tmp10_.width;
#line 269 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp12_ = *max;
#line 269 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_ = _tmp12_.width;
#line 269 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp14_ = CLAMP (_tmp11_, 0, _tmp13_);
#line 269 "/home/jens/Source/shotwell/src/util/image.vala"
	rect.width = _tmp14_;
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = *original;
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp16_ = _tmp15_.height;
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp17_ = *max;
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp18_ = _tmp17_.height;
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp19_ = CLAMP (_tmp16_, 0, _tmp18_);
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	rect.height = _tmp19_;
#line 272 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = rect;
#line 272 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 1423 "image.c"
}


void scale_point (GdkPoint* p, gdouble factor, GdkPoint* result) {
	GdkPoint _result_ = {0};
	GdkPoint _tmp0_ = {0};
	gdouble _tmp1_;
	GdkPoint _tmp2_;
	gint _tmp3_;
	gdouble _tmp4_;
	GdkPoint _tmp5_;
	gint _tmp6_;
#line 275 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (p != NULL);
#line 276 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_.x = 0;
#line 276 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_ = _tmp0_;
#line 277 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = factor;
#line 277 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = *p;
#line 277 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = _tmp2_.x;
#line 277 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_.x = (gint) ((_tmp1_ * _tmp3_) + 0.5);
#line 278 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = factor;
#line 278 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = *p;
#line 278 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.y;
#line 278 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_.y = (gint) ((_tmp4_ * _tmp6_) + 0.5);
#line 280 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _result_;
#line 280 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 1462 "image.c"
}


void add_points (GdkPoint* p1, GdkPoint* p2, GdkPoint* result) {
	GdkPoint _result_ = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint _tmp1_;
	gint _tmp2_;
	GdkPoint _tmp3_;
	gint _tmp4_;
	GdkPoint _tmp5_;
	gint _tmp6_;
	GdkPoint _tmp7_;
	gint _tmp8_;
#line 283 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (p1 != NULL);
#line 283 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (p2 != NULL);
#line 284 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_.x = 0;
#line 284 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_ = _tmp0_;
#line 285 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = *p1;
#line 285 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = _tmp1_.x;
#line 285 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = *p2;
#line 285 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = _tmp3_.x;
#line 285 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_.x = _tmp2_ + _tmp4_;
#line 286 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = *p1;
#line 286 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.y;
#line 286 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = *p2;
#line 286 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = _tmp7_.y;
#line 286 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_.y = _tmp6_ + _tmp8_;
#line 288 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _result_;
#line 288 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 1509 "image.c"
}


void subtract_points (GdkPoint* p1, GdkPoint* p2, GdkPoint* result) {
	GdkPoint _result_ = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint _tmp1_;
	gint _tmp2_;
	GdkPoint _tmp3_;
	gint _tmp4_;
	GdkPoint _tmp5_;
	gint _tmp6_;
	GdkPoint _tmp7_;
	gint _tmp8_;
#line 291 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (p1 != NULL);
#line 291 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (p2 != NULL);
#line 292 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_.x = 0;
#line 292 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_ = _tmp0_;
#line 293 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = *p1;
#line 293 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = _tmp1_.x;
#line 293 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = *p2;
#line 293 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = _tmp3_.x;
#line 293 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_.x = _tmp2_ - _tmp4_;
#line 294 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = *p1;
#line 294 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.y;
#line 294 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = *p2;
#line 294 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = _tmp7_.y;
#line 294 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_.y = _tmp6_ - _tmp8_;
#line 296 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _result_;
#line 296 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 1556 "image.c"
}


void fix_cairo_pixbuf (GdkPixbuf* pixbuf) {
	guchar* gdk_pixels = NULL;
	GdkPixbuf* _tmp0_;
	void* _tmp1_;
	void* _tmp2_;
#line 300 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 301 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = pixbuf;
#line 301 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = gdk_pixbuf_get_pixels (_tmp0_);
#line 301 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = _tmp1_;
#line 301 "/home/jens/Source/shotwell/src/util/image.vala"
	gdk_pixels = _tmp2_;
#line 1575 "image.c"
	{
		gint j = 0;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
		j = 0;
#line 1580 "image.c"
		{
			gboolean _tmp3_ = FALSE;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
			_tmp3_ = TRUE;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
			while (TRUE) {
#line 1587 "image.c"
				gint _tmp5_;
				GdkPixbuf* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				guchar* p = NULL;
				guchar* _tmp9_;
				guchar* end = NULL;
				guchar* _tmp10_;
				GdkPixbuf* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				guchar* _tmp26_;
				GdkPixbuf* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
				if (!_tmp3_) {
#line 1605 "image.c"
					gint _tmp4_;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp4_ = j;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
					j = _tmp4_ + 1;
#line 1611 "image.c"
				}
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp3_ = FALSE;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp5_ = j;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp6_ = pixbuf;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp7_ = gdk_pixbuf_get_height (_tmp6_);
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp8_ = _tmp7_;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
				if (!(_tmp5_ < _tmp8_)) {
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
					break;
#line 1627 "image.c"
				}
#line 303 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp9_ = gdk_pixels;
#line 303 "/home/jens/Source/shotwell/src/util/image.vala"
				p = _tmp9_;
#line 304 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp10_ = p;
#line 304 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp11_ = pixbuf;
#line 304 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp12_ = gdk_pixbuf_get_width (_tmp11_);
#line 304 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp13_ = _tmp12_;
#line 304 "/home/jens/Source/shotwell/src/util/image.vala"
				end = _tmp10_ + (4 * _tmp13_);
#line 306 "/home/jens/Source/shotwell/src/util/image.vala"
				while (TRUE) {
#line 1645 "image.c"
					guchar* _tmp14_;
					guchar* _tmp15_;
					guchar tmp = '\0';
					guchar* _tmp16_;
					guchar _tmp17_;
					guchar* _tmp18_;
					guchar* _tmp19_;
					guchar _tmp20_;
					guchar _tmp21_;
					guchar* _tmp22_;
					guchar _tmp23_;
					guchar _tmp24_;
					guchar* _tmp25_;
#line 306 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp14_ = p;
#line 306 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp15_ = end;
#line 306 "/home/jens/Source/shotwell/src/util/image.vala"
					if (!(_tmp14_ < _tmp15_)) {
#line 306 "/home/jens/Source/shotwell/src/util/image.vala"
						break;
#line 1667 "image.c"
					}
#line 307 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp16_ = p;
#line 307 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp17_ = _tmp16_[0];
#line 307 "/home/jens/Source/shotwell/src/util/image.vala"
					tmp = _tmp17_;
#line 309 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp18_ = p;
#line 309 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp19_ = p;
#line 309 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp20_ = _tmp19_[2];
#line 309 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp18_[0] = _tmp20_;
#line 309 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp21_ = _tmp18_[0];
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp22_ = p;
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp23_ = tmp;
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp22_[2] = _tmp23_;
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp24_ = _tmp22_[2];
#line 317 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp25_ = p;
#line 317 "/home/jens/Source/shotwell/src/util/image.vala"
					p = _tmp25_ + 4;
#line 1697 "image.c"
				}
#line 320 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp26_ = gdk_pixels;
#line 320 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp27_ = pixbuf;
#line 320 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp28_ = gdk_pixbuf_get_rowstride (_tmp27_);
#line 320 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp29_ = _tmp28_;
#line 320 "/home/jens/Source/shotwell/src/util/image.vala"
				gdk_pixels = _tmp26_ + _tmp29_;
#line 1709 "image.c"
			}
		}
	}
}


/**
 * Finds the size of the smallest axially-aligned rectangle that could contain
 * a rectangle src_width by src_height, rotated by angle.
 *
 * @param src_width The width of the incoming rectangle.
 * @param src_height The height of the incoming rectangle.
 * @param angle The amount to rotate by, given in degrees.
 * @param dest_width The width of the computed rectangle.
 * @param dest_height The height of the computed rectangle.
 */
void compute_arb_rotated_size (gdouble src_width, gdouble src_height, gdouble angle, gdouble* dest_width, gdouble* dest_height) {
	gdouble _vala_dest_width = 0.0;
	gdouble _vala_dest_height = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
#line 337 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = angle;
#line 337 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = degrees_to_radians (_tmp0_);
#line 337 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = fabs (_tmp1_);
#line 337 "/home/jens/Source/shotwell/src/util/image.vala"
	angle = _tmp2_;
#line 338 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = angle;
#line 338 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp3_ <= G_PI_2, "angle <= Math.PI_2");
#line 339 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = src_width;
#line 339 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = angle;
#line 339 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = cos (_tmp5_);
#line 339 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = src_height;
#line 339 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = angle;
#line 339 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = sin (_tmp8_);
#line 339 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_dest_width = (_tmp4_ * _tmp6_) + (_tmp7_ * _tmp9_);
#line 340 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp10_ = src_height;
#line 340 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp11_ = angle;
#line 340 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp12_ = cos (_tmp11_);
#line 340 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_ = src_width;
#line 340 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp14_ = angle;
#line 340 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = sin (_tmp14_);
#line 340 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_dest_height = (_tmp10_ * _tmp12_) + (_tmp13_ * _tmp15_);
#line 334 "/home/jens/Source/shotwell/src/util/image.vala"
	if (dest_width) {
#line 334 "/home/jens/Source/shotwell/src/util/image.vala"
		*dest_width = _vala_dest_width;
#line 1789 "image.c"
	}
#line 334 "/home/jens/Source/shotwell/src/util/image.vala"
	if (dest_height) {
#line 334 "/home/jens/Source/shotwell/src/util/image.vala"
		*dest_height = _vala_dest_height;
#line 1795 "image.c"
	}
}


/**
 * @brief Rotates a pixbuf to an arbitrary angle, given in degrees, and returns the rotated pixbuf.
 *
 * @param source_pixbuf The source image that needs to be angled.
 * @param angle The angle the source image should be rotated by.
 */
GdkPixbuf* rotate_arb (GdkPixbuf* source_pixbuf, gdouble angle) {
	GdkPixbuf* result = NULL;
	gdouble _tmp0_;
	gdouble x_tmp = 0.0;
	gdouble y_tmp = 0.0;
	GdkPixbuf* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GdkPixbuf* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	GdkPixbuf* dest_pixbuf = NULL;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	GdkPixbuf* _tmp16_;
	cairo_format_t _tmp17_ = 0;
	GdkPixbuf* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	cairo_surface_t* surface = NULL;
	GdkPixbuf* _tmp21_;
	void* _tmp22_;
	void* _tmp23_;
	GdkPixbuf* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	GdkPixbuf* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GdkPixbuf* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	cairo_surface_t* _tmp33_;
	cairo_t* context = NULL;
	cairo_surface_t* _tmp34_;
	cairo_t* _tmp35_;
	cairo_t* _tmp36_;
	cairo_t* _tmp37_;
	GdkPixbuf* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	GdkPixbuf* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	cairo_t* _tmp44_;
	cairo_t* _tmp45_;
	GdkPixbuf* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	GdkPixbuf* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	cairo_t* _tmp52_;
	gdouble _tmp53_;
	gdouble _tmp54_;
	cairo_t* _tmp55_;
	GdkPixbuf* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	GdkPixbuf* _tmp59_;
	gint _tmp60_;
	gint _tmp61_;
	cairo_t* _tmp62_;
	GdkPixbuf* _tmp63_;
	cairo_t* _tmp64_;
	cairo_pattern_t* _tmp65_;
	cairo_t* _tmp66_;
	GdkPixbuf* _tmp67_;
#line 349 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (source_pixbuf), NULL);
#line 353 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = angle;
#line 353 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp0_ == 0.0) {
#line 1885 "image.c"
		GdkPixbuf* _tmp1_;
		GdkPixbuf* _tmp2_;
#line 354 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = source_pixbuf;
#line 354 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 354 "/home/jens/Source/shotwell/src/util/image.vala"
		result = _tmp2_;
#line 354 "/home/jens/Source/shotwell/src/util/image.vala"
		return result;
#line 1896 "image.c"
	}
#line 361 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = source_pixbuf;
#line 361 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = gdk_pixbuf_get_width (_tmp3_);
#line 361 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = _tmp4_;
#line 361 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = source_pixbuf;
#line 361 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = gdk_pixbuf_get_height (_tmp6_);
#line 361 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = _tmp7_;
#line 361 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = angle;
#line 361 "/home/jens/Source/shotwell/src/util/image.vala"
	compute_arb_rotated_size ((gdouble) _tmp5_, (gdouble) _tmp8_, _tmp9_, &_tmp10_, &_tmp11_);
#line 361 "/home/jens/Source/shotwell/src/util/image.vala"
	x_tmp = _tmp10_;
#line 361 "/home/jens/Source/shotwell/src/util/image.vala"
	y_tmp = _tmp11_;
#line 364 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp12_ = x_tmp;
#line 364 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_ = round (_tmp12_);
#line 364 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp14_ = y_tmp;
#line 364 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = round (_tmp14_);
#line 364 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp16_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, (gint) _tmp13_, (gint) _tmp15_);
#line 364 "/home/jens/Source/shotwell/src/util/image.vala"
	dest_pixbuf = _tmp16_;
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp18_ = source_pixbuf;
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp19_ = gdk_pixbuf_get_has_alpha (_tmp18_);
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp20_ = _tmp19_;
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp20_) {
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp17_ = CAIRO_FORMAT_ARGB32;
#line 1940 "image.c"
	} else {
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp17_ = CAIRO_FORMAT_RGB24;
#line 1944 "image.c"
	}
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp21_ = dest_pixbuf;
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp22_ = gdk_pixbuf_get_pixels (_tmp21_);
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp23_ = _tmp22_;
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp24_ = dest_pixbuf;
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp25_ = gdk_pixbuf_get_width (_tmp24_);
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp26_ = _tmp25_;
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp27_ = dest_pixbuf;
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp28_ = gdk_pixbuf_get_height (_tmp27_);
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp29_ = _tmp28_;
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp30_ = dest_pixbuf;
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp31_ = gdk_pixbuf_get_rowstride (_tmp30_);
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp32_ = _tmp31_;
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp33_ = cairo_image_surface_create_for_data ((guchar*) _tmp23_, _tmp17_, _tmp26_, _tmp29_, _tmp32_);
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	surface = _tmp33_;
#line 372 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp34_ = surface;
#line 372 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp35_ = cairo_create (_tmp34_);
#line 372 "/home/jens/Source/shotwell/src/util/image.vala"
	context = _tmp35_;
#line 374 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp36_ = context;
#line 374 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_set_source_rgb (_tmp36_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp37_ = context;
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp38_ = dest_pixbuf;
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp39_ = gdk_pixbuf_get_width (_tmp38_);
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp40_ = _tmp39_;
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp41_ = dest_pixbuf;
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp42_ = gdk_pixbuf_get_height (_tmp41_);
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp43_ = _tmp42_;
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_rectangle (_tmp37_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp40_, (gdouble) _tmp43_);
#line 376 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp44_ = context;
#line 376 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_fill (_tmp44_);
#line 378 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp45_ = context;
#line 378 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp46_ = dest_pixbuf;
#line 378 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp47_ = gdk_pixbuf_get_width (_tmp46_);
#line 378 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp48_ = _tmp47_;
#line 378 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp49_ = dest_pixbuf;
#line 378 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp50_ = gdk_pixbuf_get_height (_tmp49_);
#line 378 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp51_ = _tmp50_;
#line 378 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_translate (_tmp45_, (gdouble) (_tmp48_ / 2), (gdouble) (_tmp51_ / 2));
#line 379 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp52_ = context;
#line 379 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp53_ = angle;
#line 379 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp54_ = degrees_to_radians (_tmp53_);
#line 379 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_rotate (_tmp52_, _tmp54_);
#line 380 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp55_ = context;
#line 380 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp56_ = source_pixbuf;
#line 380 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp57_ = gdk_pixbuf_get_width (_tmp56_);
#line 380 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp58_ = _tmp57_;
#line 380 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp59_ = source_pixbuf;
#line 380 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp60_ = gdk_pixbuf_get_height (_tmp59_);
#line 380 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp61_ = _tmp60_;
#line 380 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_translate (_tmp55_, (gdouble) ((-_tmp58_) / 2), (gdouble) ((-_tmp61_) / 2));
#line 382 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp62_ = context;
#line 382 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp63_ = source_pixbuf;
#line 382 "/home/jens/Source/shotwell/src/util/image.vala"
	gdk_cairo_set_source_pixbuf (_tmp62_, _tmp63_, (gdouble) 0, (gdouble) 0);
#line 383 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp64_ = context;
#line 383 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp65_ = cairo_get_source (_tmp64_);
#line 383 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_pattern_set_filter (_tmp65_, CAIRO_FILTER_BEST);
#line 384 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp66_ = context;
#line 384 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_paint (_tmp66_);
#line 388 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp67_ = dest_pixbuf;
#line 388 "/home/jens/Source/shotwell/src/util/image.vala"
	fix_cairo_pixbuf (_tmp67_);
#line 390 "/home/jens/Source/shotwell/src/util/image.vala"
	result = dest_pixbuf;
#line 390 "/home/jens/Source/shotwell/src/util/image.vala"
	_cairo_destroy0 (context);
#line 390 "/home/jens/Source/shotwell/src/util/image.vala"
	_cairo_surface_destroy0 (surface);
#line 390 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 2072 "image.c"
}


/**
 * @brief Rotates a point around the upper left corner of an image to an arbitrary angle,
 * given in degrees, and returns the rotated point, translated such that it, along with its attendant
 * image, are in positive x, positive y.
 *
 * @note May be subject to slight inaccuracy as Gdk points' coordinates may only be in whole pixels,
 * so the fractional component is lost.
 *
 * @param source_point The point to be rotated and scaled.
 * @param img_w The width of the source image (unrotated).
 * @param img_h The height of the source image (unrotated).
 * @param angle The angle the source image is to be rotated by to straighten it.
 */
void rotate_point_arb (GdkPoint* source_point, gint img_w, gint img_h, gdouble angle, gboolean invert, GdkPoint* result) {
	gdouble _tmp0_;
	gdouble dest_width = 0.0;
	gdouble dest_height = 0.0;
	gint _tmp2_;
	gint _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	cairo_matrix_t matrix = {0};
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gboolean _tmp13_;
	gdouble dest_x = 0.0;
	GdkPoint _tmp15_;
	gint _tmp16_;
	gdouble dest_y = 0.0;
	GdkPoint _tmp17_;
	gint _tmp18_;
	gdouble _tmp19_;
	gdouble _tmp20_;
	GdkPoint _tmp21_ = {0};
#line 406 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (source_point != NULL);
#line 409 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = angle;
#line 409 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp0_ == 0.0) {
#line 2121 "image.c"
		GdkPoint _tmp1_;
#line 411 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = *source_point;
#line 411 "/home/jens/Source/shotwell/src/util/image.vala"
		*result = _tmp1_;
#line 411 "/home/jens/Source/shotwell/src/util/image.vala"
		return;
#line 2129 "image.c"
	}
#line 416 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = img_w;
#line 416 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = img_h;
#line 416 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = angle;
#line 416 "/home/jens/Source/shotwell/src/util/image.vala"
	compute_arb_rotated_size ((gdouble) _tmp2_, (gdouble) _tmp3_, _tmp4_, &_tmp5_, &_tmp6_);
#line 416 "/home/jens/Source/shotwell/src/util/image.vala"
	dest_width = _tmp5_;
#line 416 "/home/jens/Source/shotwell/src/util/image.vala"
	dest_height = _tmp6_;
#line 418 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_matrix_init_identity (&matrix);
#line 419 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = dest_width;
#line 419 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = dest_height;
#line 419 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_matrix_translate (&matrix, _tmp7_ / 2, _tmp8_ / 2);
#line 420 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = angle;
#line 420 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp10_ = degrees_to_radians (_tmp9_);
#line 420 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_matrix_rotate (&matrix, _tmp10_);
#line 421 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp11_ = img_w;
#line 421 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp12_ = img_h;
#line 421 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_matrix_translate (&matrix, (gdouble) ((-_tmp11_) / 2), (gdouble) ((-_tmp12_) / 2));
#line 422 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_ = invert;
#line 422 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp13_) {
#line 2167 "image.c"
		cairo_status_t _tmp14_;
#line 423 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp14_ = cairo_matrix_invert (&matrix);
#line 423 "/home/jens/Source/shotwell/src/util/image.vala"
		_vala_assert (_tmp14_ == CAIRO_STATUS_SUCCESS, "matrix.invert() == Cairo.Status.SUCCESS");
#line 2173 "image.c"
	}
#line 425 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = *source_point;
#line 425 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp16_ = _tmp15_.x;
#line 425 "/home/jens/Source/shotwell/src/util/image.vala"
	dest_x = (gdouble) _tmp16_;
#line 426 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp17_ = *source_point;
#line 426 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp18_ = _tmp17_.y;
#line 426 "/home/jens/Source/shotwell/src/util/image.vala"
	dest_y = (gdouble) _tmp18_;
#line 427 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_matrix_transform_point (&matrix, &dest_x, &dest_y);
#line 429 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp19_ = dest_x;
#line 429 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp20_ = dest_y;
#line 429 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp21_.x = (gint) _tmp19_;
#line 429 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp21_.y = (gint) _tmp20_;
#line 429 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _tmp21_;
#line 429 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 2201 "image.c"
}


/**
 * @brief <u>De</u>rotates a point around the upper left corner of an image from an arbitrary angle,
 * given in degrees, and returns the de-rotated point, taking into account any translation necessary
 * to make sure all of the rotated image stays in positive x, positive y.
 *
 * @note May be subject to slight inaccuracy as Gdk points' coordinates may only be in whole pixels,
 * so the fractional component is lost.
 *
 * @param source_point The point to be de-rotated.
 * @param img_w The width of the source image (unrotated).
 * @param img_h The height of the source image (unrotated).
 * @param angle The angle the source image is to be rotated by to straighten it.
 */
void derotate_point_arb (GdkPoint* source_point, gint img_w, gint img_h, gdouble angle, GdkPoint* result) {
	GdkPoint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gdouble _tmp3_;
	GdkPoint _tmp4_ = {0};
#line 445 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (source_point != NULL);
#line 446 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = *source_point;
#line 446 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = img_w;
#line 446 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = img_h;
#line 446 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = angle;
#line 446 "/home/jens/Source/shotwell/src/util/image.vala"
	rotate_point_arb (&_tmp0_, _tmp1_, _tmp2_, _tmp3_, TRUE, &_tmp4_);
#line 446 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _tmp4_;
#line 446 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 2240 "image.c"
}


static gpointer _cairo_surface_reference0 (gpointer self) {
#line 484 "/home/jens/Source/shotwell/src/util/image.vala"
	return self ? cairo_surface_reference (self) : NULL;
#line 2247 "image.c"
}


cairo_surface_t* get_background_surface (void) {
	cairo_surface_t* result = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp31_;
	cairo_surface_t* _tmp32_;
#line 452 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = background_surface;
#line 452 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp0_ == NULL) {
#line 2260 "image.c"
		gchar* color_a = NULL;
		gchar* color_b = NULL;
		ConfigFacade* config = NULL;
		ConfigFacade* _tmp1_;
		gchar* type = NULL;
		ConfigFacade* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GQuark _tmp7_ = 0U;
#line 458 "/home/jens/Source/shotwell/src/util/image.vala"
		static GQuark _tmp6_label0 = 0;
#line 458 "/home/jens/Source/shotwell/src/util/image.vala"
		static GQuark _tmp6_label1 = 0;
#line 2275 "image.c"
		cairo_surface_t* _tmp17_;
		cairo_t* ctx = NULL;
		cairo_surface_t* _tmp18_;
		cairo_t* _tmp19_;
		cairo_t* _tmp20_;
		cairo_t* _tmp21_;
		const gchar* _tmp22_;
		cairo_t* _tmp23_;
		cairo_t* _tmp24_;
		cairo_t* _tmp25_;
		cairo_t* _tmp26_;
		const gchar* _tmp27_;
		cairo_t* _tmp28_;
		cairo_t* _tmp29_;
		cairo_t* _tmp30_;
#line 455 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = config_facade_get_instance ();
#line 455 "/home/jens/Source/shotwell/src/util/image.vala"
		config = _tmp1_;
#line 457 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = config;
#line 457 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp3_ = configuration_facade_get_transparent_background_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 457 "/home/jens/Source/shotwell/src/util/image.vala"
		type = _tmp3_;
#line 458 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp4_ = type;
#line 458 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp5_ = _tmp4_;
#line 458 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
#line 458 "/home/jens/Source/shotwell/src/util/image.vala"
		if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("checkered")))) {
#line 458 "/home/jens/Source/shotwell/src/util/image.vala"
			switch (0) {
#line 2311 "image.c"
				default:
				{
					gchar* _tmp8_;
					gchar* _tmp9_;
#line 460 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp8_ = g_strdup ("#808080");
#line 460 "/home/jens/Source/shotwell/src/util/image.vala"
					_g_free0 (color_a);
#line 460 "/home/jens/Source/shotwell/src/util/image.vala"
					color_a = _tmp8_;
#line 461 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp9_ = g_strdup ("#ccc");
#line 461 "/home/jens/Source/shotwell/src/util/image.vala"
					_g_free0 (color_b);
#line 461 "/home/jens/Source/shotwell/src/util/image.vala"
					color_b = _tmp9_;
#line 462 "/home/jens/Source/shotwell/src/util/image.vala"
					break;
#line 2330 "image.c"
				}
			}
		} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("solid")))) {
#line 458 "/home/jens/Source/shotwell/src/util/image.vala"
			switch (0) {
#line 2336 "image.c"
				default:
				{
					ConfigFacade* _tmp10_;
					gchar* _tmp11_;
					const gchar* _tmp12_;
					gchar* _tmp13_;
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp10_ = config;
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp11_ = configuration_facade_get_transparent_background_color (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
					_g_free0 (color_b);
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
					color_b = _tmp11_;
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp12_ = color_b;
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp13_ = g_strdup (_tmp12_);
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
					_g_free0 (color_a);
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
					color_a = _tmp13_;
#line 465 "/home/jens/Source/shotwell/src/util/image.vala"
					break;
#line 2361 "image.c"
				}
			}
		} else {
#line 458 "/home/jens/Source/shotwell/src/util/image.vala"
			switch (0) {
#line 2367 "image.c"
				default:
				{
					gchar* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
#line 467 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp14_ = g_strdup ("#000");
#line 467 "/home/jens/Source/shotwell/src/util/image.vala"
					_g_free0 (color_b);
#line 467 "/home/jens/Source/shotwell/src/util/image.vala"
					color_b = _tmp14_;
#line 467 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp15_ = color_b;
#line 467 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp16_ = g_strdup (_tmp15_);
#line 467 "/home/jens/Source/shotwell/src/util/image.vala"
					_g_free0 (color_a);
#line 467 "/home/jens/Source/shotwell/src/util/image.vala"
					color_a = _tmp16_;
#line 468 "/home/jens/Source/shotwell/src/util/image.vala"
					break;
#line 2389 "image.c"
				}
			}
		}
#line 471 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp17_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, 16, 16);
#line 471 "/home/jens/Source/shotwell/src/util/image.vala"
		_cairo_surface_destroy0 (background_surface);
#line 471 "/home/jens/Source/shotwell/src/util/image.vala"
		background_surface = _tmp17_;
#line 472 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp18_ = background_surface;
#line 472 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp19_ = cairo_create (_tmp18_);
#line 472 "/home/jens/Source/shotwell/src/util/image.vala"
		ctx = _tmp19_;
#line 473 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp20_ = ctx;
#line 473 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_set_operator (_tmp20_, CAIRO_OPERATOR_SOURCE);
#line 474 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp21_ = ctx;
#line 474 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp22_ = color_a;
#line 474 "/home/jens/Source/shotwell/src/util/image.vala"
		set_source_color_from_string (_tmp21_, _tmp22_);
#line 475 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp23_ = ctx;
#line 475 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_rectangle (_tmp23_, (gdouble) 0, (gdouble) 0, (gdouble) 8, (gdouble) 8);
#line 476 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp24_ = ctx;
#line 476 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_rectangle (_tmp24_, (gdouble) 8, (gdouble) 8, (gdouble) 8, (gdouble) 8);
#line 477 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp25_ = ctx;
#line 477 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_fill (_tmp25_);
#line 478 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp26_ = ctx;
#line 478 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp27_ = color_b;
#line 478 "/home/jens/Source/shotwell/src/util/image.vala"
		set_source_color_from_string (_tmp26_, _tmp27_);
#line 479 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp28_ = ctx;
#line 479 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_rectangle (_tmp28_, (gdouble) 0, (gdouble) 8, (gdouble) 8, (gdouble) 8);
#line 480 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp29_ = ctx;
#line 480 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_rectangle (_tmp29_, (gdouble) 8, (gdouble) 0, (gdouble) 8, (gdouble) 8);
#line 481 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp30_ = ctx;
#line 481 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_fill (_tmp30_);
#line 452 "/home/jens/Source/shotwell/src/util/image.vala"
		_cairo_destroy0 (ctx);
#line 452 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_free0 (type);
#line 452 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_object_unref0 (config);
#line 452 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_free0 (color_b);
#line 452 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_free0 (color_a);
#line 2455 "image.c"
	}
#line 484 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp31_ = background_surface;
#line 484 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp32_ = _cairo_surface_reference0 (_tmp31_);
#line 484 "/home/jens/Source/shotwell/src/util/image.vala"
	result = _tmp32_;
#line 484 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 2465 "image.c"
}


void invalidate_transparent_background (void) {
#line 488 "/home/jens/Source/shotwell/src/util/image.vala"
	_cairo_surface_destroy0 (background_surface);
#line 488 "/home/jens/Source/shotwell/src/util/image.vala"
	background_surface = NULL;
#line 2474 "image.c"
}


void paint_pixmap_with_background (cairo_t* ctx, GdkPixbuf* pixbuf, gint x, gint y) {
	GdkPixbuf* _tmp0_;
	gboolean _tmp1_;
	cairo_t* _tmp17_;
	GdkPixbuf* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	cairo_t* _tmp21_;
#line 491 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (ctx != NULL);
#line 491 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 492 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = pixbuf;
#line 492 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = gdk_pixbuf_get_has_alpha (_tmp0_);
#line 492 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp1_) {
#line 2496 "image.c"
		cairo_t* _tmp2_;
		cairo_surface_t* _tmp3_;
		cairo_surface_t* _tmp4_;
		cairo_t* _tmp5_;
		cairo_pattern_t* _tmp6_;
		cairo_t* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		GdkPixbuf* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		GdkPixbuf* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		cairo_t* _tmp16_;
#line 493 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = ctx;
#line 493 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp3_ = get_background_surface ();
#line 493 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp4_ = _tmp3_;
#line 493 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_set_source_surface (_tmp2_, _tmp4_, (gdouble) 0, (gdouble) 0);
#line 493 "/home/jens/Source/shotwell/src/util/image.vala"
		_cairo_surface_destroy0 (_tmp4_);
#line 494 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp5_ = ctx;
#line 494 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp6_ = cairo_get_source (_tmp5_);
#line 494 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_pattern_set_extend (_tmp6_, CAIRO_EXTEND_REPEAT);
#line 495 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp7_ = ctx;
#line 495 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp8_ = x;
#line 495 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp9_ = y;
#line 495 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp10_ = pixbuf;
#line 495 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp11_ = gdk_pixbuf_get_width (_tmp10_);
#line 495 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp12_ = _tmp11_;
#line 495 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp13_ = pixbuf;
#line 495 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp14_ = gdk_pixbuf_get_height (_tmp13_);
#line 495 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp15_ = _tmp14_;
#line 495 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_rectangle (_tmp7_, (gdouble) _tmp8_, (gdouble) _tmp9_, (gdouble) _tmp12_, (gdouble) _tmp15_);
#line 496 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp16_ = ctx;
#line 496 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_fill (_tmp16_);
#line 2552 "image.c"
	}
#line 499 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp17_ = ctx;
#line 499 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp18_ = pixbuf;
#line 499 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp19_ = x;
#line 499 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp20_ = y;
#line 499 "/home/jens/Source/shotwell/src/util/image.vala"
	gdk_cairo_set_source_pixbuf (_tmp17_, _tmp18_, (gdouble) _tmp19_, (gdouble) _tmp20_);
#line 500 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp21_ = ctx;
#line 500 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_paint (_tmp21_);
#line 2568 "image.c"
}


void clamp_inside_rotated_image (Box* src, gint img_w, gint img_h, gdouble angle_deg, gboolean preserve_geom, Box* result) {
	GdkPoint top_left = {0};
	Box _tmp0_;
	gint _tmp1_;
	Box _tmp2_;
	gint _tmp3_;
	GdkPoint _tmp4_ = {0};
	gint _tmp5_;
	gint _tmp6_;
	gdouble _tmp7_;
	GdkPoint _tmp8_ = {0};
	GdkPoint top_right = {0};
	Box _tmp9_;
	gint _tmp10_;
	Box _tmp11_;
	gint _tmp12_;
	GdkPoint _tmp13_ = {0};
	gint _tmp14_;
	gint _tmp15_;
	gdouble _tmp16_;
	GdkPoint _tmp17_ = {0};
	GdkPoint bottom_left = {0};
	Box _tmp18_;
	gint _tmp19_;
	Box _tmp20_;
	gint _tmp21_;
	GdkPoint _tmp22_ = {0};
	gint _tmp23_;
	gint _tmp24_;
	gdouble _tmp25_;
	GdkPoint _tmp26_ = {0};
	GdkPoint bottom_right = {0};
	Box _tmp27_;
	gint _tmp28_;
	Box _tmp29_;
	gint _tmp30_;
	GdkPoint _tmp31_ = {0};
	gint _tmp32_;
	gint _tmp33_;
	gdouble _tmp34_;
	GdkPoint _tmp35_ = {0};
	gdouble angle = 0.0;
	gdouble _tmp36_;
	gdouble _tmp37_;
	gint top_offset = 0;
	gint bottom_offset = 0;
	gint left_offset = 0;
	gint right_offset = 0;
	gint top = 0;
	GdkPoint _tmp38_;
	gint _tmp39_;
	GdkPoint _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	gint bottom = 0;
	GdkPoint _tmp47_;
	gint _tmp48_;
	GdkPoint _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	gint _tmp53_;
	gint left = 0;
	GdkPoint _tmp58_;
	gint _tmp59_;
	GdkPoint _tmp60_;
	gint _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	gint right = 0;
	GdkPoint _tmp67_;
	gint _tmp68_;
	GdkPoint _tmp69_;
	gint _tmp70_;
	gint _tmp71_;
	gint _tmp72_;
	gint _tmp73_;
	Box _tmp78_ = {0};
	gboolean _tmp79_;
#line 504 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (src != NULL);
#line 507 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = *src;
#line 507 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = _tmp0_.left;
#line 507 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = *src;
#line 507 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = _tmp2_.top;
#line 507 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_.x = _tmp1_;
#line 507 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_.y = _tmp3_;
#line 507 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = img_w;
#line 507 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = img_h;
#line 507 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = angle_deg;
#line 507 "/home/jens/Source/shotwell/src/util/image.vala"
	derotate_point_arb (&_tmp4_, _tmp5_, _tmp6_, _tmp7_, &_tmp8_);
#line 507 "/home/jens/Source/shotwell/src/util/image.vala"
	top_left = _tmp8_;
#line 508 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = *src;
#line 508 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp10_ = _tmp9_.right;
#line 508 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp11_ = *src;
#line 508 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp12_ = _tmp11_.top;
#line 508 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_.x = _tmp10_;
#line 508 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_.y = _tmp12_;
#line 508 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp14_ = img_w;
#line 508 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = img_h;
#line 508 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp16_ = angle_deg;
#line 508 "/home/jens/Source/shotwell/src/util/image.vala"
	derotate_point_arb (&_tmp13_, _tmp14_, _tmp15_, _tmp16_, &_tmp17_);
#line 508 "/home/jens/Source/shotwell/src/util/image.vala"
	top_right = _tmp17_;
#line 509 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp18_ = *src;
#line 509 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp19_ = _tmp18_.left;
#line 509 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp20_ = *src;
#line 509 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp21_ = _tmp20_.bottom;
#line 509 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp22_.x = _tmp19_;
#line 509 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp22_.y = _tmp21_;
#line 509 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp23_ = img_w;
#line 509 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp24_ = img_h;
#line 509 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp25_ = angle_deg;
#line 509 "/home/jens/Source/shotwell/src/util/image.vala"
	derotate_point_arb (&_tmp22_, _tmp23_, _tmp24_, _tmp25_, &_tmp26_);
#line 509 "/home/jens/Source/shotwell/src/util/image.vala"
	bottom_left = _tmp26_;
#line 510 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp27_ = *src;
#line 510 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp28_ = _tmp27_.right;
#line 510 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp29_ = *src;
#line 510 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp30_ = _tmp29_.bottom;
#line 510 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp31_.x = _tmp28_;
#line 510 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp31_.y = _tmp30_;
#line 510 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp32_ = img_w;
#line 510 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp33_ = img_h;
#line 510 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp34_ = angle_deg;
#line 510 "/home/jens/Source/shotwell/src/util/image.vala"
	derotate_point_arb (&_tmp31_, _tmp32_, _tmp33_, _tmp34_, &_tmp35_);
#line 510 "/home/jens/Source/shotwell/src/util/image.vala"
	bottom_right = _tmp35_;
#line 512 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp36_ = angle_deg;
#line 512 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp37_ = degrees_to_radians (_tmp36_);
#line 512 "/home/jens/Source/shotwell/src/util/image.vala"
	angle = _tmp37_;
#line 513 "/home/jens/Source/shotwell/src/util/image.vala"
	top_offset = 0;
#line 513 "/home/jens/Source/shotwell/src/util/image.vala"
	bottom_offset = 0;
#line 513 "/home/jens/Source/shotwell/src/util/image.vala"
	left_offset = 0;
#line 513 "/home/jens/Source/shotwell/src/util/image.vala"
	right_offset = 0;
#line 515 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp38_ = top_left;
#line 515 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp39_ = _tmp38_.y;
#line 515 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp40_ = top_right;
#line 515 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp41_ = _tmp40_.y;
#line 515 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp42_ = MIN (_tmp39_, _tmp41_);
#line 515 "/home/jens/Source/shotwell/src/util/image.vala"
	top = _tmp42_;
#line 516 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp43_ = top;
#line 516 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp43_ < 0) {
#line 2772 "image.c"
		gint _tmp44_;
		gdouble _tmp45_;
		gdouble _tmp46_;
#line 517 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp44_ = top;
#line 517 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp45_ = angle;
#line 517 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp46_ = cos (_tmp45_);
#line 517 "/home/jens/Source/shotwell/src/util/image.vala"
		top_offset = (gint) ((0 - _tmp44_) * _tmp46_);
#line 2784 "image.c"
	}
#line 519 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp47_ = bottom_left;
#line 519 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp48_ = _tmp47_.y;
#line 519 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp49_ = bottom_right;
#line 519 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp50_ = _tmp49_.y;
#line 519 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp51_ = MAX (_tmp48_, _tmp50_);
#line 519 "/home/jens/Source/shotwell/src/util/image.vala"
	bottom = _tmp51_;
#line 520 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp52_ = bottom;
#line 520 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp53_ = img_h;
#line 520 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp52_ > _tmp53_) {
#line 2804 "image.c"
		gint _tmp54_;
		gint _tmp55_;
		gdouble _tmp56_;
		gdouble _tmp57_;
#line 521 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp54_ = img_h;
#line 521 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp55_ = bottom;
#line 521 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp56_ = angle;
#line 521 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp57_ = cos (_tmp56_);
#line 521 "/home/jens/Source/shotwell/src/util/image.vala"
		bottom_offset = (gint) ((_tmp54_ - _tmp55_) * _tmp57_);
#line 2819 "image.c"
	}
#line 523 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp58_ = top_left;
#line 523 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp59_ = _tmp58_.x;
#line 523 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp60_ = bottom_left;
#line 523 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp61_ = _tmp60_.x;
#line 523 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp62_ = MIN (_tmp59_, _tmp61_);
#line 523 "/home/jens/Source/shotwell/src/util/image.vala"
	left = _tmp62_;
#line 524 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp63_ = left;
#line 524 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp63_ < 0) {
#line 2837 "image.c"
		gint _tmp64_;
		gdouble _tmp65_;
		gdouble _tmp66_;
#line 525 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp64_ = left;
#line 525 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp65_ = angle;
#line 525 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp66_ = cos (_tmp65_);
#line 525 "/home/jens/Source/shotwell/src/util/image.vala"
		left_offset = (gint) ((0 - _tmp64_) * _tmp66_);
#line 2849 "image.c"
	}
#line 527 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp67_ = top_right;
#line 527 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp68_ = _tmp67_.x;
#line 527 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp69_ = bottom_right;
#line 527 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp70_ = _tmp69_.x;
#line 527 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp71_ = MAX (_tmp68_, _tmp70_);
#line 527 "/home/jens/Source/shotwell/src/util/image.vala"
	right = _tmp71_;
#line 528 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp72_ = right;
#line 528 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp73_ = img_w;
#line 528 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp72_ > _tmp73_) {
#line 2869 "image.c"
		gint _tmp74_;
		gint _tmp75_;
		gdouble _tmp76_;
		gdouble _tmp77_;
#line 529 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp74_ = img_w;
#line 529 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp75_ = right;
#line 529 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp76_ = angle;
#line 529 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp77_ = cos (_tmp76_);
#line 529 "/home/jens/Source/shotwell/src/util/image.vala"
		right_offset = (gint) ((_tmp74_ - _tmp75_) * _tmp77_);
#line 2884 "image.c"
	}
#line 531 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp79_ = preserve_geom;
#line 531 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp79_) {
#line 2890 "image.c"
		gint _tmp80_;
		gint _tmp81_;
		gint _tmp82_;
		gint _tmp83_;
		Box _tmp84_ = {0};
#line 531 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp80_ = left_offset;
#line 531 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp81_ = right_offset;
#line 531 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp82_ = top_offset;
#line 531 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp83_ = bottom_offset;
#line 531 "/home/jens/Source/shotwell/src/util/image.vala"
		box_get_offset (src, _tmp80_ + _tmp81_, _tmp82_ + _tmp83_, &_tmp84_);
#line 531 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp78_ = _tmp84_;
#line 2908 "image.c"
	} else {
		Box _tmp85_;
		gint _tmp86_;
		gint _tmp87_;
		Box _tmp88_;
		gint _tmp89_;
		gint _tmp90_;
		Box _tmp91_;
		gint _tmp92_;
		gint _tmp93_;
		Box _tmp94_;
		gint _tmp95_;
		gint _tmp96_;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp85_ = *src;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp86_ = _tmp85_.left;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp87_ = left_offset;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp88_ = *src;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp89_ = _tmp88_.top;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp90_ = top_offset;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp91_ = *src;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp92_ = _tmp91_.right;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp93_ = right_offset;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp94_ = *src;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp95_ = _tmp94_.bottom;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp96_ = bottom_offset;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		box_init (&_tmp78_, _tmp86_ + _tmp87_, _tmp89_ + _tmp90_, _tmp92_ + _tmp93_, _tmp95_ + _tmp96_);
#line 2948 "image.c"
	}
#line 531 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _tmp78_;
#line 531 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 2954 "image.c"
}



