#include "Benchmark.h"
#include <wibble/exception.h>

#include <stdarg.h>
#include <time.h>
#include <iostream>

using namespace std;

Timer::~Timer()
{
	done();
}

void Timer::done()
{
	if (start != -1)
	{
		clock_t end = clock();

		cout << desc << ": " << (double)(end - start) / (double)CLOCKS_PER_SEC * 1000.0 << "ms" << endl;

		start = -1;
	}
}


static Benchmark* _root = 0;
Benchmark* Benchmark::root()
{
	if (!_root)
		_root = new Benchmark("");
	return _root;
}


// Run only the subtest at the given path
void Benchmark::run(const std::string& path)
{
	size_t split = path.find('/');
	if (split == std::string::npos)
	{
		for (std::vector<Benchmark*>::iterator i = children.begin();
				i != children.end(); i++)
			if ((*i)->name() == path)
				return (*i)->run();
	} else {
		std::string child(path, 0, split);
		std::string nextpath(path, split+1);

		for (std::vector<Benchmark*>::iterator i = children.begin();
				i != children.end(); i++)
			if ((*i)->name() == child)
				return (*i)->run(nextpath);
	}
	throw wibble::exception::Consistency("looking for benchmark " + path + " at " + fullName(), "benchmark not found");
}

// Run all subtests and this test
void Benchmark::run()
{
	// First, run children
	if (! children.empty())
	{
		Timer t = mktimer("total");
		for (std::vector<Benchmark*>::iterator i = children.begin();
				i != children.end(); i++)
			(*i)->run();
	}

	// Then, run self
	main();
}
// vim:set ts=4 sw=4:
