/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * UniPhier UMC (Universal Memory Controller) registers
 *
 * Copyright (C) 2011-2014 Panasonic Corporation
 */

#ifndef ARCH_UMC_REGS_H
#define ARCH_UMC_REGS_H

#include <linux/bitops.h>

#define UMC_CPURST		0x00000700
#define UMC_IDSRST		0x0000070C
#define UMC_IXMRST		0x00000714
#define UMC_HDMRST		0x00000718
#define UMC_MDMRST		0x0000071C
#define UMC_HDDRST		0x00000720
#define UMC_MDDRST		0x00000724
#define UMC_SIORST		0x00000728
#define UMC_GIORST		0x0000072C
#define UMC_HD2RST		0x00000734
#define UMC_VIORST		0x0000073C
#define UMC_FRCRST		0x00000748 /* LD4/sLD8 */
#define UMC_DVCRST		0x00000748 /* Pro4 */
#define UMC_RGLRST		0x00000750
#define UMC_VPERST		0x00000758
#define UMC_AIORST		0x00000764
#define UMC_DMDRST		0x00000770

#define UMC_HDMCHSEL		0x00000898
#define UMC_MDMCHSEL		0x0000089C
#define UMC_DVCCHSEL		0x000008C8
#define UMC_DMDCHSEL		0x000008F0

#define UMC_CLKEN_SSIF_FETCH	0x0000C060
#define UMC_CLKEN_SSIF_COMQUE0	0x0000C064
#define UMC_CLKEN_SSIF_COMWC0	0x0000C068
#define UMC_CLKEN_SSIF_COMRC0	0x0000C06C
#define UMC_CLKEN_SSIF_COMQUE1	0x0000C070
#define UMC_CLKEN_SSIF_COMWC1	0x0000C074
#define UMC_CLKEN_SSIF_COMRC1	0x0000C078
#define UMC_CLKEN_SSIF_WC	0x0000C07C
#define UMC_CLKEN_SSIF_RC	0x0000C080
#define UMC_CLKEN_SSIF_DST	0x0000C084

#define UMC_CMDCTLA		0x00000000
#define UMC_CMDCTLB		0x00000004
#define UMC_INITSET		0x00000014
#define   UMC_INITSET_INIT1EN		BIT(1)	/* init without power-on wait */
#define   UMC_INITSET_INIT0EN		BIT(0)	/* init with power-on wait */
#define UMC_INITSTAT		0x00000018
#define   UMC_INITSTAT_INIT1ST		BIT(1)	/* init without power-on wait */
#define   UMC_INITSTAT_INIT0ST		BIT(0)	/* init with power-on wait */
#define UMC_SPCCTLA		0x00000030
#define UMC_SPCCTLB		0x00000034
#define UMC_SPCSETA		0x00000038
#define UMC_SPCSETB		0x0000003C
#define   UMC_SPCSETB_AREFMD_MASK	(0x3)	/* Auto Refresh Mode */
#define   UMC_SPCSETB_AREFMD_ARB	(0x0)	/* control by arbitor */
#define   UMC_SPCSETB_AREFMD_CONT	(0x1)	/* control by DRAMCONT */
#define   UMC_SPCSETB_AREFMD_REG	(0x2)	/* control by register */
#define UMC_SPCSETC		0x00000040
#define UMC_SPCSETD		0x00000044
#define UMC_SPCSTATA		0x00000050
#define UMC_SPCSTATB		0x00000054
#define UMC_SPCSTATC		0x00000058
#define UMC_ACSSETA		0x00000060
#define UMC_FLOWCTLA		0x00000400
#define UMC_FLOWCTLB		0x00000404
#define UMC_FLOWCTLC		0x00000408
#define UMC_FLOWCTLG		0x00000508
#define UMC_FLOWCTLOB0		0x00000520
#define UMC_FLOWCTLOB1		0x00000524
#define UMC_RDATACTL_D0		0x00000600
#define   UMC_RDATACTL_RADLTY_SHIFT	4
#define   UMC_RDATACTL_RADLTY_MASK	(0xf << (UMC_RDATACTL_RADLTY_SHIFT))
#define   UMC_RDATACTL_RAD2LTY_SHIFT	8
#define   UMC_RDATACTL_RAD2LTY_MASK	(0xf << (UMC_RDATACTL_RAD2LTY_SHIFT))
#define UMC_WDATACTL_D0		0x00000604
#define UMC_RDATACTL_D1		0x00000608
#define UMC_WDATACTL_D1		0x0000060C
#define UMC_DATASET		0x00000610
#define UMC_RESPCTL		0x00000624
#define UMC_DCCGCTL		0x00000720
#define UMC_DICGCTLA		0x00000724
#define UMC_DICGCTLB		0x00000728
#define UMC_ERRMASKA		0x00000958
#define UMC_ERRMASKB		0x0000095c
#define UMC_BSICMAPSET		0x00000988
#define UMC_DIOCTLA		0x00000C00
#define   UMC_DIOCTLA_CTL_NRST		BIT(8)	/* ctl_rst_n */
#define   UMC_DIOCTLA_CFG_NRST		BIT(0)	/* cfg_rst_n */
#define UMC_DFICUPDCTLA		0x00000C20

/* UM registers */
#define UMC_MBUS0		0x00080004
#define UMC_MBUS1		0x00081004
#define UMC_MBUS2		0x00082004
#define UMC_MBUS3		0x00083004

/* UD registers */
#define UMC_BITPERPIXELMODE_D0	0x010
#define UMC_PAIR1DOFF_D0	0x054

#endif
