var Cu = Components.utils;
var Ci = Components.interfaces;
var Cc = Components.classes;
var Cr = Components.results;

const typeError = TypeError;

var jumlib = {};
Components.utils.import("resource://mozmill/modules/jum.js", jumlib);

Cu.import("resource://unity/unity-api.js");

function setupModule(module) {
  module.controller = mozmill.getBrowserController();
}

var CallbackManager = {
    makeCallback: function (type, callback) {
        return callback;
    },
    releaseCallback: function() {
    }
};

function dumb() {
}

function testGeneral(){
    var uwa = {
        notification_show_notification: dumb,
        music_player_set_playback_state: dumb,
        music_player_set_track: dumb
    };

    var Unity = makeAPI(dumb, dumb, dumb, dumb, dumb, uwa, {context: 1}, CallbackManager, dumb);
    var error;
    try {
        Unity.Notification.showNotification(null);
    } catch (x) {
        error = x;
    }
    jumlib.assertNotNull(error);

    error = null;
    try {
        Unity.Notification.showNotification(null, null, null);
    } catch (x) {
        error = x;
    }
    jumlib.assertNotNull(error);

    error = null;
    try {
        Unity.Notification.showNotification('abc', 'sdfgh', null);
    } catch (x) {
        error = x;
    }
    jumlib.assertEquals(error, null);

    error = null;
    try {
        Unity.MediaPlayer.setPlaybackState("sdsad");
    } catch (x) {
        error = x;
    }
    jumlib.assertNotNull(error);

    error = null;
    try {
        Unity.MediaPlayer.setPlaybackState(1);
    } catch (x) {
        error = x;
    }
    jumlib.assertEquals(error, null);

    error = null;
    try {
        Unity.MediaPlayer.setTrack({ artist: null, album: null, title: "sdsa" });
    } catch (x) {
        error = x;
    }
    jumlib.assertEquals(error, null);

    error = null;
    try {
        Unity.MediaPlayer.setTrack({ artist: null, album: "sdas", title: null });
    } catch (x) {
        error = x;
    }
    jumlib.assertNotNull(error);
}

function testMediaPlayerSetTrack() {
    var uwa = {
        notification_show_notification: dumb,
        music_player_set_playback_state: dumb,
        music_player_set_track: function (context, artist, album, title) {
            jumlib.assertEquals(artist, "artist");
            jumlib.assertEquals(album, "album");
            jumlib.assertEquals(title, "title");
        }
    };

    var Unity = makeAPI(dumb, dumb, dumb, dumb, dumb, uwa, {context: 1}, CallbackManager, dumb);
    var error = null;
    try {
        Unity = makeAPI(dumb, dumb, dumb, dumb, dumb, uwa, {context: 1}, CallbackManager, dumb);
        Unity.MediaPlayer.setTrack({ artist: "artist", album: "album", title: "title" });
    } catch (x) {
        error = x;
    }
    jumlib.assertEquals(error, null);
}

function testLauncher() {
    var ct = 0;
    var uwa = {
        launcher_set_count: function (context, count) {
            jumlib.assertEquals(count, 42);
            ct++;
        },
        launcher_clear_count: function () {
            ct++;
        },
        launcher_set_progress: function (context, progress) {
            jumlib.assertEquals(progress, 43);
            ct++;
        },
        launcher_clear_progress: dumb,
        launcher_set_urgent: dumb,
        launcher_add_action: function (context, name, callback) {
            jumlib.assertEquals(name, "action 1");
            ct++;
            callback();
        }
    };

    var Unity = makeAPI(dumb, dumb, dumb, dumb, dumb, uwa, {context: 1}, CallbackManager, dumb);

    Unity.Launcher.setCount(42);
    Unity.Launcher.clearCount();
    Unity.Launcher.setProgress(43);
    Unity.Launcher.addAction('action 1', function () {
        ct++;
    });

    jumlib.assertEquals(ct, 5);
}

function testMessagingIndicator() {
    var ct = 0;
    function inc() {
        ct++;
    }
    var uwa = {
        indicator_add_action: function (context, name, callback, dummy) {
            ct++;
            jumlib.assertEquals(name, 'action 1');
            jumlib.assertEquals(dummy, null);
        },
        indicator_show_indicator: function (context, name) {
            ct++;
            jumlib.assertEquals(name, 'indicator 1');
        },
        indicator_set_property: function (context, name, propName, value) {
            jumlib.assertEquals(name, 'indicator 1');
            jumlib.assertEquals(propName, 'prop1');
            jumlib.assertEquals(value, '42');
            ct++;
        },
        indicator_set_callback: function(context, name, callback) {
            jumlib.assertEquals(name, 'indicator 1');
            callback();
            ct++;
        },
        indicator_set_property_icon: function (context, name, tmp, icon) {
            jumlib.assertEquals(name, 'indicator 1');
            jumlib.assertEquals(icon, 'icon://');
            ct++;
        },
        indicator_clear_indicator: inc,
        indicator_clear_indicators: inc
    };

    var Unity = makeAPI(dumb, dumb, dumb, dumb, dumb, uwa, {context: 1}, CallbackManager, dumb);
    Unity.MessagingIndicator.clearIndicator('action 1');

    Unity.MessagingIndicator.addAction('action 1', inc);
    Unity.MessagingIndicator.clearIndicator('action 1');
    Unity.MessagingIndicator.clearIndicators();
    Unity.MessagingIndicator.showIndicator('indicator 1', { icon: 'icon://',
                                                            prop1: 42,
                                                            callback: inc});
    jumlib.assertEquals(ct, 9);
}
