#! /usr/bin/python3
# -*- coding: utf-8 -*-
import imp
from unittest import TestCase

import dbusmock
from gi.repository import Unity

TOMBOY_BUS_NAME = 'org.gnome.Tomboy'
TOMBOY_BUS_PATH = '/org/gnome/Tomboy/RemoteControl'
TOMBOY_IFACE = 'org.gnome.Tomboy.RemoteControl'

class ResultSet(Unity.ResultSet):
    def __init__(self):
        Unity.ResultSet.__init__(self)
        self.results = []

    def do_add_result(self, result):
        self.results.append({'uri':result.uri,
                             'title':result.title,
                             'comment':result.comment,
                             'icon':result.icon_hint})


class ScopeTestCase:
    def init_scope(self, scope_path):
        self.scope_module = imp.load_source('scope', scope_path)
        self.scope = self.scope_module.load_scope()

    def perform_query(self, query, filter_set = Unity.FilterSet.new()):
        result_set = ResultSet()
        ctx = Unity.SearchContext.create(query, 0, filter_set,
                                         None, result_set, None)
        s = self.scope.create_search_for_query(ctx)
        s.run()
        return result_set


class TestTomboy(dbusmock.DBusTestCase, ScopeTestCase):
    def setUp(self):
        self.init_scope('src/unity_tomboy_daemon.py')

    def tearDown(self):
        self.scope = None
        self.scope_module = None

    @classmethod
    def setUpClass(cls):
        """Set up a session bus running a mock version of the Tomboy
        remote control interface."""
        cls.start_session_bus()
        cls.session_bus = cls.get_dbus()

        cls.tomboy_proc = cls.spawn_server(
            TOMBOY_BUS_NAME, TOMBOY_BUS_PATH, TOMBOY_IFACE)
        tomboy = cls.session_bus.get_object(TOMBOY_BUS_NAME, TOMBOY_BUS_PATH)
        tomboy.AddMethod(TOMBOY_IFACE, 'SearchNotes', 'sb', 'as',
                         '''ret = [args[0]] if args[0] != 'invalid' else []''')
        tomboy.AddMethod(TOMBOY_IFACE, 'GetNoteChangeDate', 's', 'i',
                         '''ret = 1356998400''')
        tomboy.AddMethod(TOMBOY_IFACE, 'GetTagsForNote', 's', 'as',
                         '''ret = ['tag1', 'tag2']''')
        tomboy.AddMethod(TOMBOY_IFACE, 'GetNoteTitle', 's', 's',
                         '''ret = '{} title'.format(args[0])''')
        tomboy.AddMethod(TOMBOY_IFACE, 'GetNoteContents', 's', 's',
                         '''ret = '{} contents'.format(args[0])''')

    @classmethod
    def tearDownClass(cls):
        cls.tomboy_proc.terminate()
        cls.tomboy_proc.wait()
        super(TestTomboy, cls).tearDownClass()

    def test_valid_search(self):
        result_set = self.perform_query('foo')
        self.assertEqual(len(result_set.results), 1)
        result = result_set.results[0]
        self.assertEqual(result['title'], 'foo title')
        self.assertEqual(result['comment'], 'foo contents')

    def test_failing_search(self):
        result_set = self.perform_query('invalid')
        self.assertEqual(len(result_set.results), 0)

if __name__ == '__main__':
    unittest.main()
