/* workshop.c */
void workshop_init(void);
void workshop_postinit(void);
void ex_wsverb(exarg_T *eap);
char *workshop_get_editor_name(void);
char *workshop_get_editor_version(void);
void workshop_load_file(char *filename, int line, char *frameid);
void workshop_reload_file(char *filename, int line);
void workshop_show_file(char *filename);
void workshop_goto_line(char *filename, int lineno);
void workshop_front_file(char *filename);
void workshop_save_file(char *filename);
void workshop_save_files(void);
void workshop_quit(void);
void workshop_minimize(void);
void workshop_maximize(void);
void workshop_add_mark_type(int idx, char *colorspec, char *sign);
void workshop_set_mark(char *filename, int lineno, int markId, int idx);
void workshop_change_mark_type(char *filename, int markId, int idx);
void workshop_goto_mark(char *filename, int markId, char *message);
void workshop_delete_mark(char *filename, int markId);
int workshop_get_mark_lineno(char *filename, int markId);
void workshop_moved_marks(char *filename);
int workshop_get_font_height(void);
void workshop_footer_message(char *message, int severity);
void workshop_menu_begin(char *label);
void workshop_submenu_begin(char *label);
void workshop_submenu_end(void);
void workshop_menu_item(char *label, char *verb, char *accelerator, char *acceleratorText, char *name, char *filepos, char *sensitive);
void workshop_menu_end(void);
void workshop_toolbar_begin(void);
void workshop_toolbar_end(void);
void workshop_toolbar_button(char *label, char *verb, char *senseVerb, char *filepos, char *help, char *sense, char *file, char *left);
void workshop_frame_sensitivities(VerbSense *vs);
void workshop_set_option(char *option, char *value);
void workshop_balloon_mode(Boolean on);
void workshop_balloon_delay(int delay);
void workshop_show_balloon_tip(char *tip);
void workshop_hotkeys(Boolean on);
int workshop_get_positions(void *clientData, char **filename, int *curLine, int *curCol, int *selStartLine, int *selStartCol, int *selEndLine, int *selEndCol, int *selLength, char **selection);
char *workshop_test_getcurrentfile(void);
int workshop_test_getcursorrow(void);
int workshop_test_getcursorcol(void);
char *workshop_test_getcursorrowtext(void);
char *workshop_test_getselectedtext(void);
void workshop_save_sensitivity(char *filename);
void workshop_beval_cb(BalloonEval *beval, int state);
void findYourself(char *argv0);
/* vim: set ft=c : */
