<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:dc="http://purl.org/dc/elements/1.1/"
  xmlns:wfw="http://wellformedweb.org/CommentAPI/"
  xmlns:slash="http://purl.org/rss/1.0/modules/slash/"
  xmlns:content="http://purl.org/rss/1.0/modules/content/"
  xmlns:r="http://backend.userland.com/rss2"
  xmlns:rss="http://purl.org/rss/1.0/"
  xmlns="http://www.w3.org/2005/Atom"
  version="1.0">

<xsl:output indent="yes"  />


<!-- general element conversions -->

<xsl:template match="/">
  <xsl:comment>ATOM based XML document generated By OpenLink Virtuoso</xsl:comment>
  <feed>
      <xsl:apply-templates />
  </feed>
</xsl:template>

<xsl:template match="rdf:RDF/rss:channel">
    <id><xsl:value-of select="rss:link"/></id>
    <xsl:apply-templates />
</xsl:template>

<xsl:template match="rss:title">
    <title><xsl:value-of select="." /></title>
</xsl:template>

<xsl:template match="rss:link">
    <link href="{.}" type="text/html" rel="alternate"/>
    <xsl:if test="parent::channel">
	<link href="{.}gems/atom10.xml" type="application/atom+xml" rel="self"/>
    </xsl:if>
</xsl:template>

<xsl:template match="rss:channel/rss:description[.!='']">
    <subtitle><xsl:apply-templates /></subtitle>
</xsl:template>

<xsl:template match="rss:channel/rss:copyright">
    <rights><xsl:apply-templates /></rights>
</xsl:template>

<xsl:template match="rss:channel/rss:managingEditor[.!='']">
	<xsl:call-template name="author"/>
</xsl:template>

<xsl:template match="rss:channel/dc:date">
    <updated><xsl:value-of select="."/></updated>
</xsl:template>


<xsl:template match="rss:channel/rss:category">
    <category>
	<xsl:apply-templates />
    </category>
</xsl:template>

<xsl:template match="rss:channel/rss:generator">
    <generator>
	<xsl:apply-templates />
    </generator>
</xsl:template>

<xsl:template match="rss:channel/rss:image">
    <logo><xsl:apply-templates select="url"/></logo>
</xsl:template>

<xsl:template match="rss:item/rss:author[.!='']">
    <xsl:call-template name="author"/>
</xsl:template>

<xsl:template match="rss:item/rss:description">
    <content type="html">
	<xsl:apply-templates />
    </content>
</xsl:template>


<xsl:template match="rss:item/dc:date">
    <published><xsl:value-of select="."/></published>
</xsl:template>

<xsl:template match="rss:item">
    <entry>
	<id><xsl:value-of select="@rdf:about" /></id>
	<xsl:apply-templates />
    </entry>
</xsl:template>

<xsl:template match="rss:channel/rss:language" />
<xsl:template match="rss:channel/rss:webMaster" />
<xsl:template match="rss:channel/rss:cloud" />
<xsl:template match="wfw:*" />
<xsl:template match="dc:*" />
<xsl:template match="slash:*" />
<xsl:template match="rss:items" />
<xsl:template match="rss:item/rss:comments" />
<xsl:template match="rss:item/rss:enclosure" />

<xsl:template match="@*" />

<xsl:template match="text()">
  <xsl:value-of select="normalize-space(.)" />
</xsl:template>

<xsl:template name="author">
    <author>
	<xsl:choose>
	    <xsl:when test="contains (., '&lt;')">
		<name><xsl:value-of select="normalize-space (substring-before (.,'&lt;'))"/></name>
		<email><xsl:value-of select="translate (substring-after (.,'&lt;'), '&gt;', '')"/></email>
	    </xsl:when>
	    <xsl:when test="contains (., '(')">
		<name><xsl:value-of select="translate (substring-after (.,'('), ')', '')"/></name>
		<email><xsl:value-of select="normalize-space (substring-before (.,'('))"/></email>
	    </xsl:when>
	    <xsl:otherwise>
		<name><xsl:value-of select="."/></name>
		<email><xsl:value-of select="."/></email>
	    </xsl:otherwise>
	</xsl:choose>
    </author>
</xsl:template>

<xsl:template name="date">
  <xsl:variable name="m" select="substring(., 9, 3)" />
  <xsl:value-of select="substring(., 13, 4)"
  />-<xsl:choose>
    <xsl:when test="$m='Jan'">01</xsl:when>
    <xsl:when test="$m='Feb'">02</xsl:when>
    <xsl:when test="$m='Mar'">03</xsl:when>
    <xsl:when test="$m='Apr'">04</xsl:when>
    <xsl:when test="$m='May'">05</xsl:when>
    <xsl:when test="$m='Jun'">06</xsl:when>
    <xsl:when test="$m='Jul'">07</xsl:when>
    <xsl:when test="$m='Aug'">08</xsl:when>
    <xsl:when test="$m='Sep'">09</xsl:when>
    <xsl:when test="$m='Oct'">10</xsl:when>
    <xsl:when test="$m='Nov'">11</xsl:when>
    <xsl:when test="$m='Dec'">12</xsl:when>
    <xsl:otherwise>00</xsl:otherwise>
  </xsl:choose>-<xsl:value-of select="substring(., 6, 2)"
  />T<xsl:value-of select="substring(., 18, 8)" /><xsl:text>Z</xsl:text>
</xsl:template>

<xsl:template name="removeTags">
  <xsl:param name="html" select="." />
  <xsl:choose>
    <xsl:when test="contains($html,'&lt;')">
      <xsl:call-template name="removeEntities">
        <xsl:with-param name="html" select="substring-before($html,'&lt;')" />
      </xsl:call-template>
      <xsl:call-template name="removeTags">
        <xsl:with-param name="html" select="substring-after($html, '&gt;')" />
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="removeEntities">
        <xsl:with-param name="html" select="$html" />
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="removeEntities">
  <xsl:param name="html" select="." />
  <xsl:choose>
    <xsl:when test="contains($html,'&amp;')">
      <xsl:value-of select="substring-before($html,'&amp;')" />
      <xsl:variable name="c" select="substring-before(substring-after($html,'&amp;'),';')" />
      <xsl:choose>
        <xsl:when test="$c='nbsp'">&#160;</xsl:when>
        <xsl:when test="$c='lt'">&lt;</xsl:when>
        <xsl:when test="$c='gt'">&gt;</xsl:when>
        <xsl:when test="$c='amp'">&amp;</xsl:when>
        <xsl:when test="$c='quot'">&quot;</xsl:when>
        <xsl:when test="$c='apos'">&apos;</xsl:when>
        <xsl:otherwise>?</xsl:otherwise>
      </xsl:choose>
      <xsl:call-template name="removeTags">
        <xsl:with-param name="html" select="substring-after($html, ';')" />
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$html" />
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>
