/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.GlobalOrderComparer;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public final class SimpleMappingExpression
extends Expression
implements ContextMappingFunction {
    private Expression start;
    private Expression step;
    private boolean isHybrid;

    public SimpleMappingExpression(Expression start, Expression step, boolean isHybrid) {
        this.start = start;
        this.step = step;
        this.isHybrid = isHybrid;
        this.adoptChildExpression(start);
        this.adoptChildExpression(step);
    }

    public Expression getStartExpression() {
        return this.start;
    }

    public Expression getStepExpression() {
        return this.step;
    }

    public boolean isHybrid() {
        return this.isHybrid;
    }

    public final ItemType getItemType(TypeHierarchy th) {
        return this.step.getItemType(th);
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) {
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression step2;
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Expression start2 = visitor.optimize(this.start, contextItemType);
        if (start2 != this.start) {
            this.adoptChildExpression(start2);
            this.start = start2;
        }
        if ((step2 = this.step.optimize(visitor, this.start.getItemType(th))) != this.step) {
            this.adoptChildExpression(step2);
            this.step = step2;
        }
        PromotionOffer offer = new PromotionOffer(opt);
        offer.action = 10;
        offer.promoteDocumentDependent = (this.start.getSpecialProperties() & 0x10000) != 0;
        offer.containingExpression = this;
        this.step = this.doPromotion(this.step, offer);
        visitor.resetStaticProperties();
        if (offer.containingExpression != this) {
            offer.containingExpression = visitor.optimize(visitor.typeCheck(offer.containingExpression, contextItemType), contextItemType);
            return offer.containingExpression;
        }
        return this;
    }

    public Expression promote(PromotionOffer offer) throws XPathException {
        Expression exp = offer.accept(this);
        if (exp != null) {
            return exp;
        }
        this.start = this.doPromotion(this.start, offer);
        if (offer.action == 12 || offer.action == 14) {
            this.step = this.doPromotion(this.step, offer);
        }
        return this;
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.start, this.step);
    }

    public boolean hasLoopingSubexpression(Expression child) {
        return child == this.step;
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.start == original) {
            this.start = replacement;
            found = true;
        }
        if (this.step == original) {
            this.step = replacement;
            found = true;
        }
        return found;
    }

    public int computeDependencies() {
        return this.start.getDependencies() | this.step.getDependencies() & 0x261;
    }

    public Expression copy() {
        return new SimpleMappingExpression(this.start.copy(), this.step.copy(), this.isHybrid);
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        if ((this.start.getSpecialProperties() & this.step.getSpecialProperties() & 0x400000) != 0) {
            p |= 0x400000;
        }
        return p;
    }

    public int computeCardinality() {
        int c1 = this.start.getCardinality();
        int c2 = this.step.getCardinality();
        return Cardinality.multiply(c1, c2);
    }

    public boolean equals(Object other) {
        if (!(other instanceof SimpleMappingExpression)) {
            return false;
        }
        SimpleMappingExpression p = (SimpleMappingExpression)other;
        return this.start.equals(p.start) && this.step.equals(p.step);
    }

    public int hashCode() {
        return "SimpleMappingExpression".hashCode() + this.start.hashCode() + this.step.hashCode();
    }

    public SequenceIterator iterate(final XPathContext context) throws XPathException {
        SequenceIterator result = this.start.iterate(context);
        XPathContextMinor context2 = context.newMinorContext();
        context2.setCurrentIterator(result);
        context2.setOriginatingConstructType(2025);
        result = new ContextMappingIterator(this, context2);
        if (this.isHybrid) {
            final SimpleMappingExpression loc = this;
            Item first = result.next();
            if (first == null) {
                return EmptyIterator.getInstance();
            }
            if (first instanceof AtomicValue) {
                ItemMappingFunction atomicValueChecker = new ItemMappingFunction(){

                    public Item map(Item item) throws XPathException {
                        if (item instanceof AtomicValue) {
                            return item;
                        }
                        throw SimpleMappingExpression.this.reportMixedItems(loc, context);
                    }
                };
                return new ItemMappingIterator(result.getAnother(), atomicValueChecker);
            }
            ItemMappingFunction nodeChecker = new ItemMappingFunction(){

                public Item map(Item item) throws XPathException {
                    if (item instanceof NodeInfo) {
                        return item;
                    }
                    throw SimpleMappingExpression.this.reportMixedItems(loc, context);
                }
            };
            return new DocumentOrderIterator(new ItemMappingIterator(result.getAnother(), nodeChecker), GlobalOrderComparer.getInstance());
        }
        return result;
    }

    private XPathException reportMixedItems(SourceLocator loc, XPathContext context) {
        XPathException err = new XPathException("Cannot mix nodes and atomic values in the result of a path expression");
        err.setErrorCode("XPTY0018");
        err.setLocator(loc);
        err.setXPathContext(context);
        return err;
    }

    public SequenceIterator map(XPathContext context) throws XPathException {
        return this.step.iterate(context);
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("atomicMap");
        this.start.explain(destination);
        this.step.explain(destination);
        destination.endElement();
    }
}

