/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;

public final class SavedNamespaceContext
implements Serializable,
NamespaceResolver {
    private int[] namespaceCodes;
    private NamePool namePool;

    public SavedNamespaceContext(int[] nscodes, NamePool pool) {
        this.namespaceCodes = nscodes;
        this.namePool = pool;
    }

    public SavedNamespaceContext(NamespaceResolver resolver, NamePool pool) {
        this.namePool = pool;
        ArrayList<Integer> list = new ArrayList<Integer>();
        Iterator iter = resolver.iteratePrefixes();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            String uri = resolver.getURIForPrefix(prefix, true);
            int nscode = pool.getNamespaceCode(prefix, uri);
            list.add(new Integer(nscode));
        }
        this.namespaceCodes = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.namespaceCodes[i] = (Integer)list.get(i);
        }
    }

    public int[] getNamespaceCodes() {
        return this.namespaceCodes;
    }

    public String getURIForPrefix(String prefix, boolean useDefault) {
        if (prefix.length() == 0 && !useDefault) {
            return "";
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        for (int i = this.namespaceCodes.length - 1; i >= 0; --i) {
            if (!this.namePool.getPrefixFromNamespaceCode(this.namespaceCodes[i]).equals(prefix)) continue;
            return this.namePool.getURIFromNamespaceCode(this.namespaceCodes[i]);
        }
        if (prefix.length() == 0) {
            return "";
        }
        return null;
    }

    public Iterator iteratePrefixes() {
        ArrayList<String> prefixes = new ArrayList<String>(this.namespaceCodes.length);
        for (int i = 0; i < this.namespaceCodes.length; ++i) {
            prefixes.add(this.namePool.getPrefixFromNamespaceCode(this.namespaceCodes[i]));
        }
        return prefixes.iterator();
    }
}

