


#include <glib-object.h>
#include "yelp-types.h"


/* enumerations from "yelp-document.h" */
static const GEnumValue _yelp_document_signal_values[] = {
  { YELP_DOCUMENT_SIGNAL_CONTENTS, "YELP_DOCUMENT_SIGNAL_CONTENTS", "contents" },
  { YELP_DOCUMENT_SIGNAL_INFO, "YELP_DOCUMENT_SIGNAL_INFO", "info" },
  { YELP_DOCUMENT_SIGNAL_ERROR, "YELP_DOCUMENT_SIGNAL_ERROR", "error" },
  { 0, NULL, NULL }
};

GType
yelp_document_signal_get_type (void)
{
  static GType type = 0;

  if (!type)
    type = g_enum_register_static ("YelpDocumentSignal", _yelp_document_signal_values);

  return type;
}


/* enumerations from "yelp-view.h" */
static const GEnumValue _yelp_view_state_values[] = {
  { YELP_VIEW_STATE_BLANK, "YELP_VIEW_STATE_BLANK", "blank" },
  { YELP_VIEW_STATE_LOADING, "YELP_VIEW_STATE_LOADING", "loading" },
  { YELP_VIEW_STATE_LOADED, "YELP_VIEW_STATE_LOADED", "loaded" },
  { YELP_VIEW_STATE_ERROR, "YELP_VIEW_STATE_ERROR", "error" },
  { 0, NULL, NULL }
};

GType
yelp_view_state_get_type (void)
{
  static GType type = 0;

  if (!type)
    type = g_enum_register_static ("YelpViewState", _yelp_view_state_values);

  return type;
}




