/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.gui.HyperlinkActivatedListener;
import org.jets3t.gui.JHtmlLabel;
import org.jets3t.gui.skins.SkinsFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.utils.ServiceUtils;

public class UserInputFields {
    private static final Log log = LogFactory.getLog(UserInputFields.class);
    private Insets insetsDefault = null;
    private HyperlinkActivatedListener hyperlinkListener = null;
    private SkinsFactory skinsFactory = null;
    private Insets insetsNone = new Insets(0, 0, 0, 0);
    private Map userInputComponentsMap = new HashMap();

    public UserInputFields(Insets defaultInsets, HyperlinkActivatedListener hyperlinkListener, SkinsFactory skinsFactory) {
        this.insetsDefault = defaultInsets;
        this.hyperlinkListener = hyperlinkListener;
        this.skinsFactory = skinsFactory;
    }

    public boolean buildFieldsPanel(JPanel fieldsPanel, Jets3tProperties uploaderProperties) {
        int fieldIndex = 0;
        for (int fieldNo = 0; fieldNo < 100; ++fieldNo) {
            JHtmlLabel label;
            String fieldName = uploaderProperties.getStringProperty("field." + fieldNo + ".name", null);
            String fieldType = uploaderProperties.getStringProperty("field." + fieldNo + ".type", null);
            String fieldPrompt = uploaderProperties.getStringProperty("field." + fieldNo + ".prompt", null);
            String fieldOptions = uploaderProperties.getStringProperty("field." + fieldNo + ".options", null);
            String fieldDefault = uploaderProperties.getStringProperty("field." + fieldNo + ".default", null);
            if (fieldName == null) {
                log.debug((Object)("No field with index number " + fieldNo));
                continue;
            }
            if (fieldType == null || fieldPrompt == null) {
                log.warn((Object)("Field '" + fieldName + "' missing .type or .prompt properties"));
                continue;
            }
            if ("message".equals(fieldType)) {
                label = this.skinsFactory.createSkinnedJHtmlLabel(fieldName);
                label.setText(fieldPrompt);
                label.setHyperlinkeActivatedListener(this.hyperlinkListener);
                fieldsPanel.add((Component)label, new GridBagConstraints(0, fieldIndex++, 1, 1, 0.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
                continue;
            }
            if ("radio".equals(fieldType)) {
                if (fieldOptions == null) {
                    log.warn((Object)("Radio button field '" + fieldName + "' is missing the required .options property"));
                    continue;
                }
                label = this.skinsFactory.createSkinnedJHtmlLabel(fieldName);
                label.setText(fieldPrompt);
                label.setHyperlinkeActivatedListener(this.hyperlinkListener);
                fieldsPanel.add((Component)label, new GridBagConstraints(0, fieldIndex++, 1, 1, 0.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
                JPanel optionsPanel = this.skinsFactory.createSkinnedJPanel("OptionsPanel");
                optionsPanel.setLayout(new GridBagLayout());
                int columnOffset = 0;
                ButtonGroup buttonGroup = new ButtonGroup();
                StringTokenizer st = new StringTokenizer(fieldOptions, ",");
                while (st.hasMoreTokens()) {
                    String option = st.nextToken();
                    JRadioButton radioButton = this.skinsFactory.createSkinnedJRadioButton(fieldName);
                    radioButton.setText(option);
                    buttonGroup.add(radioButton);
                    if (fieldDefault != null && fieldDefault.equals(option)) {
                        radioButton.setSelected(true);
                    } else if (buttonGroup.getButtonCount() == 1) {
                        radioButton.setSelected(true);
                    }
                    optionsPanel.add((Component)radioButton, new GridBagConstraints(columnOffset++, 0, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
                }
                fieldsPanel.add((Component)optionsPanel, new GridBagConstraints(0, fieldIndex++, 1, 1, 0.0, 0.0, 17, 0, this.insetsNone, 0, 0));
                this.userInputComponentsMap.put(fieldName, buttonGroup);
                continue;
            }
            if ("selection".equals(fieldType)) {
                if (fieldOptions == null) {
                    log.warn((Object)("Radio button field '" + fieldName + "' is missing the required .options property"));
                    continue;
                }
                label = this.skinsFactory.createSkinnedJHtmlLabel(fieldName);
                label.setText(fieldPrompt);
                label.setHyperlinkeActivatedListener(this.hyperlinkListener);
                fieldsPanel.add((Component)label, new GridBagConstraints(0, fieldIndex++, 1, 1, 0.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
                JComboBox comboBox = this.skinsFactory.createSkinnedJComboBox(fieldName);
                StringTokenizer st = new StringTokenizer(fieldOptions, ",");
                while (st.hasMoreTokens()) {
                    String option = st.nextToken();
                    comboBox.addItem(option);
                }
                if (fieldDefault != null) {
                    comboBox.setSelectedItem(fieldDefault);
                }
                fieldsPanel.add((Component)comboBox, new GridBagConstraints(0, fieldIndex++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
                this.userInputComponentsMap.put(fieldName, comboBox);
                continue;
            }
            if ("text".equals(fieldType)) {
                label = this.skinsFactory.createSkinnedJHtmlLabel(fieldName);
                label.setText(fieldPrompt);
                label.setHyperlinkeActivatedListener(this.hyperlinkListener);
                fieldsPanel.add((Component)label, new GridBagConstraints(0, fieldIndex++, 1, 1, 0.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
                JTextField textField = this.skinsFactory.createSkinnedJTextField(fieldName);
                if (fieldDefault != null) {
                    textField.setText(fieldDefault);
                }
                fieldsPanel.add((Component)textField, new GridBagConstraints(0, fieldIndex++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
                this.userInputComponentsMap.put(fieldName, textField);
                continue;
            }
            if ("password".equals(fieldType)) {
                label = this.skinsFactory.createSkinnedJHtmlLabel(fieldName);
                label.setText(fieldPrompt);
                label.setHyperlinkeActivatedListener(this.hyperlinkListener);
                fieldsPanel.add((Component)label, new GridBagConstraints(0, fieldIndex++, 1, 1, 0.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
                JPasswordField passwordField = this.skinsFactory.createSkinnedJPasswordField(fieldName);
                if (fieldDefault != null) {
                    passwordField.setText(fieldDefault);
                }
                fieldsPanel.add((Component)passwordField, new GridBagConstraints(0, fieldIndex++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
                this.userInputComponentsMap.put(fieldName, passwordField);
                continue;
            }
            if (fieldType.equals("textarea")) {
                label = this.skinsFactory.createSkinnedJHtmlLabel(fieldName);
                label.setText(fieldPrompt);
                label.setHyperlinkeActivatedListener(this.hyperlinkListener);
                fieldsPanel.add((Component)label, new GridBagConstraints(0, fieldIndex++, 2, 1, 0.0, 0.0, 18, 2, this.insetsDefault, 0, 0));
                JTextArea textArea = this.skinsFactory.createSkinnedJTextArea(fieldName);
                textArea.setLineWrap(true);
                if (fieldDefault != null) {
                    textArea.setText(fieldDefault);
                }
                JScrollPane scrollPane = this.skinsFactory.createSkinnedJScrollPane(fieldName);
                scrollPane.setViewportView(textArea);
                fieldsPanel.add((Component)scrollPane, new GridBagConstraints(0, fieldIndex++, 2, 1, 1.0, 1.0, 17, 1, this.insetsDefault, 0, 0));
                this.userInputComponentsMap.put(fieldName, textArea);
                continue;
            }
            log.warn((Object)("Unrecognised .type setting for field '" + fieldName + "'"));
        }
        return this.isUserInputFieldsAvailable();
    }

    public Properties getUserInputsAsProperties(boolean hashPasswords) {
        Properties properties = new Properties();
        for (String fieldName : this.userInputComponentsMap.keySet()) {
            String fieldValue = null;
            Object component = this.userInputComponentsMap.get(fieldName);
            if (component instanceof ButtonGroup) {
                ButtonGroup bg = (ButtonGroup)component;
                Enumeration<AbstractButton> radioEnum = bg.getElements();
                while (radioEnum.hasMoreElements()) {
                    JRadioButton button = (JRadioButton)radioEnum.nextElement();
                    if (!button.isSelected()) continue;
                    fieldValue = button.getText();
                    break;
                }
            } else if (component instanceof JComboBox) {
                fieldValue = ((JComboBox)component).getSelectedItem().toString();
            } else if (component instanceof JPasswordField) {
                if (hashPasswords) {
                    String password = new String(((JPasswordField)component).getPassword());
                    try {
                        fieldValue = ServiceUtils.toHex((byte[])ServiceUtils.computeMD5Hash((byte[])password.getBytes(Constants.DEFAULT_ENCODING)));
                    }
                    catch (Exception e) {
                        log.error((Object)("Unable to generate hash of password for field named '" + fieldName + "'"), (Throwable)e);
                    }
                } else {
                    fieldValue = new String(((JPasswordField)component).getPassword());
                }
            } else if (component instanceof JTextField) {
                fieldValue = ((JTextField)component).getText();
            } else if (component instanceof JTextArea) {
                fieldValue = ((JTextArea)component).getText();
            } else {
                log.warn((Object)("Unrecognised component type for field named '" + fieldName + "': " + component.getClass().getName()));
            }
            properties.put(fieldName, fieldValue);
        }
        return properties;
    }

    public boolean isUserInputFieldsAvailable() {
        return this.userInputComponentsMap.size() > 0;
    }
}

