/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import java.net.URI;

public class AwsHostNameUtils {
    public static String parseRegionName(URI endpoint) {
        String host = endpoint.getHost();
        if (!host.endsWith(".amazonaws.com")) {
            return "us-east-1";
        }
        String serviceAndRegion = host.substring(0, host.indexOf(".amazonaws.com"));
        int separator = 46;
        if (serviceAndRegion.startsWith("s3")) {
            separator = 45;
        }
        if (serviceAndRegion.indexOf(separator) == -1) {
            return "us-east-1";
        }
        String region = serviceAndRegion.substring(serviceAndRegion.indexOf(separator) + 1);
        if ("us-gov".equals(region)) {
            return "us-gov-west-1";
        }
        return region;
    }

    public static String parseServiceName(URI endpoint) {
        String host = endpoint.getHost();
        if (!host.endsWith(".amazonaws.com")) {
            return "us-east-1";
        }
        String serviceAndRegion = host.substring(0, host.indexOf(".amazonaws.com"));
        int separator = 46;
        if (serviceAndRegion.startsWith("s3")) {
            separator = 45;
        }
        if (serviceAndRegion.indexOf(separator) == -1) {
            return serviceAndRegion;
        }
        String service = serviceAndRegion.substring(0, serviceAndRegion.indexOf(separator));
        return service;
    }
}

