/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ExportTaskDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class CreateInstanceExportTask
extends BaseCmd {
    public static final int MAX_COMMENT_LENGTH = 255;
    public static final String[] DISK_IMAGE_FORMAT_DESC = new String[]{"The file format of the disk image. Refer to the latest Developer's", "Guide for valid values. [OPTIONAL]"};
    public static final String[] ENVIRONMENT_DESC = new String[]{"The target environment. Refer to the latest Developer's", "Guide for valid values. [REQUIRED]"};
    public static final String[] S3_BUCKET_DESC = new String[]{"S3 destination bucket name for the exported file.", "The target bucket must grant WRITE and READ_ACL permissions to the ", "vm-import-export@amazon.com AWS account. [REQUIRED]"};
    public static final String[] CONTAINER_FORMAT_DESC = new String[]{"The container format used to combine disk images with metadata. ", "If absent, only the disk image will be exported. [OPTIONAL]"};
    public static final String[] S3_PREFIX_DESC = new String[]{"Initial part of the S3 key (object name) used for the exported file.", "Maximum length is 1000 bytes of UTF-8. [OPTIONAL]"};
    public static final String[] DESCRIPTION_DESC = new String[]{"A free-form comment that will be returned verbatim during", "subsequent calls to ec2-describe-export-tasks.  Maximum length is 255", "characters. [OPTIONAL]"};
    private String instanceId;
    private String targetEnvironment;
    private String diskFormat;
    private String containerFormat;
    private String bucket;
    private String prefix;
    private String description;

    public CreateInstanceExportTask(String[] args) {
        super("ec2addixt", new String[]{"ec2addixt", "ec2-create-instance-export-task"});
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"disk-image-format");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)CreateInstanceExportTask.joinDescription(DISK_IMAGE_FORMAT_DESC));
        OptionBuilder.withArgName((String)"DISK-IMAGE-FORMAT");
        result.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withLongOpt((String)"target-environment");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)CreateInstanceExportTask.joinDescription(ENVIRONMENT_DESC));
        OptionBuilder.withArgName((String)"TARGET-ENVIRONMENT");
        result.addOption(OptionBuilder.create((String)"e"));
        OptionBuilder.withLongOpt((String)"container-format");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)CreateInstanceExportTask.joinDescription(CONTAINER_FORMAT_DESC));
        OptionBuilder.withArgName((String)"CONTAINER-FORMAT");
        result.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"s3-bucket");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)CreateInstanceExportTask.joinDescription(S3_BUCKET_DESC));
        OptionBuilder.withArgName((String)"S3-BUCKET");
        result.addOption(OptionBuilder.create((String)"b"));
        OptionBuilder.withLongOpt((String)"s3-prefix");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)CreateInstanceExportTask.joinDescription(S3_PREFIX_DESC));
        OptionBuilder.withArgName((String)"S3-PREFIX");
        result.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"description");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)CreateInstanceExportTask.joinDescription(DESCRIPTION_DESC));
        OptionBuilder.withArgName((String)"DESCRIPTION");
        result.addOption(OptionBuilder.create((String)"d"));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "INSTANCE -e TARGET_ENVIRONMENT -f DISK_IMAGE_FORMAT [-c CONTAINER_FORMAT] -b S3_BUCKET [-p S3_PREFIX] [-d DESCRIPTION]";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("disk-image-format");
        this.printOption("target-environment");
        this.printOption("container-format");
        this.printOption("s3-bucket");
        this.printOption("s3-prefix");
        this.printOption("description");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Initiate an instance export task to export a running or stopped");
        System.out.println("     instance to a file in S3");
        System.out.println("     The INSTANCE parameter specifies the instance to export. ");
        System.out.println("     The instance will be rebooted once, in the same fashion as ");
        System.out.println("     ec2-create-image");
        System.out.println("     Temporary AMIs or snapshots of the instance and its attached");
        System.out.println("     volumes may be created under your account during the initial phase of");
        System.out.println("     the export task. They will be deleted automatically when they are no");
        System.out.println("     longer needed for the export task.");
    }

    protected void validateParameters() {
        this.assertNonOptionSet("instance");
        this.assertOptionSet("target-environment");
        this.assertOptionSet("s3-bucket");
        this.instanceId = this.getNonOptions()[0];
        this.targetEnvironment = this.getOptionValue("target-environment");
        this.bucket = this.getOptionValue("s3-bucket");
        this.diskFormat = null;
        if (this.isOptionSet("disk-image-format")) {
            this.diskFormat = this.getOptionValue("disk-image-format");
        }
        this.containerFormat = null;
        if (this.isOptionSet("container-format")) {
            this.containerFormat = this.getOptionValue("container-format");
        }
        this.prefix = null;
        if (this.isOptionSet("s3-prefix")) {
            this.prefix = this.getOptionValue("s3-prefix");
        }
        this.description = null;
        if (this.isOptionSet("description")) {
            this.description = this.getOptionValue("description");
        }
        if (this.description != null && this.description.length() > 255) {
            throw new InvalidArgument("description", this.description);
        }
        this.warnIfTooManyNonOptions();
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        RequestResultPair task = jec2.createInstanceExportTask(this.instanceId, this.targetEnvironment, this.diskFormat, this.containerFormat, this.bucket, this.prefix, this.description);
        out.output(System.out, (ExportTaskDescription)task.getResponse(), true);
        return true;
    }

    public static void main(String[] args) {
        new CreateInstanceExportTask(args).invoke();
    }
}

