/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.NetworkInterfaceAttributeType;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class ResetNetworkInterfaceAttribute
extends BaseCmd {
    private static final String[] SOURCE_DEST_CHECK_DESC = new String[]{"Resets whether to enable the source/dest check on traffic through ", "this network interface to the default value."};
    private String networkInterfaceId;
    private NetworkInterfaceAttributeType type;

    public ResetNetworkInterfaceAttribute(String[] args) {
        super("ec2rnicatt", "ec2-reset-network-interface-attribute");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(ResetNetworkInterfaceAttribute.createOption(null, "source-dest-check", SOURCE_DEST_CHECK_DESC));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "NETWORKINTERFACE";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("source-dest-check");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Resets a network interface attribute. Only one attribute can be specified");
        System.out.println("     per call.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        RequestResultPair rsp = jec2.resetNetworkInterfaceAttribute(this.networkInterfaceId, this.type);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.outputReset(System.out, this.networkInterfaceId, this.type);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    protected void validateParameters() {
        this.assertNonOptionSet("NETWORKINTERFACE");
        this.networkInterfaceId = this.getNonOptions()[0];
        this.assertOnlyOneOptionSet(new String[]{"source-dest-check"});
        this.warnIfTooManyNonOptions();
        if (this.isOptionSet("source-dest-check")) {
            this.type = NetworkInterfaceAttributeType.sourceDestCheck;
        }
    }

    public static void main(String[] args) {
        new ResetNetworkInterfaceAttribute(args).invoke();
    }
}

