/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.recalibration;

import java.io.PrintStream;
import org.broadinstitute.sting.utils.collections.LoggingNestedIntegerArray;
import org.broadinstitute.sting.utils.collections.NestedIntegerArray;
import org.broadinstitute.sting.utils.recalibration.EventType;
import org.broadinstitute.sting.utils.recalibration.RecalDatum;
import org.broadinstitute.sting.utils.recalibration.covariates.Covariate;

public class RecalibrationTables {
    private final NestedIntegerArray[] tables;

    public RecalibrationTables(Covariate[] covariates) {
        this(covariates, covariates[TableType.READ_GROUP_TABLE.index].maximumKeyValue() + 1, null);
    }

    public RecalibrationTables(Covariate[] covariates, PrintStream log) {
        this(covariates, covariates[TableType.READ_GROUP_TABLE.index].maximumKeyValue() + 1, log);
    }

    public RecalibrationTables(Covariate[] covariates, int numReadGroups) {
        this(covariates, numReadGroups, null);
    }

    public RecalibrationTables(Covariate[] covariates, int numReadGroups, PrintStream log) {
        this.tables = new NestedIntegerArray[covariates.length];
        int qualDimension = covariates[TableType.QUALITY_SCORE_TABLE.index].maximumKeyValue() + 1;
        int eventDimension = EventType.values().length;
        this.tables[TableType.READ_GROUP_TABLE.index] = log == null ? new NestedIntegerArray(numReadGroups, eventDimension) : new LoggingNestedIntegerArray(log, "READ_GROUP_TABLE", numReadGroups, eventDimension);
        this.tables[TableType.QUALITY_SCORE_TABLE.index] = log == null ? new NestedIntegerArray(numReadGroups, qualDimension, eventDimension) : new LoggingNestedIntegerArray(log, "QUALITY_SCORE_TABLE", numReadGroups, qualDimension, eventDimension);
        for (int i = TableType.OPTIONAL_COVARIATE_TABLES_START.index; i < covariates.length; ++i) {
            this.tables[i] = log == null ? new NestedIntegerArray(numReadGroups, qualDimension, covariates[i].maximumKeyValue() + 1, eventDimension) : new LoggingNestedIntegerArray(log, String.format("OPTIONAL_COVARIATE_TABLE_%d", i - TableType.OPTIONAL_COVARIATE_TABLES_START.index + 1), numReadGroups, qualDimension, covariates[i].maximumKeyValue() + 1, eventDimension);
        }
    }

    public NestedIntegerArray<RecalDatum> getReadGroupTable() {
        return this.tables[TableType.READ_GROUP_TABLE.index];
    }

    public NestedIntegerArray<RecalDatum> getQualityScoreTable() {
        return this.tables[TableType.QUALITY_SCORE_TABLE.index];
    }

    public NestedIntegerArray<RecalDatum> getTable(int index) {
        return this.tables[index];
    }

    public int numTables() {
        return this.tables.length;
    }

    public static enum TableType {
        READ_GROUP_TABLE(0),
        QUALITY_SCORE_TABLE(1),
        OPTIONAL_COVARIATE_TABLES_START(2);

        public final int index;

        private TableType(int index) {
            this.index = index;
        }
    }
}

