/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.iff;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import java.io.DataInputStream;
import java.io.IOException;

public class ChunkHeader {
    private ModuleBase _module;
    private RepInfo _repInfo;
    private long _size;
    private String _chunkID;

    public ChunkHeader(ModuleBase moduleBase, RepInfo repInfo) {
        this._module = moduleBase;
        this._repInfo = repInfo;
    }

    public boolean readHeader(DataInputStream dataInputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(4);
        for (int i = 0; i < 4; ++i) {
            int n = ModuleBase.readUnsignedByte((DataInputStream)dataInputStream, (ModuleBase)this._module);
            if (n < 32) {
                String string = Integer.toHexString(n);
                if (string.length() < 2) {
                    string = "0" + string;
                }
                this._repInfo.setMessage((Message)new ErrorMessage("Invalid character in Chunk ID", "Character = 0x" + string, this._module.getNByte()));
                this._repInfo.setWellFormed(false);
                return false;
            }
            stringBuffer.append((char)n);
        }
        this._chunkID = stringBuffer.toString();
        this._size = ModuleBase.readUnsignedInt((DataInputStream)dataInputStream, (boolean)this._module.isBigEndian(), (ModuleBase)this._module);
        return true;
    }

    public void setID(String string) {
        this._chunkID = string;
    }

    public String getID() {
        return this._chunkID;
    }

    public long getSize() {
        return this._size;
    }
}

