/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.UUIDInfoBox;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.ListIterator;

public class DataEntryURLBox
extends JP2Box {
    public DataEntryURLBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    @Override
    public boolean readBox() throws IOException {
        int n;
        this.initBytesRead();
        for (int i = 0; i < 4; ++i) {
            n = ModuleBase.readUnsignedByte(this._dstrm, this._module);
            if (n == 0) continue;
            this._repInfo.setMessage(new ErrorMessage("Unrecognized version or flag value in Data Entry URL Box", this._module.getFilePos()));
            this._repInfo.setValid(false);
            break;
        }
        ArrayList<Byte> arrayList = new ArrayList<Byte>(512);
        while ((n = ModuleBase.readUnsignedByte(this._dstrm, this._module)) != 0) {
            arrayList.add(new Byte((byte)n));
        }
        ListIterator listIterator = arrayList.listIterator();
        byte[] byArray = new byte[arrayList.size()];
        int n2 = 0;
        while (listIterator.hasNext()) {
            byArray[n2] = (Byte)listIterator.next();
        }
        String string = new String(byArray, "UTF-8");
        if (this._parentBox instanceof UUIDInfoBox) {
            UUIDInfoBox uUIDInfoBox = (UUIDInfoBox)this._parentBox;
            uUIDInfoBox.setURL(string);
        }
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Data Entry URL Box";
    }
}

