/*###############################################################################
# Linux Management Providers (LMP), Base_Server provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "OpenDRIM_ComputerSystemCapabilitiesAccess.h"

static string _InstanceID;

int Base_Server_OpenDRIM_ComputerSystemCapabilities_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(_InstanceID, errorMessage));
	_InstanceID = "OpenDRIM_ComputerSystem:" + _InstanceID;
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystemCapabilities_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystemCapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ComputerSystemCapabilities>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	// TODO As State management is not yet implmented, we should get no instance
	/*
	OpenDRIM_ComputerSystemCapabilities instance;
	instance.setInstanceID(_InstanceID);
	instance.setElementNameEditSupported(true);
	vector<unsigned short> RequestedStatesSupported;
	instance.setRequestedStatesSupported(RequestedStatesSupported);
	result.push_back(instance);
	*/
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystemCapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ComputerSystemCapabilities& instance, const char** properties, string& errorMessage) {
	_E_;
	// TODO As State management is not yet implmented, we should get no instance
	/*
	string InstanceID;
	instance.getInstanceID(InstanceID);
	if (!CF_strCmpNoCase(InstanceID, _InstanceID))
		return NOT_FOUND;
	instance.setInstanceID(_InstanceID);
	instance.setElementNameEditSupported(true);
	vector<unsigned short> RequestedStatesSupported;
	instance.setRequestedStatesSupported(RequestedStatesSupported);
	*/
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystemCapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemCapabilities& newInstance, const OpenDRIM_ComputerSystemCapabilities& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Base_Server_OpenDRIM_ComputerSystemCapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemCapabilities& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Base_Server_OpenDRIM_ComputerSystemCapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemCapabilities& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Base_Server_OpenDRIM_ComputerSystemCapabilities_CreateGoalSettings(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemCapabilities& instance, unsigned short& returnValue, const OpenDRIM_ComputerSystemCapabilities_CreateGoalSettings_In& in, OpenDRIM_ComputerSystemCapabilities_CreateGoalSettings_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystemCapabilities_populate(OpenDRIM_ComputerSystemCapabilities& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

