#include "launcher.h"

QDir homedir;
QStringList packagedirs;
QByteArray variables[VAR_MAX];


const char *varnames[] = {
	"fullscreen",		"1",
	"scr_w",		"1024",
	"scr_h",		"768",
	"colorbits",		"0",
	"depthbits",		"0",
	"stencilbits",		"0",
	"fsaa",			"0",
	"vsync",		"1",
	"shaders",		"1",
	"shaderprecision",	"0",
	"forceglsl",		"0",
	"soundchans",		"32",
	"soundfreq",		"22050",
	"soundbufferlen",	"1024",
};

namespace IO
{
	void reset()
	{
		#ifdef Q_OS_WIN // works with WIN64 too
		homedir.setPath(".");
		if(!homedir.exists(QString("my_stuff")))
			homedir.mkdir(QString("my_stuff"));
		homedir.cd(QString("my_stuff"));
		#elif Q_OS_DARWIN
		//FIXME
		//homedir
		#else //linux :3
		homedir.setPath(QDir::homePath());
		if(!homedir.exists(QString(".platinumarts")))
			homedir.mkdir(QString(".platinumarts"));
		homedir.cd(QString(".platinumarts"));
		#endif

		packagedirs.clear();

		loop(i, VAR_MAX)
			variables[i] = varnames[i*2 + 1];
	}

	QFile *openfile(QString file, bool write)
	{
		if(write)
			return new QFile(homedir.filePath(file));

		if(homedir.exists(file))
			return new QFile(homedir.filePath(file));

		QDir tmp;
		loopv(i, packagedirs)
		{
			tmp.setPath(packagedirs[i]);
			if(tmp.exists(file))
				return new QFile(tmp.filePath(file));
		}

		tmp.setPath(QDir::currentPath());
		if(tmp.exists(file))
			return new QFile(tmp.filePath(file));

		return NULL;
	}

	void refreshSearchPaths()
	{

	}

	void setHomedir() {}
	void addPackagedir() {}
	void removePackagedir() {}

	void readDat()
	{
		QFile dat("launcher.dat");
		dat.open(QIODevice::ReadOnly);
		if(!dat.isOpen())
			return;

		homedir.setPath(dat.readLine());
		while(!dat.atEnd())
			packagedirs << dat.readLine();

		dat.close();

		refreshSearchPaths();
	}

	void writeDat()
	{
		QFile dat("launcher.dat");
		dat.open(QIODevice::WriteOnly|QIODevice::Text);

		dat.write(homedir.path().toAscii());
		loopv(i, packagedirs)
		{
			dat.putChar('\n');
			dat.write(packagedirs[i].toAscii());
		}

		dat.close();
	}

	void readCfg()
	{
		QFile *init = openfile("init.cfg", false);
		init->open(QIODevice::ReadOnly|QIODevice::Text);

		//we assume that the file is unmodified - mostly

		while(!init->atEnd())
		{
			QByteArray buf = init->readLine();
			buf = buf.simplified();
			if(buf[0] == '/' && buf[1] == '/') continue;

			int var = -1;
			loop(i, VAR_MAX)
			{
				if(buf.startsWith(varnames[2 * i]))
				{
					var = i;
					break;
				}
			}
			if(var != -1)
			{
				variables[var] = buf.right(buf.count() - QByteArray(varnames[2 * var]).count() );
			}
		}

		init->close();
		delete init;
	}

	void writeCfg()
	{
		QFile *init = openfile("init.cfg", true);
		init->open(QIODevice::WriteOnly|QIODevice::Text);

		init->write("//This file was generated by the Sandbox Launcher\n//Do not modify this file unless you know what you're doing\n//Modify settigns in game or via the launcher\n\n");
		loop(i, VAR_MAX)
		{
			init->write(varnames[i * 2]);
			init->putChar('\t');
			init->write(variables[i]);
			init->putChar('\n');
		}
		init->close();
		delete init;
	}
}