!{\src2tex{textfont=tt}}
!!****f* ABINIT/setup_little_group
!! NAME
!! setup_little_group
!!
!! FUNCTION
!!  Set up little group operations and symmetry tables 
!!  for GW calculations
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2007 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  gmet(3,3)=reciprocal space metric (bohr**-2).
!!  kbz(3,nkbz)=points in the full Brillouin Zone
!!  nop=number of symmetry operations
!!  ninv=if 2, inversion is considered; if 1, inversion is not considered
!!  nkbz=number of points in the full BZ
!!  op(3,3,nop)=symmetry operations in reciprocal space
!!  xpt(3)= point in the Brillouin zone  
!!
!! OUTPUT
!!  ibzq(nkbz)= 1 if the kpoint belongs to the IBZ defined by xpt, 0 otherwise
!!  lgtab(nkbz)=table giving, for each k-point in the BZ (kBZ), the corresponding 
!!   irreducible point (kIBZ) in the irreducible zone defined by the little group of xpt,
!!   i.e kBZ= (IR) kIBZ where I is the inversion or the identity and R is an
!!   operation in the little group of xpt
!!  lgtabo(nkbz)=the symmetry operation R in the little group that takes kIBZ to each kBZ
!!  lgtabi(nkbz)= defines whether inversion has to be considered in the 
!!   relation kBZ=(IR) kIBZ (1 => only R; -1 => -R)  
!!  ltg(2,nop)= 1 if ISq=q, 0 otherwise, the first index is for the identity or the time reversal symmetry, 
!!  wtksym(2,nop,nkbz)= for each kpoint is equal to 1 if the symmetry operation (with or without time reversal)  
!!   must be considered in the calculation of \chi_o, 0 otherwise  
!!
!! SIDE EFFECTS
!!
!! NOTES
!!  umklapp processes are not taken into account in the definition of the little group
!!
!! PARENTS
!!  
!!
!! CHILDREN
!! 
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine setup_little_group(xpt,gmet,nop,op,ninv,nkbz,kbz,ibzq,ltg,lgtab,lgtabo,lgtabi,wtksym)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_13recipspace
 use interfaces_15gw, except_this_one => setup_little_group
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
! 
!scalars
 integer,intent(in) :: ninv,nkbz,nop
!arrays
 integer,intent(inout) :: ibzq(nkbz),lgtab(nkbz),lgtabi(nkbz),lgtabo(nkbz)
 integer,intent(inout) :: ltg(2,nop),wtksym(2,nop,nkbz)
 real(dp),intent(in) :: gmet(3,3),kbz(3,nkbz),op(3,3,nop),xpt(3)

!Local variables-------------------------------
!scalars
 integer :: idx,iinv,ik,ikp,ind,iold,iop,itest,nkibzq,nsymltg,nsymq
 integer :: ntest,timrev
 logical :: DEBUG=.true.,VERBOSE=.true.,no_identity
 character(len=500) :: message
!arrays
 integer :: dummy(nkbz),g0(3),identity(3,3)
 integer :: indkpt1(nkbz),op_int(3,3,nop),symxpt(4,2,nop)
 integer,allocatable :: opltg(:,:,:)
 real(dp) :: knew(3),ktest(3,nkbz),op_q(3,3,nop),wtk(nkbz),wtk_folded(nkbz)
! *************************************************************************

!DEBUG
!write(std_out,*)'symgw : enter '
!ENDDEBUG
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 integer :: icmpk2
#endif
!End of the abilint section

 identity(:,:)=reshape((/1,0,0,0,1,0,0,0,1/),(/3,3/))
!DEBUG
! if(option/=1 .and. option/=2 )then
!  write(message,'(a,a,a,a,a,a,i6)') ch10,&
!&  ' symgw: BUG -',ch10,&
!&  '  The argument option should be 1 or 2,',ch10,&
!&  '  however, option=',option
!  call wrtout(std_out,message,'COLL')
!  call leave_new('COLL')
! endif
!ENDDEBUG

 write(message,'(2a,3f8.5,a)')ch10,&
& ' Analyzing symmetries at point ',xpt,ch10 
 call wrtout(6,message,'COLL')

 !trick: in the gw part operations are real
 !while in the main code are integer, symq3 requires an integer argument
 op_int=nint(op)

 do iop=1,nop
  if (any(abs(op_int(:,:,iop)-op(:,:,iop))>tol6)) stop
 end do 

 !another dirty trick
 !symq3 assumes that the identity operation is present
 !but in the GW part we are removing symmetries related 
 !by the inversion and, sometimes it happens that only the inversion 
 !is reported in the KSS file (see outkss.F90) 
 !to bypass this problem:
 no_identity=.true. 
 do iop=1,nop
  if (all(op_int(:,:,iop)==identity)) then 
   no_identity=.false.
   exit
  end if
 end do 
 
 if (no_identity) then 
  write(message,'(a)')&
&  ' Only the inversion was found in the set of symmetries read from the KSS file '
  call wrtout(6,message,'COLL')
  op_int=-op_int
 end if 

 !timrev is not used 
 call symq3(nop,xpt,symxpt,op_int,timrev)

 !umklapp processes are not considered in the present implementation
 ltg=0
 do iop=1,nop
   if (symxpt(4,1,iop)==1 .and. all(symxpt(1:3,1,iop)==0)) then !no time reversal and G==0
  !if (symxpt(4,1,iop)==1) then !no time reversal 
   if (.not.no_identity)ltg(1,iop)=1
   if (no_identity)ltg(2,iop)=1
   !write(*,*)symq(1:3,1,iop)
  end if  
  if (symxpt(4,2,iop)==1 .and. all(symxpt(1:3,2,iop)==0)) then !time reversal and G==0
  !if (sympt(4,2,iop)==1) then !no time reversal 
   if (.not.no_identity)ltg(2,iop)=1
   if (no_identity)ltg(1,iop)=1
  !write(*,*)symxpt(1:3,2,iop)
  end if
 end do

 if (no_identity) then 
  write(message,'(4a,2i5,a,i5)')ch10,&
&  ' Total Number of symmetry operations in the little group (no umklapp processes)',ch10,&
&  ' with and without the time reversal symmetry : ',sum(ltg(2,:)),sum(ltg(1,:)),' / ',nop
 else
  write(message,'(4a,2i5,a,i5)')ch10,&
&  ' Total Number of symmetry operations in the little group (no umklapp processes)',ch10,&
&  ' with and without the time reversal symmetry : ',sum(ltg(1,:)),sum(ltg(2,:)),' / ',nop
 end if
 call wrtout(6,message,'COLL')
 
 nsymltg=sum(ltg(:,:))
 allocate (opltg(3,3,nsymltg))  !keeping into account the time reversal simmetry

 ind=1
 do iinv=1,ninv
  do iop=1,nop  
   if (ltg(iinv,iop)==1) then  
    if (iinv==1) then 
      opltg(:,:,ind)=int(op(:,:,iop))
    end if 
    if (iinv==2) then 
     opltg(:,:,ind)=-int(op(:,:,iop))
    end if
    ind=ind+1
   end if
  end do 
 end do

 !find irreducible Brillouin zone defined by input point xpt
 wtk=one
 !no time reversal 
 call symkpt(gmet,indkpt1,kbz,nkbz,nkibzq,nsymltg,0,opltg,0,wtk,wtk_folded)

 write(message,'(a,i5,a,i5,a)')&
& ' Number of points in the IBZ defined by the little group :',nkibzq,' / ',nkbz,ch10
 call wrtout(6,message,'COLL')

 !set up table containing containing 0 if the points does not belong to the IBZ 
 !1 otherwise
 ibzq=0
 ind=1
 do ik=1,nkbz
  if (wtk_folded(ik) >tol8 ) then
   ibzq(ik)=1
   if (VERBOSE) then 
    write (message,'(1x,i4,a,4f14.6)')&
&    ind,') ',kbz(:,ik),wtk_folded(ik)
    call wrtout(6,message,'COLL')
   end if
   ind=ind+1
  end if
 end do

 !reconstruct full BZ starting from the IBZ of the little group  
 !and calculate the appropriate weight for each symmetry operation.
 !this part is required since we need to know if the time reversal 
 !has to be considered or not  

 lgtab=0
 lgtabo=0
 lgtabi=0
 wtksym(:,:,:)=0

 !zero no. of k-points found
 ntest=0 
 ktest=zero

 do ik=1,nkbz
  if (ibzq(ik)/=1) cycle
  !loop over symmetry operations R and inversions I
  do iop=1,nop
   do iinv=1,ninv
    !form RIk only for R in the little group
    if (ltg(iinv,iop)==0) cycle
    call dosym(op(1,1,iop),iinv,kbz(1,ik),knew(1))
    !check whether it has already been found (to within a RL vector)
    iold=0
    do itest=1,ntest
     iold=iold+icmpk2(knew,ktest(1,itest))
    end do
    if(iold==0) then !new point
     wtksym(iinv,iop,ik)=1 !for point ik this symmetry operation must be considered
     ntest=ntest+1
     ktest(:,ntest)=knew(:)
     do idx=1,nkbz
      if (icmpk2(knew,kbz(1,idx))==1) then 
       lgtab(idx)=ik
       lgtabo(idx)=iop
       lgtabi(idx)=3-2*iinv
       exit
      end if 
     end do
    end if
   end do
  end do
 end do

 deallocate (opltg)

!DEBUG
!if (DEBUG) then
! if (sum(wtksym)-nkbz/=0) then 
!  write(*,*)' sum(wtksym)-nkbz= ',sum(wtksym)-nkbz
!  call leave_new('COLL')
! end if 
! if(ntest/=nkbz) then 
!  write(*,*)' ntest-nkbz= ',ntest-nkbz
!  call leave_new('COLL')
! end if 
! call findk(ntest,nkbz,ktest,kbz,dummy,1,1)
! do ik=1,ntest-1 
!  do ikp=ik+1,ntest
!  if (dummy(ikp)==dummy(ik))stop
!  end do 
! end do
! do ik=1,nkbz
! if (sum(wtksym(1,:,ik)+wtksym(2,:,ik))/=wtk_folded(ik)) then 
!  write(*,*)'sum(wtksym,ik)-wtk_folded(ik) = ',sum(wtksym(1,:,ik)+wtksym(2,:,ik))-wtk_folded(ik)
!  write(*,*)wtksym(1,:,ik),wtksym(2,:,ik),wtk_folded(ik)
!  write(*,*)ik,kbz(:,ik)
! call leave_new('COLL')
! end if 
! end do
! do ik=1,nkbz 
!  call dosym(op(1,1,lgtabo(ik)),(3-lgtabi(ik))/2,kbz(1,lgtab(ik)),knew(1))
!  if (icmpk2(knew,kbz(1,ik))==0) then 
!   write(*,*)knew,kbz(:,ik) 
!   write(*,*)lgtabo(ik),lgtabi(ik),lgtab(ik)
!   stop 'bug in setup_little_group'
!  end if 
! end do
!end if 
!ENDDEBUG

end subroutine setup_little_group
!!***
