!{\src2tex{textfont=tt}}
!!****f* ABINIT/defs_scalapack
!! NAME
!! defs_scalapack
!!
!! FUNCTION
!! This module contains descriptions of the variables used in the ScaLAPACK routines. 
!! The ScaLAPACK routines and functions are defined in 01managempi/scalapack.F90
!! and used in 08seqpar/subdiago.F90.
!!
!! COPYRIGHT
!! Copyright (C) 2004-2007 ABINIT group (CS,GZ,FB)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! TODO
!! To be translated
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

module defs_scalapack

  use defs_basis

  implicit none


!constantes du tableau de description des matrices ScaLAPACK
  integer, parameter :: DLEN_ = 9    ! longueur
  integer, parameter :: Dtype_ = 1   ! type
  integer, parameter :: CTXT_ = 2    ! contexte BLACS
  integer, parameter :: M_ = 3       ! nb global lignes 
  integer, parameter :: N_ = 4       ! nb global colonnes
  integer, parameter :: MB_ = 5      ! nb lignes d'un bloc
  integer, parameter :: NB_ = 6      ! nb colonnes d'un bloc
  integer, parameter :: RSRC_ = 7    ! ligne de processeurs du debut
  integer, parameter :: CSRC_ = 8    ! colonne de processeurs du debut
  integer, parameter :: LLD_ = 9     ! nb local de lignes

! grille de processeurs ScaLAPACK
  type grille_scalapack

     integer   :: nbprocs ! nombre total de processeurs
     integer,dimension(1:2)   :: dims

     integer   :: ictxt   ! contexte blacs

  end type grille_scalapack

! un processeur dans la grille
  type processeur_scalapack

     integer    :: myproc ! numero de processeur
     integer    :: comm   ! communicateur MPI sous-jacent a la grille BLACS
     integer,dimension(1:2)   :: coords

     type(grille_scalapack) :: grille   ! la grille a laquelle est associee
                                        ! le processeur

  end type processeur_scalapack

! type descriptif d'une matrice scalapack
  type descriptif_scalapack
!     SEQUENCE
     integer, dimension(DLEN_) :: tab

  end type descriptif_scalapack

! la partie locale  un processeur d'une matrice ScaLAPACK
  type matrice_scalapack

     complex(dp),dimension(:,:),pointer :: buffer     ! buffer de la partie
                                                      ! locale de la matrice

     integer, dimension(:), pointer     :: ipiv

     integer,dimension(1:2)             :: taille_globale

     type(processeur_scalapack),pointer :: processeur

     integer,dimension(1:2)             :: taille_blocs ! taille des blocs
                                                        ! de donnees consecutives

     integer,dimension(1:2)             :: taille_locale ! dimensions du buffer

     type(descriptif_scalapack)         :: descriptif

  end type matrice_scalapack

end module defs_scalapack
!!***
