#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <QtWidgets/QWidget>
#include <QtWidgets/QHBoxLayout>
#include <QtWidgets/QVBoxLayout>
#include <QtGui/QPainter>
#include <QtWidgets>
#include <QtGui/QMouseEvent>
#include <QtWidgets>
#include "model.h"
#include "filter.h"

Filter::Filter(Model *p_model, int p_index, QWidget *parent, int w, int h) : QWidget(parent) {

  model = p_model;
  index = p_index;
  mousePos = -1;
  mouseVal = 0;
  setMinimumSize(w, h);
  leftBorder = 20;
  rightBorder = 10;
  topBorder = 20;
  bottomBorder = 60;
  scaleX = (double)(width() - leftBorder - rightBorder) / (double)model->getHarmonicSplit(0);
  scaleY = (height() - topBorder - bottomBorder) / model->getMax();
  setPalette(QPalette(QColor(200, 200, 200), QColor(20, 0, 70)));
  setAutoFillBackground(true);
  setMouseTracking(true);
}

Filter::~Filter() {
  
}

void Filter::paintEvent(QPaintEvent *) {

  QPainter p;
  QString qs, qs1, qs2;
  QPoint points[4];
  int i;
  int vStart, vEnd;
  double x;
    
  model->getEditRange(vStart, vEnd);
  scaleX = (double)(width() - leftBorder - rightBorder) / (double)FILTER_LEN;
  scaleY = (height() - topBorder - bottomBorder) / model->getMax();
  p.begin(this);
  p.setPen(QPen(QBrush(QColor(240, 200, 0)), 2));
  for (i=0; i < FILTER_LEN - 1; i++) {
    points[0] = QPoint(leftBorder + (int)((double)i*scaleX), height() - bottomBorder - scaleY * model->getVoiceData(vStart)->getFilter(index, i));
    points[1] = QPoint(leftBorder + (int)((double)i*scaleX), height() - bottomBorder);
    points[2] = QPoint(leftBorder + (int)((double)(i+1)*scaleX), height() - bottomBorder);
    points[3] = QPoint(leftBorder + (int)((double)(i+1)*scaleX), height() - bottomBorder - scaleY * model->getVoiceData(vStart)->getFilter(index, i+1));
    p.setBrush(QBrush(QColor(200, 150, 0), Qt::SolidPattern));
    p.drawPolygon(points, 4);
  }
  if ((mousePos > -1) && (mousePos < FILTER_LEN) && (mouseVal >= 0) && (mouseVal <= model->getMax())) {
    p.setFont(QFont("Helvetica", 14));
    x = model->getVoiceData(vStart)->getFilter(index, mousePos);
    qs1 = (x > 0) ? QString::number(-0.6 * (100.0 - x), 'f', 1) : QString::number(-100, 'f', 1); 
    qs2 = (mouseVal > 0) ? QString::number(-0.6 * (100.0 - mouseVal), 'f', 1) : QString::number(-100, 'f', 1); 
    qs = "Filter " + QString::number(mousePos + 1) + " :  " + qs1 + " dB" + " <-- " + qs2 + " dB";
    p.drawText(leftBorder, height() - bottomBorder * 0.3, qs);
  }  
  p.end();
}

void Filter::viewportResizeEvent(QResizeEvent *ev) {

  scaleX = (double)(width() - leftBorder - rightBorder) / (double)FILTER_LEN;
  scaleY = (height() - topBorder - bottomBorder) / model->getMax();
  update(0, 0, width(), height());
}

void Filter::mousePressEvent (QMouseEvent *ev) {

  int i;
  double val;
  int vStart, vEnd;
  
  model->getEditRange(vStart, vEnd);
  i = round((ev->x() - leftBorder) / scaleX);
  if ((i >= 0) && (i < FILTER_LEN)) { 
    val = (double)(height() - bottomBorder - ev->y()) / scaleY;
    for (int vl = vStart; vl <= vEnd; vl++) {
      model->getVoiceData(vl)->setFilter(index, i, val);  
    }
    update(0, 0, width(), height());
  }
}

void Filter::mouseReleaseEvent (QMouseEvent *ev) {

  update(0, 0, width(), height());
}

void Filter::mouseMoveEvent (QMouseEvent *ev) {

  int vStart, vEnd;

  model->getEditRange(vStart, vEnd);
  mousePos = round((ev->x() - leftBorder) / scaleX);
  if ((mousePos >= 0) && (mousePos < FILTER_LEN)) {
    mouseVal = (double)(height() - bottomBorder - ev->y()) / scaleY;
    if (ev->buttons() == Qt::LeftButton) {
      for (int vl = vStart; vl <= vEnd; vl++) {
        model->getVoiceData(vl)->setFilter(index, mousePos, mouseVal);  
      }
      update(0, 0, width(), height());
    } else { 
      update(0, height() - bottomBorder, width(), height());
    } 
  }   
}
       
