/* 
 * frankhale@gmail.com
 * http://frankhale.org
 *
 * This code is released under the GPL license www.gnu.org
 */
#include "aewm.hh"

IconMenu::IconMenu(Display * dpy) : GenericMenu(dpy)
{
	updateMenu();
	addToMenuList(this);
}

void IconMenu::handleButtonReleaseEvent(XButtonEvent *e)
{
	GenericMenu::handleButtonReleaseEvent(e);

	switch (e->button) 
	{
		case Button1:
			if (curr) 
			{
				switch(	curr->function )
				{
					case SHOW:
						curr->client->unhide();
						hideAllVisibleSubmenus();
					break;
				
				}										
			}	
		break;
	} 
}

void IconMenu::addThisClient(Client *c)
{
	if(c)
	{
		BaseMenuItem *item = new BaseMenuItem();

		item->client = c;
		
		if(c->getClientIconName() == NULL)
		{
			item->name = "untitled";
		}else
		{
			item->name = c->getClientIconName();
		}
		
		item->function=SHOW;
	
		insert(item);
	}
}

void IconMenu::updateClientName(Client *c)
{
	list<BaseMenuItem*> menuItemList = getMenuItemList();
	list<BaseMenuItem*>::iterator mit;
	
	for(mit = menuItemList.begin(); mit != menuItemList.end(); mit++)
	{
		if(*mit)
		{
			if((*mit)->client == c) 
			{
				if(c->getClientIconName() == NULL)
				{
					(*mit)->name = "Untitled";
				}
				else
				{
					(*mit)->name = c->getClientIconName();
				}
				
				updateMenu();
			}
		}
	}
}

void IconMenu::removeClientFromIconMenu(Client *c)
{
	list<BaseMenuItem*> menuItemList = getMenuItemList();
	list<BaseMenuItem*>::iterator mit;
	
	for(mit = menuItemList.begin(); mit != menuItemList.end(); mit++)
	{
		if(*mit)
		{
			if((*mit)->client == c) 
			{
				remove(*mit);
				delete *mit;
				curr=NULL;
				break;
			}
		}
	}
}
