/*
    This file is part of Akonadi Contact.

    Copyright (c) 2010 Felix Mauch (felix_mauch@web.de)

    This library is free software; you can redistribute it and/or modify it
    under the terms of the GNU Library General Public License as published by
    the Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This library is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
    License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to the
    Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
    02110-1301, USA.
*/

#include "sendsmsaction.h"

#include "contactactionssettings.h"
#include "qskypedialer.h"
#include "smsdialog.h"

#include <kcontacts/phonenumber.h>
#include <KLocalizedString>
#include <KMessageBox>
#include <krun.h>

#include <QPointer>

static QString strippedSmsNumber(const QString &number)
{
    QString result;

    const int numberLenght(number.length());
    for (int i = 0; i < numberLenght; ++i) {
        const QChar character = number.at(i);
        if (character.isDigit() || (character == QLatin1Char('+') && i == 0)) {
            result += character;
        }
    }

    return result;
}

void SendSmsAction::sendSms(const KContacts::PhoneNumber &phoneNumber)
{
    const QString number = phoneNumber.number().trimmed();

    // synchronize
    ContactActionsSettings::self()->load();

    QString command = ContactActionsSettings::self()->smsCommand();

    if (command.isEmpty()) {
        KMessageBox::sorry(nullptr, i18n("There is no application set which could be executed.\nPlease go to the settings dialog and configure one."));
        return;
    }

    QPointer<SmsDialog> dlg(new SmsDialog(number));
    if (dlg->exec() != QDialog::Accepted) {   // the cancel button has been clicked
        delete dlg;
        return;
    }
    const QString message = (dlg != nullptr ? dlg->message() : QString());
    delete dlg;

    //   we handle skype separated
    if (ContactActionsSettings::self()->sendSmsAction() == ContactActionsSettings::UseSkypeSms) {
        QSkypeDialer dialer(QStringLiteral("AkonadiContacts"));
        if (dialer.sendSms(number, message)) {
            // I'm not sure whether here should be a notification.
            // Skype can do a notification itself if whished.
        } else {
            KMessageBox::sorry(nullptr, dialer.errorMessage());
        }

        return;
    }

    /*
     * %N the raw number
     * %n the number with all additional non-number characters removed
     */
    command = command.replace(QStringLiteral("%N"), QStringLiteral("\"%1\"").arg(phoneNumber.number()));
    command = command.replace(QStringLiteral("%n"), QStringLiteral("\"%1\"").arg(strippedSmsNumber(number)));
    command = command.replace(QStringLiteral("%t"), QStringLiteral("\"%1\"").arg(message));
    //Bug: 293232 In KDE3 We used %F to replace text
    command = command.replace(QStringLiteral("%F"), message);
    KRun::runCommand(command, nullptr);
}
