/*
 * Decompiled with CFR 0.152.
 */
package amap;

import amap.Alignment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AmapReader {
    private Map<String, String> nameSeqMap;
    private Map<String, String> nameColorMap;
    List<Alignment> alignments;
    List<String> keys;
    InputStream is;
    boolean firstTime;
    double pWeight;

    public AmapReader(InputStream is) {
        this.is = is;
        this.alignments = new ArrayList<Alignment>();
        this.keys = new ArrayList<String>();
        this.reset();
        this.read();
    }

    public List<Alignment> getAlignments() {
        return this.alignments;
    }

    private void read() {
        Pattern pw = Pattern.compile("^Weight\\s+([+-]?(?=\\d|\\.\\d)\\d*(\\.\\d*)?([Ee]([+-]?\\d+))?)$");
        Matcher pwm = pw.matcher("");
        Pattern s = Pattern.compile("^>(\\S+)\\s+(\\S+)$");
        Matcher sm = s.matcher("");
        Pattern c = Pattern.compile("^@(\\S+)\\s+(\\S+)$");
        Matcher cm = c.matcher("");
        this.firstTime = true;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
            String line = null;
            while ((line = br.readLine()) != null) {
                String val;
                String key;
                pwm.reset(line);
                if (pwm.matches()) {
                    this.saveAlignment();
                    this.pWeight = new Double(pwm.group(1));
                    continue;
                }
                sm.reset(line);
                if (sm.matches()) {
                    key = sm.group(1);
                    val = sm.group(2);
                    if (this.nameSeqMap.containsKey(key)) {
                        val = this.nameSeqMap.get(key) + val;
                    }
                    this.nameSeqMap.put(key, val);
                    if (!this.firstTime) continue;
                    this.keys.add(key);
                    continue;
                }
                cm.reset(line);
                if (!cm.matches()) continue;
                key = cm.group(1);
                val = cm.group(2);
                if (this.nameColorMap.containsKey(key)) {
                    val = this.nameColorMap.get(key) + val;
                }
                this.nameColorMap.put(key, val);
            }
            this.saveAlignment();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void saveAlignment() {
        if (this.pWeight > 0.0) {
            Alignment a = new Alignment(this.keys, this.nameSeqMap, this.nameColorMap, this.pWeight);
            this.alignments.add(a);
            this.reset();
        }
    }

    private void reset() {
        this.nameSeqMap = new HashMap<String, String>();
        this.nameColorMap = new HashMap<String, String>();
        this.pWeight = -1.0;
        this.firstTime = false;
    }
}

