/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.v4.os.ParcelableCompat;
import android.support.v4.os.ParcelableCompatCreatorCallbacks;
import android.support.v4.view.KeyEventCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v4.widget.EdgeEffectCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewPager
extends ViewGroup {
    private static final String TAG = "ViewPager";
    private static final boolean DEBUG = false;
    private static final boolean USE_CACHE = false;
    private static final int DEFAULT_OFFSCREEN_PAGES = 1;
    private static final int MAX_SETTLE_DURATION = 600;
    private static final Comparator<ItemInfo> COMPARATOR = new Comparator<ItemInfo>(){

        @Override
        public int compare(ItemInfo lhs, ItemInfo rhs) {
            return lhs.position - rhs.position;
        }
    };
    private static final Interpolator sInterpolator = new Interpolator(){

        public float getInterpolation(float t) {
            return (t -= 1.0f) * t * t + 1.0f;
        }
    };
    private final ArrayList<ItemInfo> mItems = new ArrayList();
    private PagerAdapter mAdapter;
    private int mCurItem;
    private int mRestoredCurItem = -1;
    private Parcelable mRestoredAdapterState = null;
    private ClassLoader mRestoredClassLoader = null;
    private Scroller mScroller;
    private PagerAdapter.DataSetObserver mObserver;
    private int mPageMargin;
    private Drawable mMarginDrawable;
    private int mChildWidthMeasureSpec;
    private int mChildHeightMeasureSpec;
    private boolean mInLayout;
    private boolean mScrollingCacheEnabled;
    private boolean mPopulatePending;
    private boolean mScrolling;
    private int mOffscreenPageLimit = 1;
    private boolean mIsBeingDragged;
    private boolean mIsUnableToDrag;
    private int mTouchSlop;
    private float mInitialMotionX;
    private float mLastMotionX;
    private float mLastMotionY;
    private int mActivePointerId = -1;
    private static final int INVALID_POINTER = -1;
    private VelocityTracker mVelocityTracker;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private float mBaseLineFlingVelocity;
    private float mFlingVelocityInfluence;
    private boolean mFakeDragging;
    private long mFakeDragBeginTime;
    private EdgeEffectCompat mLeftEdge;
    private EdgeEffectCompat mRightEdge;
    private boolean mFirstLayout = true;
    private OnPageChangeListener mOnPageChangeListener;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SETTLING = 2;
    private int mScrollState = 0;

    public ViewPager(Context context) {
        super(context);
        this.initViewPager();
    }

    public ViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initViewPager();
    }

    void initViewPager() {
        this.setWillNotDraw(false);
        this.setDescendantFocusability(262144);
        this.setFocusable(true);
        Context context = this.getContext();
        this.mScroller = new Scroller(context, sInterpolator);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop(configuration);
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mLeftEdge = new EdgeEffectCompat(context);
        this.mRightEdge = new EdgeEffectCompat(context);
        float density = context.getResources().getDisplayMetrics().density;
        this.mBaseLineFlingVelocity = 2500.0f * density;
        this.mFlingVelocityInfluence = 0.4f;
    }

    private void setScrollState(int newState) {
        if (this.mScrollState == newState) {
            return;
        }
        this.mScrollState = newState;
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrollStateChanged(newState);
        }
    }

    public void setAdapter(PagerAdapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.setDataSetObserver(null);
            this.mAdapter.startUpdate((View)this);
            for (int i = 0; i < this.mItems.size(); ++i) {
                ItemInfo ii = this.mItems.get(i);
                this.mAdapter.destroyItem((View)this, ii.position, ii.object);
            }
            this.mAdapter.finishUpdate((View)this);
            this.mItems.clear();
            this.removeAllViews();
            this.mCurItem = 0;
            this.scrollTo(0, 0);
        }
        this.mAdapter = adapter;
        if (this.mAdapter != null) {
            if (this.mObserver == null) {
                this.mObserver = new DataSetObserver();
            }
            this.mAdapter.setDataSetObserver(this.mObserver);
            this.mPopulatePending = false;
            if (this.mRestoredCurItem >= 0) {
                this.mAdapter.restoreState(this.mRestoredAdapterState, this.mRestoredClassLoader);
                this.setCurrentItemInternal(this.mRestoredCurItem, false, true);
                this.mRestoredCurItem = -1;
                this.mRestoredAdapterState = null;
                this.mRestoredClassLoader = null;
            } else {
                this.populate();
            }
        }
    }

    public PagerAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setCurrentItem(int item) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(item, !this.mFirstLayout, false);
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(item, smoothScroll, false);
    }

    public int getCurrentItem() {
        return this.mCurItem;
    }

    void setCurrentItemInternal(int item, boolean smoothScroll, boolean always) {
        this.setCurrentItemInternal(item, smoothScroll, always, 0);
    }

    void setCurrentItemInternal(int item, boolean smoothScroll, boolean always, int velocity) {
        if (this.mAdapter == null || this.mAdapter.getCount() <= 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        if (!always && this.mCurItem == item && this.mItems.size() != 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        if (item < 0) {
            item = 0;
        } else if (item >= this.mAdapter.getCount()) {
            item = this.mAdapter.getCount() - 1;
        }
        int pageLimit = this.mOffscreenPageLimit;
        if (item > this.mCurItem + pageLimit || item < this.mCurItem - pageLimit) {
            for (int i = 0; i < this.mItems.size(); ++i) {
                this.mItems.get((int)i).scrolling = true;
            }
        }
        boolean dispatchSelected = this.mCurItem != item;
        this.mCurItem = item;
        this.populate();
        int destX = (this.getWidth() + this.mPageMargin) * item;
        if (smoothScroll) {
            this.smoothScrollTo(destX, 0, velocity);
            if (dispatchSelected && this.mOnPageChangeListener != null) {
                this.mOnPageChangeListener.onPageSelected(item);
            }
        } else {
            if (dispatchSelected && this.mOnPageChangeListener != null) {
                this.mOnPageChangeListener.onPageSelected(item);
            }
            this.completeScroll();
            this.scrollTo(destX, 0);
        }
    }

    public void setOnPageChangeListener(OnPageChangeListener listener) {
        this.mOnPageChangeListener = listener;
    }

    public int getOffscreenPageLimit() {
        return this.mOffscreenPageLimit;
    }

    public void setOffscreenPageLimit(int limit) {
        if (limit < 1) {
            Log.w((String)TAG, (String)("Requested offscreen page limit " + limit + " too small; defaulting to " + 1));
            limit = 1;
        }
        if (limit != this.mOffscreenPageLimit) {
            this.mOffscreenPageLimit = limit;
            this.populate();
        }
    }

    public void setPageMargin(int marginPixels) {
        int oldMargin = this.mPageMargin;
        this.mPageMargin = marginPixels;
        int width = this.getWidth();
        this.recomputeScrollPosition(width, width, marginPixels, oldMargin);
        this.requestLayout();
    }

    public int getPageMargin() {
        return this.mPageMargin;
    }

    public void setPageMarginDrawable(Drawable d) {
        this.mMarginDrawable = d;
        if (d != null) {
            this.refreshDrawableState();
        }
        this.setWillNotDraw(d == null);
        this.invalidate();
    }

    public void setPageMarginDrawable(int resId) {
        this.setPageMarginDrawable(this.getContext().getResources().getDrawable(resId));
    }

    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.mMarginDrawable;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable d = this.mMarginDrawable;
        if (d != null && d.isStateful()) {
            d.setState(this.getDrawableState());
        }
    }

    float distanceInfluenceForSnapDuration(float f) {
        f -= 0.5f;
        f = (float)((double)f * 0.4712389167638204);
        return (float)Math.sin(f);
    }

    void smoothScrollTo(int x, int y) {
        this.smoothScrollTo(x, y, 0);
    }

    void smoothScrollTo(int x, int y, int velocity) {
        if (this.getChildCount() == 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        int sx = this.getScrollX();
        int sy = this.getScrollY();
        int dx = x - sx;
        int dy = y - sy;
        if (dx == 0 && dy == 0) {
            this.completeScroll();
            this.setScrollState(0);
            return;
        }
        this.setScrollingCacheEnabled(true);
        this.mScrolling = true;
        this.setScrollState(2);
        float pageDelta = (float)Math.abs(dx) / (float)(this.getWidth() + this.mPageMargin);
        int duration = (int)(pageDelta * 100.0f);
        velocity = Math.abs(velocity);
        duration = velocity > 0 ? (int)((float)duration + (float)duration / ((float)velocity / this.mBaseLineFlingVelocity) * this.mFlingVelocityInfluence) : (duration += 100);
        duration = Math.min(duration, 600);
        this.mScroller.startScroll(sx, sy, dx, dy, duration);
        this.invalidate();
    }

    void addNewItem(int position, int index) {
        ItemInfo ii = new ItemInfo();
        ii.position = position;
        ii.object = this.mAdapter.instantiateItem((View)this, position);
        if (index < 0) {
            this.mItems.add(ii);
        } else {
            this.mItems.add(index, ii);
        }
    }

    void dataSetChanged() {
        boolean needPopulate = this.mItems.size() < 3 && this.mItems.size() < this.mAdapter.getCount();
        int newCurrItem = -1;
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            int newPos = this.mAdapter.getItemPosition(ii.object);
            if (newPos == -1) continue;
            if (newPos == -2) {
                this.mItems.remove(i);
                --i;
                this.mAdapter.destroyItem((View)this, ii.position, ii.object);
                needPopulate = true;
                if (this.mCurItem != ii.position) continue;
                newCurrItem = Math.max(0, Math.min(this.mCurItem, this.mAdapter.getCount() - 1));
                continue;
            }
            if (ii.position == newPos) continue;
            if (ii.position == this.mCurItem) {
                newCurrItem = newPos;
            }
            ii.position = newPos;
            needPopulate = true;
        }
        Collections.sort(this.mItems, COMPARATOR);
        if (newCurrItem >= 0) {
            this.setCurrentItemInternal(newCurrItem, false, true);
            needPopulate = true;
        }
        if (needPopulate) {
            this.populate();
            this.requestLayout();
        }
    }

    void populate() {
        if (this.mAdapter == null) {
            return;
        }
        if (this.mPopulatePending) {
            return;
        }
        if (this.getWindowToken() == null) {
            return;
        }
        this.mAdapter.startUpdate((View)this);
        int pageLimit = this.mOffscreenPageLimit;
        int startPos = Math.max(0, this.mCurItem - pageLimit);
        int N = this.mAdapter.getCount();
        int endPos = Math.min(N - 1, this.mCurItem + pageLimit);
        int lastPos = -1;
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            if (!(ii.position >= startPos && ii.position <= endPos || ii.scrolling)) {
                this.mItems.remove(i);
                --i;
                this.mAdapter.destroyItem((View)this, ii.position, ii.object);
            } else if (lastPos < endPos && ii.position > startPos) {
                if (++lastPos < startPos) {
                    lastPos = startPos;
                }
                while (lastPos <= endPos && lastPos < ii.position) {
                    this.addNewItem(lastPos, i);
                    ++lastPos;
                    ++i;
                }
            }
            lastPos = ii.position;
        }
        int n = lastPos = this.mItems.size() > 0 ? this.mItems.get((int)(this.mItems.size() - 1)).position : -1;
        if (lastPos < endPos) {
            int n2 = lastPos = ++lastPos > startPos ? lastPos : startPos;
            while (lastPos <= endPos) {
                this.addNewItem(lastPos, -1);
                ++lastPos;
            }
        }
        ItemInfo curItem = null;
        for (int i = 0; i < this.mItems.size(); ++i) {
            if (this.mItems.get((int)i).position != this.mCurItem) continue;
            curItem = this.mItems.get(i);
            break;
        }
        this.mAdapter.setPrimaryItem((View)this, this.mCurItem, curItem != null ? curItem.object : null);
        this.mAdapter.finishUpdate((View)this);
        if (this.hasFocus()) {
            ItemInfo ii;
            View currentFocused = this.findFocus();
            ItemInfo itemInfo = ii = currentFocused != null ? this.infoForAnyChild(currentFocused) : null;
            if (ii == null || ii.position != this.mCurItem) {
                View child;
                for (int i = 0; !(i >= this.getChildCount() || (ii = this.infoForChild(child = this.getChildAt(i))) != null && ii.position == this.mCurItem && child.requestFocus(2)); ++i) {
                }
            }
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.position = this.mCurItem;
        if (this.mAdapter != null) {
            ss.adapterState = this.mAdapter.saveState();
        }
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (this.mAdapter != null) {
            this.mAdapter.restoreState(ss.adapterState, ss.loader);
            this.setCurrentItemInternal(ss.position, false, true);
        } else {
            this.mRestoredCurItem = ss.position;
            this.mRestoredAdapterState = ss.adapterState;
            this.mRestoredClassLoader = ss.loader;
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.mInLayout) {
            this.addViewInLayout(child, index, params);
            child.measure(this.mChildWidthMeasureSpec, this.mChildHeightMeasureSpec);
        } else {
            super.addView(child, index, params);
        }
    }

    ItemInfo infoForChild(View child) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            if (!this.mAdapter.isViewFromObject(child, ii.object)) continue;
            return ii;
        }
        return null;
    }

    ItemInfo infoForAnyChild(View child) {
        ViewParent parent;
        while ((parent = child.getParent()) != this) {
            if (parent == null || !(parent instanceof View)) {
                return null;
            }
            child = (View)parent;
        }
        return this.infoForChild(child);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(ViewPager.getDefaultSize((int)0, (int)widthMeasureSpec), ViewPager.getDefaultSize((int)0, (int)heightMeasureSpec));
        this.mChildWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000);
        this.mChildHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom()), (int)0x40000000);
        this.mInLayout = true;
        this.populate();
        this.mInLayout = false;
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.measure(this.mChildWidthMeasureSpec, this.mChildHeightMeasureSpec);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw) {
            this.recomputeScrollPosition(w, oldw, this.mPageMargin, this.mPageMargin);
        }
    }

    private void recomputeScrollPosition(int width, int oldWidth, int margin, int oldMargin) {
        int widthWithMargin = width + margin;
        if (oldWidth > 0) {
            int oldScrollPos = this.getScrollX();
            int oldwwm = oldWidth + oldMargin;
            int oldScrollItem = oldScrollPos / oldwwm;
            float scrollOffset = (float)(oldScrollPos % oldwwm) / (float)oldwwm;
            int scrollPos = (int)(((float)oldScrollItem + scrollOffset) * (float)widthWithMargin);
            this.scrollTo(scrollPos, this.getScrollY());
            if (!this.mScroller.isFinished()) {
                int newDuration = this.mScroller.getDuration() - this.mScroller.timePassed();
                this.mScroller.startScroll(scrollPos, 0, this.mCurItem * widthWithMargin, 0, newDuration);
            }
        } else {
            int scrollPos = this.mCurItem * widthWithMargin;
            if (scrollPos != this.getScrollX()) {
                this.completeScroll();
                this.scrollTo(scrollPos, this.getScrollY());
            }
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mInLayout = true;
        this.populate();
        this.mInLayout = false;
        int count = this.getChildCount();
        int width = r - l;
        for (int i = 0; i < count; ++i) {
            ItemInfo ii;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 || (ii = this.infoForChild(child)) == null) continue;
            int loff = (width + this.mPageMargin) * ii.position;
            int childLeft = this.getPaddingLeft() + loff;
            int childTop = this.getPaddingTop();
            child.layout(childLeft, childTop, childLeft + child.getMeasuredWidth(), childTop + child.getMeasuredHeight());
        }
        this.mFirstLayout = false;
    }

    public void computeScroll() {
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (oldX != x || oldY != y) {
                this.scrollTo(x, y);
            }
            if (this.mOnPageChangeListener != null) {
                int widthWithMargin = this.getWidth() + this.mPageMargin;
                int position = x / widthWithMargin;
                int offsetPixels = x % widthWithMargin;
                float offset = (float)offsetPixels / (float)widthWithMargin;
                this.mOnPageChangeListener.onPageScrolled(position, offset, offsetPixels);
            }
            this.invalidate();
            return;
        }
        this.completeScroll();
    }

    private void completeScroll() {
        boolean needPopulate = this.mScrolling;
        if (needPopulate) {
            this.setScrollingCacheEnabled(false);
            this.mScroller.abortAnimation();
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (oldX != x || oldY != y) {
                this.scrollTo(x, y);
            }
            this.setScrollState(0);
        }
        this.mPopulatePending = false;
        this.mScrolling = false;
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            if (!ii.scrolling) continue;
            needPopulate = true;
            ii.scrolling = false;
        }
        if (needPopulate) {
            this.populate();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction() & 0xFF;
        if (action == 3 || action == 1) {
            this.mIsBeingDragged = false;
            this.mIsUnableToDrag = false;
            this.mActivePointerId = -1;
            return false;
        }
        if (action != 0) {
            if (this.mIsBeingDragged) {
                return true;
            }
            if (this.mIsUnableToDrag) {
                return false;
            }
        }
        switch (action) {
            case 2: {
                boolean atEdge;
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1) break;
                int pointerIndex = MotionEventCompat.findPointerIndex(ev, activePointerId);
                float x = MotionEventCompat.getX(ev, pointerIndex);
                float dx = x - this.mLastMotionX;
                float xDiff = Math.abs(dx);
                float y = MotionEventCompat.getY(ev, pointerIndex);
                float yDiff = Math.abs(y - this.mLastMotionY);
                int scrollX = this.getScrollX();
                boolean bl = atEdge = dx > 0.0f && scrollX == 0 || dx < 0.0f && this.mAdapter != null && scrollX >= (this.mAdapter.getCount() - 1) * this.getWidth() - 1;
                if (this.canScroll((View)this, false, (int)dx, (int)x, (int)y)) {
                    this.mInitialMotionX = this.mLastMotionX = x;
                    this.mLastMotionY = y;
                    return false;
                }
                if (xDiff > (float)this.mTouchSlop && xDiff > yDiff) {
                    this.mIsBeingDragged = true;
                    this.setScrollState(1);
                    this.mLastMotionX = x;
                    this.setScrollingCacheEnabled(true);
                    break;
                }
                if (!(yDiff > (float)this.mTouchSlop)) break;
                this.mIsUnableToDrag = true;
                break;
            }
            case 0: {
                this.mLastMotionX = this.mInitialMotionX = ev.getX();
                this.mLastMotionY = ev.getY();
                this.mActivePointerId = MotionEventCompat.getPointerId(ev, 0);
                if (this.mScrollState == 2) {
                    this.mIsBeingDragged = true;
                    this.mIsUnableToDrag = false;
                    this.setScrollState(1);
                    break;
                }
                this.completeScroll();
                this.mIsBeingDragged = false;
                this.mIsUnableToDrag = false;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        return this.mIsBeingDragged;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mFakeDragging) {
            return true;
        }
        if (ev.getAction() == 0 && ev.getEdgeFlags() != 0) {
            return false;
        }
        if (this.mAdapter == null || this.mAdapter.getCount() == 0) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        int action = ev.getAction();
        boolean needsInvalidate = false;
        switch (action & 0xFF) {
            case 0: {
                this.completeScroll();
                this.mLastMotionX = this.mInitialMotionX = ev.getX();
                this.mActivePointerId = MotionEventCompat.getPointerId(ev, 0);
                break;
            }
            case 2: {
                float over;
                float x;
                if (!this.mIsBeingDragged) {
                    int pointerIndex = MotionEventCompat.findPointerIndex(ev, this.mActivePointerId);
                    x = MotionEventCompat.getX(ev, pointerIndex);
                    float xDiff = Math.abs(x - this.mLastMotionX);
                    float y = MotionEventCompat.getY(ev, pointerIndex);
                    float yDiff = Math.abs(y - this.mLastMotionY);
                    if (xDiff > (float)this.mTouchSlop && xDiff > yDiff) {
                        this.mIsBeingDragged = true;
                        this.mLastMotionX = x;
                        this.setScrollState(1);
                        this.setScrollingCacheEnabled(true);
                    }
                }
                if (!this.mIsBeingDragged) break;
                int activePointerIndex = MotionEventCompat.findPointerIndex(ev, this.mActivePointerId);
                x = MotionEventCompat.getX(ev, activePointerIndex);
                float deltaX = this.mLastMotionX - x;
                this.mLastMotionX = x;
                float oldScrollX = this.getScrollX();
                float scrollX = oldScrollX + deltaX;
                int width = this.getWidth();
                int widthWithMargin = width + this.mPageMargin;
                int lastItemIndex = this.mAdapter.getCount() - 1;
                float leftBound = Math.max(0, (this.mCurItem - 1) * widthWithMargin);
                float rightBound = Math.min(this.mCurItem + 1, lastItemIndex) * widthWithMargin;
                if (scrollX < leftBound) {
                    if (leftBound == 0.0f) {
                        over = -scrollX;
                        needsInvalidate = this.mLeftEdge.onPull(over / (float)width);
                    }
                    scrollX = leftBound;
                } else if (scrollX > rightBound) {
                    if (rightBound == (float)(lastItemIndex * widthWithMargin)) {
                        over = scrollX - rightBound;
                        needsInvalidate = this.mRightEdge.onPull(over / (float)width);
                    }
                    scrollX = rightBound;
                }
                this.mLastMotionX += scrollX - (float)((int)scrollX);
                this.scrollTo((int)scrollX, this.getScrollY());
                if (this.mOnPageChangeListener == null) break;
                int position = (int)scrollX / widthWithMargin;
                int positionOffsetPixels = (int)scrollX % widthWithMargin;
                float positionOffset = (float)positionOffsetPixels / (float)widthWithMargin;
                this.mOnPageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
                break;
            }
            case 1: {
                if (!this.mIsBeingDragged) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int initialVelocity = (int)VelocityTrackerCompat.getXVelocity(velocityTracker, this.mActivePointerId);
                this.mPopulatePending = true;
                int widthWithMargin = this.getWidth() + this.mPageMargin;
                int scrollX = this.getScrollX();
                int currentPage = scrollX / widthWithMargin;
                int nextPage = initialVelocity > 0 ? currentPage : currentPage + 1;
                this.setCurrentItemInternal(nextPage, true, true, initialVelocity);
                this.mActivePointerId = -1;
                this.endDrag();
                needsInvalidate = this.mLeftEdge.onRelease() | this.mRightEdge.onRelease();
                break;
            }
            case 3: {
                if (!this.mIsBeingDragged) break;
                this.setCurrentItemInternal(this.mCurItem, true, true);
                this.mActivePointerId = -1;
                this.endDrag();
                needsInvalidate = this.mLeftEdge.onRelease() | this.mRightEdge.onRelease();
                break;
            }
            case 5: {
                float x;
                int index = MotionEventCompat.getActionIndex(ev);
                this.mLastMotionX = x = MotionEventCompat.getX(ev, index);
                this.mActivePointerId = MotionEventCompat.getPointerId(ev, index);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                this.mLastMotionX = MotionEventCompat.getX(ev, MotionEventCompat.findPointerIndex(ev, this.mActivePointerId));
            }
        }
        if (needsInvalidate) {
            this.invalidate();
        }
        return true;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        boolean needsInvalidate = false;
        int overScrollMode = ViewCompat.getOverScrollMode((View)this);
        if (overScrollMode == 0 || overScrollMode == 1 && this.mAdapter != null && this.mAdapter.getCount() > 1) {
            int restoreCount;
            if (!this.mLeftEdge.isFinished()) {
                restoreCount = canvas.save();
                int height = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                canvas.rotate(270.0f);
                canvas.translate((float)(-height + this.getPaddingTop()), 0.0f);
                this.mLeftEdge.setSize(height, this.getWidth());
                needsInvalidate |= this.mLeftEdge.draw(canvas);
                canvas.restoreToCount(restoreCount);
            }
            if (!this.mRightEdge.isFinished()) {
                restoreCount = canvas.save();
                int width = this.getWidth();
                int height = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                int itemCount = this.mAdapter != null ? this.mAdapter.getCount() : 1;
                canvas.rotate(90.0f);
                canvas.translate((float)(-this.getPaddingTop()), (float)(-itemCount * (width + this.mPageMargin) + this.mPageMargin));
                this.mRightEdge.setSize(height, width);
                needsInvalidate |= this.mRightEdge.draw(canvas);
                canvas.restoreToCount(restoreCount);
            }
        } else {
            this.mLeftEdge.finish();
            this.mRightEdge.finish();
        }
        if (needsInvalidate) {
            this.invalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        int width;
        int scrollX;
        int offset;
        super.onDraw(canvas);
        if (this.mPageMargin > 0 && this.mMarginDrawable != null && (offset = (scrollX = this.getScrollX()) % ((width = this.getWidth()) + this.mPageMargin)) != 0) {
            int left = scrollX - offset + width;
            this.mMarginDrawable.setBounds(left, 0, left + this.mPageMargin, this.getHeight());
            this.mMarginDrawable.draw(canvas);
        }
    }

    public boolean beginFakeDrag() {
        if (this.mIsBeingDragged) {
            return false;
        }
        this.mFakeDragging = true;
        this.setScrollState(1);
        this.mLastMotionX = 0.0f;
        this.mInitialMotionX = 0.0f;
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
        long time = SystemClock.uptimeMillis();
        MotionEvent ev = MotionEvent.obtain((long)time, (long)time, (int)0, (float)0.0f, (float)0.0f, (int)0);
        this.mVelocityTracker.addMovement(ev);
        ev.recycle();
        this.mFakeDragBeginTime = time;
        return true;
    }

    public void endFakeDrag() {
        if (!this.mFakeDragging) {
            throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
        }
        VelocityTracker velocityTracker = this.mVelocityTracker;
        velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
        int initialVelocity = (int)VelocityTrackerCompat.getYVelocity(velocityTracker, this.mActivePointerId);
        this.mPopulatePending = true;
        if (Math.abs(initialVelocity) > this.mMinimumVelocity || Math.abs(this.mInitialMotionX - this.mLastMotionX) >= (float)(this.getWidth() / 3)) {
            if (this.mLastMotionX > this.mInitialMotionX) {
                this.setCurrentItemInternal(this.mCurItem - 1, true, true);
            } else {
                this.setCurrentItemInternal(this.mCurItem + 1, true, true);
            }
        } else {
            this.setCurrentItemInternal(this.mCurItem, true, true);
        }
        this.endDrag();
        this.mFakeDragging = false;
    }

    public void fakeDragBy(float xOffset) {
        if (!this.mFakeDragging) {
            throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
        }
        this.mLastMotionX += xOffset;
        float scrollX = (float)this.getScrollX() - xOffset;
        int width = this.getWidth();
        int widthWithMargin = width + this.mPageMargin;
        float leftBound = Math.max(0, (this.mCurItem - 1) * widthWithMargin);
        float rightBound = Math.min(this.mCurItem + 1, this.mAdapter.getCount() - 1) * widthWithMargin;
        if (scrollX < leftBound) {
            scrollX = leftBound;
        } else if (scrollX > rightBound) {
            scrollX = rightBound;
        }
        this.mLastMotionX += scrollX - (float)((int)scrollX);
        this.scrollTo((int)scrollX, this.getScrollY());
        if (this.mOnPageChangeListener != null) {
            int position = (int)scrollX / widthWithMargin;
            int positionOffsetPixels = (int)scrollX % widthWithMargin;
            float positionOffset = (float)positionOffsetPixels / (float)widthWithMargin;
            this.mOnPageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
        long time = SystemClock.uptimeMillis();
        MotionEvent ev = MotionEvent.obtain((long)this.mFakeDragBeginTime, (long)time, (int)2, (float)this.mLastMotionX, (float)0.0f, (int)0);
        this.mVelocityTracker.addMovement(ev);
        ev.recycle();
    }

    public boolean isFakeDragging() {
        return this.mFakeDragging;
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = MotionEventCompat.getActionIndex(ev);
        int pointerId = MotionEventCompat.getPointerId(ev, pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mLastMotionX = MotionEventCompat.getX(ev, newPointerIndex);
            this.mActivePointerId = MotionEventCompat.getPointerId(ev, newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.mIsUnableToDrag = false;
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private void setScrollingCacheEnabled(boolean enabled) {
        if (this.mScrollingCacheEnabled != enabled) {
            this.mScrollingCacheEnabled = enabled;
        }
    }

    protected boolean canScroll(View v, boolean checkV, int dx, int x, int y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int scrollX = v.getScrollX();
            int scrollY = v.getScrollY();
            int count = group.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                if (x + scrollX < child.getLeft() || x + scrollX >= child.getRight() || y + scrollY < child.getTop() || y + scrollY >= child.getBottom() || !this.canScroll(child, true, dx, x + scrollX - child.getLeft(), y + scrollY - child.getTop())) continue;
                return true;
            }
        }
        return checkV && ViewCompat.canScrollHorizontally(v, -dx);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return super.dispatchKeyEvent(event) || this.executeKeyEvent(event);
    }

    public boolean executeKeyEvent(KeyEvent event) {
        boolean handled = false;
        if (event.getAction() == 0) {
            switch (event.getKeyCode()) {
                case 21: {
                    handled = this.arrowScroll(17);
                    break;
                }
                case 22: {
                    handled = this.arrowScroll(66);
                    break;
                }
                case 61: {
                    if (KeyEventCompat.hasNoModifiers(event)) {
                        handled = this.arrowScroll(2);
                        break;
                    }
                    if (!KeyEventCompat.hasModifiers(event, 1)) break;
                    handled = this.arrowScroll(1);
                }
            }
        }
        return handled;
    }

    public boolean arrowScroll(int direction) {
        View currentFocused = this.findFocus();
        if (currentFocused == this) {
            currentFocused = null;
        }
        boolean handled = false;
        View nextFocused = FocusFinder.getInstance().findNextFocus((ViewGroup)this, currentFocused, direction);
        if (nextFocused != null && nextFocused != currentFocused) {
            if (direction == 17) {
                handled = currentFocused != null && nextFocused.getLeft() >= currentFocused.getLeft() ? this.pageLeft() : nextFocused.requestFocus();
            } else if (direction == 66) {
                handled = currentFocused != null && nextFocused.getLeft() <= currentFocused.getLeft() ? this.pageRight() : nextFocused.requestFocus();
            }
        } else if (direction == 17 || direction == 1) {
            handled = this.pageLeft();
        } else if (direction == 66 || direction == 2) {
            handled = this.pageRight();
        }
        if (handled) {
            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection((int)direction));
        }
        return handled;
    }

    boolean pageLeft() {
        if (this.mCurItem > 0) {
            this.setCurrentItem(this.mCurItem - 1, true);
            return true;
        }
        return false;
    }

    boolean pageRight() {
        if (this.mAdapter != null && this.mCurItem < this.mAdapter.getCount() - 1) {
            this.setCurrentItem(this.mCurItem + 1, true);
            return true;
        }
        return false;
    }

    public void addFocusables(ArrayList<View> views, int direction, int focusableMode) {
        int focusableCount = views.size();
        int descendantFocusability = this.getDescendantFocusability();
        if (descendantFocusability != 393216) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ItemInfo ii;
                View child = this.getChildAt(i);
                if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurItem) continue;
                child.addFocusables(views, direction, focusableMode);
            }
        }
        if (descendantFocusability != 262144 || focusableCount == views.size()) {
            if (!this.isFocusable()) {
                return;
            }
            if ((focusableMode & 1) == 1 && this.isInTouchMode() && !this.isFocusableInTouchMode()) {
                return;
            }
            if (views != null) {
                views.add((View)this);
            }
        }
    }

    public void addTouchables(ArrayList<View> views) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ItemInfo ii;
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurItem) continue;
            child.addTouchables(views);
        }
    }

    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        int end;
        int increment;
        int index;
        int count = this.getChildCount();
        if ((direction & 2) != 0) {
            index = 0;
            increment = 1;
            end = count;
        } else {
            index = count - 1;
            increment = -1;
            end = -1;
        }
        for (int i = index; i != end; i += increment) {
            ItemInfo ii;
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurItem || !child.requestFocus(direction, previouslyFocusedRect)) continue;
            return true;
        }
        return false;
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ItemInfo ii;
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurItem || !child.dispatchPopulateAccessibilityEvent(event)) continue;
            return true;
        }
        return false;
    }

    private class DataSetObserver
    implements PagerAdapter.DataSetObserver {
        private DataSetObserver() {
        }

        public void onDataSetChanged() {
            ViewPager.this.dataSetChanged();
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        int position;
        Parcelable adapterState;
        ClassLoader loader;
        public static final Parcelable.Creator<SavedState> CREATOR = ParcelableCompat.newCreator(new ParcelableCompatCreatorCallbacks<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        });

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.position);
            out.writeParcelable(this.adapterState, flags);
        }

        public String toString() {
            return "FragmentPager.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " position=" + this.position + "}";
        }

        SavedState(Parcel in, ClassLoader loader) {
            super(in);
            if (loader == null) {
                loader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            this.position = in.readInt();
            this.adapterState = in.readParcelable(loader);
            this.loader = loader;
        }
    }

    public static class SimpleOnPageChangeListener
    implements OnPageChangeListener {
        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
        }

        public void onPageScrollStateChanged(int state) {
        }
    }

    public static interface OnPageChangeListener {
        public void onPageScrolled(int var1, float var2, int var3);

        public void onPageSelected(int var1);

        public void onPageScrollStateChanged(int var1);
    }

    static class ItemInfo {
        Object object;
        int position;
        boolean scrolling;

        ItemInfo() {
        }
    }
}

