/*
 * Decompiled with CFR 0.152.
 */
package android.support.v13.dreams;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;

public class BasicDream
extends Activity {
    private static final String TAG = "BasicDream";
    private static final boolean DEBUG = true;
    private View mView;
    private boolean mPlugged = false;
    private final BroadcastReceiver mPowerIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.BATTERY_CHANGED".equals(action)) {
                boolean plugged;
                boolean bl = plugged = 1 == intent.getIntExtra("plugged", 0);
                if (plugged != BasicDream.this.mPlugged) {
                    Log.d((String)BasicDream.TAG, (String)("now " + (plugged ? "plugged in" : "unplugged")));
                    BasicDream.this.mPlugged = plugged;
                    if (BasicDream.this.mPlugged) {
                        BasicDream.this.getWindow().addFlags(128);
                    } else {
                        BasicDream.this.getWindow().clearFlags(128);
                    }
                }
            }
        }
    };

    public void onStart() {
        super.onStart();
        this.setContentView(new BasicDreamView((Context)this));
        this.getWindow().addFlags(524289);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.BATTERY_CHANGED");
        this.registerReceiver(this.mPowerIntentReceiver, filter);
    }

    public void onPause() {
        super.onPause();
        Log.d((String)TAG, (String)"exiting onPause");
        this.finish();
    }

    public void onStop() {
        super.onStop();
        this.unregisterReceiver(this.mPowerIntentReceiver);
    }

    protected View getContentView() {
        return this.mView;
    }

    public void setContentView(View v) {
        super.setContentView(v);
        this.mView = v;
    }

    protected void invalidate() {
        this.getContentView().invalidate();
    }

    public void onDraw(Canvas c) {
    }

    public void onUserInteraction() {
        Log.d((String)TAG, (String)"exiting onUserInteraction");
        this.finish();
    }

    class BasicDreamView
    extends View {
        public BasicDreamView(Context c) {
            super(c);
        }

        public BasicDreamView(Context c, AttributeSet at) {
            super(c, at);
        }

        public void onAttachedToWindow() {
            this.setSystemUiVisibility(1);
        }

        public void onDraw(Canvas c) {
            BasicDream.this.onDraw(c);
        }
    }
}

