/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.BindingTarget;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.store.SetterStore;
import android.databinding.tool.writer.CodeGenUtil;

public class Binding {
    private final String mName;
    private final Expr mExpr;
    private final BindingTarget mTarget;
    private SetterStore.SetterCall mSetterCall;

    public Binding(BindingTarget target, String name, Expr expr) {
        this.mTarget = target;
        this.mName = name;
        this.mExpr = expr;
    }

    private SetterStore.BindingSetterCall getSetterCall() {
        if (this.mSetterCall == null) {
            ModelClass viewType = this.mTarget.getResolvedType();
            this.mSetterCall = viewType != null && viewType.extendsViewStub() ? (this.isViewStubAttribute() ? new ViewStubDirectCall(this.mName, viewType, this.mExpr) : new ViewStubSetterCall(this.mName)) : SetterStore.get(ModelAnalyzer.getInstance()).getSetterCall(this.mName, viewType, this.mExpr.getResolvedType(), this.mExpr.getModel().getImports());
        }
        return this.mSetterCall;
    }

    public BindingTarget getTarget() {
        return this.mTarget;
    }

    public String toJavaCode(String targetViewName) {
        String argCode = CodeGenUtil.Companion.toCode(this.getExpr(), false).generate();
        return this.getSetterCall().toJava(targetViewName, argCode);
    }

    public int getMinApi() {
        return this.getSetterCall().getMinApi();
    }

    public String getName() {
        return this.mName;
    }

    public Expr getExpr() {
        return this.mExpr;
    }

    private boolean isViewStubAttribute() {
        if ("android:inflatedId".equals(this.mName)) {
            return true;
        }
        if ("android:layout".equals(this.mName)) {
            return true;
        }
        return "android:visibility".equals(this.mName);
    }

    private static class ViewStubDirectCall
    extends SetterStore.SetterCall {
        private final SetterStore.SetterCall mWrappedCall;

        public ViewStubDirectCall(String name, ModelClass viewType, Expr expr) {
            this.mWrappedCall = SetterStore.get(ModelAnalyzer.getInstance()).getSetterCall(name, viewType, expr.getResolvedType(), expr.getModel().getImports());
        }

        @Override
        protected String toJavaInternal(String viewExpression, String converted) {
            return "if (!" + viewExpression + ".isInflated()) " + this.mWrappedCall.toJava(viewExpression + ".getViewStub()", converted);
        }

        @Override
        public int getMinApi() {
            return 0;
        }
    }

    private static class ViewStubSetterCall
    extends SetterStore.SetterCall {
        private final String mName;

        public ViewStubSetterCall(String name) {
            this.mName = name.substring(name.lastIndexOf(58) + 1);
        }

        @Override
        protected String toJavaInternal(String viewExpression, String converted) {
            return "if (" + viewExpression + ".isInflated()) " + viewExpression + ".getBinding().setVariable(BR." + this.mName + ", " + converted + ")";
        }

        @Override
        public int getMinApi() {
            return 0;
        }
    }
}

