
#line 3 "lex.rc_yy.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define rc_yyconst const
#else
#define rc_yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (rc_yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((rc_yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE rc_yyrestart(rc_yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(rc_yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct rc_yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int rc_yyleng;

extern FILE *rc_yyin, *rc_yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define rc_yyless(n) \
	do \
		{ \
		/* Undo effects of setting up rc_yytext. */ \
        int rc_yyless_macro_arg = (n); \
        YY_LESS_LINENO(rc_yyless_macro_arg);\
		*rc_yy_cp = (rc_yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(rc_yy_c_buf_p) = rc_yy_cp = rc_yy_bp + rc_yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up rc_yytext again */ \
		} \
	while ( 0 )

#define unput(c) rc_yyunput( c, (rc_yytext_ptr)  )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t rc_yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct rc_yy_buffer_state
	{
	FILE *rc_yy_input_file;

	char *rc_yy_ch_buf;		/* input buffer */
	char *rc_yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	rc_yy_size_t rc_yy_buf_size;

	/* Number of characters read into rc_yy_ch_buf, not including EOB
	 * characters.
	 */
	int rc_yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int rc_yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int rc_yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int rc_yy_at_bol;

    int rc_yy_bs_lineno; /**< The line count. */
    int rc_yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int rc_yy_fill_buffer;

	int rc_yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via rc_yyrestart()), so that the user can continue scanning by
	 * just pointing rc_yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t rc_yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t rc_yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * rc_yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (rc_yy_buffer_stack) \
                          ? (rc_yy_buffer_stack)[(rc_yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (rc_yy_buffer_stack)[(rc_yy_buffer_stack_top)]

/* rc_yy_hold_char holds the character lost when rc_yytext is formed. */
static char rc_yy_hold_char;
static int rc_yy_n_chars;		/* number of characters read into rc_yy_ch_buf */
int rc_yyleng;

/* Points to current character in buffer. */
static char *rc_yy_c_buf_p = (char *) 0;
static int rc_yy_init = 0;		/* whether we need to initialize */
static int rc_yy_start = 0;	/* start state number */

/* Flag which is used to allow rc_yywrap()'s to do buffer switches
 * instead of setting up a fresh rc_yyin.  A bit of a hack ...
 */
static int rc_yy_did_buffer_switch_on_eof;

void rc_yyrestart (FILE *input_file  );
void rc_yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE rc_yy_create_buffer (FILE *file,int size  );
void rc_yy_delete_buffer (YY_BUFFER_STATE b  );
void rc_yy_flush_buffer (YY_BUFFER_STATE b  );
void rc_yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void rc_yypop_buffer_state (void );

static void rc_yyensure_buffer_stack (void );
static void rc_yy_load_buffer_state (void );
static void rc_yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER rc_yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE rc_yy_scan_buffer (char *base,rc_yy_size_t size  );
YY_BUFFER_STATE rc_yy_scan_string (rc_yyconst char *rc_yy_str  );
YY_BUFFER_STATE rc_yy_scan_bytes (rc_yyconst char *bytes,int len  );

void *rc_yyalloc (rc_yy_size_t  );
void *rc_yyrealloc (void *,rc_yy_size_t  );
void rc_yyfree (void *  );

#define rc_yy_new_buffer rc_yy_create_buffer

#define rc_yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        rc_yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            rc_yy_create_buffer(rc_yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->rc_yy_is_interactive = is_interactive; \
	}

#define rc_yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        rc_yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            rc_yy_create_buffer(rc_yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->rc_yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->rc_yy_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *rc_yyin = (FILE *) 0, *rc_yyout = (FILE *) 0;

typedef int rc_yy_state_type;

extern int rc_yylineno;

int rc_yylineno = 1;

extern char *rc_yytext;
#define rc_yytext_ptr rc_yytext

static rc_yy_state_type rc_yy_get_previous_state (void );
static rc_yy_state_type rc_yy_try_NUL_trans (rc_yy_state_type current_state  );
static int rc_yy_get_next_buffer (void );
static void rc_yy_fatal_error (rc_yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up rc_yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(rc_yytext_ptr) = rc_yy_bp; \
	rc_yyleng = (size_t) (rc_yy_cp - rc_yy_bp); \
	(rc_yy_hold_char) = *rc_yy_cp; \
	*rc_yy_cp = '\0'; \
	(rc_yy_c_buf_p) = rc_yy_cp;

#define YY_NUM_RULES 46
#define YY_END_OF_BUFFER 47
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct rc_yy_trans_info
	{
	flex_int32_t rc_yy_verify;
	flex_int32_t rc_yy_nxt;
	};
static rc_yyconst flex_int16_t rc_yy_accept[193] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,   47,   45,
       40,   42,   45,   45,    2,   43,   25,   25,   45,   25,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       25,   25,   25,   45,   25,   25,   46,   46,   31,   46,
       37,   38,   39,   37,   37,   37,   46,   34,   40,   44,
        0,   26,    0,    2,    1,   25,   25,    0,   25,   25,
       25,   25,   25,   25,   25,   25,   25,   16,   25,   15,
       25,   25,    8,   25,   25,   25,   25,   41,    0,   31,
        0,   30,   29,   37,   37,   38,   37,   26,   37,   37,
       35,    0,   34,   28,   27,   25,    0,    0,   21,    7,

       25,   25,   25,   25,   25,   25,    5,   25,   25,    9,
       25,   25,   25,   25,   25,   36,   28,   27,   28,   37,
       37,    0,   25,   25,    0,   32,    0,   25,   12,   14,
       25,   20,   17,   25,   25,   25,   25,   18,   13,   25,
       37,    0,    0,   25,   25,    0,   33,    3,   25,   25,
       25,   24,   25,   25,   37,   37,    0,    0,   25,   25,
       25,   10,   23,   22,   25,   33,    0,    0,   25,    0,
       25,   11,   19,    0,    0,   25,   25,    0,    0,    0,
        6,    6,    0,    0,    0,    0,    0,    0,    0,    4,
        4,    0

    } ;

static rc_yyconst flex_int32_t rc_yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    1,    1,    1,    1,    7,
        7,    1,    1,    1,    8,    9,    9,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,    7,    1,   11,
       12,    1,    1,    1,   13,   14,   15,   16,   17,   18,
       19,   20,   21,    9,    9,   22,   23,   24,   25,   26,
        9,   27,   28,   29,   30,   31,    9,   32,   33,    9,
        7,   34,    7,    1,    9,    1,   13,   35,   15,   36,

       37,   18,   38,   20,   39,    9,    9,   22,   23,   40,
       25,   26,    9,   27,   28,   29,   30,   31,    9,   32,
       33,    9,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static rc_yyconst flex_int32_t rc_yy_meta[41] =
    {   0,
        1,    2,    3,    1,    1,    1,    1,    4,    4,    4,
        1,    1,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    1,    4,    4,    4,    4,    4,    4
    } ;

static rc_yyconst flex_int16_t rc_yy_base[211] =
    {   0,
        0,    0,   38,   39,   43,   47,  332,  331,  333,  336,
      330,  336,  319,   42,  327,  336,  321,    0,  317,   35,
       36,   42,  302,   38,   35,   46,  308,  300,  299,  296,
       48,  293,  294,  317,  294,  296,   52,  336,  336,  307,
      282,  313,  336,   64,   53,   65,  311,  336,  311,  336,
       74,  336,  302,  308,  336,  302,    0,  301,   54,   64,
      289,   66,  285,  283,   64,  277,  288,    0,  290,    0,
       73,  273,    0,   72,  279,  275,   72,  336,   79,  336,
      289,  336,  336,  264,   89,  295,   92,  262,  104,  138,
      336,  292,  336,  336,  336,  101,  114,  119,    0,    0,

      273,  260,  270,  268,   95,  110,    0,  112,   80,    0,
      114,  265,  116,  263,   86,  336,  254,  253,  126,  172,
        0,  138,  269,  261,  155,  336,  281,  259,    0,    0,
      269,    0,    0,  117,  263,  248,  248,    0,    0,  118,
      133,  261,  253,  257,  259,  271,  336,    0,  140,  246,
      239,    0,  145,  148,  166,  168,  252,  253,  237,  179,
      150,    0,    0,    0,  230,  336,  229,  186,  218,  187,
      230,    0,    0,  213,  226,  228,  214,  203,  196,  201,
        0,  336,  161,  188,  189,  190,  151,  191,  133,  199,
      336,  336,  207,  211,  215,  219,  223,  126,  227,  231,

      235,  239,  243,  247,   92,  251,  255,  259,  263,  266
    } ;

static rc_yyconst flex_int16_t rc_yy_def[211] =
    {   0,
      192,    1,  193,  193,  194,  194,  195,  195,  192,  192,
      192,  192,  192,  196,  197,  192,  198,  198,  192,  198,
      198,  198,  198,  198,  198,  198,  198,  198,  198,  198,
      198,  198,  198,  192,  198,  198,  199,  192,  192,  200,
      201,  192,  192,  202,  201,  201,  203,  192,  192,  192,
      196,  192,  204,  197,  192,  198,  198,  205,  198,  198,
      198,  198,  198,  198,  198,  198,  198,  198,  198,  198,
      198,  198,  198,  198,  198,  198,  198,  192,  199,  192,
      200,  192,  192,  201,  201,  192,  202,  201,  206,  207,
      192,  203,  192,  192,  192,  198,  205,  205,  198,  198,

      198,  198,  198,  198,  198,  198,  198,  198,  198,  198,
      198,  198,  198,  198,  198,  192,  201,  201,  201,  207,
      120,  192,  198,  198,  192,  192,  208,  198,  198,  198,
      198,  198,  198,  198,  198,  198,  198,  198,  198,  198,
      209,  192,  192,  198,  198,  208,  192,  198,  198,  198,
      198,  198,  198,  198,  209,  209,  192,  192,  198,  198,
      198,  198,  198,  198,  198,  192,  192,  192,  198,  192,
      198,  198,  198,  192,  192,  198,  198,  192,  192,  210,
      198,  192,  210,  210,  192,  210,  192,  210,  192,  210,
      192,    0,  192,  192,  192,  192,  192,  192,  192,  192,

      192,  192,  192,  192,  192,  192,  192,  192,  192,  192
    } ;

static rc_yyconst flex_int16_t rc_yy_nxt[377] =
    {   0,
       10,   11,   12,   13,   14,   15,   16,   17,   18,   18,
       19,   16,   20,   21,   22,   23,   24,   25,   18,   26,
       27,   18,   28,   29,   30,   18,   31,   32,   33,   18,
       18,   18,   18,   34,   35,   23,   36,   18,   27,   29,
       38,   38,   39,   39,   42,   43,   52,   44,   42,   43,
       59,   44,   61,   45,   63,   68,   80,   45,   60,   66,
       62,   67,   69,   90,   74,   51,   64,   91,   88,   99,
       59,   40,   40,   68,   60,   53,   46,   75,   52,  100,
       46,  102,   69,   80,   74,   81,   85,  105,  109,   99,
      111,  116,  115,   51,  112,   98,   88,   89,   85,  100,

      135,  102,  122,  105,  140,   94,  116,   53,  109,  111,
      115,  132,   81,  118,  123,  125,  126,  124,  135,  127,
      125,  126,   85,  140,  127,   89,  133,  134,  116,   57,
      136,  132,  138,  150,  146,  147,  154,  119,   84,  122,
      191,   84,   84,   84,   84,  120,  133,  134,   84,   84,
      136,  142,  138,  150,  143,  154,  125,  126,  189,   85,
      127,  164,  183,  161,  165,  172,  156,  146,  147,  146,
      166,   85,   84,  125,  126,   84,   84,  141,   84,  161,
      170,  164,   84,   84,  165,  172,  171,  170,  170,  185,
      185,  185,  185,  175,  175,  186,  187,  188,  190,  156,

      185,  156,  183,  182,  180,   85,  190,   37,   37,   37,
       37,   41,   41,   41,   41,   47,   47,   47,   47,   51,
       51,  181,   51,   54,   54,   54,   54,   79,   79,  180,
       79,   82,   82,  179,   82,   84,  178,  177,   84,   87,
       87,  176,   87,   92,   92,   92,   92,   94,   94,  174,
       94,  117,  117,  117,  117,  121,  173,  169,  121,  146,
      146,  146,  146,  155,  155,  155,  155,  184,  168,  184,
      167,  163,  162,  147,  160,  159,  158,  157,  153,  152,
      151,  149,  148,  147,  145,  144,   85,   85,  139,  137,
      131,  130,  129,  128,   93,   85,   86,   85,   83,  114,

      113,  110,  108,  107,  106,  104,  103,  101,   97,   96,
       55,   95,   49,   93,   86,   85,   83,   66,   62,   78,
       77,   76,   73,   72,   71,   70,   65,   58,   56,   55,
       50,   49,  192,   48,   48,    9,  192,  192,  192,  192,
      192,  192,  192,  192,  192,  192,  192,  192,  192,  192,
      192,  192,  192,  192,  192,  192,  192,  192,  192,  192,
      192,  192,  192,  192,  192,  192,  192,  192,  192,  192,
      192,  192,  192,  192,  192,  192
    } ;

static rc_yyconst flex_int16_t rc_yy_chk[377] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        3,    4,    3,    4,    5,    5,   14,    5,    6,    6,
       20,    6,   21,    5,   22,   25,   37,    6,   20,   24,
       21,   24,   26,   45,   31,   44,   22,   46,   44,   59,
       20,    3,    4,   25,   20,   14,    5,   31,   51,   60,
        6,   62,   26,   79,   31,   37,   45,   65,   71,   59,
       74,   85,   77,   87,   74,  205,   87,   44,   46,   60,

      109,   62,   96,   65,  115,   89,   89,   51,   71,   74,
       77,  105,   79,   89,   96,   97,   97,   96,  109,   97,
       98,   98,   85,  115,   98,   87,  106,  108,  119,  198,
      111,  105,  113,  134,  141,  141,  140,   89,   90,  122,
      189,   90,   90,   90,   90,   90,  106,  108,   90,   90,
      111,  122,  113,  134,  122,  140,  125,  125,  187,  119,
      125,  153,  183,  149,  154,  161,  141,  155,  155,  156,
      156,   90,  120,  120,  120,  120,  120,  120,  120,  149,
      160,  153,  120,  120,  154,  161,  160,  168,  170,  184,
      185,  186,  188,  168,  170,  184,  185,  186,  188,  155,

      190,  156,  180,  179,  178,  120,  190,  193,  193,  193,
      193,  194,  194,  194,  194,  195,  195,  195,  195,  196,
      196,  177,  196,  197,  197,  197,  197,  199,  199,  176,
      199,  200,  200,  175,  200,  201,  174,  171,  201,  202,
      202,  169,  202,  203,  203,  203,  203,  204,  204,  167,
      204,  206,  206,  206,  206,  207,  165,  159,  207,  208,
      208,  208,  208,  209,  209,  209,  209,  210,  158,  210,
      157,  151,  150,  146,  145,  144,  143,  142,  137,  136,
      135,  131,  128,  127,  124,  123,  118,  117,  114,  112,
      104,  103,  102,  101,   92,   88,   86,   84,   81,   76,

       75,   72,   69,   67,   66,   64,   63,   61,   58,   56,
       54,   53,   49,   47,   42,   41,   40,   36,   35,   34,
       33,   32,   30,   29,   28,   27,   23,   19,   17,   15,
       13,   11,    9,    8,    7,  192,  192,  192,  192,  192,
      192,  192,  192,  192,  192,  192,  192,  192,  192,  192,
      192,  192,  192,  192,  192,  192,  192,  192,  192,  192,
      192,  192,  192,  192,  192,  192,  192,  192,  192,  192,
      192,  192,  192,  192,  192,  192
    } ;

static rc_yy_state_type rc_yy_last_accepting_state;
static char *rc_yy_last_accepting_cpos;

extern int rc_yy_flex_debug;
int rc_yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define rc_yymore() rc_yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *rc_yytext;
#line 1 "rcfile.l"
#line 2 "rcfile.l"
/*
   rcfile.l

   This file is part of GNU Anubis.
   Copyright (C) 2003, 2004, 2007 The Anubis Team.

   GNU Anubis is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 3 of the License, or (at your
   option) any later version.

   GNU Anubis is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with GNU Anubis.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#include "headers.h"
#include "extern.h"
#include "rcfile.h"
#include "rcfile-gram.h"	

struct string_list
{
  struct string_list *next;
  char *str;
  int length;
};

static int simple_string (void);
static void string_begin (void);
static void string_add (char *, int);
static void string_add_char (int);
static void string_finish (void);
static int escape (int);
char *trimws (char *);
char *trimcpy (void);

static void multiline_begin (void);
static void multiline_add (char *);
static void multiline_finish (void);
static char *multiline_strip_tabs (char *);
static int isemptystr (char *);
 
static char *multiline_delimiter;
static int strip_tabs;
 
static struct string_list *str_head, *str_tail;
int cfg_line_num;
char *cfg_file;

extern int rc_yydebug;
#define DBG(t,s) do {\
 if (rc_yydebug > 1) \
   printf ("LEX %s:%d: %s %s\n", cfg_file, cfg_line_num, t, s);\
 } while (0)
 

#line 665 "lex.rc_yy.c"

#define INITIAL 0
#define STR 1
#define LIT 2
#define ML 3

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int rc_yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int rc_yylex_destroy (void );

int rc_yyget_debug (void );

void rc_yyset_debug (int debug_flag  );

YY_EXTRA_TYPE rc_yyget_extra (void );

void rc_yyset_extra (YY_EXTRA_TYPE user_defined  );

FILE *rc_yyget_in (void );

void rc_yyset_in  (FILE * in_str  );

FILE *rc_yyget_out (void );

void rc_yyset_out  (FILE * out_str  );

int rc_yyget_leng (void );

char *rc_yyget_text (void );

int rc_yyget_lineno (void );

void rc_yyset_lineno (int line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int rc_yywrap (void );
#else
extern int rc_yywrap (void );
#endif
#endif

    static void rc_yyunput (int c,char *buf_ptr  );
    
#ifndef rc_yytext_ptr
static void rc_yy_flex_strncpy (char *,rc_yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int rc_yy_flex_strlen (rc_yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int rc_yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO fwrite( rc_yytext, rc_yyleng, 1, rc_yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->rc_yy_is_interactive ) \
		{ \
		int c = '*'; \
		unsigned n; \
		for ( n = 0; n < max_size && \
			     (c = getc( rc_yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( rc_yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, rc_yyin))==0 && ferror(rc_yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(rc_yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "rc_yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef rc_yyterminate
#define rc_yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) rc_yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int rc_yylex (void);

#define YY_DECL int rc_yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after rc_yytext and rc_yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register rc_yy_state_type rc_yy_current_state;
	register char *rc_yy_cp, *rc_yy_bp;
	register int rc_yy_act;
    
#line 77 "rcfile.l"

         /* End-of-line comments */
#line 853 "lex.rc_yy.c"

	if ( !(rc_yy_init) )
		{
		(rc_yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (rc_yy_start) )
			(rc_yy_start) = 1;	/* first start state */

		if ( ! rc_yyin )
			rc_yyin = stdin;

		if ( ! rc_yyout )
			rc_yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			rc_yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				rc_yy_create_buffer(rc_yyin,YY_BUF_SIZE );
		}

		rc_yy_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		rc_yy_cp = (rc_yy_c_buf_p);

		/* Support of rc_yytext. */
		*rc_yy_cp = (rc_yy_hold_char);

		/* rc_yy_bp points to the position in rc_yy_ch_buf of the start of
		 * the current run.
		 */
		rc_yy_bp = rc_yy_cp;

		rc_yy_current_state = (rc_yy_start);
rc_yy_match:
		do
			{
			register YY_CHAR rc_yy_c = rc_yy_ec[YY_SC_TO_UI(*rc_yy_cp)];
			if ( rc_yy_accept[rc_yy_current_state] )
				{
				(rc_yy_last_accepting_state) = rc_yy_current_state;
				(rc_yy_last_accepting_cpos) = rc_yy_cp;
				}
			while ( rc_yy_chk[rc_yy_base[rc_yy_current_state] + rc_yy_c] != rc_yy_current_state )
				{
				rc_yy_current_state = (int) rc_yy_def[rc_yy_current_state];
				if ( rc_yy_current_state >= 193 )
					rc_yy_c = rc_yy_meta[(unsigned int) rc_yy_c];
				}
			rc_yy_current_state = rc_yy_nxt[rc_yy_base[rc_yy_current_state] + (unsigned int) rc_yy_c];
			++rc_yy_cp;
			}
		while ( rc_yy_base[rc_yy_current_state] != 336 );

rc_yy_find_action:
		rc_yy_act = rc_yy_accept[rc_yy_current_state];
		if ( rc_yy_act == 0 )
			{ /* have to back up */
			rc_yy_cp = (rc_yy_last_accepting_cpos);
			rc_yy_current_state = (rc_yy_last_accepting_state);
			rc_yy_act = rc_yy_accept[rc_yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( rc_yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*rc_yy_cp = (rc_yy_hold_char);
			rc_yy_cp = (rc_yy_last_accepting_cpos);
			rc_yy_current_state = (rc_yy_last_accepting_state);
			goto rc_yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 79 "rcfile.l"
{ cfg_line_num++; return EOL; }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 80 "rcfile.l"
/* end-of-file comment */;
	YY_BREAK
/* Keywords */
case 3:
YY_RULE_SETUP
#line 82 "rcfile.l"
return T_BEGIN;
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 83 "rcfile.l"
{
	char *p = strstr (rc_yytext, "BEGIN") + 5;
	char *q;
	int len;

	for (; *p && isspace (*(u_char*)p); p++)
		;
	for (q = rc_yytext + rc_yyleng - 4; q > p && isspace (*(u_char*)q); q--)
		;
	len = q - p + 1;
	rc_yylval.string = xmalloc (len + 1);
	memcpy (rc_yylval.string, p, len);
	rc_yylval.string[len] = 0;
	DBG ("D_BEGIN", rc_yylval.string);
	return D_BEGIN; }
	YY_BREAK
case 5:
#line 99 "rcfile.l"
case 6:
YY_RULE_SETUP
#line 99 "rcfile.l"
return T_END;
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 100 "rcfile.l"
return AND;
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 101 "rcfile.l"
return OR;
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 102 "rcfile.l"
return NOT;
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 103 "rcfile.l"
{ rc_yylval.num = HEADER; return T_MSGPART; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 104 "rcfile.l"
{ rc_yylval.num = COMMAND; return T_MSGPART; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 105 "rcfile.l"
{ rc_yylval.num = BODY; return T_MSGPART; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 106 "rcfile.l"
return STOP;
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 107 "rcfile.l"
return CALL;
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 108 "rcfile.l"
return IF;
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 109 "rcfile.l"
return FI;
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 110 "rcfile.l"
return ELSE;
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 111 "rcfile.l"
return RULE;
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 112 "rcfile.l"
return RULE;
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 113 "rcfile.l"
return DONE;
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 114 "rcfile.l"
return ADD;
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 115 "rcfile.l"
return REMOVE;
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 116 "rcfile.l"
return MODIFY;
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 117 "rcfile.l"
return REGEX;
	YY_BREAK
/* Identifiers */
case 25:
YY_RULE_SETUP
#line 120 "rcfile.l"
{ rc_yylval.string = strdup (rc_yytext);
                   DBG ("IDENT", rc_yytext);
		   return IDENT; }
	YY_BREAK
/* Quoted strings */
case 26:
YY_RULE_SETUP
#line 124 "rcfile.l"
{ return simple_string (); }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 125 "rcfile.l"
{BEGIN (STR);
                   string_begin ();
		   string_add (rc_yytext+1, rc_yyleng-1);
                  }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 129 "rcfile.l"
{ BEGIN (STR);
                   string_begin ();
		   string_add (rc_yytext+1, rc_yyleng-3);
		   string_add_char (escape (rc_yytext[rc_yyleng-1])); }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 133 "rcfile.l"
{ string_add (rc_yytext, rc_yyleng); }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 134 "rcfile.l"
{ string_add (rc_yytext, rc_yyleng-2);
                    string_add_char (escape (rc_yytext[rc_yyleng-1])); }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 136 "rcfile.l"
{ BEGIN (INITIAL);
                   string_add (rc_yytext, rc_yyleng-1); 
                   string_finish ();
		   return STRING; }
	YY_BREAK
/* "Here document" (multiline strings) */
case 32:
/* rule 32 can match eol */
#line 142 "rcfile.l"
case 33:
/* rule 33 can match eol */
YY_RULE_SETUP
#line 142 "rcfile.l"
{ BEGIN (ML);
                                        multiline_begin ();
	                         	cfg_line_num++; }
	YY_BREAK
case 34:
/* rule 34 can match eol */
YY_RULE_SETUP
#line 145 "rcfile.l"
{ char *p = multiline_strip_tabs (rc_yytext);
           cfg_line_num++;
	   
           if (strncmp (p, multiline_delimiter, strlen (multiline_delimiter))
	        == 0
	       && isemptystr (p + strlen (multiline_delimiter))) {
		   BEGIN (INITIAL);
		   multiline_finish ();
		   unput ('\n');
		   DBG ("<ML>STRING", rc_yylval.string);
		   return STRING;
	     }
	    multiline_add (p);
         } 
	YY_BREAK
/* Literal */
case 35:
/* rule 35 can match eol */
YY_RULE_SETUP
#line 160 "rcfile.l"
{ cfg_line_num++; }
	YY_BREAK
case 36:
/* rule 36 can match eol */
YY_RULE_SETUP
#line 161 "rcfile.l"
{ rc_yylval.string = malloc (rc_yyleng-1);
                       memcpy (rc_yylval.string, rc_yytext, rc_yyleng-2);
		       rc_yylval.string[rc_yyleng-2] = 0;
		       DBG ("<LIT>STRING", rc_yylval.string);
		       cfg_line_num++;
		       return STRING; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 167 "rcfile.l"
{ rc_yylval.string = trimcpy ();
		   DBG ("<LIT>STRING", rc_yylval.string);
		   return STRING; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 170 "rcfile.l"
;
	YY_BREAK
case 39:
/* rule 39 can match eol */
YY_RULE_SETUP
#line 171 "rcfile.l"
{ BEGIN (INITIAL); cfg_line_num++; return EOL; }
	YY_BREAK
/* Other tokens */
case 40:
YY_RULE_SETUP
#line 173 "rcfile.l"
;
	YY_BREAK
case 41:
/* rule 41 can match eol */
YY_RULE_SETUP
#line 174 "rcfile.l"
{ cfg_line_num++; }
	YY_BREAK
case 42:
/* rule 42 can match eol */
YY_RULE_SETUP
#line 175 "rcfile.l"
{ cfg_line_num++; return EOL; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 176 "rcfile.l"
return rc_yytext[0];
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 177 "rcfile.l"
return NE;
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 178 "rcfile.l"
{ parse_error (_("Stray character in config: \\%03o. Possibly missing quotes around the string"), rc_yytext[0]); }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 180 "rcfile.l"
ECHO;
	YY_BREAK
#line 1223 "lex.rc_yy.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(STR):
case YY_STATE_EOF(LIT):
case YY_STATE_EOF(ML):
	rc_yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int rc_yy_amount_of_matched_text = (int) (rc_yy_cp - (rc_yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*rc_yy_cp = (rc_yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->rc_yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed rc_yyin at a new source and called
			 * rc_yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(rc_yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->rc_yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->rc_yy_input_file = rc_yyin;
			YY_CURRENT_BUFFER_LVALUE->rc_yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for rc_yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since rc_yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (rc_yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->rc_yy_ch_buf[(rc_yy_n_chars)] )
			{ /* This was really a NUL. */
			rc_yy_state_type rc_yy_next_state;

			(rc_yy_c_buf_p) = (rc_yytext_ptr) + rc_yy_amount_of_matched_text;

			rc_yy_current_state = rc_yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * rc_yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			rc_yy_next_state = rc_yy_try_NUL_trans( rc_yy_current_state );

			rc_yy_bp = (rc_yytext_ptr) + YY_MORE_ADJ;

			if ( rc_yy_next_state )
				{
				/* Consume the NUL. */
				rc_yy_cp = ++(rc_yy_c_buf_p);
				rc_yy_current_state = rc_yy_next_state;
				goto rc_yy_match;
				}

			else
				{
				rc_yy_cp = (rc_yy_c_buf_p);
				goto rc_yy_find_action;
				}
			}

		else switch ( rc_yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(rc_yy_did_buffer_switch_on_eof) = 0;

				if ( rc_yywrap( ) )
					{
					/* Note: because we've taken care in
					 * rc_yy_get_next_buffer() to have set up
					 * rc_yytext, we can now set up
					 * rc_yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(rc_yy_c_buf_p) = (rc_yytext_ptr) + YY_MORE_ADJ;

					rc_yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (rc_yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(rc_yy_c_buf_p) =
					(rc_yytext_ptr) + rc_yy_amount_of_matched_text;

				rc_yy_current_state = rc_yy_get_previous_state(  );

				rc_yy_cp = (rc_yy_c_buf_p);
				rc_yy_bp = (rc_yytext_ptr) + YY_MORE_ADJ;
				goto rc_yy_match;

			case EOB_ACT_LAST_MATCH:
				(rc_yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->rc_yy_ch_buf[(rc_yy_n_chars)];

				rc_yy_current_state = rc_yy_get_previous_state(  );

				rc_yy_cp = (rc_yy_c_buf_p);
				rc_yy_bp = (rc_yytext_ptr) + YY_MORE_ADJ;
				goto rc_yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of rc_yylex */

/* rc_yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int rc_yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->rc_yy_ch_buf;
	register char *source = (rc_yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (rc_yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->rc_yy_ch_buf[(rc_yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->rc_yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (rc_yy_c_buf_p) - (rc_yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((rc_yy_c_buf_p) - (rc_yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->rc_yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->rc_yy_n_chars = (rc_yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->rc_yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int rc_yy_c_buf_p_offset =
				(int) ((rc_yy_c_buf_p) - b->rc_yy_ch_buf);

			if ( b->rc_yy_is_our_buffer )
				{
				int new_size = b->rc_yy_buf_size * 2;

				if ( new_size <= 0 )
					b->rc_yy_buf_size += b->rc_yy_buf_size / 8;
				else
					b->rc_yy_buf_size *= 2;

				b->rc_yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					rc_yyrealloc((void *) b->rc_yy_ch_buf,b->rc_yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->rc_yy_ch_buf = 0;

			if ( ! b->rc_yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(rc_yy_c_buf_p) = &b->rc_yy_ch_buf[rc_yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->rc_yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->rc_yy_ch_buf[number_to_move]),
			(rc_yy_n_chars), (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->rc_yy_n_chars = (rc_yy_n_chars);
		}

	if ( (rc_yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			rc_yyrestart(rc_yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->rc_yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((rc_yy_size_t) ((rc_yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->rc_yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		rc_yy_size_t new_size = (rc_yy_n_chars) + number_to_move + ((rc_yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->rc_yy_ch_buf = (char *) rc_yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->rc_yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->rc_yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in rc_yy_get_next_buffer()" );
	}

	(rc_yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->rc_yy_ch_buf[(rc_yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->rc_yy_ch_buf[(rc_yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(rc_yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->rc_yy_ch_buf[0];

	return ret_val;
}

/* rc_yy_get_previous_state - get the state just before the EOB char was reached */

    static rc_yy_state_type rc_yy_get_previous_state (void)
{
	register rc_yy_state_type rc_yy_current_state;
	register char *rc_yy_cp;
    
	rc_yy_current_state = (rc_yy_start);

	for ( rc_yy_cp = (rc_yytext_ptr) + YY_MORE_ADJ; rc_yy_cp < (rc_yy_c_buf_p); ++rc_yy_cp )
		{
		register YY_CHAR rc_yy_c = (*rc_yy_cp ? rc_yy_ec[YY_SC_TO_UI(*rc_yy_cp)] : 1);
		if ( rc_yy_accept[rc_yy_current_state] )
			{
			(rc_yy_last_accepting_state) = rc_yy_current_state;
			(rc_yy_last_accepting_cpos) = rc_yy_cp;
			}
		while ( rc_yy_chk[rc_yy_base[rc_yy_current_state] + rc_yy_c] != rc_yy_current_state )
			{
			rc_yy_current_state = (int) rc_yy_def[rc_yy_current_state];
			if ( rc_yy_current_state >= 193 )
				rc_yy_c = rc_yy_meta[(unsigned int) rc_yy_c];
			}
		rc_yy_current_state = rc_yy_nxt[rc_yy_base[rc_yy_current_state] + (unsigned int) rc_yy_c];
		}

	return rc_yy_current_state;
}

/* rc_yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = rc_yy_try_NUL_trans( current_state );
 */
    static rc_yy_state_type rc_yy_try_NUL_trans  (rc_yy_state_type rc_yy_current_state )
{
	register int rc_yy_is_jam;
    	register char *rc_yy_cp = (rc_yy_c_buf_p);

	register YY_CHAR rc_yy_c = 1;
	if ( rc_yy_accept[rc_yy_current_state] )
		{
		(rc_yy_last_accepting_state) = rc_yy_current_state;
		(rc_yy_last_accepting_cpos) = rc_yy_cp;
		}
	while ( rc_yy_chk[rc_yy_base[rc_yy_current_state] + rc_yy_c] != rc_yy_current_state )
		{
		rc_yy_current_state = (int) rc_yy_def[rc_yy_current_state];
		if ( rc_yy_current_state >= 193 )
			rc_yy_c = rc_yy_meta[(unsigned int) rc_yy_c];
		}
	rc_yy_current_state = rc_yy_nxt[rc_yy_base[rc_yy_current_state] + (unsigned int) rc_yy_c];
	rc_yy_is_jam = (rc_yy_current_state == 192);

	return rc_yy_is_jam ? 0 : rc_yy_current_state;
}

    static void rc_yyunput (int c, register char * rc_yy_bp )
{
	register char *rc_yy_cp;
    
    rc_yy_cp = (rc_yy_c_buf_p);

	/* undo effects of setting up rc_yytext */
	*rc_yy_cp = (rc_yy_hold_char);

	if ( rc_yy_cp < YY_CURRENT_BUFFER_LVALUE->rc_yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = (rc_yy_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->rc_yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->rc_yy_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->rc_yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->rc_yy_ch_buf )
			*--dest = *--source;

		rc_yy_cp += (int) (dest - source);
		rc_yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->rc_yy_n_chars =
			(rc_yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->rc_yy_buf_size;

		if ( rc_yy_cp < YY_CURRENT_BUFFER_LVALUE->rc_yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--rc_yy_cp = (char) c;

	(rc_yytext_ptr) = rc_yy_bp;
	(rc_yy_hold_char) = *rc_yy_cp;
	(rc_yy_c_buf_p) = rc_yy_cp;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int rc_yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(rc_yy_c_buf_p) = (rc_yy_hold_char);

	if ( *(rc_yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* rc_yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (rc_yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->rc_yy_ch_buf[(rc_yy_n_chars)] )
			/* This was really a NUL. */
			*(rc_yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (rc_yy_c_buf_p) - (rc_yytext_ptr);
			++(rc_yy_c_buf_p);

			switch ( rc_yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because rc_yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					rc_yyrestart(rc_yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( rc_yywrap( ) )
						return EOF;

					if ( ! (rc_yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return rc_yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(rc_yy_c_buf_p) = (rc_yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (rc_yy_c_buf_p);	/* cast for 8-bit char's */
	*(rc_yy_c_buf_p) = '\0';	/* preserve rc_yytext */
	(rc_yy_hold_char) = *++(rc_yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void rc_yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        rc_yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            rc_yy_create_buffer(rc_yyin,YY_BUF_SIZE );
	}

	rc_yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	rc_yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void rc_yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		rc_yypop_buffer_state();
	 *		rc_yypush_buffer_state(new_buffer);
     */
	rc_yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(rc_yy_c_buf_p) = (rc_yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->rc_yy_buf_pos = (rc_yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->rc_yy_n_chars = (rc_yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	rc_yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (rc_yywrap()) processing, but the only time this flag
	 * is looked at is after rc_yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(rc_yy_did_buffer_switch_on_eof) = 1;
}

static void rc_yy_load_buffer_state  (void)
{
    	(rc_yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->rc_yy_n_chars;
	(rc_yytext_ptr) = (rc_yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->rc_yy_buf_pos;
	rc_yyin = YY_CURRENT_BUFFER_LVALUE->rc_yy_input_file;
	(rc_yy_hold_char) = *(rc_yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE rc_yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) rc_yyalloc(sizeof( struct rc_yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in rc_yy_create_buffer()" );

	b->rc_yy_buf_size = size;

	/* rc_yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->rc_yy_ch_buf = (char *) rc_yyalloc(b->rc_yy_buf_size + 2  );
	if ( ! b->rc_yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in rc_yy_create_buffer()" );

	b->rc_yy_is_our_buffer = 1;

	rc_yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with rc_yy_create_buffer()
 * 
 */
    void rc_yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->rc_yy_is_our_buffer )
		rc_yyfree((void *) b->rc_yy_ch_buf  );

	rc_yyfree((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a rc_yyrestart() or at EOF.
 */
    static void rc_yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	rc_yy_flush_buffer(b );

	b->rc_yy_input_file = file;
	b->rc_yy_fill_buffer = 1;

    /* If b is the current buffer, then rc_yy_init_buffer was _probably_
     * called from rc_yyrestart() or through rc_yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->rc_yy_bs_lineno = 1;
        b->rc_yy_bs_column = 0;
    }

        b->rc_yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void rc_yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->rc_yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->rc_yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->rc_yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->rc_yy_buf_pos = &b->rc_yy_ch_buf[0];

	b->rc_yy_at_bol = 1;
	b->rc_yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		rc_yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void rc_yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	rc_yyensure_buffer_stack();

	/* This block is copied from rc_yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(rc_yy_c_buf_p) = (rc_yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->rc_yy_buf_pos = (rc_yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->rc_yy_n_chars = (rc_yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(rc_yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from rc_yy_switch_to_buffer. */
	rc_yy_load_buffer_state( );
	(rc_yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void rc_yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	rc_yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((rc_yy_buffer_stack_top) > 0)
		--(rc_yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		rc_yy_load_buffer_state( );
		(rc_yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void rc_yyensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(rc_yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(rc_yy_buffer_stack) = (struct rc_yy_buffer_state**)rc_yyalloc
								(num_to_alloc * sizeof(struct rc_yy_buffer_state*)
								);
		if ( ! (rc_yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in rc_yyensure_buffer_stack()" );
								  
		memset((rc_yy_buffer_stack), 0, num_to_alloc * sizeof(struct rc_yy_buffer_state*));
				
		(rc_yy_buffer_stack_max) = num_to_alloc;
		(rc_yy_buffer_stack_top) = 0;
		return;
	}

	if ((rc_yy_buffer_stack_top) >= ((rc_yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (rc_yy_buffer_stack_max) + grow_size;
		(rc_yy_buffer_stack) = (struct rc_yy_buffer_state**)rc_yyrealloc
								((rc_yy_buffer_stack),
								num_to_alloc * sizeof(struct rc_yy_buffer_state*)
								);
		if ( ! (rc_yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in rc_yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((rc_yy_buffer_stack) + (rc_yy_buffer_stack_max), 0, grow_size * sizeof(struct rc_yy_buffer_state*));
		(rc_yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE rc_yy_scan_buffer  (char * base, rc_yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) rc_yyalloc(sizeof( struct rc_yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in rc_yy_scan_buffer()" );

	b->rc_yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->rc_yy_buf_pos = b->rc_yy_ch_buf = base;
	b->rc_yy_is_our_buffer = 0;
	b->rc_yy_input_file = 0;
	b->rc_yy_n_chars = b->rc_yy_buf_size;
	b->rc_yy_is_interactive = 0;
	b->rc_yy_at_bol = 1;
	b->rc_yy_fill_buffer = 0;
	b->rc_yy_buffer_status = YY_BUFFER_NEW;

	rc_yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to rc_yylex() will
 * scan from a @e copy of @a str.
 * @param rc_yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       rc_yy_scan_bytes() instead.
 */
YY_BUFFER_STATE rc_yy_scan_string (rc_yyconst char * rc_yystr )
{
    
	return rc_yy_scan_bytes(rc_yystr,strlen(rc_yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to rc_yylex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE rc_yy_scan_bytes  (rc_yyconst char * rc_yybytes, int  _rc_yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	rc_yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _rc_yybytes_len + 2;
	buf = (char *) rc_yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in rc_yy_scan_bytes()" );

	for ( i = 0; i < _rc_yybytes_len; ++i )
		buf[i] = rc_yybytes[i];

	buf[_rc_yybytes_len] = buf[_rc_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = rc_yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in rc_yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->rc_yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void rc_yy_fatal_error (rc_yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine rc_yyless() so it works in section 3 code. */

#undef rc_yyless
#define rc_yyless(n) \
	do \
		{ \
		/* Undo effects of setting up rc_yytext. */ \
        int rc_yyless_macro_arg = (n); \
        YY_LESS_LINENO(rc_yyless_macro_arg);\
		rc_yytext[rc_yyleng] = (rc_yy_hold_char); \
		(rc_yy_c_buf_p) = rc_yytext + rc_yyless_macro_arg; \
		(rc_yy_hold_char) = *(rc_yy_c_buf_p); \
		*(rc_yy_c_buf_p) = '\0'; \
		rc_yyleng = rc_yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int rc_yyget_lineno  (void)
{
        
    return rc_yylineno;
}

/** Get the input stream.
 * 
 */
FILE *rc_yyget_in  (void)
{
        return rc_yyin;
}

/** Get the output stream.
 * 
 */
FILE *rc_yyget_out  (void)
{
        return rc_yyout;
}

/** Get the length of the current token.
 * 
 */
int rc_yyget_leng  (void)
{
        return rc_yyleng;
}

/** Get the current token.
 * 
 */

char *rc_yyget_text  (void)
{
        return rc_yytext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void rc_yyset_lineno (int  line_number )
{
    
    rc_yylineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see rc_yy_switch_to_buffer
 */
void rc_yyset_in (FILE *  in_str )
{
        rc_yyin = in_str ;
}

void rc_yyset_out (FILE *  out_str )
{
        rc_yyout = out_str ;
}

int rc_yyget_debug  (void)
{
        return rc_yy_flex_debug;
}

void rc_yyset_debug (int  bdebug )
{
        rc_yy_flex_debug = bdebug ;
}

static int rc_yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from rc_yylex_destroy(), so don't allocate here.
     */

    (rc_yy_buffer_stack) = 0;
    (rc_yy_buffer_stack_top) = 0;
    (rc_yy_buffer_stack_max) = 0;
    (rc_yy_c_buf_p) = (char *) 0;
    (rc_yy_init) = 0;
    (rc_yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    rc_yyin = stdin;
    rc_yyout = stdout;
#else
    rc_yyin = (FILE *) 0;
    rc_yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * rc_yylex_init()
     */
    return 0;
}

/* rc_yylex_destroy is for both reentrant and non-reentrant scanners. */
int rc_yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		rc_yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		rc_yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	rc_yyfree((rc_yy_buffer_stack) );
	(rc_yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * rc_yylex() is called, initialization will occur. */
    rc_yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef rc_yytext_ptr
static void rc_yy_flex_strncpy (char* s1, rc_yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int rc_yy_flex_strlen (rc_yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *rc_yyalloc (rc_yy_size_t  size )
{
	return (void *) malloc( size );
}

void *rc_yyrealloc  (void * ptr, rc_yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void rc_yyfree (void * ptr )
{
	free( (char *) ptr );	/* see rc_yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "rc_yytables"

#line 180 "rcfile.l"



int
rc_yywrap ()
{
  if (rc_yyin)
    {
      fclose (rc_yyin);
      rc_yyin = NULL;
    }
  return 1;
}

void
verbatim (void)
{
  BEGIN (LIT);
}

void
lex_clear_state (void)
{
  BEGIN (INITIAL);
}

int
simple_string (void)
{
  rc_yylval.string = xmalloc (rc_yyleng - 1);
  memcpy (rc_yylval.string, rc_yytext + 1, rc_yyleng - 2);
  rc_yylval.string[rc_yyleng - 2] = 0;
  DBG ("STRING", rc_yylval.string); 
  return STRING;
}

void
string_begin (void)
{
  str_head = str_tail = NULL;
}

void
string_add (char *str, int len)
{
  struct string_list *s = xmalloc (sizeof (*s) + len);
  s->next = NULL;
  s->str = (char*)(s+1);
  memcpy (s->str, str, len);
  s->length = len;
  if (str_tail)
    str_tail->next = s;
  else
    str_head = s;
  str_tail = s;
}

void
string_add_char (int n)
{
  char c = n;
  string_add (&c, 1);
}

void
string_finish (void)
{
  struct string_list *s;
  int len = 0;
  char *p;
	
  for (s = str_head; s; s = s->next) 
    len += s->length;
  len++;
  rc_yylval.string = xmalloc (len);
  for (p = rc_yylval.string, s = str_head; s; )
    {
      struct string_list *next = s->next;
      memcpy (p, s->str, s->length);
      p += s->length;
      xfree (s);
      s = next;
    }
  *p = 0;
}

void
multiline_begin (void)
{
  char *endp;
  int len;
  char *p = rc_yytext + 2; /* past the << marker */

  if (*p == '-')
    {
      strip_tabs = 1;
      p++;
    }
  else
    strip_tabs = 0;

  /* Find the delimiter */
  for (endp = p; *endp; endp++)
    if (isspace (*(u_char*)endp))
      break;

  len = endp - p;
  multiline_delimiter = xmalloc (len + 1);
  memcpy (multiline_delimiter, p, len);
  multiline_delimiter[len] = 0;
  string_begin ();
}

void
multiline_finish (void)
{
  free (multiline_delimiter);
  multiline_delimiter = NULL;
  string_finish ();
}

int
isemptystr (char *text)
{
  for (; *text && isspace (*(u_char*)text); text++)
    ;
  return *text == 0;
}

char *
multiline_strip_tabs (char *text)
{
  if (strip_tabs)
    for (; *text == '\t'; text++)
      ;
  return text;
}

void
multiline_add (char *p)
{
  string_add (p, strlen (p));
}

int
escape (int c)
{
  switch (c) {
  case 'a':
    return '\a';
  case 'b':
    return '\b';
  case 'f':
    return '\f';
  case 'e':
    return '\e';
  case 'n':
    return '\n';
  case 'r':
    return '\t';
  case 't':
    return '\t';
  case 'v':
    return '\v';
  default:
    break;
  }
  return c;
}

char *
trimws (char *s)
{
  int len;

  for (len = strlen (s) - 1; len > 0 && isspace ((u_char)s[len]); len--)
    ;
  if (len > 0)
    s[len+1] = 0;
  return s;
}

char *
trimcpy (void)
{
  char *string;
  int i, j, len;

  for (i = 0; i < rc_yyleng && isspace ((u_char)rc_yytext[i]); i++)
    ;
  for (j = rc_yyleng - 1; j > i && isspace ((u_char)rc_yytext[i]); j--)
    ;
  len = j - i + 1;
  string = xmalloc (len + 1);
  memcpy (string, rc_yytext + i, len);
  string[len] = 0;
  return string;
}

int
rc_open (char *name)
{
  rc_yyin = fopen (name, "r");
  if (!rc_yyin)
    {
      if (options.termlevel == DEBUG)
	anubis_error (0, errno, _("Anubis RC file error"));
      return -1;
    }
  
  cfg_file = name;
  cfg_line_num = 1;
  return 0;
}

int
error_sync_begin ()
{
  int c;
  
  while (rc_yyin && (c = rc_yylex ()) > 0)
    {
      if (c == T_BEGIN)
	{
	  rc_yyless (0);
	  break;
	}
      else if (c == D_BEGIN)
	{
	  xfree (rc_yylval.string);
	  rc_yyless (0);
	  break;
	}
    }
  return c;
}


