#!/usr/bin/perl
# A perl program to compute the average from the frequencies generated by summation.pl amongst 
# multiple files for each position.
# @author Jason Myers
use strict;

# Print an error message unless the a frequency file is specified
my $numArgs = $#ARGV + 1;

unless( $numArgs == 1){
    print "Usage: perl combinedAvg.pl FreqFile\n";
    exit;
}

# Open the input file
my $infile = $ARGV[0];

open INFILE, "$infile", or die $!;

# deal with the header line
my $header = <INFILE>;

# An array to hold the average scores
my @AVG_SCORE = ();

# An array to temporarily hold the elements of a given line
my @TEMP = ();

# The variable that temporarily holds each line as a string
my $line = '';

# the number of all possible quality scores
my $numScores = 71;

# An array holding all of the possible quality scores
my @ALL_SCORES = ();

# Fill the possible quality scores array
for(my $i = 0; $i < $numScores; $i++){
	$ALL_SCORES[$i] = $i;
}

# a count variable to keep track of the line number being deal with
my $count = 0;

# Loop over the files contents
while(<INFILE>){
		
	# capture the line as a string
	$line = $_;

	# Store the elements of the line in the temp array
	@TEMP = split('\t', $line);

	# Loop over the elements of the line
	foreach my $pos(0 .. $#TEMP){
		# Aggregate the products of the frequency and quality score
		$AVG_SCORE[0][$pos] += ($TEMP[$pos] * $ALL_SCORES[$count]);
		# Sum all of the frequencies		
		$AVG_SCORE[1][$pos] += $TEMP[$pos];
	}
	
	# Increase the line number counter
	$count++;

}

# close the infile
close(INFILE);

# open the output file
my $outfile = $infile;

# by appending
open OUTFILE, ">>$outfile", or die $!;

# Write out the numerators
foreach my $pos1(0 .. ($#TEMP - 1)){
	print OUTFILE $AVG_SCORE[0][$pos1], "\t";
}

print OUTFILE "\n";

# Write out the denominators
foreach my $pos2(0 .. ($#TEMP - 1)){
	print OUTFILE $AVG_SCORE[1][$pos2], "\t";
}

print OUTFILE "\n";

# Write out the average quality score for each position
foreach my $pos3(0 .. ($#TEMP - 1)){
	
	# If the numerator or the denominator is 0, avg quality is 0
	if(($AVG_SCORE[0][$pos3] == 0) || ($AVG_SCORE[1][$pos3] == 0)){
		print OUTFILE 0, "\t";
	} else {
		# If not, calculate the average quality score and write it
		print OUTFILE ($AVG_SCORE[0][$pos3] / $AVG_SCORE[1][$pos3]), "\t";
	}
}

print OUTFILE "\n";

# close the output file
close(OUTFILE);

# end the program
exit;
