/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 13:34:47 GMT 2018
 */

package uk.ac.sanger.artemis.components.alignment;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.ReferenceSequence;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.components.alignment.BamView;
import uk.ac.sanger.artemis.components.alignment.CRAMReferenceSequenceFile;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class CRAMReferenceSequenceFile_ESTest extends CRAMReferenceSequenceFile_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      doReturn(4237).when(bases0).getLength();
      Bases bases1 = mock(Bases.class, new ViolatedAssumptionAnswer());
      doReturn("@").when(bases1).getSubSequence(any(uk.ac.sanger.artemis.io.Range.class) , anyInt());
      Entry entry0 = mock(Entry.class, new ViolatedAssumptionAnswer());
      doReturn(bases0, bases1, (Bases) null).when(entry0).getBases();
      doReturn((uk.ac.sanger.artemis.io.Entry) null, (uk.ac.sanger.artemis.io.Entry) null, (uk.ac.sanger.artemis.io.Entry) null).when(entry0).getEMBLEntry();
      doReturn("!NUTW)$", (String) null).when(entry0).getName();
      BamView bamView0 = mock(BamView.class, new ViolatedAssumptionAnswer());
      doReturn(2823, 0).when(bamView0).getSequenceOffset(anyString());
      CRAMReferenceSequenceFile cRAMReferenceSequenceFile0 = new CRAMReferenceSequenceFile(entry0, bamView0);
      cRAMReferenceSequenceFile0.getSequence(")qZ5A0EYa-n");
      // Undeclared exception!
      try { 
        cRAMReferenceSequenceFile0.getSubsequenceAt(")qZ5A0EYa-n", 5, 4237);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.CRAMReferenceSequenceFile", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      doReturn(30).when(bases0).getLength();
      uk.ac.sanger.artemis.io.Entry entry0 = mock(uk.ac.sanger.artemis.io.Entry.class, new ViolatedAssumptionAnswer());
      doReturn((Sequence) null).when(entry0).getSequence();
      Bases bases1 = mock(Bases.class, new ViolatedAssumptionAnswer());
      doReturn("").when(bases1).getSubSequence(any(uk.ac.sanger.artemis.io.Range.class) , anyInt());
      uk.ac.sanger.artemis.io.Entry entry1 = mock(uk.ac.sanger.artemis.io.Entry.class, new ViolatedAssumptionAnswer());
      doReturn((Sequence) null).when(entry1).getSequence();
      Entry entry2 = mock(Entry.class, new ViolatedAssumptionAnswer());
      doReturn(bases0, bases1).when(entry2).getBases();
      doReturn(entry0, entry1).when(entry2).getEMBLEntry();
      doReturn("user.dir").when(entry2).getName();
      BamView bamView0 = mock(BamView.class, new ViolatedAssumptionAnswer());
      doReturn(2084).when(bamView0).getSequenceOffset(anyString());
      CRAMReferenceSequenceFile cRAMReferenceSequenceFile0 = new CRAMReferenceSequenceFile(entry2, bamView0);
      ReferenceSequence referenceSequence0 = cRAMReferenceSequenceFile0.getSequence(".*.(bam|cram)$");
      assertNotNull(referenceSequence0);
      assertEquals(0, referenceSequence0.getContigIndex());
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      Entry entry0 = mock(Entry.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(entry0).getBases();
      doReturn((uk.ac.sanger.artemis.io.Entry) null).when(entry0).getEMBLEntry();
      BamView bamView0 = mock(BamView.class, new ViolatedAssumptionAnswer());
      CRAMReferenceSequenceFile cRAMReferenceSequenceFile0 = new CRAMReferenceSequenceFile(entry0, bamView0);
      // Undeclared exception!
      try { 
        cRAMReferenceSequenceFile0.getSequence("");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.CRAMReferenceSequenceFile", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      Sequence sequence0 = mock(Sequence.class, new ViolatedAssumptionAnswer());
      uk.ac.sanger.artemis.io.Entry entry0 = mock(uk.ac.sanger.artemis.io.Entry.class, new ViolatedAssumptionAnswer());
      doReturn(sequence0, sequence0).when(entry0).getSequence();
      Entry entry1 = mock(Entry.class, new ViolatedAssumptionAnswer());
      doReturn(bases0, (Bases) null).when(entry1).getBases();
      doReturn(entry0, entry0, (uk.ac.sanger.artemis.io.Entry) null).when(entry1).getEMBLEntry();
      doReturn((String) null, (String) null).when(entry1).getName();
      BamView bamView0 = mock(BamView.class, new ViolatedAssumptionAnswer());
      doReturn(216, 0).when(bamView0).getSequenceOffset(anyString());
      CRAMReferenceSequenceFile cRAMReferenceSequenceFile0 = new CRAMReferenceSequenceFile(entry1, bamView0);
      cRAMReferenceSequenceFile0.isReferenceIndexed();
      cRAMReferenceSequenceFile0.getSubsequenceAt((String) null, 2183L, 0);
      // Undeclared exception!
      try { 
        cRAMReferenceSequenceFile0.getSubsequenceAt("", 0L, 0L);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.CRAMReferenceSequenceFile", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      Entry entry0 = mock(Entry.class, new ViolatedAssumptionAnswer());
      BamView bamView0 = mock(BamView.class, new ViolatedAssumptionAnswer());
      CRAMReferenceSequenceFile cRAMReferenceSequenceFile0 = new CRAMReferenceSequenceFile(entry0, bamView0);
      boolean boolean0 = cRAMReferenceSequenceFile0.isIndexed();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      Entry entry0 = mock(Entry.class, new ViolatedAssumptionAnswer());
      BamView bamView0 = mock(BamView.class, new ViolatedAssumptionAnswer());
      CRAMReferenceSequenceFile cRAMReferenceSequenceFile0 = new CRAMReferenceSequenceFile(entry0, bamView0);
      SAMSequenceDictionary sAMSequenceDictionary0 = cRAMReferenceSequenceFile0.getSequenceDictionary();
      assertNull(sAMSequenceDictionary0);
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      Entry entry0 = mock(Entry.class, new ViolatedAssumptionAnswer());
      BamView bamView0 = mock(BamView.class, new ViolatedAssumptionAnswer());
      CRAMReferenceSequenceFile cRAMReferenceSequenceFile0 = new CRAMReferenceSequenceFile(entry0, bamView0);
      ReferenceSequence referenceSequence0 = cRAMReferenceSequenceFile0.nextSequence();
      assertNull(referenceSequence0);
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      Entry entry0 = mock(Entry.class, new ViolatedAssumptionAnswer());
      BamView bamView0 = mock(BamView.class, new ViolatedAssumptionAnswer());
      CRAMReferenceSequenceFile cRAMReferenceSequenceFile0 = new CRAMReferenceSequenceFile(entry0, bamView0);
      cRAMReferenceSequenceFile0.close();
      assertTrue(cRAMReferenceSequenceFile0.isIndexed());
  }
}
