/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 21:34:06 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.GFF3AttributeAggregator;
import uk.ac.sanger.artemis.io.GFF3AttributeBuilder;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class GFF3AttributeBuilder_ESTest extends GFF3AttributeBuilder_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFF3AttributeBuilder0.setGlue("5D8z[^R>ZB", "rzjx^;i7}5");
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      StringVector stringVector0 = new StringVector();
      assertNotNull(stringVector0);
      assertTrue(stringVector0.isEmpty());
      assertEquals("[]", stringVector0.toString());
      assertEquals(10, stringVector0.capacity());
      assertEquals(0, stringVector0.size());
      
      StringVector stringVector1 = StringVector.getStrings("y", "hK.?RE#ZlQ7c");
      assertNotSame(stringVector1, stringVector0);
      assertNotNull(stringVector1);
      assertFalse(stringVector1.isEmpty());
      assertEquals(10, stringVector1.capacity());
      assertEquals("[y]", stringVector1.toString());
      assertEquals(1, stringVector1.size());
      assertFalse(stringVector1.equals((Object)stringVector0));
      
      stringVector0.add(stringVector1);
      assertNotSame(stringVector0, stringVector1);
      assertNotSame(stringVector1, stringVector0);
      assertEquals(10, stringVector0.capacity());
      assertEquals("[y]", stringVector0.toString());
      assertFalse(stringVector0.isEmpty());
      assertEquals(1, stringVector0.size());
      assertFalse(stringVector1.isEmpty());
      assertEquals(10, stringVector1.capacity());
      assertEquals("[y]", stringVector1.toString());
      assertEquals(1, stringVector1.size());
      assertTrue(stringVector0.equals((Object)stringVector1));
      assertTrue(stringVector1.equals((Object)stringVector0));
      
      gFF3AttributeBuilder0.add(" but this VariantContext contains an END key with value ", stringVector0);
      assertNotSame(stringVector0, stringVector1);
      assertEquals(10, stringVector0.capacity());
      assertEquals("[y]", stringVector0.toString());
      assertFalse(stringVector0.isEmpty());
      assertEquals(1, stringVector0.size());
      assertTrue(stringVector0.equals((Object)stringVector1));
      
      String string0 = gFF3AttributeBuilder0.get(" but this VariantContext contains an END key with value ");
      assertEquals("y", string0);
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      String[] stringArray0 = new String[9];
      StringVector stringVector0 = new StringVector(stringArray0);
      assertEquals(9, stringArray0.length);
      assertNotNull(stringVector0);
      assertEquals(9, stringVector0.capacity());
      assertEquals(9, stringVector0.size());
      assertFalse(stringVector0.isEmpty());
      assertEquals("[null, null, null, null, null, null, null, null, null]", stringVector0.toString());
      
      gFF3AttributeBuilder0.add("", stringVector0);
      assertEquals(9, stringArray0.length);
      assertEquals(9, stringVector0.capacity());
      assertEquals(9, stringVector0.size());
      assertFalse(stringVector0.isEmpty());
      assertEquals("[null, null, null, null, null, null, null, null, null]", stringVector0.toString());
      
      // Undeclared exception!
      try { 
        gFF3AttributeBuilder0.toString();
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFF3AttributeBuilder0.add((String) null, ";");
      // Undeclared exception!
      try { 
        gFF3AttributeBuilder0.toString();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFF3AttributeBuilder", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFF3AttributeBuilder0.setAggregator("=", (GFF3AttributeAggregator) null);
      gFF3AttributeBuilder0.setMapping(" but  his VariantContext contains an END key with valu? ", "=");
      StringVector stringVector0 = new StringVector();
      assertNotNull(stringVector0);
      assertEquals("[]", stringVector0.toString());
      assertTrue(stringVector0.isEmpty());
      assertEquals(0, stringVector0.size());
      assertEquals(10, stringVector0.capacity());
      
      // Undeclared exception!
      try { 
        gFF3AttributeBuilder0.add(" but  his VariantContext contains an END key with valu? ", stringVector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFF3AttributeBuilder", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      // Undeclared exception!
      try { 
        gFF3AttributeBuilder0.add("[J?bl! 0VCh-y^*%j", (String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFF3AttributeBuilder", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFF3AttributeBuilder0.setMapping(" but this VariantContext contains an END key with value ", "=");
      StringVector stringVector0 = new StringVector();
      assertNotNull(stringVector0);
      assertTrue(stringVector0.isEmpty());
      assertEquals(10, stringVector0.capacity());
      assertEquals("[]", stringVector0.toString());
      assertEquals(0, stringVector0.size());
      
      gFF3AttributeBuilder0.add(" but this VariantContext contains an END key with value ", stringVector0);
      assertTrue(stringVector0.isEmpty());
      assertEquals(10, stringVector0.capacity());
      assertEquals("[]", stringVector0.toString());
      assertEquals(0, stringVector0.size());
      
      gFF3AttributeBuilder0.add("ID", stringVector0);
      assertTrue(stringVector0.isEmpty());
      assertEquals(10, stringVector0.capacity());
      assertEquals("[]", stringVector0.toString());
      assertEquals(0, stringVector0.size());
      
      String string0 = gFF3AttributeBuilder0.toString();
      assertEquals("", string0);
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFF3AttributeBuilder0.add("Gd$", "Target");
      gFF3AttributeBuilder0.add("ID", "ID");
      String string0 = gFF3AttributeBuilder0.toString();
      assertEquals("ID=ID;gd$=Target", string0);
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      StringVector stringVector0 = new StringVector("'D!K?edCX");
      assertNotNull(stringVector0);
      assertEquals(1, stringVector0.size());
      assertEquals(10, stringVector0.capacity());
      assertEquals("['D!K?edCX]", stringVector0.toString());
      assertFalse(stringVector0.isEmpty());
      
      gFF3AttributeBuilder0.add("Ontology_term", stringVector0);
      assertEquals(1, stringVector0.size());
      assertEquals(10, stringVector0.capacity());
      assertEquals("['D!K?edCX]", stringVector0.toString());
      assertFalse(stringVector0.isEmpty());
      
      gFF3AttributeBuilder0.add("YI", stringVector0);
      assertEquals(1, stringVector0.size());
      assertEquals(10, stringVector0.capacity());
      assertEquals("['D!K?edCX]", stringVector0.toString());
      assertFalse(stringVector0.isEmpty());
      
      String string0 = gFF3AttributeBuilder0.toString();
      assertEquals("Ontology_term='D!K?edCX;yI='D!K?edCX", string0);
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      StringVector stringVector0 = new StringVector();
      assertNotNull(stringVector0);
      assertTrue(stringVector0.isEmpty());
      assertEquals("[]", stringVector0.toString());
      assertEquals(10, stringVector0.capacity());
      assertEquals(0, stringVector0.size());
      
      gFF3AttributeBuilder0.add(" but this VariantContext contains an END key with value ", stringVector0);
      assertTrue(stringVector0.isEmpty());
      assertEquals("[]", stringVector0.toString());
      assertEquals(10, stringVector0.capacity());
      assertEquals(0, stringVector0.size());
      
      String string0 = gFF3AttributeBuilder0.get(" but this VariantContext contains an END key with value ");
      assertEquals("", string0);
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFF3AttributeBuilder0.setMapping(" but this VariantContext contains an END key with value ", "=");
      try { 
        gFF3AttributeBuilder0.get(" but this VariantContext contains an END key with value ");
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // empty attribute value for =
         //
         verifyException("uk.ac.sanger.artemis.io.GFF3AttributeBuilder", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      StringVector stringVector0 = new StringVector();
      stringVector0.add("MD5");
      gFF3AttributeBuilder0.add("e(b=T", stringVector0);
      String string0 = gFF3AttributeBuilder0.toString();
      assertEquals("e(b=T=MD5", string0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      String[] stringArray0 = new String[1];
      stringArray0[0] = "";
      StringVector stringVector0 = new StringVector(stringArray0);
      gFF3AttributeBuilder0.add("", stringVector0);
      assertEquals(1, stringVector0.capacity());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      gFF3AttributeBuilder0.add("", (StringVector) null);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      String[] stringArray0 = new String[2];
      gFF3AttributeBuilder0.setMapping("", "");
      StringVector stringVector0 = new StringVector(stringArray0);
      gFF3AttributeBuilder0.setClone("", "");
      gFF3AttributeBuilder0.add("", stringVector0);
      assertEquals("[null, null]", stringVector0.toString());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      gFF3AttributeBuilder0.unignore(";");
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      gFF3AttributeBuilder0.setGlue("", "");
      StringVector stringVector0 = StringVector.getStrings("", "");
      gFF3AttributeBuilder0.add("", "BUG: Cannot add a no call allele to a variant context ");
      gFF3AttributeBuilder0.add("", stringVector0);
      assertEquals("[]", stringVector0.toString());
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      gFF3AttributeBuilder0.unsetGlue("/F@(J_I22Yi|FFCx");
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      gFF3AttributeBuilder0.ignore("ID");
      gFF3AttributeBuilder0.add("ID", "ID");
      String string0 = gFF3AttributeBuilder0.toString();
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      gFF3AttributeBuilder0.unsetClone("");
      gFF3AttributeBuilder0.setMapping("b_mdZDF#n0ZuB_V", "");
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      GFF3AttributeAggregator gFF3AttributeAggregator0 = mock(GFF3AttributeAggregator.class, new ViolatedAssumptionAnswer());
      gFF3AttributeBuilder0.unsetAggregator("ID", gFF3AttributeAggregator0);
  }
}
