/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 21:35:36 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.Range;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class Range_ESTest extends Range_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Range range0 = new Range(0);
      boolean boolean0 = range0.fuzzyOverlaps(range0, 0);
      assertEquals(0, range0.getEnd());
      assertEquals(0, range0.getStart());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Range range0 = new Range((-11));
      Range range1 = range0.change((-11), 29);
      boolean boolean0 = range1.fuzzyOverlaps(range1, (-1));
      assertEquals((-11), range0.getStart());
      assertEquals((-11), range0.getEnd());
      assertTrue(boolean0);
      assertEquals(41, range1.getCount());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Range range0 = new Range((-1), 0);
      Range range1 = range0.change(0, 0);
      boolean boolean0 = range1.fuzzyOverlaps(range0, (-1));
      assertFalse(boolean0);
      assertEquals(2, range0.getCount());
      assertEquals(1, range1.getCount());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Range range0 = new Range(0, 0);
      Range range1 = new Range(0, 18);
      boolean boolean0 = range1.equals(range0);
      assertEquals(18, range1.getEnd());
      assertEquals(19, range1.getCount());
      assertFalse(boolean0);
      assertEquals(0, range1.getStart());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Range range0 = new Range((-688), (-688));
      Range range1 = new Range(0, 0);
      boolean boolean0 = range0.equals(range1);
      assertFalse(boolean0);
      assertEquals(1, range1.getCount());
      assertEquals(0, range1.getStart());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Range range0 = new Range((-2459), 230);
      Range range1 = new Range(0);
      boolean boolean0 = range0.contains(range1);
      assertTrue(boolean0);
      assertEquals(2690, range0.getCount());
      assertEquals(0, range1.getEnd());
      assertEquals(0, range1.getStart());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Range range0 = new Range(767);
      int int0 = range0.getStart();
      assertEquals(767, int0);
      assertEquals(767, range0.getEnd());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Range range0 = new Range((-1), 2773);
      int int0 = range0.getEnd();
      assertEquals(2773, int0);
      assertEquals(2775, range0.getCount());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Range range0 = new Range((-963));
      int int0 = range0.getEnd();
      assertEquals((-963), int0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Range range0 = new Range(0);
      Range range1 = range0.copy();
      assertEquals(1, range1.getCount());
      assertEquals(0, range1.getEnd());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Range range0 = new Range((-1), 0);
      Range range1 = range0.copy();
      assertEquals(2, range1.getCount());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Range range0 = new Range((-1), 0);
      Range range1 = range0.truncate(range0);
      assertNotNull(range1);
      
      Range range2 = range1.copy();
      assertEquals(2, range2.getEnd());
      assertEquals(0, range0.getEnd());
      assertEquals((-1), range0.getStart());
      assertEquals(2, range2.getCount());
      assertEquals(2, range0.getCount());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Range range0 = new Range((-1), 0);
      Range range1 = range0.change(0, 0);
      int int0 = range1.getStart();
      assertEquals(0, int0);
      assertEquals(1, range1.getCount());
      assertEquals(2, range0.getCount());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Range range0 = new Range(370);
      Range range1 = range0.change(1, 607);
      assertEquals(370, range0.getEnd());
      assertEquals(607, range1.getCount());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Range range0 = new Range((-1126), 0);
      // Undeclared exception!
      try { 
        range0.truncate((Range) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.Range", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Range range0 = new Range((-1546), 0);
      // Undeclared exception!
      try { 
        range0.overlaps((Range) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.Range", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      Range range0 = new Range(0);
      // Undeclared exception!
      try { 
        range0.fuzzyOverlaps((Range) null, 575);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.Range", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Range range0 = new Range((-1916));
      // Undeclared exception!
      try { 
        range0.contains((Range) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.Range", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Range range0 = new Range(0, 0);
      Range range1 = range0.truncate(range0);
      boolean boolean0 = range1.overlaps(range0);
      assertFalse(boolean0);
      assertEquals(1, range1.getCount());
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      Range range0 = new Range((-2866));
      boolean boolean0 = range0.overlaps(range0);
      assertTrue(boolean0);
      assertEquals((-2866), range0.getStart());
      assertEquals((-2866), range0.getEnd());
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Range range0 = null;
      try {
        range0 = new Range(1, 0);
        fail("Expecting exception: Exception");
      
      } catch(Throwable e) {
         //
         // start: 1 > end: 0
         //
         verifyException("uk.ac.sanger.artemis.io.Range", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      Range range0 = new Range((-1), 0);
      int int0 = range0.getStart();
      assertEquals(2, range0.getCount());
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      Range range0 = new Range((-1), 0);
      int int0 = range0.getEnd();
      assertEquals(2, range0.getCount());
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      Range range0 = new Range((-1), 0);
      Range range1 = range0.change((-937), (-1));
      boolean boolean0 = range1.fuzzyOverlaps(range0, 0);
      assertEquals(937, range1.getCount());
      assertEquals((-1), range1.getEnd());
      assertTrue(boolean0);
      assertEquals((-937), range1.getStart());
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      Range range0 = new Range((-1916));
      boolean boolean0 = range0.fuzzyOverlaps(range0, (-1916));
      assertEquals((-1916), range0.getStart());
      assertEquals((-1916), range0.getEnd());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      Range range0 = new Range((-1), 0);
      Range range1 = new Range(2838);
      boolean boolean0 = range1.fuzzyOverlaps(range0, (-1));
      assertEquals(2, range0.getCount());
      assertEquals(2838, range1.getEnd());
      assertFalse(boolean0);
      assertEquals(2838, range1.getStart());
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      Range range0 = new Range((-1), 0);
      Range range1 = range0.change((-937), (-1));
      boolean boolean0 = range1.overlaps(range0);
      assertEquals((-1), range1.getEnd());
      assertEquals((-937), range1.getStart());
      assertEquals(937, range1.getCount());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      Range range0 = new Range((-390));
      Range range1 = range0.change((-1), 1474);
      Range range2 = new Range((-390));
      boolean boolean0 = range2.overlaps(range1);
      assertFalse(boolean0);
      assertEquals((-390), range2.getEnd());
      assertEquals(1476, range1.getCount());
      assertEquals((-390), range2.getStart());
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      Range range0 = new Range(0);
      Range range1 = new Range((-1));
      boolean boolean0 = range0.equals(range1);
      assertFalse(boolean0);
      assertEquals((-1), range1.getEnd());
      assertEquals((-1), range1.getStart());
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      Range range0 = new Range((-2866));
      boolean boolean0 = range0.equals(range0);
      assertEquals((-2866), range0.getEnd());
      assertTrue(boolean0);
      assertEquals((-2866), range0.getStart());
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      Range range0 = new Range(0, 0);
      boolean boolean0 = range0.equals((Range) null);
      assertEquals(1, range0.getCount());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      Range range0 = new Range(0, 0);
      Range range1 = new Range(0, 2089);
      Range range2 = range0.truncate(range1);
      assertNotNull(range2);
      
      Range range3 = range1.truncate(range2);
      assertEquals(1, range3.getCount());
      assertEquals(1, range2.getStart());
      assertEquals(2090, range1.getCount());
      assertNotNull(range3);
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      Range range0 = new Range((-3748));
      Range range1 = range0.truncate(range0);
      range1.truncate(range0);
      assertEquals((-3748), range0.getStart());
      assertEquals((-3748), range0.getEnd());
      assertEquals(1, range1.getCount());
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      Range range0 = new Range((-2866));
      Range range1 = range0.truncate(range0);
      assertNotNull(range1);
      
      range0.truncate(range1);
      assertEquals((-2866), range0.getStart());
      assertEquals(1, range1.getCount());
      assertEquals((-2866), range0.getEnd());
      assertEquals(1, range0.getCount());
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      Range range0 = new Range((-2866));
      Range range1 = range0.change((-2866), 975);
      boolean boolean0 = range0.contains(range1);
      assertEquals((-2866), range0.getStart());
      assertFalse(boolean0);
      assertEquals((-2866), range0.getEnd());
      assertEquals(3842, range1.getCount());
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      Range range0 = new Range((-1), 0);
      Range range1 = range0.change((-937), (-1));
      boolean boolean0 = range0.contains(range1);
      assertEquals(937, range1.getCount());
      assertEquals((-937), range1.getStart());
      assertEquals((-1), range1.getEnd());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      Range range0 = new Range((-2866));
      boolean boolean0 = range0.contains(range0);
      assertEquals((-2866), range0.getEnd());
      assertTrue(boolean0);
      assertEquals((-2866), range0.getStart());
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      Range range0 = new Range((-1), 0);
      Range range1 = new Range(2838);
      boolean boolean0 = range1.contains(range0);
      assertEquals(2, range0.getCount());
      assertEquals(2838, range1.getEnd());
      assertFalse(boolean0);
      assertEquals(2838, range1.getStart());
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      Range range0 = new Range((-2866));
      Range range1 = range0.change((-2866), 975);
      String string0 = range1.toString();
      assertEquals("-2866..975", string0);
      assertEquals((-2866), range0.getEnd());
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      Range range0 = new Range((-2866));
      String string0 = range0.toString();
      assertEquals("-2866", string0);
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      Range range0 = new Range((-2866));
      try { 
        range0.change((-1274), (-1383));
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // start: -1274 > end: -1383
         //
         verifyException("uk.ac.sanger.artemis.io.Range", e);
      }
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      Range range0 = new Range((-1916));
      int int0 = range0.getCount();
      assertEquals(1, int0);
      assertEquals((-1916), range0.getStart());
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      Range range0 = new Range((-1916));
      Range range1 = range0.change((-1916), (-886));
      boolean boolean0 = range0.equals(range1);
      assertFalse(boolean0);
      assertEquals((-1916), range0.getEnd());
      assertEquals(1031, range1.getCount());
      assertEquals((-1916), range0.getStart());
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      Range range0 = new Range((-1916));
      Range range1 = range0.copy();
      assertEquals(1, range1.getCount());
      assertEquals((-1916), range0.getStart());
      assertEquals((-1916), range0.getEnd());
  }
}
