/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.cojen.classfile.Attribute;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.FixedLocation;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.LocationRange;
import org.cojen.classfile.LocationRangeImpl;
import org.cojen.classfile.TypeDesc;
import org.cojen.classfile.constant.ConstantUTFInfo;

public class LocalVariableTableAttr
extends Attribute {
    private List<Entry> mEntries = new ArrayList<Entry>(10);
    private List<Entry> mCleanEntries;
    private int mRangeCount;

    public LocalVariableTableAttr(ConstantPool cp) {
        super(cp, "LocalVariableTable");
    }

    public LocalVariableTableAttr(ConstantPool cp, String name) {
        super(cp, name);
    }

    public LocalVariableTableAttr(ConstantPool cp, String name, int length, DataInput din) throws IOException {
        super(cp, name);
        int size = din.readUnsignedShort();
        for (int i = 0; i < size; ++i) {
            int start_pc = din.readUnsignedShort();
            int end_pc = start_pc + din.readUnsignedShort() + 1;
            int name_index = din.readUnsignedShort();
            int descriptor_index = din.readUnsignedShort();
            final int index = din.readUnsignedShort();
            final ConstantUTFInfo varName = (ConstantUTFInfo)cp.getConstant(name_index);
            final ConstantUTFInfo varDesc = (ConstantUTFInfo)cp.getConstant(descriptor_index);
            if (varDesc == null) continue;
            FixedLocation startLocation = new FixedLocation(start_pc);
            FixedLocation endLocation = new FixedLocation(end_pc);
            final Set<LocationRangeImpl> ranges = Collections.singleton(new LocationRangeImpl(startLocation, endLocation));
            LocalVariable localVar = new LocalVariable(){
                private String mName;
                private TypeDesc mType;
                {
                    this.mName = varName == null ? null : varName.getValue();
                    this.mType = TypeDesc.forDescriptor(varDesc.getValue());
                }

                @Override
                public String getName() {
                    return this.mName;
                }

                @Override
                public void setName(String name) {
                    this.mName = name;
                }

                @Override
                public TypeDesc getType() {
                    return this.mType;
                }

                @Override
                public boolean isDoubleWord() {
                    return this.mType.isDoubleWord();
                }

                @Override
                public int getNumber() {
                    return index;
                }

                @Override
                public Set<LocationRange> getLocationRangeSet() {
                    return ranges;
                }
            };
            this.mEntries.add(new Entry(localVar, varName, varDesc));
        }
    }

    public LocalVariable getLocalVariable(Location useLocation, int number) {
        return this.getLocalVariable(useLocation.getLocation(), number);
    }

    public LocalVariable getLocalVariable(int useLocation, int number) {
        for (Entry entry : this.mEntries) {
            LocalVariable var = entry.mLocalVar;
            if (var.getNumber() != number) continue;
            for (LocationRange range : var.getLocationRangeSet()) {
                int start = range.getStartLocation().getLocation();
                int end = range.getEndLocation().getLocation();
                if (start < 0 || end < 0 || start > useLocation || useLocation >= end) continue;
                return var;
            }
        }
        return null;
    }

    public void addEntry(LocalVariable localVar) {
        String varName = localVar.getName();
        if (varName == null) {
            int num = localVar.getNumber();
            varName = num < 0 ? "_" : "v" + num + '$';
        }
        ConstantUTFInfo name = this.getConstantPool().addConstantUTF(varName);
        ConstantUTFInfo descriptor = this.getConstantPool().addConstantUTF(localVar.getType().getDescriptor());
        this.mEntries.add(new Entry(localVar, name, descriptor));
        this.mCleanEntries = null;
    }

    public int getLength() {
        this.clean();
        return 2 + 10 * this.mRangeCount;
    }

    public void writeDataTo(DataOutput dout) throws IOException {
        dout.writeShort(this.mRangeCount);
        int size = this.mCleanEntries.size();
        for (int i = 0; i < size; ++i) {
            Entry entry = this.mCleanEntries.get(i);
            LocalVariable localVar = entry.mLocalVar;
            Set<LocationRange> ranges = localVar.getLocationRangeSet();
            if (ranges == null) continue;
            int name_index = entry.mName.getIndex();
            int descriptor_index = entry.mDescriptor.getIndex();
            int index = localVar.getNumber();
            this.check("local variable table entry name index", name_index);
            this.check("local variable table entry descriptor index", descriptor_index);
            this.check("local variable table entry index", index);
            for (LocationRange range : ranges) {
                Object startLocation = range.getStartLocation();
                Object endLocation = range.getEndLocation();
                int start_pc = startLocation.getLocation();
                int length = endLocation.getLocation() - start_pc - 1;
                this.check("local variable table entry start PC", start_pc);
                dout.writeShort(start_pc);
                dout.writeShort(length);
                dout.writeShort(name_index);
                dout.writeShort(descriptor_index);
                dout.writeShort(index);
            }
        }
    }

    private void check(String type, int addr) throws IllegalStateException {
        if (addr < 0 || addr > 65535) {
            throw new IllegalStateException("Value for " + type + " out of " + "valid range: " + addr);
        }
    }

    private void clean() {
        if (this.mCleanEntries != null) {
            return;
        }
        int size = this.mEntries.size();
        this.mCleanEntries = new ArrayList<Entry>(size);
        this.mRangeCount = 0;
        block0: for (int i = 0; i < size; ++i) {
            Entry entry = this.mEntries.get(i);
            LocalVariable localVar = entry.mLocalVar;
            Set<LocationRange> ranges = localVar.getLocationRangeSet();
            if (ranges == null || ranges.size() == 0) continue;
            for (LocationRange range : ranges) {
                Object startLocation = range.getStartLocation();
                Object endLocation = range.getEndLocation();
                if (startLocation == null || endLocation == null) continue block0;
                int start_pc = startLocation.getLocation();
                int length = endLocation.getLocation() - start_pc - 1;
                if (length >= 0) continue;
                continue block0;
            }
            this.mCleanEntries.add(entry);
            this.mRangeCount += entry.getRangeCount();
        }
    }

    private static class Entry {
        public LocalVariable mLocalVar;
        public ConstantUTFInfo mName;
        public ConstantUTFInfo mDescriptor;

        public Entry(LocalVariable localVar, ConstantUTFInfo name, ConstantUTFInfo descriptor) {
            this.mLocalVar = localVar;
            this.mName = name;
            this.mDescriptor = descriptor;
        }

        public int getRangeCount() {
            return this.mLocalVar.getLocationRangeSet().size();
        }
    }
}

