/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import org.cojen.util.Cache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RefCache<K, V>
implements Cache<K, V> {
    static final float LOAD_FACTOR = 0.75f;
    int mSize;
    int mThreshold;

    RefCache(int capacity) {
        this.mThreshold = (int)((float)capacity * 0.75f);
    }

    @Override
    public final synchronized int size() {
        return this.mSize;
    }

    @Override
    public final synchronized boolean isEmpty() {
        return this.mSize == 0;
    }

    @Override
    public final synchronized V putIfAbsent(K key, V value) {
        Object existing = this.get(key);
        return existing == null ? this.put(key, value) : existing;
    }

    @Override
    public final synchronized boolean remove(K key, V value) {
        Object existing = this.get(key);
        if (existing != null && existing.equals(value)) {
            this.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public final synchronized boolean replace(K key, V oldValue, V newValue) {
        Object existing = this.get(key);
        if (existing != null && existing.equals(oldValue)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    @Override
    public final synchronized V replace(K key, V value) {
        return this.get(key) == null ? null : (V)this.put(key, value);
    }

    protected int keyHashCode(K key) {
        return key.hashCode();
    }

    protected boolean keyEquals(K a, K b) {
        return a.equals(b);
    }
}

